/*
 * Decompiled with CFR 0.152.
 */
package org.readutf.buildstore.api.simple;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Logger;
import org.jspecify.annotations.NonNull;
import org.readutf.buildstore.api.Build;
import org.readutf.buildstore.api.BuildMeta;
import org.readutf.buildstore.api.BuildStore;
import org.readutf.buildstore.api.exception.BuildException;

public class SimpleBuildStore
implements BuildStore {
    private final Logger logger;
    private final @NonNull File buildsDirectory;
    private final @NonNull File metaTrackerFile;
    private final @NonNull Map<String, BuildMeta> builds;

    public SimpleBuildStore(@NonNull Logger logger, @NonNull Gson gson, @NonNull File buildsDirectory) throws IOException, JsonParseException {
        this.logger = logger;
        this.buildsDirectory = buildsDirectory;
        if (!buildsDirectory.exists()) {
            buildsDirectory.mkdirs();
        }
        this.metaTrackerFile = new File(buildsDirectory, "builds.json");
        if (!this.metaTrackerFile.exists() && this.metaTrackerFile.createNewFile()) {
            logger.info("Created builds.json file");
            Files.writeString(this.metaTrackerFile.toPath(), (CharSequence)"[]", new OpenOption[0]);
        }
        this.builds = (Map)gson.fromJson(new JsonReader((Reader)new FileReader(this.metaTrackerFile)), (TypeToken)new TypeToken<Map<String, BuildMeta>>(this){});
    }

    @Override
    public boolean exists(String name) {
        return this.getBuilds().stream().anyMatch(meta -> meta.name().equalsIgnoreCase(name));
    }

    @Override
    public Collection<BuildMeta> getBuilds() {
        return this.builds.values();
    }

    @Override
    public Build loadBuild(String buildName, Integer version) throws BuildException {
        File buildFile = this.getBuildFile(buildName, version);
        try {
            byte[] schematicData = Files.readAllBytes(buildFile.toPath());
            BuildMeta metaData = this.builds.get(buildName + ":" + version);
            if (metaData == null) {
                throw new BuildException("Build %s v%d metadata could not be read".formatted(buildName, version));
            }
            return new Build(metaData, schematicData);
        }
        catch (IOException e) {
            throw new BuildException("Could not find a build with that name");
        }
    }

    @Override
    public void saveBuild(Build build) throws BuildException {
        if (this.builds.containsKey(build.buildMeta().getId())) {
            throw new BuildException("'%s' v%s already exists.".formatted(build.buildMeta().name(), build.buildMeta().version()));
        }
        this.builds.put(build.buildMeta().getId(), build.buildMeta());
        File buildFile = this.getBuildFile(build.buildMeta().name(), build.buildMeta().version());
        try {
            Files.write(buildFile.toPath(), build.spongeSchematicData(), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new BuildException("Failed to save build %s".formatted(build.buildMeta().name()));
        }
        this.saveBuildTree();
    }

    public void saveBuildTree() throws BuildException {
        try {
            Files.writeString(this.metaTrackerFile.toPath(), (CharSequence)new Gson().toJson(this.builds), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new BuildException("Failed to save build tree");
        }
    }

    public File getBuildFile(String name, int version) throws BuildException {
        File directory = this.getBuildDirectory(name, version);
        return new File(directory, "%s-v%d.schem".formatted(name, version));
    }

    private File getBuildDirectory(String name, int version) throws BuildException {
        File directory = new File(this.buildsDirectory, name);
        if (!directory.exists()) {
            if (directory.mkdirs()) {
                this.logger.info("Created directory for build %s".formatted(name));
            } else {
                throw new BuildException("Failed to create directory for build %s".formatted(name));
            }
        }
        return directory;
    }
}

