/*
 * Decompiled with CFR 0.152.
 */
package org.readutf.hermes;

import com.github.michaelbull.result.Result;
import com.github.michaelbull.result.ResultKt;
import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.readutf.hermes.Packet;
import org.readutf.hermes.PacketManager;
import org.readutf.hermes.channel.HermesChannel;
import org.readutf.hermes.exceptions.ExceptionManager;
import org.readutf.hermes.listeners.Listener;
import org.readutf.hermes.listeners.ListenerManager;
import org.readutf.hermes.listeners.TypedListener;
import org.readutf.hermes.platform.PacketPlatform;
import org.readutf.hermes.response.ResponseListener;
import org.readutf.hermes.response.ResponsePacket;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 6*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u00016B\u0017\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ!\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020 0\u001e2\u0006\u0010!\u001a\u00020\"\u00a2\u0006\u0004\b#\u0010$J+\u0010\u001d\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u00020%0\u001e0\u0019\"\u0006\b\u0001\u0010\u0001\u0018\u00012\u0006\u0010!\u001a\u00020\"H\u0086\bJ\f\u0010&\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000J\u001a\u0010'\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\f\u0010(\u001a\b\u0012\u0004\u0012\u00020 0)J2\u0010'\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000\"\b\b\u0001\u0010**\u00020 2\f\u0010+\u001a\b\u0012\u0004\u0012\u0002H*0,2\f\u0010(\u001a\b\u0012\u0004\u0012\u0002H*0)J\u000e\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020 J \u00100\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u001f01J\u0018\u00102\u001a\u00020\u001f2\u0006\u00103\u001a\u0002042\u0006\u0010!\u001a\u00020\"H\u0002J\u0006\u00105\u001a\u00020\u001fR\u0013\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00190\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u00067"}, d2={"Lorg/readutf/hermes/PacketManager;", "T", "Lorg/readutf/hermes/platform/PacketPlatform;", "", "packetPlatform", "executorService", "Ljava/util/concurrent/ExecutorService;", "<init>", "(Lorg/readutf/hermes/platform/PacketPlatform;Ljava/util/concurrent/ExecutorService;)V", "getPacketPlatform", "()Lorg/readutf/hermes/platform/PacketPlatform;", "Lorg/readutf/hermes/platform/PacketPlatform;", "getExecutorService", "()Ljava/util/concurrent/ExecutorService;", "logger", "Lio/github/oshai/kotlinlogging/KLogger;", "getLogger", "()Lio/github/oshai/kotlinlogging/KLogger;", "listenerManager", "Lorg/readutf/hermes/listeners/ListenerManager;", "exceptionManager", "Lorg/readutf/hermes/exceptions/ExceptionManager;", "responseFutures", "", "", "Ljava/util/concurrent/CompletableFuture;", "Lorg/readutf/hermes/response/ResponsePacket;", "getResponseFutures", "()Ljava/util/Map;", "sendPacket", "Lcom/github/michaelbull/result/Result;", "", "", "packet", "Lorg/readutf/hermes/Packet;", "sendPacket-Zyo9ksc", "(Lorg/readutf/hermes/Packet;)Ljava/lang/Object;", "", "start", "exception", "consumer", "Ljava/util/function/Consumer;", "U", "clazz", "Ljava/lang/Class;", "handleException", "", "throwable", "editListeners", "Lkotlin/Function1;", "onPacketReceived", "hermesChannel", "Lorg/readutf/hermes/channel/HermesChannel;", "stop", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nPacketManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PacketManager.kt\norg/readutf/hermes/PacketManager\n+ 2 Factory.kt\ncom/github/michaelbull/result/FactoryKt\n+ 3 ListenerManager.kt\norg/readutf/hermes/listeners/ListenerManager\n*L\n1#1,105:1\n29#2,8:106\n71#3,10:114\n*S KotlinDebug\n*F\n+ 1 PacketManager.kt\norg/readutf/hermes/PacketManager\n*L\n37#1:106,8\n33#1:114,10\n*E\n"})
public final class PacketManager<T extends PacketPlatform> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final T packetPlatform;
    @NotNull
    private final ExecutorService executorService;
    @NotNull
    private final KLogger logger;
    @NotNull
    private final ListenerManager listenerManager;
    @NotNull
    private final ExceptionManager exceptionManager;
    @NotNull
    private final Map<Integer, CompletableFuture<ResponsePacket>> responseFutures;

    public PacketManager(@NotNull T packetPlatform, @NotNull ExecutorService executorService) {
        Intrinsics.checkNotNullParameter(packetPlatform, (String)"packetPlatform");
        Intrinsics.checkNotNullParameter((Object)executorService, (String)"executorService");
        this.packetPlatform = packetPlatform;
        this.executorService = executorService;
        this.logger = KotlinLogging.INSTANCE.logger(PacketManager::logger$lambda$0);
        this.listenerManager = new ListenerManager(this.executorService);
        this.exceptionManager = new ExceptionManager();
        this.responseFutures = new LinkedHashMap();
        this.packetPlatform.setupPacketListener((arg_0, arg_1) -> PacketManager._init_$lambda$1(this, arg_0, arg_1));
        this.packetPlatform.init(this);
        this.editListeners((Function1<ListenerManager, Unit>)((Function1)arg_0 -> PacketManager._init_$lambda$2(this, arg_0)));
    }

    @NotNull
    public final T getPacketPlatform() {
        return this.packetPlatform;
    }

    @NotNull
    public final ExecutorService getExecutorService() {
        return this.executorService;
    }

    @NotNull
    public final KLogger getLogger() {
        return this.logger;
    }

    @NotNull
    public final Map<Integer, CompletableFuture<ResponsePacket>> getResponseFutures() {
        return this.responseFutures;
    }

    @NotNull
    public final Object sendPacket-Zyo9ksc(@NotNull Packet packet) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        PacketManager $this$runCatching$iv = this;
        boolean $i$f$runCatching = false;
        try {
            PacketManager $this$sendPacket_Zyo9ksc_u24lambda_u243 = $this$runCatching$iv;
            boolean bl = false;
            $this$sendPacket_Zyo9ksc_u24lambda_u243.packetPlatform.sendPacket(packet);
            object = ResultKt.Ok((Object)Unit.INSTANCE);
        }
        catch (Throwable e$iv) {
            object = ResultKt.Err((Object)e$iv);
        }
        return object;
    }

    public final /* synthetic */ <T> CompletableFuture<Result<T, String>> sendPacket(Packet packet) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        boolean $i$f$sendPacket = false;
        CompletableFuture future = new CompletableFuture();
        this.getResponseFutures().put(packet.getPacketId(), future);
        this.getPacketPlatform().sendPacket(packet);
        Intrinsics.needClassReification();
        Function1 function1 = new Function1<ResponsePacket, Result<? extends T, ? extends String>>(this, packet){
            final /* synthetic */ PacketManager<T> this$0;
            final /* synthetic */ Packet $packet;
            {
                this.this$0 = $receiver;
                this.$packet = $packet;
            }

            public final Result<? extends T, ? extends String> invoke-VAwEx0E(ResponsePacket responsePacket) {
                this.this$0.getLogger().debug((Function0)new Function0<Object>(this.$packet){
                    final /* synthetic */ Packet $packet;
                    {
                        this.$packet = $packet;
                    }

                    public final Object invoke() {
                        return "Received response back for packet " + this.$packet.getPacketId();
                    }
                });
                Object object = responsePacket.getResponse();
                Intrinsics.reifiedOperationMarker((int)3, (String)"T");
                if (object instanceof Object) {
                    KLogger kLogger = this.this$0.getLogger();
                    Intrinsics.needClassReification();
                    kLogger.debug((Function0)new Function0<Object>(responsePacket){
                        final /* synthetic */ ResponsePacket $responsePacket;
                        {
                            this.$responsePacket = $responsePacket;
                        }

                        public final Object invoke() {
                            Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                            return "Received back " + this.$responsePacket + " as " + Object.class.getSimpleName();
                        }
                    });
                    if (responsePacket.getSuccess()) {
                        Object object2 = responsePacket.getResponse();
                        Intrinsics.reifiedOperationMarker((int)1, (String)"T");
                        return Result.box-impl((Object)ResultKt.Ok((Object)object2));
                    }
                    return Result.box-impl((Object)ResultKt.Err((Object)responsePacket.getError()));
                }
                KLogger kLogger = this.this$0.getLogger();
                Intrinsics.needClassReification();
                kLogger.warn((Function0)sendPacket.3.INSTANCE);
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                throw new IllegalStateException("Response packet was not of type " + Object.class.getSimpleName());
            }
        };
        CompletionStage completionStage = future.thenApply(new Function(function1){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ Object apply(Object p0) {
                return this.function.invoke(p0);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenApply(...)");
        return completionStage;
    }

    @NotNull
    public final PacketManager<T> start() {
        this.packetPlatform.start();
        return this;
    }

    @NotNull
    public final PacketManager<T> exception(@NotNull Consumer<Throwable> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        this.exceptionManager.setGlobalExceptionHandler(consumer);
        return this;
    }

    @NotNull
    public final <U extends Throwable> PacketManager<T> exception(@NotNull Class<U> clazz, @NotNull Consumer<U> consumer) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        this.exceptionManager.setExceptionHandler(clazz, consumer);
        return this;
    }

    public final boolean handleException(@NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        return this.exceptionManager.handleException(throwable);
    }

    @NotNull
    public final PacketManager<T> editListeners(@NotNull Function1<? super ListenerManager, Unit> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        consumer.invoke((Object)this.listenerManager);
        return this;
    }

    private final void onPacketReceived(HermesChannel hermesChannel, Packet packet) {
        this.logger.debug(() -> PacketManager.onPacketReceived$lambda$4(packet));
        this.listenerManager.handlePacket(hermesChannel, packet);
    }

    public final void stop() {
        this.packetPlatform.stop();
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$1(PacketManager this$0, HermesChannel channel, Packet packet) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        this$0.onPacketReceived(channel, packet);
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit _init_$lambda$2(PacketManager this$0, ListenerManager it) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ListenerManager listenerManager = it;
        TypedListener typedListener$iv = new ResponseListener(this$0);
        boolean $i$f$registerListener = false;
        Listener[] listenerArray = new Listener[]{new Listener(typedListener$iv){
            final /* synthetic */ TypedListener $typedListener;
            {
                this.$typedListener = $typedListener;
            }

            public Unit acceptPacket(HermesChannel hermesChannel, Packet packet) {
                Intrinsics.checkNotNullParameter((Object)hermesChannel, (String)"hermesChannel");
                Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
                return this.$typedListener.handle((Packet)((ResponsePacket)packet), hermesChannel);
            }
        }};
        this_$iv.registerListener(ResponsePacket.class, listenerArray);
        return Unit.INSTANCE;
    }

    private static final Object onPacketReceived$lambda$4(Packet $packet) {
        Intrinsics.checkNotNullParameter((Object)$packet, (String)"$packet");
        return "Received packet: " + $packet;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J+\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\b\b\u0001\u0010\u0006*\u00020\u00072\u0006\u0010\b\u001a\u0002H\u00062\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/readutf/hermes/PacketManager$Companion;", "", "<init>", "()V", "create", "Lorg/readutf/hermes/PacketManager;", "T", "Lorg/readutf/hermes/platform/PacketPlatform;", "platform", "executorService", "Ljava/util/concurrent/ExecutorService;", "(Lorg/readutf/hermes/platform/PacketPlatform;Ljava/util/concurrent/ExecutorService;)Lorg/readutf/hermes/PacketManager;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final <T extends PacketPlatform> PacketManager<T> create(@NotNull T platform, @NotNull ExecutorService executorService) {
            Intrinsics.checkNotNullParameter(platform, (String)"platform");
            Intrinsics.checkNotNullParameter((Object)executorService, (String)"executorService");
            return new PacketManager<T>(platform, executorService);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

