/*
 * Decompiled with CFR 0.152.
 */
package org.readutf.hermes.listeners;

import com.github.michaelbull.result.Result;
import com.github.michaelbull.result.ResultKt;
import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KAnnotatedElement;
import kotlin.reflect.KCallable;
import kotlin.reflect.KClass;
import kotlin.reflect.KFunction;
import kotlin.reflect.KParameter;
import kotlin.reflect.KType;
import kotlin.reflect.full.KCallables;
import kotlin.reflect.full.KClasses;
import kotlin.reflect.jvm.KTypesJvm;
import org.jetbrains.annotations.NotNull;
import org.readutf.hermes.Packet;
import org.readutf.hermes.channel.HermesChannel;
import org.readutf.hermes.listeners.Listener;
import org.readutf.hermes.listeners.TypedListener;
import org.readutf.hermes.listeners.annotation.PacketHandler;
import org.readutf.hermes.response.ResponsePacket;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\rJ/\u0010\u0015\u001a\u00020\u00112\u000e\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\f2\u0012\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u0018\"\u00020\u000f\u00a2\u0006\u0002\u0010\u0019JA\u0010\u0015\u001a\u00020\u0011\"\n\b\u0000\u0010\u001a\u0018\u0001*\u00020\r\"\n\b\u0001\u0010\u001b\u0018\u0001*\u00020\u0013\"\u0004\b\u0002\u0010\u001c2\u0018\u0010\u001d\u001a\u0014\u0012\u0004\u0012\u0002H\u001a\u0012\u0004\u0012\u0002H\u001b\u0012\u0004\u0012\u0002H\u001c0\u001eH\u0086\bJ.\u0010\u0015\u001a\u00020\u0011\"\n\b\u0000\u0010\u001a\u0018\u0001*\u00020\r2\u0014\b\u0004\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u0002H\u001a\u0012\u0004\u0012\u00020\u00110\u001fH\u0086\b\u00f8\u0001\u0000J\u000e\u0010 \u001a\u00020\u00112\u0006\u0010!\u001a\u00020\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\n\u001a\u001c\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\r0\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\""}, d2={"Lorg/readutf/hermes/listeners/ListenerManager;", "", "executorService", "Ljava/util/concurrent/ExecutorService;", "<init>", "(Ljava/util/concurrent/ExecutorService;)V", "getExecutorService", "()Ljava/util/concurrent/ExecutorService;", "logger", "Lio/github/oshai/kotlinlogging/KLogger;", "listeners", "", "Ljava/lang/Class;", "Lorg/readutf/hermes/Packet;", "", "Lorg/readutf/hermes/listeners/Listener;", "handlePacket", "", "hermesChannel", "Lorg/readutf/hermes/channel/HermesChannel;", "packet", "registerListener", "clazz", "listener", "", "(Ljava/lang/Class;[Lorg/readutf/hermes/listeners/Listener;)V", "T", "U", "V", "typedListener", "Lorg/readutf/hermes/listeners/TypedListener;", "Lkotlin/Function1;", "registerAll", "scannedObject", "core"})
@SourceDebugExtension(value={"SMAP\nListenerManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ListenerManager.kt\norg/readutf/hermes/listeners/ListenerManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 KAnnotatedElements.kt\nkotlin/reflect/full/KAnnotatedElements\n+ 4 Factory.kt\ncom/github/michaelbull/result/FactoryKt\n*L\n1#1,182:1\n1863#2:183\n295#2,2:185\n360#2,7:187\n360#2,7:194\n1864#2:201\n1863#2:202\n1863#2:203\n1864#2:212\n1864#2:213\n20#3:184\n29#4,8:204\n*S KotlinDebug\n*F\n+ 1 ListenerManager.kt\norg/readutf/hermes/listeners/ListenerManager\n*L\n98#1:183\n99#1:185,2\n134#1:187,7\n140#1:194,7\n98#1:201\n27#1:202\n29#1:203\n29#1:212\n27#1:213\n99#1:184\n31#1:204,8\n*E\n"})
public final class ListenerManager {
    @NotNull
    private final ExecutorService executorService;
    @NotNull
    private final KLogger logger;
    @NotNull
    private final Map<Class<? extends Packet>, List<Listener>> listeners;

    public ListenerManager(@NotNull ExecutorService executorService) {
        Intrinsics.checkNotNullParameter((Object)executorService, (String)"executorService");
        this.executorService = executorService;
        this.logger = KotlinLogging.INSTANCE.logger(ListenerManager::logger$lambda$0);
        this.listeners = new LinkedHashMap();
    }

    @NotNull
    public final ExecutorService getExecutorService() {
        return this.executorService;
    }

    public final void handlePacket(@NotNull HermesChannel hermesChannel, @NotNull Packet packet) {
        Intrinsics.checkNotNullParameter((Object)hermesChannel, (String)"hermesChannel");
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        this.executorService.submit(() -> ListenerManager.handlePacket$lambda$5(this, packet, hermesChannel));
    }

    public final void registerListener(@NotNull Class<? extends Packet> clazz, Listener ... listener2) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        List<Listener> currentListeners = this.listeners.getOrDefault(clazz, new ArrayList());
        CollectionsKt.addAll((Collection)currentListeners, (Object[])listener2);
        this.listeners.put(clazz, currentListeners);
    }

    public final /* synthetic */ <T extends Packet, U extends HermesChannel, V> void registerListener(TypedListener<T, U, V> typedListener) {
        Intrinsics.checkNotNullParameter(typedListener, (String)"typedListener");
        boolean $i$f$registerListener = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        Listener[] listenerArray = new Listener[1];
        Intrinsics.needClassReification();
        listenerArray[0] = new Listener(typedListener){
            final /* synthetic */ TypedListener<T, U, V> $typedListener;
            {
                this.$typedListener = $typedListener;
            }

            public V acceptPacket(HermesChannel hermesChannel, Packet packet) {
                Intrinsics.checkNotNullParameter((Object)hermesChannel, (String)"hermesChannel");
                Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
                Intrinsics.reifiedOperationMarker((int)1, (String)"T");
                Intrinsics.reifiedOperationMarker((int)1, (String)"U");
                return this.$typedListener.handle(packet, hermesChannel);
            }
        };
        this.registerListener(Packet.class, listenerArray);
    }

    public final /* synthetic */ <T extends Packet> void registerListener(Function1<? super T, Unit> typedListener) {
        Intrinsics.checkNotNullParameter(typedListener, (String)"typedListener");
        boolean $i$f$registerListener = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        Listener[] listenerArray = new Listener[1];
        Intrinsics.needClassReification();
        listenerArray[0] = new Listener(typedListener){
            final /* synthetic */ Function1<T, Unit> $typedListener;
            {
                this.$typedListener = $typedListener;
            }

            public void acceptPacket(HermesChannel hermesChannel, Packet packet) {
                Intrinsics.checkNotNullParameter((Object)hermesChannel, (String)"hermesChannel");
                Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
                Intrinsics.reifiedOperationMarker((int)1, (String)"T");
                this.$typedListener.invoke((Object)packet);
            }
        };
        this.registerListener(Packet.class, listenerArray);
    }

    public final void registerAll(@NotNull Object scannedObject) {
        Intrinsics.checkNotNullParameter((Object)scannedObject, (String)"scannedObject");
        KClass kClass = Reflection.getOrCreateKotlinClass(scannedObject.getClass());
        Iterable $this$forEach$iv = KClasses.getMemberFunctions((KClass)kClass);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int packetIndex;
            int channelIndex;
            List parameters;
            KFunction function;
            block12: {
                int n;
                int n2;
                block11: {
                    Object v0;
                    Listener[] $this$firstOrNull$iv$iv;
                    block10: {
                        function = (KFunction)element$iv;
                        boolean bl = false;
                        KAnnotatedElement $this$findAnnotation$iv = (KAnnotatedElement)function;
                        boolean $i$f$findAnnotation = false;
                        $this$firstOrNull$iv$iv = (Listener[])$this$findAnnotation$iv.getAnnotations();
                        boolean $i$f$firstOrNull = false;
                        for (Object t : $this$firstOrNull$iv$iv) {
                            Annotation it$iv = (Annotation)t;
                            boolean bl2 = false;
                            if (!(it$iv instanceof PacketHandler)) continue;
                            v0 = t;
                            break block10;
                        }
                        v0 = null;
                    }
                    if ((PacketHandler)((Annotation)v0) == null) continue;
                    parameters = KCallables.getValueParameters((KCallable)((KCallable)function));
                    if (parameters.size() == 1) {
                        Class<Packet> packetClass;
                        if (!Packet.class.isAssignableFrom(JvmClassMappingKt.getJavaClass((KClass)KTypesJvm.getJvmErasure((KType)((KParameter)parameters.get(0)).getType())))) {
                            this.logger.error(() -> ListenerManager.registerAll$lambda$12$lambda$6(function));
                            return;
                        }
                        Intrinsics.checkNotNullExpressionValue(JvmClassMappingKt.getJavaClass((KClass)KTypesJvm.getJvmErasure((KType)((KParameter)parameters.get(0)).getType())).asSubclass(Packet.class), (String)"asSubclass(...)");
                        Listener listener2 = new Listener(function, scannedObject){
                            final /* synthetic */ KFunction<?> $function;
                            final /* synthetic */ Object $scannedObject;
                            {
                                this.$function = $function;
                                this.$scannedObject = $scannedObject;
                            }

                            public Object acceptPacket(HermesChannel hermesChannel, Packet packet) {
                                Intrinsics.checkNotNullParameter((Object)hermesChannel, (String)"hermesChannel");
                                Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
                                Object[] objectArray = new Object[]{this.$scannedObject, packet};
                                Object result = this.$function.call(objectArray);
                                if (result instanceof Unit) {
                                    return null;
                                }
                                return result;
                            }
                        };
                        $this$firstOrNull$iv$iv = new Listener[]{listener2};
                        this.registerListener(packetClass, $this$firstOrNull$iv$iv);
                        continue;
                    }
                    if (parameters.size() != 2) continue;
                    List $this$indexOfFirst$iv = parameters;
                    boolean $i$f$indexOfFirst = false;
                    int index$iv = 0;
                    for (Object object : $this$indexOfFirst$iv) {
                        KParameter kParameter = (KParameter)object;
                        boolean bl = false;
                        if (HermesChannel.class.isAssignableFrom(JvmClassMappingKt.getJavaClass((KClass)KTypesJvm.getJvmErasure((KType)kParameter.getType())))) {
                            n2 = index$iv;
                            break block11;
                        }
                        ++index$iv;
                    }
                    n2 = -1;
                }
                channelIndex = n2;
                List $this$indexOfFirst$iv = parameters;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                for (Object item$iv : $this$indexOfFirst$iv) {
                    KParameter kParameter = (KParameter)item$iv;
                    boolean bl = false;
                    if (Packet.class.isAssignableFrom(JvmClassMappingKt.getJavaClass((KClass)KTypesJvm.getJvmErasure((KType)kParameter.getType())))) {
                        n = index$iv;
                        break block12;
                    }
                    ++index$iv;
                }
                n = packetIndex = -1;
            }
            if (packetIndex == -1) {
                this.logger.error(() -> ListenerManager.registerAll$lambda$12$lambda$9(function));
                return;
            }
            if (channelIndex == -1) {
                this.logger.error(() -> ListenerManager.registerAll$lambda$12$lambda$10(function));
                return;
            }
            Class<Packet> packetType = JvmClassMappingKt.getJavaClass((KClass)KTypesJvm.getJvmErasure((KType)((KParameter)parameters.get(packetIndex)).getType())).asSubclass(Packet.class);
            Listener listener3 = new Listener(scannedObject, channelIndex, packetIndex, function){
                final /* synthetic */ Object $scannedObject;
                final /* synthetic */ int $channelIndex;
                final /* synthetic */ int $packetIndex;
                final /* synthetic */ KFunction<?> $function;
                {
                    this.$scannedObject = $scannedObject;
                    this.$channelIndex = $channelIndex;
                    this.$packetIndex = $packetIndex;
                    this.$function = $function;
                }

                public void acceptPacket(HermesChannel hermesChannel, Packet packet) {
                    Intrinsics.checkNotNullParameter((Object)hermesChannel, (String)"hermesChannel");
                    Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
                    Object[] args = new Object[3];
                    args[0] = this.$scannedObject;
                    args[this.$channelIndex + 1] = hermesChannel;
                    args[this.$packetIndex + 1] = packet;
                    this.$function.call(Arrays.copyOf(args, args.length));
                }
            };
            this.logger.info(() -> ListenerManager.registerAll$lambda$12$lambda$11(packetType, function));
            Intrinsics.checkNotNull(packetType);
            Iterator<Object> iterator = new Listener[]{listener3};
            this.registerListener((Class<? extends Packet>)packetType, (Listener)((Object)iterator));
        }
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object handlePacket$lambda$5$lambda$4$lambda$3$lambda$1(Listener $listener) {
        Intrinsics.checkNotNullParameter((Object)$listener, (String)"$listener");
        return "Handling packet with listener " + $listener.getClass().getName();
    }

    private static final void handlePacket$lambda$5(ListenerManager this$0, Packet $packet, HermesChannel $hermesChannel) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$packet, (String)"$packet");
        Intrinsics.checkNotNullParameter((Object)$hermesChannel, (String)"$hermesChannel");
        Iterable $this$forEach$iv = this$0.listeners.entrySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl = false;
            Class clazz = (Class)entry.getKey();
            List packetListeners = (List)entry.getValue();
            if (!clazz.isAssignableFrom($packet.getClass())) continue;
            Iterable $this$forEach$iv2 = packetListeners;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Object object;
                Object object2;
                Listener listener2 = (Listener)element$iv2;
                boolean bl2 = false;
                this$0.logger.debug(() -> ListenerManager.handlePacket$lambda$5$lambda$4$lambda$3$lambda$1(listener2));
                ListenerManager $this$runCatching$iv = this$0;
                boolean $i$f$runCatching = false;
                try {
                    ListenerManager $this$handlePacket_u24lambda_u245_u24lambda_u244_u24lambda_u243_u24lambda_u242 = $this$runCatching$iv;
                    boolean bl3 = false;
                    object2 = ResultKt.Ok((Object)listener2.acceptPacket($hermesChannel, $packet));
                }
                catch (Throwable e$iv) {
                    object2 = ResultKt.Err((Object)e$iv);
                }
                Object listenerResult = object2;
                if (Result.isErr-impl((Object)listenerResult)) {
                    String string = ((Throwable)Result.getError-impl((Object)listenerResult)).getMessage();
                    if (string == null) {
                        string = "An error occurred";
                    }
                    object = $hermesChannel.sendPacket-Zyo9ksc(new ResponsePacket(false, null, string, $packet.getPacketId()));
                    continue;
                }
                Object result = Result.getValue-impl((Object)listenerResult);
                if (result == null || result instanceof Unit) {
                    return;
                }
                object = $hermesChannel.sendPacket-Zyo9ksc(new ResponsePacket(true, result, "", $packet.getPacketId()));
            }
        }
    }

    private static final Object registerAll$lambda$12$lambda$6(KFunction $function) {
        Intrinsics.checkNotNullParameter((Object)$function, (String)"$function");
        return "Parameter is not a packet in listener " + $function.getName();
    }

    private static final Object registerAll$lambda$12$lambda$9(KFunction $function) {
        Intrinsics.checkNotNullParameter((Object)$function, (String)"$function");
        return "Listener " + $function.getName() + " does not have a packet parameter";
    }

    private static final Object registerAll$lambda$12$lambda$10(KFunction $function) {
        Intrinsics.checkNotNullParameter((Object)$function, (String)"$function");
        return "Listener " + $function.getName() + " does not have a channel parameter";
    }

    private static final Object registerAll$lambda$12$lambda$11(Class $packetType, KFunction $function) {
        Intrinsics.checkNotNullParameter((Object)$function, (String)"$function");
        return "Registering " + $packetType + " listener '" + $function.getName();
    }
}

