/*
 * Decompiled with CFR 0.152.
 */
package org.readutf.hermes.response;

import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.readutf.hermes.PacketManager;
import org.readutf.hermes.channel.HermesChannel;
import org.readutf.hermes.listeners.TypedListener;
import org.readutf.hermes.response.ResponsePacket;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\u0013\u0012\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u0003H\u0016R\u0012\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/readutf/hermes/response/ResponseListener;", "Lorg/readutf/hermes/listeners/TypedListener;", "Lorg/readutf/hermes/response/ResponsePacket;", "Lorg/readutf/hermes/channel/HermesChannel;", "", "packetManager", "Lorg/readutf/hermes/PacketManager;", "<init>", "(Lorg/readutf/hermes/PacketManager;)V", "logger", "Lio/github/oshai/kotlinlogging/KLogger;", "handle", "packet", "channel", "core"})
public final class ResponseListener
implements TypedListener<ResponsePacket, HermesChannel, Unit> {
    @NotNull
    private final PacketManager<?> packetManager;
    @NotNull
    private final KLogger logger;

    public ResponseListener(@NotNull PacketManager<?> packetManager) {
        Intrinsics.checkNotNullParameter(packetManager, (String)"packetManager");
        this.packetManager = packetManager;
        this.logger = KotlinLogging.INSTANCE.logger(ResponseListener::logger$lambda$0);
    }

    @Override
    public void handle(@NotNull ResponsePacket packet, @NotNull HermesChannel channel) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        this.logger.debug(() -> ResponseListener.handle$lambda$1(packet));
        CompletableFuture<ResponsePacket> future = this.packetManager.getResponseFutures().get(packet.getOriginalId());
        if (future != null) {
            try {
                this.logger.debug(() -> ResponseListener.handle$lambda$2(packet));
                Boolean bl = future.complete(packet);
            }
            catch (Exception exception) {
                this.logger.error((Throwable)exception, ResponseListener::handle$lambda$3);
                Unit unit = Unit.INSTANCE;
            }
        } else {
            this.logger.debug(ResponseListener::handle$lambda$4);
        }
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object handle$lambda$1(ResponsePacket $packet) {
        Intrinsics.checkNotNullParameter((Object)$packet, (String)"$packet");
        return "Received response packet " + $packet.getOriginalId();
    }

    private static final Object handle$lambda$2(ResponsePacket $packet) {
        Intrinsics.checkNotNullParameter((Object)$packet, (String)"$packet");
        return "Completing future with " + $packet.getResponse();
    }

    private static final Object handle$lambda$3() {
        return "Error completing future";
    }

    private static final Object handle$lambda$4() {
        return "No future found";
    }
}

