/*
 * Decompiled with CFR 0.152.
 */
package org.readutf.hermes.utils;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u0014*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\u0014B\u001b\u0012\b\u0010\u0003\u001a\u0004\u0018\u00018\u0000\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\nJ&\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\r0\u0000\"\u0004\b\u0001\u0010\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H\r0\u000fJ,\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\r0\u0000\"\u0004\b\u0001\u0010\r2\u0018\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\r0\u00000\u000fJ\u000b\u0010\u0011\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0012J\u0006\u0010\u0013\u001a\u00020\u0005R\u0012\u0010\u0003\u001a\u0004\u0018\u00018\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/readutf/hermes/utils/Result;", "T", "", "value", "error", "", "<init>", "(Ljava/lang/Object;Ljava/lang/String;)V", "Ljava/lang/Object;", "isOk", "", "isError", "map", "U", "f", "Lkotlin/Function1;", "flatMap", "get", "()Ljava/lang/Object;", "getError", "Companion", "core"})
public final class Result<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final T value;
    @Nullable
    private final String error;

    public Result(@Nullable T value, @Nullable String error) {
        this.value = value;
        this.error = error;
    }

    public final boolean isOk() {
        return this.error == null;
    }

    public final boolean isError() {
        return this.error != null;
    }

    @NotNull
    public final <U> Result<U> map(@NotNull Function1<? super T, ? extends U> f) {
        Result<Object> result;
        Intrinsics.checkNotNullParameter(f, (String)"f");
        if (this.isOk()) {
            T t = this.value;
            Intrinsics.checkNotNull(t);
            result = Companion.ok(f.invoke(t));
        } else {
            String string = this.error;
            Intrinsics.checkNotNull((Object)string);
            result = Companion.error(string);
        }
        return result;
    }

    @NotNull
    public final <U> Result<U> flatMap(@NotNull Function1<? super T, Result<U>> f) {
        Result result;
        Intrinsics.checkNotNullParameter(f, (String)"f");
        if (this.isOk()) {
            T t = this.value;
            Intrinsics.checkNotNull(t);
            result = (Result)f.invoke(t);
        } else {
            String string = this.error;
            Intrinsics.checkNotNull((Object)string);
            result = Companion.error(string);
        }
        return result;
    }

    public final T get() {
        T t = this.value;
        Intrinsics.checkNotNull(t);
        return t;
    }

    @NotNull
    public final String getError() {
        String string = this.error;
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\u0004\b\u0001\u0010\u00062\u0006\u0010\u0004\u001a\u00020\u0007J\u001f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\u0004\b\u0001\u0010\u00062\u0006\u0010\t\u001a\u0002H\u0006\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/readutf/hermes/utils/Result$Companion;", "", "<init>", "()V", "error", "Lorg/readutf/hermes/utils/Result;", "T", "", "ok", "value", "(Ljava/lang/Object;)Lorg/readutf/hermes/utils/Result;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final <T> Result<T> error(@NotNull String error) {
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            return new Result<Object>(null, error);
        }

        @NotNull
        public final <T> Result<T> ok(T value) {
            return new Result<T>(value, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

