/*
 * Decompiled with CFR 0.152.
 */
package org.readutf.hermes.listeners;

import com.github.michaelbull.result.GetKt;
import com.github.michaelbull.result.Result;
import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.readutf.hermes.Packet;
import org.readutf.hermes.channel.HermesChannel;
import org.readutf.hermes.listeners.Listener;
import org.readutf.hermes.response.ResponseManager;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J!\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0000\u00a2\u0006\u0002\b\u0015J\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00172\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0002J7\u0010\u0018\u001a\u00020\u00112\u0012\u0010\u0019\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u000e0\r2\u0012\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u001b\"\u00020\u000fH\u0000\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\n\u001a \u0012\u001c\u0012\u001a\u0012\u0010\u0012\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u000e0\r\u0012\u0004\u0012\u00020\u000f0\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/readutf/hermes/listeners/ListenerManager;", "", "responseManager", "Lorg/readutf/hermes/response/ResponseManager;", "executorService", "Ljava/util/concurrent/ExecutorService;", "<init>", "(Lorg/readutf/hermes/response/ResponseManager;Ljava/util/concurrent/ExecutorService;)V", "logger", "Lio/github/oshai/kotlinlogging/KLogger;", "registeredListeners", "", "Lkotlin/Pair;", "Ljava/lang/Class;", "Lorg/readutf/hermes/Packet;", "Lorg/readutf/hermes/listeners/Listener;", "handlePacket", "", "hermesChannel", "Lorg/readutf/hermes/channel/HermesChannel;", "packet", "handlePacket$core", "getListeners", "", "registerListener", "clazz", "listeners", "", "registerListener$core", "(Ljava/lang/Class;[Lorg/readutf/hermes/listeners/Listener;)V", "core"})
@SourceDebugExtension(value={"SMAP\nListenerManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ListenerManager.kt\norg/readutf/hermes/listeners/ListenerManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,58:1\n774#2:59\n865#2,2:60\n1557#2:62\n1628#2,3:63\n*S KotlinDebug\n*F\n+ 1 ListenerManager.kt\norg/readutf/hermes/listeners/ListenerManager\n*L\n47#1:59\n47#1:60,2\n47#1:62\n47#1:63,3\n*E\n"})
public final class ListenerManager {
    @NotNull
    private final ResponseManager responseManager;
    @NotNull
    private final ExecutorService executorService;
    @NotNull
    private final KLogger logger;
    @NotNull
    private final List<Pair<Class<? extends Packet<?>>, Listener>> registeredListeners;

    public ListenerManager(@NotNull ResponseManager responseManager, @NotNull ExecutorService executorService) {
        Intrinsics.checkNotNullParameter((Object)responseManager, (String)"responseManager");
        Intrinsics.checkNotNullParameter((Object)executorService, (String)"executorService");
        this.responseManager = responseManager;
        this.executorService = executorService;
        this.logger = KotlinLogging.INSTANCE.logger(ListenerManager::logger$lambda$0);
        this.registeredListeners = new ArrayList();
    }

    public final void handlePacket$core(@NotNull HermesChannel hermesChannel, @NotNull Packet<?> packet) {
        Intrinsics.checkNotNullParameter((Object)hermesChannel, (String)"hermesChannel");
        Intrinsics.checkNotNullParameter(packet, (String)"packet");
        this.executorService.submit(() -> ListenerManager.handlePacket$lambda$4(this, packet, hermesChannel));
    }

    /*
     * WARNING - void declaration
     */
    private final List<Listener> getListeners(Packet<?> packet) {
        void $this$mapTo$iv$iv;
        Pair pair;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.registeredListeners;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            pair = (Pair)element$iv$iv;
            boolean bl = false;
            Class clazz = (Class)pair.component1();
            if (!clazz.isAssignableFrom(packet.getClass())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((Listener)it.getSecond());
        }
        return (List)destination$iv$iv;
    }

    public final void registerListener$core(@NotNull Class<? extends Packet<?>> clazz, Listener ... listeners) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)listeners, (String)"listeners");
        for (Listener listener : listeners) {
            this.registeredListeners.add(TuplesKt.to(clazz, (Object)listener));
        }
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object handlePacket$lambda$4$lambda$1(Listener $listener) {
        Intrinsics.checkNotNullParameter((Object)$listener, (String)"$listener");
        return "Handling packet with listener " + $listener.getClass().getName();
    }

    private static final Object handlePacket$lambda$4$lambda$2() {
        return "Packet handled successfully and has no response data";
    }

    private static final Object handlePacket$lambda$4$lambda$3() {
        return "Packet handled successfully and has response data";
    }

    private static final void handlePacket$lambda$4(ListenerManager this$0, Packet $packet, HermesChannel $hermesChannel) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$packet, (String)"$packet");
        Intrinsics.checkNotNullParameter((Object)$hermesChannel, (String)"$hermesChannel");
        List<Listener> packetListeners = this$0.getListeners($packet);
        for (Listener listener : packetListeners) {
            this$0.logger.debug(() -> ListenerManager.handlePacket$lambda$4$lambda$1(listener));
            Object result = listener.acceptPacket-T3BZVFY($hermesChannel, $packet);
            if (Result.isOk-impl((Object)result) && Intrinsics.areEqual((Object)GetKt.get-GZb53jc((Object)result), (Object)Unit.INSTANCE)) {
                this$0.logger.debug(ListenerManager::handlePacket$lambda$4$lambda$2);
                continue;
            }
            this$0.logger.debug(ListenerManager::handlePacket$lambda$4$lambda$3);
            this$0.responseManager.sendPacketResponse-sXqBOj8$core($packet, result, $hermesChannel);
            return;
        }
    }
}

