/*
 * Decompiled with CFR 0.152.
 */
package org.readutf.hermes.serializer;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.util.Pool;
import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.OutputStream;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.readutf.hermes.Packet;
import org.readutf.hermes.serializer.PacketSerializer;
import org.readutf.hermes.utils.Result;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\n2\u0006\u0010\u000f\u001a\u00020\u000bH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/readutf/hermes/serializer/KryoPacketSerializer;", "Lorg/readutf/hermes/serializer/PacketSerializer;", "kryoPool", "Lcom/esotericsoftware/kryo/util/Pool;", "Lcom/esotericsoftware/kryo/Kryo;", "<init>", "(Lcom/esotericsoftware/kryo/util/Pool;)V", "logger", "Lio/github/oshai/kotlinlogging/KLogger;", "serialize", "Lorg/readutf/hermes/utils/Result;", "", "packet", "Lorg/readutf/hermes/Packet;", "deserialize", "bytes", "kryo"})
public final class KryoPacketSerializer
implements PacketSerializer {
    @NotNull
    private final Pool<Kryo> kryoPool;
    @NotNull
    private final KLogger logger;

    public KryoPacketSerializer(@NotNull Pool<Kryo> kryoPool) {
        Intrinsics.checkNotNullParameter(kryoPool, (String)"kryoPool");
        this.kryoPool = kryoPool;
        this.logger = KotlinLogging.INSTANCE.logger(KryoPacketSerializer::logger$lambda$0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Result<byte[]> serialize(@NotNull Packet packet) {
        Closeable closeable;
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        try {
            byte[] byArray;
            closeable = new ByteArrayOutputStream();
            Result.Companion companion = Result.Companion;
            Throwable throwable = null;
            try {
                ByteArrayOutputStream outputStream = (ByteArrayOutputStream)closeable;
                boolean bl = false;
                Closeable closeable2 = (Closeable)new Output((OutputStream)outputStream);
                Throwable throwable2 = null;
                try {
                    Output output = (Output)closeable2;
                    boolean bl2 = false;
                    Kryo kryo = (Kryo)this.kryoPool.obtain();
                    kryo.writeClassAndObject(output, (Object)packet);
                    this.kryoPool.free((Object)kryo);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                byArray = outputStream.toByteArray();
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            closeable = companion.ok((Object)byArray);
        }
        catch (Exception e) {
            this.logger.error((Throwable)e, KryoPacketSerializer::serialize$lambda$3);
            String string = e.getMessage();
            if (string == null) {
                string = "Failed to serialize packet";
            }
            closeable = Result.Companion.error(string);
        }
        return closeable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Result<Packet> deserialize(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        Pool<Kryo> pool = this.kryoPool;
        synchronized (pool) {
            boolean bl = false;
            try {
                Kryo kryo = (Kryo)this.kryoPool.obtain();
                Object object = kryo.readClassAndObject(new Input(bytes));
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.readutf.hermes.Packet");
                Packet packet = (Packet)object;
                this.kryoPool.free((Object)kryo);
                Result result = Result.Companion.ok((Object)packet);
                return result;
            }
            catch (Exception e) {
                this.logger.error((Throwable)e, () -> KryoPacketSerializer.deserialize$lambda$5$lambda$4(bytes));
                String string = e.getMessage();
                if (string == null) {
                    string = "Failed to deserialize packet";
                }
                Result result = Result.Companion.error(string);
                return result;
            }
        }
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object serialize$lambda$3() {
        return "Failed to serialize packet";
    }

    private static final Object deserialize$lambda$5$lambda$4(byte[] $bytes) {
        Intrinsics.checkNotNullParameter((Object)$bytes, (String)"$bytes");
        String string = Arrays.toString($bytes);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return "Failed to deserialize packet array = " + string;
    }
}

