/*
 * Decompiled with CFR 0.152.
 */
package org.readutf.hermes.platform.netty;

import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.readutf.hermes.Packet;
import org.readutf.hermes.channel.ChannelClosePacket;
import org.readutf.hermes.channel.ChannelOpenPacket;
import org.readutf.hermes.channel.HermesChannel;
import org.readutf.hermes.platform.netty.NettyPlatform;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/readutf/hermes/platform/netty/NettyInboundHandler;", "Lio/netty/channel/ChannelInboundHandlerAdapter;", "packetPlatform", "Lorg/readutf/hermes/platform/netty/NettyPlatform;", "<init>", "(Lorg/readutf/hermes/platform/netty/NettyPlatform;)V", "logger", "Lio/github/oshai/kotlinlogging/KLogger;", "channelRead", "", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "msg", "", "channelActive", "channelInactive", "exceptionCaught", "cause", "", "netty"})
public final class NettyInboundHandler
extends ChannelInboundHandlerAdapter {
    @NotNull
    private final NettyPlatform packetPlatform;
    @NotNull
    private final KLogger logger;

    public NettyInboundHandler(@NotNull NettyPlatform packetPlatform) {
        Intrinsics.checkNotNullParameter((Object)((Object)packetPlatform), (String)"packetPlatform");
        this.packetPlatform = packetPlatform;
        this.logger = KotlinLogging.INSTANCE.logger(NettyInboundHandler::logger$lambda$0);
    }

    public void channelRead(@NotNull ChannelHandlerContext ctx, @Nullable Object msg) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.logger.debug(() -> NettyInboundHandler.channelRead$lambda$1(msg));
        if (!(msg instanceof Packet)) {
            this.logger.warn(() -> NettyInboundHandler.channelRead$lambda$2(msg));
            return;
        }
        Channel channel = ctx.channel();
        Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"channel(...)");
        HermesChannel hermesChannel = this.packetPlatform.getChannel(channel);
        this.packetPlatform.handlePacket(hermesChannel, (Packet)msg);
    }

    public void channelActive(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.logger.info(() -> NettyInboundHandler.channelActive$lambda$3(ctx));
        this.packetPlatform.getActiveChannels().put(ctx.channel().id().asLongText(), ctx.channel());
        Channel channel = ctx.channel();
        Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"channel(...)");
        HermesChannel hermesChannel = this.packetPlatform.getChannel(channel);
        this.packetPlatform.handlePacket(hermesChannel, (Packet)new ChannelOpenPacket(hermesChannel));
    }

    public void channelInactive(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.logger.info(() -> NettyInboundHandler.channelInactive$lambda$4(ctx));
        this.packetPlatform.getActiveChannels().remove(ctx.channel().id().asLongText());
        Channel channel = ctx.channel();
        Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"channel(...)");
        HermesChannel hermesChannel = this.packetPlatform.getChannel(channel);
        this.packetPlatform.handlePacket(hermesChannel, (Packet)new ChannelClosePacket(hermesChannel));
        Channel channel2 = ctx.channel();
        Intrinsics.checkNotNullExpressionValue((Object)channel2, (String)"channel(...)");
        this.packetPlatform.removeChannel(channel2);
    }

    public void exceptionCaught(@NotNull ChannelHandlerContext ctx, @NotNull Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        boolean handled = this.packetPlatform.getPacketManager().handleException(cause);
        if (!handled) {
            throw cause;
        }
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object channelRead$lambda$1(Object $msg) {
        return "Received packet " + $msg;
    }

    private static final Object channelRead$lambda$2(Object $msg) {
        return "Received unknown message: " + $msg;
    }

    private static final Object channelActive$lambda$3(ChannelHandlerContext $ctx) {
        Intrinsics.checkNotNullParameter((Object)$ctx, (String)"$ctx");
        return "New connection from " + $ctx.channel().remoteAddress();
    }

    private static final Object channelInactive$lambda$4(ChannelHandlerContext $ctx) {
        Intrinsics.checkNotNullParameter((Object)$ctx, (String)"$ctx");
        return "Connection closed from " + $ctx.channel().remoteAddress();
    }
}

