/*
 * Decompiled with CFR 0.152.
 */
package org.readutf.hermes.platform.netty;

import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ReplayingDecoder;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.readutf.hermes.Packet;
import org.readutf.hermes.serializer.PacketSerializer;
import org.readutf.hermes.utils.Result;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u0000\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J(\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/readutf/hermes/platform/netty/NettyPacketDecoder;", "Lio/netty/handler/codec/ReplayingDecoder;", "Lorg/readutf/hermes/Packet;", "packetSerializer", "Lorg/readutf/hermes/serializer/PacketSerializer;", "<init>", "(Lorg/readutf/hermes/serializer/PacketSerializer;)V", "logger", "Lio/github/oshai/kotlinlogging/KLogger;", "decode", "", "contex", "Lio/netty/channel/ChannelHandlerContext;", "buffer", "Lio/netty/buffer/ByteBuf;", "packets", "", "", "netty"})
public final class NettyPacketDecoder
extends ReplayingDecoder<Packet> {
    @NotNull
    private final PacketSerializer packetSerializer;
    @NotNull
    private final KLogger logger;

    public NettyPacketDecoder(@NotNull PacketSerializer packetSerializer) {
        Intrinsics.checkNotNullParameter((Object)packetSerializer, (String)"packetSerializer");
        this.packetSerializer = packetSerializer;
        this.logger = KotlinLogging.INSTANCE.logger(NettyPacketDecoder::logger$lambda$0);
    }

    protected void decode(@Nullable ChannelHandlerContext contex, @NotNull ByteBuf buffer, @NotNull List<Object> packets) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter(packets, (String)"packets");
        if (buffer.readableBytes() < 4) {
            return;
        }
        int length = buffer.readInt();
        if (buffer.readableBytes() < length) {
            buffer.resetReaderIndex();
            return;
        }
        byte[] bytes = new byte[length];
        buffer.readBytes(bytes);
        Result packetResult = this.packetSerializer.deserialize(bytes);
        if (packetResult.isError()) {
            this.logger.warn(() -> NettyPacketDecoder.decode$lambda$1(packetResult));
            return;
        }
        packets.add(packetResult.get());
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object decode$lambda$1(Result $packetResult) {
        Intrinsics.checkNotNullParameter((Object)$packetResult, (String)"$packetResult");
        return "Failed to deserialize packet: " + $packetResult.getError();
    }
}

