/*
 * Decompiled with CFR 0.152.
 */
package org.readutf.hermes.platform.netty;

import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import io.netty.bootstrap.AbstractBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.readutf.hermes.Packet;
import org.readutf.hermes.PacketManager;
import org.readutf.hermes.channel.HermesChannel;
import org.readutf.hermes.platform.PacketPlatform;
import org.readutf.hermes.platform.netty.NettyHermesChannel;
import org.readutf.hermes.platform.netty.NettyInboundHandler;
import org.readutf.hermes.platform.netty.NettyPacketDecoder;
import org.readutf.hermes.platform.netty.NettyPacketEncoder;
import org.readutf.hermes.serializer.PacketSerializer;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u001e\n\u0002\b\u0003\b&\u0018\u00002\u00020\u00012\u00020\u0002B1\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u000e\u0010\t\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0014\u00105\u001a\u0002062\n\u0010'\u001a\u0006\u0012\u0002\b\u00030(H\u0016J\f\u00107\u001a\b\u0012\u0004\u0012\u00020908J\u0016\u0010:\u001a\u0002062\u0006\u0010;\u001a\u00020\u001f2\u0006\u0010<\u001a\u00020 J\u000e\u0010#\u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\"J\u0010\u0010=\u001a\u0004\u0018\u00010\u001f2\u0006\u0010!\u001a\u00020\"J\u001c\u0010>\u001a\u0002062\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020 0\u001eH\u0016J\u0012\u0010#\u001a\u0004\u0018\u00010\u001f2\u0006\u0010?\u001a\u00020\u0004H\u0016J\f\u0010@\u001a\b\u0012\u0004\u0012\u00020\"0AJ\u0010\u0010B\u001a\u0002062\u0006\u0010<\u001a\u00020 H\u0016J\u0010\u0010C\u001a\u0002062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0007\u001a\u00020\bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\"\u0010\t\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020 0\u001eX\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010!\u001a\u00020\"X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R \u0010'\u001a\b\u0012\u0004\u0012\u00020\u00000(X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u001a\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u001f0.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u001f0.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u00100\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\"0.X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u00102\"\u0004\b3\u00104\u00a8\u0006D"}, d2={"Lorg/readutf/hermes/platform/netty/NettyPlatform;", "Lio/netty/channel/ChannelInboundHandlerAdapter;", "Lorg/readutf/hermes/platform/PacketPlatform;", "hostName", "", "port", "", "serializer", "Lorg/readutf/hermes/serializer/PacketSerializer;", "bootstrap", "Lio/netty/bootstrap/AbstractBootstrap;", "<init>", "(Ljava/lang/String;ILorg/readutf/hermes/serializer/PacketSerializer;Lio/netty/bootstrap/AbstractBootstrap;)V", "getHostName$netty", "()Ljava/lang/String;", "getPort$netty", "()I", "getSerializer$netty", "()Lorg/readutf/hermes/serializer/PacketSerializer;", "setSerializer$netty", "(Lorg/readutf/hermes/serializer/PacketSerializer;)V", "getBootstrap$netty", "()Lio/netty/bootstrap/AbstractBootstrap;", "setBootstrap$netty", "(Lio/netty/bootstrap/AbstractBootstrap;)V", "logger", "Lio/github/oshai/kotlinlogging/KLogger;", "getLogger", "()Lio/github/oshai/kotlinlogging/KLogger;", "packetConsumer", "Ljava/util/function/BiConsumer;", "Lorg/readutf/hermes/channel/HermesChannel;", "Lorg/readutf/hermes/Packet;", "channel", "Lio/netty/channel/Channel;", "getChannel", "()Lio/netty/channel/Channel;", "setChannel", "(Lio/netty/channel/Channel;)V", "packetManager", "Lorg/readutf/hermes/PacketManager;", "getPacketManager", "()Lorg/readutf/hermes/PacketManager;", "setPacketManager", "(Lorg/readutf/hermes/PacketManager;)V", "channelMap", "", "channelIdMap", "activeChannels", "getActiveChannels", "()Ljava/util/Map;", "setActiveChannels", "(Ljava/util/Map;)V", "init", "", "getChannelInitializer", "Lio/netty/channel/ChannelInitializer;", "Lio/netty/channel/socket/SocketChannel;", "handlePacket", "hermesChannel", "packet", "removeChannel", "setupPacketListener", "channelId", "getChannels", "", "sendPacket", "setSerializer", "netty"})
@SourceDebugExtension(value={"SMAP\nNettyPlatform.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NettyPlatform.kt\norg/readutf/hermes/platform/netty/NettyPlatform\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,223:1\n381#2,7:224\n*S KotlinDebug\n*F\n+ 1 NettyPlatform.kt\norg/readutf/hermes/platform/netty/NettyPlatform\n*L\n63#1:224,7\n*E\n"})
public abstract class NettyPlatform
extends ChannelInboundHandlerAdapter
implements PacketPlatform {
    @NotNull
    private final String hostName;
    private final int port;
    @NotNull
    private PacketSerializer serializer;
    @NotNull
    private AbstractBootstrap<?, ?> bootstrap;
    @NotNull
    private final KLogger logger;
    private BiConsumer<HermesChannel, Packet> packetConsumer;
    public Channel channel;
    public PacketManager<NettyPlatform> packetManager;
    @NotNull
    private final Map<Channel, HermesChannel> channelMap;
    @NotNull
    private final Map<String, HermesChannel> channelIdMap;
    @NotNull
    private Map<String, Channel> activeChannels;

    public NettyPlatform(@NotNull String hostName, int port, @NotNull PacketSerializer serializer, @NotNull AbstractBootstrap<?, ?> bootstrap) {
        Intrinsics.checkNotNullParameter((Object)hostName, (String)"hostName");
        Intrinsics.checkNotNullParameter((Object)serializer, (String)"serializer");
        Intrinsics.checkNotNullParameter(bootstrap, (String)"bootstrap");
        this.hostName = hostName;
        this.port = port;
        this.serializer = serializer;
        this.bootstrap = bootstrap;
        this.logger = KotlinLogging.INSTANCE.logger(NettyPlatform::logger$lambda$0);
        this.channelMap = new LinkedHashMap();
        this.channelIdMap = new LinkedHashMap();
        this.activeChannels = new LinkedHashMap();
    }

    @NotNull
    public final String getHostName$netty() {
        return this.hostName;
    }

    public final int getPort$netty() {
        return this.port;
    }

    @NotNull
    public final PacketSerializer getSerializer$netty() {
        return this.serializer;
    }

    public final void setSerializer$netty(@NotNull PacketSerializer packetSerializer) {
        Intrinsics.checkNotNullParameter((Object)packetSerializer, (String)"<set-?>");
        this.serializer = packetSerializer;
    }

    @NotNull
    public final AbstractBootstrap<?, ?> getBootstrap$netty() {
        return this.bootstrap;
    }

    public final void setBootstrap$netty(@NotNull AbstractBootstrap<?, ?> abstractBootstrap) {
        Intrinsics.checkNotNullParameter(abstractBootstrap, (String)"<set-?>");
        this.bootstrap = abstractBootstrap;
    }

    @NotNull
    public final KLogger getLogger() {
        return this.logger;
    }

    @NotNull
    public final Channel getChannel() {
        Channel channel = this.channel;
        if (channel != null) {
            return channel;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"channel");
        return null;
    }

    public final void setChannel(@NotNull Channel channel) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"<set-?>");
        this.channel = channel;
    }

    @NotNull
    public final PacketManager<NettyPlatform> getPacketManager() {
        PacketManager<NettyPlatform> packetManager = this.packetManager;
        if (packetManager != null) {
            return packetManager;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"packetManager");
        return null;
    }

    public final void setPacketManager(@NotNull PacketManager<NettyPlatform> packetManager) {
        Intrinsics.checkNotNullParameter(packetManager, (String)"<set-?>");
        this.packetManager = packetManager;
    }

    @NotNull
    public final Map<String, Channel> getActiveChannels() {
        return this.activeChannels;
    }

    public final void setActiveChannels(@NotNull Map<String, Channel> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.activeChannels = map;
    }

    public void init(@NotNull PacketManager<?> packetManager) {
        Intrinsics.checkNotNullParameter(packetManager, (String)"packetManager");
        this.setPacketManager(packetManager);
    }

    @NotNull
    public final ChannelInitializer<SocketChannel> getChannelInitializer() {
        return (ChannelInitializer)new ChannelInitializer<SocketChannel>(this){
            final /* synthetic */ NettyPlatform this$0;
            {
                this.this$0 = $receiver;
            }

            protected void initChannel(SocketChannel socketChannel) {
                Intrinsics.checkNotNullParameter((Object)socketChannel, (String)"socketChannel");
                ChannelPipeline pipeline = socketChannel.pipeline();
                pipeline.addLast("decoder", (ChannelHandler)new NettyPacketDecoder(this.this$0.getSerializer$netty()));
                pipeline.addLast("encoder", (ChannelHandler)new NettyPacketEncoder(this.this$0.getSerializer$netty()));
                pipeline.addLast("handler", (ChannelHandler)new NettyInboundHandler(this.this$0));
            }
        };
    }

    public final void handlePacket(@NotNull HermesChannel hermesChannel, @NotNull Packet packet) {
        Intrinsics.checkNotNullParameter((Object)hermesChannel, (String)"hermesChannel");
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        if (this.packetConsumer != null) {
            BiConsumer<HermesChannel, Packet> biConsumer = this.packetConsumer;
            if (biConsumer == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"packetConsumer");
                biConsumer = null;
            }
            biConsumer.accept(hermesChannel, packet);
        }
    }

    @NotNull
    public final HermesChannel getChannel(@NotNull Channel channel) {
        HermesChannel hermesChannel;
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Map<Channel, HermesChannel> $this$getOrPut$iv = this.channelMap;
        boolean $i$f$getOrPut = false;
        HermesChannel value$iv = $this$getOrPut$iv.get(channel);
        if (value$iv == null) {
            boolean bl = false;
            HermesChannel answer$iv = new NettyHermesChannel(channel, this.getPacketManager());
            $this$getOrPut$iv.put(channel, answer$iv);
            hermesChannel = answer$iv;
        } else {
            hermesChannel = value$iv;
        }
        return hermesChannel;
    }

    @Nullable
    public final HermesChannel removeChannel(@NotNull Channel channel) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        return this.channelMap.remove(channel);
    }

    public void setupPacketListener(@NotNull BiConsumer<HermesChannel, Packet> packetConsumer) {
        Intrinsics.checkNotNullParameter(packetConsumer, (String)"packetConsumer");
        this.packetConsumer = packetConsumer;
    }

    @Nullable
    public HermesChannel getChannel(@NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        return this.channelIdMap.get(channelId);
    }

    @NotNull
    public final Collection<Channel> getChannels() {
        return this.activeChannels.values();
    }

    public void sendPacket(@NotNull Packet packet) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        if (this.channel != null) {
            this.logger.debug(() -> NettyPlatform.sendPacket$lambda$2(packet));
            this.getChannel().writeAndFlush((Object)packet);
        } else {
            this.logger.warn(NettyPlatform::sendPacket$lambda$3);
        }
    }

    public void setSerializer(@NotNull PacketSerializer serializer) {
        Intrinsics.checkNotNullParameter((Object)serializer, (String)"serializer");
        this.serializer = serializer;
    }

    public void handleException(@NotNull Throwable throwable) {
        PacketPlatform.DefaultImpls.handleException((PacketPlatform)this, (Throwable)throwable);
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object sendPacket$lambda$2(Packet $packet) {
        Intrinsics.checkNotNullParameter((Object)$packet, (String)"$packet");
        return "Writing packet " + $packet + " and flushing...";
    }

    private static final Object sendPacket$lambda$3() {
        return "Channel not initialized, cannot send packet";
    }
}

