/*
 * Decompiled with CFR 0.152.
 */
package org.readutf.hermes.platform.netty;

import com.github.michaelbull.result.ResultKt;
import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import io.netty.bootstrap.AbstractBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.readutf.hermes.Packet;
import org.readutf.hermes.PacketManager;
import org.readutf.hermes.channel.HermesChannel;
import org.readutf.hermes.platform.PacketPlatform;
import org.readutf.hermes.platform.netty.NettyHermesChannel;
import org.readutf.hermes.platform.netty.NettyInboundHandler;
import org.readutf.hermes.platform.netty.NettyPacketDecoder;
import org.readutf.hermes.platform.netty.NettyPacketEncoder;
import org.readutf.hermes.serializer.PacketSerializer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u001e\n\u0002\b\u0005\b&\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0002B1\b\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u000e\u0010\n\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000b\u00a2\u0006\u0004\b\f\u0010\rJ)\u00102\u001a\u000e\u0012\u0004\u0012\u000204\u0012\u0004\u0012\u000205032\f\u0010(\u001a\b\u0012\u0004\u0012\u00028\u00000)H\u0016\u00a2\u0006\u0004\b6\u00107J\f\u00108\u001a\b\u0012\u0004\u0012\u00020:09J\u001a\u0010;\u001a\u0002042\u0006\u0010<\u001a\u00020 2\n\u0010=\u001a\u0006\u0012\u0002\b\u00030!J\u000e\u0010$\u001a\u00020 2\u0006\u0010\"\u001a\u00020#J\u0010\u0010>\u001a\u0004\u0018\u00010 2\u0006\u0010\"\u001a\u00020#J \u0010?\u001a\u0002042\u0016\u0010\u001e\u001a\u0012\u0012\u0004\u0012\u00020 \u0012\b\u0012\u0006\u0012\u0002\b\u00030!0\u001fH\u0016J\u0012\u0010$\u001a\u0004\u0018\u00010 2\u0006\u0010@\u001a\u00020\u0005H\u0016J\f\u0010A\u001a\b\u0012\u0004\u0012\u00020#0BJ'\u0010C\u001a\u000e\u0012\u0004\u0012\u000204\u0012\u0004\u0012\u000205032\n\u0010=\u001a\u0006\u0012\u0002\b\u00030!H\u0016\u00a2\u0006\u0004\bD\u0010EJ\u0010\u0010F\u001a\u0002042\u0006\u0010\b\u001a\u00020\tH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0006\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\b\u001a\u00020\tX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\"\u0010\n\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u001e\u0010\u001e\u001a\u0012\u0012\u0004\u0012\u00020 \u0012\b\u0012\u0006\u0012\u0002\b\u00030!0\u001fX\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\"\u001a\u00020#X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u0014\u0010(\u001a\b\u0012\u0004\u0012\u00028\u00000)X\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010*\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020 0+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020 0+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020#0+X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101\u00a8\u0006G"}, d2={"Lorg/readutf/hermes/platform/netty/NettyPlatform;", "T", "Lorg/readutf/hermes/platform/PacketPlatform;", "Lio/netty/channel/ChannelInboundHandlerAdapter;", "hostName", "", "port", "", "serializer", "Lorg/readutf/hermes/serializer/PacketSerializer;", "bootstrap", "Lio/netty/bootstrap/AbstractBootstrap;", "<init>", "(Ljava/lang/String;ILorg/readutf/hermes/serializer/PacketSerializer;Lio/netty/bootstrap/AbstractBootstrap;)V", "getHostName$netty", "()Ljava/lang/String;", "getPort$netty", "()I", "getSerializer$netty", "()Lorg/readutf/hermes/serializer/PacketSerializer;", "setSerializer$netty", "(Lorg/readutf/hermes/serializer/PacketSerializer;)V", "getBootstrap$netty", "()Lio/netty/bootstrap/AbstractBootstrap;", "setBootstrap$netty", "(Lio/netty/bootstrap/AbstractBootstrap;)V", "logger", "Lio/github/oshai/kotlinlogging/KLogger;", "getLogger", "()Lio/github/oshai/kotlinlogging/KLogger;", "packetConsumer", "Ljava/util/function/BiConsumer;", "Lorg/readutf/hermes/channel/HermesChannel;", "Lorg/readutf/hermes/Packet;", "channel", "Lio/netty/channel/Channel;", "getChannel", "()Lio/netty/channel/Channel;", "setChannel", "(Lio/netty/channel/Channel;)V", "packetManager", "Lorg/readutf/hermes/PacketManager;", "channelMap", "", "channelIdMap", "activeChannels", "getActiveChannels", "()Ljava/util/Map;", "setActiveChannels", "(Ljava/util/Map;)V", "init", "Lcom/github/michaelbull/result/Result;", "", "", "init-Zyo9ksc", "(Lorg/readutf/hermes/PacketManager;)Ljava/lang/Object;", "getChannelInitializer", "Lio/netty/channel/ChannelInitializer;", "Lio/netty/channel/socket/SocketChannel;", "handlePacket", "hermesChannel", "packet", "removeChannel", "setupPacketListener", "channelId", "getChannels", "", "sendPacket", "sendPacket-Zyo9ksc", "(Lorg/readutf/hermes/Packet;)Ljava/lang/Object;", "setSerializer", "netty"})
@SourceDebugExtension(value={"SMAP\nNettyPlatform.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NettyPlatform.kt\norg/readutf/hermes/platform/netty/NettyPlatform\n+ 2 Factory.kt\ncom/github/michaelbull/result/FactoryKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,227:1\n29#2,8:228\n381#3,7:236\n*S KotlinDebug\n*F\n+ 1 NettyPlatform.kt\norg/readutf/hermes/platform/netty/NettyPlatform\n*L\n46#1:228,8\n65#1:236,7\n*E\n"})
public abstract class NettyPlatform<T extends PacketPlatform<T>>
extends ChannelInboundHandlerAdapter
implements PacketPlatform<T> {
    @NotNull
    private final String hostName;
    private final int port;
    @NotNull
    private PacketSerializer serializer;
    @NotNull
    private AbstractBootstrap<?, ?> bootstrap;
    @NotNull
    private final KLogger logger;
    private BiConsumer<HermesChannel, Packet<?>> packetConsumer;
    public Channel channel;
    private PacketManager<T> packetManager;
    @NotNull
    private final Map<Channel, HermesChannel> channelMap;
    @NotNull
    private final Map<String, HermesChannel> channelIdMap;
    @NotNull
    private Map<String, Channel> activeChannels;

    public NettyPlatform(@NotNull String hostName, int port, @NotNull PacketSerializer serializer, @NotNull AbstractBootstrap<?, ?> bootstrap) {
        Intrinsics.checkNotNullParameter((Object)hostName, (String)"hostName");
        Intrinsics.checkNotNullParameter((Object)serializer, (String)"serializer");
        Intrinsics.checkNotNullParameter(bootstrap, (String)"bootstrap");
        this.hostName = hostName;
        this.port = port;
        this.serializer = serializer;
        this.bootstrap = bootstrap;
        this.logger = KotlinLogging.INSTANCE.logger(NettyPlatform::logger$lambda$0);
        this.channelMap = new LinkedHashMap();
        this.channelIdMap = new LinkedHashMap();
        this.activeChannels = new LinkedHashMap();
    }

    @NotNull
    public final String getHostName$netty() {
        return this.hostName;
    }

    public final int getPort$netty() {
        return this.port;
    }

    @NotNull
    public final PacketSerializer getSerializer$netty() {
        return this.serializer;
    }

    public final void setSerializer$netty(@NotNull PacketSerializer packetSerializer) {
        Intrinsics.checkNotNullParameter((Object)packetSerializer, (String)"<set-?>");
        this.serializer = packetSerializer;
    }

    @NotNull
    public final AbstractBootstrap<?, ?> getBootstrap$netty() {
        return this.bootstrap;
    }

    public final void setBootstrap$netty(@NotNull AbstractBootstrap<?, ?> abstractBootstrap) {
        Intrinsics.checkNotNullParameter(abstractBootstrap, (String)"<set-?>");
        this.bootstrap = abstractBootstrap;
    }

    @NotNull
    public final KLogger getLogger() {
        return this.logger;
    }

    @NotNull
    public final Channel getChannel() {
        Channel channel = this.channel;
        if (channel != null) {
            return channel;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"channel");
        return null;
    }

    public final void setChannel(@NotNull Channel channel) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"<set-?>");
        this.channel = channel;
    }

    @NotNull
    public final Map<String, Channel> getActiveChannels() {
        return this.activeChannels;
    }

    public final void setActiveChannels(@NotNull Map<String, Channel> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.activeChannels = map;
    }

    @NotNull
    public Object init-Zyo9ksc(@NotNull PacketManager<T> packetManager) {
        Object object;
        Intrinsics.checkNotNullParameter(packetManager, (String)"packetManager");
        NettyPlatform $this$runCatching$iv = this;
        boolean $i$f$runCatching = false;
        try {
            NettyPlatform $this$init_Zyo9ksc_u24lambda_u241 = $this$runCatching$iv;
            boolean bl = false;
            $this$init_Zyo9ksc_u24lambda_u241.packetManager = packetManager;
            object = ResultKt.Ok((Object)Unit.INSTANCE);
        }
        catch (Throwable e$iv) {
            object = ResultKt.Err((Object)e$iv);
        }
        return object;
    }

    @NotNull
    public final ChannelInitializer<SocketChannel> getChannelInitializer() {
        return (ChannelInitializer)new ChannelInitializer<SocketChannel>(this){
            final /* synthetic */ NettyPlatform<T> this$0;
            {
                this.this$0 = $receiver;
            }

            protected void initChannel(SocketChannel socketChannel) {
                Intrinsics.checkNotNullParameter((Object)socketChannel, (String)"socketChannel");
                ChannelPipeline pipeline = socketChannel.pipeline();
                pipeline.addLast("decoder", (ChannelHandler)new NettyPacketDecoder(this.this$0.getSerializer$netty()));
                pipeline.addLast("encoder", (ChannelHandler)new NettyPacketEncoder(this.this$0.getSerializer$netty()));
                pipeline.addLast("handler", (ChannelHandler)new NettyInboundHandler(this.this$0));
            }
        };
    }

    public final void handlePacket(@NotNull HermesChannel hermesChannel, @NotNull Packet<?> packet) {
        Intrinsics.checkNotNullParameter((Object)hermesChannel, (String)"hermesChannel");
        Intrinsics.checkNotNullParameter(packet, (String)"packet");
        if (this.packetConsumer != null) {
            BiConsumer<HermesChannel, Packet<?>> biConsumer = this.packetConsumer;
            if (biConsumer == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"packetConsumer");
                biConsumer = null;
            }
            biConsumer.accept(hermesChannel, packet);
        }
    }

    @NotNull
    public final HermesChannel getChannel(@NotNull Channel channel) {
        HermesChannel hermesChannel;
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Map<Channel, HermesChannel> $this$getOrPut$iv = this.channelMap;
        boolean $i$f$getOrPut = false;
        HermesChannel value$iv = $this$getOrPut$iv.get(channel);
        if (value$iv == null) {
            boolean bl = false;
            PacketManager<T> packetManager = this.packetManager;
            if (packetManager == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"packetManager");
                packetManager = null;
            }
            HermesChannel answer$iv = new NettyHermesChannel(channel, packetManager);
            $this$getOrPut$iv.put(channel, answer$iv);
            hermesChannel = answer$iv;
        } else {
            hermesChannel = value$iv;
        }
        return hermesChannel;
    }

    @Nullable
    public final HermesChannel removeChannel(@NotNull Channel channel) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        return this.channelMap.remove(channel);
    }

    public void setupPacketListener(@NotNull BiConsumer<HermesChannel, Packet<?>> packetConsumer) {
        Intrinsics.checkNotNullParameter(packetConsumer, (String)"packetConsumer");
        this.packetConsumer = packetConsumer;
    }

    @Nullable
    public HermesChannel getChannel(@NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        return this.channelIdMap.get(channelId);
    }

    @NotNull
    public final Collection<Channel> getChannels() {
        return this.activeChannels.values();
    }

    @NotNull
    public Object sendPacket-Zyo9ksc(@NotNull Packet<?> packet) {
        Intrinsics.checkNotNullParameter(packet, (String)"packet");
        if (this.channel != null) {
            this.logger.debug(() -> NettyPlatform.sendPacket_Zyo9ksc$lambda$3(packet));
            this.getChannel().writeAndFlush(packet);
            return ResultKt.Ok((Object)Unit.INSTANCE);
        }
        this.logger.error(NettyPlatform::sendPacket_Zyo9ksc$lambda$4);
        return ResultKt.Err((Object)new Exception("Channel not initialized"));
    }

    public void setSerializer(@NotNull PacketSerializer serializer) {
        Intrinsics.checkNotNullParameter((Object)serializer, (String)"serializer");
        this.serializer = serializer;
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object sendPacket_Zyo9ksc$lambda$3(Packet $packet) {
        Intrinsics.checkNotNullParameter((Object)$packet, (String)"$packet");
        return "Writing packet " + $packet + " and flushing...";
    }

    private static final Object sendPacket_Zyo9ksc$lambda$4() {
        return "Channel not initialized";
    }
}

