/*
 * Decompiled with CFR 0.152.
 */
package org.readutf.hermes.platform.netty;

import io.netty.bootstrap.AbstractBootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.readutf.hermes.platform.netty.NettyPlatform;
import org.readutf.hermes.serializer.PacketSerializer;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0016R\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/readutf/hermes/platform/netty/NettyServerPlatform;", "Lorg/readutf/hermes/platform/netty/NettyPlatform;", "hostName", "", "port", "", "serializer", "Lorg/readutf/hermes/serializer/PacketSerializer;", "bootstrap", "Lio/netty/bootstrap/ServerBootstrap;", "<init>", "(Ljava/lang/String;ILorg/readutf/hermes/serializer/PacketSerializer;Lio/netty/bootstrap/ServerBootstrap;)V", "thread", "Ljava/lang/Thread;", "bossGroup", "Lio/netty/channel/nio/NioEventLoopGroup;", "workerGroup", "start", "", "stop", "netty"})
public final class NettyServerPlatform
extends NettyPlatform<NettyServerPlatform> {
    private Thread thread;
    private NioEventLoopGroup bossGroup;
    private NioEventLoopGroup workerGroup;

    public NettyServerPlatform(@NotNull String hostName, int port, @NotNull PacketSerializer serializer, @NotNull ServerBootstrap bootstrap) {
        Intrinsics.checkNotNullParameter((Object)hostName, (String)"hostName");
        Intrinsics.checkNotNullParameter((Object)serializer, (String)"serializer");
        Intrinsics.checkNotNullParameter((Object)bootstrap, (String)"bootstrap");
        super(hostName, port, serializer, (AbstractBootstrap)bootstrap);
    }

    public void start() {
        this.bossGroup = new NioEventLoopGroup();
        this.workerGroup = new NioEventLoopGroup();
        this.thread = new Thread(() -> NettyServerPlatform.start$lambda$2(this), "Hermes-Netty-Thread");
        Thread thread = this.thread;
        if (thread == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"thread");
            thread = null;
        }
        thread.start();
    }

    public void stop() {
        if (this.thread != null) {
            this.getLogger().debug(NettyServerPlatform::stop$lambda$3);
            Thread thread = this.thread;
            if (thread == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"thread");
                thread = null;
            }
            thread.interrupt();
        }
    }

    private static final Object start$lambda$2$lambda$0(NettyServerPlatform this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        return "Server started on " + this$0.getHostName$netty() + ":" + this$0.getPort$netty();
    }

    private static final Object start$lambda$2$lambda$1() {
        return "Exception occurred on main netty thread";
    }

    private static final void start$lambda$2(NettyServerPlatform this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        try {
            AbstractBootstrap<?, ?> abstractBootstrap = this$0.getBootstrap$netty();
            Intrinsics.checkNotNull(abstractBootstrap, (String)"null cannot be cast to non-null type io.netty.bootstrap.ServerBootstrap");
            ServerBootstrap serverBootstrap = (ServerBootstrap)abstractBootstrap;
            NioEventLoopGroup nioEventLoopGroup = this$0.bossGroup;
            if (nioEventLoopGroup == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"bossGroup");
                nioEventLoopGroup = null;
            }
            EventLoopGroup eventLoopGroup = (EventLoopGroup)nioEventLoopGroup;
            NioEventLoopGroup nioEventLoopGroup2 = this$0.workerGroup;
            if (nioEventLoopGroup2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"workerGroup");
                nioEventLoopGroup2 = null;
            }
            this$0.setBootstrap$netty((AbstractBootstrap)((ServerBootstrap)serverBootstrap.group(eventLoopGroup, (EventLoopGroup)nioEventLoopGroup2).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)this$0.getChannelInitializer()));
            ChannelFuture channelFuture = this$0.getBootstrap$netty().bind(this$0.getHostName$netty(), this$0.getPort$netty()).sync();
            this$0.getLogger().info(() -> NettyServerPlatform.start$lambda$2$lambda$0(this$0));
            channelFuture.channel().closeFuture();
        }
        catch (Exception e) {
            this$0.getLogger().error((Throwable)e, NettyServerPlatform::start$lambda$2$lambda$1);
        }
    }

    private static final Object stop$lambda$3() {
        return "Stopping netty platform thread";
    }
}

