package akasha.core;

import javax.annotation.Generated;
import javax.annotation.Nonnull;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsType;

/**
 * The URIError object represents an error when a global URI handling function was used in a wrong way.
 *
 * @see <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/URIError">URIError - MDN</a>
 * @see <a href="https://tc39.es/ecma262/multipage/fundamental-objects.html#sec-native-error-types-used-in-this-standard-urierror"># sec-native-error-types-used-in-this-standard-urierror</a>
 */
@Generated("org.realityforge.webtack")
@JsType(
    isNative = true,
    namespace = JsPackage.GLOBAL,
    name = "URIError"
)
public class URIError extends JsError {
  /**
   * The URIError() constructor creates an error when a global URI handling function was used in a wrong way.
   *
   * @see <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/URIError/URIError">URIError() - MDN</a>
   * @see <a href="https://tc39.es/ecma262/#sec-native-error-types-used-in-this-standard-urierror">URIError() - ECMA</a>
   */
  public URIError(@Nonnull final String message) {
  }

  /**
   * The URIError() constructor creates an error when a global URI handling function was used in a wrong way.
   *
   * @see <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/URIError/URIError">URIError() - MDN</a>
   * @see <a href="https://tc39.es/ecma262/#sec-native-error-types-used-in-this-standard-urierror">URIError() - ECMA</a>
   */
  public URIError() {
  }
}
