/*
 * Decompiled with CFR 0.152.
 */
package akasha;

import java.lang.annotation.Documented;
import javax.annotation.Nonnull;

@Documented
public @interface PositionErrorCode {

    public static final class Util {
        private Util() {
        }

        @PositionErrorCode
        public static int requireValid(int value) {
            Util.assertValid(value);
            return value;
        }

        public static void assertValid(int value) {
            assert (Util.isValid(value)) : "@PositionErrorCode annotated value must be one of [PositionError.PERMISSION_DENIED, PositionError.POSITION_UNAVAILABLE, PositionError.TIMEOUT] but is " + value;
        }

        public static boolean isValid(int value) {
            return 1 == value || 2 == value || 3 == value;
        }

        @Nonnull
        public static String describe(int value) {
            return 1 == value ? "PERMISSION_DENIED" : (2 == value ? "POSITION_UNAVAILABLE" : (3 == value ? "TIMEOUT" : "Unknown value " + value));
        }
    }
}

