/*
 * Decompiled with CFR 0.152.
 */
package akasha.audio;

import java.lang.annotation.Documented;
import javax.annotation.Nonnull;

@Documented
public @interface BiquadFilterType {
    @Nonnull
    public static final String allpass = "allpass";
    @Nonnull
    public static final String bandpass = "bandpass";
    @Nonnull
    public static final String highpass = "highpass";
    @Nonnull
    public static final String highshelf = "highshelf";
    @Nonnull
    public static final String lowpass = "lowpass";
    @Nonnull
    public static final String lowshelf = "lowshelf";
    @Nonnull
    public static final String notch = "notch";
    @Nonnull
    public static final String peaking = "peaking";

    public static final class Util {
        private Util() {
        }

        @BiquadFilterType
        public static String requireValid(String value) {
            Util.assertValid(value);
            return value;
        }

        public static void assertValid(@Nonnull String value) {
            assert (Util.isValid(value));
        }

        public static boolean isValid(@Nonnull String value) {
            return BiquadFilterType.allpass.equals(value) || BiquadFilterType.bandpass.equals(value) || BiquadFilterType.highpass.equals(value) || BiquadFilterType.highshelf.equals(value) || BiquadFilterType.lowpass.equals(value) || BiquadFilterType.lowshelf.equals(value) || BiquadFilterType.notch.equals(value) || BiquadFilterType.peaking.equals(value);
        }
    }
}

