/*
 * Decompiled with CFR 0.152.
 */
package akasha.idb;

import java.lang.annotation.Documented;
import javax.annotation.Nonnull;

@Documented
public @interface IDBTransactionMode {
    @Nonnull
    public static final String readonly = "readonly";
    @Nonnull
    public static final String readwrite = "readwrite";
    @Nonnull
    public static final String versionchange = "versionchange";

    public static final class Util {
        private Util() {
        }

        @IDBTransactionMode
        public static String requireValid(String value) {
            Util.assertValid(value);
            return value;
        }

        public static void assertValid(@Nonnull String value) {
            assert (Util.isValid(value));
        }

        public static boolean isValid(@Nonnull String value) {
            return IDBTransactionMode.readonly.equals(value) || IDBTransactionMode.readwrite.equals(value) || IDBTransactionMode.versionchange.equals(value);
        }
    }
}

