/*
 * Decompiled with CFR 0.152.
 */
package akasha.gpu;

import java.lang.annotation.Documented;
import javax.annotation.Nonnull;
import org.jetbrains.annotations.ApiStatus;

@Documented
@ApiStatus.Experimental
public @interface GPUAddressMode {
    @Nonnull
    public static final String clamp_to_edge = "clamp-to-edge";
    @Nonnull
    public static final String mirror_repeat = "mirror-repeat";
    @Nonnull
    public static final String repeat = "repeat";

    public static final class Util {
        private Util() {
        }

        @GPUAddressMode
        public static String requireValid(String value) {
            Util.assertValid(value);
            return value;
        }

        public static void assertValid(@Nonnull String value) {
            assert (Util.isValid(value));
        }

        public static boolean isValid(@Nonnull String value) {
            return GPUAddressMode.clamp_to_edge.equals(value) || GPUAddressMode.mirror_repeat.equals(value) || GPUAddressMode.repeat.equals(value);
        }
    }
}

