/*
 * Decompiled with CFR 0.152.
 */
package akasha.gpu;

import akasha.gpu.GPUCanvasCompositingAlphaMode;
import akasha.gpu.GPUDevice;
import akasha.gpu.GPUExtent3D;
import akasha.gpu.GPUExtent3DDict;
import akasha.gpu.GPUPredefinedColorSpace;
import akasha.gpu.GPUTextureFormat;
import akasha.lang.JsArray;
import javax.annotation.Nonnull;
import jsinterop.annotations.JsOverlay;
import jsinterop.annotations.JsProperty;
import jsinterop.annotations.JsType;
import jsinterop.base.Js;
import jsinterop.base.JsPropertyMap;
import org.jetbrains.annotations.ApiStatus;

@JsType(isNative=true, namespace="<global>", name="GPUPresentationConfiguration")
@ApiStatus.Experimental
public interface GPUPresentationConfiguration {
    @JsOverlay
    @Nonnull
    public static Builder create(@Nonnull GPUDevice device, @Nonnull @GPUTextureFormat String format) {
        return ((Builder)Js.uncheckedCast((Object)JsPropertyMap.of())).device(device).format(format);
    }

    @JsProperty(name="colorSpace")
    @GPUPredefinedColorSpace
    public String colorSpace();

    @JsProperty
    public void setColorSpace(@Nonnull @GPUPredefinedColorSpace String var1);

    @JsProperty(name="compositingAlphaMode")
    @GPUCanvasCompositingAlphaMode
    public String compositingAlphaMode();

    @JsProperty
    public void setCompositingAlphaMode(@Nonnull @GPUCanvasCompositingAlphaMode String var1);

    @JsProperty(name="device")
    @Nonnull
    public GPUDevice device();

    @JsProperty
    public void setDevice(@Nonnull GPUDevice var1);

    @JsProperty(name="format")
    @Nonnull
    @GPUTextureFormat
    public String format();

    @JsProperty
    public void setFormat(@Nonnull @GPUTextureFormat String var1);

    @JsProperty(name="size")
    public GPUExtent3D size();

    @JsProperty
    public void setSize(@Nonnull GPUExtent3D var1);

    @JsOverlay
    default public void setSize(@Nonnull JsArray<Double> size) {
        this.setSize(GPUExtent3D.of(size));
    }

    @JsOverlay
    default public void setSize(double ... size) {
        this.setSize(GPUExtent3D.of(size));
    }

    @JsOverlay
    default public void setSize(@Nonnull GPUExtent3DDict size) {
        this.setSize(GPUExtent3D.of(size));
    }

    @JsProperty(name="usage")
    public int usage();

    @JsProperty
    public void setUsage(int var1);

    @JsType(isNative=true, namespace="<global>", name="GPUPresentationConfiguration")
    @ApiStatus.Experimental
    public static interface Builder
    extends GPUPresentationConfiguration {
        @JsOverlay
        @Nonnull
        default public Builder colorSpace(@Nonnull @GPUPredefinedColorSpace String colorSpace) {
            this.setColorSpace(colorSpace);
            return this;
        }

        @JsOverlay
        @Nonnull
        default public Builder compositingAlphaMode(@Nonnull @GPUCanvasCompositingAlphaMode String compositingAlphaMode) {
            this.setCompositingAlphaMode(compositingAlphaMode);
            return this;
        }

        @JsOverlay
        @Nonnull
        default public Builder device(@Nonnull GPUDevice device) {
            this.setDevice(device);
            return this;
        }

        @JsOverlay
        @Nonnull
        default public Builder format(@Nonnull @GPUTextureFormat String format) {
            this.setFormat(format);
            return this;
        }

        @JsOverlay
        @Nonnull
        default public Builder size(@Nonnull GPUExtent3D size) {
            this.setSize(size);
            return this;
        }

        @JsOverlay
        @Nonnull
        default public Builder size(@Nonnull JsArray<Double> size) {
            this.setSize(size);
            return this;
        }

        @JsOverlay
        @Nonnull
        default public Builder size(double ... size) {
            this.setSize(size);
            return this;
        }

        @JsOverlay
        @Nonnull
        default public Builder size(@Nonnull GPUExtent3DDict size) {
            this.setSize(size);
            return this;
        }

        @JsOverlay
        @Nonnull
        default public Builder usage(int usage) {
            this.setUsage(usage);
            return this;
        }
    }
}

