/*
 * Decompiled with CFR 0.152.
 */
package akasha.gpu;

import akasha.gpu.GPUExtent3D;
import akasha.gpu.GPUExtent3DDict;
import akasha.gpu.GPUObjectDescriptorBase;
import akasha.gpu.GPUTextureDimension;
import akasha.gpu.GPUTextureFormat;
import akasha.lang.JsArray;
import javax.annotation.Nonnull;
import jsinterop.annotations.JsOverlay;
import jsinterop.annotations.JsProperty;
import jsinterop.annotations.JsType;
import jsinterop.base.Js;
import jsinterop.base.JsPropertyMap;
import org.jetbrains.annotations.ApiStatus;

@JsType(isNative=true, namespace="<global>", name="GPUTextureDescriptor")
@ApiStatus.Experimental
public interface GPUTextureDescriptor
extends GPUObjectDescriptorBase {
    @JsOverlay
    @Nonnull
    public static Builder create(@Nonnull @GPUTextureFormat String format, @Nonnull GPUExtent3D size, int usage) {
        return ((Builder)Js.uncheckedCast((Object)JsPropertyMap.of())).format(format).size(size).usage(usage);
    }

    @JsOverlay
    @Nonnull
    public static Builder create(@Nonnull @GPUTextureFormat String format, @Nonnull JsArray<Double> size, int usage) {
        return ((Builder)Js.uncheckedCast((Object)JsPropertyMap.of())).format(format).size(size).usage(usage);
    }

    @JsOverlay
    @Nonnull
    public static Builder create(@Nonnull @GPUTextureFormat String format, @Nonnull double[] size, int usage) {
        return ((Builder)Js.uncheckedCast((Object)JsPropertyMap.of())).format(format).size(size).usage(usage);
    }

    @JsOverlay
    @Nonnull
    public static Builder create(@Nonnull @GPUTextureFormat String format, @Nonnull GPUExtent3DDict size, int usage) {
        return ((Builder)Js.uncheckedCast((Object)JsPropertyMap.of())).format(format).size(size).usage(usage);
    }

    @JsProperty(name="dimension")
    @GPUTextureDimension
    public String dimension();

    @JsProperty
    public void setDimension(@Nonnull @GPUTextureDimension String var1);

    @JsProperty(name="format")
    @Nonnull
    @GPUTextureFormat
    public String format();

    @JsProperty
    public void setFormat(@Nonnull @GPUTextureFormat String var1);

    @JsProperty(name="mipLevelCount")
    public int mipLevelCount();

    @JsProperty
    public void setMipLevelCount(int var1);

    @JsProperty(name="sampleCount")
    public int sampleCount();

    @JsProperty
    public void setSampleCount(int var1);

    @JsProperty(name="size")
    @Nonnull
    public GPUExtent3D size();

    @JsProperty
    public void setSize(@Nonnull GPUExtent3D var1);

    @JsOverlay
    default public void setSize(@Nonnull JsArray<Double> size) {
        this.setSize(GPUExtent3D.of(size));
    }

    @JsOverlay
    default public void setSize(double ... size) {
        this.setSize(GPUExtent3D.of(size));
    }

    @JsOverlay
    default public void setSize(@Nonnull GPUExtent3DDict size) {
        this.setSize(GPUExtent3D.of(size));
    }

    @JsProperty(name="usage")
    public int usage();

    @JsProperty
    public void setUsage(int var1);

    @JsType(isNative=true, namespace="<global>", name="GPUTextureDescriptor")
    @ApiStatus.Experimental
    public static interface Builder
    extends GPUTextureDescriptor {
        @JsOverlay
        @Nonnull
        default public Builder dimension(@Nonnull @GPUTextureDimension String dimension) {
            this.setDimension(dimension);
            return this;
        }

        @JsOverlay
        @Nonnull
        default public Builder format(@Nonnull @GPUTextureFormat String format) {
            this.setFormat(format);
            return this;
        }

        @JsOverlay
        @Nonnull
        default public Builder mipLevelCount(int mipLevelCount) {
            this.setMipLevelCount(mipLevelCount);
            return this;
        }

        @JsOverlay
        @Nonnull
        default public Builder sampleCount(int sampleCount) {
            this.setSampleCount(sampleCount);
            return this;
        }

        @JsOverlay
        @Nonnull
        default public Builder size(@Nonnull GPUExtent3D size) {
            this.setSize(size);
            return this;
        }

        @JsOverlay
        @Nonnull
        default public Builder size(@Nonnull JsArray<Double> size) {
            this.setSize(size);
            return this;
        }

        @JsOverlay
        @Nonnull
        default public Builder size(double ... size) {
            this.setSize(size);
            return this;
        }

        @JsOverlay
        @Nonnull
        default public Builder size(@Nonnull GPUExtent3DDict size) {
            this.setSize(size);
            return this;
        }

        @JsOverlay
        @Nonnull
        default public Builder usage(int usage) {
            this.setUsage(usage);
            return this;
        }

        @JsOverlay
        @Nonnull
        default public Builder label(@Nonnull String label) {
            this.setLabel(label);
            return this;
        }
    }
}

