/*
 * Decompiled with CFR 0.152.
 */
package akasha.gpu;

import java.lang.annotation.Documented;
import javax.annotation.Nonnull;
import org.jetbrains.annotations.ApiStatus;

@Documented
@ApiStatus.Experimental
public @interface GPUTextureDimension {
    @Nonnull
    public static final String _1d = "1d";
    @Nonnull
    public static final String _2d = "2d";
    @Nonnull
    public static final String _3d = "3d";

    public static final class Util {
        private Util() {
        }

        @GPUTextureDimension
        public static String requireValid(String value) {
            Util.assertValid(value);
            return value;
        }

        public static void assertValid(@Nonnull String value) {
            assert (Util.isValid(value));
        }

        public static boolean isValid(@Nonnull String value) {
            return GPUTextureDimension._1d.equals(value) || GPUTextureDimension._2d.equals(value) || GPUTextureDimension._3d.equals(value);
        }
    }
}

