package akasha.xr;

import akasha.core.JsObject;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsProperty;
import jsinterop.annotations.JsType;

/**
 * The XRRenderState interface of the WebXR Device API contains configurable values which affect how the imagery generated by an XRSession gets composited.
 *
 * @see <a href="https://developer.mozilla.org/en-US/docs/Web/API/XRRenderState">XRRenderState - MDN</a>
 * @see <a href="https://immersive-web.github.io/webxr/#xrrenderstate-interface">XRRenderState - WebXR Device API</a>
 */
@Generated("org.realityforge.webtack")
@JsType(
    isNative = true,
    namespace = JsPackage.GLOBAL,
    name = "XRRenderState"
)
public class XRRenderState extends JsObject {
  protected XRRenderState() {
  }

  /**
   * The read-only baseLayer property of the XRRenderState interface returns the XRWebGLLayer instance that is the source of bitmap images and a description of how the image is to be rendered in the device.
   *
   * @see <a href="https://developer.mozilla.org/en-US/docs/Web/API/XRRenderState/baseLayer">XRRenderState.baseLayer - MDN</a>
   * @see <a href="https://immersive-web.github.io/webxr/#dom-xrrenderstate-baselayer">XRRenderState.baseLayer - WebXR Device API</a>
   */
  @JsProperty(
      name = "baseLayer"
  )
  @Nullable
  public native XRWebGLLayer baseLayer();

  /**
   * The depthFar read-only property of the XRRenderState interface returns the distance in meters of the far clip plane from the viewer.
   *
   * @see <a href="https://developer.mozilla.org/en-US/docs/Web/API/XRRenderState/depthFar">XRRenderState.depthFar - MDN</a>
   */
  @JsProperty(
      name = "depthFar"
  )
  public native double depthFar();

  /**
   * The depthNear read-only property of the XRRenderState interface returns the distance in meters of the near clip plane from the viewer.
   *
   * @see <a href="https://developer.mozilla.org/en-US/docs/Web/API/XRRenderState/depthNear">XRRenderState.depthNear - MDN</a>
   */
  @JsProperty(
      name = "depthNear"
  )
  public native double depthNear();

  /**
   * The read-only inlineVerticalFieldOfView property of the XRRenderState interface returns the default vertical field of view for &quot;inline&quot; sessions and null for all immersive sessions.
   *
   * @see <a href="https://developer.mozilla.org/en-US/docs/Web/API/XRRenderState/inlineVerticalFieldOfView">XRRenderState.inlineVerticalFieldOfView - MDN</a>
   * @see <a href="https://immersive-web.github.io/webxr/#dom-xrrenderstate-inlineVerticalFieldOfView">XRRenderState.inlineVerticalFieldOfView - WebXR Device API</a>
   */
  @JsProperty(
      name = "inlineVerticalFieldOfView"
  )
  @Nullable
  public native Double inlineVerticalFieldOfView();
}
