/*
 * Decompiled with CFR 0.152.
 */
package akasha.gpu;

import java.lang.annotation.Documented;
import javax.annotation.Nonnull;

@Documented
public @interface GPUBufferUsageFlags {

    public static final class Util {
        private Util() {
        }

        @GPUBufferUsageFlags
        public static int requireValid(int value) {
            Util.assertValid(value);
            return value;
        }

        public static void assertValid(int value) {
            assert (Util.isValid(value)) : "@GPUBufferUsageFlags annotated value must be one of [GPUBufferUsage.MAP_READ, GPUBufferUsage.MAP_WRITE, GPUBufferUsage.COPY_SRC, GPUBufferUsage.COPY_DST, GPUBufferUsage.INDEX, GPUBufferUsage.VERTEX, GPUBufferUsage.UNIFORM, GPUBufferUsage.STORAGE, GPUBufferUsage.INDIRECT, GPUBufferUsage.QUERY_RESOLVE] but is " + value;
        }

        public static boolean isValid(int value) {
            return 1 == value || 2 == value || 4 == value || 8 == value || 16 == value || 32 == value || 64 == value || 128 == value || 256 == value || 512 == value;
        }

        @Nonnull
        public static String describe(int value) {
            return 1 == value ? "MAP_READ" : (2 == value ? "MAP_WRITE" : (4 == value ? "COPY_SRC" : (8 == value ? "COPY_DST" : (16 == value ? "INDEX" : (32 == value ? "VERTEX" : (64 == value ? "UNIFORM" : (128 == value ? "STORAGE" : (256 == value ? "INDIRECT" : (512 == value ? "QUERY_RESOLVE" : "Unknown value " + value)))))))));
        }
    }
}

