/*
 * Decompiled with CFR 0.152.
 */
package akasha.gpu;

import java.lang.annotation.Documented;
import javax.annotation.Nonnull;

@Documented
public @interface GPUColorWriteFlags {

    public static final class Util {
        private Util() {
        }

        @GPUColorWriteFlags
        public static int requireValid(int value) {
            Util.assertValid(value);
            return value;
        }

        public static void assertValid(int value) {
            assert (Util.isValid(value)) : "@GPUColorWriteFlags annotated value must be one of [GPUColorWrite.RED, GPUColorWrite.GREEN, GPUColorWrite.BLUE, GPUColorWrite.ALPHA, GPUColorWrite.ALL] but is " + value;
        }

        public static boolean isValid(int value) {
            return 1 == value || 2 == value || 4 == value || 8 == value || 15 == value;
        }

        @Nonnull
        public static String describe(int value) {
            return 1 == value ? "RED" : (2 == value ? "GREEN" : (4 == value ? "BLUE" : (8 == value ? "ALPHA" : (15 == value ? "ALL" : "Unknown value " + value))));
        }
    }
}

