/*
 * Decompiled with CFR 0.152.
 */
package akasha.speech;

import java.lang.annotation.Documented;
import javax.annotation.Nonnull;

@Documented
public @interface SpeechRecognitionErrorCode {
    @Nonnull
    public static final String aborted = "aborted";
    @Nonnull
    public static final String audio_capture = "audio-capture";
    @Nonnull
    public static final String bad_grammar = "bad-grammar";
    @Nonnull
    public static final String language_not_supported = "language-not-supported";
    @Nonnull
    public static final String network = "network";
    @Nonnull
    public static final String no_speech = "no-speech";
    @Nonnull
    public static final String not_allowed = "not-allowed";
    @Nonnull
    public static final String service_not_allowed = "service-not-allowed";

    public static final class Util {
        private Util() {
        }

        @SpeechRecognitionErrorCode
        public static String requireValid(String value) {
            Util.assertValid(value);
            return value;
        }

        public static void assertValid(@Nonnull String value) {
            assert (Util.isValid(value));
        }

        public static boolean isValid(@Nonnull String value) {
            return SpeechRecognitionErrorCode.aborted.equals(value) || SpeechRecognitionErrorCode.audio_capture.equals(value) || SpeechRecognitionErrorCode.bad_grammar.equals(value) || SpeechRecognitionErrorCode.language_not_supported.equals(value) || SpeechRecognitionErrorCode.network.equals(value) || SpeechRecognitionErrorCode.no_speech.equals(value) || SpeechRecognitionErrorCode.not_allowed.equals(value) || SpeechRecognitionErrorCode.service_not_allowed.equals(value);
        }
    }
}

