/*
 * Decompiled with CFR 0.152.
 */
package akasha.crypto;

import akasha.core.BufferSource;
import akasha.core.JsObject;
import akasha.crypto.Algorithm;
import akasha.crypto.AlgorithmIdentifier;
import javax.annotation.Nonnull;
import jsinterop.annotations.JsOverlay;
import jsinterop.annotations.JsProperty;
import jsinterop.annotations.JsType;
import jsinterop.base.Js;
import jsinterop.base.JsPropertyMap;

@JsType(isNative=true, namespace="<global>", name="Pbkdf2Params")
public interface Pbkdf2Params
extends Algorithm {
    @JsOverlay
    @Nonnull
    public static Builder create(@Nonnull String name, @Nonnull AlgorithmIdentifier hash, int iterations, @Nonnull BufferSource salt) {
        return ((Builder)Js.uncheckedCast((Object)JsPropertyMap.of())).name(name).hash(hash).iterations(iterations).salt(salt);
    }

    @JsOverlay
    @Nonnull
    public static Builder create(@Nonnull String name, @Nonnull JsObject hash, int iterations, @Nonnull BufferSource salt) {
        return ((Builder)Js.uncheckedCast((Object)JsPropertyMap.of())).name(name).hash(hash).iterations(iterations).salt(salt);
    }

    @JsOverlay
    @Nonnull
    public static Builder create(@Nonnull String name, @Nonnull String hash, int iterations, @Nonnull BufferSource salt) {
        return ((Builder)Js.uncheckedCast((Object)JsPropertyMap.of())).name(name).hash(hash).iterations(iterations).salt(salt);
    }

    @JsProperty(name="hash")
    @Nonnull
    public AlgorithmIdentifier hash();

    @JsProperty
    public void setHash(@Nonnull AlgorithmIdentifier var1);

    @JsOverlay
    default public void setHash(@Nonnull JsObject hash) {
        this.setHash(AlgorithmIdentifier.of(hash));
    }

    @JsOverlay
    default public void setHash(@Nonnull String hash) {
        this.setHash(AlgorithmIdentifier.of(hash));
    }

    @JsProperty(name="iterations")
    public int iterations();

    @JsProperty
    public void setIterations(int var1);

    @JsProperty(name="salt")
    @Nonnull
    public BufferSource salt();

    @JsProperty
    public void setSalt(@Nonnull BufferSource var1);

    @JsType(isNative=true, namespace="<global>", name="Pbkdf2Params")
    public static interface Builder
    extends Pbkdf2Params {
        @JsOverlay
        @Nonnull
        default public Builder hash(@Nonnull AlgorithmIdentifier hash) {
            this.setHash(hash);
            return this;
        }

        @JsOverlay
        @Nonnull
        default public Builder hash(@Nonnull JsObject hash) {
            this.setHash(hash);
            return this;
        }

        @JsOverlay
        @Nonnull
        default public Builder hash(@Nonnull String hash) {
            this.setHash(hash);
            return this;
        }

        @JsOverlay
        @Nonnull
        default public Builder iterations(int iterations) {
            this.setIterations(iterations);
            return this;
        }

        @JsOverlay
        @Nonnull
        default public Builder salt(@Nonnull BufferSource salt) {
            this.setSalt(salt);
            return this;
        }

        @JsOverlay
        @Nonnull
        default public Builder name(@Nonnull String name) {
            this.setName(name);
            return this;
        }
    }
}

