/*
 * Decompiled with CFR 0.152.
 */
package akasha.gpu;

import java.lang.annotation.Documented;
import javax.annotation.Nonnull;

@Documented
public @interface GPUTextureUsageFlags {

    public static final class Util {
        private Util() {
        }

        @GPUTextureUsageFlags
        public static int requireValid(int value) {
            Util.assertValid(value);
            return value;
        }

        public static void assertValid(int value) {
            assert (Util.isValid(value)) : "@GPUTextureUsageFlags annotated value must be one of [GPUTextureUsage.COPY_SRC, GPUTextureUsage.COPY_DST, GPUTextureUsage.SHADER_READ, GPUTextureUsage.STORAGE, GPUTextureUsage.RENDER_ATTACHMENT] but is " + value;
        }

        public static boolean isValid(int value) {
            return 1 == value || 2 == value || 4 == value || 8 == value || 16 == value;
        }

        @Nonnull
        public static String describe(int value) {
            return 1 == value ? "COPY_SRC" : (2 == value ? "COPY_DST" : (4 == value ? "SHADER_READ" : (8 == value ? "STORAGE" : (16 == value ? "RENDER_ATTACHMENT" : "Unknown value " + value))));
        }
    }
}

