/**
 * @fileoverview
 * @externs
 */
/**
 * @typedef {!AlgorithmIdentifier}
 */
var HashAlgorithmIdentifier;
/**
 * @typedef {(!OffscreenCanvasRenderingContext2D|!ImageBitmapRenderingContext|!WebGLRenderingContext|!WebGL2RenderingContext|!GPUCanvasContext)}
 */
var OffscreenRenderingContext;
/**
 * @typedef {!boolean}
 */
var GLboolean;
/**
 * @typedef {!Array<!UvmEntry>}
 */
var UvmEntries;
/**
 * @typedef {(!Object|!string)}
 */
var AlgorithmIdentifier;
/**
 * @typedef {!number}
 */
var GLubyte;
/**
 * @typedef {?OnBeforeUnloadEventHandler}
 */
var NullableOnBeforeUnloadEventHandler;
/**
 * @typedef {!number}
 */
var GPUIndex32;
/**
 * @typedef {!Array<!PerformanceEntry>}
 */
var PerformanceEntryList;
/**
 * @typedef {!number}
 */
var COSEAlgorithmIdentifier;
/**
 * @typedef {(!Float32Array|!Array<!GLfloat>)}
 */
var Float32List;
/**
 * @typedef {(!GPUSampler|!GPUTextureView|!GPUBufferBinding|!GPUExternalTexture)}
 */
var GPUBindingResource;
/**
 * @typedef {(!EXT_color_buffer_float|!EXT_disjoint_timer_query_webgl2|!EXT_texture_norm16|!OCULUS_multiview|!OVR_multiview2|!WebGLCommonExtension)}
 */
var WebGLExtension;
/**
 * @typedef {(!EXT_color_buffer_half_float|!EXT_float_blend|!KHR_parallel_shader_compile|!EXT_texture_compression_bptc|!EXT_texture_compression_rgtc|!EXT_texture_filter_anisotropic|!OES_texture_float_linear|!OES_texture_half_float_linear|!WEBGL_compressed_texture_astc|!WEBGL_compressed_texture_etc|!WEBGL_compressed_texture_etc1|!WEBGL_compressed_texture_pvrtc|!WEBGL_compressed_texture_s3tc|!WEBGL_compressed_texture_s3tc_srgb|!WEBGL_debug_renderer_info|!WEBGL_debug_shaders|!WEBGL_depth_texture|!WEBGL_lose_context|!WEBGL_multi_draw)}
 */
var WebGLCommonExtension;
/**
 * @typedef {(!Int8Array|!Int16Array|!Int32Array|!Uint8Array|!Uint16Array|!Uint32Array|!Uint8ClampedArray)}
 */
var IntegerTypedArray;
/**
 * @typedef {!number}
 */
var DOMTimeStamp;
/**
 * @typedef {(!ReadableStreamDefaultController|!ReadableByteStreamController)}
 */
var ReadableStreamController;
/**
 * @typedef {(!number|!string)}
 */
var LineAndPositionSetting;
/**
 * @typedef {!number}
 */
var GLuint;
/**
 * @typedef {(!MediaStream|!MediaSource|!Blob)}
 */
var MediaProvider;
/**
 * @typedef {(!string|!number)}
 */
var BluetoothServiceUUID;
/**
 * @typedef {(!BufferSource|!string)}
 */
var PushMessageDataInit;
/**
 * @typedef {!number}
 */
var GPUStencilValue;
/**
 * @typedef {(!string|!number)}
 */
var BluetoothCharacteristicUUID;
/**
 * @typedef {!number}
 */
var GPUSampleMask;
/**
 * @typedef {(!ImageBitmap|!ImageData|!HTMLImageElement|!HTMLCanvasElement|!HTMLVideoElement|!OffscreenCanvas|!VideoFrame)}
 */
var TexImageSource;
/**
 * @typedef {(!string|!number)}
 */
var BluetoothDescriptorUUID;
/**
 * @typedef {!number}
 */
var GPUSize64;
/**
 * @typedef {(!Request|!string)}
 */
var RequestInfo;
/**
 * @typedef {!number}
 */
var Timestamp;
/**
 * @typedef {(!Blob|!BufferSource|!FormData|!URLSearchParams|!string)}
 */
var XMLHttpRequestBodyInit;
/**
 * @typedef {?EventHandler}
 */
var NullableEventHandler;
/**
 * @typedef {!Array<!ClipboardItem>}
 */
var ClipboardItems;
/**
 * @typedef {!number}
 */
var GPUDepthBias;
/**
 * @typedef {(!boolean|!ConstrainBooleanParameters)}
 */
var ConstrainBoolean;
/**
 * @typedef {(!string|!number)}
 */
var StringifySpaceUnionType;
/**
 * @typedef {(!CanvasRenderingContext2D|!ImageBitmapRenderingContext|!WebGLRenderingContext|!WebGL2RenderingContext|!GPUCanvasContext)}
 */
var RenderingContext;
/**
 * @typedef {(!Array<!number>|!GPUColorDict)}
 */
var GPUColor;
/**
 * @typedef {!number}
 */
var GPUSignedOffset32;
/**
 * @typedef {(!BufferSource|!Blob|!string)}
 */
var BlobPart;
/**
 * @typedef {!number}
 */
var GPUBufferDynamicOffset;
/**
 * @typedef {!number}
 */
var GPUFlagsConstant;
/**
 * @typedef {!number}
 */
var GLsizeiptr;
/**
 * @typedef {(!Array<!GPUIntegerCoordinate>|!GPUOrigin2DDict)}
 */
var GPUOrigin2D;
/**
 * @typedef {(!ANGLE_instanced_arrays|!EXT_blend_minmax|!EXT_disjoint_timer_query|!EXT_frag_depth|!EXT_shader_texture_lod|!EXT_sRGB|!OES_fbo_render_mipmap|!OES_element_index_uint|!OES_standard_derivatives|!OES_texture_float|!OES_texture_half_float|!OES_vertex_array_object|!WEBGL_color_buffer_float|!WEBGL_draw_buffers|!WebGLCommonExtension)}
 */
var WebGL1Extension;
/**
 * @typedef {!Window}
 */
var WindowProxy;
/**
 * @typedef {(!number|!ConstrainULongRange)}
 */
var ConstrainULong;
/**
 * @typedef {(!string|!Blob)}
 */
var ClipboardItemDataType;
/**
 * @typedef {(!Array<!Array<!string>>|!Object<!string,!string>)}
 */
var HeadersInit;
/**
 * @typedef {(!number|!ConstrainDoubleRange)}
 */
var ConstrainDouble;
/**
 * @typedef {(!WebGLRenderingContext|!WebGL2RenderingContext)}
 */
var XRWebGLRenderingContext;
/**
 * @typedef {(!number|!Array<!number>)}
 */
var VibratePattern;
/**
 * @typedef {!string}
 */
var UUID;
/**
 * @typedef {(!BufferSource|!ReadableStream)}
 */
var ImageBufferSource;
/**
 * @typedef {!number}
 */
var GPUSize32;
/**
 * @typedef {(!ReadableStream|!XMLHttpRequestBodyInit)}
 */
var BodyInit;
/**
 * @typedef {!string}
 */
var CSSOMString;
/**
 * @typedef {(!CanvasImageSource|!Blob|!ImageData)}
 */
var ImageBitmapSource;
/**
 * @typedef {!number}
 */
var GLshort;
/**
 * @typedef {(!File|!string)}
 */
var FormDataEntryValue;
/**
 * @typedef {(!Array<!GPUIntegerCoordinate>|!GPUExtent3DDict)}
 */
var GPUExtent3D;
/**
 * @typedef {!number}
 */
var GLint64;
/**
 * @typedef {(!GPUOutOfMemoryError|!GPUValidationError)}
 */
var GPUError;
/**
 * @typedef {(!Int32Array|!Array<!GLint>)}
 */
var Int32List;
/**
 * @typedef {(!WindowProxy|!MessagePort|!ServiceWorker)}
 */
var MessageEventSource;
/**
 * @typedef {!number}
 */
var GLushort;
/**
 * @typedef {(!HTMLImageElement|!SVGImageElement)}
 */
var HTMLOrSVGImageElement;
/**
 * @typedef {!Uint8Array}
 */
var BigInteger;
/**
 * @typedef {(!ReadableStreamDefaultReader|!ReadableStreamBYOBReader)}
 */
var ReadableStreamReader;
/**
 * @typedef {!Promise<!ClipboardItemDataType>}
 */
var ClipboardItemData;
/**
 * @typedef {(!HTMLOrSVGImageElement|!HTMLVideoElement|!HTMLCanvasElement|!ImageBitmap|!OffscreenCanvas)}
 */
var CanvasImageSource;
/**
 * @typedef {(!PasswordCredentialData|!HTMLFormElement)}
 */
var PasswordCredentialInit;
/**
 * @typedef {!number}
 */
var GPUIntegerCoordinate;
/**
 * @typedef {?OnErrorEventHandler}
 */
var NullableOnErrorEventHandler;
/**
 * @typedef {!number}
 */
var DOMHighResTimeStamp;
/**
 * @typedef {(!HTMLScriptElement|!SVGScriptElement)}
 */
var HTMLOrSVGScriptElement;
/**
 * @typedef {!number}
 */
var GLfloat;
/**
 * @typedef {!number}
 */
var GLuint64;
/**
 * @typedef {!number}
 */
var GLsizei;
/**
 * @typedef {!string}
 */
var NamedCurve;
/**
 * @typedef {!number}
 */
var GLenum;
/**
 * @typedef {(!Uint32Array|!Array<!GLuint>)}
 */
var Uint32List;
/**
 * @typedef {!number}
 */
var GLbitfield;
/**
 * @typedef {(!Array<!GPUIntegerCoordinate>|!GPUOrigin3DDict)}
 */
var GPUOrigin3D;
/**
 * @typedef {!Array<!number>}
 */
var UvmEntry;
/**
 * @typedef {!number}
 */
var GLint;
/**
 * @typedef {(!string|!Array<!string>|!ConstrainDOMStringParameters)}
 */
var ConstrainDOMString;
/**
 * @typedef {!number}
 */
var GLbyte;
/**
 * @typedef {!number}
 */
var GLuint64EXT;
/**
 * @typedef {!number}
 */
var GPUPipelineConstantValue;
/**
 * @typedef {!number}
 */
var GLclampf;
/**
 * @typedef {!number}
 */
var GLintptr;
/**
 * @typedef {!Array<!Report>}
 */
var ReportList;
/**
 * @typedef {function(!DOMHighResTimeStamp): undefined}
 */
var FrameRequestCallback;
/**
 * @typedef {function(!EncodedVideoChunk,!EncodedVideoChunkMetadata=): undefined}
 */
var EncodedVideoChunkOutputCallback;
/**
 * @typedef {function(): !ClipboardItemData}
 */
var ClipboardItemDelayedCallback;
/**
 * @typedef {function(!IdleDeadline): undefined}
 */
var IdleRequestCallback;
/**
 * @typedef {function(*): undefined}
 */
var PropertyMutatorFunction;
/**
 * @typedef {function(!AudioBuffer): undefined}
 */
var DecodeSuccessCallback;
/**
 * @typedef {function(!DeviceOrientationEvent): undefined}
 */
var DeviceOrientationEventHandler;
/**
 * @typedef {function(!InputEvent): undefined}
 */
var InputEventHandler;
/**
 * @typedef {function(!TrackEvent): undefined}
 */
var TrackEventHandler;
/**
 * @typedef {function(!HashChangeEvent): undefined}
 */
var HashChangeEventHandler;
/**
 * @typedef {function(!string,*): *}
 */
var ParseReviverFn;
/**
 * @typedef {function(!GeolocationPosition): undefined}
 */
var PositionCallback;
/**
 * @typedef {function(*,!TransformStreamDefaultController): !Promise<undefined>}
 */
var TransformerTransformCallback;
/**
 * @typedef {function(!TransformStreamDefaultController): *}
 */
var TransformerStartCallback;
/**
 * @typedef {function(!VideoFrame): undefined}
 */
var VideoFrameOutputCallback;
/**
 * @typedef {function(!AudioData): undefined}
 */
var AudioDataOutputCallback;
/**
 * @typedef {function(!string): undefined}
 */
var FunctionStringCallback;
/**
 * @typedef {function(): *}
 */
var PropertyAccessorFunction;
/**
 * @typedef {function(!WheelEvent): undefined}
 */
var WheelEventHandler;
/**
 * @typedef {function(!RTCPeerConnectionIceErrorEvent): undefined}
 */
var RTCPeerConnectionIceErrorEventHandler;
/**
 * @typedef {function(!OfflineAudioCompletionEvent): undefined}
 */
var OfflineAudioCompletionEventHandler;
/**
 * @typedef {function(!string,!string,!RTCIdentityProviderOptions): !Promise<!RTCIdentityAssertionResult>}
 */
var GenerateAssertionCallback;
/**
 * @typedef {function(!SpeechSynthesisErrorEvent): undefined}
 */
var SpeechSynthesisErrorEventHandler;
/**
 * @typedef {function(!DragEvent): undefined}
 */
var DragEventHandler;
/**
 * @typedef {function(!RTCErrorEvent): undefined}
 */
var RTCErrorEventHandler;
/**
 * @typedef {function(!Array<!IntersectionObserverEntry>,!IntersectionObserver): undefined}
 */
var IntersectionObserverCallback;
/**
 * @typedef {function(): !Promise<undefined>}
 */
var UnderlyingSinkCloseCallback;
/**
 * @typedef {function(*=): !number}
 */
var QueuingStrategySize;
/**
 * @typedef {function(!PageTransitionEvent): undefined}
 */
var PageTransitionEventHandler;
/**
 * @typedef {function(*=): !Promise<undefined>}
 */
var UnderlyingSinkAbortCallback;
/**
 * @typedef {function(!MessageEvent): undefined}
 */
var MessageEventHandler;
/**
 * @typedef {function(!MediaStreamTrackEvent): undefined}
 */
var MediaStreamTrackEventHandler;
/**
 * @typedef {function(!DOMHighResTimeStamp,!XRFrame): undefined}
 */
var XRFrameRequestCallback;
/**
 * @typedef {function(!UIEvent): undefined}
 */
var UIEventHandler;
/**
 * @typedef {function(!DOMException): undefined}
 */
var RTCPeerConnectionErrorCallback;
/**
 * @typedef {function(!SpeechSynthesisEvent): undefined}
 */
var SpeechSynthesisEventHandler;
/**
 * @typedef {function(!Array<!MutationRecord>,!MutationObserver): undefined}
 */
var MutationCallback;
/**
 * @typedef {function(): undefined}
 */
var TimerHandler;
/**
 * @typedef {function(!XRReferenceSpaceEvent): undefined}
 */
var XRReferenceSpaceEventHandler;
/**
 * @typedef {function(!ReadableStreamController): *}
 */
var UnderlyingSourceStartCallback;
/**
 * @typedef {function(!DeviceMotionEvent): undefined}
 */
var DeviceMotionEventHandler;
/**
 * @typedef {function(!RTCSessionDescriptionInit): undefined}
 */
var RTCSessionDescriptionCallback;
/**
 * @typedef {function(!Event): undefined}
 */
var EventHandler;
/**
 * @typedef {function(!SpeechRecognitionEvent): undefined}
 */
var SpeechRecognitionEventHandler;
/**
 * @typedef {function(EventOrStringUnion,!string=,!number=,!number=,*=): undefined}
 */
var OnErrorEventHandler;
/**
 * @typedef {function(?Blob): undefined}
 */
var BlobCallback;
/**
 * @typedef {function(!AnimationEvent): undefined}
 */
var AnimationEventHandler;
/**
 * @typedef {function(!SpeechRecognitionErrorEvent): undefined}
 */
var SpeechRecognitionErrorEventHandler;
/**
 * @typedef {function(!PerformanceObserverEntryList,!PerformanceObserver,!PerformanceObserverCallbackOptions=): undefined}
 */
var PerformanceObserverCallback;
/**
 * @typedef {function(!EncodedAudioChunk,!EncodedAudioChunkMetadata=): undefined}
 */
var EncodedAudioChunkOutputCallback;
/**
 * @typedef {function(!PointerEvent): undefined}
 */
var PointerEventHandler;
/**
 * @typedef {function(!FocusEvent): undefined}
 */
var FocusEventHandler;
/**
 * @typedef {function(!Event): ?string}
 */
var OnBeforeUnloadEventHandler;
/**
 * @typedef {function(!WritableStreamDefaultController): *}
 */
var UnderlyingSinkStartCallback;
/**
 * @typedef {function(!ReadableStreamController): !Promise<undefined>}
 */
var UnderlyingSourcePullCallback;
/**
 * @typedef {function(!DOMException): undefined}
 */
var WebCodecsErrorCallback;
/**
 * @typedef {function(!AudioProcessingEvent): undefined}
 */
var AudioProcessingEventHandler;
/**
 * @typedef {function(!KeyboardEvent): undefined}
 */
var KeyboardEventHandler;
/**
 * @typedef {function(!DOMException): undefined}
 */
var DecodeErrorCallback;
/**
 * @typedef {function(!MouseEvent): undefined}
 */
var MouseEventHandler;
/**
 * @typedef {function(!MediaRecorderErrorEvent): undefined}
 */
var MediaRecorderErrorEventHandler;
/**
 * @typedef {function(!string): undefined}
 */
var NotificationPermissionCallback;
/**
 * @typedef {function(!GeolocationPositionError): undefined}
 */
var PositionErrorCallback;
/**
 * @typedef {function(!RTCPeerConnectionIceEvent): undefined}
 */
var RTCPeerConnectionIceEventHandler;
/**
 * @typedef {function(!Array<!Array<!Float32Array>>,!Array<!Array<!Float32Array>>,!Object): !boolean}
 */
var AudioWorkletProcessCallback;
/**
 * @typedef {function(): !HTMLElement}
 */
var CustomElementConstructor;
/**
 * @typedef {function(*=): !Promise<undefined>}
 */
var UnderlyingSourceCancelCallback;
/**
 * @typedef {function(!RTCDTMFToneChangeEvent): undefined}
 */
var RTCDTMFToneChangeEventHandler;
/**
 * @typedef {function(!GamepadEvent): undefined}
 */
var GamepadEventHandler;
/**
 * @typedef {function(!CloseEvent): undefined}
 */
var CloseEventHandler;
/**
 * @typedef {function(!TransitionEvent): undefined}
 */
var TransitionEventHandler;
/**
 * @typedef {function(!TransformStreamDefaultController): !Promise<undefined>}
 */
var TransformerFlushCallback;
/**
 * @typedef {function(!Array<!Report>,!ReportingObserver): undefined}
 */
var ReportingObserverCallback;
/**
 * @typedef {function(!RTCDataChannelEvent): undefined}
 */
var RTCDataChannelEventHandler;
/**
 * @typedef {function(!PromiseRejectionEvent): undefined}
 */
var PromiseRejectionEventHandler;
/**
 * @typedef {function(!string,!string): !Promise<!RTCIdentityValidationResult>}
 */
var ValidateAssertionCallback;
/**
 * @typedef {function(!TouchEvent): undefined}
 */
var TouchEventHandler;
/**
 * @typedef {function(!ProgressEvent): undefined}
 */
var ProgressEventHandler;
/**
 * @typedef {function(!StorageEvent): undefined}
 */
var StorageEventHandler;
/**
 * @typedef {function(!string,*): *}
 */
var StringifyReplacerFn;
/**
 * @typedef {function(): undefined}
 */
var VoidFunction;
/**
 * @typedef {function(*,!WritableStreamDefaultController): !Promise<undefined>}
 */
var UnderlyingSinkWriteCallback;
/**
 * @typedef {function(!RTCTrackEvent): undefined}
 */
var RTCTrackEventHandler;
/**
 * @typedef {function(!ClipboardEvent): undefined}
 */
var ClipboardEventHandler;
/**
 * @typedef {function(!IDBVersionChangeEvent): undefined}
 */
var IDBVersionChangeEventHandler;
/**
 * @interface
 */
function KeyboardEventListener() {}
/**
 * @param {!KeyboardEvent} event
 * @return {undefined}
 */
KeyboardEventListener.prototype.handleEvent = function(event) {}
/**
 * @interface
 */
function HashChangeEventListener() {}
/**
 * @param {!HashChangeEvent} event
 * @return {undefined}
 */
HashChangeEventListener.prototype.handleEvent = function(event) {}
/**
 * @interface
 */
function ProgressEventListener() {}
/**
 * @param {!ProgressEvent} event
 * @return {undefined}
 */
ProgressEventListener.prototype.handleEvent = function(event) {}
/**
 * @interface
 */
function MediaRecorderErrorEventListener() {}
/**
 * @param {!MediaRecorderErrorEvent} event
 * @return {undefined}
 */
MediaRecorderErrorEventListener.prototype.handleEvent = function(event) {}
/**
 * @interface
 */
function SpeechRecognitionErrorEventListener() {}
/**
 * @param {!SpeechRecognitionErrorEvent} event
 * @return {undefined}
 */
SpeechRecognitionErrorEventListener.prototype.handleEvent = function(event) {}
/**
 * @interface
 */
function RTCPeerConnectionIceErrorEventListener() {}
/**
 * @param {!RTCPeerConnectionIceErrorEvent} event
 * @return {undefined}
 */
RTCPeerConnectionIceErrorEventListener.prototype.handleEvent = function(event) {}
/**
 * @interface
 */
function FormDataEventListener() {}
/**
 * @param {!FormDataEvent} event
 * @return {undefined}
 */
FormDataEventListener.prototype.handleEvent = function(event) {}
/**
 * @interface
 */
function CloseEventListener() {}
/**
 * @param {!CloseEvent} event
 * @return {undefined}
 */
CloseEventListener.prototype.handleEvent = function(event) {}
/**
 * @interface
 */
function XPathNSResolver() {}
/**
 * @param {?string} prefix
 * @return {?string}
 */
XPathNSResolver.prototype.lookupNamespaceURI = function(prefix) {}
/**
 * @interface
 */
function UIEventListener() {}
/**
 * @param {!UIEvent} event
 * @return {undefined}
 */
UIEventListener.prototype.handleEvent = function(event) {}
/**
 * @interface
 */
function PageTransitionEventListener() {}
/**
 * @param {!PageTransitionEvent} event
 * @return {undefined}
 */
PageTransitionEventListener.prototype.handleEvent = function(event) {}
/**
 * @interface
 */
function PointerEventListener() {}
/**
 * @param {!PointerEvent} event
 * @return {undefined}
 */
PointerEventListener.prototype.handleEvent = function(event) {}
/**
 * @interface
 */
function AnimationEventListener() {}
/**
 * @param {!AnimationEvent} event
 * @return {undefined}
 */
AnimationEventListener.prototype.handleEvent = function(event) {}
/**
 * @interface
 */
function RTCPeerConnectionIceEventListener() {}
/**
 * @param {!RTCPeerConnectionIceEvent} event
 * @return {undefined}
 */
RTCPeerConnectionIceEventListener.prototype.handleEvent = function(event) {}
/**
 * @interface
 */
function WebGLContextEventListener() {}
/**
 * @param {!WebGLContextEvent} event
 * @return {undefined}
 */
WebGLContextEventListener.prototype.handleEvent = function(event) {}
/**
 * @interface
 */
function EventListener() {}
/**
 * @param {!Event} event
 * @return {undefined}
 */
EventListener.prototype.handleEvent = function(event) {}
/**
 * @interface
 */
function ValueEventListener() {}
/**
 * @param {!ValueEvent} event
 * @return {undefined}
 */
ValueEventListener.prototype.handleEvent = function(event) {}
/**
 * @interface
 */
function RTCDTMFToneChangeEventListener() {}
/**
 * @param {!RTCDTMFToneChangeEvent} event
 * @return {undefined}
 */
RTCDTMFToneChangeEventListener.prototype.handleEvent = function(event) {}
/**
 * @interface
 */
function RTCTrackEventListener() {}
/**
 * @param {!RTCTrackEvent} event
 * @return {undefined}
 */
RTCTrackEventListener.prototype.handleEvent = function(event) {}
/**
 * @interface
 */
function InputEventListener() {}
/**
 * @param {!InputEvent} event
 * @return {undefined}
 */
InputEventListener.prototype.handleEvent = function(event) {}
/**
 * @interface
 */
function MediaStreamTrackEventListener() {}
/**
 * @param {!MediaStreamTrackEvent} event
 * @return {undefined}
 */
MediaStreamTrackEventListener.prototype.handleEvent = function(event) {}
/**
 * @interface
 */
function DeviceOrientationEventListener() {}
/**
 * @param {!DeviceOrientationEvent} event
 * @return {undefined}
 */
DeviceOrientationEventListener.prototype.handleEvent = function(event) {}
/**
 * @interface
 */
function FocusEventListener() {}
/**
 * @param {!FocusEvent} event
 * @return {undefined}
 */
FocusEventListener.prototype.handleEvent = function(event) {}
/**
 * @interface
 */
function SpeechSynthesisErrorEventListener() {}
/**
 * @param {!SpeechSynthesisErrorEvent} event
 * @return {undefined}
 */
SpeechSynthesisErrorEventListener.prototype.handleEvent = function(event) {}
/**
 * @interface
 */
function StorageEventListener() {}
/**
 * @param {!StorageEvent} event
 * @return {undefined}
 */
StorageEventListener.prototype.handleEvent = function(event) {}
/**
 * @interface
 */
function MessageEventListener() {}
/**
 * @param {!MessageEvent} event
 * @return {undefined}
 */
MessageEventListener.prototype.handleEvent = function(event) {}
/**
 * @interface
 */
function CompositionEventListener() {}
/**
 * @param {!CompositionEvent} event
 * @return {undefined}
 */
CompositionEventListener.prototype.handleEvent = function(event) {}
/**
 * @interface
 */
function SpeechSynthesisEventListener() {}
/**
 * @param {!SpeechSynthesisEvent} event
 * @return {undefined}
 */
SpeechSynthesisEventListener.prototype.handleEvent = function(event) {}
/**
 * @interface
 */
function TrackEventListener() {}
/**
 * @param {!TrackEvent} event
 * @return {undefined}
 */
TrackEventListener.prototype.handleEvent = function(event) {}
/**
 * @interface
 */
function WheelEventListener() {}
/**
 * @param {!WheelEvent} event
 * @return {undefined}
 */
WheelEventListener.prototype.handleEvent = function(event) {}
/**
 * @interface
 */
function OfflineAudioCompletionEventListener() {}
/**
 * @param {!OfflineAudioCompletionEvent} event
 * @return {undefined}
 */
OfflineAudioCompletionEventListener.prototype.handleEvent = function(event) {}
/**
 * @interface
 */
function GamepadEventListener() {}
/**
 * @param {!GamepadEvent} event
 * @return {undefined}
 */
GamepadEventListener.prototype.handleEvent = function(event) {}
/**
 * @interface
 */
function MouseEventListener() {}
/**
 * @param {!MouseEvent} event
 * @return {undefined}
 */
MouseEventListener.prototype.handleEvent = function(event) {}
/**
 * @interface
 */
function DragEventListener() {}
/**
 * @param {!DragEvent} event
 * @return {undefined}
 */
DragEventListener.prototype.handleEvent = function(event) {}
/**
 * @interface
 */
function BluetoothAdvertisingEventListener() {}
/**
 * @param {!BluetoothAdvertisingEvent} event
 * @return {undefined}
 */
BluetoothAdvertisingEventListener.prototype.handleEvent = function(event) {}
/**
 * @interface
 */
function PromiseRejectionEventListener() {}
/**
 * @param {!PromiseRejectionEvent} event
 * @return {undefined}
 */
PromiseRejectionEventListener.prototype.handleEvent = function(event) {}
/**
 * @interface
 */
function IDBVersionChangeEventListener() {}
/**
 * @param {!IDBVersionChangeEvent} event
 * @return {undefined}
 */
IDBVersionChangeEventListener.prototype.handleEvent = function(event) {}
/**
 * @interface
 */
function SubmitEventListener() {}
/**
 * @param {!SubmitEvent} event
 * @return {undefined}
 */
SubmitEventListener.prototype.handleEvent = function(event) {}
/**
 * @interface
 */
function TouchEventListener() {}
/**
 * @param {!TouchEvent} event
 * @return {undefined}
 */
TouchEventListener.prototype.handleEvent = function(event) {}
/**
 * @interface
 */
function AudioProcessingEventListener() {}
/**
 * @param {!AudioProcessingEvent} event
 * @return {undefined}
 */
AudioProcessingEventListener.prototype.handleEvent = function(event) {}
/**
 * @interface
 */
function XRReferenceSpaceEventListener() {}
/**
 * @param {!XRReferenceSpaceEvent} event
 * @return {undefined}
 */
XRReferenceSpaceEventListener.prototype.handleEvent = function(event) {}
/**
 * @interface
 */
function DeviceMotionEventListener() {}
/**
 * @param {!DeviceMotionEvent} event
 * @return {undefined}
 */
DeviceMotionEventListener.prototype.handleEvent = function(event) {}
/**
 * @interface
 */
function SpeechRecognitionEventListener() {}
/**
 * @param {!SpeechRecognitionEvent} event
 * @return {undefined}
 */
SpeechRecognitionEventListener.prototype.handleEvent = function(event) {}
/**
 * @interface
 */
function ClipboardEventListener() {}
/**
 * @param {!ClipboardEvent} event
 * @return {undefined}
 */
ClipboardEventListener.prototype.handleEvent = function(event) {}
/**
 * @interface
 */
function TransitionEventListener() {}
/**
 * @param {!TransitionEvent} event
 * @return {undefined}
 */
TransitionEventListener.prototype.handleEvent = function(event) {}
/**
 * @interface
 */
function RTCDataChannelEventListener() {}
/**
 * @param {!RTCDataChannelEvent} event
 * @return {undefined}
 */
RTCDataChannelEventListener.prototype.handleEvent = function(event) {}
/**
 * @interface
 */
function NodeFilter() {}
/** @const {!number} */ NodeFilter.FILTER_ACCEPT;
/** @const {!number} */ NodeFilter.FILTER_REJECT;
/** @const {!number} */ NodeFilter.FILTER_SKIP;
/** @const {!number} */ NodeFilter.SHOW_ALL;
/** @const {!number} */ NodeFilter.SHOW_ATTRIBUTE;
/** @const {!number} */ NodeFilter.SHOW_CDATA_SECTION;
/** @const {!number} */ NodeFilter.SHOW_COMMENT;
/** @const {!number} */ NodeFilter.SHOW_DOCUMENT;
/** @const {!number} */ NodeFilter.SHOW_DOCUMENT_FRAGMENT;
/** @const {!number} */ NodeFilter.SHOW_DOCUMENT_TYPE;
/** @const {!number} */ NodeFilter.SHOW_ELEMENT;
/** @const {!number} */ NodeFilter.SHOW_ENTITY;
/** @const {!number} */ NodeFilter.SHOW_ENTITY_REFERENCE;
/** @const {!number} */ NodeFilter.SHOW_NOTATION;
/** @const {!number} */ NodeFilter.SHOW_PROCESSING_INSTRUCTION;
/** @const {!number} */ NodeFilter.SHOW_TEXT;
/**
 * @param {!Node} node
 * @return {!number}
 */
NodeFilter.prototype.acceptNode = function(node) {}
/**
 * @interface
 */
function RTCErrorEventListener() {}
/**
 * @param {!RTCErrorEvent} event
 * @return {undefined}
 */
RTCErrorEventListener.prototype.handleEvent = function(event) {}
/**
 * @typedef {{attestation:(!string|undefined),authenticatorSelection:(!AuthenticatorSelectionCriteria|undefined),challenge:!BufferSource,excludeCredentials:(!Array<!PublicKeyCredentialDescriptor>|undefined),extensions:(!AuthenticationExtensionsClientInputs|undefined),pubKeyCredParams:!Array<!PublicKeyCredentialParameters>,rp:!PublicKeyCredentialRpEntity,timeout:(!number|undefined),user:!PublicKeyCredentialUserEntity}}
 */
var PublicKeyCredentialCreationOptions;
/**
 * @typedef {{error:!WebCodecsErrorCallback,output:!EncodedAudioChunkOutputCallback}}
 */
var AudioEncoderInit;
/**
 * @typedef {{hash:!KeyAlgorithm,modulusLength:!number,publicExponent:!BigInteger,name:!string}}
 */
var RsaHashedKeyAlgorithm;
/**
 * @typedef {{message:!ArrayBuffer,messageType:!string,bubbles:(!boolean|undefined),cancelable:(!boolean|undefined),composed:(!boolean|undefined)}}
 */
var MediaKeyMessageEventInit;
/**
 * @typedef {{track:(?VideoTrackOrAudioTrackOrTextTrackUnion|undefined),bubbles:(!boolean|undefined),cancelable:(!boolean|undefined),composed:(!boolean|undefined)}}
 */
var TrackEventInit;
/**
 * @typedef {{includeUncontrolled:(!boolean|undefined),type:(!string|undefined)}}
 */
var ClientQueryOptions;
/**
 * @typedef {{advanced:(!Array<!MediaTrackConstraintSet>|undefined),aspectRatio:(!ConstrainDouble|undefined),autoGainControl:(!ConstrainBoolean|undefined),channelCount:(!ConstrainULong|undefined),deviceId:(!ConstrainDOMString|undefined),echoCancellation:(!ConstrainBoolean|undefined),facingMode:(!ConstrainDOMString|undefined),frameRate:(!ConstrainDouble|undefined),groupId:(!ConstrainDOMString|undefined),height:(!ConstrainULong|undefined),latency:(!ConstrainDouble|undefined),noiseSuppression:(!ConstrainBoolean|undefined),resizeMode:(!ConstrainDOMString|undefined),sampleRate:(!ConstrainULong|undefined),sampleSize:(!ConstrainULong|undefined),width:(!ConstrainULong|undefined),cursor:(!ConstrainDOMString|undefined),displaySurface:(!ConstrainDOMString|undefined),logicalSurface:(!ConstrainBoolean|undefined),restrictOwnAudio:(!ConstrainBoolean|undefined),suppressLocalAudioPlayback:(!ConstrainBoolean|undefined)}}
 */
var MediaTrackConstraints;
/**
 * @typedef {{length:!number,numberOfChannels:(!number|undefined),sampleRate:!number}}
 */
var AudioBufferOptions;
/**
 * @typedef {{referenceSpace:!XRReferenceSpace,transform:(?XRRigidTransform|undefined),bubbles:(!boolean|undefined),cancelable:(!boolean|undefined),composed:(!boolean|undefined)}}
 */
var XRReferenceSpaceEventInit;
/**
 * @typedef {{hash:!HashAlgorithmIdentifier,length:(!number|undefined),name:!string}}
 */
var HmacKeyGenParams;
/**
 * @typedef {{targetOrigin:(!string|undefined),transfer:(!Array<!Transferable>|undefined)}}
 */
var WindowPostMessageOptions;
/**
 * @typedef {{rid:(!string|undefined)}}
 */
var RTCRtpCodingParameters;
/**
 * @typedef {{bitrate:(!number|undefined),codec:!string,numberOfChannels:(!number|undefined),sampleRate:(!number|undefined)}}
 */
var AudioEncoderConfig;
/**
 * @typedef {{droppedEntriesCount:(!number|undefined)}}
 */
var PerformanceObserverCallbackOptions;
/**
 * @typedef {{config:(!AudioDecoderConfig|undefined),supported:(!boolean|undefined)}}
 */
var AudioDecoderSupport;
/**
 * @typedef {{layout:!GPUBindGroupLayout,entries:!Array<!GPUBindGroupEntry>,label:(!string|undefined)}}
 */
var GPUBindGroupDescriptor;
/**
 * @typedef {{state:(*|undefined),bubbles:(!boolean|undefined),cancelable:(!boolean|undefined),composed:(!boolean|undefined)}}
 */
var PopStateEventInit;
/**
 * @typedef {{device:!GPUDevice,format:!string,colorSpace:(!string|undefined),compositingAlphaMode:(!string|undefined),size:(!GPUExtent3D|undefined),usage:(!GPUFlagsConstant|undefined)}}
 */
var GPUCanvasConfiguration;
/**
 * @typedef {{lastModified:(!number|undefined),endings:(!string|undefined),type:(!string|undefined)}}
 */
var FilePropertyBag;
/**
 * @typedef {{endpoint:(!string|undefined),expirationTime:(?DOMTimeStamp|undefined),keys:(!Object<!string,!string>|undefined)}}
 */
var PushSubscriptionJSON;
/**
 * @typedef {{aspectRatio:(!number|undefined),autoGainControl:(!boolean|undefined),channelCount:(!number|undefined),deviceId:(!string|undefined),echoCancellation:(!boolean|undefined),facingMode:(!string|undefined),frameRate:(!number|undefined),groupId:(!string|undefined),height:(!number|undefined),latency:(!number|undefined),noiseSuppression:(!boolean|undefined),resizeMode:(!string|undefined),sampleRate:(!number|undefined),sampleSize:(!number|undefined),width:(!number|undefined),cursor:(!string|undefined),displaySurface:(!string|undefined),logicalSurface:(!boolean|undefined),restrictOwnAudio:(!boolean|undefined)}}
 */
var MediaTrackSettings;
/**
 * @typedef {{lengthComputable:(!boolean|undefined),loaded:(!number|undefined),total:(!number|undefined),bubbles:(!boolean|undefined),cancelable:(!boolean|undefined),composed:(!boolean|undefined)}}
 */
var ProgressEventInit;
/**
 * @typedef {{id:(!string|undefined),name:!string}}
 */
var PublicKeyCredentialRpEntity;
/**
 * @typedef {{colorAttachments:!Array<!GPURenderPassColorAttachment>,depthStencilAttachment:(!GPURenderPassDepthStencilAttachment|undefined),occlusionQuerySet:(!GPUQuerySet|undefined),label:(!string|undefined)}}
 */
var GPURenderPassDescriptor;
/**
 * @typedef {{concealedSamples:(!number|undefined),concealmentEvents:(!number|undefined),estimatedPlayoutTimestamp:(!DOMHighResTimeStamp|undefined),insertedSamplesForDeceleration:(!number|undefined),jitterBufferDelay:(!number|undefined),jitterBufferEmittedCount:(!number|undefined),removedSamplesForAcceleration:(!number|undefined),silentConcealedSamples:(!number|undefined),totalSamplesReceived:(!number|undefined),audioLevel:(!number|undefined),totalAudioEnergy:(!number|undefined),totalSamplesDuration:(!number|undefined),voiceActivityFlag:(!boolean|undefined),ended:(!boolean|undefined),kind:!string,trackIdentifier:(!string|undefined),priority:(!string|undefined),remoteSource:(!boolean|undefined),id:!string,timestamp:!DOMHighResTimeStamp,type:!string}}
 */
var RTCAudioReceiverStats;
/**
 * @typedef {{channelCount:(!number|undefined),channelCountMode:(!string|undefined),channelInterpretation:(!string|undefined)}}
 */
var AudioNodeOptions;
/**
 * @typedef {{x:(!GPUIntegerCoordinate|undefined),y:(!GPUIntegerCoordinate|undefined),z:(!GPUIntegerCoordinate|undefined)}}
 */
var GPUOrigin3DDict;
/**
 * @typedef {{autoIncrement:(!boolean|undefined),keyPath:(?StringOrStringArrayUnion|undefined)}}
 */
var IDBObjectStoreParameters;
/**
 * @typedef {{start:(!UnderlyingSourceStartCallback|undefined),pull:(!UnderlyingSourcePullCallback|undefined),cancel:(!UnderlyingSourceCancelCallback|undefined),type:(!string|undefined),autoAllocateChunkSize:(!number|undefined)}}
 */
var UnderlyingSource;
/**
 * @typedef {{channels:(!number|undefined),clockRate:!number,mimeType:!string,sdpFmtpLine:(!string|undefined)}}
 */
var RTCRtpCodecCapability;
/**
 * @typedef {{frame:!XRFrame,inputSource:!XRInputSource,bubbles:(!boolean|undefined),cancelable:(!boolean|undefined),composed:(!boolean|undefined)}}
 */
var XRInputSourceEventInit;
/**
 * @typedef {{highWaterMark:!number}}
 */
var QueuingStrategyInit;
/**
 * @typedef {{height:(!number|undefined),width:(!number|undefined),x:(!number|undefined),y:(!number|undefined)}}
 */
var DOMRectInit;
/**
 * @typedef {{userVisibleOnly:(!boolean|undefined),name:!string}}
 */
var PushPermissionDescriptor;
/**
 * @typedef {{charIndex:(!number|undefined),charLength:(!number|undefined),elapsedTime:(!number|undefined),name:(!string|undefined),utterance:!SpeechSynthesisUtterance,bubbles:(!boolean|undefined),cancelable:(!boolean|undefined),composed:(!boolean|undefined)}}
 */
var SpeechSynthesisEventInit;
/**
 * @typedef {{codec:!string,codedHeight:(!number|undefined),codedWidth:(!number|undefined),description:(!BufferSource|undefined),displayAspectHeight:(!number|undefined),displayAspectWidth:(!number|undefined),hardwareAcceleration:(!string|undefined)}}
 */
var VideoDecoderConfig;
/**
 * @typedef {{codecs:!Array<!RTCRtpCodecParameters>,headerExtensions:!Array<!RTCRtpHeaderExtensionParameters>,rtcp:!RTCRtcpParameters}}
 */
var RTCRtpParameters;
/**
 * @typedef {{congestionWindow:(!number|undefined),mtu:(!number|undefined),receiverWindow:(!number|undefined),smoothedRoundTripTime:(!number|undefined),transportId:(!string|undefined),unackData:(!number|undefined),id:!string,timestamp:!DOMHighResTimeStamp,type:!string}}
 */
var RTCSctpTransportStats;
/**
 * @typedef {{saltLength:!number,name:!string}}
 */
var RsaPssParams;
/**
 * @typedef {{contentType:(!string|undefined),robustness:(!string|undefined)}}
 */
var MediaKeySystemMediaCapability;
/**
 * @typedef {{aspectRatio:(!DoubleRange|undefined),autoGainControl:(!Array<!boolean>|undefined),channelCount:(!ULongRange|undefined),deviceId:(!string|undefined),echoCancellation:(!Array<!boolean>|undefined),facingMode:(!Array<!string>|undefined),frameRate:(!DoubleRange|undefined),groupId:(!string|undefined),height:(!ULongRange|undefined),latency:(!DoubleRange|undefined),noiseSuppression:(!Array<!boolean>|undefined),resizeMode:(!Array<!string>|undefined),sampleRate:(!ULongRange|undefined),sampleSize:(!ULongRange|undefined),width:(!ULongRange|undefined),cursor:(!Array<!string>|undefined),displaySurface:(!string|undefined),logicalSurface:(!boolean|undefined)}}
 */
var MediaTrackCapabilities;
/**
 * @typedef {{privateKey:(!CryptoKey|undefined),publicKey:(!CryptoKey|undefined)}}
 */
var CryptoKeyPair;
/**
 * @typedef {{offset:(!number|undefined)}}
 */
var ConstantSourceOptions;
/**
 * @typedef {{layout:(!Array<!PlaneLayout>|undefined),rect:(!VideoFrameRect|undefined)}}
 */
var VideoFrameCopyToOptions;
/**
 * @typedef {{newURL:(!string|undefined),oldURL:(!string|undefined),bubbles:(!boolean|undefined),cancelable:(!boolean|undefined),composed:(!boolean|undefined)}}
 */
var HashChangeEventInit;
/**
 * @typedef {{data:!BufferSource,offset:(!number|undefined),stride:!number}}
 */
var PlaneInit;
/**
 * @typedef {{data:!BufferSource,timestamp:!number,type:!string}}
 */
var EncodedAudioChunkInit;
/**
 * @typedef {{quota:(!number|undefined),usage:(!number|undefined)}}
 */
var StorageEstimate;
/**
 * @typedef {{audio:(!BooleanOrMediaTrackConstraintsUnion|undefined),video:(!BooleanOrMediaTrackConstraintsUnion|undefined),peerIdentity:(!string|undefined)}}
 */
var MediaStreamConstraints;
/**
 * @typedef {{exact:(!number|undefined),ideal:(!number|undefined),max:(!number|undefined),min:(!number|undefined)}}
 */
var ConstrainDoubleRange;
/**
 * @typedef {{source:!HTMLVideoElement,colorSpace:(!string|undefined),label:(!string|undefined)}}
 */
var GPUExternalTextureDescriptor;
/**
 * @typedef {{length:!number,name:!string}}
 */
var AesKeyGenParams;
/**
 * @typedef {{button:(!number|undefined),buttons:(!number|undefined),relatedTarget:(?EventTarget|undefined),clientX:(!number|undefined),clientY:(!number|undefined),screenX:(!number|undefined),screenY:(!number|undefined),movementX:(!number|undefined),movementY:(!number|undefined),altKey:(!boolean|undefined),ctrlKey:(!boolean|undefined),metaKey:(!boolean|undefined),modifierAltGraph:(!boolean|undefined),modifierCapsLock:(!boolean|undefined),modifierFn:(!boolean|undefined),modifierFnLock:(!boolean|undefined),modifierHyper:(!boolean|undefined),modifierNumLock:(!boolean|undefined),modifierScrollLock:(!boolean|undefined),modifierSuper:(!boolean|undefined),modifierSymbol:(!boolean|undefined),modifierSymbolLock:(!boolean|undefined),shiftKey:(!boolean|undefined),detail:(!number|undefined),view:(?Window|undefined),bubbles:(!boolean|undefined),cancelable:(!boolean|undefined),composed:(!boolean|undefined)}}
 */
var MouseEventInit;
/**
 * @typedef {{id:!string}}
 */
var CredentialData;
/**
 * @typedef {{ignoreMethod:(!boolean|undefined),ignoreSearch:(!boolean|undefined),ignoreVary:(!boolean|undefined)}}
 */
var CacheQueryOptions;
/**
 * @typedef {{imag:(!Array<!number>|undefined),real:(!Array<!number>|undefined),disableNormalization:(!boolean|undefined)}}
 */
var PeriodicWaveOptions;
/**
 * @typedef {{label:(!BufferSource|undefined),name:!string}}
 */
var RsaOaepParams;
/**
 * @typedef {{code:(!number|undefined),reason:(!string|undefined),wasClean:(!boolean|undefined),bubbles:(!boolean|undefined),cancelable:(!boolean|undefined),composed:(!boolean|undefined)}}
 */
var CloseEventInit;
/**
 * @typedef {{compute:!GPUProgrammableStage,layout:(!GPUPipelineLayout|undefined),label:(!string|undefined)}}
 */
var GPUComputePipelineDescriptor;
/**
 * @typedef {{optionalFeatures:(!Array<*>|undefined),requiredFeatures:(!Array<*>|undefined)}}
 */
var XRSessionInit;
/**
 * @typedef {{p1:(!DOMPointInit|undefined),p2:(!DOMPointInit|undefined),p3:(!DOMPointInit|undefined),p4:(!DOMPointInit|undefined)}}
 */
var DOMQuadInit;
/**
 * @typedef {{audioLevel:(!number|undefined),averageRtcpInterval:(!number|undefined),bytesReceived:(!number|undefined),concealedSamples:(!number|undefined),concealmentEvents:(!number|undefined),decoderImplementation:(!string|undefined),estimatedPlayoutTimestamp:(!DOMHighResTimeStamp|undefined),fecPacketsDiscarded:(!number|undefined),fecPacketsReceived:(!number|undefined),firCount:(!number|undefined),frameBitDepth:(!number|undefined),frameHeight:(!number|undefined),frameWidth:(!number|undefined),framesDecoded:(!number|undefined),framesPerSecond:(!number|undefined),framesReceived:(!number|undefined),headerBytesReceived:(!number|undefined),insertedSamplesForDeceleration:(!number|undefined),jitterBufferDelay:(!number|undefined),jitterBufferEmittedCount:(!number|undefined),keyFramesDecoded:(!number|undefined),lastPacketReceivedTimestamp:(!DOMHighResTimeStamp|undefined),nackCount:(!number|undefined),packetsDuplicated:(!number|undefined),packetsFailedDecryption:(!number|undefined),perDscpPacketsReceived:(!Object<!string,!number>|undefined),pliCount:(!number|undefined),qpSum:(!number|undefined),receiverId:!string,remoteId:(!string|undefined),removedSamplesForAcceleration:(!number|undefined),samplesDecodedWithCelt:(!number|undefined),samplesDecodedWithSilk:(!number|undefined),silentConcealedSamples:(!number|undefined),sliCount:(!number|undefined),totalAudioEnergy:(!number|undefined),totalDecodeTime:(!number|undefined),totalInterFrameDelay:(!number|undefined),totalProcessingDelay:(!number|undefined),totalSamplesDecoded:(!number|undefined),totalSamplesDuration:(!number|undefined),totalSamplesReceived:(!number|undefined),totalSquaredInterFrameDelay:(!number|undefined),voiceActivityFlag:(!boolean|undefined),fractionLost:(!number|undefined),trackId:(!string|undefined),burstDiscardCount:(!number|undefined),burstDiscardRate:(!number|undefined),burstLossCount:(!number|undefined),burstLossRate:(!number|undefined),burstPacketsDiscarded:(!number|undefined),burstPacketsLost:(!number|undefined),framesDropped:(!number|undefined),fullFramesLost:(!number|undefined),gapDiscardRate:(!number|undefined),gapLossRate:(!number|undefined),jitter:(!number|undefined),packetsDiscarded:(!number|undefined),packetsLost:(!number|undefined),packetsReceived:(!number|undefined),packetsRepaired:(!number|undefined),partialFramesLost:(!number|undefined),codecId:(!string|undefined),kind:!string,ssrc:!number,transportId:(!string|undefined),averageRTCPInterval:(!number|undefined),mediaType:(!string|undefined),id:!string,timestamp:!DOMHighResTimeStamp,type:!string}}
 */
var RTCInboundRtpStreamStats;
/**
 * @typedef {{matches:(!boolean|undefined),media:(!CSSOMString|undefined),bubbles:(!boolean|undefined),cancelable:(!boolean|undefined),composed:(!boolean|undefined)}}
 */
var MediaQueryListEventInit;
/**
 * @typedef {{candidate:(!string|undefined),sdpMLineIndex:(?number|undefined),sdpMid:(?string|undefined),usernameFragment:(?string|undefined)}}
 */
var RTCIceCandidateInit;
/**
 * @typedef {{iconURL:(!string|undefined),name:(!string|undefined),origin:!string,protocol:(!string|undefined),provider:!string,id:!string}}
 */
var FederatedCredentialInit;
/**
 * @typedef {{targets:!Array<!GPUColorTargetState>,module:!GPUShaderModule,entryPoint:!string,constants:(!Object<!string,!GPUPipelineConstantValue>|undefined)}}
 */
var GPUFragmentState;
/**
 * @typedef {{descriptor:!PermissionDescriptor,oneRealm:(!boolean|undefined),state:!string}}
 */
var PermissionSetParameters;
/**
 * @typedef {{kind:!string,relayedSource:(!boolean|undefined),trackIdentifier:!string,id:!string,timestamp:!DOMHighResTimeStamp,type:!string}}
 */
var RTCMediaSourceStats;
/**
 * @typedef {{exact:(!StringOrStringArrayUnion|undefined),ideal:(!StringOrStringArrayUnion|undefined)}}
 */
var ConstrainDOMStringParameters;
/**
 * @typedef {{kind:!string,module:!string,name:!string}}
 */
var ModuleImportDescriptor;
/**
 * @typedef {{size:!GPUSize64,usage:!GPUFlagsConstant,mappedAtCreation:(!boolean|undefined),label:(!string|undefined)}}
 */
var GPUBufferDescriptor;
/**
 * @typedef {{addressModeU:(!string|undefined),addressModeV:(!string|undefined),addressModeW:(!string|undefined),compare:(!string|undefined),lodMaxClamp:(!number|undefined),lodMinClamp:(!number|undefined),magFilter:(!string|undefined),maxAnisotropy:(!number|undefined),minFilter:(!string|undefined),mipmapFilter:(!string|undefined),label:(!string|undefined)}}
 */
var GPUSamplerDescriptor;
/**
 * @typedef {{bundlePolicy:(!string|undefined),certificates:(!Array<!RTCCertificate>|undefined),iceCandidatePoolSize:(!number|undefined),iceServers:(!Array<!RTCIceServer>|undefined),iceTransportPolicy:(!string|undefined),rtcpMuxPolicy:(!string|undefined),peerIdentity:(!string|undefined)}}
 */
var RTCConfiguration;
/**
 * @typedef {{colno:(!number|undefined),error:(*|undefined),filename:(!string|undefined),lineno:(!number|undefined),message:(!string|undefined),bubbles:(!boolean|undefined),cancelable:(!boolean|undefined),composed:(!boolean|undefined)}}
 */
var ErrorEventInit;
/**
 * @typedef {{altKey:(!boolean|undefined),ctrlKey:(!boolean|undefined),metaKey:(!boolean|undefined),modifierAltGraph:(!boolean|undefined),modifierCapsLock:(!boolean|undefined),modifierFn:(!boolean|undefined),modifierFnLock:(!boolean|undefined),modifierHyper:(!boolean|undefined),modifierNumLock:(!boolean|undefined),modifierScrollLock:(!boolean|undefined),modifierSuper:(!boolean|undefined),modifierSymbol:(!boolean|undefined),modifierSymbolLock:(!boolean|undefined),shiftKey:(!boolean|undefined),detail:(!number|undefined),view:(?Window|undefined),bubbles:(!boolean|undefined),cancelable:(!boolean|undefined),composed:(!boolean|undefined)}}
 */
var EventModifierInit;
/**
 * @typedef {{signal:(!AbortSignal|undefined)}}
 */
var WatchAdvertisementsOptions;
/**
 * @typedef {{fftSize:(!number|undefined),maxDecibels:(!number|undefined),minDecibels:(!number|undefined),smoothingTimeConstant:(!number|undefined),channelCount:(!number|undefined),channelCountMode:(!string|undefined),channelInterpretation:(!string|undefined)}}
 */
var AnalyserOptions;
/**
 * @typedef {{name:!string}}
 */
var Algorithm;
/**
 * @typedef {{label:(!string|undefined)}}
 */
var GPUObjectDescriptorBase;
/**
 * @typedef {{challenge:!string,crossOrigin:(!boolean|undefined),origin:!string,tokenBinding:(!TokenBinding|undefined),type:!string}}
 */
var CollectedClientData;
/**
 * @typedef {{added:!Array<!XRInputSource>,removed:!Array<!XRInputSource>,session:!XRSession,bubbles:(!boolean|undefined),cancelable:(!boolean|undefined),composed:(!boolean|undefined)}}
 */
var XRInputSourcesChangeEventInit;
/**
 * @typedef {{buffer:(?AudioBuffer|undefined),detune:(!number|undefined),loop:(!boolean|undefined),loopEnd:(!number|undefined),loopStart:(!number|undefined),playbackRate:(!number|undefined)}}
 */
var AudioBufferSourceOptions;
/**
 * @typedef {{encrypted:(!boolean|undefined),id:!number,uri:!string}}
 */
var RTCRtpHeaderExtensionParameters;
/**
 * @typedef {{clampDepth:(!boolean|undefined),cullMode:(!string|undefined),frontFace:(!string|undefined),stripIndexFormat:(!string|undefined),topology:(!string|undefined)}}
 */
var GPUPrimitiveState;
/**
 * @typedef {{vertex:!GPUVertexState,depthStencil:(!GPUDepthStencilState|undefined),fragment:(!GPUFragmentState|undefined),multisample:(!GPUMultisampleState|undefined),primitive:(!GPUPrimitiveState|undefined),layout:(!GPUPipelineLayout|undefined),label:(!string|undefined)}}
 */
var GPURenderPipelineDescriptor;
/**
 * @typedef {{detail:(!number|undefined),view:(?Window|undefined),bubbles:(!boolean|undefined),cancelable:(!boolean|undefined),composed:(!boolean|undefined)}}
 */
var UIEventInit;
/**
 * @typedef {{config:(!AudioEncoderConfig|undefined),supported:(!boolean|undefined)}}
 */
var AudioEncoderSupport;
/**
 * @typedef {{endings:(!string|undefined),type:(!string|undefined)}}
 */
var BlobPropertyBag;
/**
 * @typedef {{id:(!string|undefined),status:!string}}
 */
var TokenBinding;
/**
 * @typedef {{counter:!BufferSource,length:!number,name:!string}}
 */
var AesCtrParams;
/**
 * @typedef {{start:(!TransformerStartCallback|undefined),transform:(!TransformerTransformCallback|undefined),flush:(!TransformerFlushCallback|undefined),readableType:(*|undefined),writableType:(*|undefined)}}
 */
var Transformer;
/**
 * @typedef {{delay:(!number|undefined),direction:(!string|undefined),duration:(!UnrestrictedDoubleOrStringUnion|undefined),easing:(!string|undefined),endDelay:(!number|undefined),fill:(!string|undefined),iterationStart:(!number|undefined),iterations:(!number|undefined)}}
 */
var OptionalEffectTiming;
/**
 * @typedef {{composed:(!boolean|undefined)}}
 */
var GetRootNodeOptions;
/**
 * @typedef {{root:(?ElementOrDocumentUnion|undefined),rootMargin:(!string|undefined),threshold:(!DoubleOrDoubleArrayUnion|undefined)}}
 */
var IntersectionObserverInit;
/**
 * @typedef {{colorFormats:!Array<!string>,depthStencilFormat:(!string|undefined),sampleCount:(!GPUSize32|undefined),label:(!string|undefined)}}
 */
var GPURenderPassLayout;
/**
 * @typedef {{statusMessage:(!string|undefined),bubbles:(!boolean|undefined),cancelable:(!boolean|undefined),composed:(!boolean|undefined)}}
 */
var WebGLContextEventInit;
/**
 * @typedef {{bitDepth:(!number|undefined),frames:(!number|undefined),framesPerSecond:(!number|undefined),height:(!number|undefined),width:(!number|undefined),kind:!string,relayedSource:(!boolean|undefined),trackIdentifier:!string,id:!string,timestamp:!DOMHighResTimeStamp,type:!string}}
 */
var RTCVideoSourceStats;
/**
 * @typedef {{submitter:(?HTMLElement|undefined),bubbles:(!boolean|undefined),cancelable:(!boolean|undefined),composed:(!boolean|undefined)}}
 */
var SubmitEventInit;
/**
 * @typedef {{public:!CryptoKey,name:!string}}
 */
var EcdhKeyDeriveParams;
/**
 * @typedef {{data:!BufferSource,duration:(!number|undefined),timestamp:!number,type:!string}}
 */
var EncodedVideoChunkInit;
/**
 * @typedef {{allowedManufacturerData:!Array<!number>,allowedServices:StringOrUUIDArrayUnion,deviceId:!string,mayUseGATT:!boolean}}
 */
var AllowedBluetoothDevice;
/**
 * @typedef {{automationRate:(!string|undefined),defaultValue:(!number|undefined),maxValue:(!number|undefined),minValue:(!number|undefined),name:!string}}
 */
var AudioParamDescriptor;
/**
 * @typedef {{composite:(!string|undefined),easing:(!string|undefined),offset:(?number|undefined)}}
 */
var BaseKeyframe;
/**
 * @typedef {{frameCount:(!number|undefined),frameOffset:(!number|undefined),planeIndex:!number}}
 */
var AudioDataCopyToOptions;
/**
 * @typedef {{compare:(!string|undefined),depthFailOp:(!string|undefined),failOp:(!string|undefined),passOp:(!string|undefined)}}
 */
var GPUStencilFaceState;
/**
 * @typedef {{namedCurve:!NamedCurve,name:!string}}
 */
var EcKeyAlgorithm;
/**
 * @typedef {{entries:!Array<!GPUBindGroupLayoutEntry>,label:(!string|undefined)}}
 */
var GPUBindGroupLayoutDescriptor;
/**
 * @typedef {{domain:!string,protocol:(!string|undefined)}}
 */
var RTCIdentityProviderDetails;
/**
 * @typedef {{blockedURI:(!string|undefined),columnNumber:(!number|undefined),disposition:!string,documentURI:!string,effectiveDirective:!string,lineNumber:(!number|undefined),originalPolicy:!string,referrer:(!string|undefined),sample:(!string|undefined),sourceFile:(!string|undefined),statusCode:!number,violatedDirective:!string,bubbles:(!boolean|undefined),cancelable:(!boolean|undefined),composed:(!boolean|undefined)}}
 */
var SecurityPolicyViolationEventInit;
/**
 * @typedef {{relatedTarget:(?EventTarget|undefined),detail:(!number|undefined),view:(?Window|undefined),bubbles:(!boolean|undefined),cancelable:(!boolean|undefined),composed:(!boolean|undefined)}}
 */
var FocusEventInit;
/**
 * @typedef {{resultIndex:(!number|undefined),results:!SpeechRecognitionResultList,bubbles:(!boolean|undefined),cancelable:(!boolean|undefined),composed:(!boolean|undefined)}}
 */
var SpeechRecognitionEventInit;
/**
 * @typedef {{subtree:(!boolean|undefined)}}
 */
var GetAnimationsOptions;
/**
 * @typedef {{complete:!boolean,image:!VideoFrame}}
 */
var ImageDecodeResult;
/**
 * @typedef {{r:!number,g:!number,b:!number,a:!number}}
 */
var GPUColorDict;
/**
 * @typedef {{mediaElement:!HTMLMediaElement}}
 */
var MediaElementAudioSourceOptions;
/**
 * @typedef {{fractionLost:(!number|undefined),localId:(!string|undefined),reportsReceived:(!number|undefined),roundTripTime:(!number|undefined),roundTripTimeMeasurements:(!number|undefined),totalRoundTripTime:(!number|undefined),burstDiscardCount:(!number|undefined),burstDiscardRate:(!number|undefined),burstLossCount:(!number|undefined),burstLossRate:(!number|undefined),burstPacketsDiscarded:(!number|undefined),burstPacketsLost:(!number|undefined),framesDropped:(!number|undefined),fullFramesLost:(!number|undefined),gapDiscardRate:(!number|undefined),gapLossRate:(!number|undefined),jitter:(!number|undefined),packetsDiscarded:(!number|undefined),packetsLost:(!number|undefined),packetsReceived:(!number|undefined),packetsRepaired:(!number|undefined),partialFramesLost:(!number|undefined),codecId:(!string|undefined),kind:!string,ssrc:!number,transportId:(!string|undefined),averageRTCPInterval:(!number|undefined),mediaType:(!string|undefined),id:!string,timestamp:!DOMHighResTimeStamp,type:!string}}
 */
var RTCRemoteInboundRtpStreamStats;
/**
 * @typedef {{exact:(!boolean|undefined),ideal:(!boolean|undefined)}}
 */
var ConstrainBooleanParameters;
/**
 * @typedef {{files:(!Array<!File>|undefined),text:(!string|undefined),title:(!string|undefined),url:(!string|undefined)}}
 */
var ShareData;
/**
 * @typedef {{label:(!string|undefined)}}
 */
var GPUCommandBufferDescriptor;
/**
 * @typedef {{blob:(!ArrayBuffer|undefined),supported:(!boolean|undefined),written:(!boolean|undefined)}}
 */
var AuthenticationExtensionsLargeBlobOutputs;
/**
 * @typedef {{decoderConfig:(!VideoDecoderConfig|undefined),svc:(!SvcOutputMetadata|undefined)}}
 */
var EncodedVideoChunkMetadata;
/**
 * @typedef {{cname:(!string|undefined),reducedSize:(!boolean|undefined)}}
 */
var RTCRtcpParameters;
/**
 * @typedef {{dataPrefix:(!BufferSource|undefined),mask:(!BufferSource|undefined)}}
 */
var BluetoothDataFilterInit;
/**
 * @typedef {{password:(!string|undefined),usernameFragment:(!string|undefined)}}
 */
var RTCIceParameters;
/**
 * @typedef {{lastChance:(!boolean|undefined),tag:!string,bubbles:(!boolean|undefined),cancelable:(!boolean|undefined),composed:(!boolean|undefined)}}
 */
var SyncEventInit;
/**
 * @typedef {{block:(!string|undefined),inline:(!string|undefined),behavior:(!string|undefined)}}
 */
var ScrollIntoViewOptions;
/**
 * @typedef {{keyFrame:(!boolean|undefined)}}
 */
var VideoEncoderEncodeOptions;
/**
 * @record
 */
var GPUExternalTextureBindingLayout;
/**
 * @typedef {{changedTouches:(!Array<!Touch>|undefined),targetTouches:(!Array<!Touch>|undefined),touches:(!Array<!Touch>|undefined),altKey:(!boolean|undefined),ctrlKey:(!boolean|undefined),metaKey:(!boolean|undefined),modifierAltGraph:(!boolean|undefined),modifierCapsLock:(!boolean|undefined),modifierFn:(!boolean|undefined),modifierFnLock:(!boolean|undefined),modifierHyper:(!boolean|undefined),modifierNumLock:(!boolean|undefined),modifierScrollLock:(!boolean|undefined),modifierSuper:(!boolean|undefined),modifierSymbol:(!boolean|undefined),modifierSymbolLock:(!boolean|undefined),shiftKey:(!boolean|undefined),detail:(!number|undefined),view:(?Window|undefined),bubbles:(!boolean|undefined),cancelable:(!boolean|undefined),composed:(!boolean|undefined)}}
 */
var TouchEventInit;
/**
 * @typedef {{id:!BufferSource,transports:(!Array<!string>|undefined),type:!string}}
 */
var PublicKeyCredentialDescriptor;
/**
 * @typedef {{clientId:(!string|undefined),handled:(!Promise<undefined>|undefined),preloadResponse:(!Promise<*>|undefined),replacesClientId:(!string|undefined),request:!Request,resultingClientId:(!string|undefined),bubbles:(!boolean|undefined),cancelable:(!boolean|undefined),composed:(!boolean|undefined)}}
 */
var FetchEventInit;
/**
 * @typedef {{appid:(!boolean|undefined),appidExclude:(!boolean|undefined),uvm:(!UvmEntries|undefined),credProps:(!CredentialPropertiesOutput|undefined),largeBlob:(!AuthenticationExtensionsLargeBlobOutputs|undefined)}}
 */
var AuthenticationExtensionsClientOutputs;
/**
 * @typedef {{allowWithoutGesture:(!boolean|undefined),name:!string}}
 */
var ClipboardPermissionDescriptor;
/**
 * @typedef {{localId:(!string|undefined),remoteTimestamp:(!DOMHighResTimeStamp|undefined),reportsSent:(!number|undefined),roundTripTime:(!number|undefined),roundTripTimeMeasurements:(!number|undefined),totalRoundTripTime:(!number|undefined),bytesSent:(!number|undefined),packetsSent:(!number|undefined),codecId:(!string|undefined),kind:!string,ssrc:!number,transportId:(!string|undefined),averageRTCPInterval:(!number|undefined),mediaType:(!string|undefined),id:!string,timestamp:!DOMHighResTimeStamp,type:!string}}
 */
var RTCRemoteOutboundRtpStreamStats;
/**
 * @typedef {{audioLevel:(!number|undefined),rtpTimestamp:!number,source:!number,timestamp:!DOMHighResTimeStamp}}
 */
var RTCRtpSynchronizationSource;
/**
 * @typedef {{format:!string,blend:(!GPUBlendState|undefined),writeMask:(!GPUFlagsConstant|undefined)}}
 */
var GPUColorTargetState;
/**
 * @typedef {{audioBitrateMode:(!string|undefined),audioBitsPerSecond:(!number|undefined),bitsPerSecond:(!number|undefined),mimeType:(!string|undefined),videoBitsPerSecond:(!number|undefined)}}
 */
var MediaRecorderOptions;
/**
 * @typedef {{audio:(!BooleanOrMediaTrackConstraintsUnion|undefined),video:(!BooleanOrMediaTrackConstraintsUnion|undefined)}}
 */
var DisplayMediaStreamConstraints;
/**
 * @typedef {{actions:(!Array<!NotificationAction>|undefined),badge:(!string|undefined),body:(!string|undefined),data:(*|undefined),dir:(!string|undefined),icon:(!string|undefined),image:(!string|undefined),lang:(!string|undefined),renotify:(!boolean|undefined),requireInteraction:(!boolean|undefined),silent:(!boolean|undefined),tag:(!string|undefined),timestamp:(!DOMTimeStamp|undefined),vibrate:(!VibratePattern|undefined)}}
 */
var NotificationOptions;
/**
 * @typedef {{numberOfOutputs:(!number|undefined),channelCount:(!number|undefined),channelCountMode:(!string|undefined),channelInterpretation:(!string|undefined)}}
 */
var ChannelSplitterOptions;
/**
 * @typedef {{multisampled:(!boolean|undefined),sampleType:(!string|undefined),viewDimension:(!string|undefined)}}
 */
var GPUTextureBindingLayout;
/**
 * @typedef {{mediaSourceId:(!string|undefined),echoReturnLoss:(!number|undefined),echoReturnLossEnhancement:(!number|undefined),totalSamplesSent:(!number|undefined),audioLevel:(!number|undefined),totalAudioEnergy:(!number|undefined),totalSamplesDuration:(!number|undefined),voiceActivityFlag:(!boolean|undefined),ended:(!boolean|undefined),kind:!string,trackIdentifier:(!string|undefined),priority:(!string|undefined),remoteSource:(!boolean|undefined),id:!string,timestamp:!DOMHighResTimeStamp,type:!string}}
 */
var RTCAudioSenderStats;
/**
 * @typedef {{name:!string}}
 */
var PublicKeyCredentialEntity;
/**
 * @typedef {{rk:(!boolean|undefined)}}
 */
var CredentialPropertiesOutput;
/**
 * @typedef {{type:(!string|undefined)}}
 */
var GPUSamplerBindingLayout;
/**
 * @typedef {{transfer:(!Array<!Transferable>|undefined)}}
 */
var PostMessageOptions;
/**
 * @typedef {{label:(!string|undefined)}}
 */
var GPURenderBundleDescriptor;
/**
 * @typedef {{audioLevel:(!number|undefined),totalAudioEnergy:(!number|undefined),totalSamplesDuration:(!number|undefined),voiceActivityFlag:(!boolean|undefined),ended:(!boolean|undefined),kind:!string,trackIdentifier:(!string|undefined),priority:(!string|undefined),remoteSource:(!boolean|undefined),id:!string,timestamp:!DOMHighResTimeStamp,type:!string}}
 */
var RTCAudioHandlerStats;
/**
 * @typedef {{initial:!number,maximum:(!number|undefined)}}
 */
var MemoryDescriptor;
/**
 * @typedef {{layout:(!GPUPipelineLayout|undefined),label:(!string|undefined)}}
 */
var GPUPipelineDescriptorBase;
/**
 * @typedef {{alphaToCoverageEnabled:(!boolean|undefined),count:(!GPUSize32|undefined),mask:(!GPUSampleMask|undefined)}}
 */
var GPUMultisampleState;
/**
 * @typedef {{mediaStreamTrack:!MediaStreamTrack}}
 */
var MediaStreamTrackAudioSourceOptions;
/**
 * @typedef {{height:!number,left:!number,top:!number,width:!number}}
 */
var VideoFrameRect;
/**
 * @typedef {{aspectRatio:(!boolean|undefined),autoGainControl:(!boolean|undefined),channelCount:(!boolean|undefined),deviceId:(!boolean|undefined),echoCancellation:(!boolean|undefined),facingMode:(!boolean|undefined),frameRate:(!boolean|undefined),groupId:(!boolean|undefined),height:(!boolean|undefined),latency:(!boolean|undefined),noiseSuppression:(!boolean|undefined),resizeMode:(!boolean|undefined),sampleRate:(!boolean|undefined),sampleSize:(!boolean|undefined),width:(!boolean|undefined),cursor:(!boolean|undefined),displaySurface:(!boolean|undefined),logicalSurface:(!boolean|undefined),restrictOwnAudio:(!boolean|undefined),suppressLocalAudioPlayback:(!boolean|undefined)}}
 */
var MediaTrackSupportedConstraints;
/**
 * @typedef {{withCredentials:(!boolean|undefined)}}
 */
var EventSourceInit;
/**
 * @typedef {{key:(?string|undefined),newValue:(?string|undefined),oldValue:(?string|undefined),storageArea:(?Storage|undefined),url:(!string|undefined),bubbles:(!boolean|undefined),cancelable:(!boolean|undefined),composed:(!boolean|undefined)}}
 */
var StorageEventInit;
/**
 * @typedef {{active:(!boolean|undefined),maxBitrate:(!number|undefined),scaleResolutionDownBy:(!number|undefined),networkPriority:(!string|undefined),priority:(!string|undefined),rid:(!string|undefined)}}
 */
var RTCRtpEncodingParameters;
/**
 * @typedef {{alpha:(!boolean|undefined),antialias:(!boolean|undefined),depth:(!boolean|undefined),framebufferScaleFactor:(!number|undefined),ignoreDepthValues:(!boolean|undefined),stencil:(!boolean|undefined)}}
 */
var XRWebGLLayerInit;
/**
 * @typedef {{hash:!HashAlgorithmIdentifier,length:(!number|undefined),name:!string}}
 */
var HmacImportParams;
/**
 * @typedef {{view:!GPUTextureView,resolveTarget:(!GPUTextureView|undefined),loadValue:GPULoadOpOrGPUColorUnion,storeOp:!string}}
 */
var GPURenderPassColorAttachment;
/**
 * @typedef {{instance:!WebAssembly.Instance,module:!WebAssembly.Module}}
 */
var WebAssemblyInstantiatedSource;
/**
 * @typedef {{height:(!number|undefined),isPrimary:(!boolean|undefined),pointerId:(!number|undefined),pointerType:(!string|undefined),pressure:(!number|undefined),tangentialPressure:(!number|undefined),tiltX:(!number|undefined),tiltY:(!number|undefined),twist:(!number|undefined),width:(!number|undefined),button:(!number|undefined),buttons:(!number|undefined),relatedTarget:(?EventTarget|undefined),clientX:(!number|undefined),clientY:(!number|undefined),screenX:(!number|undefined),screenY:(!number|undefined),movementX:(!number|undefined),movementY:(!number|undefined),altKey:(!boolean|undefined),ctrlKey:(!boolean|undefined),metaKey:(!boolean|undefined),modifierAltGraph:(!boolean|undefined),modifierCapsLock:(!boolean|undefined),modifierFn:(!boolean|undefined),modifierFnLock:(!boolean|undefined),modifierHyper:(!boolean|undefined),modifierNumLock:(!boolean|undefined),modifierScrollLock:(!boolean|undefined),modifierSuper:(!boolean|undefined),modifierSymbol:(!boolean|undefined),modifierSymbolLock:(!boolean|undefined),shiftKey:(!boolean|undefined),detail:(!number|undefined),view:(?Window|undefined),bubbles:(!boolean|undefined),cancelable:(!boolean|undefined),composed:(!boolean|undefined)}}
 */
var PointerEventInit;
/**
 * @typedef {{value:(*|undefined),bubbles:(!boolean|undefined),cancelable:(!boolean|undefined),composed:(!boolean|undefined)}}
 */
var ValueEventInit;
/**
 * @typedef {{arrayStride:!GPUSize64,stepMode:(!string|undefined),attributes:!Array<!GPUVertexAttribute>}}
 */
var GPUVertexBufferLayout;
/**
 * @typedef {{aspectRatio:(!ConstrainDouble|undefined),autoGainControl:(!ConstrainBoolean|undefined),channelCount:(!ConstrainULong|undefined),deviceId:(!ConstrainDOMString|undefined),echoCancellation:(!ConstrainBoolean|undefined),facingMode:(!ConstrainDOMString|undefined),frameRate:(!ConstrainDouble|undefined),groupId:(!ConstrainDOMString|undefined),height:(!ConstrainULong|undefined),latency:(!ConstrainDouble|undefined),noiseSuppression:(!ConstrainBoolean|undefined),resizeMode:(!ConstrainDOMString|undefined),sampleRate:(!ConstrainULong|undefined),sampleSize:(!ConstrainULong|undefined),width:(!ConstrainULong|undefined),cursor:(!ConstrainDOMString|undefined),displaySurface:(!ConstrainDOMString|undefined),logicalSurface:(!ConstrainBoolean|undefined),restrictOwnAudio:(!ConstrainBoolean|undefined),suppressLocalAudioPlayback:(!ConstrainBoolean|undefined)}}
 */
var MediaTrackConstraintSet;
/**
 * @typedef {{mediaStream:!MediaStream}}
 */
var MediaStreamAudioSourceOptions;
/**
 * @typedef {{duration:(!number|undefined),timestamp:(!number|undefined)}}
 */
var VideoFrameInit;
/**
 * @typedef {{label:(!string|undefined)}}
 */
var GPUComputePassDescriptor;
/**
 * @typedef {{stream:(!boolean|undefined)}}
 */
var TextDecodeOptions;
/**
 * @typedef {{frameHeight:(!number|undefined),frameWidth:(!number|undefined),framesPerSecond:(!number|undefined),ended:(!boolean|undefined),kind:!string,trackIdentifier:(!string|undefined),priority:(!string|undefined),remoteSource:(!boolean|undefined),id:!string,timestamp:!DOMHighResTimeStamp,type:!string}}
 */
var RTCVideoHandlerStats;
/**
 * @typedef {{a:(!number|undefined),b:(!number|undefined),c:(!number|undefined),d:(!number|undefined),e:(!number|undefined),f:(!number|undefined),m11:(!number|undefined),m12:(!number|undefined),m21:(!number|undefined),m22:(!number|undefined),m41:(!number|undefined),m42:(!number|undefined)}}
 */
var DOMMatrix2DInit;
/**
 * @typedef {{manufacturerData:(!Array<!BluetoothManufacturerDataFilterInit>|undefined),name:(!string|undefined),namePrefix:(!string|undefined),serviceData:(!Array<!BluetoothServiceDataFilterInit>|undefined),services:(!Array<!BluetoothServiceUUID>|undefined)}}
 */
var BluetoothLEScanFilterInit;
/**
 * @typedef {{buffered:(!boolean|undefined),entryTypes:(!Array<!string>|undefined),type:(!string|undefined)}}
 */
var PerformanceObserverInit;
/**
 * @typedef {{audioLevel:(!number|undefined),echoReturnLoss:(!number|undefined),echoReturnLossEnhancement:(!number|undefined),totalAudioEnergy:(!number|undefined),totalSamplesDuration:(!number|undefined),kind:!string,relayedSource:(!boolean|undefined),trackIdentifier:!string,id:!string,timestamp:!DOMHighResTimeStamp,type:!string}}
 */
var RTCAudioSourceStats;
/**
 * @typedef {{forceSoftware:(!boolean|undefined),powerPreference:(!string|undefined)}}
 */
var GPURequestAdapterOptions;
/**
 * @typedef {{offset:!number,stride:!number}}
 */
var PlaneLayout;
/**
 * @typedef {{averageRtcpInterval:(!number|undefined),bytesDiscardedOnSend:(!number|undefined),encoderImplementation:(!string|undefined),fecPacketsSent:(!number|undefined),firCount:(!number|undefined),frameBitDepth:(!number|undefined),frameHeight:(!number|undefined),frameWidth:(!number|undefined),framesDiscardedOnSend:(!number|undefined),framesEncoded:(!number|undefined),framesPerSecond:(!number|undefined),framesSent:(!number|undefined),headerBytesSent:(!number|undefined),hugeFramesSent:(!number|undefined),keyFramesEncoded:(!number|undefined),lastPacketSentTimestamp:(!DOMHighResTimeStamp|undefined),mediaSourceId:(!string|undefined),nackCount:(!number|undefined),packetsDiscardedOnSend:(!number|undefined),perDscpPacketsSent:(!Object<!string,!number>|undefined),pliCount:(!number|undefined),qpSum:(!number|undefined),qualityLimitationDurations:(!Object<!string,!number>|undefined),qualityLimitationReason:(!string|undefined),qualityLimitationResolutionChanges:(!number|undefined),remoteId:(!string|undefined),retransmittedBytesSent:(!number|undefined),retransmittedPacketsSent:(!number|undefined),rid:(!string|undefined),rtxSsrc:(!number|undefined),samplesEncodedWithCelt:(!number|undefined),samplesEncodedWithSilk:(!number|undefined),senderId:(!string|undefined),sliCount:(!number|undefined),targetBitrate:(!number|undefined),totalEncodeTime:(!number|undefined),totalEncodedBytesTarget:(!number|undefined),totalPacketSendDelay:(!number|undefined),totalSamplesSent:(!number|undefined),voiceActivityFlag:(!boolean|undefined),trackId:(!string|undefined),bytesSent:(!number|undefined),packetsSent:(!number|undefined),codecId:(!string|undefined),kind:!string,ssrc:!number,transportId:(!string|undefined),averageRTCPInterval:(!number|undefined),mediaType:(!string|undefined),id:!string,timestamp:!DOMHighResTimeStamp,type:!string}}
 */
var RTCOutboundRtpStreamStats;
/**
 * @typedef {{audioLevel:(!number|undefined),rtpTimestamp:!number,source:!number,timestamp:!DOMHighResTimeStamp}}
 */
var RTCRtpContributingSource;
/**
 * @typedef {{format:!string,offset:!GPUSize64,shaderLocation:!GPUIndex32}}
 */
var GPUVertexAttribute;
/**
 * @typedef {{mutable:(!boolean|undefined),value:!string}}
 */
var GlobalDescriptor;
/**
 * @typedef {{kind:!string,name:!string}}
 */
var ModuleExportDescriptor;
/**
 * @typedef {{hash:!HashAlgorithmIdentifier,info:!BufferSource,salt:!BufferSource,name:!string}}
 */
var HkdfParams;
/**
 * @typedef {{errorDetail:!string,receivedAlert:(!number|undefined),sctpCauseCode:(!number|undefined),sdpLineNumber:(!number|undefined),sentAlert:(!number|undefined),httpRequestStatusCode:(!number|undefined)}}
 */
var RTCErrorInit;
/**
 * @typedef {{alpha:(?number|undefined),beta:(?number|undefined),gamma:(?number|undefined)}}
 */
var DeviceMotionEventRotationRateInit;
/**
 * @typedef {{altitudeAngle:(!number|undefined),azimuthAngle:(!number|undefined),clientX:(!number|undefined),clientY:(!number|undefined),force:(!number|undefined),identifier:!number,pageX:(!number|undefined),pageY:(!number|undefined),radiusX:(!number|undefined),radiusY:(!number|undefined),rotationAngle:(!number|undefined),screenX:(!number|undefined),screenY:(!number|undefined),target:!EventTarget,touchType:(!string|undefined)}}
 */
var TouchInit;
/**
 * @typedef {{badInput:(!boolean|undefined),customError:(!boolean|undefined),patternMismatch:(!boolean|undefined),rangeOverflow:(!boolean|undefined),rangeUnderflow:(!boolean|undefined),stepMismatch:(!boolean|undefined),tooLong:(!boolean|undefined),tooShort:(!boolean|undefined),typeMismatch:(!boolean|undefined),valueMissing:(!boolean|undefined)}}
 */
var ValidityStateFlags;
/**
 * @typedef {{panTiltZoom:(!boolean|undefined),deviceId:(!string|undefined),name:!string}}
 */
var CameraDevicePermissionDescriptor;
/**
 * @typedef {{access:(!string|undefined),format:!string,viewDimension:(!string|undefined)}}
 */
var GPUStorageTextureBindingLayout;
/**
 * @typedef {{channels:(!number|undefined),clockRate:!number,mimeType:!string,payloadType:!number,sdpFmtpLine:(!string|undefined)}}
 */
var RTCRtpCodecParameters;
/**
 * @typedef {{detail:(*|undefined),bubbles:(!boolean|undefined),cancelable:(!boolean|undefined),composed:(!boolean|undefined)}}
 */
var CustomEventInit;
/**
 * @typedef {{contents:!string,identity:!string}}
 */
var RTCIdentityValidationResult;
/**
 * @typedef {{service:!BluetoothServiceUUID,dataPrefix:(!BufferSource|undefined),mask:(!BufferSource|undefined)}}
 */
var BluetoothServiceDataFilterInit;
/**
 * @typedef {{d:(!string|undefined),r:(!string|undefined),t:(!string|undefined)}}
 */
var RsaOtherPrimesInfo;
/**
 * @typedef {{initData:(?ArrayBuffer|undefined),initDataType:(!string|undefined),bubbles:(!boolean|undefined),cancelable:(!boolean|undefined),composed:(!boolean|undefined)}}
 */
var MediaEncryptedEventInit;
/**
 * @typedef {{colorSpace:(!string|undefined),premultipliedAlpha:(!boolean|undefined),texture:!GPUTexture,aspect:(!string|undefined),mipLevel:(!GPUIntegerCoordinate|undefined),origin:(!GPUOrigin3D|undefined)}}
 */
var GPUImageCopyTextureTagged;
/**
 * @typedef {{module:!GPUShaderModule,entryPoint:!string,constants:(!Object<!string,!GPUPipelineConstantValue>|undefined)}}
 */
var GPUProgrammableStage;
/**
 * @typedef {{name:!string}}
 */
var PermissionDescriptor;
/**
 * @typedef {{flatten:(!boolean|undefined)}}
 */
var AssignedNodesOptions;
/**
 * @typedef {{decoderConfig:(!AudioDecoderConfig|undefined)}}
 */
var EncodedAudioChunkMetadata;
/**
 * @typedef {{error:!DOMException,bubbles:(!boolean|undefined),cancelable:(!boolean|undefined),composed:(!boolean|undefined)}}
 */
var MediaRecorderErrorEventInit;
/**
 * @typedef {{acceptAllDevices:(!boolean|undefined),deviceId:(!string|undefined),filters:(!Array<!BluetoothLEScanFilterInit>|undefined),optionalManufacturerData:(!Array<!number>|undefined),optionalServices:(!Array<!BluetoothServiceUUID>|undefined),name:!string}}
 */
var BluetoothPermissionDescriptor;
/**
 * @typedef {{measureExecutionTime:(!boolean|undefined),label:(!string|undefined)}}
 */
var GPUCommandEncoderDescriptor;
/**
 * @typedef {{candidate:(?RTCIceCandidate|undefined),url:(?string|undefined),bubbles:(!boolean|undefined),cancelable:(!boolean|undefined),composed:(!boolean|undefined)}}
 */
var RTCPeerConnectionIceEventInit;
/**
 * @typedef {{max:(!number|undefined),min:(!number|undefined)}}
 */
var DoubleRange;
/**
 * @typedef {{appid:(!string|undefined),appidExclude:(!string|undefined),uvm:(!boolean|undefined),credProps:(!boolean|undefined),largeBlob:(!AuthenticationExtensionsLargeBlobInputs|undefined)}}
 */
var AuthenticationExtensionsClientInputs;
/**
 * @typedef {{max:(!number|undefined),min:(!number|undefined)}}
 */
var ULongRange;
/**
 * @typedef {{estimatedPlayoutTimestamp:(!DOMHighResTimeStamp|undefined),framesDecoded:(!number|undefined),framesDropped:(!number|undefined),framesReceived:(!number|undefined),fullFramesLost:(!number|undefined),jitterBufferDelay:(!number|undefined),jitterBufferEmittedCount:(!number|undefined),keyFramesReceived:(!number|undefined),partialFramesLost:(!number|undefined),frameHeight:(!number|undefined),frameWidth:(!number|undefined),framesPerSecond:(!number|undefined),ended:(!boolean|undefined),kind:!string,trackIdentifier:(!string|undefined),priority:(!string|undefined),remoteSource:(!boolean|undefined),id:!string,timestamp:!DOMHighResTimeStamp,type:!string}}
 */
var RTCReceiverVideoTrackAttachmentStats;
/**
 * @typedef {{numberOfInputs:(!number|undefined),numberOfOutputs:(!number|undefined),outputChannelCount:(!Array<!number>|undefined),parameterData:(!Object<!string,!number>|undefined),processorOptions:(!Object|undefined),channelCount:(!number|undefined),channelCountMode:(!string|undefined),channelInterpretation:(!string|undefined)}}
 */
var AudioWorkletNodeOptions;
/**
 * @typedef {{action:!string,icon:(!string|undefined),title:!string}}
 */
var NotificationAction;
/**
 * @typedef {{multiEntry:(!boolean|undefined),unique:(!boolean|undefined)}}
 */
var IDBIndexParameters;
/**
 * @typedef {{binding:!GPUIndex32,resource:!GPUBindingResource}}
 */
var GPUBindGroupEntry;
/**
 * @typedef {{formData:!FormData,bubbles:(!boolean|undefined),cancelable:(!boolean|undefined),composed:(!boolean|undefined)}}
 */
var FormDataEventInit;
/**
 * @typedef {{namedCurve:!NamedCurve,name:!string}}
 */
var EcKeyGenParams;
/**
 * @typedef {{port:(!number|undefined),relayProtocol:(!string|undefined),totalRequestsSent:(!number|undefined),totalResponsesReceived:(!number|undefined),totalRoundTripTime:(!number|undefined),url:!string,id:!string,timestamp:!DOMHighResTimeStamp,type:!string}}
 */
var RTCIceServerStats;
/**
 * @typedef {{preventCancel:(!boolean|undefined)}}
 */
var ReadableStreamIteratorOptions;
/**
 * @typedef {{iceRestart:(!boolean|undefined),offerToReceiveAudio:(!boolean|undefined),offerToReceiveVideo:(!boolean|undefined)}}
 */
var RTCOfferOptions;
/**
 * @typedef {{cacheName:(!string|undefined),ignoreMethod:(!boolean|undefined),ignoreSearch:(!boolean|undefined),ignoreVary:(!boolean|undefined)}}
 */
var MultiCacheQueryOptions;
/**
 * @typedef {{config:(!VideoDecoderConfig|undefined),supported:(!boolean|undefined)}}
 */
var VideoDecoderSupport;
/**
 * @typedef {{iv:!BufferSource,name:!string}}
 */
var AesCbcParams;
/**
 * @typedef {{acceptAllDevices:(!boolean|undefined),filters:(!Array<!BluetoothLEScanFilterInit>|undefined),optionalManufacturerData:(!Array<!number>|undefined),optionalServices:(!Array<!BluetoothServiceUUID>|undefined)}}
 */
var RequestDeviceOptions;
/**
 * @typedef {{temporalLayerId:(!number|undefined)}}
 */
var SvcOutputMetadata;
/**
 * @typedef {{rid:(!string|undefined)}}
 */
var RTCRtpDecodingParameters;
/**
 * @typedef {{id:!string,timestamp:!DOMHighResTimeStamp,type:!string}}
 */
var RTCStats;
/**
 * @typedef {{enabled:(!boolean|undefined),headerValue:(!string|undefined)}}
 */
var NavigationPreloadState;
/**
 * @typedef {{mediaSourceId:(!string|undefined),echoReturnLoss:(!number|undefined),echoReturnLossEnhancement:(!number|undefined),totalSamplesSent:(!number|undefined),audioLevel:(!number|undefined),totalAudioEnergy:(!number|undefined),totalSamplesDuration:(!number|undefined),voiceActivityFlag:(!boolean|undefined),ended:(!boolean|undefined),kind:!string,trackIdentifier:(!string|undefined),priority:(!string|undefined),remoteSource:(!boolean|undefined),id:!string,timestamp:!DOMHighResTimeStamp,type:!string}}
 */
var RTCSenderAudioTrackAttachmentStats;
/**
 * @typedef {{timeout:(!number|undefined)}}
 */
var IdleRequestOptions;
/**
 * @typedef {{codecs:!Array<!RTCRtpCodecCapability>,headerExtensions:!Array<!RTCRtpHeaderExtensionCapability>}}
 */
var RTCRtpCapabilities;
/**
 * @typedef {{hash:!HashAlgorithmIdentifier,iterations:!number,salt:!BufferSource,name:!string}}
 */
var Pbkdf2Params;
/**
 * @typedef {{detune:(!number|undefined),frequency:(!number|undefined),periodicWave:(!PeriodicWave|undefined),type:(!string|undefined),channelCount:(!number|undefined),channelCountMode:(!string|undefined),channelInterpretation:(!string|undefined)}}
 */
var OscillatorOptions;
/**
 * @typedef {{composite:(!string|undefined),computedOffset:(!number|undefined),easing:(!string|undefined),offset:(?number|undefined)}}
 */
var BaseComputedKeyframe;
/**
 * @typedef {{data:(*|undefined),lastEventId:(!string|undefined),origin:(!string|undefined),ports:(!Array<!MessagePort>|undefined),source:(?MessageEventSource|undefined),bubbles:(!boolean|undefined),cancelable:(!boolean|undefined),composed:(!boolean|undefined)}}
 */
var MessageEventInit;
/**
 * @typedef {{sdp:(!string|undefined),type:(!string|undefined)}}
 */
var RTCLocalSessionDescriptionInit;
/**
 * @typedef {{session:!XRSession,bubbles:(!boolean|undefined),cancelable:(!boolean|undefined),composed:(!boolean|undefined)}}
 */
var XRSessionEventInit;
/**
 * @typedef {{alg:(!string|undefined),crv:(!string|undefined),d:(!string|undefined),dp:(!string|undefined),dq:(!string|undefined),e:(!string|undefined),ext:(!boolean|undefined),k:(!string|undefined),key_ops:(!Array<!string>|undefined),kty:(!string|undefined),n:(!string|undefined),oth:(!Array<!RsaOtherPrimesInfo>|undefined),p:(!string|undefined),q:(!string|undefined),qi:(!string|undefined),use:(!string|undefined),x:(!string|undefined),y:(!string|undefined)}}
 */
var JsonWebKey;
/**
 * @typedef {{algorithm:(!string|undefined),value:(!string|undefined)}}
 */
var RTCDtlsFingerprint;
/**
 * @typedef {{hasDynamicOffset:(!boolean|undefined),minBindingSize:(!GPUSize64|undefined),type:(!string|undefined)}}
 */
var GPUBufferBindingLayout;
/**
 * @typedef {{completeFramesOnly:(!boolean|undefined),frameIndex:(!number|undefined)}}
 */
var ImageDecodeOptions;
/**
 * @typedef {{dataChannelsAccepted:(!number|undefined),dataChannelsClosed:(!number|undefined),dataChannelsOpened:(!number|undefined),dataChannelsRequested:(!number|undefined),id:!string,timestamp:!DOMHighResTimeStamp,type:!string}}
 */
var RTCPeerConnectionStats;
/**
 * @typedef {{name:!string}}
 */
var KeyAlgorithm;
/**
 * @typedef {{alpha:(!boolean|undefined),antialias:(!boolean|undefined),depth:(!boolean|undefined),desynchronized:(!boolean|undefined),failIfMajorPerformanceCaveat:(!boolean|undefined),powerPreference:(!string|undefined),premultipliedAlpha:(!boolean|undefined),preserveDrawingBuffer:(!boolean|undefined),stencil:(!boolean|undefined),xrCompatible:(!boolean|undefined)}}
 */
var WebGLContextAttributes;
/**
 * @typedef {{newSubscription:(!PushSubscription|undefined),oldSubscription:(!PushSubscription|undefined),bubbles:(!boolean|undefined),cancelable:(!boolean|undefined),composed:(!boolean|undefined)}}
 */
var PushSubscriptionChangeEventInit;
/**
 * @typedef {{sdp:(!string|undefined),type:!string}}
 */
var RTCSessionDescriptionInit;
/**
 * @typedef {{start:(!UnderlyingSinkStartCallback|undefined),write:(!UnderlyingSinkWriteCallback|undefined),close:(!UnderlyingSinkCloseCallback|undefined),abort:(!UnderlyingSinkAbortCallback|undefined),type:(*|undefined)}}
 */
var UnderlyingSink;
/**
 * @typedef {{attack:(!number|undefined),knee:(!number|undefined),ratio:(!number|undefined),release:(!number|undefined),threshold:(!number|undefined),channelCount:(!number|undefined),channelCountMode:(!string|undefined),channelInterpretation:(!string|undefined)}}
 */
var DynamicsCompressorOptions;
/**
 * @typedef {{credentials:(!string|undefined),name:(!string|undefined),type:(!string|undefined)}}
 */
var WorkerOptions;
/**
 * @typedef {{protocols:(!Array<!string>|undefined),providers:(!Array<!string>|undefined)}}
 */
var FederatedCredentialRequestOptions;
/**
 * @typedef {{composite:(!string|undefined),pseudoElement:(?CSSOMString|undefined),delay:(!number|undefined),direction:(!string|undefined),duration:(!UnrestrictedDoubleOrStringUnion|undefined),easing:(!string|undefined),endDelay:(!number|undefined),fill:(!string|undefined),iterationStart:(!number|undefined),iterations:(!number|undefined)}}
 */
var KeyframeEffectOptions;
/**
 * @typedef {{id:(!number|undefined),maxPacketLifeTime:(!number|undefined),maxRetransmits:(!number|undefined),negotiated:(!boolean|undefined),ordered:(!boolean|undefined),protocol:(!string|undefined),priority:(!string|undefined)}}
 */
var RTCDataChannelInit;
/**
 * @typedef {{format:!string,depthBias:(!GPUDepthBias|undefined),depthBiasClamp:(!number|undefined),depthBiasSlopeScale:(!number|undefined),depthCompare:(!string|undefined),depthWriteEnabled:(!boolean|undefined),stencilBack:(!GPUStencilFaceState|undefined),stencilFront:(!GPUStencilFaceState|undefined),stencilReadMask:(!GPUStencilValue|undefined),stencilWriteMask:(!GPUStencilValue|undefined)}}
 */
var GPUDepthStencilState;
/**
 * @typedef {{dstFactor:(!string|undefined),operation:(!string|undefined),srcFactor:(!string|undefined)}}
 */
var GPUBlendComponent;
/**
 * @typedef {{address:(?string|undefined),candidateType:!string,port:(!number|undefined),priority:(!number|undefined),protocol:(!string|undefined),relayProtocol:(!string|undefined),transportId:!string,url:(!string|undefined),deleted:(!boolean|undefined),isRemote:(!boolean|undefined),id:!string,timestamp:!DOMHighResTimeStamp,type:!string}}
 */
var RTCIceCandidateStats;
/**
 * @typedef {{animationName:(!CSSOMString|undefined),elapsedTime:(!number|undefined),pseudoElement:(!CSSOMString|undefined),bubbles:(!boolean|undefined),cancelable:(!boolean|undefined),composed:(!boolean|undefined)}}
 */
var AnimationEventInit;
/**
 * @typedef {{colorSpaceConversion:(!string|undefined),data:!ImageBufferSource,desiredHeight:(!number|undefined),desiredWidth:(!number|undefined),preferAnimation:(!boolean|undefined),premultiplyAlpha:(!string|undefined),type:!string}}
 */
var ImageDecoderInit;
/**
 * @typedef {{sysex:(!boolean|undefined),name:!string}}
 */
var MidiPermissionDescriptor;
/**
 * @typedef {{error:!RTCError,bubbles:(!boolean|undefined),cancelable:(!boolean|undefined),composed:(!boolean|undefined)}}
 */
var RTCErrorEventInit;
/**
 * @typedef {{navigationUI:(!string|undefined)}}
 */
var FullscreenOptions;
/**
 * @typedef {{name:(!string|undefined),version:(!number|undefined)}}
 */
var IDBDatabaseInfo;
/**
 * @typedef {{code:(!string|undefined),isComposing:(!boolean|undefined),key:(!string|undefined),location:(!number|undefined),repeat:(!boolean|undefined),altKey:(!boolean|undefined),ctrlKey:(!boolean|undefined),metaKey:(!boolean|undefined),modifierAltGraph:(!boolean|undefined),modifierCapsLock:(!boolean|undefined),modifierFn:(!boolean|undefined),modifierFnLock:(!boolean|undefined),modifierHyper:(!boolean|undefined),modifierNumLock:(!boolean|undefined),modifierScrollLock:(!boolean|undefined),modifierSuper:(!boolean|undefined),modifierSymbol:(!boolean|undefined),modifierSymbolLock:(!boolean|undefined),shiftKey:(!boolean|undefined),detail:(!number|undefined),view:(?Window|undefined),bubbles:(!boolean|undefined),cancelable:(!boolean|undefined),composed:(!boolean|undefined)}}
 */
var KeyboardEventInit;
/**
 * @typedef {{activeDuration:(!number|undefined),currentIteration:(?number|undefined),endTime:(!number|undefined),localTime:(?number|undefined),progress:(?number|undefined),delay:(!number|undefined),direction:(!string|undefined),duration:(!UnrestrictedDoubleOrStringUnion|undefined),easing:(!string|undefined),endDelay:(!number|undefined),fill:(!string|undefined),iterationStart:(!number|undefined),iterations:(!number|undefined)}}
 */
var ComputedEffectTiming;
/**
 * @typedef {{elapsedTime:(!number|undefined),propertyName:(!CSSOMString|undefined),pseudoElement:(!CSSOMString|undefined),bubbles:(!boolean|undefined),cancelable:(!boolean|undefined),composed:(!boolean|undefined)}}
 */
var TransitionEventInit;
/**
 * @typedef {{availableIncomingBitrate:(!number|undefined),availableOutgoingBitrate:(!number|undefined),bytesDiscardedOnSend:(!number|undefined),bytesReceived:(!number|undefined),bytesSent:(!number|undefined),circuitBreakerTriggerCount:(!number|undefined),consentExpiredTimestamp:(!DOMHighResTimeStamp|undefined),consentRequestBytesSent:(!number|undefined),consentRequestsSent:(!number|undefined),currentRoundTripTime:(!number|undefined),firstRequestTimestamp:(!DOMHighResTimeStamp|undefined),lastPacketReceivedTimestamp:(!DOMHighResTimeStamp|undefined),lastPacketSentTimestamp:(!DOMHighResTimeStamp|undefined),lastRequestTimestamp:(!DOMHighResTimeStamp|undefined),lastResponseTimestamp:(!DOMHighResTimeStamp|undefined),localCandidateId:!string,nominated:(!boolean|undefined),packetsDiscardedOnSend:(!number|undefined),packetsReceived:(!number|undefined),packetsSent:(!number|undefined),remoteCandidateId:!string,requestBytesSent:(!number|undefined),requestsReceived:(!number|undefined),requestsSent:(!number|undefined),responseBytesSent:(!number|undefined),responsesReceived:(!number|undefined),responsesSent:(!number|undefined),retransmissionsReceived:(!number|undefined),retransmissionsSent:(!number|undefined),state:!string,totalRoundTripTime:(!number|undefined),transportId:!string,currentRtt:(!number|undefined),priority:(!number|undefined),totalRtt:(!number|undefined),id:!string,timestamp:!DOMHighResTimeStamp,type:!string}}
 */
var RTCIceCandidatePairStats;
/**
 * @typedef {{buffer:!GPUBuffer,bytesPerRow:(!GPUSize32|undefined),offset:(!GPUSize64|undefined),rowsPerImage:(!GPUSize32|undefined)}}
 */
var GPUImageCopyBuffer;
/**
 * @typedef {{mid:(!string|undefined),receiverId:!string,senderId:!string,id:!string,timestamp:!DOMHighResTimeStamp,type:!string}}
 */
var RTCRtpTransceiverStats;
/**
 * @typedef {{baseLayer:(?XRWebGLLayer|undefined),depthFar:(!number|undefined),depthNear:(!number|undefined),inlineVerticalFieldOfView:(!number|undefined),layers:(?Array<!XRLayer>|undefined)}}
 */
var XRRenderStateInit;
/**
 * @typedef {{error:!string,charIndex:(!number|undefined),charLength:(!number|undefined),elapsedTime:(!number|undefined),name:(!string|undefined),utterance:!SpeechSynthesisUtterance,bubbles:(!boolean|undefined),cancelable:(!boolean|undefined),composed:(!boolean|undefined)}}
 */
var SpeechSynthesisErrorEventInit;
/**
 * @typedef {{alpha:(!boolean|undefined)}}
 */
var ImageBitmapRenderingContextSettings;
/**
 * @typedef {{additionalData:(!BufferSource|undefined),iv:!BufferSource,tagLength:(!number|undefined),name:!string}}
 */
var AesGcmParams;
/**
 * @typedef {{hash:!KeyAlgorithm,length:!number,name:!string}}
 */
var HmacKeyAlgorithm;
/**
 * @typedef {{tone:(!string|undefined),bubbles:(!boolean|undefined),cancelable:(!boolean|undefined),composed:(!boolean|undefined)}}
 */
var RTCDTMFToneChangeEventInit;
/**
 * @typedef {{enableHighAccuracy:(!boolean|undefined),maximumAge:(!number|undefined),timeout:(!number|undefined)}}
 */
var PositionOptions;
/**
 * @typedef {{assertion:!string,idp:!RTCIdentityProviderDetails}}
 */
var RTCIdentityAssertionResult;
/**
 * @typedef {{bytesSent:(!number|undefined),packetsSent:(!number|undefined),codecId:(!string|undefined),kind:!string,ssrc:!number,transportId:(!string|undefined),averageRTCPInterval:(!number|undefined),mediaType:(!string|undefined),id:!string,timestamp:!DOMHighResTimeStamp,type:!string}}
 */
var RTCSentRtpStreamStats;
/**
 * @typedef {{authenticatorAttachment:(!string|undefined),requireResidentKey:(!boolean|undefined),residentKey:(!string|undefined),userVerification:(!string|undefined)}}
 */
var AuthenticatorSelectionCriteria;
/**
 * @typedef {{attributeFilter:(!Array<!string>|undefined),attributeOldValue:(!boolean|undefined),attributes:(!boolean|undefined),characterData:(!boolean|undefined),characterDataOldValue:(!boolean|undefined),childList:(!boolean|undefined),subtree:(!boolean|undefined)}}
 */
var MutationObserverInit;
/**
 * @typedef {{code:!string,sourceMap:(!Object|undefined),label:(!string|undefined)}}
 */
var GPUShaderModuleDescriptor;
/**
 * @record
 */
var RTCAnswerOptions;
/**
 * @typedef {{modulusLength:!number,publicExponent:!BigInteger,name:!string}}
 */
var RsaKeyAlgorithm;
/**
 * @typedef {{allowedDevices:!Array<!AllowedBluetoothDevice>}}
 */
var BluetoothPermissionStorage;
/**
 * @typedef {{persisted:(!boolean|undefined),bubbles:(!boolean|undefined),cancelable:(!boolean|undefined),composed:(!boolean|undefined)}}
 */
var PageTransitionEventInit;
/**
 * @typedef {{originTime:(!DOMHighResTimeStamp|undefined)}}
 */
var DocumentTimelineOptions;
/**
 * @typedef {{action:(!string|undefined),notification:!Notification,bubbles:(!boolean|undefined),cancelable:(!boolean|undefined),composed:(!boolean|undefined)}}
 */
var NotificationEventInit;
/**
 * @typedef {{group:(!string|undefined),message:!string}}
 */
var GenerateTestReportParameters;
/**
 * @typedef {{behavior:(!string|undefined)}}
 */
var ScrollOptions;
/**
 * @typedef {{namedCurve:!NamedCurve,name:!string}}
 */
var EcKeyImportParams;
/**
 * @typedef {{length:!number,numberOfChannels:(!number|undefined),sampleRate:!number}}
 */
var OfflineAudioContextOptions;
/**
 * @typedef {{expires:(!DOMTimeStamp|undefined)}}
 */
var RTCCertificateExpiration;
/**
 * @typedef {{credential:(!string|undefined),credentialType:(!string|undefined),urls:StringOrStringArrayUnion,username:(!string|undefined)}}
 */
var RTCIceServer;
/**
 * @typedef {{preventScroll:(!boolean|undefined)}}
 */
var FocusOptions;
/**
 * @typedef {{preventClose:(!boolean|undefined),preventAbort:(!boolean|undefined),preventCancel:(!boolean|undefined),signal:(!AbortSignal|undefined)}}
 */
var StreamPipeOptions;
/**
 * @typedef {{headers:(!HeadersInit|undefined),status:(!number|undefined),statusText:(!string|undefined)}}
 */
var ResponseInit;
/**
 * @typedef {{renderedBuffer:!AudioBuffer,bubbles:(!boolean|undefined),cancelable:(!boolean|undefined),composed:(!boolean|undefined)}}
 */
var OfflineAudioCompletionEventInit;
/**
 * @typedef {{bytesReceived:(!number|undefined),bytesSent:(!number|undefined),dtlsCipher:(!string|undefined),dtlsState:!string,iceLocalUsernameFragment:(!string|undefined),iceRole:(!string|undefined),iceState:(!string|undefined),localCertificateId:(!string|undefined),packetsReceived:(!number|undefined),packetsSent:(!number|undefined),remoteCertificateId:(!string|undefined),rtcpTransportStatsId:(!string|undefined),selectedCandidatePairChanges:(!number|undefined),selectedCandidatePairId:(!string|undefined),srtpCipher:(!string|undefined),tlsGroup:(!string|undefined),tlsVersion:(!string|undefined),id:!string,timestamp:!DOMHighResTimeStamp,type:!string}}
 */
var RTCTransportStats;
/**
 * @typedef {{latencyHint:(!AudioContextLatencyCategoryOrDoubleUnion|undefined),sampleRate:(!number|undefined)}}
 */
var AudioContextOptions;
/**
 * @typedef {{delay:(!number|undefined),direction:(!string|undefined),duration:(!UnrestrictedDoubleOrStringUnion|undefined),easing:(!string|undefined),endDelay:(!number|undefined),fill:(!string|undefined),iterationStart:(!number|undefined),iterations:(!number|undefined)}}
 */
var EffectTiming;
/**
 * @typedef {{hash:!HashAlgorithmIdentifier,modulusLength:!number,publicExponent:!BigInteger,name:!string}}
 */
var RsaHashedKeyGenParams;
/**
 * @typedef {{depthReadOnly:(!boolean|undefined),stencilReadOnly:(!boolean|undefined),colorFormats:!Array<!string>,depthStencilFormat:(!string|undefined),sampleCount:(!GPUSize32|undefined),label:(!string|undefined)}}
 */
var GPURenderBundleEncoderDescriptor;
/**
 * @typedef {{applicationServerKey:(?BufferSourceOrStringUnion|undefined),userVisibleOnly:(!boolean|undefined)}}
 */
var PushSubscriptionOptionsInit;
/**
 * @typedef {{base64Certificate:!string,fingerprint:!string,fingerprintAlgorithm:!string,issuerCertificateId:(!string|undefined),id:!string,timestamp:!DOMHighResTimeStamp,type:!string}}
 */
var RTCCertificateStats;
/**
 * @typedef {{newVersion:(?number|undefined),oldVersion:(!number|undefined),bubbles:(!boolean|undefined),cancelable:(!boolean|undefined),composed:(!boolean|undefined)}}
 */
var IDBVersionChangeEventInit;
/**
 * @typedef {{fatal:(!boolean|undefined),ignoreBOM:(!boolean|undefined)}}
 */
var TextDecoderOptions;
/**
 * @typedef {{dataTransfer:(?DataTransfer|undefined),button:(!number|undefined),buttons:(!number|undefined),relatedTarget:(?EventTarget|undefined),clientX:(!number|undefined),clientY:(!number|undefined),screenX:(!number|undefined),screenY:(!number|undefined),movementX:(!number|undefined),movementY:(!number|undefined),altKey:(!boolean|undefined),ctrlKey:(!boolean|undefined),metaKey:(!boolean|undefined),modifierAltGraph:(!boolean|undefined),modifierCapsLock:(!boolean|undefined),modifierFn:(!boolean|undefined),modifierFnLock:(!boolean|undefined),modifierHyper:(!boolean|undefined),modifierNumLock:(!boolean|undefined),modifierScrollLock:(!boolean|undefined),modifierSuper:(!boolean|undefined),modifierSymbol:(!boolean|undefined),modifierSymbolLock:(!boolean|undefined),shiftKey:(!boolean|undefined),detail:(!number|undefined),view:(?Window|undefined),bubbles:(!boolean|undefined),cancelable:(!boolean|undefined),composed:(!boolean|undefined)}}
 */
var DragEventInit;
/**
 * @typedef {{alpha:(!boolean|undefined),colorSpace:(!string|undefined),desynchronized:(!boolean|undefined),willReadFrequently:(!boolean|undefined)}}
 */
var CanvasRenderingContext2DSettings;
/**
 * @typedef {{data:!BufferSource,format:!string,numberOfChannels:!number,numberOfFrames:!number,sampleRate:!number,timestamp:!number}}
 */
var AudioDataInit;
/**
 * @typedef {{bytesReceived:(!number|undefined),bytesSent:(!number|undefined),dataChannelIdentifier:(!number|undefined),label:(!string|undefined),messagesReceived:(!number|undefined),messagesSent:(!number|undefined),protocol:(!string|undefined),state:!string,id:!string,timestamp:!DOMHighResTimeStamp,type:!string}}
 */
var RTCDataChannelStats;
/**
 * @typedef {{local:(!RTCIceCandidate|undefined),remote:(!RTCIceCandidate|undefined)}}
 */
var RTCIceCandidatePair;
/**
 * @typedef {{data:!Blob,timecode:(!DOMHighResTimeStamp|undefined)}}
 */
var BlobEventInit;
/**
 * @typedef {{curve:(!Array<!number>|undefined),oversample:(!string|undefined),channelCount:(!number|undefined),channelCountMode:(!string|undefined),channelInterpretation:(!string|undefined)}}
 */
var WaveShaperOptions;
/**
 * @typedef {{appearance:(!number|undefined),device:!BluetoothDevice,manufacturerData:(!BluetoothManufacturerDataMap|undefined),name:(!string|undefined),rssi:(!number|undefined),serviceData:(!BluetoothServiceDataMap|undefined),txPower:(!number|undefined),uuids:(!Array<StringOrUnsignedLongUnion>|undefined),bubbles:(!boolean|undefined),cancelable:(!boolean|undefined),composed:(!boolean|undefined)}}
 */
var BluetoothAdvertisingEventInit;
/**
 * @typedef {{codecId:(!string|undefined),kind:!string,ssrc:!number,transportId:(!string|undefined),averageRTCPInterval:(!number|undefined),mediaType:(!string|undefined),id:!string,timestamp:!DOMHighResTimeStamp,type:!string}}
 */
var RTCRtpStreamStats;
/**
 * @typedef {{displayName:!string,id:!BufferSource,name:!string}}
 */
var PublicKeyCredentialUserEntity;
/**
 * @typedef {{readable:!ReadableStream,writable:!WritableStream}}
 */
var ReadableWritablePair;
/**
 * @typedef {{channels:(!number|undefined),clockRate:(!number|undefined),codecType:(!string|undefined),mimeType:!string,payloadType:!number,sdpFmtpLine:(!string|undefined),transportId:!string,implementation:(!string|undefined),id:!string,timestamp:!DOMHighResTimeStamp,type:!string}}
 */
var RTCCodecStats;
/**
 * @typedef {{colorSpace:(!string|undefined)}}
 */
var ImageDataSettings;
/**
 * @typedef {{view:!GPUTextureView,depthLoadValue:GPULoadOpOrFloatUnion,depthStoreOp:!string,depthReadOnly:(!boolean|undefined),stencilLoadValue:GPULoadOpOrGPUStencilValueUnion,stencilStoreOp:!string,stencilReadOnly:(!boolean|undefined)}}
 */
var GPURenderPassDepthStencilAttachment;
/**
 * @typedef {{value:(!ArrayBufferView|undefined),done:(!boolean|undefined)}}
 */
var ReadableStreamBYOBReadResult;
/**
 * @typedef {{is2D:(!boolean|undefined),m13:(!number|undefined),m14:(!number|undefined),m23:(!number|undefined),m24:(!number|undefined),m31:(!number|undefined),m32:(!number|undefined),m33:(!number|undefined),m34:(!number|undefined),m43:(!number|undefined),m44:(!number|undefined),a:(!number|undefined),b:(!number|undefined),c:(!number|undefined),d:(!number|undefined),e:(!number|undefined),f:(!number|undefined),m11:(!number|undefined),m12:(!number|undefined),m21:(!number|undefined),m22:(!number|undefined),m41:(!number|undefined),m42:(!number|undefined)}}
 */
var DOMMatrixInit;
/**
 * @typedef {{Q:(!number|undefined),detune:(!number|undefined),frequency:(!number|undefined),gain:(!number|undefined),type:(!string|undefined),channelCount:(!number|undefined),channelCountMode:(!string|undefined),channelInterpretation:(!string|undefined)}}
 */
var BiquadFilterOptions;
/**
 * @typedef {{config:(!VideoEncoderConfig|undefined),supported:(!boolean|undefined)}}
 */
var VideoEncoderSupport;
/**
 * @typedef {{error:!WebCodecsErrorCallback,output:!AudioDataOutputCallback}}
 */
var AudioDecoderInit;
/**
 * @typedef {{hash:!HashAlgorithmIdentifier,name:!string}}
 */
var EcdsaParams;
/**
 * @typedef {{hash:!HashAlgorithmIdentifier,name:!string}}
 */
var RsaHashedImportParams;
/**
 * @typedef {{exact:(!number|undefined),ideal:(!number|undefined),max:(!number|undefined),min:(!number|undefined)}}
 */
var ConstrainULongRange;
/**
 * @typedef {{mode:(!string|undefined),optionalFeatures:(!Array<*>|undefined),requiredFeatures:(!Array<*>|undefined),name:!string}}
 */
var XRPermissionDescriptor;
/**
 * @typedef {{bitrate:(!number|undefined),bitrateMode:(!string|undefined),codec:!string,displayHeight:(!number|undefined),displayWidth:(!number|undefined),hardwareAcceleration:(!string|undefined),height:!number,scalabilityMode:(!string|undefined),width:!number}}
 */
var VideoEncoderConfig;
/**
 * @typedef {{type:!string,count:!GPUSize32,pipelineStatistics:(!Array<!string>|undefined),label:(!string|undefined)}}
 */
var GPUQuerySetDescriptor;
/**
 * @typedef {{currentTime:(?number|undefined),timelineTime:(?number|undefined),bubbles:(!boolean|undefined),cancelable:(!boolean|undefined),composed:(!boolean|undefined)}}
 */
var AnimationPlaybackEventInit;
/**
 * @typedef {{receiver:!RTCRtpReceiver,streams:(!Array<!MediaStream>|undefined),track:!MediaStreamTrack,transceiver:!RTCRtpTransceiver,bubbles:(!boolean|undefined),cancelable:(!boolean|undefined),composed:(!boolean|undefined)}}
 */
var RTCTrackEventInit;
/**
 * @typedef {{contextTime:(!number|undefined),performanceTime:(!DOMHighResTimeStamp|undefined)}}
 */
var AudioTimestamp;
/**
 * @typedef {{highWaterMark:(!number|undefined),size:(!QueuingStrategySize|undefined)}}
 */
var QueuingStrategy;
/**
 * @typedef {{deltaMode:(!number|undefined),deltaX:(!number|undefined),deltaY:(!number|undefined),deltaZ:(!number|undefined),button:(!number|undefined),buttons:(!number|undefined),relatedTarget:(?EventTarget|undefined),clientX:(!number|undefined),clientY:(!number|undefined),screenX:(!number|undefined),screenY:(!number|undefined),movementX:(!number|undefined),movementY:(!number|undefined),altKey:(!boolean|undefined),ctrlKey:(!boolean|undefined),metaKey:(!boolean|undefined),modifierAltGraph:(!boolean|undefined),modifierCapsLock:(!boolean|undefined),modifierFn:(!boolean|undefined),modifierFnLock:(!boolean|undefined),modifierHyper:(!boolean|undefined),modifierNumLock:(!boolean|undefined),modifierScrollLock:(!boolean|undefined),modifierSuper:(!boolean|undefined),modifierSymbol:(!boolean|undefined),modifierSymbolLock:(!boolean|undefined),shiftKey:(!boolean|undefined),detail:(!number|undefined),view:(?Window|undefined),bubbles:(!boolean|undefined),cancelable:(!boolean|undefined),composed:(!boolean|undefined)}}
 */
var WheelEventInit;
/**
 * @typedef {{buffers:(!Array<?GPUVertexBufferLayout>|undefined),module:!GPUShaderModule,entryPoint:!string,constants:(!Object<!string,!GPUPipelineConstantValue>|undefined)}}
 */
var GPUVertexState;
/**
 * @typedef {{x:(!GPUIntegerCoordinate|undefined),y:(!GPUIntegerCoordinate|undefined)}}
 */
var GPUOrigin2DDict;
/**
 * @typedef {{buffered:(!boolean|undefined),types:(!Array<!string>|undefined)}}
 */
var ReportingObserverOptions;
/**
 * @typedef {{buffer:(?AudioBuffer|undefined),disableNormalization:(!boolean|undefined),channelCount:(!number|undefined),channelCountMode:(!string|undefined),channelInterpretation:(!string|undefined)}}
 */
var ConvolverOptions;
/**
 * @typedef {{codedHeight:!number,codedWidth:!number,displayHeight:(!number|undefined),displayWidth:(!number|undefined),duration:(!number|undefined),format:!string,timestamp:(!number|undefined),visibleRect:(!VideoFrameRect|undefined)}}
 */
var VideoFramePlaneInit;
/**
 * @typedef {{audioLevel:(!number|undefined),contributorSsrc:!number,inboundRtpStreamId:!string,packetsContributedTo:(!number|undefined),id:!string,timestamp:!DOMHighResTimeStamp,type:!string}}
 */
var RTCRtpContributingSourceStats;
/**
 * @typedef {{streamIdentifier:(!string|undefined),trackIds:(!Array<!string>|undefined),id:!string,timestamp:!DOMHighResTimeStamp,type:!string}}
 */
var RTCMediaStreamStats;
/**
 * @typedef {{tag:(!string|undefined)}}
 */
var GetNotificationOptions;
/**
 * @typedef {{id:(!string|undefined),timeline:(?AnimationTimeline|undefined),composite:(!string|undefined),pseudoElement:(?CSSOMString|undefined),delay:(!number|undefined),direction:(!string|undefined),duration:(!UnrestrictedDoubleOrStringUnion|undefined),easing:(!string|undefined),endDelay:(!number|undefined),fill:(!string|undefined),iterationStart:(!number|undefined),iterations:(!number|undefined)}}
 */
var KeyframeAnimationOptions;
/**
 * @typedef {{quality:(!number|undefined),type:(!string|undefined)}}
 */
var ImageEncodeOptions;
/**
 * @typedef {{width:!GPUIntegerCoordinate,depthOrArrayLayers:(!GPUIntegerCoordinate|undefined),height:(!GPUIntegerCoordinate|undefined)}}
 */
var GPUExtent3DDict;
/**
 * @typedef {{size:!GPUExtent3D,dimension:(!string|undefined),mipLevelCount:(!GPUIntegerCoordinate|undefined),sampleCount:(!GPUSize32|undefined),format:!string,usage:!GPUFlagsConstant,label:(!string|undefined)}}
 */
var GPUTextureDescriptor;
/**
 * @typedef {{data:(?string|undefined),inputType:(!string|undefined),isComposing:(!boolean|undefined),detail:(!number|undefined),view:(?Window|undefined),bubbles:(!boolean|undefined),cancelable:(!boolean|undefined),composed:(!boolean|undefined)}}
 */
var InputEventInit;
/**
 * @typedef {{read:(!boolean|undefined),support:(!string|undefined),write:(!BufferSource|undefined)}}
 */
var AuthenticationExtensionsLargeBlobInputs;
/**
 * @typedef {{delegatesFocus:(!boolean|undefined),mode:!string,slotAssignment:(!string|undefined)}}
 */
var ShadowRootInit;
/**
 * @typedef {{x:(?number|undefined),y:(?number|undefined),z:(?number|undefined)}}
 */
var DeviceMotionEventAccelerationInit;
/**
 * @typedef {{codec:!string,description:(!BufferSource|undefined),numberOfChannels:!number,sampleRate:!number}}
 */
var AudioDecoderConfig;
/**
 * @typedef {{gain:(!number|undefined),channelCount:(!number|undefined),channelCountMode:(!string|undefined),channelInterpretation:(!string|undefined)}}
 */
var GainOptions;
/**
 * @typedef {{element:!string,initial:!number,maximum:(!number|undefined)}}
 */
var TableDescriptor;
/**
 * @typedef {{disableNormalization:(!boolean|undefined)}}
 */
var PeriodicWaveConstraints;
/**
 * @typedef {{mode:(!string|undefined)}}
 */
var ReadableStreamGetReaderOptions;
/**
 * @typedef {{w:(!number|undefined),x:(!number|undefined),y:(!number|undefined),z:(!number|undefined)}}
 */
var DOMPointInit;
/**
 * @typedef {{delayTime:(!number|undefined),maxDelayTime:(!number|undefined),channelCount:(!number|undefined),channelCountMode:(!string|undefined),channelInterpretation:(!string|undefined)}}
 */
var DelayOptions;
/**
 * @typedef {{colorSpaceConversion:(!string|undefined),imageOrientation:(!string|undefined),premultiplyAlpha:(!string|undefined),resizeHeight:(!number|undefined),resizeQuality:(!string|undefined),resizeWidth:(!number|undefined)}}
 */
var ImageBitmapOptions;
/**
 * @typedef {{composite:(!CompositeOperationOrAutoOrCompositeOperationOrAutoArrayUnion|undefined),easing:(!StringOrStringArrayUnion|undefined),offset:(!DoubleOrDoubleArrayUnion|undefined)}}
 */
var BasePropertyIndexedKeyframe;
/**
 * @typedef {{value:(*|undefined),done:(!boolean|undefined)}}
 */
var ReadableStreamDefaultReadResult;
/**
 * @typedef {{companyIdentifier:!number,dataPrefix:(!BufferSource|undefined),mask:(!BufferSource|undefined)}}
 */
var BluetoothManufacturerDataFilterInit;
/**
 * @typedef {{bytesPerRow:(!GPUSize32|undefined),offset:(!GPUSize64|undefined),rowsPerImage:(!GPUSize32|undefined)}}
 */
var GPUImageDataLayout;
/**
 * @typedef {{allowCredentials:(!Array<!PublicKeyCredentialDescriptor>|undefined),challenge:!BufferSource,extensions:(!AuthenticationExtensionsClientInputs|undefined),rpId:(!string|undefined),timeout:(!number|undefined),userVerification:(!string|undefined)}}
 */
var PublicKeyCredentialRequestOptions;
/**
 * @typedef {{error:!GPUError,bubbles:(!boolean|undefined),cancelable:(!boolean|undefined),composed:(!boolean|undefined)}}
 */
var GPUUncapturedErrorEventInit;
/**
 * @typedef {{credentials:(!string|undefined)}}
 */
var WorkletOptions;
/**
 * @typedef {{feedback:!Array<!number>,feedforward:!Array<!number>,channelCount:(!number|undefined),channelCountMode:(!string|undefined),channelInterpretation:(!string|undefined)}}
 */
var IIRFilterOptions;
/**
 * @typedef {{signal:(!AbortSignal|undefined),password:(!PasswordCredentialInit|undefined),federated:(!FederatedCredentialInit|undefined),publicKey:(!PublicKeyCredentialCreationOptions|undefined)}}
 */
var CredentialCreationOptions;
/**
 * @typedef {{capture:(!boolean|undefined)}}
 */
var EventListenerOptions;
/**
 * @typedef {{iconURL:(!string|undefined),name:(!string|undefined),origin:!string,password:!string,id:!string}}
 */
var PasswordCredentialData;
/**
 * @typedef {{endContainer:!Node,endOffset:!number,startContainer:!Node,startOffset:!number}}
 */
var StaticRangeInit;
/**
 * @typedef {{numberOfInputs:(!number|undefined),channelCount:(!number|undefined),channelCountMode:(!string|undefined),channelInterpretation:(!string|undefined)}}
 */
var ChannelMergerOptions;
/**
 * @typedef {{deviceId:(!string|undefined),name:!string}}
 */
var DevicePermissionDescriptor;
/**
 * @record
 */
var RTCOfferAnswerOptions;
/**
 * @typedef {{clipboardData:(?DataTransfer|undefined),bubbles:(!boolean|undefined),cancelable:(!boolean|undefined),composed:(!boolean|undefined)}}
 */
var ClipboardEventInit;
/**
 * @typedef {{length:!number,name:!string}}
 */
var AesDerivedKeyParams;
/**
 * @typedef {{scope:(!string|undefined),type:(!string|undefined),updateViaCache:(!string|undefined)}}
 */
var RegistrationOptions;
/**
 * @typedef {{clipped:(!boolean|undefined),fill:(!boolean|undefined),markers:(!boolean|undefined),stroke:(!boolean|undefined)}}
 */
var SVGBoundingBoxOptions;
/**
 * @typedef {{promise:!Promise<*>,reason:(*|undefined),bubbles:(!boolean|undefined),cancelable:(!boolean|undefined),composed:(!boolean|undefined)}}
 */
var PromiseRejectionEventInit;
/**
 * @typedef {{encodings:!Array<!RTCRtpEncodingParameters>,transactionId:!string,codecs:!Array<!RTCRtpCodecParameters>,headerExtensions:!Array<!RTCRtpHeaderExtensionParameters>,rtcp:!RTCRtcpParameters}}
 */
var RTCRtpSendParameters;
/**
 * @typedef {{absolute:(!boolean|undefined),alpha:(?number|undefined),beta:(?number|undefined),gamma:(?number|undefined),bubbles:(!boolean|undefined),cancelable:(!boolean|undefined),composed:(!boolean|undefined)}}
 */
var DeviceOrientationEventInit;
/**
 * @typedef {{pan:(!number|undefined),channelCount:(!number|undefined),channelCountMode:(!string|undefined),channelInterpretation:(!string|undefined)}}
 */
var StereoPannerOptions;
/**
 * @typedef {{uri:(!string|undefined)}}
 */
var RTCRtpHeaderExtensionCapability;
/**
 * @typedef {{arrayLayerCount:(!GPUIntegerCoordinate|undefined),aspect:(!string|undefined),baseArrayLayer:(!GPUIntegerCoordinate|undefined),baseMipLevel:(!GPUIntegerCoordinate|undefined),dimension:(!string|undefined),format:(!string|undefined),mipLevelCount:(!GPUIntegerCoordinate|undefined),label:(!string|undefined)}}
 */
var GPUTextureViewDescriptor;
/**
 * @typedef {{gamepad:!Gamepad,bubbles:(!boolean|undefined),cancelable:(!boolean|undefined),composed:(!boolean|undefined)}}
 */
var GamepadEventInit;
/**
 * @typedef {{left:(!number|undefined),top:(!number|undefined),behavior:(!string|undefined)}}
 */
var ScrollToOptions;
/**
 * @typedef {{mediaSourceId:(!string|undefined),framesCaptured:(!number|undefined),framesSent:(!number|undefined),hugeFramesSent:(!number|undefined),keyFramesSent:(!number|undefined),frameHeight:(!number|undefined),frameWidth:(!number|undefined),framesPerSecond:(!number|undefined),ended:(!boolean|undefined),kind:!string,trackIdentifier:(!string|undefined),priority:(!string|undefined),remoteSource:(!boolean|undefined),id:!string,timestamp:!DOMHighResTimeStamp,type:!string}}
 */
var RTCSenderVideoTrackAttachmentStats;
/**
 * @typedef {{color:!GPUBlendComponent,alpha:!GPUBlendComponent}}
 */
var GPUBlendState;
/**
 * @typedef {{burstDiscardCount:(!number|undefined),burstDiscardRate:(!number|undefined),burstLossCount:(!number|undefined),burstLossRate:(!number|undefined),burstPacketsDiscarded:(!number|undefined),burstPacketsLost:(!number|undefined),framesDropped:(!number|undefined),fullFramesLost:(!number|undefined),gapDiscardRate:(!number|undefined),gapLossRate:(!number|undefined),jitter:(!number|undefined),packetsDiscarded:(!number|undefined),packetsLost:(!number|undefined),packetsReceived:(!number|undefined),packetsRepaired:(!number|undefined),partialFramesLost:(!number|undefined),codecId:(!string|undefined),kind:!string,ssrc:!number,transportId:(!string|undefined),averageRTCPInterval:(!number|undefined),mediaType:(!string|undefined),id:!string,timestamp:!DOMHighResTimeStamp,type:!string}}
 */
var RTCReceivedRtpStreamStats;
/**
 * @typedef {{error:!WebCodecsErrorCallback,output:!EncodedVideoChunkOutputCallback}}
 */
var VideoEncoderInit;
/**
 * @typedef {{bubbles:(!boolean|undefined),cancelable:(!boolean|undefined),composed:(!boolean|undefined)}}
 */
var ExtendableEventInit;
/**
 * @typedef {{bindGroupLayouts:!Array<!GPUBindGroupLayout>,label:(!string|undefined)}}
 */
var GPUPipelineLayoutDescriptor;
/**
 * @typedef {{mediation:(!string|undefined),signal:(!AbortSignal|undefined),password:(!boolean|undefined),federated:(!FederatedCredentialRequestOptions|undefined),publicKey:(!PublicKeyCredentialRequestOptions|undefined)}}
 */
var CredentialRequestOptions;
/**
 * @typedef {{data:(!PushMessageDataInit|undefined),bubbles:(!boolean|undefined),cancelable:(!boolean|undefined),composed:(!boolean|undefined)}}
 */
var PushEventInit;
/**
 * @typedef {{mediaSourceId:(!string|undefined),framesCaptured:(!number|undefined),framesSent:(!number|undefined),hugeFramesSent:(!number|undefined),keyFramesSent:(!number|undefined),frameHeight:(!number|undefined),frameWidth:(!number|undefined),framesPerSecond:(!number|undefined),ended:(!boolean|undefined),kind:!string,trackIdentifier:(!string|undefined),priority:(!string|undefined),remoteSource:(!boolean|undefined),id:!string,timestamp:!DOMHighResTimeStamp,type:!string}}
 */
var RTCVideoSenderStats;
/**
 * @typedef {{alg:!COSEAlgorithmIdentifier,type:!string}}
 */
var PublicKeyCredentialParameters;
/**
 * @typedef {{durability:(!string|undefined)}}
 */
var IDBTransactionOptions;
/**
 * @typedef {{binding:!GPUIndex32,visibility:!GPUFlagsConstant,buffer:(!GPUBufferBindingLayout|undefined),externalTexture:(!GPUExternalTextureBindingLayout|undefined),sampler:(!GPUSamplerBindingLayout|undefined),storageTexture:(!GPUStorageTextureBindingLayout|undefined),texture:(!GPUTextureBindingLayout|undefined)}}
 */
var GPUBindGroupLayoutEntry;
/**
 * @typedef {{requiredFeatures:(!Array<!string>|undefined),requiredLimits:(!Object<!string,!GPUSize32>|undefined),label:(!string|undefined)}}
 */
var GPUDeviceDescriptor;
/**
 * @typedef {{codecs:!Array<!RTCRtpCodecParameters>,headerExtensions:!Array<!RTCRtpHeaderExtensionParameters>,rtcp:!RTCRtcpParameters}}
 */
var RTCRtpReceiveParameters;
/**
 * @typedef {{extends:(!string|undefined)}}
 */
var ElementDefinitionOptions;
/**
 * @typedef {{error:!WebCodecsErrorCallback,output:!VideoFrameOutputCallback}}
 */
var VideoDecoderInit;
/**
 * @typedef {{track:!MediaStreamTrack,bubbles:(!boolean|undefined),cancelable:(!boolean|undefined),composed:(!boolean|undefined)}}
 */
var MediaStreamTrackEventInit;
/**
 * @typedef {{ended:(!boolean|undefined),kind:!string,trackIdentifier:(!string|undefined),priority:(!string|undefined),remoteSource:(!boolean|undefined),id:!string,timestamp:!DOMHighResTimeStamp,type:!string}}
 */
var RTCMediaHandlerStats;
/**
 * @typedef {{address:(?string|undefined),errorCode:!number,errorText:(!string|undefined),port:(?number|undefined),url:(!string|undefined),bubbles:(!boolean|undefined),cancelable:(!boolean|undefined),composed:(!boolean|undefined)}}
 */
var RTCPeerConnectionIceErrorEventInit;
/**
 * @typedef {{modulusLength:!number,publicExponent:!BigInteger,name:!string}}
 */
var RsaKeyGenParams;
/**
 * @typedef {{read:(!number|undefined),written:(!number|undefined)}}
 */
var TextEncoderEncodeIntoResult;
/**
 * @typedef {{audioCapabilities:(!Array<!MediaKeySystemMediaCapability>|undefined),distinctiveIdentifier:(!string|undefined),initDataTypes:(!Array<!string>|undefined),label:(!string|undefined),persistentState:(!string|undefined),sessionTypes:(!Array<!string>|undefined),videoCapabilities:(!Array<!MediaKeySystemMediaCapability>|undefined)}}
 */
var MediaKeySystemConfiguration;
/**
 * @typedef {{source:ImageBitmapOrHTMLCanvasElementOrOffscreenCanvasUnion,origin:(!GPUOrigin2D|undefined)}}
 */
var GPUImageCopyExternalImage;
/**
 * @typedef {{data:(!string|undefined),detail:(!number|undefined),view:(?Window|undefined),bubbles:(!boolean|undefined),cancelable:(!boolean|undefined),composed:(!boolean|undefined)}}
 */
var CompositionEventInit;
/**
 * @typedef {{baseURL:(!string|undefined),disabled:(!boolean|undefined),media:(!MediaListOrStringUnion|undefined)}}
 */
var CSSStyleSheetInit;
/**
 * @typedef {{texture:!GPUTexture,aspect:(!string|undefined),mipLevel:(!GPUIntegerCoordinate|undefined),origin:(!GPUOrigin3D|undefined)}}
 */
var GPUImageCopyTexture;
/**
 * @typedef {{once:(!boolean|undefined),passive:(!boolean|undefined),signal:(!AbortSignal|undefined),capture:(!boolean|undefined)}}
 */
var AddEventListenerOptions;
/**
 * @typedef {{error:!string,message:(!string|undefined),bubbles:(!boolean|undefined),cancelable:(!boolean|undefined),composed:(!boolean|undefined)}}
 */
var SpeechRecognitionErrorEventInit;
/**
 * @typedef {{estimatedPlayoutTimestamp:(!DOMHighResTimeStamp|undefined),framesDecoded:(!number|undefined),framesDropped:(!number|undefined),framesReceived:(!number|undefined),fullFramesLost:(!number|undefined),jitterBufferDelay:(!number|undefined),jitterBufferEmittedCount:(!number|undefined),keyFramesReceived:(!number|undefined),partialFramesLost:(!number|undefined),frameHeight:(!number|undefined),frameWidth:(!number|undefined),framesPerSecond:(!number|undefined),ended:(!boolean|undefined),kind:!string,trackIdentifier:(!string|undefined),priority:(!string|undefined),remoteSource:(!boolean|undefined),id:!string,timestamp:!DOMHighResTimeStamp,type:!string}}
 */
var RTCVideoReceiverStats;
/**
 * @typedef {{coneInnerAngle:(!number|undefined),coneOuterAngle:(!number|undefined),coneOuterGain:(!number|undefined),distanceModel:(!string|undefined),maxDistance:(!number|undefined),orientationX:(!number|undefined),orientationY:(!number|undefined),orientationZ:(!number|undefined),panningModel:(!string|undefined),positionX:(!number|undefined),positionY:(!number|undefined),positionZ:(!number|undefined),refDistance:(!number|undefined),rolloffFactor:(!number|undefined),channelCount:(!number|undefined),channelCountMode:(!string|undefined),channelInterpretation:(!string|undefined)}}
 */
var PannerOptions;
/**
 * @typedef {{generateAssertion:!GenerateAssertionCallback,validateAssertion:!ValidateAssertionCallback}}
 */
var RTCIdentityProvider;
/**
 * @typedef {{acceleration:(!DeviceMotionEventAccelerationInit|undefined),accelerationIncludingGravity:(!DeviceMotionEventAccelerationInit|undefined),interval:(!number|undefined),rotationRate:(!DeviceMotionEventRotationRateInit|undefined),bubbles:(!boolean|undefined),cancelable:(!boolean|undefined),composed:(!boolean|undefined)}}
 */
var DeviceMotionEventInit;
/**
 * @typedef {{concealedSamples:(!number|undefined),concealmentEvents:(!number|undefined),estimatedPlayoutTimestamp:(!DOMHighResTimeStamp|undefined),insertedSamplesForDeceleration:(!number|undefined),jitterBufferDelay:(!number|undefined),jitterBufferEmittedCount:(!number|undefined),removedSamplesForAcceleration:(!number|undefined),silentConcealedSamples:(!number|undefined),totalSamplesReceived:(!number|undefined),audioLevel:(!number|undefined),totalAudioEnergy:(!number|undefined),totalSamplesDuration:(!number|undefined),voiceActivityFlag:(!boolean|undefined),ended:(!boolean|undefined),kind:!string,trackIdentifier:(!string|undefined),priority:(!string|undefined),remoteSource:(!boolean|undefined),id:!string,timestamp:!DOMHighResTimeStamp,type:!string}}
 */
var RTCReceiverAudioTrackAttachmentStats;
/**
 * @typedef {{inputBuffer:!AudioBuffer,outputBuffer:!AudioBuffer,playbackTime:!number,bubbles:(!boolean|undefined),cancelable:(!boolean|undefined),composed:(!boolean|undefined)}}
 */
var AudioProcessingEventInit;
/**
 * @typedef {{bubbles:(!boolean|undefined),cancelable:(!boolean|undefined),composed:(!boolean|undefined)}}
 */
var EventInit;
/**
 * @typedef {{boundingClientRect:!DOMRectInit,intersectionRatio:!number,intersectionRect:!DOMRectInit,isIntersecting:!boolean,rootBounds:?DOMRectInit,target:!Element,time:!DOMHighResTimeStamp}}
 */
var IntersectionObserverEntryInit;
/**
 * @typedef {{length:!number,name:!string}}
 */
var AesKeyAlgorithm;
/**
 * @typedef {{peerIdentity:(!string|undefined),protocol:(!string|undefined),usernameHint:(!string|undefined)}}
 */
var RTCIdentityProviderOptions;
/**
 * @typedef {{body:(?BodyInit|undefined),cache:(!string|undefined),credentials:(!string|undefined),headers:(!HeadersInit|undefined),integrity:(!string|undefined),keepalive:(!boolean|undefined),method:(!string|undefined),mode:(!string|undefined),redirect:(!string|undefined),referrer:(!string|undefined),referrerPolicy:(!string|undefined),signal:(?AbortSignal|undefined),window:(*|undefined)}}
 */
var RequestInit;
/**
 * @typedef {{presentationStyle:(!string|undefined)}}
 */
var ClipboardItemOptions;
/**
 * @typedef {{direction:(!string|undefined),sendEncodings:(!Array<!RTCRtpEncodingParameters>|undefined),streams:(!Array<!MediaStream>|undefined)}}
 */
var RTCRtpTransceiverInit;
/**
 * @typedef {{buffer:!GPUBuffer,offset:(!GPUSize64|undefined),size:(!GPUSize64|undefined)}}
 */
var GPUBufferBinding;
/**
 * @typedef {{is:(!string|undefined)}}
 */
var ElementCreationOptions;
/**
 * @typedef {{channel:!RTCDataChannel,bubbles:(!boolean|undefined),cancelable:(!boolean|undefined),composed:(!boolean|undefined)}}
 */
var RTCDataChannelEventInit;
/**
 * @const
 */
var console;
/**
 * @param {!string=} label
 * @return {undefined}
 */
console.timeEnd = function(label) {}
/**
 * @param {...*} data
 * @return {undefined}
 */
console.debug = function(data) {}
/**
 * @param {...*} data
 * @return {undefined}
 */
console.log = function(data) {}
/**
 * @param {!string=} label
 * @return {undefined}
 */
console.count = function(label) {}
/**
 * @return {undefined}
 */
console.clear = function() {}
/**
 * @param {...*} data
 * @return {undefined}
 */
console.dirxml = function(data) {}
/**
 * @param {...*} data
 * @return {undefined}
 */
console.error = function(data) {}
/**
 * @param {*=} item
 * @param {?Object=} options
 * @return {undefined}
 */
console.dir = function(item,options) {}
/**
 * @param {!string=} label
 * @return {undefined}
 */
console.countReset = function(label) {}
/**
 * @param {...*} data
 * @return {undefined}
 */
console.warn = function(data) {}
/**
 * @param {...*} data
 * @return {undefined}
 */
console.trace = function(data) {}
/**
 * @return {undefined}
 */
console.groupEnd = function() {}
/**
 * @param {!boolean=} condition
 * @param {...*} data
 * @return {undefined}
 */
console.assert = function(condition,data) {}
/**
 * @param {!string=} label
 * @param {...*} data
 * @return {undefined}
 */
console.timeLog = function(label,data) {}
/**
 * @param {!string=} label
 * @return {undefined}
 */
console.time = function(label) {}
/**
 * @param {*=} tabularData
 * @param {!Array<!string>=} properties
 * @return {undefined}
 */
console.table = function(tabularData,properties) {}
/**
 * @param {...*} data
 * @return {undefined}
 */
console.groupCollapsed = function(data) {}
/**
 * @param {...*} data
 * @return {undefined}
 */
console.info = function(data) {}
/**
 * @param {...*} data
 * @return {undefined}
 */
console.group = function(data) {}
/**
 * @const
 */
var CSS;
/**
 * @param {!CSSOMString} arg0
 * @param {!CSSOMString=} arg1
 * @return {!boolean}
 */
CSS.supports = function(arg0,arg1) {}
/**
 * @param {!CSSOMString} ident
 * @return {!CSSOMString}
 */
CSS.escape = function(ident) {}
/**
 * @const
 */
var WebAssembly;
/**
 * @param {!BufferSource} bytes
 * @return {!Promise<!WebAssembly.Module>}
 */
WebAssembly.compile = function(bytes) {}
/**
 * @param {!Promise<!Response>} source
 * @param {!Object=} importObject
 * @return {!Promise<!WebAssemblyInstantiatedSource>}
 */
WebAssembly.instantiateStreaming = function(source,importObject) {}
/**
 * @param {(!BufferSource|!WebAssembly.Module)} arg0
 * @param {!Object=} arg1
 * @return {(!Promise<!WebAssemblyInstantiatedSource>|!Promise<!WebAssembly.Instance>)}
 */
WebAssembly.instantiate = function(arg0,arg1) {}
/**
 * @param {!Promise<!Response>} source
 * @return {!Promise<!WebAssembly.Module>}
 */
WebAssembly.compileStreaming = function(source) {}
/**
 * @param {!BufferSource} bytes
 * @return {!boolean}
 * @nosideeffects
 */
WebAssembly.validate = function(bytes) {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function PerformanceTiming() {}
/** @type {!number} */ PerformanceTiming.prototype.connectEnd;
/** @type {!number} */ PerformanceTiming.prototype.connectStart;
/** @type {!number} */ PerformanceTiming.prototype.domComplete;
/** @type {!number} */ PerformanceTiming.prototype.domContentLoadedEventEnd;
/** @type {!number} */ PerformanceTiming.prototype.domContentLoadedEventStart;
/** @type {!number} */ PerformanceTiming.prototype.domInteractive;
/** @type {!number} */ PerformanceTiming.prototype.domLoading;
/** @type {!number} */ PerformanceTiming.prototype.domainLookupEnd;
/** @type {!number} */ PerformanceTiming.prototype.domainLookupStart;
/** @type {!number} */ PerformanceTiming.prototype.fetchStart;
/** @type {!number} */ PerformanceTiming.prototype.loadEventEnd;
/** @type {!number} */ PerformanceTiming.prototype.loadEventStart;
/** @type {!number} */ PerformanceTiming.prototype.navigationStart;
/** @type {!number} */ PerformanceTiming.prototype.redirectEnd;
/** @type {!number} */ PerformanceTiming.prototype.redirectStart;
/** @type {!number} */ PerformanceTiming.prototype.requestStart;
/** @type {!number} */ PerformanceTiming.prototype.responseEnd;
/** @type {!number} */ PerformanceTiming.prototype.responseStart;
/** @type {!number} */ PerformanceTiming.prototype.secureConnectionStart;
/** @type {!number} */ PerformanceTiming.prototype.unloadEventEnd;
/** @type {!number} */ PerformanceTiming.prototype.unloadEventStart;
/**
 * @return {!Object}
 * @override
 */
PerformanceTiming.prototype.toJSON = function() {}
/**
 * @constructor
 * @private
 * @extends {CSSRule}
 * @nosideeffects
 */
function CSSImportRule() {}
/** @type {!string} */ CSSImportRule.prototype.href;
/** @type {!MediaList} */ CSSImportRule.prototype.media;
/** @type {!CSSStyleSheet} */ CSSImportRule.prototype.styleSheet;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function WakeLock() {}
/**
 * @param {!string=} type
 * @return {!Promise<!WakeLockSentinel>}
 */
WakeLock.prototype.request = function(type) {}
/**
 * @constructor
 * @private
 * @extends {SVGGraphicsElement}
 * @nosideeffects
 */
function SVGForeignObjectElement() {}
/** @type {!SVGAnimatedLength} */ SVGForeignObjectElement.prototype.height;
/** @type {!SVGAnimatedLength} */ SVGForeignObjectElement.prototype.width;
/** @type {!SVGAnimatedLength} */ SVGForeignObjectElement.prototype.x;
/** @type {!SVGAnimatedLength} */ SVGForeignObjectElement.prototype.y;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @implements {Iterable<!Array<!CSSOMString|!Array<!number>>>}
 * @nosideeffects
 */
function CSSFontFeatureValuesMap() {}
/**
 * @param {!CSSOMString} featureValueName
 * @param {(!number|!Array<!number>)} values
 * @return {undefined}
 */
CSSFontFeatureValuesMap.prototype.set = function(featureValueName,values) {}
/** @const {number} */ CSSFontFeatureValuesMap.prototype.size;
/**
 * @param {!CSSOMString} key
 * @return {!boolean}
 * @nosideeffects
 */
CSSFontFeatureValuesMap.prototype.has = function(key) {}
/**
 * @param {!CSSOMString} key
 * @return {?Array<!number>}
 * @nosideeffects
 */
CSSFontFeatureValuesMap.prototype.get = function(key) {}
/**
 * @return {!Iterator<!CSSOMString>}
 * @nosideeffects
 */
CSSFontFeatureValuesMap.prototype.keys = function() {}
/**
 * @return {!Iterator<!Array<!number>>}
 * @nosideeffects
 */
CSSFontFeatureValuesMap.prototype.values = function() {}
/**
 * @return {!Iterator<!Array<!CSSOMString|!Array<!number>>>}
 * @nosideeffects
 */
CSSFontFeatureValuesMap.prototype.entries = function() {};
/**
 * @return {!Iterator<!Array<!CSSOMString|!Array<!number>>>}
 * @nosideeffects
 */
CSSFontFeatureValuesMap.prototype[Symbol.iterator] = function() {};
/**
 * @param {function(!Array<!number>, !CSSOMString, MAP)} callback
 * @this {MAP}
 * @template MAP
 */
CSSFontFeatureValuesMap.prototype.forEach = function(callback) {};
/**
 * @param {!CSSOMString} key
 * @return {!boolean}
 */
CSSFontFeatureValuesMap.prototype.delete = function(key) {}
/**
 * @return {undefined}
 */
CSSFontFeatureValuesMap.prototype.clear = function() {}
/**
 * @constructor
 * @extends {Object}
 * @param {!MemoryDescriptor} descriptor
 */
WebAssembly.Memory = function(descriptor) {}
/** @type {!ArrayBuffer} */ WebAssembly.Memory.prototype.buffer;
/**
 * @param {!number} delta
 * @return {!number}
 */
WebAssembly.Memory.prototype.grow = function(delta) {}
/**
 * @constructor
 * @extends {Credential}
 * @param {(!HTMLFormElement|!PasswordCredentialData)} arg0
 */
function PasswordCredential(arg0) {}
/** @type {!string} */ PasswordCredential.prototype.password;
/** @type {!string} */ PasswordCredential.prototype.iconURL;
/** @type {!string} */ PasswordCredential.prototype.name;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function SVGAnimatedBoolean() {}
/** @type {!boolean} */ SVGAnimatedBoolean.prototype.animVal;
/** @type {!boolean} */ SVGAnimatedBoolean.prototype.baseVal;
/**
 * @constructor
 * @private
 * @extends {SVGElement}
 * @nosideeffects
 */
function SVGFEDiffuseLightingElement() {}
/** @type {!SVGAnimatedNumber} */ SVGFEDiffuseLightingElement.prototype.diffuseConstant;
/** @type {!SVGAnimatedString} */ SVGFEDiffuseLightingElement.prototype.in1;
/** @type {!SVGAnimatedNumber} */ SVGFEDiffuseLightingElement.prototype.kernelUnitLengthX;
/** @type {!SVGAnimatedNumber} */ SVGFEDiffuseLightingElement.prototype.kernelUnitLengthY;
/** @type {!SVGAnimatedNumber} */ SVGFEDiffuseLightingElement.prototype.surfaceScale;
/** @type {!SVGAnimatedLength} */ SVGFEDiffuseLightingElement.prototype.height;
/** @type {!SVGAnimatedString} */ SVGFEDiffuseLightingElement.prototype.result;
/** @type {!SVGAnimatedLength} */ SVGFEDiffuseLightingElement.prototype.width;
/** @type {!SVGAnimatedLength} */ SVGFEDiffuseLightingElement.prototype.x;
/** @type {!SVGAnimatedLength} */ SVGFEDiffuseLightingElement.prototype.y;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function SVGPointList() {}
/** @type {!number} */ SVGPointList.prototype.length;
/** @type {!number} */ SVGPointList.prototype.numberOfItems;
/**
 * @param {!number} index
 * @return {!DOMPoint}
 */
SVGPointList.prototype.removeItem = function(index) {}
/**
 * @param {!DOMPoint} newItem
 * @param {!number} index
 * @return {!DOMPoint}
 */
SVGPointList.prototype.insertItemBefore = function(newItem,index) {}
/**
 * @param {!DOMPoint} newItem
 * @param {!number} index
 * @return {!DOMPoint}
 */
SVGPointList.prototype.replaceItem = function(newItem,index) {}
/**
 * @return {undefined}
 */
SVGPointList.prototype.clear = function() {}
/**
 * @param {!number} index
 * @return {!DOMPoint}
 */
SVGPointList.prototype.getItem = function(index) {}
/**
 * @param {!DOMPoint} newItem
 * @return {!DOMPoint}
 */
SVGPointList.prototype.initialize = function(newItem) {}
/**
 * @param {!DOMPoint} newItem
 * @return {!DOMPoint}
 */
SVGPointList.prototype.appendItem = function(newItem) {}
/**
 * @constructor
 * @private
 * @extends {SVGElement}
 * @nosideeffects
 */
function SVGFEColorMatrixElement() {}
/** @const {!number} */ SVGFEColorMatrixElement.SVG_FECOLORMATRIX_TYPE_HUEROTATE;
/** @const {!number} */ SVGFEColorMatrixElement.prototype.SVG_FECOLORMATRIX_TYPE_HUEROTATE;
/** @const {!number} */ SVGFEColorMatrixElement.SVG_FECOLORMATRIX_TYPE_LUMINANCETOALPHA;
/** @const {!number} */ SVGFEColorMatrixElement.prototype.SVG_FECOLORMATRIX_TYPE_LUMINANCETOALPHA;
/** @const {!number} */ SVGFEColorMatrixElement.SVG_FECOLORMATRIX_TYPE_MATRIX;
/** @const {!number} */ SVGFEColorMatrixElement.prototype.SVG_FECOLORMATRIX_TYPE_MATRIX;
/** @const {!number} */ SVGFEColorMatrixElement.SVG_FECOLORMATRIX_TYPE_SATURATE;
/** @const {!number} */ SVGFEColorMatrixElement.prototype.SVG_FECOLORMATRIX_TYPE_SATURATE;
/** @const {!number} */ SVGFEColorMatrixElement.SVG_FECOLORMATRIX_TYPE_UNKNOWN;
/** @const {!number} */ SVGFEColorMatrixElement.prototype.SVG_FECOLORMATRIX_TYPE_UNKNOWN;
/** @type {!SVGAnimatedString} */ SVGFEColorMatrixElement.prototype.in1;
/** @type {!SVGAnimatedEnumeration} */ SVGFEColorMatrixElement.prototype.type;
/** @type {!SVGAnimatedNumberList} */ SVGFEColorMatrixElement.prototype.values;
/** @type {!SVGAnimatedLength} */ SVGFEColorMatrixElement.prototype.height;
/** @type {!SVGAnimatedString} */ SVGFEColorMatrixElement.prototype.result;
/** @type {!SVGAnimatedLength} */ SVGFEColorMatrixElement.prototype.width;
/** @type {!SVGAnimatedLength} */ SVGFEColorMatrixElement.prototype.x;
/** @type {!SVGAnimatedLength} */ SVGFEColorMatrixElement.prototype.y;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function HTMLCollection() {}
/** @type {!number} */ HTMLCollection.prototype.length;
/**
 * @param {!string} name
 * @return {?Element}
 * @nosideeffects
 */
HTMLCollection.prototype.namedItem = function(name) {}
/**
 * @param {!number} index
 * @return {?Element}
 * @nosideeffects
 */
HTMLCollection.prototype.item = function(index) {}
/**
 * @constructor
 * @private
 * @extends {HTMLElement}
 * @nosideeffects
 */
function HTMLSpanElement() {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function GamepadTouch() {}
/** @type {!Float32Array} */ GamepadTouch.prototype.position;
/** @type {?Uint32Array} */ GamepadTouch.prototype.surfaceDimensions;
/** @type {!number} */ GamepadTouch.prototype.surfaceId;
/** @type {!number} */ GamepadTouch.prototype.touchId;
/**
 * @constructor
 * @extends {Event}
 * @param {!string} type
 * @param {!XRSessionEventInit} eventInitDict
 */
function XRSessionEvent(type,eventInitDict) {}
/** @type {!XRSession} */ XRSessionEvent.prototype.session;
/**
 * @constructor
 * @private
 * @extends {PermissionStatus}
 * @nosideeffects
 */
function XRPermissionStatus() {}
/** @type {!Array<*>} */ XRPermissionStatus.prototype.granted;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function GPURenderPipeline() {}
/** @type {?string} */ GPURenderPipeline.prototype.label;
/**
 * @param {!number} index
 * @return {!GPUBindGroupLayout}
 */
GPURenderPipeline.prototype.getBindGroupLayout = function(index) {}
/**
 * @constructor
 * @extends {SpeechSynthesisEvent}
 * @param {!string} type
 * @param {!SpeechSynthesisErrorEventInit} eventInitDict
 */
function SpeechSynthesisErrorEvent(type,eventInitDict) {}
/** @type {!string} */ SpeechSynthesisErrorEvent.prototype.error;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function CanvasPattern() {}
/**
 * @param {!DOMMatrix2DInit=} transform
 * @return {undefined}
 */
CanvasPattern.prototype.setTransform = function(transform) {}
/**
 * @constructor
 * @private
 * @extends {HTMLElement}
 * @nosideeffects
 */
function HTMLDivElement() {}
/** @type {!string} */ HTMLDivElement.prototype.align;
/**
 * @constructor
 * @extends {Object}
 */
function DOMParser() {}
/**
 * @param {!string} string
 * @param {!string} type
 * @return {!Document}
 */
DOMParser.prototype.parseFromString = function(string,type) {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function WEBGL_compressed_texture_pvrtc() {}
/** @const {!GLenum} */ WEBGL_compressed_texture_pvrtc.prototype.COMPRESSED_RGBA_PVRTC_2BPPV1_IMG;
/** @const {!GLenum} */ WEBGL_compressed_texture_pvrtc.prototype.COMPRESSED_RGBA_PVRTC_4BPPV1_IMG;
/** @const {!GLenum} */ WEBGL_compressed_texture_pvrtc.prototype.COMPRESSED_RGB_PVRTC_2BPPV1_IMG;
/** @const {!GLenum} */ WEBGL_compressed_texture_pvrtc.prototype.COMPRESSED_RGB_PVRTC_4BPPV1_IMG;
/**
 * @constructor
 * @private
 * @extends {EventTarget}
 * @nosideeffects
 */
function SpeechRecognition() {}
/** @type {!boolean} */ SpeechRecognition.prototype.continuous;
/** @type {!SpeechGrammarList} */ SpeechRecognition.prototype.grammars;
/** @type {!boolean} */ SpeechRecognition.prototype.interimResults;
/** @type {!string} */ SpeechRecognition.prototype.lang;
/** @type {!number} */ SpeechRecognition.prototype.maxAlternatives;
/** @type {?EventHandler} */ SpeechRecognition.prototype.onaudioend;
/** @type {?EventHandler} */ SpeechRecognition.prototype.onaudiostart;
/** @type {?EventHandler} */ SpeechRecognition.prototype.onend;
/** @type {?SpeechRecognitionErrorEventHandler} */ SpeechRecognition.prototype.onerror;
/** @type {?SpeechRecognitionEventHandler} */ SpeechRecognition.prototype.onnomatch;
/** @type {?SpeechRecognitionEventHandler} */ SpeechRecognition.prototype.onresult;
/** @type {?EventHandler} */ SpeechRecognition.prototype.onsoundend;
/** @type {?EventHandler} */ SpeechRecognition.prototype.onsoundstart;
/** @type {?EventHandler} */ SpeechRecognition.prototype.onspeechend;
/** @type {?EventHandler} */ SpeechRecognition.prototype.onspeechstart;
/** @type {?EventHandler} */ SpeechRecognition.prototype.onstart;
/**
 * @return {undefined}
 */
SpeechRecognition.prototype.stop = function() {}
/**
 * @return {undefined}
 */
SpeechRecognition.prototype.abort = function() {}
/**
 * @return {undefined}
 */
SpeechRecognition.prototype.start = function() {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function GPUBufferUsage() {}
/** @const {!GPUFlagsConstant} */ GPUBufferUsage.COPY_DST;
/** @const {!GPUFlagsConstant} */ GPUBufferUsage.prototype.COPY_DST;
/** @const {!GPUFlagsConstant} */ GPUBufferUsage.COPY_SRC;
/** @const {!GPUFlagsConstant} */ GPUBufferUsage.prototype.COPY_SRC;
/** @const {!GPUFlagsConstant} */ GPUBufferUsage.INDEX;
/** @const {!GPUFlagsConstant} */ GPUBufferUsage.prototype.INDEX;
/** @const {!GPUFlagsConstant} */ GPUBufferUsage.INDIRECT;
/** @const {!GPUFlagsConstant} */ GPUBufferUsage.prototype.INDIRECT;
/** @const {!GPUFlagsConstant} */ GPUBufferUsage.MAP_READ;
/** @const {!GPUFlagsConstant} */ GPUBufferUsage.prototype.MAP_READ;
/** @const {!GPUFlagsConstant} */ GPUBufferUsage.MAP_WRITE;
/** @const {!GPUFlagsConstant} */ GPUBufferUsage.prototype.MAP_WRITE;
/** @const {!GPUFlagsConstant} */ GPUBufferUsage.QUERY_RESOLVE;
/** @const {!GPUFlagsConstant} */ GPUBufferUsage.prototype.QUERY_RESOLVE;
/** @const {!GPUFlagsConstant} */ GPUBufferUsage.STORAGE;
/** @const {!GPUFlagsConstant} */ GPUBufferUsage.prototype.STORAGE;
/** @const {!GPUFlagsConstant} */ GPUBufferUsage.UNIFORM;
/** @const {!GPUFlagsConstant} */ GPUBufferUsage.prototype.UNIFORM;
/** @const {!GPUFlagsConstant} */ GPUBufferUsage.VERTEX;
/** @const {!GPUFlagsConstant} */ GPUBufferUsage.prototype.VERTEX;
/**
 * @constructor
 * @private
 * @extends {HTMLElement}
 * @nosideeffects
 */
function HTMLTimeElement() {}
/** @type {!string} */ HTMLTimeElement.prototype.dateTime;
/**
 * @constructor
 * @private
 * @extends {CSSRule}
 * @nosideeffects
 */
function CSSNamespaceRule() {}
/** @type {!CSSOMString} */ CSSNamespaceRule.prototype.namespaceURI;
/** @type {!CSSOMString} */ CSSNamespaceRule.prototype.prefix;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function KHR_parallel_shader_compile() {}
/** @const {!GLenum} */ KHR_parallel_shader_compile.prototype.COMPLETION_STATUS_KHR;
/**
 * @constructor
 * @private
 * @extends {SVGElement}
 * @nosideeffects
 */
function SVGFEDistantLightElement() {}
/** @type {!SVGAnimatedNumber} */ SVGFEDistantLightElement.prototype.azimuth;
/** @type {!SVGAnimatedNumber} */ SVGFEDistantLightElement.prototype.elevation;
/**
 * @constructor
 * @extends {Event}
 * @param {!string} type
 * @param {!MediaKeyMessageEventInit} eventInitDict
 */
function MediaKeyMessageEvent(type,eventInitDict) {}
/** @type {!ArrayBuffer} */ MediaKeyMessageEvent.prototype.message;
/** @type {!string} */ MediaKeyMessageEvent.prototype.messageType;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function SVGAnimatedInteger() {}
/** @type {!number} */ SVGAnimatedInteger.prototype.animVal;
/** @type {!number} */ SVGAnimatedInteger.prototype.baseVal;
/**
 * @constructor
 * @private
 * @extends {MediaDeviceInfo}
 * @nosideeffects
 */
function InputDeviceInfo() {}
/**
 * @return {!MediaTrackCapabilities}
 */
InputDeviceInfo.prototype.getCapabilities = function() {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function Crypto() {}
/** @type {!SubtleCrypto} */ Crypto.prototype.subtle;
/**
 * @param {!ArrayBufferView} array
 * @return {!ArrayBufferView}
 */
Crypto.prototype.getRandomValues = function(array) {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function StyleSheet() {}
/** @type {?string} */ StyleSheet.prototype.href;
/** @type {!MediaList} */ StyleSheet.prototype.media;
/** @type {ElementOrProcessingInstructionUnion} */ StyleSheet.prototype.ownerNode;
/** @type {?CSSStyleSheet} */ StyleSheet.prototype.parentStyleSheet;
/** @type {?string} */ StyleSheet.prototype.title;
/** @type {!CSSOMString} */ StyleSheet.prototype.type;
/** @type {!boolean} */ StyleSheet.prototype.disabled;
/**
 * @constructor
 * @private
 * @extends {EventTarget}
 * @nosideeffects
 */
function IDBTransaction() {}
/** @type {!IDBDatabase} */ IDBTransaction.prototype.db;
/** @type {!string} */ IDBTransaction.prototype.durability;
/** @type {?DOMException} */ IDBTransaction.prototype.error;
/** @type {!string} */ IDBTransaction.prototype.mode;
/** @type {!DOMStringList} */ IDBTransaction.prototype.objectStoreNames;
/** @type {?EventHandler} */ IDBTransaction.prototype.onabort;
/** @type {?EventHandler} */ IDBTransaction.prototype.oncomplete;
/** @type {?EventHandler} */ IDBTransaction.prototype.onerror;
/**
 * @param {!string} name
 * @return {!IDBObjectStore}
 */
IDBTransaction.prototype.objectStore = function(name) {}
/**
 * @return {undefined}
 */
IDBTransaction.prototype.abort = function() {}
/**
 * @return {undefined}
 */
IDBTransaction.prototype.commit = function() {}
/**
 * @constructor
 * @private
 * @extends {HTMLElement}
 * @nosideeffects
 */
function HTMLFrameSetElement() {}
/** @type {!string} */ HTMLFrameSetElement.prototype.cols;
/** @type {!string} */ HTMLFrameSetElement.prototype.rows;
/** @type {!NullableEventHandler} */ HTMLFrameSetElement.prototype.onafterprint;
/** @type {!NullableEventHandler} */ HTMLFrameSetElement.prototype.onbeforeprint;
/** @type {!NullableOnBeforeUnloadEventHandler} */ HTMLFrameSetElement.prototype.onbeforeunload;
/** @type {!NullableEventHandler} */ HTMLFrameSetElement.prototype.onhashchange;
/** @type {!NullableEventHandler} */ HTMLFrameSetElement.prototype.onlanguagechange;
/** @type {!NullableEventHandler} */ HTMLFrameSetElement.prototype.onmessage;
/** @type {!NullableEventHandler} */ HTMLFrameSetElement.prototype.onmessageerror;
/** @type {!NullableEventHandler} */ HTMLFrameSetElement.prototype.onoffline;
/** @type {!NullableEventHandler} */ HTMLFrameSetElement.prototype.ononline;
/** @type {!NullableEventHandler} */ HTMLFrameSetElement.prototype.onpagehide;
/** @type {!NullableEventHandler} */ HTMLFrameSetElement.prototype.onpageshow;
/** @type {!NullableEventHandler} */ HTMLFrameSetElement.prototype.onpopstate;
/** @type {!NullableEventHandler} */ HTMLFrameSetElement.prototype.onrejectionhandled;
/** @type {!NullableEventHandler} */ HTMLFrameSetElement.prototype.onstorage;
/** @type {!NullableEventHandler} */ HTMLFrameSetElement.prototype.onunhandledrejection;
/** @type {!NullableEventHandler} */ HTMLFrameSetElement.prototype.onunload;
/** @type {!NullableEventHandler} */ HTMLFrameSetElement.prototype.ongamepadconnected;
/** @type {!NullableEventHandler} */ HTMLFrameSetElement.prototype.ongamepaddisconnected;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function GPUExternalTexture() {}
/** @type {?string} */ GPUExternalTexture.prototype.label;
/**
 * @constructor
 * @private
 * @extends {HTMLElement}
 * @nosideeffects
 */
function HTMLOptionElement() {}
/** @type {?HTMLFormElement} */ HTMLOptionElement.prototype.form;
/** @type {!number} */ HTMLOptionElement.prototype.index;
/** @type {!boolean} */ HTMLOptionElement.prototype.defaultSelected;
/** @type {!boolean} */ HTMLOptionElement.prototype.disabled;
/** @type {!string} */ HTMLOptionElement.prototype.label;
/** @type {!boolean} */ HTMLOptionElement.prototype.selected;
/** @type {!string} */ HTMLOptionElement.prototype.text;
/** @type {!string} */ HTMLOptionElement.prototype.value;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function SpeechGrammarList() {}
/** @type {!number} */ SpeechGrammarList.prototype.length;
/**
 * @param {!string} src
 * @param {!number=} weight
 * @return {undefined}
 */
SpeechGrammarList.prototype.addFromURI = function(src,weight) {}
/**
 * @param {!number} index
 * @return {!SpeechGrammar}
 */
SpeechGrammarList.prototype.item = function(index) {}
/**
 * @param {!string} string
 * @param {!number=} weight
 * @return {undefined}
 */
SpeechGrammarList.prototype.addFromString = function(string,weight) {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function AudioParam() {}
/** @type {!number} */ AudioParam.prototype.defaultValue;
/** @type {!number} */ AudioParam.prototype.maxValue;
/** @type {!number} */ AudioParam.prototype.minValue;
/** @type {!string} */ AudioParam.prototype.automationRate;
/** @type {!number} */ AudioParam.prototype.value;
/**
 * @param {!number} value
 * @param {!number} startTime
 * @return {!AudioParam}
 */
AudioParam.prototype.setValueAtTime = function(value,startTime) {}
/**
 * @param {!number} value
 * @param {!number} endTime
 * @return {!AudioParam}
 */
AudioParam.prototype.exponentialRampToValueAtTime = function(value,endTime) {}
/**
 * @param {!number} cancelTime
 * @return {!AudioParam}
 */
AudioParam.prototype.cancelScheduledValues = function(cancelTime) {}
/**
 * @param {!number} cancelTime
 * @return {!AudioParam}
 */
AudioParam.prototype.cancelAndHoldAtTime = function(cancelTime) {}
/**
 * @param {!Array<!number>} values
 * @param {!number} startTime
 * @param {!number} duration
 * @return {!AudioParam}
 */
AudioParam.prototype.setValueCurveAtTime = function(values,startTime,duration) {}
/**
 * @param {!number} target
 * @param {!number} startTime
 * @param {!number} timeConstant
 * @return {!AudioParam}
 */
AudioParam.prototype.setTargetAtTime = function(target,startTime,timeConstant) {}
/**
 * @param {!number} value
 * @param {!number} endTime
 * @return {!AudioParam}
 */
AudioParam.prototype.linearRampToValueAtTime = function(value,endTime) {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function GPUSampler() {}
/** @type {?string} */ GPUSampler.prototype.label;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function OES_vertex_array_object() {}
/** @const {!GLenum} */ OES_vertex_array_object.prototype.VERTEX_ARRAY_BINDING_OES;
/**
 * @param {?WebGLVertexArrayObjectOES} arrayObject
 * @return {undefined}
 */
OES_vertex_array_object.prototype.deleteVertexArrayOES = function(arrayObject) {}
/**
 * @return {?WebGLVertexArrayObjectOES}
 * @nosideeffects
 */
OES_vertex_array_object.prototype.createVertexArrayOES = function() {}
/**
 * @param {?WebGLVertexArrayObjectOES} arrayObject
 * @return {undefined}
 */
OES_vertex_array_object.prototype.bindVertexArrayOES = function(arrayObject) {}
/**
 * @param {?WebGLVertexArrayObjectOES} arrayObject
 * @return {!GLboolean}
 * @nosideeffects
 */
OES_vertex_array_object.prototype.isVertexArrayOES = function(arrayObject) {}
/**
 * @constructor
 * @extends {AbstractRange}
 * @param {!StaticRangeInit} init
 */
function StaticRange(init) {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function RTCRtpSender() {}
/** @type {?MediaStreamTrack} */ RTCRtpSender.prototype.track;
/** @type {?RTCDtlsTransport} */ RTCRtpSender.prototype.transport;
/** @type {?RTCDTMFSender} */ RTCRtpSender.prototype.dtmf;
/**
 * @param {!RTCRtpSendParameters} parameters
 * @return {!Promise<undefined>}
 */
RTCRtpSender.prototype.setParameters = function(parameters) {}
/**
 * @return {!Promise<!RTCStatsReport>}
 */
RTCRtpSender.prototype.getStats = function() {}
/**
 * @param {...!MediaStream} streams
 * @return {undefined}
 */
RTCRtpSender.prototype.setStreams = function(streams) {}
/**
 * @param {?MediaStreamTrack} withTrack
 * @return {!Promise<undefined>}
 */
RTCRtpSender.prototype.replaceTrack = function(withTrack) {}
/**
 * @return {!RTCRtpSendParameters}
 */
RTCRtpSender.prototype.getParameters = function() {}
/**
 * @param {!string} kind
 * @return {?RTCRtpCapabilities}
 */
RTCRtpSender.getCapabilities = function(kind) {}
/**
 * @constructor
 * @extends {Event}
 * @param {!string} type
 * @param {!GamepadEventInit} eventInitDict
 */
function GamepadEvent(type,eventInitDict) {}
/** @type {!Gamepad} */ GamepadEvent.prototype.gamepad;
/**
 * @constructor
 * @extends {Object}
 * @param {!WebAssembly.Module} module
 * @param {!Object=} importObject
 */
WebAssembly.Instance = function(module,importObject) {}
/** @type {!Object} */ WebAssembly.Instance.prototype.exports;
/**
 * @constructor
 * @extends {DOMException}
 * @param {!RTCErrorInit} init
 * @param {!string=} message
 */
function RTCError(init,message) {}
/** @type {!string} */ RTCError.prototype.errorDetail;
/** @type {?number} */ RTCError.prototype.receivedAlert;
/** @type {?number} */ RTCError.prototype.sctpCauseCode;
/** @type {?number} */ RTCError.prototype.sdpLineNumber;
/** @type {?number} */ RTCError.prototype.sentAlert;
/** @type {?number} */ RTCError.prototype.httpRequestStatusCode;
/**
 * @constructor
 * @private
 * @extends {SVGElement}
 * @nosideeffects
 */
function SVGFEFloodElement() {}
/** @type {!SVGAnimatedLength} */ SVGFEFloodElement.prototype.height;
/** @type {!SVGAnimatedString} */ SVGFEFloodElement.prototype.result;
/** @type {!SVGAnimatedLength} */ SVGFEFloodElement.prototype.width;
/** @type {!SVGAnimatedLength} */ SVGFEFloodElement.prototype.x;
/** @type {!SVGAnimatedLength} */ SVGFEFloodElement.prototype.y;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function Selection() {}
/** @type {?Node} */ Selection.prototype.anchorNode;
/** @type {!number} */ Selection.prototype.anchorOffset;
/** @type {?Node} */ Selection.prototype.focusNode;
/** @type {!number} */ Selection.prototype.focusOffset;
/** @type {!boolean} */ Selection.prototype.isCollapsed;
/** @type {!number} */ Selection.prototype.rangeCount;
/** @type {!string} */ Selection.prototype.type;
/**
 * @param {!number} index
 * @return {!Range}
 * @nosideeffects
 */
Selection.prototype.getRangeAt = function(index) {}
/**
 * @return {undefined}
 */
Selection.prototype.collapseToStart = function() {}
/**
 * @param {!Node} node
 * @return {undefined}
 */
Selection.prototype.selectAllChildren = function(node) {}
/**
 * @return {undefined}
 */
Selection.prototype.collapseToEnd = function() {}
/**
 * @param {!Node} anchorNode
 * @param {!number} anchorOffset
 * @param {!Node} focusNode
 * @param {!number} focusOffset
 * @return {undefined}
 */
Selection.prototype.setBaseAndExtent = function(anchorNode,anchorOffset,focusNode,focusOffset) {}
/**
 * @param {!Range} range
 * @return {undefined}
 */
Selection.prototype.addRange = function(range) {}
/**
 * @param {?Node} node
 * @param {!number=} offset
 * @return {undefined}
 */
Selection.prototype.setPosition = function(node,offset) {}
/**
 * @return {undefined}
 */
Selection.prototype.empty = function() {}
/**
 * @param {!Node} node
 * @param {!number=} offset
 * @return {undefined}
 */
Selection.prototype.extend = function(node,offset) {}
/**
 * @return {undefined}
 */
Selection.prototype.removeAllRanges = function() {}
/**
 * @param {!Range} range
 * @return {undefined}
 */
Selection.prototype.removeRange = function(range) {}
/**
 * @return {undefined}
 */
Selection.prototype.deleteFromDocument = function() {}
/**
 * @param {!Node} node
 * @param {!boolean=} allowPartialContainment
 * @return {!boolean}
 * @nosideeffects
 */
Selection.prototype.containsNode = function(node,allowPartialContainment) {}
/**
 * @param {?Node} node
 * @param {!number=} offset
 * @return {undefined}
 */
Selection.prototype.collapse = function(node,offset) {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function GPUQuerySet() {}
/** @type {?string} */ GPUQuerySet.prototype.label;
/**
 * @return {undefined}
 */
GPUQuerySet.prototype.destroy = function() {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function CanvasRenderingContext2D() {}
/** @type {!HTMLCanvasElement} */ CanvasRenderingContext2D.prototype.canvas;
/** @type {!boolean} */ CanvasRenderingContext2D.prototype.imageSmoothingEnabled;
/** @type {!string} */ CanvasRenderingContext2D.prototype.imageSmoothingQuality;
/** @type {!string} */ CanvasRenderingContext2D.prototype.filter;
/** @type {!number} */ CanvasRenderingContext2D.prototype.shadowBlur;
/** @type {!string} */ CanvasRenderingContext2D.prototype.shadowColor;
/** @type {!number} */ CanvasRenderingContext2D.prototype.shadowOffsetX;
/** @type {!number} */ CanvasRenderingContext2D.prototype.shadowOffsetY;
/** @type {StringOrCanvasGradientOrCanvasPatternUnion} */ CanvasRenderingContext2D.prototype.fillStyle;
/** @type {StringOrCanvasGradientOrCanvasPatternUnion} */ CanvasRenderingContext2D.prototype.strokeStyle;
/** @type {!number} */ CanvasRenderingContext2D.prototype.globalAlpha;
/** @type {!string} */ CanvasRenderingContext2D.prototype.globalCompositeOperation;
/** @type {!string} */ CanvasRenderingContext2D.prototype.lineCap;
/** @type {!number} */ CanvasRenderingContext2D.prototype.lineDashOffset;
/** @type {!string} */ CanvasRenderingContext2D.prototype.lineJoin;
/** @type {!number} */ CanvasRenderingContext2D.prototype.lineWidth;
/** @type {!number} */ CanvasRenderingContext2D.prototype.miterLimit;
/** @type {!string} */ CanvasRenderingContext2D.prototype.direction;
/** @type {!string} */ CanvasRenderingContext2D.prototype.font;
/** @type {!string} */ CanvasRenderingContext2D.prototype.fontKerning;
/** @type {!string} */ CanvasRenderingContext2D.prototype.fontStretch;
/** @type {!string} */ CanvasRenderingContext2D.prototype.fontVariantCaps;
/** @type {!string} */ CanvasRenderingContext2D.prototype.textAlign;
/** @type {!string} */ CanvasRenderingContext2D.prototype.textBaseline;
/** @type {!number} */ CanvasRenderingContext2D.prototype.textLetterSpacing;
/** @type {!string} */ CanvasRenderingContext2D.prototype.textRendering;
/** @type {!number} */ CanvasRenderingContext2D.prototype.textWordSpacing;
/**
 * @param {!number} angle
 * @return {undefined}
 */
CanvasRenderingContext2D.prototype.rotate = function(angle) {}
/**
 * @param {(!number|!ImageData)} arg0
 * @param {!number=} arg1
 * @param {!ImageDataSettings=} arg2
 * @return {!ImageData}
 * @nosideeffects
 */
CanvasRenderingContext2D.prototype.createImageData = function(arg0,arg1,arg2) {}
/**
 * @return {undefined}
 */
CanvasRenderingContext2D.prototype.closePath = function() {}
/**
 * @return {undefined}
 */
CanvasRenderingContext2D.prototype.save = function() {}
/**
 * @param {!number} x
 * @param {!number} y
 * @return {undefined}
 */
CanvasRenderingContext2D.prototype.scale = function(x,y) {}
/**
 * @param {!number} x
 * @param {!number} y
 * @return {undefined}
 */
CanvasRenderingContext2D.prototype.lineTo = function(x,y) {}
/**
 * @param {!Array<!number>} segments
 * @return {undefined}
 */
CanvasRenderingContext2D.prototype.setLineDash = function(segments) {}
/**
 * @param {!string} text
 * @return {!TextMetrics}
 * @nosideeffects
 */
CanvasRenderingContext2D.prototype.measureText = function(text) {}
/**
 * @param {!number} x
 * @param {!number} y
 * @param {!number} w
 * @param {!number} h
 * @return {undefined}
 */
CanvasRenderingContext2D.prototype.fillRect = function(x,y,w,h) {}
/**
 * @param {!number} x
 * @param {!number} y
 * @return {undefined}
 */
CanvasRenderingContext2D.prototype.translate = function(x,y) {}
/**
 * @param {!ImageData} arg0
 * @param {!number} arg1
 * @param {!number} arg2
 * @param {!number=} arg3
 * @param {!number=} arg4
 * @param {!number=} arg5
 * @param {!number=} arg6
 * @return {undefined}
 */
CanvasRenderingContext2D.prototype.putImageData = function(arg0,arg1,arg2,arg3,arg4,arg5,arg6) {}
/**
 * @param {!number} x
 * @param {!number} y
 * @param {!number} w
 * @param {!number} h
 * @return {undefined}
 */
CanvasRenderingContext2D.prototype.rect = function(x,y,w,h) {}
/**
 * @param {!number} a
 * @param {!number} b
 * @param {!number} c
 * @param {!number} d
 * @param {!number} e
 * @param {!number} f
 * @return {undefined}
 */
CanvasRenderingContext2D.prototype.transform = function(a,b,c,d,e,f) {}
/**
 * @param {!number} x
 * @param {!number} y
 * @param {!number} radius
 * @param {!number} startAngle
 * @param {!number} endAngle
 * @param {!boolean=} counterclockwise
 * @return {undefined}
 */
CanvasRenderingContext2D.prototype.arc = function(x,y,radius,startAngle,endAngle,counterclockwise) {}
/**
 * @param {!Path2D=} arg0
 * @return {undefined}
 */
CanvasRenderingContext2D.prototype.scrollPathIntoView = function(arg0) {}
/**
 * @param {(!number|!DOMMatrix2DInit)=} arg0
 * @param {!number=} arg1
 * @param {!number=} arg2
 * @param {!number=} arg3
 * @param {!number=} arg4
 * @param {!number=} arg5
 * @return {undefined}
 */
CanvasRenderingContext2D.prototype.setTransform = function(arg0,arg1,arg2,arg3,arg4,arg5) {}
/**
 * @param {(!number|!Path2D)} arg0
 * @param {!number} arg1
 * @param {(!string|!number)=} arg2
 * @param {!string=} arg3
 * @return {!boolean}
 * @nosideeffects
 */
CanvasRenderingContext2D.prototype.isPointInPath = function(arg0,arg1,arg2,arg3) {}
/**
 * @param {!number} x
 * @param {!number} y
 * @param {!number} w
 * @param {!number} h
 * @return {undefined}
 */
CanvasRenderingContext2D.prototype.strokeRect = function(x,y,w,h) {}
/**
 * @param {!number} x
 * @param {!number} y
 * @param {!number} radiusX
 * @param {!number} radiusY
 * @param {!number} rotation
 * @param {!number} startAngle
 * @param {!number} endAngle
 * @param {!boolean=} counterclockwise
 * @return {undefined}
 */
CanvasRenderingContext2D.prototype.ellipse = function(x,y,radiusX,radiusY,rotation,startAngle,endAngle,counterclockwise) {}
/**
 * @param {!number} x0
 * @param {!number} y0
 * @param {!number} r0
 * @param {!number} x1
 * @param {!number} y1
 * @param {!number} r1
 * @return {!CanvasGradient}
 */
CanvasRenderingContext2D.prototype.createRadialGradient = function(x0,y0,r0,x1,y1,r1) {}
/**
 * @param {!string} text
 * @param {!number} x
 * @param {!number} y
 * @param {!number=} maxWidth
 * @return {undefined}
 */
CanvasRenderingContext2D.prototype.fillText = function(text,x,y,maxWidth) {}
/**
 * @return {!DOMMatrix}
 */
CanvasRenderingContext2D.prototype.getTransform = function() {}
/**
 * @param {!number} x
 * @param {!number} y
 * @param {!number} w
 * @param {!number} h
 * @param {!Array<UnrestrictedDoubleOrDOMPointInitUnion>} radii
 * @return {undefined}
 */
CanvasRenderingContext2D.prototype.roundRect = function(x,y,w,h,radii) {}
/**
 * @param {!number} x1
 * @param {!number} y1
 * @param {!number} x2
 * @param {!number} y2
 * @param {!number} radius
 * @return {undefined}
 */
CanvasRenderingContext2D.prototype.arcTo = function(x1,y1,x2,y2,radius) {}
/**
 * @param {!number} sx
 * @param {!number} sy
 * @param {!number} sw
 * @param {!number} sh
 * @param {!ImageDataSettings=} settings
 * @return {!ImageData}
 */
CanvasRenderingContext2D.prototype.getImageData = function(sx,sy,sw,sh,settings) {}
/**
 * @param {!string} text
 * @param {!number} x
 * @param {!number} y
 * @param {!number=} maxWidth
 * @return {undefined}
 */
CanvasRenderingContext2D.prototype.strokeText = function(text,x,y,maxWidth) {}
/**
 * @return {undefined}
 */
CanvasRenderingContext2D.prototype.restore = function() {}
/**
 * @return {undefined}
 */
CanvasRenderingContext2D.prototype.beginPath = function() {}
/**
 * @return {undefined}
 */
CanvasRenderingContext2D.prototype.resetTransform = function() {}
/**
 * @param {(!Element|!Path2D)} arg0
 * @param {!Element=} arg1
 * @return {undefined}
 */
CanvasRenderingContext2D.prototype.drawFocusIfNeeded = function(arg0,arg1) {}
/**
 * @param {!number} cpx
 * @param {!number} cpy
 * @param {!number} x
 * @param {!number} y
 * @return {undefined}
 */
CanvasRenderingContext2D.prototype.quadraticCurveTo = function(cpx,cpy,x,y) {}
/**
 * @param {!number} cp1x
 * @param {!number} cp1y
 * @param {!number} cp2x
 * @param {!number} cp2y
 * @param {!number} x
 * @param {!number} y
 * @return {undefined}
 */
CanvasRenderingContext2D.prototype.bezierCurveTo = function(cp1x,cp1y,cp2x,cp2y,x,y) {}
/**
 * @param {(!string|!Path2D)=} arg0
 * @param {!string=} arg1
 * @return {undefined}
 */
CanvasRenderingContext2D.prototype.fill = function(arg0,arg1) {}
/**
 * @param {!Path2D=} arg0
 * @return {undefined}
 */
CanvasRenderingContext2D.prototype.stroke = function(arg0) {}
/**
 * @param {!number} x
 * @param {!number} y
 * @param {!number} w
 * @param {!number} h
 * @return {undefined}
 */
CanvasRenderingContext2D.prototype.clearRect = function(x,y,w,h) {}
/**
 * @return {!Array<!number>}
 */
CanvasRenderingContext2D.prototype.getLineDash = function() {}
/**
 * @param {!CanvasImageSource} arg0
 * @param {!number} arg1
 * @param {!number} arg2
 * @param {!number=} arg3
 * @param {!number=} arg4
 * @param {!number=} arg5
 * @param {!number=} arg6
 * @param {!number=} arg7
 * @param {!number=} arg8
 * @return {undefined}
 */
CanvasRenderingContext2D.prototype.drawImage = function(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8) {}
/**
 * @return {!CanvasRenderingContext2DSettings}
 */
CanvasRenderingContext2D.prototype.getContextAttributes = function() {}
/**
 * @param {!CanvasImageSource} image
 * @param {!string} repetition
 * @return {?CanvasPattern}
 */
CanvasRenderingContext2D.prototype.createPattern = function(image,repetition) {}
/**
 * @param {(!number|!Path2D)} arg0
 * @param {!number} arg1
 * @param {!number=} arg2
 * @return {!boolean}
 * @nosideeffects
 */
CanvasRenderingContext2D.prototype.isPointInStroke = function(arg0,arg1,arg2) {}
/**
 * @return {undefined}
 */
CanvasRenderingContext2D.prototype.reset = function() {}
/**
 * @param {(!string|!Path2D)=} arg0
 * @param {!string=} arg1
 * @return {undefined}
 */
CanvasRenderingContext2D.prototype.clip = function(arg0,arg1) {}
/**
 * @param {!number} x
 * @param {!number} y
 * @return {undefined}
 */
CanvasRenderingContext2D.prototype.moveTo = function(x,y) {}
/**
 * @param {!number} x0
 * @param {!number} y0
 * @param {!number} x1
 * @param {!number} y1
 * @return {!CanvasGradient}
 */
CanvasRenderingContext2D.prototype.createLinearGradient = function(x0,y0,x1,y1) {}
/**
 * @param {!number} startAngle
 * @param {!number} x
 * @param {!number} y
 * @return {!CanvasGradient}
 */
CanvasRenderingContext2D.prototype.createConicGradient = function(startAngle,x,y) {}
/**
 * @constructor
 * @extends {EventTarget}
 * @param {!string} title
 * @param {!NotificationOptions=} options
 */
function Notification(title,options) {}
/** @type {!number} */ Notification.maxActions;
/** @type {!string} */ Notification.permission;
/** @type {!Array<!NotificationAction>} */ Notification.prototype.actions;
/** @type {!string} */ Notification.prototype.badge;
/** @type {!string} */ Notification.prototype.body;
/** @type {*} */ Notification.prototype.data;
/** @type {!string} */ Notification.prototype.dir;
/** @type {!string} */ Notification.prototype.icon;
/** @type {!string} */ Notification.prototype.image;
/** @type {!string} */ Notification.prototype.lang;
/** @type {!boolean} */ Notification.prototype.renotify;
/** @type {!boolean} */ Notification.prototype.requireInteraction;
/** @type {!boolean} */ Notification.prototype.silent;
/** @type {!string} */ Notification.prototype.tag;
/** @type {!DOMTimeStamp} */ Notification.prototype.timestamp;
/** @type {!string} */ Notification.prototype.title;
/** @type {!Array<!number>} */ Notification.prototype.vibrate;
/** @type {!NullableEventHandler} */ Notification.prototype.onclick;
/** @type {!NullableEventHandler} */ Notification.prototype.onclose;
/** @type {!NullableEventHandler} */ Notification.prototype.onerror;
/** @type {!NullableEventHandler} */ Notification.prototype.onshow;
/**
 * @param {!NotificationPermissionCallback=} deprecatedCallback
 * @return {!Promise<!string>}
 */
Notification.requestPermission = function(deprecatedCallback) {}
/**
 * @return {undefined}
 */
Notification.prototype.close = function() {}
/**
 * @constructor
 * @extends {XRLayer}
 * @param {!XRSession} session
 * @param {!XRWebGLRenderingContext} context
 * @param {!XRWebGLLayerInit=} layerInit
 */
function XRWebGLLayer(session,context,layerInit) {}
/** @type {!boolean} */ XRWebGLLayer.prototype.antialias;
/** @type {?WebGLFramebuffer} */ XRWebGLLayer.prototype.framebuffer;
/** @type {!number} */ XRWebGLLayer.prototype.framebufferHeight;
/** @type {!number} */ XRWebGLLayer.prototype.framebufferWidth;
/** @type {!boolean} */ XRWebGLLayer.prototype.ignoreDepthValues;
/**
 * @param {!XRView} view
 * @return {?XRViewport}
 */
XRWebGLLayer.prototype.getViewport = function(view) {}
/**
 * @param {!XRSession} session
 * @return {!number}
 */
XRWebGLLayer.getNativeFramebufferScaleFactor = function(session) {}
/**
 * @constructor
 * @extends {AudioNode}
 * @param {!BaseAudioContext} context
 * @param {!ChannelMergerOptions=} options
 */
function ChannelMergerNode(context,options) {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function SVGAnimatedLengthList() {}
/** @type {!SVGLengthList} */ SVGAnimatedLengthList.prototype.animVal;
/** @type {!SVGLengthList} */ SVGAnimatedLengthList.prototype.baseVal;
/**
 * @constructor
 * @private
 * @extends {EventTarget}
 * @nosideeffects
 */
function AudioTrackList() {}
/** @type {!number} */ AudioTrackList.prototype.length;
/** @type {?TrackEventHandler} */ AudioTrackList.prototype.onaddtrack;
/** @type {?EventHandler} */ AudioTrackList.prototype.onchange;
/** @type {?TrackEventHandler} */ AudioTrackList.prototype.onremovetrack;
/**
 * @param {!string} id
 * @return {?AudioTrack}
 */
AudioTrackList.prototype.getTrackById = function(id) {}
/**
 * @constructor
 * @private
 * @extends {HTMLElement}
 * @nosideeffects
 */
function HTMLBaseElement() {}
/** @type {!string} */ HTMLBaseElement.prototype.href;
/** @type {!string} */ HTMLBaseElement.prototype.target;
/**
 * @constructor
 * @private
 * @extends {HTMLElement}
 * @nosideeffects
 */
function HTMLMapElement() {}
/** @type {!HTMLCollection} */ HTMLMapElement.prototype.areas;
/** @type {!string} */ HTMLMapElement.prototype.name;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @implements {Iterable<!Array<!number|!XRInputSource>>}
 * @nosideeffects
 */
function XRInputSourceArray() {}
/** @type {!number} */ XRInputSourceArray.prototype.length;
/**
 * @return {!Iterator<!number>}
 * @nosideeffects
 */
XRInputSourceArray.prototype.keys = function() {}
/**
 * @return {!Iterator<!XRInputSource>}
 * @nosideeffects
 */
XRInputSourceArray.prototype.values = function() {}
/**
 * @return {!Iterator<!Array<!number|!XRInputSource>>}
 * @nosideeffects
 */
XRInputSourceArray.prototype.entries = function() {};
/**
 * @return {!Iterator<!Array<!number|!XRInputSource>>}
 * @nosideeffects
 */
XRInputSourceArray.prototype[Symbol.iterator] = function() {};
/**
 * @param {function(!XRInputSource, !number, MAP)} callback
 * @this {MAP}
 * @template MAP
 */
XRInputSourceArray.prototype.forEach = function(callback) {};
/**
 * @constructor
 * @extends {Object}
 */
function XMLSerializer() {}
/**
 * @param {!Node} root
 * @return {!string}
 */
XMLSerializer.prototype.serializeToString = function(root) {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function SVGAnimatedPreserveAspectRatio() {}
/** @type {!SVGPreserveAspectRatio} */ SVGAnimatedPreserveAspectRatio.prototype.animVal;
/** @type {!SVGPreserveAspectRatio} */ SVGAnimatedPreserveAspectRatio.prototype.baseVal;
/**
 * @constructor
 * @extends {UIEvent}
 * @param {!string} type
 * @param {!MouseEventInit=} eventInitDict
 */
function MouseEvent(type,eventInitDict) {}
/** @type {!boolean} */ MouseEvent.prototype.altKey;
/** @type {!number} */ MouseEvent.prototype.button;
/** @type {!number} */ MouseEvent.prototype.buttons;
/** @type {!boolean} */ MouseEvent.prototype.ctrlKey;
/** @type {!boolean} */ MouseEvent.prototype.metaKey;
/** @type {?EventTarget} */ MouseEvent.prototype.relatedTarget;
/** @type {!boolean} */ MouseEvent.prototype.shiftKey;
/** @type {!number} */ MouseEvent.prototype.clientX;
/** @type {!number} */ MouseEvent.prototype.clientY;
/** @type {!number} */ MouseEvent.prototype.offsetX;
/** @type {!number} */ MouseEvent.prototype.offsetY;
/** @type {!number} */ MouseEvent.prototype.pageX;
/** @type {!number} */ MouseEvent.prototype.pageY;
/** @type {!number} */ MouseEvent.prototype.screenX;
/** @type {!number} */ MouseEvent.prototype.screenY;
/** @type {!number} */ MouseEvent.prototype.x;
/** @type {!number} */ MouseEvent.prototype.y;
/** @type {!number} */ MouseEvent.prototype.movementX;
/** @type {!number} */ MouseEvent.prototype.movementY;
/**
 * @param {!string} keyArg
 * @return {!boolean}
 */
MouseEvent.prototype.getModifierState = function(keyArg) {}
/**
 * @constructor
 * @private
 * @extends {WebGLObject}
 * @nosideeffects
 */
function WebGLShader() {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function ObjectPropertyEntry() {}
/**
 * @constructor
 * @private
 * @extends {HTMLElement}
 * @nosideeffects
 */
function HTMLSelectElement() {}
/** @type {?HTMLFormElement} */ HTMLSelectElement.prototype.form;
/** @type {!NodeList} */ HTMLSelectElement.prototype.labels;
/** @type {!HTMLOptionsCollection} */ HTMLSelectElement.prototype.options;
/** @type {!HTMLCollection} */ HTMLSelectElement.prototype.selectedOptions;
/** @type {!string} */ HTMLSelectElement.prototype.type;
/** @type {!string} */ HTMLSelectElement.prototype.validationMessage;
/** @type {!ValidityState} */ HTMLSelectElement.prototype.validity;
/** @type {!boolean} */ HTMLSelectElement.prototype.willValidate;
/** @type {!string} */ HTMLSelectElement.prototype.autocomplete;
/** @type {!boolean} */ HTMLSelectElement.prototype.disabled;
/** @type {!number} */ HTMLSelectElement.prototype.length;
/** @type {!boolean} */ HTMLSelectElement.prototype.multiple;
/** @type {!string} */ HTMLSelectElement.prototype.name;
/** @type {!boolean} */ HTMLSelectElement.prototype.required;
/** @type {!number} */ HTMLSelectElement.prototype.selectedIndex;
/** @type {!number} */ HTMLSelectElement.prototype.size;
/** @type {!string} */ HTMLSelectElement.prototype.value;
/**
 * @param {(!HTMLOptionElement|!HTMLOptGroupElement)} element
 * @param {(!HTMLElement|!number)=} before
 * @return {undefined}
 */
HTMLSelectElement.prototype.add = function(element,before) {}
/**
 * @param {!number} index
 * @return {?HTMLOptionElement}
 */
HTMLSelectElement.prototype.item = function(index) {}
/**
 * @param {!string} name
 * @return {?HTMLOptionElement}
 */
HTMLSelectElement.prototype.namedItem = function(name) {}
/**
 * @param {!string} error
 * @return {undefined}
 */
HTMLSelectElement.prototype.setCustomValidity = function(error) {}
/**
 * @return {!boolean}
 */
HTMLSelectElement.prototype.reportValidity = function() {}
/**
 * @param {!number=} arg0
 * @return {undefined}
 * @override
 */
HTMLSelectElement.prototype.remove = function(arg0) {}
/**
 * @return {!boolean}
 */
HTMLSelectElement.prototype.checkValidity = function() {}
/**
 * @constructor
 * @extends {Event}
 * @param {!string} type
 * @param {!SubmitEventInit=} eventInitDict
 */
function SubmitEvent(type,eventInitDict) {}
/** @type {?HTMLElement} */ SubmitEvent.prototype.submitter;
/**
 * @constructor
 * @private
 * @extends {SVGElement}
 * @nosideeffects
 */
function SVGMetadataElement() {}
/**
 * @constructor
 * @private
 * @extends {SVGGraphicsElement}
 * @nosideeffects
 */
function SVGUseElement() {}
/** @type {?SVGElement} */ SVGUseElement.prototype.animatedInstanceRoot;
/** @type {!SVGAnimatedLength} */ SVGUseElement.prototype.height;
/** @type {?SVGElement} */ SVGUseElement.prototype.instanceRoot;
/** @type {!SVGAnimatedLength} */ SVGUseElement.prototype.width;
/** @type {!SVGAnimatedLength} */ SVGUseElement.prototype.x;
/** @type {!SVGAnimatedLength} */ SVGUseElement.prototype.y;
/** @type {!SVGAnimatedString} */ SVGUseElement.prototype.href;
/**
 * @constructor
 * @private
 * @extends {EventTarget}
 * @nosideeffects
 */
function WakeLockSentinel() {}
/** @type {!boolean} */ WakeLockSentinel.prototype.released;
/** @type {!string} */ WakeLockSentinel.prototype.type;
/** @type {!NullableEventHandler} */ WakeLockSentinel.prototype.onrelease;
/**
 * @return {!Promise<undefined>}
 */
WakeLockSentinel.prototype.release = function() {}
/**
 * @constructor
 * @private
 * @extends {SVGGradientElement}
 * @nosideeffects
 */
function SVGRadialGradientElement() {}
/** @type {!SVGAnimatedLength} */ SVGRadialGradientElement.prototype.cx;
/** @type {!SVGAnimatedLength} */ SVGRadialGradientElement.prototype.cy;
/** @type {!SVGAnimatedLength} */ SVGRadialGradientElement.prototype.fr;
/** @type {!SVGAnimatedLength} */ SVGRadialGradientElement.prototype.fx;
/** @type {!SVGAnimatedLength} */ SVGRadialGradientElement.prototype.fy;
/** @type {!SVGAnimatedLength} */ SVGRadialGradientElement.prototype.r;
/**
 * @constructor
 * @private
 * @extends {HTMLElement}
 * @nosideeffects
 */
function HTMLHRElement() {}
/** @type {!string} */ HTMLHRElement.prototype.align;
/** @type {!string} */ HTMLHRElement.prototype.color;
/** @type {!boolean} */ HTMLHRElement.prototype.noShade;
/** @type {!string} */ HTMLHRElement.prototype.size;
/** @type {!string} */ HTMLHRElement.prototype.width;
/**
 * @constructor
 * @extends {Error}
 * @param {!Iterable<*>} errors
 * @param {!string=} message
 */
function AggregateError(errors,message) {}
/** @type {!Iterable<*>} */ AggregateError.prototype.errors;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function OES_standard_derivatives() {}
/** @const {!GLenum} */ OES_standard_derivatives.prototype.FRAGMENT_SHADER_DERIVATIVE_HINT_OES;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function SVGTransform() {}
/** @const {!number} */ SVGTransform.SVG_TRANSFORM_MATRIX;
/** @const {!number} */ SVGTransform.prototype.SVG_TRANSFORM_MATRIX;
/** @const {!number} */ SVGTransform.SVG_TRANSFORM_ROTATE;
/** @const {!number} */ SVGTransform.prototype.SVG_TRANSFORM_ROTATE;
/** @const {!number} */ SVGTransform.SVG_TRANSFORM_SCALE;
/** @const {!number} */ SVGTransform.prototype.SVG_TRANSFORM_SCALE;
/** @const {!number} */ SVGTransform.SVG_TRANSFORM_SKEWX;
/** @const {!number} */ SVGTransform.prototype.SVG_TRANSFORM_SKEWX;
/** @const {!number} */ SVGTransform.SVG_TRANSFORM_SKEWY;
/** @const {!number} */ SVGTransform.prototype.SVG_TRANSFORM_SKEWY;
/** @const {!number} */ SVGTransform.SVG_TRANSFORM_TRANSLATE;
/** @const {!number} */ SVGTransform.prototype.SVG_TRANSFORM_TRANSLATE;
/** @const {!number} */ SVGTransform.SVG_TRANSFORM_UNKNOWN;
/** @const {!number} */ SVGTransform.prototype.SVG_TRANSFORM_UNKNOWN;
/** @type {!number} */ SVGTransform.prototype.angle;
/** @type {!DOMMatrix} */ SVGTransform.prototype.matrix;
/** @type {!number} */ SVGTransform.prototype.type;
/**
 * @param {!number} sx
 * @param {!number} sy
 * @return {undefined}
 */
SVGTransform.prototype.setScale = function(sx,sy) {}
/**
 * @param {!number} angle
 * @param {!number} cx
 * @param {!number} cy
 * @return {undefined}
 */
SVGTransform.prototype.setRotate = function(angle,cx,cy) {}
/**
 * @param {!DOMMatrixReadOnly} matrix
 * @return {undefined}
 */
SVGTransform.prototype.setMatrix = function(matrix) {}
/**
 * @param {!number} tx
 * @param {!number} ty
 * @return {undefined}
 */
SVGTransform.prototype.setTranslate = function(tx,ty) {}
/**
 * @param {!number} angle
 * @return {undefined}
 */
SVGTransform.prototype.setSkewX = function(angle) {}
/**
 * @param {!number} angle
 * @return {undefined}
 */
SVGTransform.prototype.setSkewY = function(angle) {}
/**
 * @constructor
 * @extends {Object}
 * @param {!RTCSessionDescriptionInit} descriptionInitDict
 */
function RTCSessionDescription(descriptionInitDict) {}
/** @type {!string} */ RTCSessionDescription.prototype.sdp;
/** @type {!string} */ RTCSessionDescription.prototype.type;
/**
 * @return {!Object}
 * @override
 */
RTCSessionDescription.prototype.toJSON = function() {}
/**
 * @constructor
 * @extends {Object}
 */
function MessageChannel() {}
/** @type {!MessagePort} */ MessageChannel.prototype.port1;
/** @type {!MessagePort} */ MessageChannel.prototype.port2;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function VideoTrack() {}
/** @type {!string} */ VideoTrack.prototype.id;
/** @type {!string} */ VideoTrack.prototype.kind;
/** @type {!string} */ VideoTrack.prototype.label;
/** @type {!string} */ VideoTrack.prototype.language;
/** @type {!boolean} */ VideoTrack.prototype.selected;
/** @type {?SourceBuffer} */ VideoTrack.prototype.sourceBuffer;
/**
 * @constructor
 * @private
 * @extends {CSSRule}
 * @nosideeffects
 */
function CSSFontFaceRule() {}
/** @type {!CSSStyleDeclaration} */ CSSFontFaceRule.prototype.style;
/**
 * @constructor
 * @private
 * @extends {WebGLObject}
 * @nosideeffects
 */
function WebGLVertexArrayObject() {}
/**
 * @constructor
 * @private
 * @extends {SVGElement}
 * @nosideeffects
 */
function SVGFEMergeNodeElement() {}
/** @type {!SVGAnimatedString} */ SVGFEMergeNodeElement.prototype.in1;
/**
 * @constructor
 * @extends {HTMLAudioElement}
 * @param {!string=} src
 */
function Audio(src) {}
/**
 * @constructor
 * @private
 * @extends {WebGLObject}
 * @nosideeffects
 */
function WebGLTransformFeedback() {}
/**
 * @constructor
 * @private
 * @extends {EventTarget}
 * @nosideeffects
 */
function AudioNode() {}
/** @type {!BaseAudioContext} */ AudioNode.prototype.context;
/** @type {!number} */ AudioNode.prototype.numberOfInputs;
/** @type {!number} */ AudioNode.prototype.numberOfOutputs;
/** @type {!number} */ AudioNode.prototype.channelCount;
/** @type {!string} */ AudioNode.prototype.channelCountMode;
/** @type {!string} */ AudioNode.prototype.channelInterpretation;
/**
 * @param {(!number|!AudioNode|!AudioParam)=} arg0
 * @param {!number=} arg1
 * @param {!number=} arg2
 * @return {undefined}
 */
AudioNode.prototype.disconnect = function(arg0,arg1,arg2) {}
/**
 * @param {(!AudioNode|!AudioParam)} arg0
 * @param {!number=} arg1
 * @param {!number=} arg2
 * @return {(!AudioNode|undefined)}
 */
AudioNode.prototype.connect = function(arg0,arg1,arg2) {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function XRPose() {}
/** @type {!boolean} */ XRPose.prototype.emulatedPosition;
/** @type {!XRRigidTransform} */ XRPose.prototype.transform;
/**
 * @constructor
 * @private
 * @extends {HTMLElement}
 * @nosideeffects
 */
function HTMLDialogElement() {}
/** @type {!boolean} */ HTMLDialogElement.prototype.open;
/** @type {!string} */ HTMLDialogElement.prototype.returnValue;
/**
 * @return {undefined}
 */
HTMLDialogElement.prototype.show = function() {}
/**
 * @return {undefined}
 */
HTMLDialogElement.prototype.showModal = function() {}
/**
 * @param {!string=} returnValue
 * @return {undefined}
 */
HTMLDialogElement.prototype.close = function(returnValue) {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @implements {Iterable<!Array<!number|!string>>}
 * @nosideeffects
 */
function DOMTokenList() {}
/** @type {!number} */ DOMTokenList.prototype.length;
/** @type {!string} */ DOMTokenList.prototype.value;
/**
 * @param {...!string} tokens
 * @return {undefined}
 */
DOMTokenList.prototype.add = function(tokens) {}
/**
 * @param {!number} index
 * @return {?string}
 * @nosideeffects
 */
DOMTokenList.prototype.item = function(index) {}
/**
 * @param {!string} token
 * @return {!boolean}
 * @nosideeffects
 */
DOMTokenList.prototype.contains = function(token) {}
/**
 * @param {!string} token
 * @param {!string} newToken
 * @return {!boolean}
 */
DOMTokenList.prototype.replace = function(token,newToken) {}
/**
 * @param {!string} token
 * @return {!boolean}
 * @nosideeffects
 */
DOMTokenList.prototype.supports = function(token) {}
/**
 * @param {!string} token
 * @param {!boolean=} force
 * @return {!boolean}
 */
DOMTokenList.prototype.toggle = function(token,force) {}
/**
 * @param {...!string} tokens
 * @return {undefined}
 */
DOMTokenList.prototype.remove = function(tokens) {}
/**
 * @return {!Iterator<!number>}
 * @nosideeffects
 */
DOMTokenList.prototype.keys = function() {}
/**
 * @return {!Iterator<!string>}
 * @nosideeffects
 */
DOMTokenList.prototype.values = function() {}
/**
 * @return {!Iterator<!Array<!number|!string>>}
 * @nosideeffects
 */
DOMTokenList.prototype.entries = function() {};
/**
 * @return {!Iterator<!Array<!number|!string>>}
 * @nosideeffects
 */
DOMTokenList.prototype[Symbol.iterator] = function() {};
/**
 * @param {function(!string, !number, MAP)} callback
 * @this {MAP}
 * @template MAP
 */
DOMTokenList.prototype.forEach = function(callback) {};
/**
 * @constructor
 * @extends {Object}
 * @param {!AudioDecoderInit} init
 */
function AudioDecoder(init) {}
/** @type {!number} */ AudioDecoder.prototype.decodeQueueSize;
/** @type {!string} */ AudioDecoder.prototype.state;
/**
 * @return {!Promise<undefined>}
 */
AudioDecoder.prototype.flush = function() {}
/**
 * @return {undefined}
 */
AudioDecoder.prototype.reset = function() {}
/**
 * @param {!AudioDecoderConfig} config
 * @return {undefined}
 */
AudioDecoder.prototype.configure = function(config) {}
/**
 * @param {!EncodedAudioChunk} chunk
 * @return {undefined}
 */
AudioDecoder.prototype.decode = function(chunk) {}
/**
 * @return {undefined}
 */
AudioDecoder.prototype.close = function() {}
/**
 * @param {!AudioDecoderConfig} config
 * @return {!Promise<!AudioDecoderSupport>}
 */
AudioDecoder.isConfigSupported = function(config) {}
/**
 * @constructor
 * @private
 * @extends {HTMLElement}
 * @nosideeffects
 */
function HTMLTemplateElement() {}
/** @type {!DocumentFragment} */ HTMLTemplateElement.prototype.content;
/**
 * @constructor
 * @private
 * @extends {HTMLElement}
 * @nosideeffects
 */
function HTMLDirectoryElement() {}
/** @type {!boolean} */ HTMLDirectoryElement.prototype.compact;
/**
 * @constructor
 * @extends {UIEvent}
 * @param {!string} type
 * @param {!TouchEventInit=} eventInitDict
 */
function TouchEvent(type,eventInitDict) {}
/** @type {!boolean} */ TouchEvent.prototype.altKey;
/** @type {!TouchList} */ TouchEvent.prototype.changedTouches;
/** @type {!boolean} */ TouchEvent.prototype.ctrlKey;
/** @type {!boolean} */ TouchEvent.prototype.metaKey;
/** @type {!boolean} */ TouchEvent.prototype.shiftKey;
/** @type {!TouchList} */ TouchEvent.prototype.targetTouches;
/** @type {!TouchList} */ TouchEvent.prototype.touches;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function DOMStringMap() {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function DeviceMotionEventRotationRate() {}
/** @type {?number} */ DeviceMotionEventRotationRate.prototype.alpha;
/** @type {?number} */ DeviceMotionEventRotationRate.prototype.beta;
/** @type {?number} */ DeviceMotionEventRotationRate.prototype.gamma;
/**
 * @constructor
 * @extends {Event}
 * @param {!string} type
 * @param {!ProgressEventInit=} eventInitDict
 */
function ProgressEvent(type,eventInitDict) {}
/** @type {!boolean} */ ProgressEvent.prototype.lengthComputable;
/** @type {!number} */ ProgressEvent.prototype.loaded;
/** @type {!number} */ ProgressEvent.prototype.total;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function GPU() {}
/**
 * @param {!GPURequestAdapterOptions=} options
 * @return {!Promise<?GPUAdapter>}
 */
GPU.prototype.requestAdapter = function(options) {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function GamepadHapticActuator() {}
/** @type {!string} */ GamepadHapticActuator.prototype.type;
/**
 * @param {!number} value
 * @param {!number} duration
 * @return {!Promise<!boolean>}
 */
GamepadHapticActuator.prototype.pulse = function(value,duration) {}
/**
 * @constructor
 * @extends {Object}
 * @param {!GlobalDescriptor} descriptor
 * @param {*=} v
 */
WebAssembly.Global = function(descriptor,v) {}
/** @type {*} */ WebAssembly.Global.prototype.value;
/**
 * @return {*}
 * @override
 */
WebAssembly.Global.prototype.valueOf = function() {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function OCULUS_multiview() {}
/** @const {!GLenum} */ OCULUS_multiview.FRAMEBUFFER_ATTACHMENT_TEXTURE_BASE_VIEW_INDEX_OVR;
/** @const {!GLenum} */ OCULUS_multiview.prototype.FRAMEBUFFER_ATTACHMENT_TEXTURE_BASE_VIEW_INDEX_OVR;
/** @const {!GLenum} */ OCULUS_multiview.FRAMEBUFFER_ATTACHMENT_TEXTURE_NUM_VIEWS_OVR;
/** @const {!GLenum} */ OCULUS_multiview.prototype.FRAMEBUFFER_ATTACHMENT_TEXTURE_NUM_VIEWS_OVR;
/** @const {!GLenum} */ OCULUS_multiview.FRAMEBUFFER_INCOMPLETE_VIEW_TARGETS_OVR;
/** @const {!GLenum} */ OCULUS_multiview.prototype.FRAMEBUFFER_INCOMPLETE_VIEW_TARGETS_OVR;
/** @const {!GLenum} */ OCULUS_multiview.MAX_VIEWS_OVR;
/** @const {!GLenum} */ OCULUS_multiview.prototype.MAX_VIEWS_OVR;
/**
 * @param {!GLenum} target
 * @param {!GLenum} attachment
 * @param {?WebGLTexture} texture
 * @param {!GLint} level
 * @param {!GLint} baseViewIndex
 * @param {!GLsizei} numViews
 * @return {undefined}
 */
OCULUS_multiview.prototype.framebufferTextureMultiviewOVR = function(target,attachment,texture,level,baseViewIndex,numViews) {}
/**
 * @param {!GLenum} target
 * @param {!GLenum} attachment
 * @param {?WebGLTexture} texture
 * @param {!GLint} level
 * @param {!GLsizei} samples
 * @param {!GLint} baseViewIndex
 * @param {!GLsizei} numViews
 * @return {undefined}
 */
OCULUS_multiview.prototype.framebufferTextureMultisampleMultiviewOVR = function(target,attachment,texture,level,samples,baseViewIndex,numViews) {}
/**
 * @constructor
 * @extends {Object}
 */
function DataTransfer() {}
/** @type {!FileList} */ DataTransfer.prototype.files;
/** @type {!DataTransferItemList} */ DataTransfer.prototype.items;
/** @type {!Array<!string>} */ DataTransfer.prototype.types;
/** @type {!string} */ DataTransfer.prototype.dropEffect;
/** @type {!string} */ DataTransfer.prototype.effectAllowed;
/**
 * @param {!string} format
 * @param {!string} data
 * @return {undefined}
 */
DataTransfer.prototype.setData = function(format,data) {}
/**
 * @param {!Element} image
 * @param {!number} x
 * @param {!number} y
 * @return {undefined}
 */
DataTransfer.prototype.setDragImage = function(image,x,y) {}
/**
 * @param {!string} format
 * @return {!string}
 */
DataTransfer.prototype.getData = function(format) {}
/**
 * @param {!string=} format
 * @return {undefined}
 */
DataTransfer.prototype.clearData = function(format) {}
/**
 * @constructor
 * @private
 * @extends {HTMLElement}
 * @nosideeffects
 */
function HTMLFormElement() {}
/** @type {!HTMLFormControlsCollection} */ HTMLFormElement.prototype.elements;
/** @type {!number} */ HTMLFormElement.prototype.length;
/** @type {!DOMTokenList} */ HTMLFormElement.prototype.relList;
/** @type {!string} */ HTMLFormElement.prototype.acceptCharset;
/** @type {!string} */ HTMLFormElement.prototype.action;
/** @type {!string} */ HTMLFormElement.prototype.autocomplete;
/** @type {!string} */ HTMLFormElement.prototype.encoding;
/** @type {!string} */ HTMLFormElement.prototype.enctype;
/** @type {!string} */ HTMLFormElement.prototype.method;
/** @type {!string} */ HTMLFormElement.prototype.name;
/** @type {!boolean} */ HTMLFormElement.prototype.noValidate;
/** @type {!string} */ HTMLFormElement.prototype.rel;
/** @type {!string} */ HTMLFormElement.prototype.target;
/**
 * @return {undefined}
 */
HTMLFormElement.prototype.submit = function() {}
/**
 * @return {!boolean}
 */
HTMLFormElement.prototype.reportValidity = function() {}
/**
 * @return {undefined}
 */
HTMLFormElement.prototype.reset = function() {}
/**
 * @param {?HTMLElement=} submitter
 * @return {undefined}
 */
HTMLFormElement.prototype.requestSubmit = function(submitter) {}
/**
 * @return {!boolean}
 */
HTMLFormElement.prototype.checkValidity = function() {}
/**
 * @constructor
 * @private
 * @extends {HTMLElement}
 * @nosideeffects
 */
function HTMLOutputElement() {}
/** @type {?HTMLFormElement} */ HTMLOutputElement.prototype.form;
/** @type {!DOMTokenList} */ HTMLOutputElement.prototype.htmlFor;
/** @type {!NodeList} */ HTMLOutputElement.prototype.labels;
/** @type {!string} */ HTMLOutputElement.prototype.type;
/** @type {!string} */ HTMLOutputElement.prototype.validationMessage;
/** @type {!ValidityState} */ HTMLOutputElement.prototype.validity;
/** @type {!boolean} */ HTMLOutputElement.prototype.willValidate;
/** @type {!string} */ HTMLOutputElement.prototype.defaultValue;
/** @type {!string} */ HTMLOutputElement.prototype.name;
/** @type {!string} */ HTMLOutputElement.prototype.value;
/**
 * @param {!string} error
 * @return {undefined}
 */
HTMLOutputElement.prototype.setCustomValidity = function(error) {}
/**
 * @return {!boolean}
 */
HTMLOutputElement.prototype.reportValidity = function() {}
/**
 * @return {!boolean}
 */
HTMLOutputElement.prototype.checkValidity = function() {}
/**
 * @constructor
 * @extends {Object}
 * @param {(!number|!Uint8ClampedArray)} arg0
 * @param {!number} arg1
 * @param {(!ImageDataSettings|!number)=} arg2
 * @param {!ImageDataSettings=} arg3
 */
function ImageData(arg0,arg1,arg2,arg3) {}
/** @type {!string} */ ImageData.prototype.colorSpace;
/** @type {!Uint8ClampedArray} */ ImageData.prototype.data;
/** @type {!number} */ ImageData.prototype.height;
/** @type {!number} */ ImageData.prototype.width;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @implements {Iterable<!Array<!number|!DataView>>}
 * @nosideeffects
 */
function BluetoothManufacturerDataMap() {}
/** @const {number} */ BluetoothManufacturerDataMap.prototype.size;
/**
 * @param {!number} key
 * @return {!boolean}
 * @nosideeffects
 */
BluetoothManufacturerDataMap.prototype.has = function(key) {}
/**
 * @param {!number} key
 * @return {!DataView}
 * @nosideeffects
 */
BluetoothManufacturerDataMap.prototype.get = function(key) {}
/**
 * @return {!Iterator<!number>}
 * @nosideeffects
 */
BluetoothManufacturerDataMap.prototype.keys = function() {}
/**
 * @return {!Iterator<!DataView>}
 * @nosideeffects
 */
BluetoothManufacturerDataMap.prototype.values = function() {}
/**
 * @return {!Iterator<!Array<!number|!DataView>>}
 * @nosideeffects
 */
BluetoothManufacturerDataMap.prototype.entries = function() {};
/**
 * @return {!Iterator<!Array<!number|!DataView>>}
 * @nosideeffects
 */
BluetoothManufacturerDataMap.prototype[Symbol.iterator] = function() {};
/**
 * @param {function(!DataView, !number, MAP)} callback
 * @this {MAP}
 * @template MAP
 */
BluetoothManufacturerDataMap.prototype.forEach = function(callback) {};
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function RTCRtpTransceiver() {}
/** @type {?string} */ RTCRtpTransceiver.prototype.currentDirection;
/** @type {?string} */ RTCRtpTransceiver.prototype.mid;
/** @type {!RTCRtpReceiver} */ RTCRtpTransceiver.prototype.receiver;
/** @type {!RTCRtpSender} */ RTCRtpTransceiver.prototype.sender;
/** @type {!string} */ RTCRtpTransceiver.prototype.direction;
/**
 * @return {undefined}
 */
RTCRtpTransceiver.prototype.stop = function() {}
/**
 * @param {!Array<!RTCRtpCodecCapability>} codecs
 * @return {undefined}
 */
RTCRtpTransceiver.prototype.setCodecPreferences = function(codecs) {}
/**
 * @constructor
 * @private
 * @extends {HTMLElement}
 * @nosideeffects
 */
function HTMLUListElement() {}
/** @type {!boolean} */ HTMLUListElement.prototype.compact;
/** @type {!string} */ HTMLUListElement.prototype.type;
/**
 * @constructor
 * @extends {AudioNode}
 * @param {!AudioContext} context
 * @param {!MediaStreamAudioSourceOptions} options
 */
function MediaStreamAudioSourceNode(context,options) {}
/** @type {!MediaStream} */ MediaStreamAudioSourceNode.prototype.mediaStream;
/**
 * @constructor
 * @extends {Event}
 * @param {!string} type
 * @param {!PromiseRejectionEventInit} eventInitDict
 */
function PromiseRejectionEvent(type,eventInitDict) {}
/** @type {!Promise<*>} */ PromiseRejectionEvent.prototype.promise;
/** @type {*} */ PromiseRejectionEvent.prototype.reason;
/**
 * @constructor
 * @private
 * @extends {XRReferenceSpace}
 * @nosideeffects
 */
function XRBoundedReferenceSpace() {}
/** @type {!Array<!DOMPointReadOnly>} */ XRBoundedReferenceSpace.prototype.boundsGeometry;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function WEBGL_debug_renderer_info() {}
/** @const {!GLenum} */ WEBGL_debug_renderer_info.prototype.UNMASKED_RENDERER_WEBGL;
/** @const {!GLenum} */ WEBGL_debug_renderer_info.prototype.UNMASKED_VENDOR_WEBGL;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function SVGAngle() {}
/** @const {!number} */ SVGAngle.SVG_ANGLETYPE_DEG;
/** @const {!number} */ SVGAngle.prototype.SVG_ANGLETYPE_DEG;
/** @const {!number} */ SVGAngle.SVG_ANGLETYPE_GRAD;
/** @const {!number} */ SVGAngle.prototype.SVG_ANGLETYPE_GRAD;
/** @const {!number} */ SVGAngle.SVG_ANGLETYPE_RAD;
/** @const {!number} */ SVGAngle.prototype.SVG_ANGLETYPE_RAD;
/** @const {!number} */ SVGAngle.SVG_ANGLETYPE_UNKNOWN;
/** @const {!number} */ SVGAngle.prototype.SVG_ANGLETYPE_UNKNOWN;
/** @const {!number} */ SVGAngle.SVG_ANGLETYPE_UNSPECIFIED;
/** @const {!number} */ SVGAngle.prototype.SVG_ANGLETYPE_UNSPECIFIED;
/** @type {!number} */ SVGAngle.prototype.unitType;
/** @type {!number} */ SVGAngle.prototype.value;
/** @type {!string} */ SVGAngle.prototype.valueAsString;
/** @type {!number} */ SVGAngle.prototype.valueInSpecifiedUnits;
/**
 * @param {!number} unitType
 * @return {undefined}
 */
SVGAngle.prototype.convertToSpecifiedUnits = function(unitType) {}
/**
 * @param {!number} unitType
 * @param {!number} valueInSpecifiedUnits
 * @return {undefined}
 */
SVGAngle.prototype.newValueSpecifiedUnits = function(unitType,valueInSpecifiedUnits) {}
/**
 * @constructor
 * @private
 * @extends {SVGComponentTransferFunctionElement}
 * @nosideeffects
 */
function SVGFEFuncAElement() {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function GeolocationPosition() {}
/** @type {!GeolocationCoordinates} */ GeolocationPosition.prototype.coords;
/** @type {!DOMTimeStamp} */ GeolocationPosition.prototype.timestamp;
/**
 * @constructor
 * @extends {Object}
 * @implements {Iterable<!Array<!string|!string>>}
 * @param {(!Array<!Array<!string>>|!Object<!string,!string>|!string)=} init
 */
function URLSearchParams(init) {}
/**
 * @param {!string} name
 * @param {!string} value
 * @return {undefined}
 */
URLSearchParams.prototype.set = function(name,value) {}
/**
 * @param {!string} name
 * @return {!Array<!string>}
 * @nosideeffects
 */
URLSearchParams.prototype.getAll = function(name) {}
/**
 * @param {!string} name
 * @return {?string}
 * @nosideeffects
 */
URLSearchParams.prototype.get = function(name) {}
/**
 * @return {undefined}
 */
URLSearchParams.prototype.sort = function() {}
/**
 * @param {!string} name
 * @return {!boolean}
 * @nosideeffects
 */
URLSearchParams.prototype.has = function(name) {}
/**
 * @param {!string} name
 * @return {undefined}
 */
URLSearchParams.prototype.delete = function(name) {}
/**
 * @param {!string} name
 * @param {!string} value
 * @return {undefined}
 */
URLSearchParams.prototype.append = function(name,value) {}
/**
 * @return {!Iterator<!string>}
 * @nosideeffects
 */
URLSearchParams.prototype.keys = function() {}
/**
 * @return {!Iterator<!string>}
 * @nosideeffects
 */
URLSearchParams.prototype.values = function() {}
/**
 * @return {!Iterator<!Array<!string|!string>>}
 * @nosideeffects
 */
URLSearchParams.prototype.entries = function() {};
/**
 * @return {!Iterator<!Array<!string|!string>>}
 * @nosideeffects
 */
URLSearchParams.prototype[Symbol.iterator] = function() {};
/**
 * @param {function(!string, !string, MAP)} callback
 * @this {MAP}
 * @template MAP
 */
URLSearchParams.prototype.forEach = function(callback) {};
/**
 * @constructor
 * @extends {Event}
 * @param {!string} type
 * @param {!GPUUncapturedErrorEventInit} gpuUncapturedErrorEventInitDict
 */
function GPUUncapturedErrorEvent(type,gpuUncapturedErrorEventInitDict) {}
/** @type {!GPUError} */ GPUUncapturedErrorEvent.prototype.error;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function Storage() {}
/** @type {!number} */ Storage.prototype.length;
/**
 * @param {!string} key
 * @return {undefined}
 */
Storage.prototype.removeItem = function(key) {}
/**
 * @return {undefined}
 */
Storage.prototype.clear = function() {}
/**
 * @param {!string} key
 * @return {?string}
 */
Storage.prototype.getItem = function(key) {}
/**
 * @param {!string} key
 * @param {!string} value
 * @return {undefined}
 */
Storage.prototype.setItem = function(key,value) {}
/**
 * @param {!number} index
 * @return {?string}
 */
Storage.prototype.key = function(index) {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function IdleDeadline() {}
/** @type {!boolean} */ IdleDeadline.prototype.didTimeout;
/**
 * @return {!DOMHighResTimeStamp}
 */
IdleDeadline.prototype.timeRemaining = function() {}
/**
 * @constructor
 * @extends {EventTarget}
 * @param {!MediaStream} stream
 * @param {!MediaRecorderOptions=} options
 */
function MediaRecorder(stream,options) {}
/** @type {!string} */ MediaRecorder.prototype.audioBitrateMode;
/** @type {!number} */ MediaRecorder.prototype.audioBitsPerSecond;
/** @type {!string} */ MediaRecorder.prototype.mimeType;
/** @type {!string} */ MediaRecorder.prototype.state;
/** @type {!MediaStream} */ MediaRecorder.prototype.stream;
/** @type {!number} */ MediaRecorder.prototype.videoBitsPerSecond;
/** @type {!NullableEventHandler} */ MediaRecorder.prototype.ondataavailable;
/** @type {?MediaRecorderErrorEventHandler} */ MediaRecorder.prototype.onerror;
/** @type {!NullableEventHandler} */ MediaRecorder.prototype.onpause;
/** @type {!NullableEventHandler} */ MediaRecorder.prototype.onresume;
/** @type {!NullableEventHandler} */ MediaRecorder.prototype.onstart;
/** @type {!NullableEventHandler} */ MediaRecorder.prototype.onstop;
/**
 * @return {undefined}
 */
MediaRecorder.prototype.resume = function() {}
/**
 * @return {undefined}
 */
MediaRecorder.prototype.stop = function() {}
/**
 * @param {!number=} timeslice
 * @return {undefined}
 */
MediaRecorder.prototype.start = function(timeslice) {}
/**
 * @param {!string} type
 * @return {!boolean}
 */
MediaRecorder.isTypeSupported = function(type) {}
/**
 * @return {undefined}
 */
MediaRecorder.prototype.requestData = function() {}
/**
 * @return {undefined}
 */
MediaRecorder.prototype.pause = function() {}
/**
 * @constructor
 * @extends {Event}
 * @param {!string} type
 * @param {!AnimationPlaybackEventInit=} eventInitDict
 */
function AnimationPlaybackEvent(type,eventInitDict) {}
/** @type {?number} */ AnimationPlaybackEvent.prototype.currentTime;
/** @type {?number} */ AnimationPlaybackEvent.prototype.timelineTime;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function Cache() {}
/**
 * @param {!RequestInfo} request
 * @return {!Promise<undefined>}
 */
Cache.prototype.add = function(request) {}
/**
 * @param {!Array<!RequestInfo>} requests
 * @return {!Promise<undefined>}
 */
Cache.prototype.addAll = function(requests) {}
/**
 * @param {!RequestInfo=} request
 * @param {!CacheQueryOptions=} options
 * @return {!Promise<!Array<!Request>>}
 */
Cache.prototype.keys = function(request,options) {}
/**
 * @param {!RequestInfo} request
 * @param {!CacheQueryOptions=} options
 * @return {!Promise<ResponseOrUndefinedUnion>}
 */
Cache.prototype.match = function(request,options) {}
/**
 * @param {!RequestInfo} request
 * @param {!CacheQueryOptions=} options
 * @return {!Promise<!boolean>}
 */
Cache.prototype.delete = function(request,options) {}
/**
 * @param {!RequestInfo} request
 * @param {!Response} response
 * @return {!Promise<undefined>}
 */
Cache.prototype.put = function(request,response) {}
/**
 * @param {!RequestInfo=} request
 * @param {!CacheQueryOptions=} options
 * @return {!Promise<!Array<!Response>>}
 */
Cache.prototype.matchAll = function(request,options) {}
/**
 * @constructor
 * @extends {Object}
 * @param {!Object<!string,!ClipboardItemData>} items
 * @param {!ClipboardItemOptions=} options
 */
function ClipboardItem(items,options) {}
/** @type {!boolean} */ ClipboardItem.prototype.delayed;
/** @type {!number} */ ClipboardItem.prototype.lastModified;
/** @type {!string} */ ClipboardItem.prototype.presentationStyle;
/** @type {!Array<!string>} */ ClipboardItem.prototype.types;
/**
 * @param {!string} type
 * @return {!Promise<!Blob>}
 */
ClipboardItem.prototype.getType = function(type) {}
/**
 * @param {!Object<!string,!ClipboardItemDelayedCallback>} items
 * @param {!ClipboardItemOptions=} options
 * @return {!ClipboardItem}
 */
ClipboardItem.createDelayed = function(items,options) {}
/**
 * @constructor
 * @private
 * @extends {HTMLMediaElement}
 * @nosideeffects
 */
function HTMLVideoElement() {}
/** @type {!number} */ HTMLVideoElement.prototype.videoHeight;
/** @type {!number} */ HTMLVideoElement.prototype.videoWidth;
/** @type {!number} */ HTMLVideoElement.prototype.height;
/** @type {!boolean} */ HTMLVideoElement.prototype.playsInline;
/** @type {!string} */ HTMLVideoElement.prototype.poster;
/** @type {!number} */ HTMLVideoElement.prototype.width;
/**
 * @return {!VideoPlaybackQuality}
 */
HTMLVideoElement.prototype.getVideoPlaybackQuality = function() {}
/**
 * @constructor
 * @private
 * @extends {HTMLElement}
 * @nosideeffects
 */
function HTMLIFrameElement() {}
/** @type {?Document} */ HTMLIFrameElement.prototype.contentDocument;
/** @type {?WindowProxy} */ HTMLIFrameElement.prototype.contentWindow;
/** @type {!DOMTokenList} */ HTMLIFrameElement.prototype.sandbox;
/** @type {!string} */ HTMLIFrameElement.prototype.allow;
/** @type {!boolean} */ HTMLIFrameElement.prototype.allowFullscreen;
/** @type {!string} */ HTMLIFrameElement.prototype.height;
/** @type {!string} */ HTMLIFrameElement.prototype.loading;
/** @type {!string} */ HTMLIFrameElement.prototype.name;
/** @type {!string} */ HTMLIFrameElement.prototype.referrerPolicy;
/** @type {!string} */ HTMLIFrameElement.prototype.src;
/** @type {!string} */ HTMLIFrameElement.prototype.srcdoc;
/** @type {!string} */ HTMLIFrameElement.prototype.width;
/** @type {!string} */ HTMLIFrameElement.prototype.align;
/** @type {!string} */ HTMLIFrameElement.prototype.frameBorder;
/** @type {!string} */ HTMLIFrameElement.prototype.longDesc;
/** @type {!string} */ HTMLIFrameElement.prototype.marginHeight;
/** @type {!string} */ HTMLIFrameElement.prototype.marginWidth;
/** @type {!string} */ HTMLIFrameElement.prototype.scrolling;
/**
 * @return {?Document}
 */
HTMLIFrameElement.prototype.getSVGDocument = function() {}
/**
 * @constructor
 * @extends {Event}
 * @param {!string} type
 * @param {!MediaRecorderErrorEventInit} eventInitDict
 */
function MediaRecorderErrorEvent(type,eventInitDict) {}
/** @type {!DOMException} */ MediaRecorderErrorEvent.prototype.error;
/**
 * @constructor
 * @extends {Event}
 * @param {!string} type
 * @param {!RTCDTMFToneChangeEventInit=} eventInitDict
 */
function RTCDTMFToneChangeEvent(type,eventInitDict) {}
/** @type {!string} */ RTCDTMFToneChangeEvent.prototype.tone;
/**
 * @constructor
 * @private
 * @extends {EventTarget}
 * @nosideeffects
 */
function VideoTrackList() {}
/** @type {!number} */ VideoTrackList.prototype.length;
/** @type {!number} */ VideoTrackList.prototype.selectedIndex;
/** @type {?TrackEventHandler} */ VideoTrackList.prototype.onaddtrack;
/** @type {?EventHandler} */ VideoTrackList.prototype.onchange;
/** @type {?TrackEventHandler} */ VideoTrackList.prototype.onremovetrack;
/**
 * @param {!string} id
 * @return {?VideoTrack}
 */
VideoTrackList.prototype.getTrackById = function(id) {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function BluetoothUUID() {}
/**
 * @param {(!string|!number)} name
 * @return {!UUID}
 */
BluetoothUUID.getDescriptor = function(name) {}
/**
 * @param {(!string|!number)} name
 * @return {!UUID}
 */
BluetoothUUID.getCharacteristic = function(name) {}
/**
 * @param {!number} alias
 * @return {!UUID}
 */
BluetoothUUID.canonicalUUID = function(alias) {}
/**
 * @param {(!string|!number)} name
 * @return {!UUID}
 */
BluetoothUUID.getService = function(name) {}
/**
 * @constructor
 * @extends {Object}
 * @param {(!CanvasImageSource|!Array<!PlaneInit>)} arg0
 * @param {(!VideoFrameInit|!VideoFramePlaneInit)=} arg1
 */
function VideoFrame(arg0,arg1) {}
/** @type {!number} */ VideoFrame.prototype.codedHeight;
/** @type {!VideoFrameRect} */ VideoFrame.prototype.codedRect;
/** @type {!number} */ VideoFrame.prototype.codedWidth;
/** @type {!number} */ VideoFrame.prototype.displayHeight;
/** @type {!number} */ VideoFrame.prototype.displayWidth;
/** @type {?number} */ VideoFrame.prototype.duration;
/** @type {!string} */ VideoFrame.prototype.format;
/** @type {?number} */ VideoFrame.prototype.timestamp;
/** @type {!VideoFrameRect} */ VideoFrame.prototype.visibleRect;
/**
 * @param {!BufferSource} destination
 * @param {!VideoFrameCopyToOptions=} options
 * @return {!Promise<!Array<!PlaneLayout>>}
 */
VideoFrame.prototype.copyTo = function(destination,options) {}
/**
 * @param {!VideoFrameCopyToOptions=} options
 * @return {!number}
 */
VideoFrame.prototype.allocationSize = function(options) {}
/**
 * @return {!VideoFrame}
 */
VideoFrame.prototype.clone = function() {}
/**
 * @return {undefined}
 */
VideoFrame.prototype.close = function() {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function Gamepad() {}
/** @type {!Array<!number>} */ Gamepad.prototype.axes;
/** @type {!Array<!GamepadButton>} */ Gamepad.prototype.buttons;
/** @type {!boolean} */ Gamepad.prototype.connected;
/** @type {!string} */ Gamepad.prototype.id;
/** @type {!number} */ Gamepad.prototype.index;
/** @type {!string} */ Gamepad.prototype.mapping;
/** @type {!DOMHighResTimeStamp} */ Gamepad.prototype.timestamp;
/** @type {!string} */ Gamepad.prototype.hand;
/** @type {!Array<!GamepadHapticActuator>} */ Gamepad.prototype.hapticActuators;
/** @type {?GamepadPose} */ Gamepad.prototype.pose;
/** @type {?Array<!GamepadTouch>} */ Gamepad.prototype.touchEvents;
/**
 * @constructor
 * @extends {Event}
 * @param {!string} type
 * @param {!SecurityPolicyViolationEventInit=} eventInitDict
 */
function SecurityPolicyViolationEvent(type,eventInitDict) {}
/** @type {!string} */ SecurityPolicyViolationEvent.prototype.blockedURI;
/** @type {!number} */ SecurityPolicyViolationEvent.prototype.columnNumber;
/** @type {!string} */ SecurityPolicyViolationEvent.prototype.disposition;
/** @type {!string} */ SecurityPolicyViolationEvent.prototype.documentURI;
/** @type {!string} */ SecurityPolicyViolationEvent.prototype.effectiveDirective;
/** @type {!number} */ SecurityPolicyViolationEvent.prototype.lineNumber;
/** @type {!string} */ SecurityPolicyViolationEvent.prototype.originalPolicy;
/** @type {!string} */ SecurityPolicyViolationEvent.prototype.referrer;
/** @type {!string} */ SecurityPolicyViolationEvent.prototype.sample;
/** @type {!string} */ SecurityPolicyViolationEvent.prototype.sourceFile;
/** @type {!number} */ SecurityPolicyViolationEvent.prototype.statusCode;
/** @type {!string} */ SecurityPolicyViolationEvent.prototype.violatedDirective;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function GPUTexture() {}
/** @type {?string} */ GPUTexture.prototype.label;
/**
 * @return {undefined}
 */
GPUTexture.prototype.destroy = function() {}
/**
 * @param {!GPUTextureViewDescriptor=} descriptor
 * @return {!GPUTextureView}
 */
GPUTexture.prototype.createView = function(descriptor) {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function ReadableStreamDefaultController() {}
/** @type {?number} */ ReadableStreamDefaultController.prototype.desiredSize;
/**
 * @param {*=} chunk
 * @return {undefined}
 */
ReadableStreamDefaultController.prototype.enqueue = function(chunk) {}
/**
 * @param {*=} e
 * @return {undefined}
 */
ReadableStreamDefaultController.prototype.error = function(e) {}
/**
 * @return {undefined}
 */
ReadableStreamDefaultController.prototype.close = function() {}
/**
 * @constructor
 * @private
 * @extends {SVGTextContentElement}
 * @nosideeffects
 */
function SVGTextPathElement() {}
/** @const {!number} */ SVGTextPathElement.TEXTPATH_METHODTYPE_ALIGN;
/** @const {!number} */ SVGTextPathElement.prototype.TEXTPATH_METHODTYPE_ALIGN;
/** @const {!number} */ SVGTextPathElement.TEXTPATH_METHODTYPE_STRETCH;
/** @const {!number} */ SVGTextPathElement.prototype.TEXTPATH_METHODTYPE_STRETCH;
/** @const {!number} */ SVGTextPathElement.TEXTPATH_METHODTYPE_UNKNOWN;
/** @const {!number} */ SVGTextPathElement.prototype.TEXTPATH_METHODTYPE_UNKNOWN;
/** @const {!number} */ SVGTextPathElement.TEXTPATH_SPACINGTYPE_AUTO;
/** @const {!number} */ SVGTextPathElement.prototype.TEXTPATH_SPACINGTYPE_AUTO;
/** @const {!number} */ SVGTextPathElement.TEXTPATH_SPACINGTYPE_EXACT;
/** @const {!number} */ SVGTextPathElement.prototype.TEXTPATH_SPACINGTYPE_EXACT;
/** @const {!number} */ SVGTextPathElement.TEXTPATH_SPACINGTYPE_UNKNOWN;
/** @const {!number} */ SVGTextPathElement.prototype.TEXTPATH_SPACINGTYPE_UNKNOWN;
/** @type {!SVGAnimatedEnumeration} */ SVGTextPathElement.prototype.method;
/** @type {!SVGAnimatedEnumeration} */ SVGTextPathElement.prototype.spacing;
/** @type {!SVGAnimatedLength} */ SVGTextPathElement.prototype.startOffset;
/** @type {!SVGAnimatedString} */ SVGTextPathElement.prototype.href;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function MediaKeys() {}
/**
 * @param {!string=} sessionType
 * @return {!MediaKeySession}
 */
MediaKeys.prototype.createSession = function(sessionType) {}
/**
 * @param {!BufferSource} serverCertificate
 * @return {!Promise<!boolean>}
 */
MediaKeys.prototype.setServerCertificate = function(serverCertificate) {}
/**
 * @constructor
 * @extends {Object}
 * @param {!PerformanceObserverCallback} callback
 */
function PerformanceObserver(callback) {}
/** @type {!Array<!string>} */ PerformanceObserver.supportedEntryTypes;
/**
 * @return {undefined}
 */
PerformanceObserver.prototype.disconnect = function() {}
/**
 * @return {!PerformanceEntryList}
 */
PerformanceObserver.prototype.takeRecords = function() {}
/**
 * @param {!PerformanceObserverInit=} options
 * @return {undefined}
 */
PerformanceObserver.prototype.observe = function(options) {}
/**
 * @constructor
 * @private
 * @extends {HTMLElement}
 * @nosideeffects
 */
function HTMLBRElement() {}
/** @type {!string} */ HTMLBRElement.prototype.clear;
/**
 * @constructor
 * @private
 * @extends {EventTarget}
 * @nosideeffects
 */
function TextTrackCue() {}
/** @type {?TextTrack} */ TextTrackCue.prototype.track;
/** @type {!number} */ TextTrackCue.prototype.endTime;
/** @type {!string} */ TextTrackCue.prototype.id;
/** @type {!NullableEventHandler} */ TextTrackCue.prototype.onenter;
/** @type {!NullableEventHandler} */ TextTrackCue.prototype.onexit;
/** @type {!boolean} */ TextTrackCue.prototype.pauseOnExit;
/** @type {!number} */ TextTrackCue.prototype.startTime;
/**
 * @constructor
 * @extends {Node}
 */
function DocumentFragment() {}
/** @type {!number} */ DocumentFragment.prototype.childElementCount;
/** @type {!HTMLCollection} */ DocumentFragment.prototype.children;
/** @type {?Element} */ DocumentFragment.prototype.firstElementChild;
/** @type {?Element} */ DocumentFragment.prototype.lastElementChild;
/**
 * @param {!string} elementId
 * @return {?Element}
 * @nosideeffects
 */
DocumentFragment.prototype.getElementById = function(elementId) {}
/**
 * @param {!string} selectors
 * @return {!NodeList}
 * @nosideeffects
 */
DocumentFragment.prototype.querySelectorAll = function(selectors) {}
/**
 * @param {...(!Node|!string)} nodes
 * @return {undefined}
 */
DocumentFragment.prototype.prepend = function(nodes) {}
/**
 * @param {!string} selectors
 * @return {?Element}
 * @nosideeffects
 */
DocumentFragment.prototype.querySelector = function(selectors) {}
/**
 * @param {...(!Node|!string)} nodes
 * @return {undefined}
 */
DocumentFragment.prototype.replaceChildren = function(nodes) {}
/**
 * @param {...(!Node|!string)} nodes
 * @return {undefined}
 */
DocumentFragment.prototype.append = function(nodes) {}
/**
 * @constructor
 * @extends {AudioNode}
 * @param {!BaseAudioContext} context
 * @param {!DynamicsCompressorOptions=} options
 */
function DynamicsCompressorNode(context,options) {}
/** @type {!AudioParam} */ DynamicsCompressorNode.prototype.attack;
/** @type {!AudioParam} */ DynamicsCompressorNode.prototype.knee;
/** @type {!AudioParam} */ DynamicsCompressorNode.prototype.ratio;
/** @type {!number} */ DynamicsCompressorNode.prototype.reduction;
/** @type {!AudioParam} */ DynamicsCompressorNode.prototype.release;
/** @type {!AudioParam} */ DynamicsCompressorNode.prototype.threshold;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function NamedNodeMap() {}
/** @type {!number} */ NamedNodeMap.prototype.length;
/**
 * @param {!number} index
 * @return {?Attr}
 * @nosideeffects
 */
NamedNodeMap.prototype.item = function(index) {}
/**
 * @param {!string} qualifiedName
 * @return {!Attr}
 */
NamedNodeMap.prototype.removeNamedItem = function(qualifiedName) {}
/**
 * @param {!Attr} attr
 * @return {?Attr}
 */
NamedNodeMap.prototype.setNamedItem = function(attr) {}
/**
 * @param {?string} namespace
 * @param {!string} localName
 * @return {?Attr}
 */
NamedNodeMap.prototype.getNamedItemNS = function(namespace,localName) {}
/**
 * @param {!string} qualifiedName
 * @return {?Attr}
 * @nosideeffects
 */
NamedNodeMap.prototype.getNamedItem = function(qualifiedName) {}
/**
 * @param {!Attr} attr
 * @return {?Attr}
 */
NamedNodeMap.prototype.setNamedItemNS = function(attr) {}
/**
 * @param {?string} namespace
 * @param {!string} localName
 * @return {!Attr}
 */
NamedNodeMap.prototype.removeNamedItemNS = function(namespace,localName) {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function ElementInternals() {}
/** @type {?HTMLFormElement} */ ElementInternals.prototype.form;
/** @type {!NodeList} */ ElementInternals.prototype.labels;
/** @type {?ShadowRoot} */ ElementInternals.prototype.shadowRoot;
/** @type {!string} */ ElementInternals.prototype.validationMessage;
/** @type {!ValidityState} */ ElementInternals.prototype.validity;
/** @type {!boolean} */ ElementInternals.prototype.willValidate;
/** @type {!string} */ ElementInternals.prototype.ariaAtomic;
/** @type {!string} */ ElementInternals.prototype.ariaAutoComplete;
/** @type {!string} */ ElementInternals.prototype.ariaBusy;
/** @type {!string} */ ElementInternals.prototype.ariaChecked;
/** @type {!string} */ ElementInternals.prototype.ariaColCount;
/** @type {!string} */ ElementInternals.prototype.ariaColIndex;
/** @type {!string} */ ElementInternals.prototype.ariaColIndexText;
/** @type {!string} */ ElementInternals.prototype.ariaColSpan;
/** @type {!string} */ ElementInternals.prototype.ariaCurrent;
/** @type {!string} */ ElementInternals.prototype.ariaDescription;
/** @type {!string} */ ElementInternals.prototype.ariaDisabled;
/** @type {!string} */ ElementInternals.prototype.ariaExpanded;
/** @type {!string} */ ElementInternals.prototype.ariaHasPopup;
/** @type {!string} */ ElementInternals.prototype.ariaHidden;
/** @type {!string} */ ElementInternals.prototype.ariaInvalid;
/** @type {!string} */ ElementInternals.prototype.ariaKeyShortcuts;
/** @type {!string} */ ElementInternals.prototype.ariaLabel;
/** @type {!string} */ ElementInternals.prototype.ariaLevel;
/** @type {!string} */ ElementInternals.prototype.ariaLive;
/** @type {!string} */ ElementInternals.prototype.ariaModal;
/** @type {!string} */ ElementInternals.prototype.ariaMultiLine;
/** @type {!string} */ ElementInternals.prototype.ariaMultiSelectable;
/** @type {!string} */ ElementInternals.prototype.ariaOrientation;
/** @type {!string} */ ElementInternals.prototype.ariaPlaceholder;
/** @type {!string} */ ElementInternals.prototype.ariaPosInSet;
/** @type {!string} */ ElementInternals.prototype.ariaPressed;
/** @type {!string} */ ElementInternals.prototype.ariaReadOnly;
/** @type {!string} */ ElementInternals.prototype.ariaRequired;
/** @type {!string} */ ElementInternals.prototype.ariaRoleDescription;
/** @type {!string} */ ElementInternals.prototype.ariaRowCount;
/** @type {!string} */ ElementInternals.prototype.ariaRowIndex;
/** @type {!string} */ ElementInternals.prototype.ariaRowIndexText;
/** @type {!string} */ ElementInternals.prototype.ariaRowSpan;
/** @type {!string} */ ElementInternals.prototype.ariaSelected;
/** @type {!string} */ ElementInternals.prototype.ariaSetSize;
/** @type {!string} */ ElementInternals.prototype.ariaSort;
/** @type {!string} */ ElementInternals.prototype.ariaValueMax;
/** @type {!string} */ ElementInternals.prototype.ariaValueMin;
/** @type {!string} */ ElementInternals.prototype.ariaValueNow;
/** @type {!string} */ ElementInternals.prototype.ariaValueText;
/** @type {?string} */ ElementInternals.prototype.role;
/**
 * @param {(!File|!string|!FormData)} value
 * @param {(!File|!string|!FormData)=} state
 * @return {undefined}
 */
ElementInternals.prototype.setFormValue = function(value,state) {}
/**
 * @return {!boolean}
 */
ElementInternals.prototype.reportValidity = function() {}
/**
 * @param {!ValidityStateFlags=} flags
 * @param {!string=} message
 * @param {!HTMLElement=} anchor
 * @return {undefined}
 */
ElementInternals.prototype.setValidity = function(flags,message,anchor) {}
/**
 * @return {!boolean}
 */
ElementInternals.prototype.checkValidity = function() {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function Report() {}
/** @type {?ReportBody} */ Report.prototype.body;
/** @type {!string} */ Report.prototype.type;
/** @type {!string} */ Report.prototype.url;
/**
 * @return {!Object}
 * @override
 */
Report.prototype.toJSON = function() {}
/**
 * @constructor
 * @extends {Object}
 */
function GPUOutOfMemoryError() {}
/**
 * @constructor
 * @private
 * @extends {SVGElement}
 * @nosideeffects
 */
function SVGFEConvolveMatrixElement() {}
/** @const {!number} */ SVGFEConvolveMatrixElement.SVG_EDGEMODE_DUPLICATE;
/** @const {!number} */ SVGFEConvolveMatrixElement.prototype.SVG_EDGEMODE_DUPLICATE;
/** @const {!number} */ SVGFEConvolveMatrixElement.SVG_EDGEMODE_NONE;
/** @const {!number} */ SVGFEConvolveMatrixElement.prototype.SVG_EDGEMODE_NONE;
/** @const {!number} */ SVGFEConvolveMatrixElement.SVG_EDGEMODE_UNKNOWN;
/** @const {!number} */ SVGFEConvolveMatrixElement.prototype.SVG_EDGEMODE_UNKNOWN;
/** @const {!number} */ SVGFEConvolveMatrixElement.SVG_EDGEMODE_WRAP;
/** @const {!number} */ SVGFEConvolveMatrixElement.prototype.SVG_EDGEMODE_WRAP;
/** @type {!SVGAnimatedNumber} */ SVGFEConvolveMatrixElement.prototype.bias;
/** @type {!SVGAnimatedNumber} */ SVGFEConvolveMatrixElement.prototype.divisor;
/** @type {!SVGAnimatedEnumeration} */ SVGFEConvolveMatrixElement.prototype.edgeMode;
/** @type {!SVGAnimatedString} */ SVGFEConvolveMatrixElement.prototype.in1;
/** @type {!SVGAnimatedNumberList} */ SVGFEConvolveMatrixElement.prototype.kernelMatrix;
/** @type {!SVGAnimatedNumber} */ SVGFEConvolveMatrixElement.prototype.kernelUnitLengthX;
/** @type {!SVGAnimatedNumber} */ SVGFEConvolveMatrixElement.prototype.kernelUnitLengthY;
/** @type {!SVGAnimatedInteger} */ SVGFEConvolveMatrixElement.prototype.orderX;
/** @type {!SVGAnimatedInteger} */ SVGFEConvolveMatrixElement.prototype.orderY;
/** @type {!SVGAnimatedBoolean} */ SVGFEConvolveMatrixElement.prototype.preserveAlpha;
/** @type {!SVGAnimatedInteger} */ SVGFEConvolveMatrixElement.prototype.targetX;
/** @type {!SVGAnimatedInteger} */ SVGFEConvolveMatrixElement.prototype.targetY;
/** @type {!SVGAnimatedLength} */ SVGFEConvolveMatrixElement.prototype.height;
/** @type {!SVGAnimatedString} */ SVGFEConvolveMatrixElement.prototype.result;
/** @type {!SVGAnimatedLength} */ SVGFEConvolveMatrixElement.prototype.width;
/** @type {!SVGAnimatedLength} */ SVGFEConvolveMatrixElement.prototype.x;
/** @type {!SVGAnimatedLength} */ SVGFEConvolveMatrixElement.prototype.y;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function BluetoothRemoteGATTServer() {}
/** @type {!boolean} */ BluetoothRemoteGATTServer.prototype.connected;
/** @type {!BluetoothDevice} */ BluetoothRemoteGATTServer.prototype.device;
/**
 * @return {undefined}
 */
BluetoothRemoteGATTServer.prototype.disconnect = function() {}
/**
 * @param {!BluetoothServiceUUID=} service
 * @return {!Promise<!Array<!BluetoothRemoteGATTService>>}
 */
BluetoothRemoteGATTServer.prototype.getPrimaryServices = function(service) {}
/**
 * @param {!BluetoothServiceUUID} service
 * @return {!Promise<!BluetoothRemoteGATTService>}
 */
BluetoothRemoteGATTServer.prototype.getPrimaryService = function(service) {}
/**
 * @return {!Promise<!BluetoothRemoteGATTServer>}
 */
BluetoothRemoteGATTServer.prototype.connect = function() {}
/**
 * @constructor
 * @extends {Event}
 * @param {!string} type
 * @param {!ValueEventInit=} initDict
 */
function ValueEvent(type,initDict) {}
/** @type {*} */ ValueEvent.prototype.value;
/**
 * @constructor
 * @private
 * @extends {EventTarget}
 * @nosideeffects
 */
function ImageTrack() {}
/** @type {!boolean} */ ImageTrack.prototype.animated;
/** @type {!number} */ ImageTrack.prototype.frameCount;
/** @type {!number} */ ImageTrack.prototype.repetitionCount;
/** @type {!NullableEventHandler} */ ImageTrack.prototype.onchange;
/** @type {!boolean} */ ImageTrack.prototype.selected;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function OES_texture_float_linear() {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function TextMetrics() {}
/** @type {!number} */ TextMetrics.prototype.actualBoundingBoxAscent;
/** @type {!number} */ TextMetrics.prototype.actualBoundingBoxDescent;
/** @type {!number} */ TextMetrics.prototype.actualBoundingBoxLeft;
/** @type {!number} */ TextMetrics.prototype.actualBoundingBoxRight;
/** @type {!number} */ TextMetrics.prototype.alphabeticBaseline;
/** @type {!number} */ TextMetrics.prototype.emHeightAscent;
/** @type {!number} */ TextMetrics.prototype.emHeightDescent;
/** @type {!number} */ TextMetrics.prototype.fontBoundingBoxAscent;
/** @type {!number} */ TextMetrics.prototype.fontBoundingBoxDescent;
/** @type {!number} */ TextMetrics.prototype.hangingBaseline;
/** @type {!number} */ TextMetrics.prototype.ideographicBaseline;
/** @type {!number} */ TextMetrics.prototype.width;
/**
 * @constructor
 * @private
 * @extends {SVGGeometryElement}
 * @nosideeffects
 */
function SVGPolygonElement() {}
/** @type {!SVGPointList} */ SVGPolygonElement.prototype.animatedPoints;
/** @type {!SVGPointList} */ SVGPolygonElement.prototype.points;
/**
 * @constructor
 * @private
 * @extends {ShadowRoot}
 * @nosideeffects
 */
function SVGUseElementShadowRoot() {}
/**
 * @constructor
 * @private
 * @extends {XRPose}
 * @nosideeffects
 */
function XRViewerPose() {}
/** @type {!Array<!XRView>} */ XRViewerPose.prototype.views;
/**
 * @constructor
 * @private
 * @extends {PerformanceResourceTiming}
 * @nosideeffects
 */
function PerformanceNavigationTiming() {}
/** @type {!DOMHighResTimeStamp} */ PerformanceNavigationTiming.prototype.domComplete;
/** @type {!DOMHighResTimeStamp} */ PerformanceNavigationTiming.prototype.domContentLoadedEventEnd;
/** @type {!DOMHighResTimeStamp} */ PerformanceNavigationTiming.prototype.domContentLoadedEventStart;
/** @type {!DOMHighResTimeStamp} */ PerformanceNavigationTiming.prototype.domInteractive;
/** @type {!DOMHighResTimeStamp} */ PerformanceNavigationTiming.prototype.loadEventEnd;
/** @type {!DOMHighResTimeStamp} */ PerformanceNavigationTiming.prototype.loadEventStart;
/** @type {!number} */ PerformanceNavigationTiming.prototype.redirectCount;
/** @type {!string} */ PerformanceNavigationTiming.prototype.type;
/** @type {!DOMHighResTimeStamp} */ PerformanceNavigationTiming.prototype.unloadEventEnd;
/** @type {!DOMHighResTimeStamp} */ PerformanceNavigationTiming.prototype.unloadEventStart;
/**
 * @return {!Object}
 * @override
 */
PerformanceNavigationTiming.prototype.toJSON = function() {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function XRRenderState() {}
/** @type {?XRWebGLLayer} */ XRRenderState.prototype.baseLayer;
/** @type {!number} */ XRRenderState.prototype.depthFar;
/** @type {!number} */ XRRenderState.prototype.depthNear;
/** @type {?number} */ XRRenderState.prototype.inlineVerticalFieldOfView;
/**
 * @constructor
 * @private
 * @extends {HTMLElement}
 * @nosideeffects
 */
function HTMLFrameElement() {}
/** @type {?Document} */ HTMLFrameElement.prototype.contentDocument;
/** @type {?WindowProxy} */ HTMLFrameElement.prototype.contentWindow;
/** @type {!string} */ HTMLFrameElement.prototype.frameBorder;
/** @type {!string} */ HTMLFrameElement.prototype.longDesc;
/** @type {!string} */ HTMLFrameElement.prototype.marginHeight;
/** @type {!string} */ HTMLFrameElement.prototype.marginWidth;
/** @type {!string} */ HTMLFrameElement.prototype.name;
/** @type {!boolean} */ HTMLFrameElement.prototype.noResize;
/** @type {!string} */ HTMLFrameElement.prototype.scrolling;
/** @type {!string} */ HTMLFrameElement.prototype.src;
/**
 * @constructor
 * @extends {EventTarget}
 * @param {!string} url
 * @param {(!string|!Array<!string>)=} protocols
 */
function WebSocket(url,protocols) {}
/** @const {!number} */ WebSocket.CLOSED;
/** @const {!number} */ WebSocket.prototype.CLOSED;
/** @const {!number} */ WebSocket.CLOSING;
/** @const {!number} */ WebSocket.prototype.CLOSING;
/** @const {!number} */ WebSocket.CONNECTING;
/** @const {!number} */ WebSocket.prototype.CONNECTING;
/** @const {!number} */ WebSocket.OPEN;
/** @const {!number} */ WebSocket.prototype.OPEN;
/** @type {!number} */ WebSocket.prototype.bufferedAmount;
/** @type {!string} */ WebSocket.prototype.extensions;
/** @type {!string} */ WebSocket.prototype.protocol;
/** @type {!number} */ WebSocket.prototype.readyState;
/** @type {!string} */ WebSocket.prototype.url;
/** @type {!string} */ WebSocket.prototype.binaryType;
/** @type {?CloseEventHandler} */ WebSocket.prototype.onclose;
/** @type {?EventHandler} */ WebSocket.prototype.onerror;
/** @type {?MessageEventHandler} */ WebSocket.prototype.onmessage;
/** @type {?EventHandler} */ WebSocket.prototype.onopen;
/**
 * @param {(!string|!Blob|!ArrayBuffer|!ArrayBufferView)} arg0
 * @return {undefined}
 */
WebSocket.prototype.send = function(arg0) {}
/**
 * @param {!number=} code
 * @param {!string=} reason
 * @return {undefined}
 */
WebSocket.prototype.close = function(code,reason) {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function GPURenderPassEncoder() {}
/** @type {?string} */ GPURenderPassEncoder.prototype.label;
/**
 * @param {!Array<!GPURenderBundle>} bundles
 * @return {undefined}
 */
GPURenderPassEncoder.prototype.executeBundles = function(bundles) {}
/**
 * @param {!GPURenderPipeline} pipeline
 * @return {undefined}
 */
GPURenderPassEncoder.prototype.setPipeline = function(pipeline) {}
/**
 * @param {!GPUSize32} queryIndex
 * @return {undefined}
 */
GPURenderPassEncoder.prototype.beginOcclusionQuery = function(queryIndex) {}
/**
 * @param {!GPUColor} color
 * @return {undefined}
 */
GPURenderPassEncoder.prototype.setBlendConstant = function(color) {}
/**
 * @param {!GPUBuffer} buffer
 * @param {!string} indexFormat
 * @param {!GPUSize64=} offset
 * @param {!GPUSize64=} size
 * @return {undefined}
 */
GPURenderPassEncoder.prototype.setIndexBuffer = function(buffer,indexFormat,offset,size) {}
/**
 * @param {!GPUIntegerCoordinate} x
 * @param {!GPUIntegerCoordinate} y
 * @param {!GPUIntegerCoordinate} width
 * @param {!GPUIntegerCoordinate} height
 * @return {undefined}
 */
GPURenderPassEncoder.prototype.setScissorRect = function(x,y,width,height) {}
/**
 * @return {undefined}
 */
GPURenderPassEncoder.prototype.endOcclusionQuery = function() {}
/**
 * @param {!string} groupLabel
 * @return {undefined}
 */
GPURenderPassEncoder.prototype.pushDebugGroup = function(groupLabel) {}
/**
 * @return {undefined}
 */
GPURenderPassEncoder.prototype.popDebugGroup = function() {}
/**
 * @param {!GPUSize32} vertexCount
 * @param {!GPUSize32=} instanceCount
 * @param {!GPUSize32=} firstVertex
 * @param {!GPUSize32=} firstInstance
 * @return {undefined}
 */
GPURenderPassEncoder.prototype.draw = function(vertexCount,instanceCount,firstVertex,firstInstance) {}
/**
 * @param {!number} x
 * @param {!number} y
 * @param {!number} width
 * @param {!number} height
 * @param {!number} minDepth
 * @param {!number} maxDepth
 * @return {undefined}
 */
GPURenderPassEncoder.prototype.setViewport = function(x,y,width,height,minDepth,maxDepth) {}
/**
 * @param {!GPUStencilValue} reference
 * @return {undefined}
 */
GPURenderPassEncoder.prototype.setStencilReference = function(reference) {}
/**
 * @param {!GPUQuerySet} querySet
 * @param {!GPUSize32} queryIndex
 * @return {undefined}
 */
GPURenderPassEncoder.prototype.writeTimestamp = function(querySet,queryIndex) {}
/**
 * @return {undefined}
 */
GPURenderPassEncoder.prototype.endPipelineStatisticsQuery = function() {}
/**
 * @param {!GPUBuffer} indirectBuffer
 * @param {!GPUSize64} indirectOffset
 * @return {undefined}
 */
GPURenderPassEncoder.prototype.drawIndirect = function(indirectBuffer,indirectOffset) {}
/**
 * @param {!GPUIndex32} slot
 * @param {!GPUBuffer} buffer
 * @param {!GPUSize64=} offset
 * @param {!GPUSize64=} size
 * @return {undefined}
 */
GPURenderPassEncoder.prototype.setVertexBuffer = function(slot,buffer,offset,size) {}
/**
 * @param {!GPUQuerySet} querySet
 * @param {!GPUSize32} queryIndex
 * @return {undefined}
 */
GPURenderPassEncoder.prototype.beginPipelineStatisticsQuery = function(querySet,queryIndex) {}
/**
 * @param {!GPUBuffer} indirectBuffer
 * @param {!GPUSize64} indirectOffset
 * @return {undefined}
 */
GPURenderPassEncoder.prototype.drawIndexedIndirect = function(indirectBuffer,indirectOffset) {}
/**
 * @param {!GPUSize32} indexCount
 * @param {!GPUSize32=} instanceCount
 * @param {!GPUSize32=} firstIndex
 * @param {!GPUSignedOffset32=} baseVertex
 * @param {!GPUSize32=} firstInstance
 * @return {undefined}
 */
GPURenderPassEncoder.prototype.drawIndexed = function(indexCount,instanceCount,firstIndex,baseVertex,firstInstance) {}
/**
 * @return {undefined}
 */
GPURenderPassEncoder.prototype.endPass = function() {}
/**
 * @param {!string} markerLabel
 * @return {undefined}
 */
GPURenderPassEncoder.prototype.insertDebugMarker = function(markerLabel) {}
/**
 * @param {!GPUIndex32} arg0
 * @param {!GPUBindGroup} arg1
 * @param {(!Array<!GPUBufferDynamicOffset>|!Uint32Array)=} arg2
 * @param {!GPUSize64=} arg3
 * @param {!GPUSize32=} arg4
 * @return {undefined}
 */
GPURenderPassEncoder.prototype.setBindGroup = function(arg0,arg1,arg2,arg3,arg4) {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function SVGAnimatedTransformList() {}
/** @type {!SVGTransformList} */ SVGAnimatedTransformList.prototype.animVal;
/** @type {!SVGTransformList} */ SVGAnimatedTransformList.prototype.baseVal;
/**
 * @constructor
 * @private
 * @extends {HTMLElement}
 * @nosideeffects
 */
function HTMLAnchorElement() {}
/** @type {!DOMTokenList} */ HTMLAnchorElement.prototype.relList;
/** @type {!string} */ HTMLAnchorElement.prototype.download;
/** @type {!string} */ HTMLAnchorElement.prototype.hreflang;
/** @type {!string} */ HTMLAnchorElement.prototype.ping;
/** @type {!string} */ HTMLAnchorElement.prototype.referrerPolicy;
/** @type {!string} */ HTMLAnchorElement.prototype.rel;
/** @type {!string} */ HTMLAnchorElement.prototype.target;
/** @type {!string} */ HTMLAnchorElement.prototype.text;
/** @type {!string} */ HTMLAnchorElement.prototype.type;
/** @type {!string} */ HTMLAnchorElement.prototype.charset;
/** @type {!string} */ HTMLAnchorElement.prototype.coords;
/** @type {!string} */ HTMLAnchorElement.prototype.name;
/** @type {!string} */ HTMLAnchorElement.prototype.rev;
/** @type {!string} */ HTMLAnchorElement.prototype.shape;
/** @type {!string} */ HTMLAnchorElement.prototype.origin;
/** @type {!string} */ HTMLAnchorElement.prototype.hash;
/** @type {!string} */ HTMLAnchorElement.prototype.host;
/** @type {!string} */ HTMLAnchorElement.prototype.hostname;
/** @type {!string} */ HTMLAnchorElement.prototype.password;
/** @type {!string} */ HTMLAnchorElement.prototype.pathname;
/** @type {!string} */ HTMLAnchorElement.prototype.port;
/** @type {!string} */ HTMLAnchorElement.prototype.protocol;
/** @type {!string} */ HTMLAnchorElement.prototype.search;
/** @type {!string} */ HTMLAnchorElement.prototype.username;
/** @type {!string} */ HTMLAnchorElement.prototype.href;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function CanvasGradient() {}
/**
 * @param {!number} offset
 * @param {!string} color
 * @return {undefined}
 */
CanvasGradient.prototype.addColorStop = function(offset,color) {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function OVR_multiview2() {}
/** @const {!GLenum} */ OVR_multiview2.prototype.FRAMEBUFFER_ATTACHMENT_TEXTURE_BASE_VIEW_INDEX_OVR;
/** @const {!GLenum} */ OVR_multiview2.prototype.FRAMEBUFFER_ATTACHMENT_TEXTURE_NUM_VIEWS_OVR;
/** @const {!GLenum} */ OVR_multiview2.prototype.FRAMEBUFFER_INCOMPLETE_VIEW_TARGETS_OVR;
/** @const {!GLenum} */ OVR_multiview2.prototype.MAX_VIEWS_OVR;
/**
 * @param {!GLenum} target
 * @param {!GLenum} attachment
 * @param {?WebGLTexture} texture
 * @param {!GLint} level
 * @param {!GLint} baseViewIndex
 * @param {!GLsizei} numViews
 * @return {undefined}
 */
OVR_multiview2.prototype.framebufferTextureMultiviewOVR = function(target,attachment,texture,level,baseViewIndex,numViews) {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function ReportBody() {}
/**
 * @return {!Object}
 * @override
 */
ReportBody.prototype.toJSON = function() {}
/**
 * @constructor
 * @private
 * @extends {SVGGradientElement}
 * @nosideeffects
 */
function SVGLinearGradientElement() {}
/** @type {!SVGAnimatedLength} */ SVGLinearGradientElement.prototype.x1;
/** @type {!SVGAnimatedLength} */ SVGLinearGradientElement.prototype.x2;
/** @type {!SVGAnimatedLength} */ SVGLinearGradientElement.prototype.y1;
/** @type {!SVGAnimatedLength} */ SVGLinearGradientElement.prototype.y2;
/**
 * @constructor
 * @extends {Event}
 * @param {!string} type
 * @param {!RTCPeerConnectionIceErrorEventInit} eventInitDict
 */
function RTCPeerConnectionIceErrorEvent(type,eventInitDict) {}
/** @type {?string} */ RTCPeerConnectionIceErrorEvent.prototype.address;
/** @type {!number} */ RTCPeerConnectionIceErrorEvent.prototype.errorCode;
/** @type {!string} */ RTCPeerConnectionIceErrorEvent.prototype.errorText;
/** @type {?number} */ RTCPeerConnectionIceErrorEvent.prototype.port;
/** @type {!string} */ RTCPeerConnectionIceErrorEvent.prototype.url;
/**
 * @constructor
 * @extends {Event}
 * @param {!CSSOMString} type
 * @param {!AnimationEventInit=} animationEventInitDict
 */
function AnimationEvent(type,animationEventInitDict) {}
/** @type {!CSSOMString} */ AnimationEvent.prototype.animationName;
/** @type {!number} */ AnimationEvent.prototype.elapsedTime;
/** @type {!CSSOMString} */ AnimationEvent.prototype.pseudoElement;
/**
 * @constructor
 * @private
 * @extends {SVGElement}
 * @nosideeffects
 */
function SVGFEComponentTransferElement() {}
/** @type {!SVGAnimatedString} */ SVGFEComponentTransferElement.prototype.in1;
/** @type {!SVGAnimatedLength} */ SVGFEComponentTransferElement.prototype.height;
/** @type {!SVGAnimatedString} */ SVGFEComponentTransferElement.prototype.result;
/** @type {!SVGAnimatedLength} */ SVGFEComponentTransferElement.prototype.width;
/** @type {!SVGAnimatedLength} */ SVGFEComponentTransferElement.prototype.x;
/** @type {!SVGAnimatedLength} */ SVGFEComponentTransferElement.prototype.y;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function GPURenderBundleEncoder() {}
/** @type {?string} */ GPURenderBundleEncoder.prototype.label;
/**
 * @param {!GPURenderPipeline} pipeline
 * @return {undefined}
 */
GPURenderBundleEncoder.prototype.setPipeline = function(pipeline) {}
/**
 * @param {!GPUBuffer} buffer
 * @param {!string} indexFormat
 * @param {!GPUSize64=} offset
 * @param {!GPUSize64=} size
 * @return {undefined}
 */
GPURenderBundleEncoder.prototype.setIndexBuffer = function(buffer,indexFormat,offset,size) {}
/**
 * @param {!GPUBuffer} indirectBuffer
 * @param {!GPUSize64} indirectOffset
 * @return {undefined}
 */
GPURenderBundleEncoder.prototype.drawIndirect = function(indirectBuffer,indirectOffset) {}
/**
 * @param {!GPUIndex32} slot
 * @param {!GPUBuffer} buffer
 * @param {!GPUSize64=} offset
 * @param {!GPUSize64=} size
 * @return {undefined}
 */
GPURenderBundleEncoder.prototype.setVertexBuffer = function(slot,buffer,offset,size) {}
/**
 * @param {!string} groupLabel
 * @return {undefined}
 */
GPURenderBundleEncoder.prototype.pushDebugGroup = function(groupLabel) {}
/**
 * @return {undefined}
 */
GPURenderBundleEncoder.prototype.popDebugGroup = function() {}
/**
 * @param {!GPURenderBundleDescriptor=} descriptor
 * @return {!GPURenderBundle}
 */
GPURenderBundleEncoder.prototype.finish = function(descriptor) {}
/**
 * @param {!GPUBuffer} indirectBuffer
 * @param {!GPUSize64} indirectOffset
 * @return {undefined}
 */
GPURenderBundleEncoder.prototype.drawIndexedIndirect = function(indirectBuffer,indirectOffset) {}
/**
 * @param {!GPUSize32} vertexCount
 * @param {!GPUSize32=} instanceCount
 * @param {!GPUSize32=} firstVertex
 * @param {!GPUSize32=} firstInstance
 * @return {undefined}
 */
GPURenderBundleEncoder.prototype.draw = function(vertexCount,instanceCount,firstVertex,firstInstance) {}
/**
 * @param {!GPUSize32} indexCount
 * @param {!GPUSize32=} instanceCount
 * @param {!GPUSize32=} firstIndex
 * @param {!GPUSignedOffset32=} baseVertex
 * @param {!GPUSize32=} firstInstance
 * @return {undefined}
 */
GPURenderBundleEncoder.prototype.drawIndexed = function(indexCount,instanceCount,firstIndex,baseVertex,firstInstance) {}
/**
 * @param {!string} markerLabel
 * @return {undefined}
 */
GPURenderBundleEncoder.prototype.insertDebugMarker = function(markerLabel) {}
/**
 * @param {!GPUIndex32} arg0
 * @param {!GPUBindGroup} arg1
 * @param {(!Array<!GPUBufferDynamicOffset>|!Uint32Array)=} arg2
 * @param {!GPUSize64=} arg3
 * @param {!GPUSize32=} arg4
 * @return {undefined}
 */
GPURenderBundleEncoder.prototype.setBindGroup = function(arg0,arg1,arg2,arg3,arg4) {}
/**
 * @constructor
 * @extends {AudioNode}
 * @param {!BaseAudioContext} context
 * @param {!WaveShaperOptions=} options
 */
function WaveShaperNode(context,options) {}
/** @type {?Float32Array} */ WaveShaperNode.prototype.curve;
/** @type {!string} */ WaveShaperNode.prototype.oversample;
/**
 * @constructor
 * @private
 * @extends {SVGElement}
 * @nosideeffects
 */
function SVGGradientElement() {}
/** @const {!number} */ SVGGradientElement.SVG_SPREADMETHOD_PAD;
/** @const {!number} */ SVGGradientElement.prototype.SVG_SPREADMETHOD_PAD;
/** @const {!number} */ SVGGradientElement.SVG_SPREADMETHOD_REFLECT;
/** @const {!number} */ SVGGradientElement.prototype.SVG_SPREADMETHOD_REFLECT;
/** @const {!number} */ SVGGradientElement.SVG_SPREADMETHOD_REPEAT;
/** @const {!number} */ SVGGradientElement.prototype.SVG_SPREADMETHOD_REPEAT;
/** @const {!number} */ SVGGradientElement.SVG_SPREADMETHOD_UNKNOWN;
/** @const {!number} */ SVGGradientElement.prototype.SVG_SPREADMETHOD_UNKNOWN;
/** @type {!SVGAnimatedTransformList} */ SVGGradientElement.prototype.gradientTransform;
/** @type {!SVGAnimatedEnumeration} */ SVGGradientElement.prototype.gradientUnits;
/** @type {!SVGAnimatedEnumeration} */ SVGGradientElement.prototype.spreadMethod;
/** @type {!SVGAnimatedString} */ SVGGradientElement.prototype.href;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function OES_texture_half_float() {}
/** @const {!GLenum} */ OES_texture_half_float.prototype.HALF_FLOAT_OES;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function GPUBindGroupLayout() {}
/** @type {?string} */ GPUBindGroupLayout.prototype.label;
/**
 * @constructor
 * @private
 * @extends {SVGGraphicsElement}
 * @nosideeffects
 */
function SVGTextContentElement() {}
/** @const {!number} */ SVGTextContentElement.LENGTHADJUST_SPACING;
/** @const {!number} */ SVGTextContentElement.prototype.LENGTHADJUST_SPACING;
/** @const {!number} */ SVGTextContentElement.LENGTHADJUST_SPACINGANDGLYPHS;
/** @const {!number} */ SVGTextContentElement.prototype.LENGTHADJUST_SPACINGANDGLYPHS;
/** @const {!number} */ SVGTextContentElement.LENGTHADJUST_UNKNOWN;
/** @const {!number} */ SVGTextContentElement.prototype.LENGTHADJUST_UNKNOWN;
/** @type {!SVGAnimatedEnumeration} */ SVGTextContentElement.prototype.lengthAdjust;
/** @type {!SVGAnimatedLength} */ SVGTextContentElement.prototype.textLength;
/**
 * @param {!number} charnum
 * @return {!DOMPoint}
 */
SVGTextContentElement.prototype.getEndPositionOfChar = function(charnum) {}
/**
 * @param {!number} charnum
 * @return {!DOMPoint}
 */
SVGTextContentElement.prototype.getStartPositionOfChar = function(charnum) {}
/**
 * @param {!number} charnum
 * @return {!number}
 */
SVGTextContentElement.prototype.getRotationOfChar = function(charnum) {}
/**
 * @param {!DOMPointInit=} point
 * @return {!number}
 */
SVGTextContentElement.prototype.getCharNumAtPosition = function(point) {}
/**
 * @param {!number} charnum
 * @param {!number} nchars
 * @return {undefined}
 */
SVGTextContentElement.prototype.selectSubString = function(charnum,nchars) {}
/**
 * @param {!number} charnum
 * @return {!DOMRect}
 */
SVGTextContentElement.prototype.getExtentOfChar = function(charnum) {}
/**
 * @return {!number}
 */
SVGTextContentElement.prototype.getComputedTextLength = function() {}
/**
 * @param {!number} charnum
 * @param {!number} nchars
 * @return {!number}
 */
SVGTextContentElement.prototype.getSubStringLength = function(charnum,nchars) {}
/**
 * @return {!number}
 */
SVGTextContentElement.prototype.getNumberOfChars = function() {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function SubtleCrypto() {}
/**
 * @param {!AlgorithmIdentifier} algorithm
 * @param {!boolean} extractable
 * @param {!Array<!string>} keyUsages
 * @return {!Promise<*>}
 */
SubtleCrypto.prototype.generateKey = function(algorithm,extractable,keyUsages) {}
/**
 * @param {!AlgorithmIdentifier} algorithm
 * @param {!CryptoKey} baseKey
 * @param {!number} length
 * @return {!Promise<!ArrayBuffer>}
 */
SubtleCrypto.prototype.deriveBits = function(algorithm,baseKey,length) {}
/**
 * @param {!string} format
 * @param {!CryptoKey} key
 * @return {!Promise<*>}
 */
SubtleCrypto.prototype.exportKey = function(format,key) {}
/**
 * @param {!AlgorithmIdentifier} algorithm
 * @param {!CryptoKey} key
 * @param {!BufferSource} data
 * @return {!Promise<*>}
 */
SubtleCrypto.prototype.encrypt = function(algorithm,key,data) {}
/**
 * @param {!AlgorithmIdentifier} algorithm
 * @param {!CryptoKey} key
 * @param {!BufferSource} data
 * @return {!Promise<*>}
 */
SubtleCrypto.prototype.sign = function(algorithm,key,data) {}
/**
 * @param {!AlgorithmIdentifier} algorithm
 * @param {!BufferSource} data
 * @return {!Promise<*>}
 */
SubtleCrypto.prototype.digest = function(algorithm,data) {}
/**
 * @param {!AlgorithmIdentifier} algorithm
 * @param {!CryptoKey} key
 * @param {!BufferSource} signature
 * @param {!BufferSource} data
 * @return {!Promise<*>}
 */
SubtleCrypto.prototype.verify = function(algorithm,key,signature,data) {}
/**
 * @param {!string} format
 * @param {(!BufferSource|!JsonWebKey)} keyData
 * @param {!AlgorithmIdentifier} algorithm
 * @param {!boolean} extractable
 * @param {!Array<!string>} keyUsages
 * @return {!Promise<!CryptoKey>}
 */
SubtleCrypto.prototype.importKey = function(format,keyData,algorithm,extractable,keyUsages) {}
/**
 * @param {!AlgorithmIdentifier} algorithm
 * @param {!CryptoKey} baseKey
 * @param {!AlgorithmIdentifier} derivedKeyType
 * @param {!boolean} extractable
 * @param {!Array<!string>} keyUsages
 * @return {!Promise<*>}
 */
SubtleCrypto.prototype.deriveKey = function(algorithm,baseKey,derivedKeyType,extractable,keyUsages) {}
/**
 * @param {!string} format
 * @param {!BufferSource} wrappedKey
 * @param {!CryptoKey} unwrappingKey
 * @param {!AlgorithmIdentifier} unwrapAlgorithm
 * @param {!AlgorithmIdentifier} unwrappedKeyAlgorithm
 * @param {!boolean} extractable
 * @param {!Array<!string>} keyUsages
 * @return {!Promise<!CryptoKey>}
 */
SubtleCrypto.prototype.unwrapKey = function(format,wrappedKey,unwrappingKey,unwrapAlgorithm,unwrappedKeyAlgorithm,extractable,keyUsages) {}
/**
 * @param {!AlgorithmIdentifier} algorithm
 * @param {!CryptoKey} key
 * @param {!BufferSource} data
 * @return {!Promise<*>}
 */
SubtleCrypto.prototype.decrypt = function(algorithm,key,data) {}
/**
 * @param {!string} format
 * @param {!CryptoKey} key
 * @param {!CryptoKey} wrappingKey
 * @param {!AlgorithmIdentifier} wrapAlgorithm
 * @return {!Promise<*>}
 */
SubtleCrypto.prototype.wrapKey = function(format,key,wrappingKey,wrapAlgorithm) {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function WebGLRenderingContext() {}
/** @const {!GLenum} */ WebGLRenderingContext.ACTIVE_ATTRIBUTES;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.ACTIVE_ATTRIBUTES;
/** @const {!GLenum} */ WebGLRenderingContext.ACTIVE_TEXTURE;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.ACTIVE_TEXTURE;
/** @const {!GLenum} */ WebGLRenderingContext.ACTIVE_UNIFORMS;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.ACTIVE_UNIFORMS;
/** @const {!GLenum} */ WebGLRenderingContext.ALIASED_LINE_WIDTH_RANGE;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.ALIASED_LINE_WIDTH_RANGE;
/** @const {!GLenum} */ WebGLRenderingContext.ALIASED_POINT_SIZE_RANGE;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.ALIASED_POINT_SIZE_RANGE;
/** @const {!GLenum} */ WebGLRenderingContext.ALPHA;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.ALPHA;
/** @const {!GLenum} */ WebGLRenderingContext.ALPHA_BITS;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.ALPHA_BITS;
/** @const {!GLenum} */ WebGLRenderingContext.ALWAYS;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.ALWAYS;
/** @const {!GLenum} */ WebGLRenderingContext.ARRAY_BUFFER;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.ARRAY_BUFFER;
/** @const {!GLenum} */ WebGLRenderingContext.ARRAY_BUFFER_BINDING;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.ARRAY_BUFFER_BINDING;
/** @const {!GLenum} */ WebGLRenderingContext.ATTACHED_SHADERS;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.ATTACHED_SHADERS;
/** @const {!GLenum} */ WebGLRenderingContext.BACK;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.BACK;
/** @const {!GLenum} */ WebGLRenderingContext.BLEND;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.BLEND;
/** @const {!GLenum} */ WebGLRenderingContext.BLEND_COLOR;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.BLEND_COLOR;
/** @const {!GLenum} */ WebGLRenderingContext.BLEND_DST_ALPHA;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.BLEND_DST_ALPHA;
/** @const {!GLenum} */ WebGLRenderingContext.BLEND_DST_RGB;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.BLEND_DST_RGB;
/** @const {!GLenum} */ WebGLRenderingContext.BLEND_EQUATION;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.BLEND_EQUATION;
/** @const {!GLenum} */ WebGLRenderingContext.BLEND_EQUATION_ALPHA;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.BLEND_EQUATION_ALPHA;
/** @const {!GLenum} */ WebGLRenderingContext.BLEND_EQUATION_RGB;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.BLEND_EQUATION_RGB;
/** @const {!GLenum} */ WebGLRenderingContext.BLEND_SRC_ALPHA;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.BLEND_SRC_ALPHA;
/** @const {!GLenum} */ WebGLRenderingContext.BLEND_SRC_RGB;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.BLEND_SRC_RGB;
/** @const {!GLenum} */ WebGLRenderingContext.BLUE_BITS;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.BLUE_BITS;
/** @const {!GLenum} */ WebGLRenderingContext.BOOL;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.BOOL;
/** @const {!GLenum} */ WebGLRenderingContext.BOOL_VEC2;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.BOOL_VEC2;
/** @const {!GLenum} */ WebGLRenderingContext.BOOL_VEC3;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.BOOL_VEC3;
/** @const {!GLenum} */ WebGLRenderingContext.BOOL_VEC4;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.BOOL_VEC4;
/** @const {!GLenum} */ WebGLRenderingContext.BROWSER_DEFAULT_WEBGL;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.BROWSER_DEFAULT_WEBGL;
/** @const {!GLenum} */ WebGLRenderingContext.BUFFER_SIZE;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.BUFFER_SIZE;
/** @const {!GLenum} */ WebGLRenderingContext.BUFFER_USAGE;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.BUFFER_USAGE;
/** @const {!GLenum} */ WebGLRenderingContext.BYTE;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.BYTE;
/** @const {!GLenum} */ WebGLRenderingContext.CCW;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.CCW;
/** @const {!GLenum} */ WebGLRenderingContext.CLAMP_TO_EDGE;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.CLAMP_TO_EDGE;
/** @const {!GLenum} */ WebGLRenderingContext.COLOR_ATTACHMENT0;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.COLOR_ATTACHMENT0;
/** @const {!GLenum} */ WebGLRenderingContext.COLOR_BUFFER_BIT;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.COLOR_BUFFER_BIT;
/** @const {!GLenum} */ WebGLRenderingContext.COLOR_CLEAR_VALUE;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.COLOR_CLEAR_VALUE;
/** @const {!GLenum} */ WebGLRenderingContext.COLOR_WRITEMASK;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.COLOR_WRITEMASK;
/** @const {!GLenum} */ WebGLRenderingContext.COMPILE_STATUS;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.COMPILE_STATUS;
/** @const {!GLenum} */ WebGLRenderingContext.COMPRESSED_TEXTURE_FORMATS;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.COMPRESSED_TEXTURE_FORMATS;
/** @const {!GLenum} */ WebGLRenderingContext.CONSTANT_ALPHA;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.CONSTANT_ALPHA;
/** @const {!GLenum} */ WebGLRenderingContext.CONSTANT_COLOR;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.CONSTANT_COLOR;
/** @const {!GLenum} */ WebGLRenderingContext.CONTEXT_LOST_WEBGL;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.CONTEXT_LOST_WEBGL;
/** @const {!GLenum} */ WebGLRenderingContext.CULL_FACE;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.CULL_FACE;
/** @const {!GLenum} */ WebGLRenderingContext.CULL_FACE_MODE;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.CULL_FACE_MODE;
/** @const {!GLenum} */ WebGLRenderingContext.CURRENT_PROGRAM;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.CURRENT_PROGRAM;
/** @const {!GLenum} */ WebGLRenderingContext.CURRENT_VERTEX_ATTRIB;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.CURRENT_VERTEX_ATTRIB;
/** @const {!GLenum} */ WebGLRenderingContext.CW;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.CW;
/** @const {!GLenum} */ WebGLRenderingContext.DECR;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.DECR;
/** @const {!GLenum} */ WebGLRenderingContext.DECR_WRAP;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.DECR_WRAP;
/** @const {!GLenum} */ WebGLRenderingContext.DELETE_STATUS;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.DELETE_STATUS;
/** @const {!GLenum} */ WebGLRenderingContext.DEPTH_ATTACHMENT;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.DEPTH_ATTACHMENT;
/** @const {!GLenum} */ WebGLRenderingContext.DEPTH_BITS;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.DEPTH_BITS;
/** @const {!GLenum} */ WebGLRenderingContext.DEPTH_BUFFER_BIT;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.DEPTH_BUFFER_BIT;
/** @const {!GLenum} */ WebGLRenderingContext.DEPTH_CLEAR_VALUE;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.DEPTH_CLEAR_VALUE;
/** @const {!GLenum} */ WebGLRenderingContext.DEPTH_COMPONENT;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.DEPTH_COMPONENT;
/** @const {!GLenum} */ WebGLRenderingContext.DEPTH_COMPONENT16;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.DEPTH_COMPONENT16;
/** @const {!GLenum} */ WebGLRenderingContext.DEPTH_FUNC;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.DEPTH_FUNC;
/** @const {!GLenum} */ WebGLRenderingContext.DEPTH_RANGE;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.DEPTH_RANGE;
/** @const {!GLenum} */ WebGLRenderingContext.DEPTH_STENCIL;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.DEPTH_STENCIL;
/** @const {!GLenum} */ WebGLRenderingContext.DEPTH_STENCIL_ATTACHMENT;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.DEPTH_STENCIL_ATTACHMENT;
/** @const {!GLenum} */ WebGLRenderingContext.DEPTH_TEST;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.DEPTH_TEST;
/** @const {!GLenum} */ WebGLRenderingContext.DEPTH_WRITEMASK;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.DEPTH_WRITEMASK;
/** @const {!GLenum} */ WebGLRenderingContext.DITHER;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.DITHER;
/** @const {!GLenum} */ WebGLRenderingContext.DONT_CARE;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.DONT_CARE;
/** @const {!GLenum} */ WebGLRenderingContext.DST_ALPHA;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.DST_ALPHA;
/** @const {!GLenum} */ WebGLRenderingContext.DST_COLOR;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.DST_COLOR;
/** @const {!GLenum} */ WebGLRenderingContext.DYNAMIC_DRAW;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.DYNAMIC_DRAW;
/** @const {!GLenum} */ WebGLRenderingContext.ELEMENT_ARRAY_BUFFER;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.ELEMENT_ARRAY_BUFFER;
/** @const {!GLenum} */ WebGLRenderingContext.ELEMENT_ARRAY_BUFFER_BINDING;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.ELEMENT_ARRAY_BUFFER_BINDING;
/** @const {!GLenum} */ WebGLRenderingContext.EQUAL;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.EQUAL;
/** @const {!GLenum} */ WebGLRenderingContext.FASTEST;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.FASTEST;
/** @const {!GLenum} */ WebGLRenderingContext.FLOAT;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.FLOAT;
/** @const {!GLenum} */ WebGLRenderingContext.FLOAT_MAT2;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.FLOAT_MAT2;
/** @const {!GLenum} */ WebGLRenderingContext.FLOAT_MAT3;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.FLOAT_MAT3;
/** @const {!GLenum} */ WebGLRenderingContext.FLOAT_MAT4;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.FLOAT_MAT4;
/** @const {!GLenum} */ WebGLRenderingContext.FLOAT_VEC2;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.FLOAT_VEC2;
/** @const {!GLenum} */ WebGLRenderingContext.FLOAT_VEC3;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.FLOAT_VEC3;
/** @const {!GLenum} */ WebGLRenderingContext.FLOAT_VEC4;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.FLOAT_VEC4;
/** @const {!GLenum} */ WebGLRenderingContext.FRAGMENT_SHADER;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.FRAGMENT_SHADER;
/** @const {!GLenum} */ WebGLRenderingContext.FRAMEBUFFER;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.FRAMEBUFFER;
/** @const {!GLenum} */ WebGLRenderingContext.FRAMEBUFFER_ATTACHMENT_OBJECT_NAME;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.FRAMEBUFFER_ATTACHMENT_OBJECT_NAME;
/** @const {!GLenum} */ WebGLRenderingContext.FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE;
/** @const {!GLenum} */ WebGLRenderingContext.FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE;
/** @const {!GLenum} */ WebGLRenderingContext.FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL;
/** @const {!GLenum} */ WebGLRenderingContext.FRAMEBUFFER_BINDING;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.FRAMEBUFFER_BINDING;
/** @const {!GLenum} */ WebGLRenderingContext.FRAMEBUFFER_COMPLETE;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.FRAMEBUFFER_COMPLETE;
/** @const {!GLenum} */ WebGLRenderingContext.FRAMEBUFFER_INCOMPLETE_ATTACHMENT;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.FRAMEBUFFER_INCOMPLETE_ATTACHMENT;
/** @const {!GLenum} */ WebGLRenderingContext.FRAMEBUFFER_INCOMPLETE_DIMENSIONS;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.FRAMEBUFFER_INCOMPLETE_DIMENSIONS;
/** @const {!GLenum} */ WebGLRenderingContext.FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT;
/** @const {!GLenum} */ WebGLRenderingContext.FRAMEBUFFER_UNSUPPORTED;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.FRAMEBUFFER_UNSUPPORTED;
/** @const {!GLenum} */ WebGLRenderingContext.FRONT;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.FRONT;
/** @const {!GLenum} */ WebGLRenderingContext.FRONT_AND_BACK;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.FRONT_AND_BACK;
/** @const {!GLenum} */ WebGLRenderingContext.FRONT_FACE;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.FRONT_FACE;
/** @const {!GLenum} */ WebGLRenderingContext.FUNC_ADD;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.FUNC_ADD;
/** @const {!GLenum} */ WebGLRenderingContext.FUNC_REVERSE_SUBTRACT;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.FUNC_REVERSE_SUBTRACT;
/** @const {!GLenum} */ WebGLRenderingContext.FUNC_SUBTRACT;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.FUNC_SUBTRACT;
/** @const {!GLenum} */ WebGLRenderingContext.GENERATE_MIPMAP_HINT;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.GENERATE_MIPMAP_HINT;
/** @const {!GLenum} */ WebGLRenderingContext.GEQUAL;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.GEQUAL;
/** @const {!GLenum} */ WebGLRenderingContext.GREATER;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.GREATER;
/** @const {!GLenum} */ WebGLRenderingContext.GREEN_BITS;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.GREEN_BITS;
/** @const {!GLenum} */ WebGLRenderingContext.HIGH_FLOAT;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.HIGH_FLOAT;
/** @const {!GLenum} */ WebGLRenderingContext.HIGH_INT;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.HIGH_INT;
/** @const {!GLenum} */ WebGLRenderingContext.IMPLEMENTATION_COLOR_READ_FORMAT;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.IMPLEMENTATION_COLOR_READ_FORMAT;
/** @const {!GLenum} */ WebGLRenderingContext.IMPLEMENTATION_COLOR_READ_TYPE;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.IMPLEMENTATION_COLOR_READ_TYPE;
/** @const {!GLenum} */ WebGLRenderingContext.INCR;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.INCR;
/** @const {!GLenum} */ WebGLRenderingContext.INCR_WRAP;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.INCR_WRAP;
/** @const {!GLenum} */ WebGLRenderingContext.INT;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.INT;
/** @const {!GLenum} */ WebGLRenderingContext.INT_VEC2;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.INT_VEC2;
/** @const {!GLenum} */ WebGLRenderingContext.INT_VEC3;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.INT_VEC3;
/** @const {!GLenum} */ WebGLRenderingContext.INT_VEC4;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.INT_VEC4;
/** @const {!GLenum} */ WebGLRenderingContext.INVALID_ENUM;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.INVALID_ENUM;
/** @const {!GLenum} */ WebGLRenderingContext.INVALID_FRAMEBUFFER_OPERATION;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.INVALID_FRAMEBUFFER_OPERATION;
/** @const {!GLenum} */ WebGLRenderingContext.INVALID_OPERATION;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.INVALID_OPERATION;
/** @const {!GLenum} */ WebGLRenderingContext.INVALID_VALUE;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.INVALID_VALUE;
/** @const {!GLenum} */ WebGLRenderingContext.INVERT;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.INVERT;
/** @const {!GLenum} */ WebGLRenderingContext.KEEP;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.KEEP;
/** @const {!GLenum} */ WebGLRenderingContext.LEQUAL;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.LEQUAL;
/** @const {!GLenum} */ WebGLRenderingContext.LESS;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.LESS;
/** @const {!GLenum} */ WebGLRenderingContext.LINEAR;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.LINEAR;
/** @const {!GLenum} */ WebGLRenderingContext.LINEAR_MIPMAP_LINEAR;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.LINEAR_MIPMAP_LINEAR;
/** @const {!GLenum} */ WebGLRenderingContext.LINEAR_MIPMAP_NEAREST;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.LINEAR_MIPMAP_NEAREST;
/** @const {!GLenum} */ WebGLRenderingContext.LINES;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.LINES;
/** @const {!GLenum} */ WebGLRenderingContext.LINE_LOOP;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.LINE_LOOP;
/** @const {!GLenum} */ WebGLRenderingContext.LINE_STRIP;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.LINE_STRIP;
/** @const {!GLenum} */ WebGLRenderingContext.LINE_WIDTH;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.LINE_WIDTH;
/** @const {!GLenum} */ WebGLRenderingContext.LINK_STATUS;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.LINK_STATUS;
/** @const {!GLenum} */ WebGLRenderingContext.LOW_FLOAT;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.LOW_FLOAT;
/** @const {!GLenum} */ WebGLRenderingContext.LOW_INT;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.LOW_INT;
/** @const {!GLenum} */ WebGLRenderingContext.LUMINANCE;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.LUMINANCE;
/** @const {!GLenum} */ WebGLRenderingContext.LUMINANCE_ALPHA;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.LUMINANCE_ALPHA;
/** @const {!GLenum} */ WebGLRenderingContext.MAX_COMBINED_TEXTURE_IMAGE_UNITS;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.MAX_COMBINED_TEXTURE_IMAGE_UNITS;
/** @const {!GLenum} */ WebGLRenderingContext.MAX_CUBE_MAP_TEXTURE_SIZE;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.MAX_CUBE_MAP_TEXTURE_SIZE;
/** @const {!GLenum} */ WebGLRenderingContext.MAX_FRAGMENT_UNIFORM_VECTORS;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.MAX_FRAGMENT_UNIFORM_VECTORS;
/** @const {!GLenum} */ WebGLRenderingContext.MAX_RENDERBUFFER_SIZE;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.MAX_RENDERBUFFER_SIZE;
/** @const {!GLenum} */ WebGLRenderingContext.MAX_TEXTURE_IMAGE_UNITS;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.MAX_TEXTURE_IMAGE_UNITS;
/** @const {!GLenum} */ WebGLRenderingContext.MAX_TEXTURE_SIZE;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.MAX_TEXTURE_SIZE;
/** @const {!GLenum} */ WebGLRenderingContext.MAX_VARYING_VECTORS;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.MAX_VARYING_VECTORS;
/** @const {!GLenum} */ WebGLRenderingContext.MAX_VERTEX_ATTRIBS;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.MAX_VERTEX_ATTRIBS;
/** @const {!GLenum} */ WebGLRenderingContext.MAX_VERTEX_TEXTURE_IMAGE_UNITS;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.MAX_VERTEX_TEXTURE_IMAGE_UNITS;
/** @const {!GLenum} */ WebGLRenderingContext.MAX_VERTEX_UNIFORM_VECTORS;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.MAX_VERTEX_UNIFORM_VECTORS;
/** @const {!GLenum} */ WebGLRenderingContext.MAX_VIEWPORT_DIMS;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.MAX_VIEWPORT_DIMS;
/** @const {!GLenum} */ WebGLRenderingContext.MEDIUM_FLOAT;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.MEDIUM_FLOAT;
/** @const {!GLenum} */ WebGLRenderingContext.MEDIUM_INT;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.MEDIUM_INT;
/** @const {!GLenum} */ WebGLRenderingContext.MIRRORED_REPEAT;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.MIRRORED_REPEAT;
/** @const {!GLenum} */ WebGLRenderingContext.NEAREST;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.NEAREST;
/** @const {!GLenum} */ WebGLRenderingContext.NEAREST_MIPMAP_LINEAR;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.NEAREST_MIPMAP_LINEAR;
/** @const {!GLenum} */ WebGLRenderingContext.NEAREST_MIPMAP_NEAREST;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.NEAREST_MIPMAP_NEAREST;
/** @const {!GLenum} */ WebGLRenderingContext.NEVER;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.NEVER;
/** @const {!GLenum} */ WebGLRenderingContext.NICEST;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.NICEST;
/** @const {!GLenum} */ WebGLRenderingContext.NONE;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.NONE;
/** @const {!GLenum} */ WebGLRenderingContext.NOTEQUAL;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.NOTEQUAL;
/** @const {!GLenum} */ WebGLRenderingContext.NO_ERROR;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.NO_ERROR;
/** @const {!GLenum} */ WebGLRenderingContext.ONE;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.ONE;
/** @const {!GLenum} */ WebGLRenderingContext.ONE_MINUS_CONSTANT_ALPHA;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.ONE_MINUS_CONSTANT_ALPHA;
/** @const {!GLenum} */ WebGLRenderingContext.ONE_MINUS_CONSTANT_COLOR;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.ONE_MINUS_CONSTANT_COLOR;
/** @const {!GLenum} */ WebGLRenderingContext.ONE_MINUS_DST_ALPHA;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.ONE_MINUS_DST_ALPHA;
/** @const {!GLenum} */ WebGLRenderingContext.ONE_MINUS_DST_COLOR;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.ONE_MINUS_DST_COLOR;
/** @const {!GLenum} */ WebGLRenderingContext.ONE_MINUS_SRC_ALPHA;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.ONE_MINUS_SRC_ALPHA;
/** @const {!GLenum} */ WebGLRenderingContext.ONE_MINUS_SRC_COLOR;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.ONE_MINUS_SRC_COLOR;
/** @const {!GLenum} */ WebGLRenderingContext.OUT_OF_MEMORY;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.OUT_OF_MEMORY;
/** @const {!GLenum} */ WebGLRenderingContext.PACK_ALIGNMENT;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.PACK_ALIGNMENT;
/** @const {!GLenum} */ WebGLRenderingContext.POINTS;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.POINTS;
/** @const {!GLenum} */ WebGLRenderingContext.POLYGON_OFFSET_FACTOR;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.POLYGON_OFFSET_FACTOR;
/** @const {!GLenum} */ WebGLRenderingContext.POLYGON_OFFSET_FILL;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.POLYGON_OFFSET_FILL;
/** @const {!GLenum} */ WebGLRenderingContext.POLYGON_OFFSET_UNITS;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.POLYGON_OFFSET_UNITS;
/** @const {!GLenum} */ WebGLRenderingContext.RED_BITS;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.RED_BITS;
/** @const {!GLenum} */ WebGLRenderingContext.RENDERBUFFER;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.RENDERBUFFER;
/** @const {!GLenum} */ WebGLRenderingContext.RENDERBUFFER_ALPHA_SIZE;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.RENDERBUFFER_ALPHA_SIZE;
/** @const {!GLenum} */ WebGLRenderingContext.RENDERBUFFER_BINDING;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.RENDERBUFFER_BINDING;
/** @const {!GLenum} */ WebGLRenderingContext.RENDERBUFFER_BLUE_SIZE;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.RENDERBUFFER_BLUE_SIZE;
/** @const {!GLenum} */ WebGLRenderingContext.RENDERBUFFER_DEPTH_SIZE;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.RENDERBUFFER_DEPTH_SIZE;
/** @const {!GLenum} */ WebGLRenderingContext.RENDERBUFFER_GREEN_SIZE;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.RENDERBUFFER_GREEN_SIZE;
/** @const {!GLenum} */ WebGLRenderingContext.RENDERBUFFER_HEIGHT;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.RENDERBUFFER_HEIGHT;
/** @const {!GLenum} */ WebGLRenderingContext.RENDERBUFFER_INTERNAL_FORMAT;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.RENDERBUFFER_INTERNAL_FORMAT;
/** @const {!GLenum} */ WebGLRenderingContext.RENDERBUFFER_RED_SIZE;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.RENDERBUFFER_RED_SIZE;
/** @const {!GLenum} */ WebGLRenderingContext.RENDERBUFFER_STENCIL_SIZE;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.RENDERBUFFER_STENCIL_SIZE;
/** @const {!GLenum} */ WebGLRenderingContext.RENDERBUFFER_WIDTH;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.RENDERBUFFER_WIDTH;
/** @const {!GLenum} */ WebGLRenderingContext.RENDERER;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.RENDERER;
/** @const {!GLenum} */ WebGLRenderingContext.REPEAT;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.REPEAT;
/** @const {!GLenum} */ WebGLRenderingContext.REPLACE;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.REPLACE;
/** @const {!GLenum} */ WebGLRenderingContext.RGB;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.RGB;
/** @const {!GLenum} */ WebGLRenderingContext.RGB565;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.RGB565;
/** @const {!GLenum} */ WebGLRenderingContext.RGB5_A1;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.RGB5_A1;
/** @const {!GLenum} */ WebGLRenderingContext.RGBA;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.RGBA;
/** @const {!GLenum} */ WebGLRenderingContext.RGBA4;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.RGBA4;
/** @const {!GLenum} */ WebGLRenderingContext.SAMPLER_2D;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.SAMPLER_2D;
/** @const {!GLenum} */ WebGLRenderingContext.SAMPLER_CUBE;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.SAMPLER_CUBE;
/** @const {!GLenum} */ WebGLRenderingContext.SAMPLES;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.SAMPLES;
/** @const {!GLenum} */ WebGLRenderingContext.SAMPLE_ALPHA_TO_COVERAGE;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.SAMPLE_ALPHA_TO_COVERAGE;
/** @const {!GLenum} */ WebGLRenderingContext.SAMPLE_BUFFERS;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.SAMPLE_BUFFERS;
/** @const {!GLenum} */ WebGLRenderingContext.SAMPLE_COVERAGE;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.SAMPLE_COVERAGE;
/** @const {!GLenum} */ WebGLRenderingContext.SAMPLE_COVERAGE_INVERT;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.SAMPLE_COVERAGE_INVERT;
/** @const {!GLenum} */ WebGLRenderingContext.SAMPLE_COVERAGE_VALUE;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.SAMPLE_COVERAGE_VALUE;
/** @const {!GLenum} */ WebGLRenderingContext.SCISSOR_BOX;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.SCISSOR_BOX;
/** @const {!GLenum} */ WebGLRenderingContext.SCISSOR_TEST;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.SCISSOR_TEST;
/** @const {!GLenum} */ WebGLRenderingContext.SHADER_TYPE;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.SHADER_TYPE;
/** @const {!GLenum} */ WebGLRenderingContext.SHADING_LANGUAGE_VERSION;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.SHADING_LANGUAGE_VERSION;
/** @const {!GLenum} */ WebGLRenderingContext.SHORT;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.SHORT;
/** @const {!GLenum} */ WebGLRenderingContext.SRC_ALPHA;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.SRC_ALPHA;
/** @const {!GLenum} */ WebGLRenderingContext.SRC_ALPHA_SATURATE;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.SRC_ALPHA_SATURATE;
/** @const {!GLenum} */ WebGLRenderingContext.SRC_COLOR;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.SRC_COLOR;
/** @const {!GLenum} */ WebGLRenderingContext.STATIC_DRAW;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.STATIC_DRAW;
/** @const {!GLenum} */ WebGLRenderingContext.STENCIL_ATTACHMENT;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.STENCIL_ATTACHMENT;
/** @const {!GLenum} */ WebGLRenderingContext.STENCIL_BACK_FAIL;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.STENCIL_BACK_FAIL;
/** @const {!GLenum} */ WebGLRenderingContext.STENCIL_BACK_FUNC;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.STENCIL_BACK_FUNC;
/** @const {!GLenum} */ WebGLRenderingContext.STENCIL_BACK_PASS_DEPTH_FAIL;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.STENCIL_BACK_PASS_DEPTH_FAIL;
/** @const {!GLenum} */ WebGLRenderingContext.STENCIL_BACK_PASS_DEPTH_PASS;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.STENCIL_BACK_PASS_DEPTH_PASS;
/** @const {!GLenum} */ WebGLRenderingContext.STENCIL_BACK_REF;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.STENCIL_BACK_REF;
/** @const {!GLenum} */ WebGLRenderingContext.STENCIL_BACK_VALUE_MASK;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.STENCIL_BACK_VALUE_MASK;
/** @const {!GLenum} */ WebGLRenderingContext.STENCIL_BACK_WRITEMASK;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.STENCIL_BACK_WRITEMASK;
/** @const {!GLenum} */ WebGLRenderingContext.STENCIL_BITS;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.STENCIL_BITS;
/** @const {!GLenum} */ WebGLRenderingContext.STENCIL_BUFFER_BIT;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.STENCIL_BUFFER_BIT;
/** @const {!GLenum} */ WebGLRenderingContext.STENCIL_CLEAR_VALUE;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.STENCIL_CLEAR_VALUE;
/** @const {!GLenum} */ WebGLRenderingContext.STENCIL_FAIL;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.STENCIL_FAIL;
/** @const {!GLenum} */ WebGLRenderingContext.STENCIL_FUNC;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.STENCIL_FUNC;
/** @const {!GLenum} */ WebGLRenderingContext.STENCIL_INDEX8;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.STENCIL_INDEX8;
/** @const {!GLenum} */ WebGLRenderingContext.STENCIL_PASS_DEPTH_FAIL;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.STENCIL_PASS_DEPTH_FAIL;
/** @const {!GLenum} */ WebGLRenderingContext.STENCIL_PASS_DEPTH_PASS;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.STENCIL_PASS_DEPTH_PASS;
/** @const {!GLenum} */ WebGLRenderingContext.STENCIL_REF;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.STENCIL_REF;
/** @const {!GLenum} */ WebGLRenderingContext.STENCIL_TEST;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.STENCIL_TEST;
/** @const {!GLenum} */ WebGLRenderingContext.STENCIL_VALUE_MASK;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.STENCIL_VALUE_MASK;
/** @const {!GLenum} */ WebGLRenderingContext.STENCIL_WRITEMASK;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.STENCIL_WRITEMASK;
/** @const {!GLenum} */ WebGLRenderingContext.STREAM_DRAW;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.STREAM_DRAW;
/** @const {!GLenum} */ WebGLRenderingContext.SUBPIXEL_BITS;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.SUBPIXEL_BITS;
/** @const {!GLenum} */ WebGLRenderingContext.TEXTURE;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.TEXTURE;
/** @const {!GLenum} */ WebGLRenderingContext.TEXTURE0;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.TEXTURE0;
/** @const {!GLenum} */ WebGLRenderingContext.TEXTURE1;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.TEXTURE1;
/** @const {!GLenum} */ WebGLRenderingContext.TEXTURE10;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.TEXTURE10;
/** @const {!GLenum} */ WebGLRenderingContext.TEXTURE11;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.TEXTURE11;
/** @const {!GLenum} */ WebGLRenderingContext.TEXTURE12;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.TEXTURE12;
/** @const {!GLenum} */ WebGLRenderingContext.TEXTURE13;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.TEXTURE13;
/** @const {!GLenum} */ WebGLRenderingContext.TEXTURE14;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.TEXTURE14;
/** @const {!GLenum} */ WebGLRenderingContext.TEXTURE15;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.TEXTURE15;
/** @const {!GLenum} */ WebGLRenderingContext.TEXTURE16;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.TEXTURE16;
/** @const {!GLenum} */ WebGLRenderingContext.TEXTURE17;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.TEXTURE17;
/** @const {!GLenum} */ WebGLRenderingContext.TEXTURE18;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.TEXTURE18;
/** @const {!GLenum} */ WebGLRenderingContext.TEXTURE19;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.TEXTURE19;
/** @const {!GLenum} */ WebGLRenderingContext.TEXTURE2;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.TEXTURE2;
/** @const {!GLenum} */ WebGLRenderingContext.TEXTURE20;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.TEXTURE20;
/** @const {!GLenum} */ WebGLRenderingContext.TEXTURE21;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.TEXTURE21;
/** @const {!GLenum} */ WebGLRenderingContext.TEXTURE22;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.TEXTURE22;
/** @const {!GLenum} */ WebGLRenderingContext.TEXTURE23;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.TEXTURE23;
/** @const {!GLenum} */ WebGLRenderingContext.TEXTURE24;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.TEXTURE24;
/** @const {!GLenum} */ WebGLRenderingContext.TEXTURE25;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.TEXTURE25;
/** @const {!GLenum} */ WebGLRenderingContext.TEXTURE26;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.TEXTURE26;
/** @const {!GLenum} */ WebGLRenderingContext.TEXTURE27;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.TEXTURE27;
/** @const {!GLenum} */ WebGLRenderingContext.TEXTURE28;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.TEXTURE28;
/** @const {!GLenum} */ WebGLRenderingContext.TEXTURE29;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.TEXTURE29;
/** @const {!GLenum} */ WebGLRenderingContext.TEXTURE3;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.TEXTURE3;
/** @const {!GLenum} */ WebGLRenderingContext.TEXTURE30;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.TEXTURE30;
/** @const {!GLenum} */ WebGLRenderingContext.TEXTURE31;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.TEXTURE31;
/** @const {!GLenum} */ WebGLRenderingContext.TEXTURE4;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.TEXTURE4;
/** @const {!GLenum} */ WebGLRenderingContext.TEXTURE5;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.TEXTURE5;
/** @const {!GLenum} */ WebGLRenderingContext.TEXTURE6;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.TEXTURE6;
/** @const {!GLenum} */ WebGLRenderingContext.TEXTURE7;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.TEXTURE7;
/** @const {!GLenum} */ WebGLRenderingContext.TEXTURE8;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.TEXTURE8;
/** @const {!GLenum} */ WebGLRenderingContext.TEXTURE9;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.TEXTURE9;
/** @const {!GLenum} */ WebGLRenderingContext.TEXTURE_2D;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.TEXTURE_2D;
/** @const {!GLenum} */ WebGLRenderingContext.TEXTURE_BINDING_2D;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.TEXTURE_BINDING_2D;
/** @const {!GLenum} */ WebGLRenderingContext.TEXTURE_BINDING_CUBE_MAP;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.TEXTURE_BINDING_CUBE_MAP;
/** @const {!GLenum} */ WebGLRenderingContext.TEXTURE_CUBE_MAP;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.TEXTURE_CUBE_MAP;
/** @const {!GLenum} */ WebGLRenderingContext.TEXTURE_CUBE_MAP_NEGATIVE_X;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.TEXTURE_CUBE_MAP_NEGATIVE_X;
/** @const {!GLenum} */ WebGLRenderingContext.TEXTURE_CUBE_MAP_NEGATIVE_Y;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.TEXTURE_CUBE_MAP_NEGATIVE_Y;
/** @const {!GLenum} */ WebGLRenderingContext.TEXTURE_CUBE_MAP_NEGATIVE_Z;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.TEXTURE_CUBE_MAP_NEGATIVE_Z;
/** @const {!GLenum} */ WebGLRenderingContext.TEXTURE_CUBE_MAP_POSITIVE_X;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.TEXTURE_CUBE_MAP_POSITIVE_X;
/** @const {!GLenum} */ WebGLRenderingContext.TEXTURE_CUBE_MAP_POSITIVE_Y;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.TEXTURE_CUBE_MAP_POSITIVE_Y;
/** @const {!GLenum} */ WebGLRenderingContext.TEXTURE_CUBE_MAP_POSITIVE_Z;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.TEXTURE_CUBE_MAP_POSITIVE_Z;
/** @const {!GLenum} */ WebGLRenderingContext.TEXTURE_MAG_FILTER;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.TEXTURE_MAG_FILTER;
/** @const {!GLenum} */ WebGLRenderingContext.TEXTURE_MIN_FILTER;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.TEXTURE_MIN_FILTER;
/** @const {!GLenum} */ WebGLRenderingContext.TEXTURE_WRAP_S;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.TEXTURE_WRAP_S;
/** @const {!GLenum} */ WebGLRenderingContext.TEXTURE_WRAP_T;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.TEXTURE_WRAP_T;
/** @const {!GLenum} */ WebGLRenderingContext.TRIANGLES;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.TRIANGLES;
/** @const {!GLenum} */ WebGLRenderingContext.TRIANGLE_FAN;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.TRIANGLE_FAN;
/** @const {!GLenum} */ WebGLRenderingContext.TRIANGLE_STRIP;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.TRIANGLE_STRIP;
/** @const {!GLenum} */ WebGLRenderingContext.UNPACK_ALIGNMENT;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.UNPACK_ALIGNMENT;
/** @const {!GLenum} */ WebGLRenderingContext.UNPACK_COLORSPACE_CONVERSION_WEBGL;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.UNPACK_COLORSPACE_CONVERSION_WEBGL;
/** @const {!GLenum} */ WebGLRenderingContext.UNPACK_FLIP_Y_WEBGL;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.UNPACK_FLIP_Y_WEBGL;
/** @const {!GLenum} */ WebGLRenderingContext.UNPACK_PREMULTIPLY_ALPHA_WEBGL;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.UNPACK_PREMULTIPLY_ALPHA_WEBGL;
/** @const {!GLenum} */ WebGLRenderingContext.UNSIGNED_BYTE;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.UNSIGNED_BYTE;
/** @const {!GLenum} */ WebGLRenderingContext.UNSIGNED_INT;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.UNSIGNED_INT;
/** @const {!GLenum} */ WebGLRenderingContext.UNSIGNED_SHORT;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.UNSIGNED_SHORT;
/** @const {!GLenum} */ WebGLRenderingContext.UNSIGNED_SHORT_4_4_4_4;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.UNSIGNED_SHORT_4_4_4_4;
/** @const {!GLenum} */ WebGLRenderingContext.UNSIGNED_SHORT_5_5_5_1;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.UNSIGNED_SHORT_5_5_5_1;
/** @const {!GLenum} */ WebGLRenderingContext.UNSIGNED_SHORT_5_6_5;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.UNSIGNED_SHORT_5_6_5;
/** @const {!GLenum} */ WebGLRenderingContext.VALIDATE_STATUS;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.VALIDATE_STATUS;
/** @const {!GLenum} */ WebGLRenderingContext.VENDOR;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.VENDOR;
/** @const {!GLenum} */ WebGLRenderingContext.VERSION;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.VERSION;
/** @const {!GLenum} */ WebGLRenderingContext.VERTEX_ATTRIB_ARRAY_BUFFER_BINDING;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.VERTEX_ATTRIB_ARRAY_BUFFER_BINDING;
/** @const {!GLenum} */ WebGLRenderingContext.VERTEX_ATTRIB_ARRAY_ENABLED;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.VERTEX_ATTRIB_ARRAY_ENABLED;
/** @const {!GLenum} */ WebGLRenderingContext.VERTEX_ATTRIB_ARRAY_NORMALIZED;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.VERTEX_ATTRIB_ARRAY_NORMALIZED;
/** @const {!GLenum} */ WebGLRenderingContext.VERTEX_ATTRIB_ARRAY_POINTER;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.VERTEX_ATTRIB_ARRAY_POINTER;
/** @const {!GLenum} */ WebGLRenderingContext.VERTEX_ATTRIB_ARRAY_SIZE;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.VERTEX_ATTRIB_ARRAY_SIZE;
/** @const {!GLenum} */ WebGLRenderingContext.VERTEX_ATTRIB_ARRAY_STRIDE;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.VERTEX_ATTRIB_ARRAY_STRIDE;
/** @const {!GLenum} */ WebGLRenderingContext.VERTEX_ATTRIB_ARRAY_TYPE;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.VERTEX_ATTRIB_ARRAY_TYPE;
/** @const {!GLenum} */ WebGLRenderingContext.VERTEX_SHADER;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.VERTEX_SHADER;
/** @const {!GLenum} */ WebGLRenderingContext.VIEWPORT;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.VIEWPORT;
/** @const {!GLenum} */ WebGLRenderingContext.ZERO;
/** @const {!GLenum} */ WebGLRenderingContext.prototype.ZERO;
/** @type {!GLsizei} */ WebGLRenderingContext.prototype.drawingBufferHeight;
/** @type {!GLsizei} */ WebGLRenderingContext.prototype.drawingBufferWidth;
/**
 * @param {?WebGLBuffer} buffer
 * @return {!GLboolean}
 * @nosideeffects
 */
WebGLRenderingContext.prototype.isBuffer = function(buffer) {}
/**
 * @param {!GLenum} target
 * @return {undefined}
 */
WebGLRenderingContext.prototype.generateMipmap = function(target) {}
/**
 * @param {?WebGLProgram} program
 * @return {undefined}
 */
WebGLRenderingContext.prototype.deleteProgram = function(program) {}
/**
 * @param {!GLenum} texture
 * @return {undefined}
 */
WebGLRenderingContext.prototype.activeTexture = function(texture) {}
/**
 * @param {!GLuint} index
 * @param {!GLenum} pname
 * @return {*}
 * @nosideeffects
 */
WebGLRenderingContext.prototype.getVertexAttrib = function(index,pname) {}
/**
 * @param {!GLenum} target
 * @param {!GLenum} attachment
 * @param {!GLenum} renderbuffertarget
 * @param {?WebGLRenderbuffer} renderbuffer
 * @return {undefined}
 */
WebGLRenderingContext.prototype.framebufferRenderbuffer = function(target,attachment,renderbuffertarget,renderbuffer) {}
/**
 * @param {!GLenum} target
 * @param {!GLint} level
 * @param {!GLenum} internalformat
 * @param {!GLsizei} width
 * @param {!GLsizei} height
 * @param {!GLint} border
 * @param {!ArrayBufferView} data
 * @return {undefined}
 */
WebGLRenderingContext.prototype.compressedTexImage2D = function(target,level,internalformat,width,height,border,data) {}
/**
 * @param {?WebGLProgram} program
 * @return {undefined}
 */
WebGLRenderingContext.prototype.useProgram = function(program) {}
/**
 * @param {!GLuint} index
 * @return {undefined}
 */
WebGLRenderingContext.prototype.enableVertexAttribArray = function(index) {}
/**
 * @param {!GLenum} target
 * @param {?WebGLFramebuffer} framebuffer
 * @return {undefined}
 */
WebGLRenderingContext.prototype.bindFramebuffer = function(target,framebuffer) {}
/**
 * @param {!GLenum} cap
 * @return {undefined}
 */
WebGLRenderingContext.prototype.enable = function(cap) {}
/**
 * @param {?WebGLUniformLocation} location
 * @param {!Int32List} v
 * @return {undefined}
 */
WebGLRenderingContext.prototype.uniform1iv = function(location,v) {}
/**
 * @param {!GLint} s
 * @return {undefined}
 */
WebGLRenderingContext.prototype.clearStencil = function(s) {}
/**
 * @return {?WebGLTexture}
 * @nosideeffects
 */
WebGLRenderingContext.prototype.createTexture = function() {}
/**
 * @param {!GLuint} index
 * @param {!GLfloat} x
 * @param {!GLfloat} y
 * @return {undefined}
 */
WebGLRenderingContext.prototype.vertexAttrib2f = function(index,x,y) {}
/**
 * @param {!GLenum} target
 * @param {!GLint} level
 * @param {!GLint} xoffset
 * @param {!GLint} yoffset
 * @param {!GLint} x
 * @param {!GLint} y
 * @param {!GLsizei} width
 * @param {!GLsizei} height
 * @return {undefined}
 */
WebGLRenderingContext.prototype.copyTexSubImage2D = function(target,level,xoffset,yoffset,x,y,width,height) {}
/**
 * @return {?Array<!string>}
 * @nosideeffects
 */
WebGLRenderingContext.prototype.getSupportedExtensions = function() {}
/**
 * @param {!GLenum} pname
 * @return {*}
 * @nosideeffects
 */
WebGLRenderingContext.prototype.getParameter = function(pname) {}
/**
 * @return {?WebGLFramebuffer}
 * @nosideeffects
 */
WebGLRenderingContext.prototype.createFramebuffer = function() {}
/**
 * @param {!GLenum} target
 * @param {!GLint} level
 * @param {!GLenum} internalformat
 * @param {!GLint} x
 * @param {!GLint} y
 * @param {!GLsizei} width
 * @param {!GLsizei} height
 * @param {!GLint} border
 * @return {undefined}
 */
WebGLRenderingContext.prototype.copyTexImage2D = function(target,level,internalformat,x,y,width,height,border) {}
/**
 * @param {?WebGLUniformLocation} location
 * @param {!Float32List} v
 * @return {undefined}
 */
WebGLRenderingContext.prototype.uniform4fv = function(location,v) {}
/**
 * @param {?WebGLFramebuffer} framebuffer
 * @return {!GLboolean}
 * @nosideeffects
 */
WebGLRenderingContext.prototype.isFramebuffer = function(framebuffer) {}
/**
 * @return {!boolean}
 * @nosideeffects
 */
WebGLRenderingContext.prototype.isContextLost = function() {}
/**
 * @param {!WebGLProgram} program
 * @return {?Array<!WebGLShader>}
 * @nosideeffects
 */
WebGLRenderingContext.prototype.getAttachedShaders = function(program) {}
/**
 * @param {!GLuint} index
 * @param {!Float32List} values
 * @return {undefined}
 */
WebGLRenderingContext.prototype.vertexAttrib1fv = function(index,values) {}
/**
 * @param {!GLenum} shadertype
 * @param {!GLenum} precisiontype
 * @return {?WebGLShaderPrecisionFormat}
 * @nosideeffects
 */
WebGLRenderingContext.prototype.getShaderPrecisionFormat = function(shadertype,precisiontype) {}
/**
 * @param {!GLfloat} factor
 * @param {!GLfloat} units
 * @return {undefined}
 */
WebGLRenderingContext.prototype.polygonOffset = function(factor,units) {}
/**
 * @return {!GLenum}
 * @nosideeffects
 */
WebGLRenderingContext.prototype.getError = function() {}
/**
 * @return {?WebGLContextAttributes}
 * @nosideeffects
 */
WebGLRenderingContext.prototype.getContextAttributes = function() {}
/**
 * @param {!GLenum} arg0
 * @param {!GLint} arg1
 * @param {!GLint} arg2
 * @param {!GLint} arg3
 * @param {(!GLsizei|!GLenum)} arg4
 * @param {(!GLsizei|!GLenum)} arg5
 * @param {(!GLenum|!TexImageSource)} arg6
 * @param {!GLenum=} arg7
 * @param {?ArrayBufferView=} arg8
 * @return {undefined}
 */
WebGLRenderingContext.prototype.texSubImage2D = function(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8) {}
/**
 * @param {!GLuint} index
 * @param {!GLenum} pname
 * @return {!GLintptr}
 * @nosideeffects
 */
WebGLRenderingContext.prototype.getVertexAttribOffset = function(index,pname) {}
/**
 * @param {!GLenum} cap
 * @return {!GLboolean}
 * @nosideeffects
 */
WebGLRenderingContext.prototype.isEnabled = function(cap) {}
/**
 * @param {!GLenum} target
 * @param {!GLenum} pname
 * @return {*}
 * @nosideeffects
 */
WebGLRenderingContext.prototype.getRenderbufferParameter = function(target,pname) {}
/**
 * @param {!WebGLProgram} program
 * @return {?string}
 * @nosideeffects
 */
WebGLRenderingContext.prototype.getProgramInfoLog = function(program) {}
/**
 * @param {!GLuint} index
 * @param {!GLfloat} x
 * @param {!GLfloat} y
 * @param {!GLfloat} z
 * @return {undefined}
 */
WebGLRenderingContext.prototype.vertexAttrib3f = function(index,x,y,z) {}
/**
 * @param {!GLenum} func
 * @return {undefined}
 */
WebGLRenderingContext.prototype.depthFunc = function(func) {}
/**
 * @param {!GLenum} mode
 * @return {undefined}
 */
WebGLRenderingContext.prototype.cullFace = function(mode) {}
/**
 * @param {!WebGLProgram} program
 * @param {!string} name
 * @return {!GLint}
 * @nosideeffects
 */
WebGLRenderingContext.prototype.getAttribLocation = function(program,name) {}
/**
 * @param {!GLenum} fail
 * @param {!GLenum} zfail
 * @param {!GLenum} zpass
 * @return {undefined}
 */
WebGLRenderingContext.prototype.stencilOp = function(fail,zfail,zpass) {}
/**
 * @param {?WebGLUniformLocation} location
 * @param {!GLboolean} transpose
 * @param {!Float32List} value
 * @return {undefined}
 */
WebGLRenderingContext.prototype.uniformMatrix4fv = function(location,transpose,value) {}
/**
 * @param {!GLfloat} width
 * @return {undefined}
 */
WebGLRenderingContext.prototype.lineWidth = function(width) {}
/**
 * @param {?WebGLRenderbuffer} renderbuffer
 * @return {undefined}
 */
WebGLRenderingContext.prototype.deleteRenderbuffer = function(renderbuffer) {}
/**
 * @param {!GLenum} modeRGB
 * @param {!GLenum} modeAlpha
 * @return {undefined}
 */
WebGLRenderingContext.prototype.blendEquationSeparate = function(modeRGB,modeAlpha) {}
/**
 * @param {!GLboolean} flag
 * @return {undefined}
 */
WebGLRenderingContext.prototype.depthMask = function(flag) {}
/**
 * @param {!WebGLProgram} program
 * @param {!GLuint} index
 * @param {!string} name
 * @return {undefined}
 */
WebGLRenderingContext.prototype.bindAttribLocation = function(program,index,name) {}
/**
 * @param {!GLuint} index
 * @return {undefined}
 */
WebGLRenderingContext.prototype.disableVertexAttribArray = function(index) {}
/**
 * @param {?WebGLUniformLocation} location
 * @param {!Int32List} v
 * @return {undefined}
 */
WebGLRenderingContext.prototype.uniform2iv = function(location,v) {}
/**
 * @param {!WebGLShader} shader
 * @return {undefined}
 */
WebGLRenderingContext.prototype.compileShader = function(shader) {}
/**
 * @param {!WebGLShader} shader
 * @return {?string}
 * @nosideeffects
 */
WebGLRenderingContext.prototype.getShaderSource = function(shader) {}
/**
 * @param {!GLenum} target
 * @param {!GLint} level
 * @param {!GLint} xoffset
 * @param {!GLint} yoffset
 * @param {!GLsizei} width
 * @param {!GLsizei} height
 * @param {!GLenum} format
 * @param {!ArrayBufferView} data
 * @return {undefined}
 */
WebGLRenderingContext.prototype.compressedTexSubImage2D = function(target,level,xoffset,yoffset,width,height,format,data) {}
/**
 * @param {!GLuint} index
 * @param {!GLfloat} x
 * @param {!GLfloat} y
 * @param {!GLfloat} z
 * @param {!GLfloat} w
 * @return {undefined}
 */
WebGLRenderingContext.prototype.vertexAttrib4f = function(index,x,y,z,w) {}
/**
 * @param {!GLenum} mode
 * @param {!GLsizei} count
 * @param {!GLenum} type
 * @param {!GLintptr} offset
 * @return {undefined}
 */
WebGLRenderingContext.prototype.drawElements = function(mode,count,type,offset) {}
/**
 * @param {!string} name
 * @return {?Object}
 */
WebGLRenderingContext.prototype.getExtension = function(name) {}
/**
 * @param {!GLenum} face
 * @param {!GLenum} fail
 * @param {!GLenum} zfail
 * @param {!GLenum} zpass
 * @return {undefined}
 */
WebGLRenderingContext.prototype.stencilOpSeparate = function(face,fail,zfail,zpass) {}
/**
 * @param {!GLclampf} value
 * @param {!GLboolean} invert
 * @return {undefined}
 */
WebGLRenderingContext.prototype.sampleCoverage = function(value,invert) {}
/**
 * @param {?WebGLFramebuffer} framebuffer
 * @return {undefined}
 */
WebGLRenderingContext.prototype.deleteFramebuffer = function(framebuffer) {}
/**
 * @param {!WebGLShader} shader
 * @return {?string}
 * @nosideeffects
 */
WebGLRenderingContext.prototype.getShaderInfoLog = function(shader) {}
/**
 * @param {!GLuint} index
 * @param {!Float32List} values
 * @return {undefined}
 */
WebGLRenderingContext.prototype.vertexAttrib2fv = function(index,values) {}
/**
 * @param {?WebGLShader} shader
 * @return {undefined}
 */
WebGLRenderingContext.prototype.deleteShader = function(shader) {}
/**
 * @param {?WebGLBuffer} buffer
 * @return {undefined}
 */
WebGLRenderingContext.prototype.deleteBuffer = function(buffer) {}
/**
 * @param {!GLenum} cap
 * @return {undefined}
 */
WebGLRenderingContext.prototype.disable = function(cap) {}
/**
 * @param {!GLenum} target
 * @param {!GLintptr} offset
 * @param {!BufferSource} data
 * @return {undefined}
 */
WebGLRenderingContext.prototype.bufferSubData = function(target,offset,data) {}
/**
 * @param {!GLenum} mode
 * @param {!GLint} first
 * @param {!GLsizei} count
 * @return {undefined}
 */
WebGLRenderingContext.prototype.drawArrays = function(mode,first,count) {}
/**
 * @param {?WebGLTexture} texture
 * @return {!GLboolean}
 * @nosideeffects
 */
WebGLRenderingContext.prototype.isTexture = function(texture) {}
/**
 * @param {?WebGLUniformLocation} location
 * @param {!Float32List} v
 * @return {undefined}
 */
WebGLRenderingContext.prototype.uniform1fv = function(location,v) {}
/**
 * @param {!GLint} x
 * @param {!GLint} y
 * @param {!GLsizei} width
 * @param {!GLsizei} height
 * @return {undefined}
 */
WebGLRenderingContext.prototype.scissor = function(x,y,width,height) {}
/**
 * @param {!GLenum} target
 * @param {!GLenum} pname
 * @return {*}
 * @nosideeffects
 */
WebGLRenderingContext.prototype.getBufferParameter = function(target,pname) {}
/**
 * @param {?WebGLUniformLocation} location
 * @param {!GLboolean} transpose
 * @param {!Float32List} value
 * @return {undefined}
 */
WebGLRenderingContext.prototype.uniformMatrix3fv = function(location,transpose,value) {}
/**
 * @param {?WebGLUniformLocation} location
 * @param {!GLfloat} x
 * @param {!GLfloat} y
 * @param {!GLfloat} z
 * @return {undefined}
 */
WebGLRenderingContext.prototype.uniform3f = function(location,x,y,z) {}
/**
 * @param {!WebGLProgram} program
 * @return {undefined}
 */
WebGLRenderingContext.prototype.validateProgram = function(program) {}
/**
 * @param {!GLenum} face
 * @param {!GLuint} mask
 * @return {undefined}
 */
WebGLRenderingContext.prototype.stencilMaskSeparate = function(face,mask) {}
/**
 * @param {!GLclampf} zNear
 * @param {!GLclampf} zFar
 * @return {undefined}
 */
WebGLRenderingContext.prototype.depthRange = function(zNear,zFar) {}
/**
 * @param {!GLenum} mode
 * @return {undefined}
 */
WebGLRenderingContext.prototype.blendEquation = function(mode) {}
/**
 * @return {undefined}
 */
WebGLRenderingContext.prototype.finish = function() {}
/**
 * @param {!GLint} x
 * @param {!GLint} y
 * @param {!GLsizei} width
 * @param {!GLsizei} height
 * @param {!GLenum} format
 * @param {!GLenum} type
 * @param {?ArrayBufferView} pixels
 * @return {undefined}
 */
WebGLRenderingContext.prototype.readPixels = function(x,y,width,height,format,type,pixels) {}
/**
 * @param {?WebGLUniformLocation} location
 * @param {!GLint} x
 * @param {!GLint} y
 * @param {!GLint} z
 * @return {undefined}
 */
WebGLRenderingContext.prototype.uniform3i = function(location,x,y,z) {}
/**
 * @param {!GLenum} arg0
 * @param {(!GLsizeiptr|?BufferSource)} arg1
 * @param {!GLenum} arg2
 * @return {undefined}
 */
WebGLRenderingContext.prototype.bufferData = function(arg0,arg1,arg2) {}
/**
 * @return {?WebGLProgram}
 * @nosideeffects
 */
WebGLRenderingContext.prototype.createProgram = function() {}
/**
 * @param {?WebGLUniformLocation} location
 * @param {!Int32List} v
 * @return {undefined}
 */
WebGLRenderingContext.prototype.uniform3iv = function(location,v) {}
/**
 * @param {!GLenum} target
 * @param {?WebGLTexture} texture
 * @return {undefined}
 */
WebGLRenderingContext.prototype.bindTexture = function(target,texture) {}
/**
 * @param {!WebGLProgram} program
 * @param {!WebGLShader} shader
 * @return {undefined}
 */
WebGLRenderingContext.prototype.detachShader = function(program,shader) {}
/**
 * @param {!GLenum} target
 * @param {!GLenum} attachment
 * @param {!GLenum} pname
 * @return {*}
 * @nosideeffects
 */
WebGLRenderingContext.prototype.getFramebufferAttachmentParameter = function(target,attachment,pname) {}
/**
 * @param {!GLenum} func
 * @param {!GLint} ref
 * @param {!GLuint} mask
 * @return {undefined}
 */
WebGLRenderingContext.prototype.stencilFunc = function(func,ref,mask) {}
/**
 * @param {!GLuint} index
 * @param {!Float32List} values
 * @return {undefined}
 */
WebGLRenderingContext.prototype.vertexAttrib3fv = function(index,values) {}
/**
 * @param {?WebGLUniformLocation} location
 * @param {!GLfloat} x
 * @param {!GLfloat} y
 * @param {!GLfloat} z
 * @param {!GLfloat} w
 * @return {undefined}
 */
WebGLRenderingContext.prototype.uniform4f = function(location,x,y,z,w) {}
/**
 * @param {!GLenum} mode
 * @return {undefined}
 */
WebGLRenderingContext.prototype.frontFace = function(mode) {}
/**
 * @param {!GLenum} target
 * @param {!GLenum} pname
 * @return {*}
 * @nosideeffects
 */
WebGLRenderingContext.prototype.getTexParameter = function(target,pname) {}
/**
 * @param {!GLenum} target
 * @param {!GLenum} pname
 * @param {!GLint} param
 * @return {undefined}
 */
WebGLRenderingContext.prototype.texParameteri = function(target,pname,param) {}
/**
 * @param {!GLenum} target
 * @param {!GLenum} pname
 * @param {!GLfloat} param
 * @return {undefined}
 */
WebGLRenderingContext.prototype.texParameterf = function(target,pname,param) {}
/**
 * @param {!GLenum} target
 * @param {!GLenum} mode
 * @return {undefined}
 */
WebGLRenderingContext.prototype.hint = function(target,mode) {}
/**
 * @param {?WebGLTexture} texture
 * @return {undefined}
 */
WebGLRenderingContext.prototype.deleteTexture = function(texture) {}
/**
 * @param {!GLclampf} depth
 * @return {undefined}
 */
WebGLRenderingContext.prototype.clearDepth = function(depth) {}
/**
 * @param {!GLenum} pname
 * @param {!GLint} param
 * @return {undefined}
 */
WebGLRenderingContext.prototype.pixelStorei = function(pname,param) {}
/**
 * @param {?WebGLUniformLocation} location
 * @param {!Float32List} v
 * @return {undefined}
 */
WebGLRenderingContext.prototype.uniform2fv = function(location,v) {}
/**
 * @param {?WebGLUniformLocation} location
 * @param {!GLint} x
 * @param {!GLint} y
 * @param {!GLint} z
 * @param {!GLint} w
 * @return {undefined}
 */
WebGLRenderingContext.prototype.uniform4i = function(location,x,y,z,w) {}
/**
 * @param {!WebGLProgram} program
 * @param {!GLenum} pname
 * @return {*}
 * @nosideeffects
 */
WebGLRenderingContext.prototype.getProgramParameter = function(program,pname) {}
/**
 * @param {!WebGLProgram} program
 * @param {!WebGLShader} shader
 * @return {undefined}
 */
WebGLRenderingContext.prototype.attachShader = function(program,shader) {}
/**
 * @param {!GLenum} target
 * @param {?WebGLBuffer} buffer
 * @return {undefined}
 */
WebGLRenderingContext.prototype.bindBuffer = function(target,buffer) {}
/**
 * @param {!GLenum} arg0
 * @param {!GLint} arg1
 * @param {!GLint} arg2
 * @param {(!GLsizei|!GLenum)} arg3
 * @param {(!GLsizei|!GLenum)} arg4
 * @param {(!GLint|!TexImageSource)} arg5
 * @param {!GLenum=} arg6
 * @param {!GLenum=} arg7
 * @param {?ArrayBufferView=} arg8
 * @return {undefined}
 */
WebGLRenderingContext.prototype.texImage2D = function(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8) {}
/**
 * @param {!GLenum} srcRGB
 * @param {!GLenum} dstRGB
 * @param {!GLenum} srcAlpha
 * @param {!GLenum} dstAlpha
 * @return {undefined}
 */
WebGLRenderingContext.prototype.blendFuncSeparate = function(srcRGB,dstRGB,srcAlpha,dstAlpha) {}
/**
 * @param {!GLenum} target
 * @param {?WebGLRenderbuffer} renderbuffer
 * @return {undefined}
 */
WebGLRenderingContext.prototype.bindRenderbuffer = function(target,renderbuffer) {}
/**
 * @return {?WebGLBuffer}
 * @nosideeffects
 */
WebGLRenderingContext.prototype.createBuffer = function() {}
/**
 * @param {!GLenum} target
 * @return {!GLenum}
 */
WebGLRenderingContext.prototype.checkFramebufferStatus = function(target) {}
/**
 * @param {!WebGLProgram} program
 * @return {undefined}
 */
WebGLRenderingContext.prototype.linkProgram = function(program) {}
/**
 * @param {!WebGLProgram} program
 * @param {!WebGLUniformLocation} location
 * @return {*}
 * @nosideeffects
 */
WebGLRenderingContext.prototype.getUniform = function(program,location) {}
/**
 * @param {?WebGLUniformLocation} location
 * @param {!GLboolean} transpose
 * @param {!Float32List} value
 * @return {undefined}
 */
WebGLRenderingContext.prototype.uniformMatrix2fv = function(location,transpose,value) {}
/**
 * @return {!Promise<undefined>}
 */
WebGLRenderingContext.prototype.makeXRCompatible = function() {}
/**
 * @param {!GLclampf} red
 * @param {!GLclampf} green
 * @param {!GLclampf} blue
 * @param {!GLclampf} alpha
 * @return {undefined}
 */
WebGLRenderingContext.prototype.clearColor = function(red,green,blue,alpha) {}
/**
 * @return {undefined}
 */
WebGLRenderingContext.prototype.flush = function() {}
/**
 * @param {!WebGLProgram} program
 * @param {!GLuint} index
 * @return {?WebGLActiveInfo}
 * @nosideeffects
 */
WebGLRenderingContext.prototype.getActiveAttrib = function(program,index) {}
/**
 * @param {?WebGLRenderbuffer} renderbuffer
 * @return {!GLboolean}
 * @nosideeffects
 */
WebGLRenderingContext.prototype.isRenderbuffer = function(renderbuffer) {}
/**
 * @param {!GLuint} mask
 * @return {undefined}
 */
WebGLRenderingContext.prototype.stencilMask = function(mask) {}
/**
 * @param {!GLenum} target
 * @param {!GLenum} attachment
 * @param {!GLenum} textarget
 * @param {?WebGLTexture} texture
 * @param {!GLint} level
 * @return {undefined}
 */
WebGLRenderingContext.prototype.framebufferTexture2D = function(target,attachment,textarget,texture,level) {}
/**
 * @param {!GLenum} type
 * @return {?WebGLShader}
 * @nosideeffects
 */
WebGLRenderingContext.prototype.createShader = function(type) {}
/**
 * @param {?WebGLUniformLocation} location
 * @param {!GLint} x
 * @return {undefined}
 */
WebGLRenderingContext.prototype.uniform1i = function(location,x) {}
/**
 * @param {!GLclampf} red
 * @param {!GLclampf} green
 * @param {!GLclampf} blue
 * @param {!GLclampf} alpha
 * @return {undefined}
 */
WebGLRenderingContext.prototype.blendColor = function(red,green,blue,alpha) {}
/**
 * @param {!GLuint} index
 * @param {!GLint} size
 * @param {!GLenum} type
 * @param {!GLboolean} normalized
 * @param {!GLsizei} stride
 * @param {!GLintptr} offset
 * @return {undefined}
 */
WebGLRenderingContext.prototype.vertexAttribPointer = function(index,size,type,normalized,stride,offset) {}
/**
 * @param {?WebGLUniformLocation} location
 * @param {!GLfloat} x
 * @return {undefined}
 */
WebGLRenderingContext.prototype.uniform1f = function(location,x) {}
/**
 * @param {?WebGLUniformLocation} location
 * @param {!Int32List} v
 * @return {undefined}
 */
WebGLRenderingContext.prototype.uniform4iv = function(location,v) {}
/**
 * @param {!WebGLProgram} program
 * @param {!GLuint} index
 * @return {?WebGLActiveInfo}
 * @nosideeffects
 */
WebGLRenderingContext.prototype.getActiveUniform = function(program,index) {}
/**
 * @param {!GLboolean} red
 * @param {!GLboolean} green
 * @param {!GLboolean} blue
 * @param {!GLboolean} alpha
 * @return {undefined}
 */
WebGLRenderingContext.prototype.colorMask = function(red,green,blue,alpha) {}
/**
 * @param {!GLenum} target
 * @param {!GLenum} internalformat
 * @param {!GLsizei} width
 * @param {!GLsizei} height
 * @return {undefined}
 */
WebGLRenderingContext.prototype.renderbufferStorage = function(target,internalformat,width,height) {}
/**
 * @return {?WebGLRenderbuffer}
 * @nosideeffects
 */
WebGLRenderingContext.prototype.createRenderbuffer = function() {}
/**
 * @param {!GLbitfield} mask
 * @return {undefined}
 */
WebGLRenderingContext.prototype.clear = function(mask) {}
/**
 * @param {!GLenum} sfactor
 * @param {!GLenum} dfactor
 * @return {undefined}
 */
WebGLRenderingContext.prototype.blendFunc = function(sfactor,dfactor) {}
/**
 * @param {!GLenum} face
 * @param {!GLenum} func
 * @param {!GLint} ref
 * @param {!GLuint} mask
 * @return {undefined}
 */
WebGLRenderingContext.prototype.stencilFuncSeparate = function(face,func,ref,mask) {}
/**
 * @param {!GLuint} index
 * @param {!Float32List} values
 * @return {undefined}
 */
WebGLRenderingContext.prototype.vertexAttrib4fv = function(index,values) {}
/**
 * @param {!GLint} x
 * @param {!GLint} y
 * @param {!GLsizei} width
 * @param {!GLsizei} height
 * @return {undefined}
 */
WebGLRenderingContext.prototype.viewport = function(x,y,width,height) {}
/**
 * @param {!WebGLProgram} program
 * @param {!string} name
 * @return {?WebGLUniformLocation}
 * @nosideeffects
 */
WebGLRenderingContext.prototype.getUniformLocation = function(program,name) {}
/**
 * @param {!WebGLShader} shader
 * @param {!string} source
 * @return {undefined}
 */
WebGLRenderingContext.prototype.shaderSource = function(shader,source) {}
/**
 * @param {!WebGLShader} shader
 * @param {!GLenum} pname
 * @return {*}
 * @nosideeffects
 */
WebGLRenderingContext.prototype.getShaderParameter = function(shader,pname) {}
/**
 * @param {?WebGLProgram} program
 * @return {!GLboolean}
 * @nosideeffects
 */
WebGLRenderingContext.prototype.isProgram = function(program) {}
/**
 * @param {!GLuint} index
 * @param {!GLfloat} x
 * @return {undefined}
 */
WebGLRenderingContext.prototype.vertexAttrib1f = function(index,x) {}
/**
 * @param {?WebGLUniformLocation} location
 * @param {!GLint} x
 * @param {!GLint} y
 * @return {undefined}
 */
WebGLRenderingContext.prototype.uniform2i = function(location,x,y) {}
/**
 * @param {?WebGLUniformLocation} location
 * @param {!Float32List} v
 * @return {undefined}
 */
WebGLRenderingContext.prototype.uniform3fv = function(location,v) {}
/**
 * @param {?WebGLUniformLocation} location
 * @param {!GLfloat} x
 * @param {!GLfloat} y
 * @return {undefined}
 */
WebGLRenderingContext.prototype.uniform2f = function(location,x,y) {}
/**
 * @param {?WebGLShader} shader
 * @return {!GLboolean}
 * @nosideeffects
 */
WebGLRenderingContext.prototype.isShader = function(shader) {}
/**
 * @constructor
 * @extends {Event}
 * @param {!string} type
 * @param {!AudioProcessingEventInit} eventInitDict
 */
function AudioProcessingEvent(type,eventInitDict) {}
/** @type {!AudioBuffer} */ AudioProcessingEvent.prototype.inputBuffer;
/** @type {!AudioBuffer} */ AudioProcessingEvent.prototype.outputBuffer;
/** @type {!number} */ AudioProcessingEvent.prototype.playbackTime;
/**
 * @constructor
 * @extends {AudioNode}
 * @param {!BaseAudioContext} context
 * @param {!ConvolverOptions=} options
 */
function ConvolverNode(context,options) {}
/** @type {?AudioBuffer} */ ConvolverNode.prototype.buffer;
/** @type {!boolean} */ ConvolverNode.prototype.normalize;
/**
 * @constructor
 * @extends {HTMLImageElement}
 * @param {!number=} width
 * @param {!number=} height
 */
function Image(width,height) {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function SVGUnitTypes() {}
/** @const {!number} */ SVGUnitTypes.SVG_UNIT_TYPE_OBJECTBOUNDINGBOX;
/** @const {!number} */ SVGUnitTypes.prototype.SVG_UNIT_TYPE_OBJECTBOUNDINGBOX;
/** @const {!number} */ SVGUnitTypes.SVG_UNIT_TYPE_UNKNOWN;
/** @const {!number} */ SVGUnitTypes.prototype.SVG_UNIT_TYPE_UNKNOWN;
/** @const {!number} */ SVGUnitTypes.SVG_UNIT_TYPE_USERSPACEONUSE;
/** @const {!number} */ SVGUnitTypes.prototype.SVG_UNIT_TYPE_USERSPACEONUSE;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function PerformanceEntry() {}
/** @type {!DOMHighResTimeStamp} */ PerformanceEntry.prototype.duration;
/** @type {!string} */ PerformanceEntry.prototype.entryType;
/** @type {!string} */ PerformanceEntry.prototype.name;
/** @type {!DOMHighResTimeStamp} */ PerformanceEntry.prototype.startTime;
/**
 * @return {!Object}
 * @override
 */
PerformanceEntry.prototype.toJSON = function() {}
/**
 * @constructor
 * @private
 * @extends {PerformanceEntry}
 * @nosideeffects
 */
function PerformanceResourceTiming() {}
/** @type {!DOMHighResTimeStamp} */ PerformanceResourceTiming.prototype.connectEnd;
/** @type {!DOMHighResTimeStamp} */ PerformanceResourceTiming.prototype.connectStart;
/** @type {!number} */ PerformanceResourceTiming.prototype.decodedBodySize;
/** @type {!DOMHighResTimeStamp} */ PerformanceResourceTiming.prototype.domainLookupEnd;
/** @type {!DOMHighResTimeStamp} */ PerformanceResourceTiming.prototype.domainLookupStart;
/** @type {!number} */ PerformanceResourceTiming.prototype.encodedBodySize;
/** @type {!DOMHighResTimeStamp} */ PerformanceResourceTiming.prototype.fetchStart;
/** @type {!string} */ PerformanceResourceTiming.prototype.initiatorType;
/** @type {!string} */ PerformanceResourceTiming.prototype.nextHopProtocol;
/** @type {!DOMHighResTimeStamp} */ PerformanceResourceTiming.prototype.redirectEnd;
/** @type {!DOMHighResTimeStamp} */ PerformanceResourceTiming.prototype.redirectStart;
/** @type {!DOMHighResTimeStamp} */ PerformanceResourceTiming.prototype.requestStart;
/** @type {!DOMHighResTimeStamp} */ PerformanceResourceTiming.prototype.responseEnd;
/** @type {!DOMHighResTimeStamp} */ PerformanceResourceTiming.prototype.responseStart;
/** @type {!DOMHighResTimeStamp} */ PerformanceResourceTiming.prototype.secureConnectionStart;
/** @type {!number} */ PerformanceResourceTiming.prototype.transferSize;
/** @type {!DOMHighResTimeStamp} */ PerformanceResourceTiming.prototype.workerStart;
/**
 * @return {!Object}
 * @override
 */
PerformanceResourceTiming.prototype.toJSON = function() {}
/**
 * @constructor
 * @private
 * @extends {EventTarget}
 * @nosideeffects
 */
function XRSession() {}
/** @type {!XRInputSourceArray} */ XRSession.prototype.inputSources;
/** @type {!XRRenderState} */ XRSession.prototype.renderState;
/** @type {!string} */ XRSession.prototype.visibilityState;
/** @type {!NullableEventHandler} */ XRSession.prototype.onend;
/** @type {!NullableEventHandler} */ XRSession.prototype.oninputsourceschange;
/** @type {!NullableEventHandler} */ XRSession.prototype.onselect;
/** @type {!NullableEventHandler} */ XRSession.prototype.onselectend;
/** @type {!NullableEventHandler} */ XRSession.prototype.onselectstart;
/** @type {!NullableEventHandler} */ XRSession.prototype.onsqueeze;
/** @type {!NullableEventHandler} */ XRSession.prototype.onsqueezeend;
/** @type {!NullableEventHandler} */ XRSession.prototype.onsqueezestart;
/** @type {!NullableEventHandler} */ XRSession.prototype.onvisibilitychange;
/**
 * @param {!number} handle
 * @return {undefined}
 */
XRSession.prototype.cancelAnimationFrame = function(handle) {}
/**
 * @param {!string} type
 * @return {!Promise<!XRReferenceSpace>}
 */
XRSession.prototype.requestReferenceSpace = function(type) {}
/**
 * @param {!XRRenderStateInit=} state
 * @return {undefined}
 */
XRSession.prototype.updateRenderState = function(state) {}
/**
 * @return {!Promise<undefined>}
 */
XRSession.prototype.end = function() {}
/**
 * @param {!XRFrameRequestCallback} callback
 * @return {!number}
 */
XRSession.prototype.requestAnimationFrame = function(callback) {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function MimeTypeArray() {}
/** @type {!number} */ MimeTypeArray.prototype.length;
/**
 * @param {!string} name
 * @return {?MimeType}
 */
MimeTypeArray.prototype.namedItem = function(name) {}
/**
 * @param {!number} index
 * @return {?MimeType}
 */
MimeTypeArray.prototype.item = function(index) {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function WEBGL_compressed_texture_etc() {}
/** @const {!GLenum} */ WEBGL_compressed_texture_etc.prototype.COMPRESSED_R11_EAC;
/** @const {!GLenum} */ WEBGL_compressed_texture_etc.prototype.COMPRESSED_RG11_EAC;
/** @const {!GLenum} */ WEBGL_compressed_texture_etc.prototype.COMPRESSED_RGB8_ETC2;
/** @const {!GLenum} */ WEBGL_compressed_texture_etc.prototype.COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2;
/** @const {!GLenum} */ WEBGL_compressed_texture_etc.prototype.COMPRESSED_RGBA8_ETC2_EAC;
/** @const {!GLenum} */ WEBGL_compressed_texture_etc.prototype.COMPRESSED_SIGNED_R11_EAC;
/** @const {!GLenum} */ WEBGL_compressed_texture_etc.prototype.COMPRESSED_SIGNED_RG11_EAC;
/** @const {!GLenum} */ WEBGL_compressed_texture_etc.prototype.COMPRESSED_SRGB8_ALPHA8_ETC2_EAC;
/** @const {!GLenum} */ WEBGL_compressed_texture_etc.prototype.COMPRESSED_SRGB8_ETC2;
/** @const {!GLenum} */ WEBGL_compressed_texture_etc.prototype.COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2;
/**
 * @constructor
 * @extends {AudioNode}
 * @param {!AudioContext} context
 * @param {!MediaStreamTrackAudioSourceOptions} options
 */
function MediaStreamTrackAudioSourceNode(context,options) {}
/**
 * @constructor
 * @private
 * @extends {EventTarget}
 * @nosideeffects
 */
function XRLayer() {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function SVGAnimatedLength() {}
/** @type {!SVGLength} */ SVGAnimatedLength.prototype.animVal;
/** @type {!SVGLength} */ SVGAnimatedLength.prototype.baseVal;
/**
 * @constructor
 * @extends {UIEvent}
 * @param {!string} type
 * @param {!InputEventInit=} eventInitDict
 */
function InputEvent(type,eventInitDict) {}
/** @type {?string} */ InputEvent.prototype.data;
/** @type {!string} */ InputEvent.prototype.inputType;
/** @type {!boolean} */ InputEvent.prototype.isComposing;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function EXT_float_blend() {}
/**
 * @constructor
 * @extends {Object}
 * @param {!Object=} transformer
 * @param {!QueuingStrategy=} writableStrategy
 * @param {!QueuingStrategy=} readableStrategy
 */
function TransformStream(transformer,writableStrategy,readableStrategy) {}
/** @type {!ReadableStream} */ TransformStream.prototype.readable;
/** @type {!WritableStream} */ TransformStream.prototype.writable;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function ReadableByteStreamController() {}
/** @type {?ReadableStreamBYOBRequest} */ ReadableByteStreamController.prototype.byobRequest;
/** @type {?number} */ ReadableByteStreamController.prototype.desiredSize;
/**
 * @param {!ArrayBufferView} chunk
 * @return {undefined}
 */
ReadableByteStreamController.prototype.enqueue = function(chunk) {}
/**
 * @param {*=} e
 * @return {undefined}
 */
ReadableByteStreamController.prototype.error = function(e) {}
/**
 * @return {undefined}
 */
ReadableByteStreamController.prototype.close = function() {}
/**
 * @constructor
 * @private
 * @extends {HTMLElement}
 * @nosideeffects
 */
function HTMLTitleElement() {}
/** @type {!string} */ HTMLTitleElement.prototype.text;
/**
 * @constructor
 * @private
 * @extends {IDBRequest}
 * @nosideeffects
 */
function IDBOpenDBRequest() {}
/** @type {?IDBVersionChangeEventHandler} */ IDBOpenDBRequest.prototype.onblocked;
/** @type {?IDBVersionChangeEventHandler} */ IDBOpenDBRequest.prototype.onupgradeneeded;
/**
 * @constructor
 * @extends {Event}
 * @param {!string} type
 * @param {!CloseEventInit=} eventInitDict
 */
function CloseEvent(type,eventInitDict) {}
/** @type {!number} */ CloseEvent.prototype.code;
/** @type {!string} */ CloseEvent.prototype.reason;
/** @type {!boolean} */ CloseEvent.prototype.wasClean;
/**
 * @constructor
 * @extends {Event}
 * @param {!string} type
 * @param {!StorageEventInit=} eventInitDict
 */
function StorageEvent(type,eventInitDict) {}
/** @type {?string} */ StorageEvent.prototype.key;
/** @type {?string} */ StorageEvent.prototype.newValue;
/** @type {?string} */ StorageEvent.prototype.oldValue;
/** @type {?Storage} */ StorageEvent.prototype.storageArea;
/** @type {!string} */ StorageEvent.prototype.url;
/**
 * @param {!string} type
 * @param {!boolean=} bubbles
 * @param {!boolean=} cancelable
 * @param {?string=} key
 * @param {?string=} oldValue
 * @param {?string=} newValue
 * @param {!string=} url
 * @param {?Storage=} storageArea
 * @return {undefined}
 */
StorageEvent.prototype.initStorageEvent = function(type,bubbles,cancelable,key,oldValue,newValue,url,storageArea) {}
/**
 * @constructor
 * @private
 * @extends {SVGGeometryElement}
 * @nosideeffects
 */
function SVGPathElement() {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @implements {Iterable<!Array<!string|!AudioParam>>}
 * @nosideeffects
 */
function AudioParamMap() {}
/** @const {number} */ AudioParamMap.prototype.size;
/**
 * @param {!string} key
 * @return {!boolean}
 * @nosideeffects
 */
AudioParamMap.prototype.has = function(key) {}
/**
 * @param {!string} key
 * @return {!AudioParam}
 * @nosideeffects
 */
AudioParamMap.prototype.get = function(key) {}
/**
 * @return {!Iterator<!string>}
 * @nosideeffects
 */
AudioParamMap.prototype.keys = function() {}
/**
 * @return {!Iterator<!AudioParam>}
 * @nosideeffects
 */
AudioParamMap.prototype.values = function() {}
/**
 * @return {!Iterator<!Array<!string|!AudioParam>>}
 * @nosideeffects
 */
AudioParamMap.prototype.entries = function() {};
/**
 * @return {!Iterator<!Array<!string|!AudioParam>>}
 * @nosideeffects
 */
AudioParamMap.prototype[Symbol.iterator] = function() {};
/**
 * @param {function(!AudioParam, !string, MAP)} callback
 * @this {MAP}
 * @template MAP
 */
AudioParamMap.prototype.forEach = function(callback) {};
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function MutationRecord() {}
/** @type {!NodeList} */ MutationRecord.prototype.addedNodes;
/** @type {?string} */ MutationRecord.prototype.attributeName;
/** @type {?string} */ MutationRecord.prototype.attributeNamespace;
/** @type {?Node} */ MutationRecord.prototype.nextSibling;
/** @type {?string} */ MutationRecord.prototype.oldValue;
/** @type {?Node} */ MutationRecord.prototype.previousSibling;
/** @type {!NodeList} */ MutationRecord.prototype.removedNodes;
/** @type {!Node} */ MutationRecord.prototype.target;
/** @type {!string} */ MutationRecord.prototype.type;
/**
 * @constructor
 * @private
 * @extends {Event}
 * @nosideeffects
 */
function SpeechRecognitionEvent() {}
/** @type {!number} */ SpeechRecognitionEvent.prototype.resultIndex;
/** @type {!SpeechRecognitionResultList} */ SpeechRecognitionEvent.prototype.results;
/**
 * @constructor
 * @private
 * @extends {SVGGeometryElement}
 * @nosideeffects
 */
function SVGEllipseElement() {}
/** @type {!SVGAnimatedLength} */ SVGEllipseElement.prototype.cx;
/** @type {!SVGAnimatedLength} */ SVGEllipseElement.prototype.cy;
/** @type {!SVGAnimatedLength} */ SVGEllipseElement.prototype.rx;
/** @type {!SVGAnimatedLength} */ SVGEllipseElement.prototype.ry;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function SVGAnimatedNumberList() {}
/** @type {!SVGNumberList} */ SVGAnimatedNumberList.prototype.animVal;
/** @type {!SVGNumberList} */ SVGAnimatedNumberList.prototype.baseVal;
/**
 * @constructor
 * @private
 * @extends {HTMLElement}
 * @nosideeffects
 */
function HTMLDetailsElement() {}
/** @type {!boolean} */ HTMLDetailsElement.prototype.open;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function SpeechRecognitionAlternative() {}
/** @type {!number} */ SpeechRecognitionAlternative.prototype.confidence;
/** @type {!string} */ SpeechRecognitionAlternative.prototype.transcript;
/**
 * @constructor
 * @private
 * @extends {CSSRule}
 * @implements {Iterable<!Array<!number|!CSSOMString>>}
 * @nosideeffects
 */
function CSSFontPaletteValuesRule() {}
/** @type {!CSSOMString} */ CSSFontPaletteValuesRule.prototype.basePalette;
/** @type {!CSSOMString} */ CSSFontPaletteValuesRule.prototype.fontFamily;
/** @const {number} */ CSSFontPaletteValuesRule.prototype.size;
/**
 * @param {!number} key
 * @return {!boolean}
 * @nosideeffects
 */
CSSFontPaletteValuesRule.prototype.has = function(key) {}
/**
 * @param {!number} key
 * @return {!CSSOMString}
 * @nosideeffects
 */
CSSFontPaletteValuesRule.prototype.get = function(key) {}
/**
 * @return {!Iterator<!number>}
 * @nosideeffects
 */
CSSFontPaletteValuesRule.prototype.keys = function() {}
/**
 * @return {!Iterator<!CSSOMString>}
 * @nosideeffects
 */
CSSFontPaletteValuesRule.prototype.values = function() {}
/**
 * @return {!Iterator<!Array<!number|!CSSOMString>>}
 * @nosideeffects
 */
CSSFontPaletteValuesRule.prototype.entries = function() {};
/**
 * @return {!Iterator<!Array<!number|!CSSOMString>>}
 * @nosideeffects
 */
CSSFontPaletteValuesRule.prototype[Symbol.iterator] = function() {};
/**
 * @param {function(!CSSOMString, !number, MAP)} callback
 * @this {MAP}
 * @template MAP
 */
CSSFontPaletteValuesRule.prototype.forEach = function(callback) {};
/**
 * @param {!number} key
 * @param {!CSSOMString} value
 * @return {undefined}
 */
CSSFontPaletteValuesRule.prototype.set = function(key,value) {}
/**
 * @param {!number} key
 * @return {!boolean}
 */
CSSFontPaletteValuesRule.prototype.delete = function(key) {}
/**
 * @return {undefined}
 */
CSSFontPaletteValuesRule.prototype.clear = function() {}
/**
 * @constructor
 * @extends {Event}
 * @param {!string} type
 * @param {!OfflineAudioCompletionEventInit} eventInitDict
 */
function OfflineAudioCompletionEvent(type,eventInitDict) {}
/** @type {!AudioBuffer} */ OfflineAudioCompletionEvent.prototype.renderedBuffer;
/**
 * @constructor
 * @extends {Object}
 */
function AbortController() {}
/** @type {!AbortSignal} */ AbortController.prototype.signal;
/**
 * @return {undefined}
 */
AbortController.prototype.abort = function() {}
/**
 * @constructor
 * @extends {Object}
 * @param {!WritableStream} stream
 */
function WritableStreamDefaultWriter(stream) {}
/** @type {!Promise<undefined>} */ WritableStreamDefaultWriter.prototype.closed;
/** @type {?number} */ WritableStreamDefaultWriter.prototype.desiredSize;
/** @type {!Promise<undefined>} */ WritableStreamDefaultWriter.prototype.ready;
/**
 * @param {*=} reason
 * @return {!Promise<undefined>}
 */
WritableStreamDefaultWriter.prototype.abort = function(reason) {}
/**
 * @return {undefined}
 */
WritableStreamDefaultWriter.prototype.releaseLock = function() {}
/**
 * @param {*=} chunk
 * @return {!Promise<undefined>}
 */
WritableStreamDefaultWriter.prototype.write = function(chunk) {}
/**
 * @return {!Promise<undefined>}
 */
WritableStreamDefaultWriter.prototype.close = function() {}
/**
 * @constructor
 * @extends {Object}
 * @param {!string} format
 */
function DecompressionStream(format) {}
/** @type {!ReadableStream} */ DecompressionStream.prototype.readable;
/** @type {!WritableStream} */ DecompressionStream.prototype.writable;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function ImageBitmap() {}
/** @type {!number} */ ImageBitmap.prototype.height;
/** @type {!number} */ ImageBitmap.prototype.width;
/**
 * @return {undefined}
 */
ImageBitmap.prototype.close = function() {}
/**
 * @constructor
 * @private
 * @extends {CharacterData}
 * @nosideeffects
 */
function ProcessingInstruction() {}
/** @type {!string} */ ProcessingInstruction.prototype.target;
/** @type {?CSSStyleSheet} */ ProcessingInstruction.prototype.sheet;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function GPUTextureView() {}
/** @type {?string} */ GPUTextureView.prototype.label;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function TouchList() {}
/** @type {!number} */ TouchList.prototype.length;
/**
 * @param {!number} index
 * @return {?Touch}
 */
TouchList.prototype.item = function(index) {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function GPUCommandBuffer() {}
/** @type {!Promise<!number>} */ GPUCommandBuffer.prototype.executionTime;
/** @type {?string} */ GPUCommandBuffer.prototype.label;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function GPUComputePipeline() {}
/** @type {?string} */ GPUComputePipeline.prototype.label;
/**
 * @param {!number} index
 * @return {!GPUBindGroupLayout}
 */
GPUComputePipeline.prototype.getBindGroupLayout = function(index) {}
/**
 * @constructor
 * @extends {Event}
 * @param {!string} type
 * @param {!ClipboardEventInit=} eventInitDict
 */
function ClipboardEvent(type,eventInitDict) {}
/** @type {?DataTransfer} */ ClipboardEvent.prototype.clipboardData;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function EXT_sRGB() {}
/** @const {!GLenum} */ EXT_sRGB.prototype.FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING_EXT;
/** @const {!GLenum} */ EXT_sRGB.prototype.SRGB8_ALPHA8_EXT;
/** @const {!GLenum} */ EXT_sRGB.prototype.SRGB_ALPHA_EXT;
/** @const {!GLenum} */ EXT_sRGB.prototype.SRGB_EXT;
/**
 * @constructor
 * @private
 * @extends {WebGLObject}
 * @nosideeffects
 */
function WebGLSampler() {}
/**
 * @constructor
 * @private
 * @extends {HTMLCollection}
 * @nosideeffects
 */
function HTMLOptionsCollection() {}
/** @type {!number} */ HTMLOptionsCollection.prototype.length;
/** @type {!number} */ HTMLOptionsCollection.prototype.selectedIndex;
/**
 * @param {(!HTMLOptionElement|!HTMLOptGroupElement)} element
 * @param {(!HTMLElement|!number)=} before
 * @return {undefined}
 */
HTMLOptionsCollection.prototype.add = function(element,before) {}
/**
 * @param {!string} name
 * @return {?HTMLOptionElement}
 * @override
 */
HTMLOptionsCollection.prototype.namedItem = function(name) {}
/**
 * @param {!number} index
 * @return {?HTMLOptionElement}
 * @override
 */
HTMLOptionsCollection.prototype.item = function(index) {}
/**
 * @param {!number} index
 * @return {undefined}
 */
HTMLOptionsCollection.prototype.remove = function(index) {}
/**
 * @constructor
 * @extends {Event}
 * @param {!string} type
 * @param {!MessageEventInit=} eventInitDict
 */
function MessageEvent(type,eventInitDict) {}
/** @type {*} */ MessageEvent.prototype.data;
/** @type {!string} */ MessageEvent.prototype.lastEventId;
/** @type {!string} */ MessageEvent.prototype.origin;
/** @type {!Array<!MessagePort>} */ MessageEvent.prototype.ports;
/** @type {?MessageEventSource} */ MessageEvent.prototype.source;
/**
 * @param {!string} type
 * @param {!boolean=} bubbles
 * @param {!boolean=} cancelable
 * @param {*=} data
 * @param {!string=} origin
 * @param {!string=} lastEventId
 * @param {?MessageEventSource=} source
 * @param {!Array<!MessagePort>=} ports
 * @return {undefined}
 */
MessageEvent.prototype.initMessageEvent = function(type,bubbles,cancelable,data,origin,lastEventId,source,ports) {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function EXT_texture_compression_bptc() {}
/** @const {!GLenum} */ EXT_texture_compression_bptc.prototype.COMPRESSED_RGBA_BPTC_UNORM_EXT;
/** @const {!GLenum} */ EXT_texture_compression_bptc.prototype.COMPRESSED_RGB_BPTC_SIGNED_FLOAT_EXT;
/** @const {!GLenum} */ EXT_texture_compression_bptc.prototype.COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT_EXT;
/** @const {!GLenum} */ EXT_texture_compression_bptc.prototype.COMPRESSED_SRGB_ALPHA_BPTC_UNORM_EXT;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function MimeType() {}
/** @type {!string} */ MimeType.prototype.description;
/** @type {!Plugin} */ MimeType.prototype.enabledPlugin;
/** @type {!string} */ MimeType.prototype.suffixes;
/** @type {!string} */ MimeType.prototype.type;
/**
 * @constructor
 * @extends {Object}
 * @param {!string} url
 * @param {!string=} base
 */
function URL(url,base) {}
/** @type {!string} */ URL.prototype.origin;
/** @type {!URLSearchParams} */ URL.prototype.searchParams;
/** @type {!string} */ URL.prototype.hash;
/** @type {!string} */ URL.prototype.host;
/** @type {!string} */ URL.prototype.hostname;
/** @type {!string} */ URL.prototype.password;
/** @type {!string} */ URL.prototype.pathname;
/** @type {!string} */ URL.prototype.port;
/** @type {!string} */ URL.prototype.protocol;
/** @type {!string} */ URL.prototype.search;
/** @type {!string} */ URL.prototype.username;
/** @type {!string} */ URL.prototype.href;
/**
 * @param {!string} url
 * @return {undefined}
 */
URL.revokeObjectURL = function(url) {}
/**
 * @return {!string}
 * @override
 */
URL.prototype.toJSON = function() {}
/**
 * @param {(!Blob|!MediaSource)} arg0
 * @return {!string}
 */
URL.createObjectURL = function(arg0) {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function WEBGL_debug_shaders() {}
/**
 * @param {!WebGLShader} shader
 * @return {!string}
 * @nosideeffects
 */
WEBGL_debug_shaders.prototype.getTranslatedShaderSource = function(shader) {}
/**
 * @constructor
 * @private
 * @extends {SVGElement}
 * @nosideeffects
 */
function SVGFECompositeElement() {}
/** @const {!number} */ SVGFECompositeElement.SVG_FECOMPOSITE_OPERATOR_ARITHMETIC;
/** @const {!number} */ SVGFECompositeElement.prototype.SVG_FECOMPOSITE_OPERATOR_ARITHMETIC;
/** @const {!number} */ SVGFECompositeElement.SVG_FECOMPOSITE_OPERATOR_ATOP;
/** @const {!number} */ SVGFECompositeElement.prototype.SVG_FECOMPOSITE_OPERATOR_ATOP;
/** @const {!number} */ SVGFECompositeElement.SVG_FECOMPOSITE_OPERATOR_IN;
/** @const {!number} */ SVGFECompositeElement.prototype.SVG_FECOMPOSITE_OPERATOR_IN;
/** @const {!number} */ SVGFECompositeElement.SVG_FECOMPOSITE_OPERATOR_OUT;
/** @const {!number} */ SVGFECompositeElement.prototype.SVG_FECOMPOSITE_OPERATOR_OUT;
/** @const {!number} */ SVGFECompositeElement.SVG_FECOMPOSITE_OPERATOR_OVER;
/** @const {!number} */ SVGFECompositeElement.prototype.SVG_FECOMPOSITE_OPERATOR_OVER;
/** @const {!number} */ SVGFECompositeElement.SVG_FECOMPOSITE_OPERATOR_UNKNOWN;
/** @const {!number} */ SVGFECompositeElement.prototype.SVG_FECOMPOSITE_OPERATOR_UNKNOWN;
/** @const {!number} */ SVGFECompositeElement.SVG_FECOMPOSITE_OPERATOR_XOR;
/** @const {!number} */ SVGFECompositeElement.prototype.SVG_FECOMPOSITE_OPERATOR_XOR;
/** @type {!SVGAnimatedString} */ SVGFECompositeElement.prototype.in1;
/** @type {!SVGAnimatedString} */ SVGFECompositeElement.prototype.in2;
/** @type {!SVGAnimatedNumber} */ SVGFECompositeElement.prototype.k1;
/** @type {!SVGAnimatedNumber} */ SVGFECompositeElement.prototype.k2;
/** @type {!SVGAnimatedNumber} */ SVGFECompositeElement.prototype.k3;
/** @type {!SVGAnimatedNumber} */ SVGFECompositeElement.prototype.k4;
/** @type {!SVGAnimatedEnumeration} */ SVGFECompositeElement.prototype.operator;
/** @type {!SVGAnimatedLength} */ SVGFECompositeElement.prototype.height;
/** @type {!SVGAnimatedString} */ SVGFECompositeElement.prototype.result;
/** @type {!SVGAnimatedLength} */ SVGFECompositeElement.prototype.width;
/** @type {!SVGAnimatedLength} */ SVGFECompositeElement.prototype.x;
/** @type {!SVGAnimatedLength} */ SVGFECompositeElement.prototype.y;
/**
 * @constructor
 * @private
 * @extends {CSSRule}
 * @nosideeffects
 */
function CSSMarginRule() {}
/** @type {!CSSOMString} */ CSSMarginRule.prototype.name;
/** @type {!CSSStyleDeclaration} */ CSSMarginRule.prototype.style;
/**
 * @constructor
 * @private
 * @extends {EventTarget}
 * @nosideeffects
 */
function ServiceWorkerRegistration() {}
/** @type {?ServiceWorker} */ ServiceWorkerRegistration.prototype.active;
/** @type {?ServiceWorker} */ ServiceWorkerRegistration.prototype.installing;
/** @type {!NavigationPreloadManager} */ ServiceWorkerRegistration.prototype.navigationPreload;
/** @type {!string} */ ServiceWorkerRegistration.prototype.scope;
/** @type {!string} */ ServiceWorkerRegistration.prototype.updateViaCache;
/** @type {?ServiceWorker} */ ServiceWorkerRegistration.prototype.waiting;
/** @type {!NullableEventHandler} */ ServiceWorkerRegistration.prototype.onupdatefound;
/** @type {!SyncManager} */ ServiceWorkerRegistration.prototype.sync;
/** @type {!PushManager} */ ServiceWorkerRegistration.prototype.pushManager;
/**
 * @param {!GetNotificationOptions=} filter
 * @return {!Promise<!Array<!Notification>>}
 */
ServiceWorkerRegistration.prototype.getNotifications = function(filter) {}
/**
 * @return {!Promise<!boolean>}
 */
ServiceWorkerRegistration.prototype.unregister = function() {}
/**
 * @return {!Promise<undefined>}
 */
ServiceWorkerRegistration.prototype.update = function() {}
/**
 * @param {!string} title
 * @param {!NotificationOptions=} options
 * @return {!Promise<undefined>}
 */
ServiceWorkerRegistration.prototype.showNotification = function(title,options) {}
/**
 * @constructor
 * @private
 * @extends {EventTarget}
 * @nosideeffects
 */
function VisualViewport() {}
/** @type {!number} */ VisualViewport.prototype.height;
/** @type {!number} */ VisualViewport.prototype.offsetLeft;
/** @type {!number} */ VisualViewport.prototype.offsetTop;
/** @type {!number} */ VisualViewport.prototype.pageLeft;
/** @type {!number} */ VisualViewport.prototype.pageTop;
/** @type {!number} */ VisualViewport.prototype.scale;
/** @type {!Array<!DOMRect>} */ VisualViewport.prototype.segments;
/** @type {!number} */ VisualViewport.prototype.width;
/** @type {?EventHandler} */ VisualViewport.prototype.onresize;
/** @type {?EventHandler} */ VisualViewport.prototype.onscroll;
/**
 * @constructor
 * @private
 * @extends {SVGElement}
 * @nosideeffects
 */
function SVGMarkerElement() {}
/** @const {!number} */ SVGMarkerElement.SVG_MARKERUNITS_STROKEWIDTH;
/** @const {!number} */ SVGMarkerElement.prototype.SVG_MARKERUNITS_STROKEWIDTH;
/** @const {!number} */ SVGMarkerElement.SVG_MARKERUNITS_UNKNOWN;
/** @const {!number} */ SVGMarkerElement.prototype.SVG_MARKERUNITS_UNKNOWN;
/** @const {!number} */ SVGMarkerElement.SVG_MARKERUNITS_USERSPACEONUSE;
/** @const {!number} */ SVGMarkerElement.prototype.SVG_MARKERUNITS_USERSPACEONUSE;
/** @const {!number} */ SVGMarkerElement.SVG_MARKER_ORIENT_ANGLE;
/** @const {!number} */ SVGMarkerElement.prototype.SVG_MARKER_ORIENT_ANGLE;
/** @const {!number} */ SVGMarkerElement.SVG_MARKER_ORIENT_AUTO;
/** @const {!number} */ SVGMarkerElement.prototype.SVG_MARKER_ORIENT_AUTO;
/** @const {!number} */ SVGMarkerElement.SVG_MARKER_ORIENT_UNKNOWN;
/** @const {!number} */ SVGMarkerElement.prototype.SVG_MARKER_ORIENT_UNKNOWN;
/** @type {!SVGAnimatedLength} */ SVGMarkerElement.prototype.markerHeight;
/** @type {!SVGAnimatedEnumeration} */ SVGMarkerElement.prototype.markerUnits;
/** @type {!SVGAnimatedLength} */ SVGMarkerElement.prototype.markerWidth;
/** @type {!SVGAnimatedAngle} */ SVGMarkerElement.prototype.orientAngle;
/** @type {!SVGAnimatedEnumeration} */ SVGMarkerElement.prototype.orientType;
/** @type {!SVGAnimatedLength} */ SVGMarkerElement.prototype.refX;
/** @type {!SVGAnimatedLength} */ SVGMarkerElement.prototype.refY;
/** @type {!string} */ SVGMarkerElement.prototype.orient;
/** @type {!SVGAnimatedPreserveAspectRatio} */ SVGMarkerElement.prototype.preserveAspectRatio;
/** @type {!SVGAnimatedRect} */ SVGMarkerElement.prototype.viewBox;
/**
 * @param {!SVGAngle} angle
 * @return {undefined}
 */
SVGMarkerElement.prototype.setOrientToAngle = function(angle) {}
/**
 * @return {undefined}
 */
SVGMarkerElement.prototype.setOrientToAuto = function() {}
/**
 * @constructor
 * @private
 * @extends {HTMLElement}
 * @nosideeffects
 */
function HTMLMetaElement() {}
/** @type {!string} */ HTMLMetaElement.prototype.content;
/** @type {!string} */ HTMLMetaElement.prototype.httpEquiv;
/** @type {!string} */ HTMLMetaElement.prototype.media;
/** @type {!string} */ HTMLMetaElement.prototype.name;
/** @type {!string} */ HTMLMetaElement.prototype.scheme;
/**
 * @constructor
 * @extends {EventTarget}
 * @param {!string} scriptURL
 * @param {!WorkerOptions=} options
 */
function Worker(scriptURL,options) {}
/** @type {?MessageEventHandler} */ Worker.prototype.onmessage;
/** @type {?MessageEventHandler} */ Worker.prototype.onmessageerror;
/** @type {!NullableEventHandler} */ Worker.prototype.onerror;
/**
 * @param {*} arg0
 * @param {(!Array<!Transferable>|!PostMessageOptions)=} arg1
 * @return {undefined}
 */
Worker.prototype.postMessage = function(arg0,arg1) {}
/**
 * @return {undefined}
 */
Worker.prototype.terminate = function() {}
/**
 * @constructor
 * @private
 * @extends {SVGGraphicsElement}
 * @nosideeffects
 */
function SVGDefsElement() {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function SpeechRecognitionResultList() {}
/** @type {!number} */ SpeechRecognitionResultList.prototype.length;
/**
 * @param {!number} index
 * @return {!SpeechRecognitionResult}
 */
SpeechRecognitionResultList.prototype.item = function(index) {}
/**
 * @constructor
 * @private
 * @extends {HTMLElement}
 * @nosideeffects
 */
function HTMLDataListElement() {}
/** @type {!HTMLCollection} */ HTMLDataListElement.prototype.options;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function OffscreenCanvasRenderingContext2D() {}
/** @type {!OffscreenCanvas} */ OffscreenCanvasRenderingContext2D.prototype.canvas;
/** @type {StringOrCanvasGradientOrCanvasPatternUnion} */ OffscreenCanvasRenderingContext2D.prototype.fillStyle;
/** @type {StringOrCanvasGradientOrCanvasPatternUnion} */ OffscreenCanvasRenderingContext2D.prototype.strokeStyle;
/** @type {!boolean} */ OffscreenCanvasRenderingContext2D.prototype.imageSmoothingEnabled;
/** @type {!string} */ OffscreenCanvasRenderingContext2D.prototype.imageSmoothingQuality;
/** @type {!string} */ OffscreenCanvasRenderingContext2D.prototype.lineCap;
/** @type {!number} */ OffscreenCanvasRenderingContext2D.prototype.lineDashOffset;
/** @type {!string} */ OffscreenCanvasRenderingContext2D.prototype.lineJoin;
/** @type {!number} */ OffscreenCanvasRenderingContext2D.prototype.lineWidth;
/** @type {!number} */ OffscreenCanvasRenderingContext2D.prototype.miterLimit;
/** @type {!number} */ OffscreenCanvasRenderingContext2D.prototype.globalAlpha;
/** @type {!string} */ OffscreenCanvasRenderingContext2D.prototype.globalCompositeOperation;
/** @type {!string} */ OffscreenCanvasRenderingContext2D.prototype.filter;
/** @type {!string} */ OffscreenCanvasRenderingContext2D.prototype.direction;
/** @type {!string} */ OffscreenCanvasRenderingContext2D.prototype.font;
/** @type {!string} */ OffscreenCanvasRenderingContext2D.prototype.fontKerning;
/** @type {!string} */ OffscreenCanvasRenderingContext2D.prototype.fontStretch;
/** @type {!string} */ OffscreenCanvasRenderingContext2D.prototype.fontVariantCaps;
/** @type {!string} */ OffscreenCanvasRenderingContext2D.prototype.textAlign;
/** @type {!string} */ OffscreenCanvasRenderingContext2D.prototype.textBaseline;
/** @type {!number} */ OffscreenCanvasRenderingContext2D.prototype.textLetterSpacing;
/** @type {!string} */ OffscreenCanvasRenderingContext2D.prototype.textRendering;
/** @type {!number} */ OffscreenCanvasRenderingContext2D.prototype.textWordSpacing;
/** @type {!number} */ OffscreenCanvasRenderingContext2D.prototype.shadowBlur;
/** @type {!string} */ OffscreenCanvasRenderingContext2D.prototype.shadowColor;
/** @type {!number} */ OffscreenCanvasRenderingContext2D.prototype.shadowOffsetX;
/** @type {!number} */ OffscreenCanvasRenderingContext2D.prototype.shadowOffsetY;
/**
 * @param {!number} angle
 * @return {undefined}
 */
OffscreenCanvasRenderingContext2D.prototype.rotate = function(angle) {}
/**
 * @param {(!number|!ImageData)} arg0
 * @param {!number=} arg1
 * @param {!ImageDataSettings=} arg2
 * @return {!ImageData}
 * @nosideeffects
 */
OffscreenCanvasRenderingContext2D.prototype.createImageData = function(arg0,arg1,arg2) {}
/**
 * @return {undefined}
 */
OffscreenCanvasRenderingContext2D.prototype.closePath = function() {}
/**
 * @return {undefined}
 */
OffscreenCanvasRenderingContext2D.prototype.save = function() {}
/**
 * @return {undefined}
 */
OffscreenCanvasRenderingContext2D.prototype.commit = function() {}
/**
 * @param {!number} x
 * @param {!number} y
 * @return {undefined}
 */
OffscreenCanvasRenderingContext2D.prototype.lineTo = function(x,y) {}
/**
 * @param {!number} x
 * @param {!number} y
 * @return {undefined}
 */
OffscreenCanvasRenderingContext2D.prototype.scale = function(x,y) {}
/**
 * @param {!string} text
 * @return {!TextMetrics}
 * @nosideeffects
 */
OffscreenCanvasRenderingContext2D.prototype.measureText = function(text) {}
/**
 * @param {!Array<!number>} segments
 * @return {undefined}
 */
OffscreenCanvasRenderingContext2D.prototype.setLineDash = function(segments) {}
/**
 * @param {!number} x
 * @param {!number} y
 * @param {!number} w
 * @param {!number} h
 * @return {undefined}
 */
OffscreenCanvasRenderingContext2D.prototype.fillRect = function(x,y,w,h) {}
/**
 * @param {!ImageData} arg0
 * @param {!number} arg1
 * @param {!number} arg2
 * @param {!number=} arg3
 * @param {!number=} arg4
 * @param {!number=} arg5
 * @param {!number=} arg6
 * @return {undefined}
 */
OffscreenCanvasRenderingContext2D.prototype.putImageData = function(arg0,arg1,arg2,arg3,arg4,arg5,arg6) {}
/**
 * @param {!number} x
 * @param {!number} y
 * @return {undefined}
 */
OffscreenCanvasRenderingContext2D.prototype.translate = function(x,y) {}
/**
 * @param {!number} x
 * @param {!number} y
 * @param {!number} w
 * @param {!number} h
 * @return {undefined}
 */
OffscreenCanvasRenderingContext2D.prototype.rect = function(x,y,w,h) {}
/**
 * @param {!number} a
 * @param {!number} b
 * @param {!number} c
 * @param {!number} d
 * @param {!number} e
 * @param {!number} f
 * @return {undefined}
 */
OffscreenCanvasRenderingContext2D.prototype.transform = function(a,b,c,d,e,f) {}
/**
 * @param {!number} x
 * @param {!number} y
 * @param {!number} radius
 * @param {!number} startAngle
 * @param {!number} endAngle
 * @param {!boolean=} counterclockwise
 * @return {undefined}
 */
OffscreenCanvasRenderingContext2D.prototype.arc = function(x,y,radius,startAngle,endAngle,counterclockwise) {}
/**
 * @param {(!number|!DOMMatrix2DInit)=} arg0
 * @param {!number=} arg1
 * @param {!number=} arg2
 * @param {!number=} arg3
 * @param {!number=} arg4
 * @param {!number=} arg5
 * @return {undefined}
 */
OffscreenCanvasRenderingContext2D.prototype.setTransform = function(arg0,arg1,arg2,arg3,arg4,arg5) {}
/**
 * @param {(!number|!Path2D)} arg0
 * @param {!number} arg1
 * @param {(!string|!number)=} arg2
 * @param {!string=} arg3
 * @return {!boolean}
 * @nosideeffects
 */
OffscreenCanvasRenderingContext2D.prototype.isPointInPath = function(arg0,arg1,arg2,arg3) {}
/**
 * @param {!number} x
 * @param {!number} y
 * @param {!number} radiusX
 * @param {!number} radiusY
 * @param {!number} rotation
 * @param {!number} startAngle
 * @param {!number} endAngle
 * @param {!boolean=} counterclockwise
 * @return {undefined}
 */
OffscreenCanvasRenderingContext2D.prototype.ellipse = function(x,y,radiusX,radiusY,rotation,startAngle,endAngle,counterclockwise) {}
/**
 * @param {!number} x0
 * @param {!number} y0
 * @param {!number} r0
 * @param {!number} x1
 * @param {!number} y1
 * @param {!number} r1
 * @return {!CanvasGradient}
 */
OffscreenCanvasRenderingContext2D.prototype.createRadialGradient = function(x0,y0,r0,x1,y1,r1) {}
/**
 * @param {!number} x
 * @param {!number} y
 * @param {!number} w
 * @param {!number} h
 * @return {undefined}
 */
OffscreenCanvasRenderingContext2D.prototype.strokeRect = function(x,y,w,h) {}
/**
 * @param {!string} text
 * @param {!number} x
 * @param {!number} y
 * @param {!number=} maxWidth
 * @return {undefined}
 */
OffscreenCanvasRenderingContext2D.prototype.fillText = function(text,x,y,maxWidth) {}
/**
 * @return {!DOMMatrix}
 */
OffscreenCanvasRenderingContext2D.prototype.getTransform = function() {}
/**
 * @param {!number} x
 * @param {!number} y
 * @param {!number} w
 * @param {!number} h
 * @param {!Array<UnrestrictedDoubleOrDOMPointInitUnion>} radii
 * @return {undefined}
 */
OffscreenCanvasRenderingContext2D.prototype.roundRect = function(x,y,w,h,radii) {}
/**
 * @param {!number} x1
 * @param {!number} y1
 * @param {!number} x2
 * @param {!number} y2
 * @param {!number} radius
 * @return {undefined}
 */
OffscreenCanvasRenderingContext2D.prototype.arcTo = function(x1,y1,x2,y2,radius) {}
/**
 * @param {!number} sx
 * @param {!number} sy
 * @param {!number} sw
 * @param {!number} sh
 * @param {!ImageDataSettings=} settings
 * @return {!ImageData}
 */
OffscreenCanvasRenderingContext2D.prototype.getImageData = function(sx,sy,sw,sh,settings) {}
/**
 * @param {!string} text
 * @param {!number} x
 * @param {!number} y
 * @param {!number=} maxWidth
 * @return {undefined}
 */
OffscreenCanvasRenderingContext2D.prototype.strokeText = function(text,x,y,maxWidth) {}
/**
 * @return {undefined}
 */
OffscreenCanvasRenderingContext2D.prototype.restore = function() {}
/**
 * @return {undefined}
 */
OffscreenCanvasRenderingContext2D.prototype.beginPath = function() {}
/**
 * @return {undefined}
 */
OffscreenCanvasRenderingContext2D.prototype.resetTransform = function() {}
/**
 * @param {!number} cpx
 * @param {!number} cpy
 * @param {!number} x
 * @param {!number} y
 * @return {undefined}
 */
OffscreenCanvasRenderingContext2D.prototype.quadraticCurveTo = function(cpx,cpy,x,y) {}
/**
 * @param {!number} cp1x
 * @param {!number} cp1y
 * @param {!number} cp2x
 * @param {!number} cp2y
 * @param {!number} x
 * @param {!number} y
 * @return {undefined}
 */
OffscreenCanvasRenderingContext2D.prototype.bezierCurveTo = function(cp1x,cp1y,cp2x,cp2y,x,y) {}
/**
 * @param {(!string|!Path2D)=} arg0
 * @param {!string=} arg1
 * @return {undefined}
 */
OffscreenCanvasRenderingContext2D.prototype.fill = function(arg0,arg1) {}
/**
 * @param {!Path2D=} arg0
 * @return {undefined}
 */
OffscreenCanvasRenderingContext2D.prototype.stroke = function(arg0) {}
/**
 * @param {!number} x
 * @param {!number} y
 * @param {!number} w
 * @param {!number} h
 * @return {undefined}
 */
OffscreenCanvasRenderingContext2D.prototype.clearRect = function(x,y,w,h) {}
/**
 * @return {!Array<!number>}
 */
OffscreenCanvasRenderingContext2D.prototype.getLineDash = function() {}
/**
 * @param {!CanvasImageSource} arg0
 * @param {!number} arg1
 * @param {!number} arg2
 * @param {!number=} arg3
 * @param {!number=} arg4
 * @param {!number=} arg5
 * @param {!number=} arg6
 * @param {!number=} arg7
 * @param {!number=} arg8
 * @return {undefined}
 */
OffscreenCanvasRenderingContext2D.prototype.drawImage = function(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8) {}
/**
 * @param {!CanvasImageSource} image
 * @param {!string} repetition
 * @return {?CanvasPattern}
 */
OffscreenCanvasRenderingContext2D.prototype.createPattern = function(image,repetition) {}
/**
 * @param {(!number|!Path2D)} arg0
 * @param {!number} arg1
 * @param {!number=} arg2
 * @return {!boolean}
 * @nosideeffects
 */
OffscreenCanvasRenderingContext2D.prototype.isPointInStroke = function(arg0,arg1,arg2) {}
/**
 * @return {undefined}
 */
OffscreenCanvasRenderingContext2D.prototype.reset = function() {}
/**
 * @param {(!string|!Path2D)=} arg0
 * @param {!string=} arg1
 * @return {undefined}
 */
OffscreenCanvasRenderingContext2D.prototype.clip = function(arg0,arg1) {}
/**
 * @param {!number} x
 * @param {!number} y
 * @return {undefined}
 */
OffscreenCanvasRenderingContext2D.prototype.moveTo = function(x,y) {}
/**
 * @param {!number} x0
 * @param {!number} y0
 * @param {!number} x1
 * @param {!number} y1
 * @return {!CanvasGradient}
 */
OffscreenCanvasRenderingContext2D.prototype.createLinearGradient = function(x0,y0,x1,y1) {}
/**
 * @param {!number} startAngle
 * @param {!number} x
 * @param {!number} y
 * @return {!CanvasGradient}
 */
OffscreenCanvasRenderingContext2D.prototype.createConicGradient = function(startAngle,x,y) {}
/**
 * @constructor
 * @private
 * @extends {SVGElement}
 * @nosideeffects
 */
function SVGFETileElement() {}
/** @type {!SVGAnimatedString} */ SVGFETileElement.prototype.in1;
/** @type {!SVGAnimatedLength} */ SVGFETileElement.prototype.height;
/** @type {!SVGAnimatedString} */ SVGFETileElement.prototype.result;
/** @type {!SVGAnimatedLength} */ SVGFETileElement.prototype.width;
/** @type {!SVGAnimatedLength} */ SVGFETileElement.prototype.x;
/** @type {!SVGAnimatedLength} */ SVGFETileElement.prototype.y;
/**
 * @constructor
 * @extends {DOMMatrixReadOnly}
 * @param {(!string|!Array<!number>)=} init
 */
function DOMMatrix(init) {}
/** @type {!number} */ DOMMatrix.prototype.a;
/** @type {!number} */ DOMMatrix.prototype.b;
/** @type {!number} */ DOMMatrix.prototype.c;
/** @type {!number} */ DOMMatrix.prototype.d;
/** @type {!number} */ DOMMatrix.prototype.e;
/** @type {!number} */ DOMMatrix.prototype.f;
/** @type {!number} */ DOMMatrix.prototype.m11;
/** @type {!number} */ DOMMatrix.prototype.m12;
/** @type {!number} */ DOMMatrix.prototype.m13;
/** @type {!number} */ DOMMatrix.prototype.m14;
/** @type {!number} */ DOMMatrix.prototype.m21;
/** @type {!number} */ DOMMatrix.prototype.m22;
/** @type {!number} */ DOMMatrix.prototype.m23;
/** @type {!number} */ DOMMatrix.prototype.m24;
/** @type {!number} */ DOMMatrix.prototype.m31;
/** @type {!number} */ DOMMatrix.prototype.m32;
/** @type {!number} */ DOMMatrix.prototype.m33;
/** @type {!number} */ DOMMatrix.prototype.m34;
/** @type {!number} */ DOMMatrix.prototype.m41;
/** @type {!number} */ DOMMatrix.prototype.m42;
/** @type {!number} */ DOMMatrix.prototype.m43;
/** @type {!number} */ DOMMatrix.prototype.m44;
/**
 * @param {!DOMMatrixInit=} other
 * @return {!DOMMatrix}
 */
DOMMatrix.prototype.preMultiplySelf = function(other) {}
/**
 * @param {!number=} scaleX
 * @param {!number=} scaleY
 * @param {!number=} scaleZ
 * @param {!number=} originX
 * @param {!number=} originY
 * @param {!number=} originZ
 * @return {!DOMMatrix}
 */
DOMMatrix.prototype.scaleSelf = function(scaleX,scaleY,scaleZ,originX,originY,originZ) {}
/**
 * @param {!number=} x
 * @param {!number=} y
 * @param {!number=} z
 * @param {!number=} angle
 * @return {!DOMMatrix}
 */
DOMMatrix.prototype.rotateAxisAngleSelf = function(x,y,z,angle) {}
/**
 * @param {!number=} tx
 * @param {!number=} ty
 * @param {!number=} tz
 * @return {!DOMMatrix}
 */
DOMMatrix.prototype.translateSelf = function(tx,ty,tz) {}
/**
 * @param {!DOMMatrixInit=} other
 * @return {!DOMMatrix}
 */
DOMMatrix.prototype.multiplySelf = function(other) {}
/**
 * @param {!number=} rotX
 * @param {!number=} rotY
 * @param {!number=} rotZ
 * @return {!DOMMatrix}
 */
DOMMatrix.prototype.rotateSelf = function(rotX,rotY,rotZ) {}
/**
 * @param {!number=} scale
 * @param {!number=} originX
 * @param {!number=} originY
 * @param {!number=} originZ
 * @return {!DOMMatrix}
 */
DOMMatrix.prototype.scale3dSelf = function(scale,originX,originY,originZ) {}
/**
 * @param {!DOMMatrixInit=} other
 * @return {!DOMMatrix}
 */
DOMMatrix.fromMatrix = function(other) {}
/**
 * @param {!Float64Array} array64
 * @return {!DOMMatrix}
 */
DOMMatrix.fromFloat64Array = function(array64) {}
/**
 * @param {!number=} sy
 * @return {!DOMMatrix}
 */
DOMMatrix.prototype.skewYSelf = function(sy) {}
/**
 * @param {!number=} x
 * @param {!number=} y
 * @return {!DOMMatrix}
 */
DOMMatrix.prototype.rotateFromVectorSelf = function(x,y) {}
/**
 * @param {!Float32Array} array32
 * @return {!DOMMatrix}
 */
DOMMatrix.fromFloat32Array = function(array32) {}
/**
 * @param {!number=} sx
 * @return {!DOMMatrix}
 */
DOMMatrix.prototype.skewXSelf = function(sx) {}
/**
 * @param {!string} transformList
 * @return {!DOMMatrix}
 */
DOMMatrix.prototype.setMatrixValue = function(transformList) {}
/**
 * @return {!DOMMatrix}
 */
DOMMatrix.prototype.invertSelf = function() {}
/**
 * @constructor
 * @extends {Event}
 * @param {!string} type
 * @param {!UIEventInit=} eventInitDict
 */
function UIEvent(type,eventInitDict) {}
/** @type {!number} */ UIEvent.prototype.detail;
/** @type {?Window} */ UIEvent.prototype.view;
/** @type {!number} */ UIEvent.prototype.which;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function WebGLUniformLocation() {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function GPUCanvasContext() {}
/** @type {HTMLCanvasElementOrOffscreenCanvasUnion} */ GPUCanvasContext.prototype.canvas;
/**
 * @param {!GPUAdapter} adapter
 * @return {!string}
 */
GPUCanvasContext.prototype.getPreferredFormat = function(adapter) {}
/**
 * @return {!GPUTexture}
 */
GPUCanvasContext.prototype.getCurrentTexture = function() {}
/**
 * @param {!GPUCanvasConfiguration} configuration
 * @return {undefined}
 */
GPUCanvasContext.prototype.configure = function(configuration) {}
/**
 * @return {undefined}
 */
GPUCanvasContext.prototype.unconfigure = function() {}
/**
 * @constructor
 * @extends {Object}
 * @param {!number=} x
 * @param {!number=} y
 * @param {!number=} width
 * @param {!number=} height
 */
function DOMRectReadOnly(x,y,width,height) {}
/** @type {!number} */ DOMRectReadOnly.prototype.bottom;
/** @type {!number} */ DOMRectReadOnly.prototype.height;
/** @type {!number} */ DOMRectReadOnly.prototype.left;
/** @type {!number} */ DOMRectReadOnly.prototype.right;
/** @type {!number} */ DOMRectReadOnly.prototype.top;
/** @type {!number} */ DOMRectReadOnly.prototype.width;
/** @type {!number} */ DOMRectReadOnly.prototype.x;
/** @type {!number} */ DOMRectReadOnly.prototype.y;
/**
 * @param {!DOMRectInit=} other
 * @return {!DOMRectReadOnly}
 */
DOMRectReadOnly.fromRect = function(other) {}
/**
 * @return {!Object}
 * @override
 */
DOMRectReadOnly.prototype.toJSON = function() {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function SVGLength() {}
/** @const {!number} */ SVGLength.SVG_LENGTHTYPE_CM;
/** @const {!number} */ SVGLength.prototype.SVG_LENGTHTYPE_CM;
/** @const {!number} */ SVGLength.SVG_LENGTHTYPE_EMS;
/** @const {!number} */ SVGLength.prototype.SVG_LENGTHTYPE_EMS;
/** @const {!number} */ SVGLength.SVG_LENGTHTYPE_EXS;
/** @const {!number} */ SVGLength.prototype.SVG_LENGTHTYPE_EXS;
/** @const {!number} */ SVGLength.SVG_LENGTHTYPE_IN;
/** @const {!number} */ SVGLength.prototype.SVG_LENGTHTYPE_IN;
/** @const {!number} */ SVGLength.SVG_LENGTHTYPE_MM;
/** @const {!number} */ SVGLength.prototype.SVG_LENGTHTYPE_MM;
/** @const {!number} */ SVGLength.SVG_LENGTHTYPE_NUMBER;
/** @const {!number} */ SVGLength.prototype.SVG_LENGTHTYPE_NUMBER;
/** @const {!number} */ SVGLength.SVG_LENGTHTYPE_PC;
/** @const {!number} */ SVGLength.prototype.SVG_LENGTHTYPE_PC;
/** @const {!number} */ SVGLength.SVG_LENGTHTYPE_PERCENTAGE;
/** @const {!number} */ SVGLength.prototype.SVG_LENGTHTYPE_PERCENTAGE;
/** @const {!number} */ SVGLength.SVG_LENGTHTYPE_PT;
/** @const {!number} */ SVGLength.prototype.SVG_LENGTHTYPE_PT;
/** @const {!number} */ SVGLength.SVG_LENGTHTYPE_PX;
/** @const {!number} */ SVGLength.prototype.SVG_LENGTHTYPE_PX;
/** @const {!number} */ SVGLength.SVG_LENGTHTYPE_UNKNOWN;
/** @const {!number} */ SVGLength.prototype.SVG_LENGTHTYPE_UNKNOWN;
/** @type {!number} */ SVGLength.prototype.unitType;
/** @type {!number} */ SVGLength.prototype.value;
/** @type {!string} */ SVGLength.prototype.valueAsString;
/** @type {!number} */ SVGLength.prototype.valueInSpecifiedUnits;
/**
 * @param {!number} unitType
 * @return {undefined}
 */
SVGLength.prototype.convertToSpecifiedUnits = function(unitType) {}
/**
 * @param {!number} unitType
 * @param {!number} valueInSpecifiedUnits
 * @return {undefined}
 */
SVGLength.prototype.newValueSpecifiedUnits = function(unitType,valueInSpecifiedUnits) {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function EXT_texture_compression_rgtc() {}
/** @const {!GLenum} */ EXT_texture_compression_rgtc.prototype.COMPRESSED_RED_GREEN_RGTC2_EXT;
/** @const {!GLenum} */ EXT_texture_compression_rgtc.prototype.COMPRESSED_RED_RGTC1_EXT;
/** @const {!GLenum} */ EXT_texture_compression_rgtc.prototype.COMPRESSED_SIGNED_RED_GREEN_RGTC2_EXT;
/** @const {!GLenum} */ EXT_texture_compression_rgtc.prototype.COMPRESSED_SIGNED_RED_RGTC1_EXT;
/**
 * @constructor
 * @private
 * @extends {EventTarget}
 * @nosideeffects
 */
function XMLHttpRequestEventTarget() {}
/** @type {!NullableEventHandler} */ XMLHttpRequestEventTarget.prototype.onabort;
/** @type {!NullableEventHandler} */ XMLHttpRequestEventTarget.prototype.onerror;
/** @type {!NullableEventHandler} */ XMLHttpRequestEventTarget.prototype.onload;
/** @type {!NullableEventHandler} */ XMLHttpRequestEventTarget.prototype.onloadend;
/** @type {!NullableEventHandler} */ XMLHttpRequestEventTarget.prototype.onloadstart;
/** @type {!NullableEventHandler} */ XMLHttpRequestEventTarget.prototype.onprogress;
/** @type {!NullableEventHandler} */ XMLHttpRequestEventTarget.prototype.ontimeout;
/**
 * @constructor
 * @private
 * @extends {XMLHttpRequestEventTarget}
 * @nosideeffects
 */
function XMLHttpRequestUpload() {}
/**
 * @constructor
 * @extends {CharacterData}
 * @param {!string=} data
 */
function Text(data) {}
/** @type {!string} */ Text.prototype.wholeText;
/** @type {?HTMLSlotElement} */ Text.prototype.assignedSlot;
/**
 * @param {!number} offset
 * @return {!Text}
 */
Text.prototype.splitText = function(offset) {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function AuthenticatorResponse() {}
/** @type {!ArrayBuffer} */ AuthenticatorResponse.prototype.clientDataJSON;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function SVGPreserveAspectRatio() {}
/** @const {!number} */ SVGPreserveAspectRatio.SVG_MEETORSLICE_MEET;
/** @const {!number} */ SVGPreserveAspectRatio.prototype.SVG_MEETORSLICE_MEET;
/** @const {!number} */ SVGPreserveAspectRatio.SVG_MEETORSLICE_SLICE;
/** @const {!number} */ SVGPreserveAspectRatio.prototype.SVG_MEETORSLICE_SLICE;
/** @const {!number} */ SVGPreserveAspectRatio.SVG_MEETORSLICE_UNKNOWN;
/** @const {!number} */ SVGPreserveAspectRatio.prototype.SVG_MEETORSLICE_UNKNOWN;
/** @const {!number} */ SVGPreserveAspectRatio.SVG_PRESERVEASPECTRATIO_NONE;
/** @const {!number} */ SVGPreserveAspectRatio.prototype.SVG_PRESERVEASPECTRATIO_NONE;
/** @const {!number} */ SVGPreserveAspectRatio.SVG_PRESERVEASPECTRATIO_UNKNOWN;
/** @const {!number} */ SVGPreserveAspectRatio.prototype.SVG_PRESERVEASPECTRATIO_UNKNOWN;
/** @const {!number} */ SVGPreserveAspectRatio.SVG_PRESERVEASPECTRATIO_XMAXYMAX;
/** @const {!number} */ SVGPreserveAspectRatio.prototype.SVG_PRESERVEASPECTRATIO_XMAXYMAX;
/** @const {!number} */ SVGPreserveAspectRatio.SVG_PRESERVEASPECTRATIO_XMAXYMID;
/** @const {!number} */ SVGPreserveAspectRatio.prototype.SVG_PRESERVEASPECTRATIO_XMAXYMID;
/** @const {!number} */ SVGPreserveAspectRatio.SVG_PRESERVEASPECTRATIO_XMAXYMIN;
/** @const {!number} */ SVGPreserveAspectRatio.prototype.SVG_PRESERVEASPECTRATIO_XMAXYMIN;
/** @const {!number} */ SVGPreserveAspectRatio.SVG_PRESERVEASPECTRATIO_XMIDYMAX;
/** @const {!number} */ SVGPreserveAspectRatio.prototype.SVG_PRESERVEASPECTRATIO_XMIDYMAX;
/** @const {!number} */ SVGPreserveAspectRatio.SVG_PRESERVEASPECTRATIO_XMIDYMID;
/** @const {!number} */ SVGPreserveAspectRatio.prototype.SVG_PRESERVEASPECTRATIO_XMIDYMID;
/** @const {!number} */ SVGPreserveAspectRatio.SVG_PRESERVEASPECTRATIO_XMIDYMIN;
/** @const {!number} */ SVGPreserveAspectRatio.prototype.SVG_PRESERVEASPECTRATIO_XMIDYMIN;
/** @const {!number} */ SVGPreserveAspectRatio.SVG_PRESERVEASPECTRATIO_XMINYMAX;
/** @const {!number} */ SVGPreserveAspectRatio.prototype.SVG_PRESERVEASPECTRATIO_XMINYMAX;
/** @const {!number} */ SVGPreserveAspectRatio.SVG_PRESERVEASPECTRATIO_XMINYMID;
/** @const {!number} */ SVGPreserveAspectRatio.prototype.SVG_PRESERVEASPECTRATIO_XMINYMID;
/** @const {!number} */ SVGPreserveAspectRatio.SVG_PRESERVEASPECTRATIO_XMINYMIN;
/** @const {!number} */ SVGPreserveAspectRatio.prototype.SVG_PRESERVEASPECTRATIO_XMINYMIN;
/** @type {!number} */ SVGPreserveAspectRatio.prototype.align;
/** @type {!number} */ SVGPreserveAspectRatio.prototype.meetOrSlice;
/**
 * @constructor
 * @private
 * @extends {HTMLElement}
 * @nosideeffects
 */
function HTMLDListElement() {}
/** @type {!boolean} */ HTMLDListElement.prototype.compact;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function CaretPosition() {}
/** @type {!number} */ CaretPosition.prototype.offset;
/** @type {!Node} */ CaretPosition.prototype.offsetNode;
/**
 * @return {?DOMRect}
 */
CaretPosition.prototype.getClientRect = function() {}
/**
 * @constructor
 * @private
 * @extends {EventTarget}
 * @nosideeffects
 */
function ServiceWorker() {}
/** @type {!string} */ ServiceWorker.prototype.scriptURL;
/** @type {!string} */ ServiceWorker.prototype.state;
/** @type {!NullableEventHandler} */ ServiceWorker.prototype.onstatechange;
/** @type {!NullableEventHandler} */ ServiceWorker.prototype.onerror;
/**
 * @param {*} arg0
 * @param {(!Array<!Transferable>|!PostMessageOptions)=} arg1
 * @return {undefined}
 */
ServiceWorker.prototype.postMessage = function(arg0,arg1) {}
/**
 * @constructor
 * @extends {Object}
 * @param {!VideoEncoderInit} init
 */
function VideoEncoder(init) {}
/** @type {!number} */ VideoEncoder.prototype.encodeQueueSize;
/** @type {!string} */ VideoEncoder.prototype.state;
/**
 * @param {!VideoFrame} frame
 * @param {!VideoEncoderEncodeOptions=} options
 * @return {undefined}
 */
VideoEncoder.prototype.encode = function(frame,options) {}
/**
 * @return {!Promise<undefined>}
 */
VideoEncoder.prototype.flush = function() {}
/**
 * @return {undefined}
 */
VideoEncoder.prototype.reset = function() {}
/**
 * @param {!VideoEncoderConfig} config
 * @return {undefined}
 */
VideoEncoder.prototype.configure = function(config) {}
/**
 * @return {undefined}
 */
VideoEncoder.prototype.close = function() {}
/**
 * @param {!VideoEncoderConfig} config
 * @return {!Promise<!boolean>}
 */
VideoEncoder.isConfigSupported = function(config) {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function OES_texture_half_float_linear() {}
/**
 * @constructor
 * @extends {Event}
 * @param {!CSSOMString} type
 * @param {!MediaQueryListEventInit=} eventInitDict
 */
function MediaQueryListEvent(type,eventInitDict) {}
/** @type {!boolean} */ MediaQueryListEvent.prototype.matches;
/** @type {!CSSOMString} */ MediaQueryListEvent.prototype.media;
/**
 * @constructor
 * @private
 * @extends {EventTarget}
 * @nosideeffects
 */
function Animation() {}
/** @type {!Promise<!Animation>} */ Animation.prototype.finished;
/** @type {!boolean} */ Animation.prototype.pending;
/** @type {!string} */ Animation.prototype.playState;
/** @type {!Promise<!Animation>} */ Animation.prototype.ready;
/** @type {!string} */ Animation.prototype.replaceState;
/** @type {?number} */ Animation.prototype.currentTime;
/** @type {?AnimationEffect} */ Animation.prototype.effect;
/** @type {!string} */ Animation.prototype.id;
/** @type {!NullableEventHandler} */ Animation.prototype.oncancel;
/** @type {!NullableEventHandler} */ Animation.prototype.onfinish;
/** @type {!NullableEventHandler} */ Animation.prototype.onremove;
/** @type {!number} */ Animation.prototype.playbackRate;
/** @type {?number} */ Animation.prototype.startTime;
/** @type {?AnimationTimeline} */ Animation.prototype.timeline;
/**
 * @return {undefined}
 */
Animation.prototype.play = function() {}
/**
 * @return {undefined}
 */
Animation.prototype.cancel = function() {}
/**
 * @param {!number} playbackRate
 * @return {undefined}
 */
Animation.prototype.updatePlaybackRate = function(playbackRate) {}
/**
 * @return {undefined}
 */
Animation.prototype.commitStyles = function() {}
/**
 * @return {undefined}
 */
Animation.prototype.finish = function() {}
/**
 * @return {undefined}
 */
Animation.prototype.persist = function() {}
/**
 * @return {undefined}
 */
Animation.prototype.reverse = function() {}
/**
 * @return {undefined}
 */
Animation.prototype.pause = function() {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function ImageBitmapRenderingContext() {}
/** @type {HTMLCanvasElementOrOffscreenCanvasUnion} */ ImageBitmapRenderingContext.prototype.canvas;
/**
 * @param {?ImageBitmap} bitmap
 * @return {undefined}
 */
ImageBitmapRenderingContext.prototype.transferFromImageBitmap = function(bitmap) {}
/**
 * @constructor
 * @private
 * @extends {EventTarget}
 * @nosideeffects
 */
function Clipboard() {}
/**
 * @param {!string} data
 * @return {!Promise<undefined>}
 */
Clipboard.prototype.writeText = function(data) {}
/**
 * @return {!Promise<!ClipboardItems>}
 */
Clipboard.prototype.read = function() {}
/**
 * @return {!Promise<!string>}
 */
Clipboard.prototype.readText = function() {}
/**
 * @param {!ClipboardItems} data
 * @return {!Promise<undefined>}
 */
Clipboard.prototype.write = function(data) {}
/**
 * @constructor
 * @private
 * @extends {SVGElement}
 * @nosideeffects
 */
function SVGFEPointLightElement() {}
/** @type {!SVGAnimatedNumber} */ SVGFEPointLightElement.prototype.x;
/** @type {!SVGAnimatedNumber} */ SVGFEPointLightElement.prototype.y;
/** @type {!SVGAnimatedNumber} */ SVGFEPointLightElement.prototype.z;
/**
 * @constructor
 * @extends {AudioNode}
 * @param {!BaseAudioContext} context
 * @param {!DelayOptions=} options
 */
function DelayNode(context,options) {}
/** @type {!AudioParam} */ DelayNode.prototype.delayTime;
/**
 * @constructor
 * @private
 * @extends {IDBCursor}
 * @nosideeffects
 */
function IDBCursorWithValue() {}
/** @type {*} */ IDBCursorWithValue.prototype.value;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function EXT_disjoint_timer_query() {}
/** @const {!GLenum} */ EXT_disjoint_timer_query.prototype.CURRENT_QUERY_EXT;
/** @const {!GLenum} */ EXT_disjoint_timer_query.prototype.GPU_DISJOINT_EXT;
/** @const {!GLenum} */ EXT_disjoint_timer_query.prototype.QUERY_COUNTER_BITS_EXT;
/** @const {!GLenum} */ EXT_disjoint_timer_query.prototype.QUERY_RESULT_AVAILABLE_EXT;
/** @const {!GLenum} */ EXT_disjoint_timer_query.prototype.QUERY_RESULT_EXT;
/** @const {!GLenum} */ EXT_disjoint_timer_query.prototype.TIMESTAMP_EXT;
/** @const {!GLenum} */ EXT_disjoint_timer_query.prototype.TIME_ELAPSED_EXT;
/**
 * @param {!GLenum} target
 * @return {undefined}
 */
EXT_disjoint_timer_query.prototype.endQueryEXT = function(target) {}
/**
 * @param {!WebGLTimerQueryEXT} query
 * @param {!GLenum} target
 * @return {undefined}
 */
EXT_disjoint_timer_query.prototype.queryCounterEXT = function(query,target) {}
/**
 * @param {?WebGLTimerQueryEXT} query
 * @return {undefined}
 */
EXT_disjoint_timer_query.prototype.deleteQueryEXT = function(query) {}
/**
 * @return {?WebGLTimerQueryEXT}
 */
EXT_disjoint_timer_query.prototype.createQueryEXT = function() {}
/**
 * @param {!GLenum} target
 * @param {!WebGLTimerQueryEXT} query
 * @return {undefined}
 */
EXT_disjoint_timer_query.prototype.beginQueryEXT = function(target,query) {}
/**
 * @param {!WebGLTimerQueryEXT} query
 * @param {!GLenum} pname
 * @return {*}
 */
EXT_disjoint_timer_query.prototype.getQueryObjectEXT = function(query,pname) {}
/**
 * @param {?WebGLTimerQueryEXT} query
 * @return {!boolean}
 */
EXT_disjoint_timer_query.prototype.isQueryEXT = function(query) {}
/**
 * @param {!GLenum} target
 * @param {!GLenum} pname
 * @return {*}
 */
EXT_disjoint_timer_query.prototype.getQueryEXT = function(target,pname) {}
/**
 * @constructor
 * @extends {Event}
 * @param {!string} type
 * @param {!CustomEventInit=} eventInitDict
 */
function CustomEvent(type,eventInitDict) {}
/** @type {*} */ CustomEvent.prototype.detail;
/**
 * @param {!string} type
 * @param {!boolean=} bubbles
 * @param {!boolean=} cancelable
 * @param {*=} detail
 * @return {undefined}
 */
CustomEvent.prototype.initCustomEvent = function(type,bubbles,cancelable,detail) {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function MediaList() {}
/** @type {!number} */ MediaList.prototype.length;
/** @type {!CSSOMString} */ MediaList.prototype.mediaText;
/**
 * @param {!number} index
 * @return {?CSSOMString}
 */
MediaList.prototype.item = function(index) {}
/**
 * @param {!CSSOMString} medium
 * @return {undefined}
 */
MediaList.prototype.deleteMedium = function(medium) {}
/**
 * @param {!CSSOMString} medium
 * @return {undefined}
 */
MediaList.prototype.appendMedium = function(medium) {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function HTMLFormControlsCollection() {}
/** @type {!number} */ HTMLFormControlsCollection.prototype.length;
/**
 * @param {!string} name
 * @return {RadioNodeListOrElementUnion}
 * @nosideeffects
 */
HTMLFormControlsCollection.prototype.namedItem = function(name) {}
/**
 * @param {!number} index
 * @return {RadioNodeListOrElementUnion}
 */
HTMLFormControlsCollection.prototype.item = function(index) {}
/**
 * @constructor
 * @private
 * @extends {HTMLElement}
 * @nosideeffects
 */
function HTMLOListElement() {}
/** @type {!boolean} */ HTMLOListElement.prototype.reversed;
/** @type {!number} */ HTMLOListElement.prototype.start;
/** @type {!string} */ HTMLOListElement.prototype.type;
/** @type {!boolean} */ HTMLOListElement.prototype.compact;
/**
 * @constructor
 * @private
 * @extends {HTMLElement}
 * @nosideeffects
 */
function HTMLOptGroupElement() {}
/** @type {!boolean} */ HTMLOptGroupElement.prototype.disabled;
/** @type {!string} */ HTMLOptGroupElement.prototype.label;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function PluginArray() {}
/** @type {!number} */ PluginArray.prototype.length;
/**
 * @param {!string} name
 * @return {?Plugin}
 */
PluginArray.prototype.namedItem = function(name) {}
/**
 * @param {!number} index
 * @return {?Plugin}
 */
PluginArray.prototype.item = function(index) {}
/**
 * @return {undefined}
 */
PluginArray.prototype.refresh = function() {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function MediaDeviceInfo() {}
/** @type {!string} */ MediaDeviceInfo.prototype.deviceId;
/** @type {!string} */ MediaDeviceInfo.prototype.groupId;
/** @type {!string} */ MediaDeviceInfo.prototype.kind;
/** @type {!string} */ MediaDeviceInfo.prototype.label;
/**
 * @return {!Object}
 * @override
 */
MediaDeviceInfo.prototype.toJSON = function() {}
/**
 * @constructor
 * @extends {Object}
 */
function TextEncoderStream() {}
/** @type {!string} */ TextEncoderStream.prototype.encoding;
/** @type {!ReadableStream} */ TextEncoderStream.prototype.readable;
/** @type {!WritableStream} */ TextEncoderStream.prototype.writable;
/**
 * @constructor
 * @private
 * @extends {HTMLElement}
 * @nosideeffects
 */
function HTMLFontElement() {}
/** @type {!string} */ HTMLFontElement.prototype.color;
/** @type {!string} */ HTMLFontElement.prototype.face;
/** @type {!string} */ HTMLFontElement.prototype.size;
/**
 * @constructor
 * @private
 * @extends {HTMLElement}
 * @nosideeffects
 */
function HTMLPictureElement() {}
/**
 * @constructor
 * @private
 * @extends {HTMLElement}
 * @nosideeffects
 */
function HTMLLabelElement() {}
/** @type {?HTMLElement} */ HTMLLabelElement.prototype.control;
/** @type {?HTMLFormElement} */ HTMLLabelElement.prototype.form;
/** @type {!string} */ HTMLLabelElement.prototype.htmlFor;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function SVGTransformList() {}
/** @type {!number} */ SVGTransformList.prototype.length;
/** @type {!number} */ SVGTransformList.prototype.numberOfItems;
/**
 * @param {!DOMMatrixReadOnly} matrix
 * @return {!SVGTransform}
 */
SVGTransformList.prototype.createSVGTransformFromMatrix = function(matrix) {}
/**
 * @param {!number} index
 * @return {!SVGTransform}
 */
SVGTransformList.prototype.removeItem = function(index) {}
/**
 * @return {?SVGTransform}
 */
SVGTransformList.prototype.consolidate = function() {}
/**
 * @param {!SVGTransform} newItem
 * @param {!number} index
 * @return {!SVGTransform}
 */
SVGTransformList.prototype.insertItemBefore = function(newItem,index) {}
/**
 * @param {!SVGTransform} newItem
 * @param {!number} index
 * @return {!SVGTransform}
 */
SVGTransformList.prototype.replaceItem = function(newItem,index) {}
/**
 * @return {undefined}
 */
SVGTransformList.prototype.clear = function() {}
/**
 * @param {!number} index
 * @return {!SVGTransform}
 */
SVGTransformList.prototype.getItem = function(index) {}
/**
 * @param {!SVGTransform} newItem
 * @return {!SVGTransform}
 */
SVGTransformList.prototype.initialize = function(newItem) {}
/**
 * @param {!SVGTransform} newItem
 * @return {!SVGTransform}
 */
SVGTransformList.prototype.appendItem = function(newItem) {}
/**
 * @constructor
 * @private
 * @extends {SVGGeometryElement}
 * @nosideeffects
 */
function SVGCircleElement() {}
/** @type {!SVGAnimatedLength} */ SVGCircleElement.prototype.cx;
/** @type {!SVGAnimatedLength} */ SVGCircleElement.prototype.cy;
/** @type {!SVGAnimatedLength} */ SVGCircleElement.prototype.r;
/**
 * @constructor
 * @extends {Event}
 * @param {!string} type
 * @param {!MediaStreamTrackEventInit} eventInitDict
 */
function MediaStreamTrackEvent(type,eventInitDict) {}
/** @type {!MediaStreamTrack} */ MediaStreamTrackEvent.prototype.track;
/**
 * @constructor
 * @extends {Event}
 * @param {!string} type
 * @param {!RTCErrorEventInit} eventInitDict
 */
function RTCErrorEvent(type,eventInitDict) {}
/** @type {!RTCError} */ RTCErrorEvent.prototype.error;
/**
 * @constructor
 * @private
 * @extends {Text}
 * @nosideeffects
 */
function CDATASection() {}
/**
 * @constructor
 * @private
 * @extends {HTMLElement}
 * @nosideeffects
 */
function HTMLImageElement() {}
/** @type {!boolean} */ HTMLImageElement.prototype.complete;
/** @type {!string} */ HTMLImageElement.prototype.currentSrc;
/** @type {!number} */ HTMLImageElement.prototype.naturalHeight;
/** @type {!number} */ HTMLImageElement.prototype.naturalWidth;
/** @type {!string} */ HTMLImageElement.prototype.alt;
/** @type {?string} */ HTMLImageElement.prototype.crossOrigin;
/** @type {!string} */ HTMLImageElement.prototype.decoding;
/** @type {!number} */ HTMLImageElement.prototype.height;
/** @type {!boolean} */ HTMLImageElement.prototype.isMap;
/** @type {!string} */ HTMLImageElement.prototype.loading;
/** @type {!string} */ HTMLImageElement.prototype.referrerPolicy;
/** @type {!string} */ HTMLImageElement.prototype.sizes;
/** @type {!string} */ HTMLImageElement.prototype.src;
/** @type {!string} */ HTMLImageElement.prototype.srcset;
/** @type {!string} */ HTMLImageElement.prototype.useMap;
/** @type {!number} */ HTMLImageElement.prototype.width;
/** @type {!number} */ HTMLImageElement.prototype.x;
/** @type {!number} */ HTMLImageElement.prototype.y;
/** @type {!string} */ HTMLImageElement.prototype.align;
/** @type {!string} */ HTMLImageElement.prototype.border;
/** @type {!number} */ HTMLImageElement.prototype.hspace;
/** @type {!string} */ HTMLImageElement.prototype.longDesc;
/** @type {!string} */ HTMLImageElement.prototype.lowsrc;
/** @type {!string} */ HTMLImageElement.prototype.name;
/** @type {!number} */ HTMLImageElement.prototype.vspace;
/**
 * @return {!Promise<undefined>}
 */
HTMLImageElement.prototype.decode = function() {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function GPUShaderModule() {}
/** @type {?string} */ GPUShaderModule.prototype.label;
/**
 * @return {!Promise<!GPUCompilationInfo>}
 */
GPUShaderModule.prototype.compilationInfo = function() {}
/**
 * @constructor
 * @extends {AnimationTimeline}
 * @param {!DocumentTimelineOptions=} options
 */
function DocumentTimeline(options) {}
/**
 * @constructor
 * @private
 * @extends {EventTarget}
 * @nosideeffects
 */
function GPUDevice() {}
/** @type {!GPUSupportedFeatures} */ GPUDevice.prototype.features;
/** @type {!GPUSupportedLimits} */ GPUDevice.prototype.limits;
/** @type {!GPUQueue} */ GPUDevice.prototype.queue;
/** @type {!Promise<!GPUDeviceLostInfo>} */ GPUDevice.prototype.lost;
/** @type {!NullableEventHandler} */ GPUDevice.prototype.onuncapturederror;
/** @type {?string} */ GPUDevice.prototype.label;
/**
 * @param {!string} filter
 * @return {undefined}
 */
GPUDevice.prototype.pushErrorScope = function(filter) {}
/**
 * @param {!GPUSamplerDescriptor=} descriptor
 * @return {!GPUSampler}
 */
GPUDevice.prototype.createSampler = function(descriptor) {}
/**
 * @param {!GPUShaderModuleDescriptor} descriptor
 * @return {!GPUShaderModule}
 */
GPUDevice.prototype.createShaderModule = function(descriptor) {}
/**
 * @param {!GPURenderPipelineDescriptor} descriptor
 * @return {!GPURenderPipeline}
 */
GPUDevice.prototype.createRenderPipeline = function(descriptor) {}
/**
 * @param {!GPUQuerySetDescriptor} descriptor
 * @return {!GPUQuerySet}
 */
GPUDevice.prototype.createQuerySet = function(descriptor) {}
/**
 * @param {!GPUPipelineLayoutDescriptor} descriptor
 * @return {!GPUPipelineLayout}
 */
GPUDevice.prototype.createPipelineLayout = function(descriptor) {}
/**
 * @param {!GPURenderBundleEncoderDescriptor} descriptor
 * @return {!GPURenderBundleEncoder}
 */
GPUDevice.prototype.createRenderBundleEncoder = function(descriptor) {}
/**
 * @return {undefined}
 */
GPUDevice.prototype.destroy = function() {}
/**
 * @param {!GPUCommandEncoderDescriptor=} descriptor
 * @return {!GPUCommandEncoder}
 */
GPUDevice.prototype.createCommandEncoder = function(descriptor) {}
/**
 * @param {!GPUExternalTextureDescriptor} descriptor
 * @return {!GPUExternalTexture}
 */
GPUDevice.prototype.importExternalTexture = function(descriptor) {}
/**
 * @param {!GPUBufferDescriptor} descriptor
 * @return {!GPUBuffer}
 */
GPUDevice.prototype.createBuffer = function(descriptor) {}
/**
 * @param {!GPUBindGroupDescriptor} descriptor
 * @return {!GPUBindGroup}
 */
GPUDevice.prototype.createBindGroup = function(descriptor) {}
/**
 * @return {!Promise<?GPUError>}
 */
GPUDevice.prototype.popErrorScope = function() {}
/**
 * @param {!GPUComputePipelineDescriptor} descriptor
 * @return {!GPUComputePipeline}
 */
GPUDevice.prototype.createComputePipeline = function(descriptor) {}
/**
 * @param {!GPUComputePipelineDescriptor} descriptor
 * @return {!Promise<!GPUComputePipeline>}
 */
GPUDevice.prototype.createComputePipelineAsync = function(descriptor) {}
/**
 * @param {!GPUBindGroupLayoutDescriptor} descriptor
 * @return {!GPUBindGroupLayout}
 */
GPUDevice.prototype.createBindGroupLayout = function(descriptor) {}
/**
 * @param {!GPUTextureDescriptor} descriptor
 * @return {!GPUTexture}
 */
GPUDevice.prototype.createTexture = function(descriptor) {}
/**
 * @param {!GPURenderPipelineDescriptor} descriptor
 * @return {!Promise<!GPURenderPipeline>}
 */
GPUDevice.prototype.createRenderPipelineAsync = function(descriptor) {}
/**
 * @constructor
 * @private
 * @extends {EventTarget}
 * @nosideeffects
 */
function RTCDTMFSender() {}
/** @type {!boolean} */ RTCDTMFSender.prototype.canInsertDTMF;
/** @type {!string} */ RTCDTMFSender.prototype.toneBuffer;
/** @type {?RTCDTMFToneChangeEventHandler} */ RTCDTMFSender.prototype.ontonechange;
/**
 * @param {!string} tones
 * @param {!number=} duration
 * @param {!number=} interToneGap
 * @return {undefined}
 */
RTCDTMFSender.prototype.insertDTMF = function(tones,duration,interToneGap) {}
/**
 * @constructor
 * @extends {Event}
 * @param {!string} type
 * @param {!HashChangeEventInit=} eventInitDict
 */
function HashChangeEvent(type,eventInitDict) {}
/** @type {!string} */ HashChangeEvent.prototype.newURL;
/** @type {!string} */ HashChangeEvent.prototype.oldURL;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function PerformanceObserverEntryList() {}
/**
 * @param {!string} name
 * @param {!string=} type
 * @return {!PerformanceEntryList}
 */
PerformanceObserverEntryList.prototype.getEntriesByName = function(name,type) {}
/**
 * @return {!PerformanceEntryList}
 */
PerformanceObserverEntryList.prototype.getEntries = function() {}
/**
 * @param {!string} type
 * @return {!PerformanceEntryList}
 */
PerformanceObserverEntryList.prototype.getEntriesByType = function(type) {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function CacheStorage() {}
/**
 * @return {!Promise<!Array<!string>>}
 */
CacheStorage.prototype.keys = function() {}
/**
 * @param {!RequestInfo} request
 * @param {!MultiCacheQueryOptions=} options
 * @return {!Promise<ResponseOrUndefinedUnion>}
 */
CacheStorage.prototype.match = function(request,options) {}
/**
 * @param {!string} cacheName
 * @return {!Promise<!boolean>}
 */
CacheStorage.prototype.has = function(cacheName) {}
/**
 * @param {!string} cacheName
 * @return {!Promise<!boolean>}
 */
CacheStorage.prototype.delete = function(cacheName) {}
/**
 * @param {!string} cacheName
 * @return {!Promise<!Cache>}
 */
CacheStorage.prototype.open = function(cacheName) {}
/**
 * @constructor
 * @private
 * @extends {EventTarget}
 * @nosideeffects
 */
function BluetoothRemoteGATTService() {}
/** @type {!BluetoothDevice} */ BluetoothRemoteGATTService.prototype.device;
/** @type {!boolean} */ BluetoothRemoteGATTService.prototype.isPrimary;
/** @type {!UUID} */ BluetoothRemoteGATTService.prototype.uuid;
/** @type {!NullableEventHandler} */ BluetoothRemoteGATTService.prototype.oncharacteristicvaluechanged;
/** @type {!NullableEventHandler} */ BluetoothRemoteGATTService.prototype.onserviceadded;
/** @type {!NullableEventHandler} */ BluetoothRemoteGATTService.prototype.onservicechanged;
/** @type {!NullableEventHandler} */ BluetoothRemoteGATTService.prototype.onserviceremoved;
/**
 * @param {!BluetoothServiceUUID} service
 * @return {!Promise<!BluetoothRemoteGATTService>}
 */
BluetoothRemoteGATTService.prototype.getIncludedService = function(service) {}
/**
 * @param {!BluetoothServiceUUID=} service
 * @return {!Promise<!Array<!BluetoothRemoteGATTService>>}
 */
BluetoothRemoteGATTService.prototype.getIncludedServices = function(service) {}
/**
 * @param {!BluetoothCharacteristicUUID} characteristic
 * @return {!Promise<!BluetoothRemoteGATTCharacteristic>}
 */
BluetoothRemoteGATTService.prototype.getCharacteristic = function(characteristic) {}
/**
 * @param {!BluetoothCharacteristicUUID=} characteristic
 * @return {!Promise<!Array<!BluetoothRemoteGATTCharacteristic>>}
 */
BluetoothRemoteGATTService.prototype.getCharacteristics = function(characteristic) {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function TransformStreamDefaultController() {}
/** @type {?number} */ TransformStreamDefaultController.prototype.desiredSize;
/**
 * @param {*=} chunk
 * @return {undefined}
 */
TransformStreamDefaultController.prototype.enqueue = function(chunk) {}
/**
 * @return {undefined}
 */
TransformStreamDefaultController.prototype.terminate = function() {}
/**
 * @param {*=} reason
 * @return {undefined}
 */
TransformStreamDefaultController.prototype.error = function(reason) {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function MediaError() {}
/** @const {!number} */ MediaError.MEDIA_ERR_ABORTED;
/** @const {!number} */ MediaError.prototype.MEDIA_ERR_ABORTED;
/** @const {!number} */ MediaError.MEDIA_ERR_DECODE;
/** @const {!number} */ MediaError.prototype.MEDIA_ERR_DECODE;
/** @const {!number} */ MediaError.MEDIA_ERR_NETWORK;
/** @const {!number} */ MediaError.prototype.MEDIA_ERR_NETWORK;
/** @const {!number} */ MediaError.MEDIA_ERR_SRC_NOT_SUPPORTED;
/** @const {!number} */ MediaError.prototype.MEDIA_ERR_SRC_NOT_SUPPORTED;
/** @type {!number} */ MediaError.prototype.code;
/** @type {!string} */ MediaError.prototype.message;
/**
 * @constructor
 * @private
 * @extends {CSSRule}
 * @nosideeffects
 */
function CSSGroupingRule() {}
/** @type {!CSSRuleList} */ CSSGroupingRule.prototype.cssRules;
/**
 * @param {!CSSOMString} rule
 * @param {!number=} index
 * @return {!number}
 */
CSSGroupingRule.prototype.insertRule = function(rule,index) {}
/**
 * @param {!number} index
 * @return {undefined}
 */
CSSGroupingRule.prototype.deleteRule = function(index) {}
/**
 * @constructor
 * @extends {Object}
 * @param {!EncodedVideoChunkInit} init
 */
function EncodedVideoChunk(init) {}
/** @type {!number} */ EncodedVideoChunk.prototype.byteLength;
/** @type {?number} */ EncodedVideoChunk.prototype.duration;
/** @type {!number} */ EncodedVideoChunk.prototype.timestamp;
/** @type {!string} */ EncodedVideoChunk.prototype.type;
/**
 * @param {!BufferSource} destination
 * @return {undefined}
 */
EncodedVideoChunk.prototype.copyTo = function(destination) {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function PushSubscriptionOptions() {}
/** @type {?ArrayBuffer} */ PushSubscriptionOptions.prototype.applicationServerKey;
/** @type {!boolean} */ PushSubscriptionOptions.prototype.userVisibleOnly;
/**
 * @constructor
 * @extends {AbstractRange}
 */
function Range() {}
/** @const {!number} */ Range.END_TO_END;
/** @const {!number} */ Range.prototype.END_TO_END;
/** @const {!number} */ Range.END_TO_START;
/** @const {!number} */ Range.prototype.END_TO_START;
/** @const {!number} */ Range.START_TO_END;
/** @const {!number} */ Range.prototype.START_TO_END;
/** @const {!number} */ Range.START_TO_START;
/** @const {!number} */ Range.prototype.START_TO_START;
/** @type {!Node} */ Range.prototype.commonAncestorContainer;
/**
 * @return {!Range}
 */
Range.prototype.cloneRange = function() {}
/**
 * @return {!DOMRect}
 */
Range.prototype.getBoundingClientRect = function() {}
/**
 * @return {!DocumentFragment}
 */
Range.prototype.extractContents = function() {}
/**
 * @param {!Node} node
 * @return {undefined}
 */
Range.prototype.setEndBefore = function(node) {}
/**
 * @param {!Node} node
 * @return {undefined}
 */
Range.prototype.insertNode = function(node) {}
/**
 * @return {!DocumentFragment}
 */
Range.prototype.cloneContents = function() {}
/**
 * @param {!Node} node
 * @return {!boolean}
 * @nosideeffects
 */
Range.prototype.intersectsNode = function(node) {}
/**
 * @param {!Node} node
 * @return {undefined}
 */
Range.prototype.setStartAfter = function(node) {}
/**
 * @param {!Node} node
 * @param {!number} offset
 * @return {!boolean}
 * @nosideeffects
 */
Range.prototype.isPointInRange = function(node,offset) {}
/**
 * @return {!DOMRectList}
 */
Range.prototype.getClientRects = function() {}
/**
 * @param {!Node} newParent
 * @return {undefined}
 */
Range.prototype.surroundContents = function(newParent) {}
/**
 * @return {undefined}
 */
Range.prototype.deleteContents = function() {}
/**
 * @param {!Node} node
 * @param {!number} offset
 * @return {!number}
 * @nosideeffects
 */
Range.prototype.comparePoint = function(node,offset) {}
/**
 * @param {!Node} node
 * @param {!number} offset
 * @return {undefined}
 */
Range.prototype.setStart = function(node,offset) {}
/**
 * @param {!Node} node
 * @return {undefined}
 */
Range.prototype.selectNodeContents = function(node) {}
/**
 * @param {!Node} node
 * @return {undefined}
 */
Range.prototype.selectNode = function(node) {}
/**
 * @param {!string} fragment
 * @return {!DocumentFragment}
 */
Range.prototype.createContextualFragment = function(fragment) {}
/**
 * @return {undefined}
 */
Range.prototype.detach = function() {}
/**
 * @param {!Node} node
 * @return {undefined}
 */
Range.prototype.setStartBefore = function(node) {}
/**
 * @param {!Node} node
 * @param {!number} offset
 * @return {undefined}
 */
Range.prototype.setEnd = function(node,offset) {}
/**
 * @param {!Node} node
 * @return {undefined}
 */
Range.prototype.setEndAfter = function(node) {}
/**
 * @param {!number} how
 * @param {!Range} sourceRange
 * @return {!number}
 */
Range.prototype.compareBoundaryPoints = function(how,sourceRange) {}
/**
 * @param {!boolean=} toStart
 * @return {undefined}
 */
Range.prototype.collapse = function(toStart) {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function PushSubscription() {}
/** @type {!string} */ PushSubscription.prototype.endpoint;
/** @type {?DOMTimeStamp} */ PushSubscription.prototype.expirationTime;
/** @type {!PushSubscriptionOptions} */ PushSubscription.prototype.options;
/**
 * @param {!string} name
 * @return {?ArrayBuffer}
 */
PushSubscription.prototype.getKey = function(name) {}
/**
 * @return {!PushSubscriptionJSON}
 * @override
 */
PushSubscription.prototype.toJSON = function() {}
/**
 * @return {!Promise<!boolean>}
 */
PushSubscription.prototype.unsubscribe = function() {}
/**
 * @constructor
 * @private
 * @extends {HTMLElement}
 * @nosideeffects
 */
function HTMLMarqueeElement() {}
/** @type {!string} */ HTMLMarqueeElement.prototype.behavior;
/** @type {!string} */ HTMLMarqueeElement.prototype.bgColor;
/** @type {!string} */ HTMLMarqueeElement.prototype.direction;
/** @type {!string} */ HTMLMarqueeElement.prototype.height;
/** @type {!number} */ HTMLMarqueeElement.prototype.hspace;
/** @type {!number} */ HTMLMarqueeElement.prototype.loop;
/** @type {!number} */ HTMLMarqueeElement.prototype.scrollAmount;
/** @type {!number} */ HTMLMarqueeElement.prototype.scrollDelay;
/** @type {!boolean} */ HTMLMarqueeElement.prototype.trueSpeed;
/** @type {!number} */ HTMLMarqueeElement.prototype.vspace;
/** @type {!string} */ HTMLMarqueeElement.prototype.width;
/**
 * @return {undefined}
 */
HTMLMarqueeElement.prototype.stop = function() {}
/**
 * @return {undefined}
 */
HTMLMarqueeElement.prototype.start = function() {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function XRFrame() {}
/** @type {!XRSession} */ XRFrame.prototype.session;
/**
 * @param {!XRSpace} space
 * @param {!XRSpace} baseSpace
 * @return {?XRPose}
 */
XRFrame.prototype.getPose = function(space,baseSpace) {}
/**
 * @param {!XRReferenceSpace} referenceSpace
 * @return {?XRViewerPose}
 */
XRFrame.prototype.getViewerPose = function(referenceSpace) {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function VideoPlaybackQuality() {}
/** @type {!number} */ VideoPlaybackQuality.prototype.corruptedVideoFrames;
/** @type {!DOMHighResTimeStamp} */ VideoPlaybackQuality.prototype.creationTime;
/** @type {!number} */ VideoPlaybackQuality.prototype.droppedVideoFrames;
/** @type {!number} */ VideoPlaybackQuality.prototype.totalVideoFrames;
/**
 * @constructor
 * @private
 * @extends {SVGElement}
 * @nosideeffects
 */
function SVGFEMorphologyElement() {}
/** @const {!number} */ SVGFEMorphologyElement.SVG_MORPHOLOGY_OPERATOR_DILATE;
/** @const {!number} */ SVGFEMorphologyElement.prototype.SVG_MORPHOLOGY_OPERATOR_DILATE;
/** @const {!number} */ SVGFEMorphologyElement.SVG_MORPHOLOGY_OPERATOR_ERODE;
/** @const {!number} */ SVGFEMorphologyElement.prototype.SVG_MORPHOLOGY_OPERATOR_ERODE;
/** @const {!number} */ SVGFEMorphologyElement.SVG_MORPHOLOGY_OPERATOR_UNKNOWN;
/** @const {!number} */ SVGFEMorphologyElement.prototype.SVG_MORPHOLOGY_OPERATOR_UNKNOWN;
/** @type {!SVGAnimatedString} */ SVGFEMorphologyElement.prototype.in1;
/** @type {!SVGAnimatedEnumeration} */ SVGFEMorphologyElement.prototype.operator;
/** @type {!SVGAnimatedNumber} */ SVGFEMorphologyElement.prototype.radiusX;
/** @type {!SVGAnimatedNumber} */ SVGFEMorphologyElement.prototype.radiusY;
/** @type {!SVGAnimatedLength} */ SVGFEMorphologyElement.prototype.height;
/** @type {!SVGAnimatedString} */ SVGFEMorphologyElement.prototype.result;
/** @type {!SVGAnimatedLength} */ SVGFEMorphologyElement.prototype.width;
/** @type {!SVGAnimatedLength} */ SVGFEMorphologyElement.prototype.x;
/** @type {!SVGAnimatedLength} */ SVGFEMorphologyElement.prototype.y;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function GPUTextureUsage() {}
/** @const {!GPUFlagsConstant} */ GPUTextureUsage.COPY_DST;
/** @const {!GPUFlagsConstant} */ GPUTextureUsage.prototype.COPY_DST;
/** @const {!GPUFlagsConstant} */ GPUTextureUsage.COPY_SRC;
/** @const {!GPUFlagsConstant} */ GPUTextureUsage.prototype.COPY_SRC;
/** @const {!GPUFlagsConstant} */ GPUTextureUsage.RENDER_ATTACHMENT;
/** @const {!GPUFlagsConstant} */ GPUTextureUsage.prototype.RENDER_ATTACHMENT;
/** @const {!GPUFlagsConstant} */ GPUTextureUsage.SHADER_READ;
/** @const {!GPUFlagsConstant} */ GPUTextureUsage.prototype.SHADER_READ;
/** @const {!GPUFlagsConstant} */ GPUTextureUsage.STORAGE;
/** @const {!GPUFlagsConstant} */ GPUTextureUsage.prototype.STORAGE;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @implements {Iterable<!Array<!string|!Object>>}
 * @nosideeffects
 */
function RTCStatsReport() {}
/** @const {number} */ RTCStatsReport.prototype.size;
/**
 * @param {!string} key
 * @return {!boolean}
 * @nosideeffects
 */
RTCStatsReport.prototype.has = function(key) {}
/**
 * @param {!string} key
 * @return {?Object}
 * @nosideeffects
 */
RTCStatsReport.prototype.get = function(key) {}
/**
 * @return {!Iterator<!string>}
 * @nosideeffects
 */
RTCStatsReport.prototype.keys = function() {}
/**
 * @return {!Iterator<!Object>}
 * @nosideeffects
 */
RTCStatsReport.prototype.values = function() {}
/**
 * @return {!Iterator<!Array<!string|!Object>>}
 * @nosideeffects
 */
RTCStatsReport.prototype.entries = function() {};
/**
 * @return {!Iterator<!Array<!string|!Object>>}
 * @nosideeffects
 */
RTCStatsReport.prototype[Symbol.iterator] = function() {};
/**
 * @param {function(!Object, !string, MAP)} callback
 * @this {MAP}
 * @template MAP
 */
RTCStatsReport.prototype.forEach = function(callback) {};
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function AudioTrack() {}
/** @type {!string} */ AudioTrack.prototype.id;
/** @type {!string} */ AudioTrack.prototype.kind;
/** @type {!string} */ AudioTrack.prototype.label;
/** @type {!string} */ AudioTrack.prototype.language;
/** @type {!boolean} */ AudioTrack.prototype.enabled;
/** @type {?SourceBuffer} */ AudioTrack.prototype.sourceBuffer;
/**
 * @constructor
 * @extends {HTMLOptionElement}
 * @param {!string=} text
 * @param {!string=} value
 * @param {!boolean=} defaultSelected
 * @param {!boolean=} selected
 */
function Option(text,value,defaultSelected,selected) {}
/**
 * @constructor
 * @private
 * @extends {EventTarget}
 * @nosideeffects
 */
function IDBRequest() {}
/** @type {?DOMException} */ IDBRequest.prototype.error;
/** @type {!string} */ IDBRequest.prototype.readyState;
/** @type {*} */ IDBRequest.prototype.result;
/** @type {IDBObjectStoreOrIDBIndexOrIDBCursorUnion} */ IDBRequest.prototype.source;
/** @type {?IDBTransaction} */ IDBRequest.prototype.transaction;
/** @type {?EventHandler} */ IDBRequest.prototype.onerror;
/** @type {?EventHandler} */ IDBRequest.prototype.onsuccess;
/**
 * @constructor
 * @extends {Blob}
 * @param {!Array<!BlobPart>} fileBits
 * @param {!string} fileName
 * @param {!FilePropertyBag=} options
 */
function File(fileBits,fileName,options) {}
/** @type {!number} */ File.prototype.lastModified;
/** @type {!string} */ File.prototype.name;
/**
 * @constructor
 * @private
 * @extends {CSSGroupingRule}
 * @nosideeffects
 */
function CSSPageRule() {}
/** @type {!CSSStyleDeclaration} */ CSSPageRule.prototype.style;
/** @type {!CSSOMString} */ CSSPageRule.prototype.selectorText;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function SVGNumber() {}
/** @type {!number} */ SVGNumber.prototype.value;
/**
 * @constructor
 * @private
 * @extends {EventTarget}
 * @nosideeffects
 */
function IDBDatabase() {}
/** @type {!string} */ IDBDatabase.prototype.name;
/** @type {!DOMStringList} */ IDBDatabase.prototype.objectStoreNames;
/** @type {!number} */ IDBDatabase.prototype.version;
/** @type {?EventHandler} */ IDBDatabase.prototype.onabort;
/** @type {!NullableEventHandler} */ IDBDatabase.prototype.onclose;
/** @type {?EventHandler} */ IDBDatabase.prototype.onerror;
/** @type {?EventHandler} */ IDBDatabase.prototype.onversionchange;
/**
 * @param {!string} name
 * @param {!IDBObjectStoreParameters=} options
 * @return {!IDBObjectStore}
 */
IDBDatabase.prototype.createObjectStore = function(name,options) {}
/**
 * @param {!string} name
 * @return {undefined}
 */
IDBDatabase.prototype.deleteObjectStore = function(name) {}
/**
 * @return {undefined}
 */
IDBDatabase.prototype.close = function() {}
/**
 * @param {(!string|!Array<!string>)} storeNames
 * @param {!string=} mode
 * @param {!IDBTransactionOptions=} options
 * @return {!IDBTransaction}
 */
IDBDatabase.prototype.transaction = function(storeNames,mode,options) {}
/**
 * @constructor
 * @extends {Event}
 * @param {!string} type
 * @param {!XRInputSourcesChangeEventInit} eventInitDict
 */
function XRInputSourcesChangeEvent(type,eventInitDict) {}
/** @type {!Array<!XRInputSource>} */ XRInputSourcesChangeEvent.prototype.added;
/** @type {!Array<!XRInputSource>} */ XRInputSourcesChangeEvent.prototype.removed;
/** @type {!XRSession} */ XRInputSourcesChangeEvent.prototype.session;
/**
 * @constructor
 * @private
 * @extends {AuthenticatorResponse}
 * @nosideeffects
 */
function AuthenticatorAssertionResponse() {}
/** @type {!ArrayBuffer} */ AuthenticatorAssertionResponse.prototype.authenticatorData;
/** @type {!ArrayBuffer} */ AuthenticatorAssertionResponse.prototype.signature;
/** @type {?ArrayBuffer} */ AuthenticatorAssertionResponse.prototype.userHandle;
/**
 * @constructor
 * @extends {Object}
 * @param {!Object=} underlyingSource
 * @param {!QueuingStrategy=} strategy
 */
function ReadableStream(underlyingSource,strategy) {}
/** @type {!boolean} */ ReadableStream.prototype.locked;
/**
 * @param {*=} reason
 * @return {!Promise<undefined>}
 */
ReadableStream.prototype.cancel = function(reason) {}
/**
 * @param {!WritableStream} destination
 * @param {!StreamPipeOptions=} options
 * @return {!Promise<undefined>}
 */
ReadableStream.prototype.pipeTo = function(destination,options) {}
/**
 * @param {!ReadableWritablePair} transform
 * @param {!StreamPipeOptions=} options
 * @return {!ReadableStream}
 */
ReadableStream.prototype.pipeThrough = function(transform,options) {}
/**
 * @return {!Array<!ReadableStream>}
 */
ReadableStream.prototype.tee = function() {}
/**
 * @param {!ReadableStreamGetReaderOptions=} options
 * @return {!ReadableStreamReader}
 */
ReadableStream.prototype.getReader = function(options) {}
/**
 * @constructor
 * @extends {Object}
 * @implements {Iterable<!Array<!string|!string>>}
 * @param {!HeadersInit=} init
 */
function Headers(init) {}
/**
 * @param {!string} name
 * @param {!string} value
 * @return {undefined}
 */
Headers.prototype.set = function(name,value) {}
/**
 * @param {!string} name
 * @return {?string}
 */
Headers.prototype.get = function(name) {}
/**
 * @param {!string} name
 * @return {!boolean}
 */
Headers.prototype.has = function(name) {}
/**
 * @param {!string} name
 * @return {undefined}
 */
Headers.prototype.delete = function(name) {}
/**
 * @param {!string} name
 * @param {!string} value
 * @return {undefined}
 */
Headers.prototype.append = function(name,value) {}
/**
 * @return {!Iterator<!string>}
 * @nosideeffects
 */
Headers.prototype.keys = function() {}
/**
 * @return {!Iterator<!string>}
 * @nosideeffects
 */
Headers.prototype.values = function() {}
/**
 * @return {!Iterator<!Array<!string|!string>>}
 * @nosideeffects
 */
Headers.prototype.entries = function() {};
/**
 * @return {!Iterator<!Array<!string|!string>>}
 * @nosideeffects
 */
Headers.prototype[Symbol.iterator] = function() {};
/**
 * @param {function(!string, !string, MAP)} callback
 * @this {MAP}
 * @template MAP
 */
Headers.prototype.forEach = function(callback) {};
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function DOMImplementation() {}
/**
 * @param {!string=} title
 * @return {!Document}
 */
DOMImplementation.prototype.createHTMLDocument = function(title) {}
/**
 * @return {!boolean}
 * @nosideeffects
 */
DOMImplementation.prototype.hasFeature = function() {}
/**
 * @param {!string} qualifiedName
 * @param {!string} publicId
 * @param {!string} systemId
 * @return {!DocumentType}
 * @nosideeffects
 */
DOMImplementation.prototype.createDocumentType = function(qualifiedName,publicId,systemId) {}
/**
 * @param {?string} namespace
 * @param {!string} qualifiedName
 * @param {?DocumentType=} doctype
 * @return {!XMLDocument}
 * @nosideeffects
 */
DOMImplementation.prototype.createDocument = function(namespace,qualifiedName,doctype) {}
/**
 * @constructor
 * @extends {Object}
 * @param {!QueuingStrategyInit} init
 */
function CountQueuingStrategy(init) {}
/** @type {!number} */ CountQueuingStrategy.prototype.highWaterMark;
/** @type {!Function} */ CountQueuingStrategy.prototype.size;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function ImageTrackList() {}
/** @type {!number} */ ImageTrackList.prototype.length;
/** @type {!Promise<undefined>} */ ImageTrackList.prototype.ready;
/** @type {!number} */ ImageTrackList.prototype.selectedIndex;
/** @type {?ImageTrack} */ ImageTrackList.prototype.selectedTrack;
/**
 * @constructor
 * @extends {EventTarget}
 * @param {!string=} text
 */
function SpeechSynthesisUtterance(text) {}
/** @type {!string} */ SpeechSynthesisUtterance.prototype.lang;
/** @type {?SpeechSynthesisEventHandler} */ SpeechSynthesisUtterance.prototype.onboundary;
/** @type {?SpeechSynthesisEventHandler} */ SpeechSynthesisUtterance.prototype.onend;
/** @type {?SpeechSynthesisErrorEventHandler} */ SpeechSynthesisUtterance.prototype.onerror;
/** @type {?SpeechSynthesisEventHandler} */ SpeechSynthesisUtterance.prototype.onmark;
/** @type {?SpeechSynthesisEventHandler} */ SpeechSynthesisUtterance.prototype.onpause;
/** @type {?SpeechSynthesisEventHandler} */ SpeechSynthesisUtterance.prototype.onresume;
/** @type {?SpeechSynthesisEventHandler} */ SpeechSynthesisUtterance.prototype.onstart;
/** @type {!number} */ SpeechSynthesisUtterance.prototype.pitch;
/** @type {!number} */ SpeechSynthesisUtterance.prototype.rate;
/** @type {!string} */ SpeechSynthesisUtterance.prototype.text;
/** @type {?SpeechSynthesisVoice} */ SpeechSynthesisUtterance.prototype.voice;
/** @type {!number} */ SpeechSynthesisUtterance.prototype.volume;
/**
 * @constructor
 * @extends {Object}
 * @param {!ReadableStream} stream
 */
function ReadableStreamBYOBReader(stream) {}
/** @type {!Promise<undefined>} */ ReadableStreamBYOBReader.prototype.closed;
/**
 * @param {*=} reason
 * @return {!Promise<undefined>}
 */
ReadableStreamBYOBReader.prototype.cancel = function(reason) {}
/**
 * @param {!ArrayBufferView} view
 * @return {!Promise<!ReadableStreamBYOBReadResult>}
 */
ReadableStreamBYOBReader.prototype.read = function(view) {}
/**
 * @return {undefined}
 */
ReadableStreamBYOBReader.prototype.releaseLock = function() {}
/**
 * @constructor
 * @private
 * @extends {WebGLObject}
 * @nosideeffects
 */
function WebGLFramebuffer() {}
/**
 * @constructor
 * @extends {Object}
 * @param {!DOMPointInit=} p1
 * @param {!DOMPointInit=} p2
 * @param {!DOMPointInit=} p3
 * @param {!DOMPointInit=} p4
 */
function DOMQuad(p1,p2,p3,p4) {}
/** @type {!DOMPoint} */ DOMQuad.prototype.p1;
/** @type {!DOMPoint} */ DOMQuad.prototype.p2;
/** @type {!DOMPoint} */ DOMQuad.prototype.p3;
/** @type {!DOMPoint} */ DOMQuad.prototype.p4;
/**
 * @param {!DOMRectInit=} other
 * @return {!DOMQuad}
 */
DOMQuad.fromRect = function(other) {}
/**
 * @return {!Object}
 * @override
 */
DOMQuad.prototype.toJSON = function() {}
/**
 * @return {!DOMRect}
 */
DOMQuad.prototype.getBounds = function() {}
/**
 * @param {!DOMQuadInit=} other
 * @return {!DOMQuad}
 */
DOMQuad.fromQuad = function(other) {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function IDBFactory() {}
/**
 * @return {!Promise<!Array<!IDBDatabaseInfo>>}
 */
IDBFactory.prototype.databases = function() {}
/**
 * @param {*} first
 * @param {*} second
 * @return {!number}
 */
IDBFactory.prototype.cmp = function(first,second) {}
/**
 * @param {!string} name
 * @return {!IDBOpenDBRequest}
 */
IDBFactory.prototype.deleteDatabase = function(name) {}
/**
 * @param {!string} name
 * @param {!number=} version
 * @return {!IDBOpenDBRequest}
 */
IDBFactory.prototype.open = function(name,version) {}
/**
 * @constructor
 * @private
 * @extends {CSSRule}
 * @nosideeffects
 */
function CSSStyleRule() {}
/** @type {!CSSStyleDeclaration} */ CSSStyleRule.prototype.style;
/** @type {!CSSOMString} */ CSSStyleRule.prototype.selectorText;
/**
 * @constructor
 * @private
 * @extends {SVGTextContentElement}
 * @nosideeffects
 */
function SVGTextPositioningElement() {}
/** @type {!SVGAnimatedLengthList} */ SVGTextPositioningElement.prototype.dx;
/** @type {!SVGAnimatedLengthList} */ SVGTextPositioningElement.prototype.dy;
/** @type {!SVGAnimatedNumberList} */ SVGTextPositioningElement.prototype.rotate;
/** @type {!SVGAnimatedLengthList} */ SVGTextPositioningElement.prototype.x;
/** @type {!SVGAnimatedLengthList} */ SVGTextPositioningElement.prototype.y;
/**
 * @constructor
 * @private
 * @extends {SVGElement}
 * @nosideeffects
 */
function SVGFilterElement() {}
/** @type {!SVGAnimatedEnumeration} */ SVGFilterElement.prototype.filterUnits;
/** @type {!SVGAnimatedLength} */ SVGFilterElement.prototype.height;
/** @type {!SVGAnimatedEnumeration} */ SVGFilterElement.prototype.primitiveUnits;
/** @type {!SVGAnimatedLength} */ SVGFilterElement.prototype.width;
/** @type {!SVGAnimatedLength} */ SVGFilterElement.prototype.x;
/** @type {!SVGAnimatedLength} */ SVGFilterElement.prototype.y;
/** @type {!SVGAnimatedString} */ SVGFilterElement.prototype.href;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function GPUBindGroup() {}
/** @type {?string} */ GPUBindGroup.prototype.label;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function AbstractRange() {}
/** @type {!boolean} */ AbstractRange.prototype.collapsed;
/** @type {!Node} */ AbstractRange.prototype.endContainer;
/** @type {!number} */ AbstractRange.prototype.endOffset;
/** @type {!Node} */ AbstractRange.prototype.startContainer;
/** @type {!number} */ AbstractRange.prototype.startOffset;
/**
 * @constructor
 * @private
 * @extends {HTMLElement}
 * @nosideeffects
 */
function HTMLTextAreaElement() {}
/** @type {?HTMLFormElement} */ HTMLTextAreaElement.prototype.form;
/** @type {!NodeList} */ HTMLTextAreaElement.prototype.labels;
/** @type {!number} */ HTMLTextAreaElement.prototype.textLength;
/** @type {!string} */ HTMLTextAreaElement.prototype.type;
/** @type {!string} */ HTMLTextAreaElement.prototype.validationMessage;
/** @type {!ValidityState} */ HTMLTextAreaElement.prototype.validity;
/** @type {!boolean} */ HTMLTextAreaElement.prototype.willValidate;
/** @type {!string} */ HTMLTextAreaElement.prototype.autocomplete;
/** @type {!number} */ HTMLTextAreaElement.prototype.cols;
/** @type {!string} */ HTMLTextAreaElement.prototype.defaultValue;
/** @type {!string} */ HTMLTextAreaElement.prototype.dirName;
/** @type {!boolean} */ HTMLTextAreaElement.prototype.disabled;
/** @type {!number} */ HTMLTextAreaElement.prototype.maxLength;
/** @type {!number} */ HTMLTextAreaElement.prototype.minLength;
/** @type {!string} */ HTMLTextAreaElement.prototype.name;
/** @type {!string} */ HTMLTextAreaElement.prototype.placeholder;
/** @type {!boolean} */ HTMLTextAreaElement.prototype.readOnly;
/** @type {!boolean} */ HTMLTextAreaElement.prototype.required;
/** @type {!number} */ HTMLTextAreaElement.prototype.rows;
/** @type {!string} */ HTMLTextAreaElement.prototype.selectionDirection;
/** @type {!number} */ HTMLTextAreaElement.prototype.selectionEnd;
/** @type {!number} */ HTMLTextAreaElement.prototype.selectionStart;
/** @type {!string} */ HTMLTextAreaElement.prototype.value;
/** @type {!string} */ HTMLTextAreaElement.prototype.wrap;
/**
 * @return {undefined}
 */
HTMLTextAreaElement.prototype.select = function() {}
/**
 * @param {!string} error
 * @return {undefined}
 */
HTMLTextAreaElement.prototype.setCustomValidity = function(error) {}
/**
 * @return {!boolean}
 */
HTMLTextAreaElement.prototype.reportValidity = function() {}
/**
 * @param {!string} arg0
 * @param {!number=} arg1
 * @param {!number=} arg2
 * @param {!string=} arg3
 * @return {undefined}
 */
HTMLTextAreaElement.prototype.setRangeText = function(arg0,arg1,arg2,arg3) {}
/**
 * @param {!number} start
 * @param {!number} end
 * @param {!string=} direction
 * @return {undefined}
 */
HTMLTextAreaElement.prototype.setSelectionRange = function(start,end,direction) {}
/**
 * @return {!boolean}
 */
HTMLTextAreaElement.prototype.checkValidity = function() {}
/**
 * @constructor
 * @extends {Object}
 * @param {!QueuingStrategyInit} init
 */
function ByteLengthQueuingStrategy(init) {}
/** @type {!number} */ ByteLengthQueuingStrategy.prototype.highWaterMark;
/** @type {!Function} */ ByteLengthQueuingStrategy.prototype.size;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function NodeIterator() {}
/** @type {?NodeFilter} */ NodeIterator.prototype.filter;
/** @type {!boolean} */ NodeIterator.prototype.pointerBeforeReferenceNode;
/** @type {!Node} */ NodeIterator.prototype.referenceNode;
/** @type {!Node} */ NodeIterator.prototype.root;
/** @type {!number} */ NodeIterator.prototype.whatToShow;
/**
 * @return {?Node}
 */
NodeIterator.prototype.nextNode = function() {}
/**
 * @return {undefined}
 */
NodeIterator.prototype.detach = function() {}
/**
 * @return {?Node}
 */
NodeIterator.prototype.previousNode = function() {}
/**
 * @constructor
 * @extends {CharacterData}
 * @param {!string=} data
 */
function Comment(data) {}
/**
 * @constructor
 * @private
 * @extends {SVGElement}
 * @nosideeffects
 */
function SVGPatternElement() {}
/** @type {!SVGAnimatedLength} */ SVGPatternElement.prototype.height;
/** @type {!SVGAnimatedEnumeration} */ SVGPatternElement.prototype.patternContentUnits;
/** @type {!SVGAnimatedTransformList} */ SVGPatternElement.prototype.patternTransform;
/** @type {!SVGAnimatedEnumeration} */ SVGPatternElement.prototype.patternUnits;
/** @type {!SVGAnimatedLength} */ SVGPatternElement.prototype.width;
/** @type {!SVGAnimatedLength} */ SVGPatternElement.prototype.x;
/** @type {!SVGAnimatedLength} */ SVGPatternElement.prototype.y;
/** @type {!SVGAnimatedPreserveAspectRatio} */ SVGPatternElement.prototype.preserveAspectRatio;
/** @type {!SVGAnimatedRect} */ SVGPatternElement.prototype.viewBox;
/** @type {!SVGAnimatedString} */ SVGPatternElement.prototype.href;
/**
 * @constructor
 * @private
 * @extends {HTMLElement}
 * @nosideeffects
 */
function HTMLObjectElement() {}
/** @type {?Document} */ HTMLObjectElement.prototype.contentDocument;
/** @type {?WindowProxy} */ HTMLObjectElement.prototype.contentWindow;
/** @type {?HTMLFormElement} */ HTMLObjectElement.prototype.form;
/** @type {!string} */ HTMLObjectElement.prototype.validationMessage;
/** @type {!ValidityState} */ HTMLObjectElement.prototype.validity;
/** @type {!boolean} */ HTMLObjectElement.prototype.willValidate;
/** @type {!string} */ HTMLObjectElement.prototype.data;
/** @type {!string} */ HTMLObjectElement.prototype.height;
/** @type {!string} */ HTMLObjectElement.prototype.name;
/** @type {!string} */ HTMLObjectElement.prototype.type;
/** @type {!string} */ HTMLObjectElement.prototype.width;
/** @type {!string} */ HTMLObjectElement.prototype.align;
/** @type {!string} */ HTMLObjectElement.prototype.archive;
/** @type {!string} */ HTMLObjectElement.prototype.border;
/** @type {!string} */ HTMLObjectElement.prototype.code;
/** @type {!string} */ HTMLObjectElement.prototype.codeBase;
/** @type {!string} */ HTMLObjectElement.prototype.codeType;
/** @type {!boolean} */ HTMLObjectElement.prototype.declare;
/** @type {!number} */ HTMLObjectElement.prototype.hspace;
/** @type {!string} */ HTMLObjectElement.prototype.standby;
/** @type {!string} */ HTMLObjectElement.prototype.useMap;
/** @type {!number} */ HTMLObjectElement.prototype.vspace;
/**
 * @param {!string} error
 * @return {undefined}
 */
HTMLObjectElement.prototype.setCustomValidity = function(error) {}
/**
 * @return {!boolean}
 */
HTMLObjectElement.prototype.reportValidity = function() {}
/**
 * @return {?Document}
 */
HTMLObjectElement.prototype.getSVGDocument = function() {}
/**
 * @return {!boolean}
 */
HTMLObjectElement.prototype.checkValidity = function() {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function CSSRule() {}
/** @const {!number} */ CSSRule.CHARSET_RULE;
/** @const {!number} */ CSSRule.prototype.CHARSET_RULE;
/** @const {!number} */ CSSRule.FONT_FACE_RULE;
/** @const {!number} */ CSSRule.prototype.FONT_FACE_RULE;
/** @const {!number} */ CSSRule.IMPORT_RULE;
/** @const {!number} */ CSSRule.prototype.IMPORT_RULE;
/** @const {!number} */ CSSRule.MARGIN_RULE;
/** @const {!number} */ CSSRule.prototype.MARGIN_RULE;
/** @const {!number} */ CSSRule.MEDIA_RULE;
/** @const {!number} */ CSSRule.prototype.MEDIA_RULE;
/** @const {!number} */ CSSRule.NAMESPACE_RULE;
/** @const {!number} */ CSSRule.prototype.NAMESPACE_RULE;
/** @const {!number} */ CSSRule.PAGE_RULE;
/** @const {!number} */ CSSRule.prototype.PAGE_RULE;
/** @const {!number} */ CSSRule.STYLE_RULE;
/** @const {!number} */ CSSRule.prototype.STYLE_RULE;
/** @const {!number} */ CSSRule.KEYFRAMES_RULE;
/** @const {!number} */ CSSRule.prototype.KEYFRAMES_RULE;
/** @const {!number} */ CSSRule.KEYFRAME_RULE;
/** @const {!number} */ CSSRule.prototype.KEYFRAME_RULE;
/** @const {!number} */ CSSRule.SUPPORTS_RULE;
/** @const {!number} */ CSSRule.prototype.SUPPORTS_RULE;
/** @const {!number} */ CSSRule.COUNTER_STYLE_RULE;
/** @const {!number} */ CSSRule.prototype.COUNTER_STYLE_RULE;
/** @const {!number} */ CSSRule.FONT_FEATURE_VALUES_RULE;
/** @const {!number} */ CSSRule.prototype.FONT_FEATURE_VALUES_RULE;
/** @const {!number} */ CSSRule.FONT_PALETTE_VALUES_RULE;
/** @const {!number} */ CSSRule.prototype.FONT_PALETTE_VALUES_RULE;
/** @type {?CSSRule} */ CSSRule.prototype.parentRule;
/** @type {?CSSStyleSheet} */ CSSRule.prototype.parentStyleSheet;
/** @type {!number} */ CSSRule.prototype.type;
/** @type {!CSSOMString} */ CSSRule.prototype.cssText;
/**
 * @constructor
 * @private
 * @extends {PerformanceEntry}
 * @nosideeffects
 */
function PerformanceMark() {}
/**
 * @constructor
 * @private
 * @extends {Credential}
 * @nosideeffects
 */
function PublicKeyCredential() {}
/** @type {!ArrayBuffer} */ PublicKeyCredential.prototype.rawId;
/** @type {!AuthenticatorResponse} */ PublicKeyCredential.prototype.response;
/**
 * @return {!AuthenticationExtensionsClientOutputs}
 */
PublicKeyCredential.prototype.getClientExtensionResults = function() {}
/**
 * @return {!Promise<!boolean>}
 */
PublicKeyCredential.isUserVerifyingPlatformAuthenticatorAvailable = function() {}
/**
 * @constructor
 * @private
 * @extends {WebGLObject}
 * @nosideeffects
 */
function WebGLSync() {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function SVGNumberList() {}
/** @type {!number} */ SVGNumberList.prototype.length;
/** @type {!number} */ SVGNumberList.prototype.numberOfItems;
/**
 * @param {!number} index
 * @return {!SVGNumber}
 */
SVGNumberList.prototype.removeItem = function(index) {}
/**
 * @param {!SVGNumber} newItem
 * @param {!number} index
 * @return {!SVGNumber}
 */
SVGNumberList.prototype.insertItemBefore = function(newItem,index) {}
/**
 * @param {!SVGNumber} newItem
 * @param {!number} index
 * @return {!SVGNumber}
 */
SVGNumberList.prototype.replaceItem = function(newItem,index) {}
/**
 * @return {undefined}
 */
SVGNumberList.prototype.clear = function() {}
/**
 * @param {!number} index
 * @return {!SVGNumber}
 */
SVGNumberList.prototype.getItem = function(index) {}
/**
 * @param {!SVGNumber} newItem
 * @return {!SVGNumber}
 */
SVGNumberList.prototype.initialize = function(newItem) {}
/**
 * @param {!SVGNumber} newItem
 * @return {!SVGNumber}
 */
SVGNumberList.prototype.appendItem = function(newItem) {}
/**
 * @constructor
 * @private
 * @extends {EventTarget}
 * @nosideeffects
 */
function ScreenOrientation() {}
/** @type {!number} */ ScreenOrientation.prototype.angle;
/** @type {!string} */ ScreenOrientation.prototype.type;
/** @type {!NullableEventHandler} */ ScreenOrientation.prototype.onchange;
/**
 * @return {undefined}
 */
ScreenOrientation.prototype.unlock = function() {}
/**
 * @param {!string} orientation
 * @return {!Promise<undefined>}
 */
ScreenOrientation.prototype.lock = function(orientation) {}
/**
 * @constructor
 * @extends {Event}
 * @param {!string} type
 * @param {!MediaEncryptedEventInit=} eventInitDict
 */
function MediaEncryptedEvent(type,eventInitDict) {}
/** @type {?ArrayBuffer} */ MediaEncryptedEvent.prototype.initData;
/** @type {!string} */ MediaEncryptedEvent.prototype.initDataType;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function VTTRegion() {}
/** @type {!string} */ VTTRegion.prototype.id;
/** @type {!number} */ VTTRegion.prototype.lines;
/** @type {!number} */ VTTRegion.prototype.regionAnchorX;
/** @type {!number} */ VTTRegion.prototype.regionAnchorY;
/** @type {!string} */ VTTRegion.prototype.scroll;
/** @type {!number} */ VTTRegion.prototype.viewportAnchorX;
/** @type {!number} */ VTTRegion.prototype.viewportAnchorY;
/** @type {!number} */ VTTRegion.prototype.width;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function XRInputSource() {}
/** @type {?XRSpace} */ XRInputSource.prototype.gripSpace;
/** @type {!string} */ XRInputSource.prototype.handedness;
/** @type {!Array<!string>} */ XRInputSource.prototype.profiles;
/** @type {!string} */ XRInputSource.prototype.targetRayMode;
/** @type {!XRSpace} */ XRInputSource.prototype.targetRaySpace;
/**
 * @constructor
 * @private
 * @extends {SVGTextPositioningElement}
 * @nosideeffects
 */
function SVGTSpanElement() {}
/**
 * @constructor
 * @private
 * @extends {HTMLElement}
 * @nosideeffects
 */
function HTMLBodyElement() {}
/** @type {!NullableEventHandler} */ HTMLBodyElement.prototype.onorientationchange;
/** @type {!string} */ HTMLBodyElement.prototype.aLink;
/** @type {!string} */ HTMLBodyElement.prototype.background;
/** @type {!string} */ HTMLBodyElement.prototype.bgColor;
/** @type {!string} */ HTMLBodyElement.prototype.link;
/** @type {!string} */ HTMLBodyElement.prototype.text;
/** @type {!string} */ HTMLBodyElement.prototype.vLink;
/** @type {!NullableEventHandler} */ HTMLBodyElement.prototype.onafterprint;
/** @type {!NullableEventHandler} */ HTMLBodyElement.prototype.onbeforeprint;
/** @type {!NullableOnBeforeUnloadEventHandler} */ HTMLBodyElement.prototype.onbeforeunload;
/** @type {!NullableEventHandler} */ HTMLBodyElement.prototype.onhashchange;
/** @type {!NullableEventHandler} */ HTMLBodyElement.prototype.onlanguagechange;
/** @type {!NullableEventHandler} */ HTMLBodyElement.prototype.onmessage;
/** @type {!NullableEventHandler} */ HTMLBodyElement.prototype.onmessageerror;
/** @type {!NullableEventHandler} */ HTMLBodyElement.prototype.onoffline;
/** @type {!NullableEventHandler} */ HTMLBodyElement.prototype.ononline;
/** @type {!NullableEventHandler} */ HTMLBodyElement.prototype.onpagehide;
/** @type {!NullableEventHandler} */ HTMLBodyElement.prototype.onpageshow;
/** @type {!NullableEventHandler} */ HTMLBodyElement.prototype.onpopstate;
/** @type {!NullableEventHandler} */ HTMLBodyElement.prototype.onrejectionhandled;
/** @type {!NullableEventHandler} */ HTMLBodyElement.prototype.onstorage;
/** @type {!NullableEventHandler} */ HTMLBodyElement.prototype.onunhandledrejection;
/** @type {!NullableEventHandler} */ HTMLBodyElement.prototype.onunload;
/** @type {!NullableEventHandler} */ HTMLBodyElement.prototype.ongamepadconnected;
/** @type {!NullableEventHandler} */ HTMLBodyElement.prototype.ongamepaddisconnected;
/**
 * @constructor
 * @private
 * @extends {SVGElement}
 * @nosideeffects
 */
function SVGFEMergeElement() {}
/** @type {!SVGAnimatedLength} */ SVGFEMergeElement.prototype.height;
/** @type {!SVGAnimatedString} */ SVGFEMergeElement.prototype.result;
/** @type {!SVGAnimatedLength} */ SVGFEMergeElement.prototype.width;
/** @type {!SVGAnimatedLength} */ SVGFEMergeElement.prototype.x;
/** @type {!SVGAnimatedLength} */ SVGFEMergeElement.prototype.y;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function GPUCommandEncoder() {}
/** @type {?string} */ GPUCommandEncoder.prototype.label;
/**
 * @param {!GPUQuerySet} querySet
 * @param {!GPUSize32} queryIndex
 * @return {undefined}
 */
GPUCommandEncoder.prototype.writeTimestamp = function(querySet,queryIndex) {}
/**
 * @param {!GPUImageCopyTexture} source
 * @param {!GPUImageCopyBuffer} destination
 * @param {!GPUExtent3D} copySize
 * @return {undefined}
 */
GPUCommandEncoder.prototype.copyTextureToBuffer = function(source,destination,copySize) {}
/**
 * @param {!GPUImageCopyBuffer} source
 * @param {!GPUImageCopyTexture} destination
 * @param {!GPUExtent3D} copySize
 * @return {undefined}
 */
GPUCommandEncoder.prototype.copyBufferToTexture = function(source,destination,copySize) {}
/**
 * @param {!GPURenderPassDescriptor} descriptor
 * @return {!GPURenderPassEncoder}
 */
GPUCommandEncoder.prototype.beginRenderPass = function(descriptor) {}
/**
 * @param {!GPUQuerySet} querySet
 * @param {!GPUSize32} firstQuery
 * @param {!GPUSize32} queryCount
 * @param {!GPUBuffer} destination
 * @param {!GPUSize64} destinationOffset
 * @return {undefined}
 */
GPUCommandEncoder.prototype.resolveQuerySet = function(querySet,firstQuery,queryCount,destination,destinationOffset) {}
/**
 * @param {!string} groupLabel
 * @return {undefined}
 */
GPUCommandEncoder.prototype.pushDebugGroup = function(groupLabel) {}
/**
 * @param {!GPUBuffer} source
 * @param {!GPUSize64} sourceOffset
 * @param {!GPUBuffer} destination
 * @param {!GPUSize64} destinationOffset
 * @param {!GPUSize64} size
 * @return {undefined}
 */
GPUCommandEncoder.prototype.copyBufferToBuffer = function(source,sourceOffset,destination,destinationOffset,size) {}
/**
 * @return {undefined}
 */
GPUCommandEncoder.prototype.popDebugGroup = function() {}
/**
 * @param {!GPUCommandBufferDescriptor=} descriptor
 * @return {!GPUCommandBuffer}
 */
GPUCommandEncoder.prototype.finish = function(descriptor) {}
/**
 * @param {!string} markerLabel
 * @return {undefined}
 */
GPUCommandEncoder.prototype.insertDebugMarker = function(markerLabel) {}
/**
 * @param {!GPUImageCopyTexture} source
 * @param {!GPUImageCopyTexture} destination
 * @param {!GPUExtent3D} copySize
 * @return {undefined}
 */
GPUCommandEncoder.prototype.copyTextureToTexture = function(source,destination,copySize) {}
/**
 * @param {!GPUComputePassDescriptor=} descriptor
 * @return {!GPUComputePassEncoder}
 */
GPUCommandEncoder.prototype.beginComputePass = function(descriptor) {}
/**
 * @constructor
 * @private
 * @extends {EventTarget}
 * @nosideeffects
 */
function XRSpace() {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function Plugin() {}
/** @type {!string} */ Plugin.prototype.description;
/** @type {!string} */ Plugin.prototype.filename;
/** @type {!number} */ Plugin.prototype.length;
/** @type {!string} */ Plugin.prototype.name;
/**
 * @param {!string} name
 * @return {?MimeType}
 */
Plugin.prototype.namedItem = function(name) {}
/**
 * @param {!number} index
 * @return {?MimeType}
 */
Plugin.prototype.item = function(index) {}
/**
 * @constructor
 * @private
 * @extends {HTMLElement}
 * @nosideeffects
 */
function HTMLQuoteElement() {}
/** @type {!string} */ HTMLQuoteElement.prototype.cite;
/**
 * @constructor
 * @private
 * @extends {EventTarget}
 * @nosideeffects
 */
function Node() {}
/** @const {!number} */ Node.ATTRIBUTE_NODE;
/** @const {!number} */ Node.prototype.ATTRIBUTE_NODE;
/** @const {!number} */ Node.CDATA_SECTION_NODE;
/** @const {!number} */ Node.prototype.CDATA_SECTION_NODE;
/** @const {!number} */ Node.COMMENT_NODE;
/** @const {!number} */ Node.prototype.COMMENT_NODE;
/** @const {!number} */ Node.DOCUMENT_FRAGMENT_NODE;
/** @const {!number} */ Node.prototype.DOCUMENT_FRAGMENT_NODE;
/** @const {!number} */ Node.DOCUMENT_NODE;
/** @const {!number} */ Node.prototype.DOCUMENT_NODE;
/** @const {!number} */ Node.DOCUMENT_POSITION_CONTAINED_BY;
/** @const {!number} */ Node.prototype.DOCUMENT_POSITION_CONTAINED_BY;
/** @const {!number} */ Node.DOCUMENT_POSITION_CONTAINS;
/** @const {!number} */ Node.prototype.DOCUMENT_POSITION_CONTAINS;
/** @const {!number} */ Node.DOCUMENT_POSITION_DISCONNECTED;
/** @const {!number} */ Node.prototype.DOCUMENT_POSITION_DISCONNECTED;
/** @const {!number} */ Node.DOCUMENT_POSITION_FOLLOWING;
/** @const {!number} */ Node.prototype.DOCUMENT_POSITION_FOLLOWING;
/** @const {!number} */ Node.DOCUMENT_POSITION_IMPLEMENTATION_SPECIFIC;
/** @const {!number} */ Node.prototype.DOCUMENT_POSITION_IMPLEMENTATION_SPECIFIC;
/** @const {!number} */ Node.DOCUMENT_POSITION_PRECEDING;
/** @const {!number} */ Node.prototype.DOCUMENT_POSITION_PRECEDING;
/** @const {!number} */ Node.DOCUMENT_TYPE_NODE;
/** @const {!number} */ Node.prototype.DOCUMENT_TYPE_NODE;
/** @const {!number} */ Node.ELEMENT_NODE;
/** @const {!number} */ Node.prototype.ELEMENT_NODE;
/** @const {!number} */ Node.ENTITY_NODE;
/** @const {!number} */ Node.prototype.ENTITY_NODE;
/** @const {!number} */ Node.ENTITY_REFERENCE_NODE;
/** @const {!number} */ Node.prototype.ENTITY_REFERENCE_NODE;
/** @const {!number} */ Node.NOTATION_NODE;
/** @const {!number} */ Node.prototype.NOTATION_NODE;
/** @const {!number} */ Node.PROCESSING_INSTRUCTION_NODE;
/** @const {!number} */ Node.prototype.PROCESSING_INSTRUCTION_NODE;
/** @const {!number} */ Node.TEXT_NODE;
/** @const {!number} */ Node.prototype.TEXT_NODE;
/** @type {!string} */ Node.prototype.baseURI;
/** @type {!NodeList} */ Node.prototype.childNodes;
/** @type {?Node} */ Node.prototype.firstChild;
/** @type {!boolean} */ Node.prototype.isConnected;
/** @type {?Node} */ Node.prototype.lastChild;
/** @type {?Node} */ Node.prototype.nextSibling;
/** @type {!string} */ Node.prototype.nodeName;
/** @type {!number} */ Node.prototype.nodeType;
/** @type {?Document} */ Node.prototype.ownerDocument;
/** @type {?Element} */ Node.prototype.parentElement;
/** @type {?Node} */ Node.prototype.parentNode;
/** @type {?Node} */ Node.prototype.previousSibling;
/** @type {?string} */ Node.prototype.nodeValue;
/** @type {?string} */ Node.prototype.textContent;
/**
 * @param {!Node} node
 * @return {!Node}
 */
Node.prototype.appendChild = function(node) {}
/**
 * @param {!Node} node
 * @param {!Node} child
 * @return {!Node}
 */
Node.prototype.replaceChild = function(node,child) {}
/**
 * @return {!boolean}
 * @nosideeffects
 */
Node.prototype.hasChildNodes = function() {}
/**
 * @param {?string} namespace
 * @return {!boolean}
 * @nosideeffects
 */
Node.prototype.isDefaultNamespace = function(namespace) {}
/**
 * @param {?string} namespace
 * @return {?string}
 * @nosideeffects
 */
Node.prototype.lookupPrefix = function(namespace) {}
/**
 * @param {?string} prefix
 * @return {?string}
 * @nosideeffects
 */
Node.prototype.lookupNamespaceURI = function(prefix) {}
/**
 * @param {!Node} child
 * @return {!Node}
 */
Node.prototype.removeChild = function(child) {}
/**
 * @param {!boolean=} deep
 * @return {!Node}
 * @nosideeffects
 */
Node.prototype.cloneNode = function(deep) {}
/**
 * @param {!Node} other
 * @return {!number}
 * @nosideeffects
 */
Node.prototype.compareDocumentPosition = function(other) {}
/**
 * @param {!Node} node
 * @param {?Node} child
 * @return {!Node}
 */
Node.prototype.insertBefore = function(node,child) {}
/**
 * @param {?Node} other
 * @return {!boolean}
 * @nosideeffects
 */
Node.prototype.contains = function(other) {}
/**
 * @param {?Node} otherNode
 * @return {!boolean}
 * @nosideeffects
 */
Node.prototype.isEqualNode = function(otherNode) {}
/**
 * @return {undefined}
 */
Node.prototype.normalize = function() {}
/**
 * @param {?Node} otherNode
 * @return {!boolean}
 * @nosideeffects
 */
Node.prototype.isSameNode = function(otherNode) {}
/**
 * @param {!GetRootNodeOptions=} options
 * @return {!Node}
 */
Node.prototype.getRootNode = function(options) {}
/**
 * @constructor
 * @private
 * @extends {HTMLElement}
 * @nosideeffects
 */
function HTMLInputElement() {}
/** @type {?HTMLFormElement} */ HTMLInputElement.prototype.form;
/** @type {?NodeList} */ HTMLInputElement.prototype.labels;
/** @type {?HTMLElement} */ HTMLInputElement.prototype.list;
/** @type {!string} */ HTMLInputElement.prototype.validationMessage;
/** @type {!ValidityState} */ HTMLInputElement.prototype.validity;
/** @type {!boolean} */ HTMLInputElement.prototype.willValidate;
/** @type {!string} */ HTMLInputElement.prototype.accept;
/** @type {!string} */ HTMLInputElement.prototype.alt;
/** @type {!string} */ HTMLInputElement.prototype.autocomplete;
/** @type {!boolean} */ HTMLInputElement.prototype.checked;
/** @type {!boolean} */ HTMLInputElement.prototype.defaultChecked;
/** @type {!string} */ HTMLInputElement.prototype.defaultValue;
/** @type {!string} */ HTMLInputElement.prototype.dirName;
/** @type {!boolean} */ HTMLInputElement.prototype.disabled;
/** @type {?FileList} */ HTMLInputElement.prototype.files;
/** @type {!string} */ HTMLInputElement.prototype.formAction;
/** @type {!string} */ HTMLInputElement.prototype.formEnctype;
/** @type {!string} */ HTMLInputElement.prototype.formMethod;
/** @type {!boolean} */ HTMLInputElement.prototype.formNoValidate;
/** @type {!string} */ HTMLInputElement.prototype.formTarget;
/** @type {!number} */ HTMLInputElement.prototype.height;
/** @type {!boolean} */ HTMLInputElement.prototype.indeterminate;
/** @type {!string} */ HTMLInputElement.prototype.max;
/** @type {!number} */ HTMLInputElement.prototype.maxLength;
/** @type {!string} */ HTMLInputElement.prototype.min;
/** @type {!number} */ HTMLInputElement.prototype.minLength;
/** @type {!boolean} */ HTMLInputElement.prototype.multiple;
/** @type {!string} */ HTMLInputElement.prototype.name;
/** @type {!string} */ HTMLInputElement.prototype.pattern;
/** @type {!string} */ HTMLInputElement.prototype.placeholder;
/** @type {!boolean} */ HTMLInputElement.prototype.readOnly;
/** @type {!boolean} */ HTMLInputElement.prototype.required;
/** @type {?string} */ HTMLInputElement.prototype.selectionDirection;
/** @type {?number} */ HTMLInputElement.prototype.selectionEnd;
/** @type {?number} */ HTMLInputElement.prototype.selectionStart;
/** @type {!number} */ HTMLInputElement.prototype.size;
/** @type {!string} */ HTMLInputElement.prototype.src;
/** @type {!string} */ HTMLInputElement.prototype.step;
/** @type {!string} */ HTMLInputElement.prototype.type;
/** @type {!string} */ HTMLInputElement.prototype.value;
/** @type {?Object} */ HTMLInputElement.prototype.valueAsDate;
/** @type {!number} */ HTMLInputElement.prototype.valueAsNumber;
/** @type {!number} */ HTMLInputElement.prototype.width;
/** @type {!string} */ HTMLInputElement.prototype.align;
/** @type {!string} */ HTMLInputElement.prototype.useMap;
/**
 * @param {!number=} n
 * @return {undefined}
 */
HTMLInputElement.prototype.stepDown = function(n) {}
/**
 * @return {undefined}
 */
HTMLInputElement.prototype.select = function() {}
/**
 * @param {!string} error
 * @return {undefined}
 */
HTMLInputElement.prototype.setCustomValidity = function(error) {}
/**
 * @return {!boolean}
 */
HTMLInputElement.prototype.reportValidity = function() {}
/**
 * @param {!number=} n
 * @return {undefined}
 */
HTMLInputElement.prototype.stepUp = function(n) {}
/**
 * @param {!string} arg0
 * @param {!number=} arg1
 * @param {!number=} arg2
 * @param {!string=} arg3
 * @return {undefined}
 */
HTMLInputElement.prototype.setRangeText = function(arg0,arg1,arg2,arg3) {}
/**
 * @param {!number} start
 * @param {!number} end
 * @param {!string=} direction
 * @return {undefined}
 */
HTMLInputElement.prototype.setSelectionRange = function(start,end,direction) {}
/**
 * @return {!boolean}
 */
HTMLInputElement.prototype.checkValidity = function() {}
/**
 * @constructor
 * @extends {UIEvent}
 * @param {!string} type
 * @param {!KeyboardEventInit=} eventInitDict
 */
function KeyboardEvent(type,eventInitDict) {}
/** @const {!number} */ KeyboardEvent.DOM_KEY_LOCATION_LEFT;
/** @const {!number} */ KeyboardEvent.prototype.DOM_KEY_LOCATION_LEFT;
/** @const {!number} */ KeyboardEvent.DOM_KEY_LOCATION_NUMPAD;
/** @const {!number} */ KeyboardEvent.prototype.DOM_KEY_LOCATION_NUMPAD;
/** @const {!number} */ KeyboardEvent.DOM_KEY_LOCATION_RIGHT;
/** @const {!number} */ KeyboardEvent.prototype.DOM_KEY_LOCATION_RIGHT;
/** @const {!number} */ KeyboardEvent.DOM_KEY_LOCATION_STANDARD;
/** @const {!number} */ KeyboardEvent.prototype.DOM_KEY_LOCATION_STANDARD;
/** @type {!boolean} */ KeyboardEvent.prototype.altKey;
/** @type {!string} */ KeyboardEvent.prototype.code;
/** @type {!boolean} */ KeyboardEvent.prototype.ctrlKey;
/** @type {!boolean} */ KeyboardEvent.prototype.isComposing;
/** @type {!string} */ KeyboardEvent.prototype.key;
/** @type {!number} */ KeyboardEvent.prototype.location;
/** @type {!boolean} */ KeyboardEvent.prototype.metaKey;
/** @type {!boolean} */ KeyboardEvent.prototype.repeat;
/** @type {!boolean} */ KeyboardEvent.prototype.shiftKey;
/** @type {!number} */ KeyboardEvent.prototype.charCode;
/** @type {!number} */ KeyboardEvent.prototype.keyCode;
/**
 * @param {!string} keyArg
 * @return {!boolean}
 */
KeyboardEvent.prototype.getModifierState = function(keyArg) {}
/**
 * @constructor
 * @private
 * @extends {SVGElement}
 * @nosideeffects
 */
function SVGFESpecularLightingElement() {}
/** @type {!SVGAnimatedString} */ SVGFESpecularLightingElement.prototype.in1;
/** @type {!SVGAnimatedNumber} */ SVGFESpecularLightingElement.prototype.kernelUnitLengthX;
/** @type {!SVGAnimatedNumber} */ SVGFESpecularLightingElement.prototype.kernelUnitLengthY;
/** @type {!SVGAnimatedNumber} */ SVGFESpecularLightingElement.prototype.specularConstant;
/** @type {!SVGAnimatedNumber} */ SVGFESpecularLightingElement.prototype.specularExponent;
/** @type {!SVGAnimatedNumber} */ SVGFESpecularLightingElement.prototype.surfaceScale;
/** @type {!SVGAnimatedLength} */ SVGFESpecularLightingElement.prototype.height;
/** @type {!SVGAnimatedString} */ SVGFESpecularLightingElement.prototype.result;
/** @type {!SVGAnimatedLength} */ SVGFESpecularLightingElement.prototype.width;
/** @type {!SVGAnimatedLength} */ SVGFESpecularLightingElement.prototype.x;
/** @type {!SVGAnimatedLength} */ SVGFESpecularLightingElement.prototype.y;
/**
 * @constructor
 * @private
 * @extends {EventTarget}
 * @nosideeffects
 */
function MediaQueryList() {}
/** @type {!boolean} */ MediaQueryList.prototype.matches;
/** @type {!CSSOMString} */ MediaQueryList.prototype.media;
/** @type {!NullableEventHandler} */ MediaQueryList.prototype.onchange;
/**
 * @param {?EventListener} callback
 * @return {undefined}
 */
MediaQueryList.prototype.removeListener = function(callback) {}
/**
 * @param {?EventListener} callback
 * @return {undefined}
 */
MediaQueryList.prototype.addListener = function(callback) {}
/**
 * @constructor
 * @extends {Node}
 */
function Document() {}
/** @type {!string} */ Document.prototype.URL;
/** @type {!string} */ Document.prototype.characterSet;
/** @type {!string} */ Document.prototype.charset;
/** @type {!string} */ Document.prototype.compatMode;
/** @type {!string} */ Document.prototype.contentType;
/** @type {?DocumentType} */ Document.prototype.doctype;
/** @type {?Element} */ Document.prototype.documentElement;
/** @type {!string} */ Document.prototype.documentURI;
/** @type {!DOMImplementation} */ Document.prototype.implementation;
/** @type {!string} */ Document.prototype.inputEncoding;
/** @type {?Element} */ Document.prototype.scrollingElement;
/** @type {!boolean} */ Document.prototype.hidden;
/** @type {!string} */ Document.prototype.visibilityState;
/** @type {?EventHandler} */ Document.prototype.onvisibilitychange;
/** @type {?EventHandler} */ Document.prototype.onpointerlockchange;
/** @type {?EventHandler} */ Document.prototype.onpointerlockerror;
/** @type {?SVGSVGElement} */ Document.prototype.rootElement;
/** @type {!DocumentTimeline} */ Document.prototype.timeline;
/** @type {!boolean} */ Document.prototype.fullscreen;
/** @type {!boolean} */ Document.prototype.fullscreenEnabled;
/** @type {?EventHandler} */ Document.prototype.onfullscreenchange;
/** @type {!NullableEventHandler} */ Document.prototype.onfullscreenerror;
/** @type {?HTMLOrSVGScriptElement} */ Document.prototype.currentScript;
/** @type {?WindowProxy} */ Document.prototype.defaultView;
/** @type {!HTMLCollection} */ Document.prototype.embeds;
/** @type {!HTMLCollection} */ Document.prototype.forms;
/** @type {?HTMLHeadElement} */ Document.prototype.head;
/** @type {!HTMLCollection} */ Document.prototype.images;
/** @type {!string} */ Document.prototype.lastModified;
/** @type {!HTMLCollection} */ Document.prototype.links;
/** @type {?Location} */ Document.prototype.location;
/** @type {!HTMLCollection} */ Document.prototype.plugins;
/** @type {!string} */ Document.prototype.readyState;
/** @type {!string} */ Document.prototype.referrer;
/** @type {!HTMLCollection} */ Document.prototype.scripts;
/** @type {?HTMLElement} */ Document.prototype.body;
/** @type {!string} */ Document.prototype.cookie;
/** @type {!string} */ Document.prototype.designMode;
/** @type {!string} */ Document.prototype.dir;
/** @type {!string} */ Document.prototype.domain;
/** @type {?EventHandler} */ Document.prototype.onreadystatechange;
/** @type {!string} */ Document.prototype.title;
/** @type {!HTMLAllCollection} */ Document.prototype.all;
/** @type {!HTMLCollection} */ Document.prototype.anchors;
/** @type {!string} */ Document.prototype.alinkColor;
/** @type {!string} */ Document.prototype.bgColor;
/** @type {!string} */ Document.prototype.fgColor;
/** @type {!string} */ Document.prototype.linkColor;
/** @type {!string} */ Document.prototype.vlinkColor;
/** @type {!number} */ Document.prototype.childElementCount;
/** @type {!HTMLCollection} */ Document.prototype.children;
/** @type {?Element} */ Document.prototype.firstElementChild;
/** @type {?Element} */ Document.prototype.lastElementChild;
/** @type {?ClipboardEventHandler} */ Document.prototype.oncopy;
/** @type {?ClipboardEventHandler} */ Document.prototype.oncut;
/** @type {?ClipboardEventHandler} */ Document.prototype.onpaste;
/** @type {!NullableEventHandler} */ Document.prototype.onabort;
/** @type {!NullableEventHandler} */ Document.prototype.onauxclick;
/** @type {!NullableEventHandler} */ Document.prototype.onblur;
/** @type {!NullableEventHandler} */ Document.prototype.oncancel;
/** @type {!NullableEventHandler} */ Document.prototype.oncanplay;
/** @type {!NullableEventHandler} */ Document.prototype.oncanplaythrough;
/** @type {!NullableEventHandler} */ Document.prototype.onchange;
/** @type {!NullableEventHandler} */ Document.prototype.onclick;
/** @type {!NullableEventHandler} */ Document.prototype.onclose;
/** @type {!NullableEventHandler} */ Document.prototype.oncontextmenu;
/** @type {!NullableEventHandler} */ Document.prototype.oncuechange;
/** @type {!NullableEventHandler} */ Document.prototype.ondblclick;
/** @type {?DragEventHandler} */ Document.prototype.ondrag;
/** @type {?DragEventHandler} */ Document.prototype.ondragend;
/** @type {?DragEventHandler} */ Document.prototype.ondragenter;
/** @type {?DragEventHandler} */ Document.prototype.ondragleave;
/** @type {?DragEventHandler} */ Document.prototype.ondragover;
/** @type {?DragEventHandler} */ Document.prototype.ondragstart;
/** @type {?DragEventHandler} */ Document.prototype.ondrop;
/** @type {!NullableEventHandler} */ Document.prototype.ondurationchange;
/** @type {!NullableEventHandler} */ Document.prototype.onemptied;
/** @type {!NullableEventHandler} */ Document.prototype.onended;
/** @type {!NullableOnErrorEventHandler} */ Document.prototype.onerror;
/** @type {!NullableEventHandler} */ Document.prototype.onfocus;
/** @type {!NullableEventHandler} */ Document.prototype.onformdata;
/** @type {!NullableEventHandler} */ Document.prototype.oninput;
/** @type {!NullableEventHandler} */ Document.prototype.oninvalid;
/** @type {?KeyboardEventHandler} */ Document.prototype.onkeydown;
/** @type {!NullableEventHandler} */ Document.prototype.onkeypress;
/** @type {?KeyboardEventHandler} */ Document.prototype.onkeyup;
/** @type {!NullableEventHandler} */ Document.prototype.onload;
/** @type {!NullableEventHandler} */ Document.prototype.onloadeddata;
/** @type {!NullableEventHandler} */ Document.prototype.onloadedmetadata;
/** @type {!NullableEventHandler} */ Document.prototype.onloadstart;
/** @type {!NullableEventHandler} */ Document.prototype.onmousedown;
/** @type {!NullableEventHandler} */ Document.prototype.onmouseenter;
/** @type {!NullableEventHandler} */ Document.prototype.onmouseleave;
/** @type {!NullableEventHandler} */ Document.prototype.onmousemove;
/** @type {!NullableEventHandler} */ Document.prototype.onmouseout;
/** @type {!NullableEventHandler} */ Document.prototype.onmouseover;
/** @type {!NullableEventHandler} */ Document.prototype.onmouseup;
/** @type {!NullableEventHandler} */ Document.prototype.onpause;
/** @type {!NullableEventHandler} */ Document.prototype.onplay;
/** @type {!NullableEventHandler} */ Document.prototype.onplaying;
/** @type {!NullableEventHandler} */ Document.prototype.onprogress;
/** @type {!NullableEventHandler} */ Document.prototype.onratechange;
/** @type {!NullableEventHandler} */ Document.prototype.onreset;
/** @type {!NullableEventHandler} */ Document.prototype.onresize;
/** @type {?EventHandler} */ Document.prototype.onscroll;
/** @type {!NullableEventHandler} */ Document.prototype.onsecuritypolicyviolation;
/** @type {!NullableEventHandler} */ Document.prototype.onseeked;
/** @type {!NullableEventHandler} */ Document.prototype.onseeking;
/** @type {!NullableEventHandler} */ Document.prototype.onselect;
/** @type {!NullableEventHandler} */ Document.prototype.onslotchange;
/** @type {!NullableEventHandler} */ Document.prototype.onstalled;
/** @type {!NullableEventHandler} */ Document.prototype.onsubmit;
/** @type {!NullableEventHandler} */ Document.prototype.onsuspend;
/** @type {!NullableEventHandler} */ Document.prototype.ontimeupdate;
/** @type {!NullableEventHandler} */ Document.prototype.ontoggle;
/** @type {!NullableEventHandler} */ Document.prototype.onvolumechange;
/** @type {!NullableEventHandler} */ Document.prototype.onwaiting;
/** @type {!NullableEventHandler} */ Document.prototype.onwebkitanimationend;
/** @type {!NullableEventHandler} */ Document.prototype.onwebkitanimationiteration;
/** @type {!NullableEventHandler} */ Document.prototype.onwebkitanimationstart;
/** @type {!NullableEventHandler} */ Document.prototype.onwebkittransitionend;
/** @type {?WheelEventHandler} */ Document.prototype.onwheel;
/** @type {?AnimationEventHandler} */ Document.prototype.onanimationcancel;
/** @type {?AnimationEventHandler} */ Document.prototype.onanimationend;
/** @type {?AnimationEventHandler} */ Document.prototype.onanimationiteration;
/** @type {?AnimationEventHandler} */ Document.prototype.onanimationstart;
/** @type {?TransitionEventHandler} */ Document.prototype.ontransitioncancel;
/** @type {?TransitionEventHandler} */ Document.prototype.ontransitionend;
/** @type {?TransitionEventHandler} */ Document.prototype.ontransitionrun;
/** @type {?TransitionEventHandler} */ Document.prototype.ontransitionstart;
/** @type {?PointerEventHandler} */ Document.prototype.ongotpointercapture;
/** @type {?PointerEventHandler} */ Document.prototype.onlostpointercapture;
/** @type {?PointerEventHandler} */ Document.prototype.onpointercancel;
/** @type {?PointerEventHandler} */ Document.prototype.onpointerdown;
/** @type {?PointerEventHandler} */ Document.prototype.onpointerenter;
/** @type {?PointerEventHandler} */ Document.prototype.onpointerleave;
/** @type {?PointerEventHandler} */ Document.prototype.onpointermove;
/** @type {?PointerEventHandler} */ Document.prototype.onpointerout;
/** @type {?PointerEventHandler} */ Document.prototype.onpointerover;
/** @type {?PointerEventHandler} */ Document.prototype.onpointerup;
/** @type {?EventHandler} */ Document.prototype.onselectionchange;
/** @type {?EventHandler} */ Document.prototype.onselectstart;
/** @type {?TouchEventHandler} */ Document.prototype.ontouchcancel;
/** @type {?TouchEventHandler} */ Document.prototype.ontouchend;
/** @type {?TouchEventHandler} */ Document.prototype.ontouchmove;
/** @type {?TouchEventHandler} */ Document.prototype.ontouchstart;
/** @type {!StyleSheetList} */ Document.prototype.styleSheets;
/** @type {?Element} */ Document.prototype.pointerLockElement;
/** @type {?Element} */ Document.prototype.fullscreenElement;
/** @type {?Element} */ Document.prototype.activeElement;
/**
 * @param {!string} elementId
 * @return {?Element}
 * @nosideeffects
 */
Document.prototype.getElementById = function(elementId) {}
/**
 * @param {!string} data
 * @return {!Text}
 * @nosideeffects
 */
Document.prototype.createTextNode = function(data) {}
/**
 * @param {!string} selectors
 * @return {!NodeList}
 * @nosideeffects
 */
Document.prototype.querySelectorAll = function(selectors) {}
/**
 * @param {...(!Node|!string)} nodes
 * @return {undefined}
 */
Document.prototype.prepend = function(nodes) {}
/**
 * @param {!string} commandId
 * @return {!string}
 */
Document.prototype.queryCommandValue = function(commandId) {}
/**
 * @param {!string} commandId
 * @return {!boolean}
 */
Document.prototype.queryCommandState = function(commandId) {}
/**
 * @param {!string} commandId
 * @return {!boolean}
 */
Document.prototype.queryCommandSupported = function(commandId) {}
/**
 * @param {!string} data
 * @return {!Comment}
 * @nosideeffects
 */
Document.prototype.createComment = function(data) {}
/**
 * @param {!Node} node
 * @return {!Node}
 */
Document.prototype.adoptNode = function(node) {}
/**
 * @param {!number} x
 * @param {!number} y
 * @return {!Array<!Element>}
 * @nosideeffects
 */
Document.prototype.elementsFromPoint = function(x,y) {}
/**
 * @param {?string} namespace
 * @param {!string} localName
 * @return {!HTMLCollection}
 * @nosideeffects
 */
Document.prototype.getElementsByTagNameNS = function(namespace,localName) {}
/**
 * @param {!string} elementName
 * @return {!NodeList}
 * @nosideeffects
 */
Document.prototype.getElementsByName = function(elementName) {}
/**
 * @param {!number} x
 * @param {!number} y
 * @return {?CaretPosition}
 */
Document.prototype.caretPositionFromPoint = function(x,y) {}
/**
 * @param {!string} interface_
 * @return {!Event}
 */
Document.prototype.createEvent = function(interface_) {}
/**
 * @return {!Array<!Animation>}
 */
Document.prototype.getAnimations = function() {}
/**
 * @return {!boolean}
 */
Document.prototype.hasFocus = function() {}
/**
 * @param {...!string} text
 * @return {undefined}
 */
Document.prototype.write = function(text) {}
/**
 * @return {undefined}
 */
Document.prototype.close = function() {}
/**
 * @param {!string} qualifiedName
 * @return {!HTMLCollection}
 * @nosideeffects
 */
Document.prototype.getElementsByTagName = function(qualifiedName) {}
/**
 * @param {...(!Node|!string)} nodes
 * @return {undefined}
 */
Document.prototype.replaceChildren = function(nodes) {}
/**
 * @param {!number} x
 * @param {!number} y
 * @return {?Element}
 * @nosideeffects
 */
Document.prototype.elementFromPoint = function(x,y) {}
/**
 * @param {!string} commandId
 * @param {!boolean=} showUI
 * @param {!string=} value
 * @return {!boolean}
 */
Document.prototype.execCommand = function(commandId,showUI,value) {}
/**
 * @param {!string} commandId
 * @return {!boolean}
 */
Document.prototype.queryCommandIndeterm = function(commandId) {}
/**
 * @param {?string} namespace
 * @param {!string} qualifiedName
 * @return {!Attr}
 */
Document.prototype.createAttributeNS = function(namespace,qualifiedName) {}
/**
 * @param {?string} namespace
 * @param {!string} qualifiedName
 * @param {(!string|!ElementCreationOptions)=} options
 * @return {!Element}
 */
Document.prototype.createElementNS = function(namespace,qualifiedName,options) {}
/**
 * @param {!string} data
 * @return {!CDATASection}
 * @nosideeffects
 */
Document.prototype.createCDATASection = function(data) {}
/**
 * @param {!string} selectors
 * @return {?Element}
 * @nosideeffects
 */
Document.prototype.querySelector = function(selectors) {}
/**
 * @param {...!string} text
 * @return {undefined}
 */
Document.prototype.writeln = function(text) {}
/**
 * @param {!string} localName
 * @param {(!string|!ElementCreationOptions)=} options
 * @return {!Element}
 * @nosideeffects
 */
Document.prototype.createElement = function(localName,options) {}
/**
 * @param {!Node} root
 * @param {!number=} whatToShow
 * @param {?NodeFilter=} filter
 * @return {!TreeWalker}
 * @nosideeffects
 */
Document.prototype.createTreeWalker = function(root,whatToShow,filter) {}
/**
 * @param {!Node} root
 * @param {!number=} whatToShow
 * @param {?NodeFilter=} filter
 * @return {!NodeIterator}
 * @nosideeffects
 */
Document.prototype.createNodeIterator = function(root,whatToShow,filter) {}
/**
 * @param {!Node} node
 * @param {!boolean=} deep
 * @return {!Node}
 */
Document.prototype.importNode = function(node,deep) {}
/**
 * @return {!Promise<undefined>}
 */
Document.prototype.exitFullscreen = function() {}
/**
 * @return {?Selection}
 * @nosideeffects
 */
Document.prototype.getSelection = function() {}
/**
 * @param {!string} localName
 * @return {!Attr}
 * @nosideeffects
 */
Document.prototype.createAttribute = function(localName) {}
/**
 * @return {!Range}
 */
Document.prototype.createRange = function() {}
/**
 * @param {!string} commandId
 * @return {!boolean}
 */
Document.prototype.queryCommandEnabled = function(commandId) {}
/**
 * @return {!DocumentFragment}
 * @nosideeffects
 */
Document.prototype.createDocumentFragment = function() {}
/**
 * @param {!Node} nodeResolver
 * @return {!XPathNSResolver}
 */
Document.prototype.createNSResolver = function(nodeResolver) {}
/**
 * @return {undefined}
 */
Document.prototype.exitPointerLock = function() {}
/**
 * @param {!string} target
 * @param {!string} data
 * @return {!ProcessingInstruction}
 * @nosideeffects
 */
Document.prototype.createProcessingInstruction = function(target,data) {}
/**
 * @param {!string} classNames
 * @return {!HTMLCollection}
 * @nosideeffects
 */
Document.prototype.getElementsByClassName = function(classNames) {}
/**
 * @param {!string} expression
 * @param {!Node} contextNode
 * @param {?XPathNSResolver=} resolver
 * @param {!number=} type
 * @param {?XPathResult=} result
 * @return {!XPathResult}
 */
Document.prototype.evaluate = function(expression,contextNode,resolver,type,result) {}
/**
 * @param {...(!Node|!string)} nodes
 * @return {undefined}
 */
Document.prototype.append = function(nodes) {}
/**
 * @param {(!string|!string)=} arg0
 * @param {!string=} arg1
 * @param {!string=} arg2
 * @return {(!Document|?WindowProxy)}
 */
Document.prototype.open = function(arg0,arg1,arg2) {}
/**
 * @param {!string} expression
 * @param {?XPathNSResolver=} resolver
 * @return {!XPathExpression}
 */
Document.prototype.createExpression = function(expression,resolver) {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function History() {}
/** @type {!number} */ History.prototype.length;
/** @type {*} */ History.prototype.state;
/** @type {!string} */ History.prototype.scrollRestoration;
/**
 * @param {*} data
 * @param {!string} unused
 * @param {?string=} url
 * @return {undefined}
 */
History.prototype.pushState = function(data,unused,url) {}
/**
 * @return {undefined}
 */
History.prototype.forward = function() {}
/**
 * @param {!number=} delta
 * @return {undefined}
 */
History.prototype.go = function(delta) {}
/**
 * @return {undefined}
 */
History.prototype.back = function() {}
/**
 * @param {*} data
 * @param {!string} unused
 * @param {?string=} url
 * @return {undefined}
 */
History.prototype.replaceState = function(data,unused,url) {}
/**
 * @constructor
 * @private
 * @extends {Node}
 * @nosideeffects
 */
function Attr() {}
/** @type {!string} */ Attr.prototype.localName;
/** @type {!string} */ Attr.prototype.name;
/** @type {?string} */ Attr.prototype.namespaceURI;
/** @type {?Element} */ Attr.prototype.ownerElement;
/** @type {?string} */ Attr.prototype.prefix;
/** @type {!boolean} */ Attr.prototype.specified;
/** @type {!string} */ Attr.prototype.value;
/**
 * @constructor
 * @private
 * @extends {Document}
 * @nosideeffects
 */
function XMLDocument() {}
/**
 * @constructor
 * @private
 * @extends {EventTarget}
 * @nosideeffects
 */
function SpeechSynthesis() {}
/** @type {!boolean} */ SpeechSynthesis.prototype.paused;
/** @type {!boolean} */ SpeechSynthesis.prototype.pending;
/** @type {!boolean} */ SpeechSynthesis.prototype.speaking;
/** @type {?EventHandler} */ SpeechSynthesis.prototype.onvoiceschanged;
/**
 * @return {undefined}
 */
SpeechSynthesis.prototype.resume = function() {}
/**
 * @return {undefined}
 */
SpeechSynthesis.prototype.cancel = function() {}
/**
 * @return {!Array<!SpeechSynthesisVoice>}
 */
SpeechSynthesis.prototype.getVoices = function() {}
/**
 * @param {!SpeechSynthesisUtterance} utterance
 * @return {undefined}
 */
SpeechSynthesis.prototype.speak = function(utterance) {}
/**
 * @return {undefined}
 */
SpeechSynthesis.prototype.pause = function() {}
/**
 * @constructor
 * @extends {AudioNode}
 * @param {!BaseAudioContext} context
 * @param {!string} name
 * @param {!AudioWorkletNodeOptions=} options
 */
function AudioWorkletNode(context,name,options) {}
/** @type {!AudioParamMap} */ AudioWorkletNode.prototype.parameters;
/** @type {!MessagePort} */ AudioWorkletNode.prototype.port;
/** @type {!NullableEventHandler} */ AudioWorkletNode.prototype.onprocessorerror;
/**
 * @constructor
 * @private
 * @extends {HTMLElement}
 * @nosideeffects
 */
function HTMLTableColElement() {}
/** @type {!number} */ HTMLTableColElement.prototype.span;
/** @type {!string} */ HTMLTableColElement.prototype.align;
/** @type {!string} */ HTMLTableColElement.prototype.ch;
/** @type {!string} */ HTMLTableColElement.prototype.chOff;
/** @type {!string} */ HTMLTableColElement.prototype.vAlign;
/** @type {!string} */ HTMLTableColElement.prototype.width;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function DataTransferItemList() {}
/** @type {!number} */ DataTransferItemList.prototype.length;
/**
 * @param {(!string|!File)} arg0
 * @param {!string=} arg1
 * @return {?DataTransferItem}
 */
DataTransferItemList.prototype.add = function(arg0,arg1) {}
/**
 * @return {undefined}
 */
DataTransferItemList.prototype.clear = function() {}
/**
 * @param {!number} index
 * @return {undefined}
 */
DataTransferItemList.prototype.remove = function(index) {}
/**
 * @constructor
 * @extends {AnimationEffect}
 * @param {(?Element|!KeyframeEffect)} arg0
 * @param {?Object=} arg1
 * @param {(!number|!KeyframeEffectOptions)=} arg2
 */
function KeyframeEffect(arg0,arg1,arg2) {}
/** @type {!string} */ KeyframeEffect.prototype.composite;
/** @type {?CSSOMString} */ KeyframeEffect.prototype.pseudoElement;
/** @type {?Element} */ KeyframeEffect.prototype.target;
/**
 * @param {?Object} keyframes
 * @return {undefined}
 */
KeyframeEffect.prototype.setKeyframes = function(keyframes) {}
/**
 * @return {!Array<!Object>}
 */
KeyframeEffect.prototype.getKeyframes = function() {}
/**
 * @constructor
 * @private
 * @extends {HTMLElement}
 * @nosideeffects
 */
function HTMLTableCaptionElement() {}
/** @type {!string} */ HTMLTableCaptionElement.prototype.align;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function StyleSheetList() {}
/** @type {!number} */ StyleSheetList.prototype.length;
/**
 * @param {!number} index
 * @return {?CSSStyleSheet}
 */
StyleSheetList.prototype.item = function(index) {}
/**
 * @constructor
 * @private
 * @extends {HTMLElement}
 * @nosideeffects
 */
function HTMLUnknownElement() {}
/**
 * @constructor
 * @private
 * @extends {HTMLElement}
 * @nosideeffects
 */
function HTMLMenuElement() {}
/** @type {!boolean} */ HTMLMenuElement.prototype.compact;
/**
 * @constructor
 * @extends {Object}
 * @param {!AudioDataInit} init
 */
function AudioData(init) {}
/** @type {!number} */ AudioData.prototype.duration;
/** @type {!string} */ AudioData.prototype.format;
/** @type {!number} */ AudioData.prototype.numberOfChannels;
/** @type {!number} */ AudioData.prototype.numberOfFrames;
/** @type {!number} */ AudioData.prototype.sampleRate;
/** @type {!number} */ AudioData.prototype.timestamp;
/**
 * @param {!BufferSource} destination
 * @param {!AudioDataCopyToOptions} options
 * @return {undefined}
 */
AudioData.prototype.copyTo = function(destination,options) {}
/**
 * @param {!AudioDataCopyToOptions} options
 * @return {!number}
 */
AudioData.prototype.allocationSize = function(options) {}
/**
 * @return {!AudioData}
 */
AudioData.prototype.clone = function() {}
/**
 * @return {undefined}
 */
AudioData.prototype.close = function() {}
/**
 * @constructor
 * @private
 * @extends {HTMLElement}
 * @nosideeffects
 */
function HTMLModElement() {}
/** @type {!string} */ HTMLModElement.prototype.cite;
/** @type {!string} */ HTMLModElement.prototype.dateTime;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function EXT_texture_filter_anisotropic() {}
/** @const {!GLenum} */ EXT_texture_filter_anisotropic.prototype.MAX_TEXTURE_MAX_ANISOTROPY_EXT;
/** @const {!GLenum} */ EXT_texture_filter_anisotropic.prototype.TEXTURE_MAX_ANISOTROPY_EXT;
/**
 * @constructor
 * @private
 * @extends {CSSConditionRule}
 * @nosideeffects
 */
function CSSMediaRule() {}
/** @type {!MediaList} */ CSSMediaRule.prototype.media;
/**
 * @constructor
 * @private
 * @extends {WebGLObject}
 * @nosideeffects
 */
function WebGLTimerQueryEXT() {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function WritableStreamDefaultController() {}
/**
 * @param {*=} e
 * @return {undefined}
 */
WritableStreamDefaultController.prototype.error = function(e) {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function AudioListener() {}
/** @type {!AudioParam} */ AudioListener.prototype.forwardX;
/** @type {!AudioParam} */ AudioListener.prototype.forwardY;
/** @type {!AudioParam} */ AudioListener.prototype.forwardZ;
/** @type {!AudioParam} */ AudioListener.prototype.positionX;
/** @type {!AudioParam} */ AudioListener.prototype.positionY;
/** @type {!AudioParam} */ AudioListener.prototype.positionZ;
/** @type {!AudioParam} */ AudioListener.prototype.upX;
/** @type {!AudioParam} */ AudioListener.prototype.upY;
/** @type {!AudioParam} */ AudioListener.prototype.upZ;
/**
 * @param {!number} x
 * @param {!number} y
 * @param {!number} z
 * @param {!number} xUp
 * @param {!number} yUp
 * @param {!number} zUp
 * @return {undefined}
 */
AudioListener.prototype.setOrientation = function(x,y,z,xUp,yUp,zUp) {}
/**
 * @param {!number} x
 * @param {!number} y
 * @param {!number} z
 * @return {undefined}
 */
AudioListener.prototype.setPosition = function(x,y,z) {}
/**
 * @constructor
 * @private
 * @extends {HTMLElement}
 * @nosideeffects
 */
function HTMLLIElement() {}
/** @type {!number} */ HTMLLIElement.prototype.value;
/** @type {!string} */ HTMLLIElement.prototype.type;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function WEBGL_compressed_texture_s3tc() {}
/** @const {!GLenum} */ WEBGL_compressed_texture_s3tc.prototype.COMPRESSED_RGBA_S3TC_DXT1_EXT;
/** @const {!GLenum} */ WEBGL_compressed_texture_s3tc.prototype.COMPRESSED_RGBA_S3TC_DXT3_EXT;
/** @const {!GLenum} */ WEBGL_compressed_texture_s3tc.prototype.COMPRESSED_RGBA_S3TC_DXT5_EXT;
/** @const {!GLenum} */ WEBGL_compressed_texture_s3tc.prototype.COMPRESSED_RGB_S3TC_DXT1_EXT;
/**
 * @constructor
 * @extends {Object}
 * @param {!string} idp
 * @param {!string} name
 */
function RTCIdentityAssertion(idp,name) {}
/** @type {!string} */ RTCIdentityAssertion.prototype.idp;
/** @type {!string} */ RTCIdentityAssertion.prototype.name;
/**
 * @constructor
 * @private
 * @extends {CSSGroupingRule}
 * @nosideeffects
 */
function CSSConditionRule() {}
/** @type {!CSSOMString} */ CSSConditionRule.prototype.conditionText;
/**
 * @constructor
 * @private
 * @extends {HTMLElement}
 * @nosideeffects
 */
function HTMLStyleElement() {}
/** @type {!string} */ HTMLStyleElement.prototype.media;
/** @type {!string} */ HTMLStyleElement.prototype.type;
/** @type {?CSSStyleSheet} */ HTMLStyleElement.prototype.sheet;
/**
 * @constructor
 * @extends {Event}
 * @param {!string} type
 * @param {!IDBVersionChangeEventInit=} eventInitDict
 */
function IDBVersionChangeEvent(type,eventInitDict) {}
/** @type {?number} */ IDBVersionChangeEvent.prototype.newVersion;
/** @type {!number} */ IDBVersionChangeEvent.prototype.oldVersion;
/**
 * @constructor
 * @extends {Object}
 * @param {!IntersectionObserverEntryInit} intersectionObserverEntryInit
 */
function IntersectionObserverEntry(intersectionObserverEntryInit) {}
/** @type {!DOMRectReadOnly} */ IntersectionObserverEntry.prototype.boundingClientRect;
/** @type {!number} */ IntersectionObserverEntry.prototype.intersectionRatio;
/** @type {!DOMRectReadOnly} */ IntersectionObserverEntry.prototype.intersectionRect;
/** @type {!boolean} */ IntersectionObserverEntry.prototype.isIntersecting;
/** @type {?DOMRectReadOnly} */ IntersectionObserverEntry.prototype.rootBounds;
/** @type {!Element} */ IntersectionObserverEntry.prototype.target;
/** @type {!DOMHighResTimeStamp} */ IntersectionObserverEntry.prototype.time;
/**
 * @constructor
 * @extends {Object}
 * @param {!RTCIceCandidateInit=} candidateInitDict
 */
function RTCIceCandidate(candidateInitDict) {}
/** @type {?string} */ RTCIceCandidate.prototype.address;
/** @type {!string} */ RTCIceCandidate.prototype.candidate;
/** @type {?string} */ RTCIceCandidate.prototype.component;
/** @type {?string} */ RTCIceCandidate.prototype.foundation;
/** @type {?number} */ RTCIceCandidate.prototype.port;
/** @type {?number} */ RTCIceCandidate.prototype.priority;
/** @type {?string} */ RTCIceCandidate.prototype.protocol;
/** @type {?string} */ RTCIceCandidate.prototype.relatedAddress;
/** @type {?number} */ RTCIceCandidate.prototype.relatedPort;
/** @type {?number} */ RTCIceCandidate.prototype.sdpMLineIndex;
/** @type {?string} */ RTCIceCandidate.prototype.sdpMid;
/** @type {?string} */ RTCIceCandidate.prototype.tcpType;
/** @type {?string} */ RTCIceCandidate.prototype.type;
/** @type {?string} */ RTCIceCandidate.prototype.usernameFragment;
/**
 * @return {!RTCIceCandidateInit}
 * @override
 */
RTCIceCandidate.prototype.toJSON = function() {}
/**
 * @constructor
 * @extends {AudioScheduledSourceNode}
 * @param {!BaseAudioContext} context
 * @param {!AudioBufferSourceOptions=} options
 */
function AudioBufferSourceNode(context,options) {}
/** @type {!AudioParam} */ AudioBufferSourceNode.prototype.detune;
/** @type {!AudioParam} */ AudioBufferSourceNode.prototype.playbackRate;
/** @type {?AudioBuffer} */ AudioBufferSourceNode.prototype.buffer;
/** @type {!boolean} */ AudioBufferSourceNode.prototype.loop;
/** @type {!number} */ AudioBufferSourceNode.prototype.loopEnd;
/** @type {!number} */ AudioBufferSourceNode.prototype.loopStart;
/**
 * @param {!number=} when
 * @param {!number=} offset
 * @param {!number=} duration
 * @return {undefined}
 * @override
 */
AudioBufferSourceNode.prototype.start = function(when,offset,duration) {}
/**
 * @constructor
 * @extends {EventTarget}
 * @param {!string} scriptURL
 * @param {(!string|!WorkerOptions)=} options
 */
function SharedWorker(scriptURL,options) {}
/** @type {!MessagePort} */ SharedWorker.prototype.port;
/** @type {!NullableEventHandler} */ SharedWorker.prototype.onerror;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function GPUCompilationInfo() {}
/** @type {!Array<!GPUCompilationMessage>} */ GPUCompilationInfo.prototype.messages;
/**
 * @constructor
 * @private
 * @extends {HTMLElement}
 * @nosideeffects
 */
function HTMLEmbedElement() {}
/** @type {!string} */ HTMLEmbedElement.prototype.height;
/** @type {!string} */ HTMLEmbedElement.prototype.src;
/** @type {!string} */ HTMLEmbedElement.prototype.type;
/** @type {!string} */ HTMLEmbedElement.prototype.width;
/** @type {!string} */ HTMLEmbedElement.prototype.align;
/** @type {!string} */ HTMLEmbedElement.prototype.name;
/**
 * @return {?Document}
 */
HTMLEmbedElement.prototype.getSVGDocument = function() {}
/**
 * @constructor
 * @private
 * @extends {EventTarget}
 * @nosideeffects
 */
function Bluetooth() {}
/** @type {?BluetoothDevice} */ Bluetooth.prototype.referringDevice;
/** @type {?EventHandler} */ Bluetooth.prototype.onavailabilitychanged;
/** @type {!NullableEventHandler} */ Bluetooth.prototype.onserviceadded;
/** @type {!NullableEventHandler} */ Bluetooth.prototype.onservicechanged;
/** @type {!NullableEventHandler} */ Bluetooth.prototype.onserviceremoved;
/** @type {!NullableEventHandler} */ Bluetooth.prototype.oncharacteristicvaluechanged;
/** @type {!NullableEventHandler} */ Bluetooth.prototype.onadvertisementreceived;
/** @type {!NullableEventHandler} */ Bluetooth.prototype.ongattserverdisconnected;
/**
 * @return {!Promise<!Array<!BluetoothDevice>>}
 */
Bluetooth.prototype.getDevices = function() {}
/**
 * @return {!Promise<!boolean>}
 */
Bluetooth.prototype.getAvailability = function() {}
/**
 * @param {!RequestDeviceOptions=} options
 * @return {!Promise<!BluetoothDevice>}
 */
Bluetooth.prototype.requestDevice = function(options) {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function EXT_frag_depth() {}
/**
 * @constructor
 * @private
 * @extends {CSSRule}
 * @nosideeffects
 */
function CSSKeyframeRule() {}
/** @type {!CSSStyleDeclaration} */ CSSKeyframeRule.prototype.style;
/** @type {!CSSOMString} */ CSSKeyframeRule.prototype.keyText;
/**
 * @constructor
 * @private
 * @extends {Element}
 * @nosideeffects
 */
function SVGElement() {}
/** @type {!SVGAnimatedString} */ SVGElement.prototype.className;
/** @type {?SVGSVGElement} */ SVGElement.prototype.ownerSVGElement;
/** @type {?SVGElement} */ SVGElement.prototype.viewportElement;
/** @type {?SVGElement} */ SVGElement.prototype.correspondingElement;
/** @type {?SVGUseElement} */ SVGElement.prototype.correspondingUseElement;
/** @type {!CSSStyleDeclaration} */ SVGElement.prototype.style;
/** @type {!NullableEventHandler} */ SVGElement.prototype.onabort;
/** @type {?MouseEventHandler} */ SVGElement.prototype.onauxclick;
/** @type {?FocusEventHandler} */ SVGElement.prototype.onblur;
/** @type {?EventHandler} */ SVGElement.prototype.oncancel;
/** @type {!NullableEventHandler} */ SVGElement.prototype.oncanplay;
/** @type {!NullableEventHandler} */ SVGElement.prototype.oncanplaythrough;
/** @type {!NullableEventHandler} */ SVGElement.prototype.onchange;
/** @type {?MouseEventHandler} */ SVGElement.prototype.onclick;
/** @type {!NullableEventHandler} */ SVGElement.prototype.onclose;
/** @type {?MouseEventHandler} */ SVGElement.prototype.oncontextmenu;
/** @type {!NullableEventHandler} */ SVGElement.prototype.oncuechange;
/** @type {?MouseEventHandler} */ SVGElement.prototype.ondblclick;
/** @type {!NullableEventHandler} */ SVGElement.prototype.ondrag;
/** @type {!NullableEventHandler} */ SVGElement.prototype.ondragend;
/** @type {!NullableEventHandler} */ SVGElement.prototype.ondragenter;
/** @type {!NullableEventHandler} */ SVGElement.prototype.ondragleave;
/** @type {!NullableEventHandler} */ SVGElement.prototype.ondragover;
/** @type {!NullableEventHandler} */ SVGElement.prototype.ondragstart;
/** @type {!NullableEventHandler} */ SVGElement.prototype.ondrop;
/** @type {!NullableEventHandler} */ SVGElement.prototype.ondurationchange;
/** @type {!NullableEventHandler} */ SVGElement.prototype.onemptied;
/** @type {!NullableEventHandler} */ SVGElement.prototype.onended;
/** @type {!NullableOnErrorEventHandler} */ SVGElement.prototype.onerror;
/** @type {?FocusEventHandler} */ SVGElement.prototype.onfocus;
/** @type {!NullableEventHandler} */ SVGElement.prototype.onformdata;
/** @type {!NullableEventHandler} */ SVGElement.prototype.oninput;
/** @type {!NullableEventHandler} */ SVGElement.prototype.oninvalid;
/** @type {!NullableEventHandler} */ SVGElement.prototype.onkeydown;
/** @type {!NullableEventHandler} */ SVGElement.prototype.onkeypress;
/** @type {!NullableEventHandler} */ SVGElement.prototype.onkeyup;
/** @type {!NullableEventHandler} */ SVGElement.prototype.onload;
/** @type {!NullableEventHandler} */ SVGElement.prototype.onloadeddata;
/** @type {!NullableEventHandler} */ SVGElement.prototype.onloadedmetadata;
/** @type {!NullableEventHandler} */ SVGElement.prototype.onloadstart;
/** @type {?MouseEventHandler} */ SVGElement.prototype.onmousedown;
/** @type {?MouseEventHandler} */ SVGElement.prototype.onmouseenter;
/** @type {?MouseEventHandler} */ SVGElement.prototype.onmouseleave;
/** @type {?MouseEventHandler} */ SVGElement.prototype.onmousemove;
/** @type {?MouseEventHandler} */ SVGElement.prototype.onmouseout;
/** @type {?MouseEventHandler} */ SVGElement.prototype.onmouseover;
/** @type {?MouseEventHandler} */ SVGElement.prototype.onmouseup;
/** @type {!NullableEventHandler} */ SVGElement.prototype.onpause;
/** @type {!NullableEventHandler} */ SVGElement.prototype.onplay;
/** @type {!NullableEventHandler} */ SVGElement.prototype.onplaying;
/** @type {!NullableEventHandler} */ SVGElement.prototype.onprogress;
/** @type {!NullableEventHandler} */ SVGElement.prototype.onratechange;
/** @type {!NullableEventHandler} */ SVGElement.prototype.onreset;
/** @type {!NullableEventHandler} */ SVGElement.prototype.onresize;
/** @type {?EventHandler} */ SVGElement.prototype.onscroll;
/** @type {!NullableEventHandler} */ SVGElement.prototype.onsecuritypolicyviolation;
/** @type {!NullableEventHandler} */ SVGElement.prototype.onseeked;
/** @type {!NullableEventHandler} */ SVGElement.prototype.onseeking;
/** @type {!NullableEventHandler} */ SVGElement.prototype.onselect;
/** @type {!NullableEventHandler} */ SVGElement.prototype.onslotchange;
/** @type {!NullableEventHandler} */ SVGElement.prototype.onstalled;
/** @type {!NullableEventHandler} */ SVGElement.prototype.onsubmit;
/** @type {!NullableEventHandler} */ SVGElement.prototype.onsuspend;
/** @type {!NullableEventHandler} */ SVGElement.prototype.ontimeupdate;
/** @type {!NullableEventHandler} */ SVGElement.prototype.ontoggle;
/** @type {!NullableEventHandler} */ SVGElement.prototype.onvolumechange;
/** @type {!NullableEventHandler} */ SVGElement.prototype.onwaiting;
/** @type {!NullableEventHandler} */ SVGElement.prototype.onwebkitanimationend;
/** @type {!NullableEventHandler} */ SVGElement.prototype.onwebkitanimationiteration;
/** @type {!NullableEventHandler} */ SVGElement.prototype.onwebkitanimationstart;
/** @type {!NullableEventHandler} */ SVGElement.prototype.onwebkittransitionend;
/** @type {?WheelEventHandler} */ SVGElement.prototype.onwheel;
/** @type {!NullableEventHandler} */ SVGElement.prototype.onanimationcancel;
/** @type {!NullableEventHandler} */ SVGElement.prototype.onanimationend;
/** @type {!NullableEventHandler} */ SVGElement.prototype.onanimationiteration;
/** @type {!NullableEventHandler} */ SVGElement.prototype.onanimationstart;
/** @type {!NullableEventHandler} */ SVGElement.prototype.ontransitioncancel;
/** @type {!NullableEventHandler} */ SVGElement.prototype.ontransitionend;
/** @type {!NullableEventHandler} */ SVGElement.prototype.ontransitionrun;
/** @type {!NullableEventHandler} */ SVGElement.prototype.ontransitionstart;
/** @type {!NullableEventHandler} */ SVGElement.prototype.ongotpointercapture;
/** @type {!NullableEventHandler} */ SVGElement.prototype.onlostpointercapture;
/** @type {!NullableEventHandler} */ SVGElement.prototype.onpointercancel;
/** @type {!NullableEventHandler} */ SVGElement.prototype.onpointerdown;
/** @type {!NullableEventHandler} */ SVGElement.prototype.onpointerenter;
/** @type {!NullableEventHandler} */ SVGElement.prototype.onpointerleave;
/** @type {!NullableEventHandler} */ SVGElement.prototype.onpointermove;
/** @type {!NullableEventHandler} */ SVGElement.prototype.onpointerout;
/** @type {!NullableEventHandler} */ SVGElement.prototype.onpointerover;
/** @type {!NullableEventHandler} */ SVGElement.prototype.onpointerup;
/** @type {!NullableEventHandler} */ SVGElement.prototype.onselectionchange;
/** @type {!NullableEventHandler} */ SVGElement.prototype.onselectstart;
/** @type {?TouchEventHandler} */ SVGElement.prototype.ontouchcancel;
/** @type {?TouchEventHandler} */ SVGElement.prototype.ontouchend;
/** @type {?TouchEventHandler} */ SVGElement.prototype.ontouchmove;
/** @type {?TouchEventHandler} */ SVGElement.prototype.ontouchstart;
/** @type {?ClipboardEventHandler} */ SVGElement.prototype.oncopy;
/** @type {?ClipboardEventHandler} */ SVGElement.prototype.oncut;
/** @type {?ClipboardEventHandler} */ SVGElement.prototype.onpaste;
/** @type {!DOMStringMap} */ SVGElement.prototype.dataset;
/** @type {!boolean} */ SVGElement.prototype.autofocus;
/** @type {!string} */ SVGElement.prototype.nonce;
/** @type {!number} */ SVGElement.prototype.tabIndex;
/**
 * @param {!FocusOptions=} options
 * @return {undefined}
 */
SVGElement.prototype.focus = function(options) {}
/**
 * @return {undefined}
 */
SVGElement.prototype.blur = function() {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function AnimationTimeline() {}
/** @type {?number} */ AnimationTimeline.prototype.currentTime;
/** @type {!string} */ AnimationTimeline.prototype.phase;
/**
 * @constructor
 * @private
 * @extends {SVGElement}
 * @nosideeffects
 */
function SVGMaskElement() {}
/** @type {!SVGAnimatedLength} */ SVGMaskElement.prototype.height;
/** @type {!SVGAnimatedEnumeration} */ SVGMaskElement.prototype.maskContentUnits;
/** @type {!SVGAnimatedEnumeration} */ SVGMaskElement.prototype.maskUnits;
/** @type {!SVGAnimatedLength} */ SVGMaskElement.prototype.width;
/** @type {!SVGAnimatedLength} */ SVGMaskElement.prototype.x;
/** @type {!SVGAnimatedLength} */ SVGMaskElement.prototype.y;
/**
 * @constructor
 * @private
 * @extends {EventTarget}
 * @nosideeffects
 */
function RTCDataChannel() {}
/** @type {!number} */ RTCDataChannel.prototype.bufferedAmount;
/** @type {?number} */ RTCDataChannel.prototype.id;
/** @type {!string} */ RTCDataChannel.prototype.label;
/** @type {?number} */ RTCDataChannel.prototype.maxPacketLifeTime;
/** @type {?number} */ RTCDataChannel.prototype.maxRetransmits;
/** @type {!boolean} */ RTCDataChannel.prototype.negotiated;
/** @type {!boolean} */ RTCDataChannel.prototype.ordered;
/** @type {!string} */ RTCDataChannel.prototype.protocol;
/** @type {!string} */ RTCDataChannel.prototype.readyState;
/** @type {!string} */ RTCDataChannel.prototype.binaryType;
/** @type {!number} */ RTCDataChannel.prototype.bufferedAmountLowThreshold;
/** @type {?EventHandler} */ RTCDataChannel.prototype.onbufferedamountlow;
/** @type {?EventHandler} */ RTCDataChannel.prototype.onclose;
/** @type {!NullableEventHandler} */ RTCDataChannel.prototype.onclosing;
/** @type {?RTCErrorEventHandler} */ RTCDataChannel.prototype.onerror;
/** @type {?MessageEventHandler} */ RTCDataChannel.prototype.onmessage;
/** @type {?RTCDataChannelEventHandler} */ RTCDataChannel.prototype.onopen;
/** @type {!string} */ RTCDataChannel.prototype.priority;
/**
 * @param {(!string|!Blob|!ArrayBuffer|!ArrayBufferView)} arg0
 * @return {undefined}
 */
RTCDataChannel.prototype.send = function(arg0) {}
/**
 * @return {undefined}
 */
RTCDataChannel.prototype.close = function() {}
/**
 * @constructor
 * @extends {AudioNode}
 * @param {!BaseAudioContext} context
 * @param {!GainOptions=} options
 */
function GainNode(context,options) {}
/** @type {!AudioParam} */ GainNode.prototype.gain;
/**
 * @constructor
 * @private
 * @extends {HTMLMediaElement}
 * @nosideeffects
 */
function HTMLAudioElement() {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function WEBGL_color_buffer_float() {}
/** @const {!GLenum} */ WEBGL_color_buffer_float.prototype.FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE_EXT;
/** @const {!GLenum} */ WEBGL_color_buffer_float.prototype.RGBA32F_EXT;
/** @const {!GLenum} */ WEBGL_color_buffer_float.prototype.UNSIGNED_NORMALIZED_EXT;
/**
 * @constructor
 * @private
 * @extends {EventTarget}
 * @nosideeffects
 */
function MessagePort() {}
/** @type {?MessageEventHandler} */ MessagePort.prototype.onmessage;
/** @type {?MessageEventHandler} */ MessagePort.prototype.onmessageerror;
/**
 * @param {*} arg0
 * @param {(!Array<!Transferable>|!PostMessageOptions)=} arg1
 * @return {undefined}
 */
MessagePort.prototype.postMessage = function(arg0,arg1) {}
/**
 * @return {undefined}
 */
MessagePort.prototype.start = function() {}
/**
 * @return {undefined}
 */
MessagePort.prototype.close = function() {}
/**
 * @constructor
 * @private
 * @extends {SVGElement}
 * @nosideeffects
 */
function SVGComponentTransferFunctionElement() {}
/** @const {!number} */ SVGComponentTransferFunctionElement.SVG_FECOMPONENTTRANSFER_TYPE_DISCRETE;
/** @const {!number} */ SVGComponentTransferFunctionElement.prototype.SVG_FECOMPONENTTRANSFER_TYPE_DISCRETE;
/** @const {!number} */ SVGComponentTransferFunctionElement.SVG_FECOMPONENTTRANSFER_TYPE_GAMMA;
/** @const {!number} */ SVGComponentTransferFunctionElement.prototype.SVG_FECOMPONENTTRANSFER_TYPE_GAMMA;
/** @const {!number} */ SVGComponentTransferFunctionElement.SVG_FECOMPONENTTRANSFER_TYPE_IDENTITY;
/** @const {!number} */ SVGComponentTransferFunctionElement.prototype.SVG_FECOMPONENTTRANSFER_TYPE_IDENTITY;
/** @const {!number} */ SVGComponentTransferFunctionElement.SVG_FECOMPONENTTRANSFER_TYPE_LINEAR;
/** @const {!number} */ SVGComponentTransferFunctionElement.prototype.SVG_FECOMPONENTTRANSFER_TYPE_LINEAR;
/** @const {!number} */ SVGComponentTransferFunctionElement.SVG_FECOMPONENTTRANSFER_TYPE_TABLE;
/** @const {!number} */ SVGComponentTransferFunctionElement.prototype.SVG_FECOMPONENTTRANSFER_TYPE_TABLE;
/** @const {!number} */ SVGComponentTransferFunctionElement.SVG_FECOMPONENTTRANSFER_TYPE_UNKNOWN;
/** @const {!number} */ SVGComponentTransferFunctionElement.prototype.SVG_FECOMPONENTTRANSFER_TYPE_UNKNOWN;
/** @type {!SVGAnimatedNumber} */ SVGComponentTransferFunctionElement.prototype.amplitude;
/** @type {!SVGAnimatedNumber} */ SVGComponentTransferFunctionElement.prototype.exponent;
/** @type {!SVGAnimatedNumber} */ SVGComponentTransferFunctionElement.prototype.intercept;
/** @type {!SVGAnimatedNumber} */ SVGComponentTransferFunctionElement.prototype.offset;
/** @type {!SVGAnimatedNumber} */ SVGComponentTransferFunctionElement.prototype.slope;
/** @type {!SVGAnimatedNumberList} */ SVGComponentTransferFunctionElement.prototype.tableValues;
/** @type {!SVGAnimatedEnumeration} */ SVGComponentTransferFunctionElement.prototype.type;
/**
 * @constructor
 * @extends {Event}
 * @param {!string} type
 * @param {!SpeechRecognitionErrorEventInit} eventInitDict
 */
function SpeechRecognitionErrorEvent(type,eventInitDict) {}
/** @type {!string} */ SpeechRecognitionErrorEvent.prototype.error;
/** @type {!string} */ SpeechRecognitionErrorEvent.prototype.message;
/**
 * @constructor
 * @private
 * @extends {SVGGraphicsElement}
 * @nosideeffects
 */
function SVGSymbolElement() {}
/** @type {!SVGAnimatedPreserveAspectRatio} */ SVGSymbolElement.prototype.preserveAspectRatio;
/** @type {!SVGAnimatedRect} */ SVGSymbolElement.prototype.viewBox;
/**
 * @constructor
 * @private
 * @extends {WebGLObject}
 * @nosideeffects
 */
function WebGLRenderbuffer() {}
/**
 * @constructor
 * @private
 * @extends {SVGGraphicsElement}
 * @nosideeffects
 */
function SVGUnknownElement() {}
/**
 * @constructor
 * @private
 * @extends {HTMLElement}
 * @nosideeffects
 */
function HTMLHtmlElement() {}
/** @type {!string} */ HTMLHtmlElement.prototype.version;
/**
 * @constructor
 * @private
 * @extends {EventTarget}
 * @nosideeffects
 */
function Window() {}
/** @type {!Navigator} */ Window.prototype.clientInformation;
/** @type {!boolean} */ Window.prototype.closed;
/** @type {!CustomElementRegistry} */ Window.prototype.customElements;
/** @type {!Document} */ Window.prototype.document;
/** @type {?Element} */ Window.prototype.frameElement;
/** @type {!WindowProxy} */ Window.prototype.frames;
/** @type {!History} */ Window.prototype.history;
/** @type {!number} */ Window.prototype.length;
/** @type {!Location} */ Window.prototype.location;
/** @type {!BarProp} */ Window.prototype.locationbar;
/** @type {!BarProp} */ Window.prototype.menubar;
/** @type {!Navigator} */ Window.prototype.navigator;
/** @type {!boolean} */ Window.prototype.originAgentCluster;
/** @type {?WindowProxy} */ Window.prototype.parent;
/** @type {!BarProp} */ Window.prototype.personalbar;
/** @type {!BarProp} */ Window.prototype.scrollbars;
/** @type {!WindowProxy} */ Window.prototype.self;
/** @type {!BarProp} */ Window.prototype.statusbar;
/** @type {!BarProp} */ Window.prototype.toolbar;
/** @type {?WindowProxy} */ Window.prototype.top;
/** @type {!WindowProxy} */ Window.prototype.window;
/** @type {!string} */ Window.prototype.name;
/** @type {*} */ Window.prototype.opener;
/** @type {!string} */ Window.prototype.status;
/** @type {!number} */ Window.prototype.devicePixelRatio;
/** @type {!number} */ Window.prototype.innerHeight;
/** @type {!number} */ Window.prototype.innerWidth;
/** @type {!number} */ Window.prototype.outerHeight;
/** @type {!number} */ Window.prototype.outerWidth;
/** @type {!number} */ Window.prototype.pageXOffset;
/** @type {!number} */ Window.prototype.pageYOffset;
/** @type {!Screen} */ Window.prototype.screen;
/** @type {!number} */ Window.prototype.screenLeft;
/** @type {!number} */ Window.prototype.screenTop;
/** @type {!number} */ Window.prototype.screenX;
/** @type {!number} */ Window.prototype.screenY;
/** @type {!number} */ Window.prototype.scrollX;
/** @type {!number} */ Window.prototype.scrollY;
/** @type {?DeviceOrientationEventHandler} */ Window.prototype.ondeviceorientation;
/** @type {!NullableEventHandler} */ Window.prototype.ondeviceorientationabsolute;
/** @type {!NullableEventHandler} */ Window.prototype.oncompassneedscalibration;
/** @type {?DeviceMotionEventHandler} */ Window.prototype.ondevicemotion;
/** @type {!SpeechSynthesis} */ Window.prototype.speechSynthesis;
/** @type {!VisualViewport} */ Window.prototype.visualViewport;
/** @type {!number} */ Window.prototype.orientation;
/** @type {?EventHandler} */ Window.prototype.onorientationchange;
/** @type {EventOrUndefinedUnion} */ Window.prototype.event;
/** @type {!boolean} */ Window.prototype.crossOriginIsolated;
/** @type {!boolean} */ Window.prototype.isSecureContext;
/** @type {!string} */ Window.prototype.origin;
/** @type {!Performance} */ Window.prototype.performance;
/** @type {!IDBFactory} */ Window.prototype.indexedDB;
/** @type {!CacheStorage} */ Window.prototype.caches;
/** @type {!Crypto} */ Window.prototype.crypto;
/** @type {?EventHandler} */ Window.prototype.onafterprint;
/** @type {?EventHandler} */ Window.prototype.onbeforeprint;
/** @type {!NullableOnBeforeUnloadEventHandler} */ Window.prototype.onbeforeunload;
/** @type {?HashChangeEventHandler} */ Window.prototype.onhashchange;
/** @type {?EventHandler} */ Window.prototype.onlanguagechange;
/** @type {?MessageEventHandler} */ Window.prototype.onmessage;
/** @type {?MessageEventHandler} */ Window.prototype.onmessageerror;
/** @type {?EventHandler} */ Window.prototype.onoffline;
/** @type {?EventHandler} */ Window.prototype.ononline;
/** @type {?PageTransitionEventHandler} */ Window.prototype.onpagehide;
/** @type {?PageTransitionEventHandler} */ Window.prototype.onpageshow;
/** @type {!NullableEventHandler} */ Window.prototype.onpopstate;
/** @type {?PromiseRejectionEventHandler} */ Window.prototype.onrejectionhandled;
/** @type {?StorageEventHandler} */ Window.prototype.onstorage;
/** @type {?PromiseRejectionEventHandler} */ Window.prototype.onunhandledrejection;
/** @type {?EventHandler} */ Window.prototype.onunload;
/** @type {?GamepadEventHandler} */ Window.prototype.ongamepadconnected;
/** @type {?GamepadEventHandler} */ Window.prototype.ongamepaddisconnected;
/** @type {!Storage} */ Window.prototype.localStorage;
/** @type {!NullableEventHandler} */ Window.prototype.onabort;
/** @type {!NullableEventHandler} */ Window.prototype.onauxclick;
/** @type {?FocusEventHandler} */ Window.prototype.onblur;
/** @type {!NullableEventHandler} */ Window.prototype.oncancel;
/** @type {!NullableEventHandler} */ Window.prototype.oncanplay;
/** @type {!NullableEventHandler} */ Window.prototype.oncanplaythrough;
/** @type {!NullableEventHandler} */ Window.prototype.onchange;
/** @type {!NullableEventHandler} */ Window.prototype.onclick;
/** @type {!NullableEventHandler} */ Window.prototype.onclose;
/** @type {!NullableEventHandler} */ Window.prototype.oncontextmenu;
/** @type {!NullableEventHandler} */ Window.prototype.oncuechange;
/** @type {!NullableEventHandler} */ Window.prototype.ondblclick;
/** @type {!NullableEventHandler} */ Window.prototype.ondrag;
/** @type {!NullableEventHandler} */ Window.prototype.ondragend;
/** @type {!NullableEventHandler} */ Window.prototype.ondragenter;
/** @type {!NullableEventHandler} */ Window.prototype.ondragleave;
/** @type {!NullableEventHandler} */ Window.prototype.ondragover;
/** @type {!NullableEventHandler} */ Window.prototype.ondragstart;
/** @type {!NullableEventHandler} */ Window.prototype.ondrop;
/** @type {!NullableEventHandler} */ Window.prototype.ondurationchange;
/** @type {!NullableEventHandler} */ Window.prototype.onemptied;
/** @type {!NullableEventHandler} */ Window.prototype.onended;
/** @type {!NullableOnErrorEventHandler} */ Window.prototype.onerror;
/** @type {?FocusEventHandler} */ Window.prototype.onfocus;
/** @type {!NullableEventHandler} */ Window.prototype.onformdata;
/** @type {!NullableEventHandler} */ Window.prototype.oninput;
/** @type {!NullableEventHandler} */ Window.prototype.oninvalid;
/** @type {!NullableEventHandler} */ Window.prototype.onkeydown;
/** @type {!NullableEventHandler} */ Window.prototype.onkeypress;
/** @type {!NullableEventHandler} */ Window.prototype.onkeyup;
/** @type {?EventHandler} */ Window.prototype.onload;
/** @type {!NullableEventHandler} */ Window.prototype.onloadeddata;
/** @type {!NullableEventHandler} */ Window.prototype.onloadedmetadata;
/** @type {!NullableEventHandler} */ Window.prototype.onloadstart;
/** @type {!NullableEventHandler} */ Window.prototype.onmousedown;
/** @type {!NullableEventHandler} */ Window.prototype.onmouseenter;
/** @type {!NullableEventHandler} */ Window.prototype.onmouseleave;
/** @type {!NullableEventHandler} */ Window.prototype.onmousemove;
/** @type {!NullableEventHandler} */ Window.prototype.onmouseout;
/** @type {!NullableEventHandler} */ Window.prototype.onmouseover;
/** @type {!NullableEventHandler} */ Window.prototype.onmouseup;
/** @type {!NullableEventHandler} */ Window.prototype.onpause;
/** @type {!NullableEventHandler} */ Window.prototype.onplay;
/** @type {!NullableEventHandler} */ Window.prototype.onplaying;
/** @type {!NullableEventHandler} */ Window.prototype.onprogress;
/** @type {!NullableEventHandler} */ Window.prototype.onratechange;
/** @type {!NullableEventHandler} */ Window.prototype.onreset;
/** @type {?UIEventHandler} */ Window.prototype.onresize;
/** @type {!NullableEventHandler} */ Window.prototype.onscroll;
/** @type {!NullableEventHandler} */ Window.prototype.onsecuritypolicyviolation;
/** @type {!NullableEventHandler} */ Window.prototype.onseeked;
/** @type {!NullableEventHandler} */ Window.prototype.onseeking;
/** @type {!NullableEventHandler} */ Window.prototype.onselect;
/** @type {!NullableEventHandler} */ Window.prototype.onslotchange;
/** @type {!NullableEventHandler} */ Window.prototype.onstalled;
/** @type {!NullableEventHandler} */ Window.prototype.onsubmit;
/** @type {!NullableEventHandler} */ Window.prototype.onsuspend;
/** @type {!NullableEventHandler} */ Window.prototype.ontimeupdate;
/** @type {!NullableEventHandler} */ Window.prototype.ontoggle;
/** @type {!NullableEventHandler} */ Window.prototype.onvolumechange;
/** @type {!NullableEventHandler} */ Window.prototype.onwaiting;
/** @type {!NullableEventHandler} */ Window.prototype.onwebkitanimationend;
/** @type {!NullableEventHandler} */ Window.prototype.onwebkitanimationiteration;
/** @type {!NullableEventHandler} */ Window.prototype.onwebkitanimationstart;
/** @type {!NullableEventHandler} */ Window.prototype.onwebkittransitionend;
/** @type {!NullableEventHandler} */ Window.prototype.onwheel;
/** @type {?AnimationEventHandler} */ Window.prototype.onanimationcancel;
/** @type {?AnimationEventHandler} */ Window.prototype.onanimationend;
/** @type {?AnimationEventHandler} */ Window.prototype.onanimationiteration;
/** @type {?AnimationEventHandler} */ Window.prototype.onanimationstart;
/** @type {?TransitionEventHandler} */ Window.prototype.ontransitioncancel;
/** @type {?TransitionEventHandler} */ Window.prototype.ontransitionend;
/** @type {?TransitionEventHandler} */ Window.prototype.ontransitionrun;
/** @type {?TransitionEventHandler} */ Window.prototype.ontransitionstart;
/** @type {!NullableEventHandler} */ Window.prototype.ongotpointercapture;
/** @type {!NullableEventHandler} */ Window.prototype.onlostpointercapture;
/** @type {!NullableEventHandler} */ Window.prototype.onpointercancel;
/** @type {!NullableEventHandler} */ Window.prototype.onpointerdown;
/** @type {!NullableEventHandler} */ Window.prototype.onpointerenter;
/** @type {!NullableEventHandler} */ Window.prototype.onpointerleave;
/** @type {!NullableEventHandler} */ Window.prototype.onpointermove;
/** @type {!NullableEventHandler} */ Window.prototype.onpointerout;
/** @type {!NullableEventHandler} */ Window.prototype.onpointerover;
/** @type {!NullableEventHandler} */ Window.prototype.onpointerup;
/** @type {!NullableEventHandler} */ Window.prototype.onselectionchange;
/** @type {!NullableEventHandler} */ Window.prototype.onselectstart;
/** @type {!NullableEventHandler} */ Window.prototype.ontouchcancel;
/** @type {!NullableEventHandler} */ Window.prototype.ontouchend;
/** @type {!NullableEventHandler} */ Window.prototype.ontouchmove;
/** @type {!NullableEventHandler} */ Window.prototype.ontouchstart;
/** @type {!Storage} */ Window.prototype.sessionStorage;
/**
 * @param {(!ScrollToOptions|!number)=} arg0
 * @param {!number=} arg1
 * @return {undefined}
 */
Window.prototype.scrollBy = function(arg0,arg1) {}
/**
 * @return {undefined}
 */
Window.prototype.focus = function() {}
/**
 * @return {undefined}
 */
Window.prototype.blur = function() {}
/**
 * @param {!VoidFunction} callback
 * @return {undefined}
 */
Window.prototype.queueMicrotask = function(callback) {}
/**
 * @param {!string} data
 * @return {!string}
 * @nosideeffects
 */
Window.prototype.btoa = function(data) {}
/**
 * @param {!Element} elt
 * @param {?CSSOMString=} pseudoElt
 * @return {!CSSStyleDeclaration}
 * @nosideeffects
 */
Window.prototype.getComputedStyle = function(elt,pseudoElt) {}
/**
 * @param {!FrameRequestCallback} callback
 * @return {!number}
 */
Window.prototype.requestAnimationFrame = function(callback) {}
/**
 * @param {!number=} handle
 * @return {undefined}
 */
Window.prototype.clearInterval = function(handle) {}
/**
 * @param {!TimerHandler} handler
 * @param {!number=} timeout
 * @return {!number}
 */
Window.prototype.setInterval = function(handler,timeout) {}
/**
 * @param {!string=} arg0
 * @return {undefined}
 */
Window.prototype.alert = function(arg0) {}
/**
 * @param {!number} width
 * @param {!number} height
 * @return {undefined}
 */
Window.prototype.resizeTo = function(width,height) {}
/**
 * @param {!number=} handle
 * @return {undefined}
 */
Window.prototype.clearTimeout = function(handle) {}
/**
 * @param {*} arg0
 * @param {(!string|!WindowPostMessageOptions)=} arg1
 * @param {!Array<!Transferable>=} arg2
 * @return {undefined}
 */
Window.prototype.postMessage = function(arg0,arg1,arg2) {}
/**
 * @param {!number} x
 * @param {!number} y
 * @return {undefined}
 */
Window.prototype.moveBy = function(x,y) {}
/**
 * @param {!IdleRequestCallback} callback
 * @param {!IdleRequestOptions=} options
 * @return {!number}
 */
Window.prototype.requestIdleCallback = function(callback,options) {}
/**
 * @return {undefined}
 */
Window.prototype.close = function() {}
/**
 * @param {!number} handle
 * @return {undefined}
 */
Window.prototype.cancelAnimationFrame = function(handle) {}
/**
 * @param {!ImageBitmapSource} arg0
 * @param {(!ImageBitmapOptions|!number)=} arg1
 * @param {!number=} arg2
 * @param {!number=} arg3
 * @param {!number=} arg4
 * @param {!ImageBitmapOptions=} arg5
 * @return {!Promise<!ImageBitmap>}
 */
Window.prototype.createImageBitmap = function(arg0,arg1,arg2,arg3,arg4,arg5) {}
/**
 * @param {(!ScrollToOptions|!number)=} arg0
 * @param {!number=} arg1
 * @return {undefined}
 */
Window.prototype.scroll = function(arg0,arg1) {}
/**
 * @param {!string} data
 * @return {!string}
 * @nosideeffects
 */
Window.prototype.atob = function(data) {}
/**
 * @param {(!ScrollToOptions|!number)=} arg0
 * @param {!number=} arg1
 * @return {undefined}
 */
Window.prototype.scrollTo = function(arg0,arg1) {}
/**
 * @param {!string=} message
 * @return {!boolean}
 */
Window.prototype.confirm = function(message) {}
/**
 * @param {!TimerHandler} handler
 * @param {!number=} timeout
 * @return {!number}
 */
Window.prototype.setTimeout = function(handler,timeout) {}
/**
 * @param {!number} x
 * @param {!number} y
 * @return {undefined}
 */
Window.prototype.resizeBy = function(x,y) {}
/**
 * @return {undefined}
 */
Window.prototype.print = function() {}
/**
 * @return {?Selection}
 * @nosideeffects
 */
Window.prototype.getSelection = function() {}
/**
 * @return {undefined}
 */
Window.prototype.stop = function() {}
/**
 * @param {!number} handle
 * @return {undefined}
 */
Window.prototype.cancelIdleCallback = function(handle) {}
/**
 * @param {!RequestInfo} input
 * @param {!RequestInit=} init
 * @return {!Promise<!Response>}
 */
Window.prototype.fetch = function(input,init) {}
/**
 * @param {!CSSOMString} query
 * @return {!MediaQueryList}
 */
Window.prototype.matchMedia = function(query) {}
/**
 * @param {!string=} message
 * @param {!string=} default_
 * @return {?string}
 */
Window.prototype.prompt = function(message,default_) {}
/**
 * @param {!string=} url
 * @param {!string=} target
 * @param {!string=} features
 * @return {?WindowProxy}
 */
Window.prototype.open = function(url,target,features) {}
/**
 * @param {!number} x
 * @param {!number} y
 * @return {undefined}
 */
Window.prototype.moveTo = function(x,y) {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function Credential() {}
/** @type {!string} */ Credential.prototype.id;
/** @type {!string} */ Credential.prototype.type;
/**
 * @constructor
 * @private
 * @extends {SVGGraphicsElement}
 * @nosideeffects
 */
function SVGGeometryElement() {}
/** @type {!SVGAnimatedNumber} */ SVGGeometryElement.prototype.pathLength;
/**
 * @return {!number}
 */
SVGGeometryElement.prototype.getTotalLength = function() {}
/**
 * @param {!DOMPointInit=} point
 * @return {!boolean}
 */
SVGGeometryElement.prototype.isPointInStroke = function(point) {}
/**
 * @param {!number} distance
 * @return {!DOMPoint}
 */
SVGGeometryElement.prototype.getPointAtLength = function(distance) {}
/**
 * @param {!DOMPointInit=} point
 * @return {!boolean}
 */
SVGGeometryElement.prototype.isPointInFill = function(point) {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function Navigator() {}
/** @type {!Clipboard} */ Navigator.prototype.clipboard;
/** @type {!CredentialsContainer} */ Navigator.prototype.credentials;
/** @type {!Geolocation} */ Navigator.prototype.geolocation;
/** @type {!MediaDevices} */ Navigator.prototype.mediaDevices;
/** @type {!Permissions} */ Navigator.prototype.permissions;
/** @type {!number} */ Navigator.prototype.maxTouchPoints;
/** @type {!WakeLock} */ Navigator.prototype.wakeLock;
/** @type {!ServiceWorkerContainer} */ Navigator.prototype.serviceWorker;
/** @type {!Bluetooth} */ Navigator.prototype.bluetooth;
/** @type {!XRSystem} */ Navigator.prototype.xr;
/** @type {!string} */ Navigator.prototype.language;
/** @type {!Array<!string>} */ Navigator.prototype.languages;
/** @type {!boolean} */ Navigator.prototype.cookieEnabled;
/** @type {!string} */ Navigator.prototype.appCodeName;
/** @type {!string} */ Navigator.prototype.appName;
/** @type {!string} */ Navigator.prototype.appVersion;
/** @type {!string} */ Navigator.prototype.platform;
/** @type {!string} */ Navigator.prototype.product;
/** @type {!string} */ Navigator.prototype.productSub;
/** @type {!string} */ Navigator.prototype.userAgent;
/** @type {!string} */ Navigator.prototype.vendor;
/** @type {!string} */ Navigator.prototype.vendorSub;
/** @type {!string} */ Navigator.prototype.oscpu;
/** @type {!MimeTypeArray} */ Navigator.prototype.mimeTypes;
/** @type {!boolean} */ Navigator.prototype.pdfViewerEnabled;
/** @type {!PluginArray} */ Navigator.prototype.plugins;
/** @type {!boolean} */ Navigator.prototype.onLine;
/** @type {!GPU} */ Navigator.prototype.gpu;
/** @type {!StorageManager} */ Navigator.prototype.storage;
/** @type {!number} */ Navigator.prototype.hardwareConcurrency;
/** @type {!boolean} */ Navigator.prototype.webdriver;
/**
 * @return {!boolean}
 */
Navigator.prototype.taintEnabled = function() {}
/**
 * @return {!boolean}
 */
Navigator.prototype.javaEnabled = function() {}
/**
 * @param {!string} keySystem
 * @param {!Array<!MediaKeySystemConfiguration>} supportedConfigurations
 * @return {!Promise<!MediaKeySystemAccess>}
 */
Navigator.prototype.requestMediaKeySystemAccess = function(keySystem,supportedConfigurations) {}
/**
 * @param {!string} scheme
 * @param {!string} url
 * @return {undefined}
 */
Navigator.prototype.unregisterProtocolHandler = function(scheme,url) {}
/**
 * @param {!string} url
 * @param {?BodyInit=} data
 * @return {!boolean}
 */
Navigator.prototype.sendBeacon = function(url,data) {}
/**
 * @param {!VibratePattern} pattern
 * @return {!boolean}
 */
Navigator.prototype.vibrate = function(pattern) {}
/**
 * @param {!string} scheme
 * @param {!string} url
 * @return {undefined}
 */
Navigator.prototype.registerProtocolHandler = function(scheme,url) {}
/**
 * @param {!ShareData=} data
 * @return {!Promise<undefined>}
 */
Navigator.prototype.share = function(data) {}
/**
 * @return {!Array<?Gamepad>}
 */
Navigator.prototype.getGamepads = function() {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function XRView() {}
/** @type {!string} */ XRView.prototype.eye;
/** @type {!Float32Array} */ XRView.prototype.projectionMatrix;
/** @type {!XRRigidTransform} */ XRView.prototype.transform;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function GPUMapMode() {}
/** @const {!GPUFlagsConstant} */ GPUMapMode.READ;
/** @const {!GPUFlagsConstant} */ GPUMapMode.prototype.READ;
/** @const {!GPUFlagsConstant} */ GPUMapMode.WRITE;
/** @const {!GPUFlagsConstant} */ GPUMapMode.prototype.WRITE;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function BluetoothRemoteGATTDescriptor() {}
/** @type {!BluetoothRemoteGATTCharacteristic} */ BluetoothRemoteGATTDescriptor.prototype.characteristic;
/** @type {!UUID} */ BluetoothRemoteGATTDescriptor.prototype.uuid;
/** @type {?DataView} */ BluetoothRemoteGATTDescriptor.prototype.value;
/**
 * @return {!Promise<!DataView>}
 */
BluetoothRemoteGATTDescriptor.prototype.readValue = function() {}
/**
 * @param {!BufferSource} value
 * @return {!Promise<undefined>}
 */
BluetoothRemoteGATTDescriptor.prototype.writeValue = function(value) {}
/**
 * @constructor
 * @private
 * @extends {EventTarget}
 * @nosideeffects
 */
function XRSystem() {}
/** @type {?EventHandler} */ XRSystem.prototype.ondevicechange;
/**
 * @param {!string} mode
 * @return {!Promise<!boolean>}
 */
XRSystem.prototype.isSessionSupported = function(mode) {}
/**
 * @param {!string} mode
 * @param {!XRSessionInit=} options
 * @return {!Promise<!XRSession>}
 */
XRSystem.prototype.requestSession = function(mode,options) {}
/**
 * @constructor
 * @private
 * @extends {SVGElement}
 * @nosideeffects
 */
function SVGFEDropShadowElement() {}
/** @type {!SVGAnimatedNumber} */ SVGFEDropShadowElement.prototype.dx;
/** @type {!SVGAnimatedNumber} */ SVGFEDropShadowElement.prototype.dy;
/** @type {!SVGAnimatedString} */ SVGFEDropShadowElement.prototype.in1;
/** @type {!SVGAnimatedNumber} */ SVGFEDropShadowElement.prototype.stdDeviationX;
/** @type {!SVGAnimatedNumber} */ SVGFEDropShadowElement.prototype.stdDeviationY;
/** @type {!SVGAnimatedLength} */ SVGFEDropShadowElement.prototype.height;
/** @type {!SVGAnimatedString} */ SVGFEDropShadowElement.prototype.result;
/** @type {!SVGAnimatedLength} */ SVGFEDropShadowElement.prototype.width;
/** @type {!SVGAnimatedLength} */ SVGFEDropShadowElement.prototype.x;
/** @type {!SVGAnimatedLength} */ SVGFEDropShadowElement.prototype.y;
/**
 * @param {!number} stdDeviationX
 * @param {!number} stdDeviationY
 * @return {undefined}
 */
SVGFEDropShadowElement.prototype.setStdDeviation = function(stdDeviationX,stdDeviationY) {}
/**
 * @constructor
 * @extends {AudioNode}
 * @param {!BaseAudioContext} context
 * @param {!PannerOptions=} options
 */
function PannerNode(context,options) {}
/** @type {!AudioParam} */ PannerNode.prototype.orientationX;
/** @type {!AudioParam} */ PannerNode.prototype.orientationY;
/** @type {!AudioParam} */ PannerNode.prototype.orientationZ;
/** @type {!AudioParam} */ PannerNode.prototype.positionX;
/** @type {!AudioParam} */ PannerNode.prototype.positionY;
/** @type {!AudioParam} */ PannerNode.prototype.positionZ;
/** @type {!number} */ PannerNode.prototype.coneInnerAngle;
/** @type {!number} */ PannerNode.prototype.coneOuterAngle;
/** @type {!number} */ PannerNode.prototype.coneOuterGain;
/** @type {!string} */ PannerNode.prototype.distanceModel;
/** @type {!number} */ PannerNode.prototype.maxDistance;
/** @type {!string} */ PannerNode.prototype.panningModel;
/** @type {!number} */ PannerNode.prototype.refDistance;
/** @type {!number} */ PannerNode.prototype.rolloffFactor;
/**
 * @param {!number} x
 * @param {!number} y
 * @param {!number} z
 * @return {undefined}
 */
PannerNode.prototype.setOrientation = function(x,y,z) {}
/**
 * @param {!number} x
 * @param {!number} y
 * @param {!number} z
 * @return {undefined}
 */
PannerNode.prototype.setPosition = function(x,y,z) {}
/**
 * @constructor
 * @private
 * @extends {AudioNode}
 * @nosideeffects
 */
function AudioScheduledSourceNode() {}
/** @type {?EventHandler} */ AudioScheduledSourceNode.prototype.onended;
/**
 * @param {!number=} when
 * @return {undefined}
 */
AudioScheduledSourceNode.prototype.stop = function(when) {}
/**
 * @param {!number=} when
 * @return {undefined}
 */
AudioScheduledSourceNode.prototype.start = function(when) {}
/**
 * @constructor
 * @extends {Object}
 * @param {!string} type
 * @param {!EventInit=} eventInitDict
 */
function Event(type,eventInitDict) {}
/** @const {!number} */ Event.AT_TARGET;
/** @const {!number} */ Event.prototype.AT_TARGET;
/** @const {!number} */ Event.BUBBLING_PHASE;
/** @const {!number} */ Event.prototype.BUBBLING_PHASE;
/** @const {!number} */ Event.CAPTURING_PHASE;
/** @const {!number} */ Event.prototype.CAPTURING_PHASE;
/** @const {!number} */ Event.NONE;
/** @const {!number} */ Event.prototype.NONE;
/** @type {!boolean} */ Event.prototype.bubbles;
/** @type {!boolean} */ Event.prototype.cancelable;
/** @type {!boolean} */ Event.prototype.composed;
/** @type {?EventTarget} */ Event.prototype.currentTarget;
/** @type {!boolean} */ Event.prototype.defaultPrevented;
/** @type {!number} */ Event.prototype.eventPhase;
/** @type {!boolean} */ Event.prototype.isTrusted;
/** @type {?EventTarget} */ Event.prototype.srcElement;
/** @type {?EventTarget} */ Event.prototype.target;
/** @type {!DOMHighResTimeStamp} */ Event.prototype.timeStamp;
/** @type {!string} */ Event.prototype.type;
/** @type {!boolean} */ Event.prototype.cancelBubble;
/** @type {!boolean} */ Event.prototype.returnValue;
/**
 * @return {undefined}
 */
Event.prototype.stopImmediatePropagation = function() {}
/**
 * @return {!Array<!EventTarget>}
 */
Event.prototype.composedPath = function() {}
/**
 * @return {undefined}
 */
Event.prototype.stopPropagation = function() {}
/**
 * @param {!string} type
 * @param {!boolean=} bubbles
 * @param {!boolean=} cancelable
 * @return {undefined}
 */
Event.prototype.initEvent = function(type,bubbles,cancelable) {}
/**
 * @return {undefined}
 */
Event.prototype.preventDefault = function() {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function TextTrackCueList() {}
/** @type {!number} */ TextTrackCueList.prototype.length;
/**
 * @param {!string} id
 * @return {?TextTrackCue}
 */
TextTrackCueList.prototype.getCueById = function(id) {}
/**
 * @constructor
 * @extends {XMLHttpRequestEventTarget}
 */
function XMLHttpRequest() {}
/** @const {!number} */ XMLHttpRequest.DONE;
/** @const {!number} */ XMLHttpRequest.prototype.DONE;
/** @const {!number} */ XMLHttpRequest.HEADERS_RECEIVED;
/** @const {!number} */ XMLHttpRequest.prototype.HEADERS_RECEIVED;
/** @const {!number} */ XMLHttpRequest.LOADING;
/** @const {!number} */ XMLHttpRequest.prototype.LOADING;
/** @const {!number} */ XMLHttpRequest.OPENED;
/** @const {!number} */ XMLHttpRequest.prototype.OPENED;
/** @const {!number} */ XMLHttpRequest.UNSENT;
/** @const {!number} */ XMLHttpRequest.prototype.UNSENT;
/** @type {!number} */ XMLHttpRequest.prototype.readyState;
/** @type {*} */ XMLHttpRequest.prototype.response;
/** @type {!string} */ XMLHttpRequest.prototype.responseText;
/** @type {!string} */ XMLHttpRequest.prototype.responseURL;
/** @type {?Document} */ XMLHttpRequest.prototype.responseXML;
/** @type {!number} */ XMLHttpRequest.prototype.status;
/** @type {!string} */ XMLHttpRequest.prototype.statusText;
/** @type {!XMLHttpRequestUpload} */ XMLHttpRequest.prototype.upload;
/** @type {!NullableEventHandler} */ XMLHttpRequest.prototype.onreadystatechange;
/** @type {!string} */ XMLHttpRequest.prototype.responseType;
/** @type {!number} */ XMLHttpRequest.prototype.timeout;
/** @type {!boolean} */ XMLHttpRequest.prototype.withCredentials;
/**
 * @return {!string}
 */
XMLHttpRequest.prototype.getAllResponseHeaders = function() {}
/**
 * @return {undefined}
 */
XMLHttpRequest.prototype.abort = function() {}
/**
 * @param {!string} name
 * @param {!string} value
 * @return {undefined}
 */
XMLHttpRequest.prototype.setRequestHeader = function(name,value) {}
/**
 * @param {!string} name
 * @return {?string}
 */
XMLHttpRequest.prototype.getResponseHeader = function(name) {}
/**
 * @param {(!Document|!XMLHttpRequestBodyInit)=} body
 * @return {undefined}
 */
XMLHttpRequest.prototype.send = function(body) {}
/**
 * @param {!string} mime
 * @return {undefined}
 */
XMLHttpRequest.prototype.overrideMimeType = function(mime) {}
/**
 * @param {!string} arg0
 * @param {!string} arg1
 * @param {!boolean=} arg2
 * @param {?string=} arg3
 * @param {?string=} arg4
 * @return {undefined}
 */
XMLHttpRequest.prototype.open = function(arg0,arg1,arg2,arg3,arg4) {}
/**
 * @constructor
 * @private
 * @extends {HTMLElement}
 * @nosideeffects
 */
function HTMLProgressElement() {}
/** @type {!NodeList} */ HTMLProgressElement.prototype.labels;
/** @type {!number} */ HTMLProgressElement.prototype.position;
/** @type {!number} */ HTMLProgressElement.prototype.max;
/** @type {!number} */ HTMLProgressElement.prototype.value;
/**
 * @constructor
 * @extends {DOMRectReadOnly}
 * @param {!number=} x
 * @param {!number=} y
 * @param {!number=} width
 * @param {!number=} height
 */
function DOMRect(x,y,width,height) {}
/** @type {!number} */ DOMRect.prototype.height;
/** @type {!number} */ DOMRect.prototype.width;
/** @type {!number} */ DOMRect.prototype.x;
/** @type {!number} */ DOMRect.prototype.y;
/**
 * @param {!DOMRectInit=} other
 * @return {!DOMRect}
 */
DOMRect.fromRect = function(other) {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function XPathExpression() {}
/**
 * @param {!Node} contextNode
 * @param {!number=} type
 * @param {?XPathResult=} result
 * @return {!XPathResult}
 */
XPathExpression.prototype.evaluate = function(contextNode,type,result) {}
/**
 * @constructor
 * @private
 * @extends {BaseAudioContext}
 * @nosideeffects
 */
function OfflineAudioContext() {}
/** @type {!number} */ OfflineAudioContext.prototype.length;
/** @type {?OfflineAudioCompletionEventHandler} */ OfflineAudioContext.prototype.oncomplete;
/**
 * @param {!number} suspendTime
 * @return {!Promise<undefined>}
 */
OfflineAudioContext.prototype.suspend = function(suspendTime) {}
/**
 * @return {!Promise<undefined>}
 */
OfflineAudioContext.prototype.resume = function() {}
/**
 * @return {!Promise<!AudioBuffer>}
 */
OfflineAudioContext.prototype.startRendering = function() {}
/**
 * @constructor
 * @private
 * @extends {SVGElement}
 * @nosideeffects
 */
function SVGGraphicsElement() {}
/** @type {!SVGAnimatedTransformList} */ SVGGraphicsElement.prototype.transform;
/** @type {!SVGStringList} */ SVGGraphicsElement.prototype.requiredExtensions;
/** @type {!SVGStringList} */ SVGGraphicsElement.prototype.systemLanguage;
/**
 * @param {!SVGBoundingBoxOptions=} options
 * @return {!DOMRect}
 */
SVGGraphicsElement.prototype.getBBox = function(options) {}
/**
 * @return {?DOMMatrix}
 */
SVGGraphicsElement.prototype.getScreenCTM = function() {}
/**
 * @return {?DOMMatrix}
 */
SVGGraphicsElement.prototype.getCTM = function() {}
/**
 * @constructor
 * @private
 * @extends {HTMLElement}
 * @nosideeffects
 */
function HTMLTableRowElement() {}
/** @type {!HTMLCollection} */ HTMLTableRowElement.prototype.cells;
/** @type {!number} */ HTMLTableRowElement.prototype.rowIndex;
/** @type {!number} */ HTMLTableRowElement.prototype.sectionRowIndex;
/** @type {!string} */ HTMLTableRowElement.prototype.align;
/** @type {!string} */ HTMLTableRowElement.prototype.bgColor;
/** @type {!string} */ HTMLTableRowElement.prototype.ch;
/** @type {!string} */ HTMLTableRowElement.prototype.chOff;
/** @type {!string} */ HTMLTableRowElement.prototype.vAlign;
/**
 * @param {!number=} index
 * @return {!HTMLTableCellElement}
 */
HTMLTableRowElement.prototype.insertCell = function(index) {}
/**
 * @param {!number} index
 * @return {undefined}
 */
HTMLTableRowElement.prototype.deleteCell = function(index) {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function Geolocation() {}
/**
 * @param {!PositionCallback} successCallback
 * @param {?PositionErrorCallback=} errorCallback
 * @param {!PositionOptions=} options
 * @return {!number}
 */
Geolocation.prototype.watchPosition = function(successCallback,errorCallback,options) {}
/**
 * @param {!PositionCallback} successCallback
 * @param {?PositionErrorCallback=} errorCallback
 * @param {!PositionOptions=} options
 * @return {undefined}
 */
Geolocation.prototype.getCurrentPosition = function(successCallback,errorCallback,options) {}
/**
 * @param {!number} watchId
 * @return {undefined}
 */
Geolocation.prototype.clearWatch = function(watchId) {}
/**
 * @constructor
 * @extends {Object}
 */
function TextEncoder() {}
/** @type {!string} */ TextEncoder.prototype.encoding;
/**
 * @param {!string=} input
 * @return {!Uint8Array}
 */
TextEncoder.prototype.encode = function(input) {}
/**
 * @param {!string} source
 * @param {!Uint8Array} destination
 * @return {!TextEncoderEncodeIntoResult}
 */
TextEncoder.prototype.encodeInto = function(source,destination) {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function StorageManager() {}
/**
 * @return {!Promise<!StorageEstimate>}
 */
StorageManager.prototype.estimate = function() {}
/**
 * @return {!Promise<!boolean>}
 */
StorageManager.prototype.persisted = function() {}
/**
 * @return {!Promise<!boolean>}
 */
StorageManager.prototype.persist = function() {}
/**
 * @constructor
 * @private
 * @extends {CSSRule}
 * @nosideeffects
 */
function CSSFontFeatureValuesRule() {}
/** @type {!CSSFontFeatureValuesMap} */ CSSFontFeatureValuesRule.prototype.annotation;
/** @type {!CSSFontFeatureValuesMap} */ CSSFontFeatureValuesRule.prototype.characterVariant;
/** @type {!CSSFontFeatureValuesMap} */ CSSFontFeatureValuesRule.prototype.ornaments;
/** @type {!CSSFontFeatureValuesMap} */ CSSFontFeatureValuesRule.prototype.styleset;
/** @type {!CSSFontFeatureValuesMap} */ CSSFontFeatureValuesRule.prototype.stylistic;
/** @type {!CSSFontFeatureValuesMap} */ CSSFontFeatureValuesRule.prototype.swash;
/** @type {!CSSOMString} */ CSSFontFeatureValuesRule.prototype.fontFamily;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
WebAssembly.RuntimeError = function() {}
/**
 * @constructor
 * @private
 * @extends {EventTarget}
 * @nosideeffects
 */
function BluetoothRemoteGATTCharacteristic() {}
/** @type {!BluetoothCharacteristicProperties} */ BluetoothRemoteGATTCharacteristic.prototype.properties;
/** @type {!BluetoothRemoteGATTService} */ BluetoothRemoteGATTCharacteristic.prototype.service;
/** @type {!UUID} */ BluetoothRemoteGATTCharacteristic.prototype.uuid;
/** @type {?DataView} */ BluetoothRemoteGATTCharacteristic.prototype.value;
/** @type {!NullableEventHandler} */ BluetoothRemoteGATTCharacteristic.prototype.oncharacteristicvaluechanged;
/**
 * @param {!BufferSource} value
 * @return {!Promise<undefined>}
 */
BluetoothRemoteGATTCharacteristic.prototype.writeValueWithoutResponse = function(value) {}
/**
 * @param {!BluetoothDescriptorUUID} descriptor
 * @return {!Promise<!BluetoothRemoteGATTDescriptor>}
 */
BluetoothRemoteGATTCharacteristic.prototype.getDescriptor = function(descriptor) {}
/**
 * @return {!Promise<!DataView>}
 */
BluetoothRemoteGATTCharacteristic.prototype.readValue = function() {}
/**
 * @param {!BluetoothDescriptorUUID=} descriptor
 * @return {!Promise<!Array<!BluetoothRemoteGATTDescriptor>>}
 */
BluetoothRemoteGATTCharacteristic.prototype.getDescriptors = function(descriptor) {}
/**
 * @return {!Promise<!BluetoothRemoteGATTCharacteristic>}
 */
BluetoothRemoteGATTCharacteristic.prototype.startNotifications = function() {}
/**
 * @param {!BufferSource} value
 * @return {!Promise<undefined>}
 */
BluetoothRemoteGATTCharacteristic.prototype.writeValueWithResponse = function(value) {}
/**
 * @param {!BufferSource} value
 * @return {!Promise<undefined>}
 */
BluetoothRemoteGATTCharacteristic.prototype.writeValue = function(value) {}
/**
 * @return {!Promise<!BluetoothRemoteGATTCharacteristic>}
 */
BluetoothRemoteGATTCharacteristic.prototype.stopNotifications = function() {}
/**
 * @constructor
 * @private
 * @extends {NodeList}
 * @nosideeffects
 */
function RadioNodeList() {}
/** @type {!string} */ RadioNodeList.prototype.value;
/**
 * @constructor
 * @private
 * @extends {EventTarget}
 * @nosideeffects
 */
function BaseAudioContext() {}
/** @type {!AudioWorklet} */ BaseAudioContext.prototype.audioWorklet;
/** @type {!number} */ BaseAudioContext.prototype.currentTime;
/** @type {!AudioDestinationNode} */ BaseAudioContext.prototype.destination;
/** @type {!AudioListener} */ BaseAudioContext.prototype.listener;
/** @type {!number} */ BaseAudioContext.prototype.sampleRate;
/** @type {!string} */ BaseAudioContext.prototype.state;
/** @type {!NullableEventHandler} */ BaseAudioContext.prototype.onstatechange;
/**
 * @return {!PannerNode}
 */
BaseAudioContext.prototype.createPanner = function() {}
/**
 * @return {!StereoPannerNode}
 */
BaseAudioContext.prototype.createStereoPanner = function() {}
/**
 * @param {!number=} numberOfInputs
 * @return {!ChannelMergerNode}
 */
BaseAudioContext.prototype.createChannelMerger = function(numberOfInputs) {}
/**
 * @return {!BiquadFilterNode}
 */
BaseAudioContext.prototype.createBiquadFilter = function() {}
/**
 * @param {!number=} bufferSize
 * @param {!number=} numberOfInputChannels
 * @param {!number=} numberOfOutputChannels
 * @return {!ScriptProcessorNode}
 */
BaseAudioContext.prototype.createScriptProcessor = function(bufferSize,numberOfInputChannels,numberOfOutputChannels) {}
/**
 * @param {!ArrayBuffer} audioData
 * @param {?DecodeSuccessCallback=} successCallback
 * @param {?DecodeErrorCallback=} errorCallback
 * @return {!Promise<!AudioBuffer>}
 */
BaseAudioContext.prototype.decodeAudioData = function(audioData,successCallback,errorCallback) {}
/**
 * @return {!ConvolverNode}
 */
BaseAudioContext.prototype.createConvolver = function() {}
/**
 * @return {!AudioBufferSourceNode}
 */
BaseAudioContext.prototype.createBufferSource = function() {}
/**
 * @return {!WaveShaperNode}
 */
BaseAudioContext.prototype.createWaveShaper = function() {}
/**
 * @param {!number} numberOfChannels
 * @param {!number} length
 * @param {!number} sampleRate
 * @return {!AudioBuffer}
 */
BaseAudioContext.prototype.createBuffer = function(numberOfChannels,length,sampleRate) {}
/**
 * @return {!GainNode}
 */
BaseAudioContext.prototype.createGain = function() {}
/**
 * @return {!DynamicsCompressorNode}
 */
BaseAudioContext.prototype.createDynamicsCompressor = function() {}
/**
 * @return {!ConstantSourceNode}
 */
BaseAudioContext.prototype.createConstantSource = function() {}
/**
 * @param {!number=} numberOfOutputs
 * @return {!ChannelSplitterNode}
 */
BaseAudioContext.prototype.createChannelSplitter = function(numberOfOutputs) {}
/**
 * @return {!OscillatorNode}
 */
BaseAudioContext.prototype.createOscillator = function() {}
/**
 * @param {!Array<!number>} feedforward
 * @param {!Array<!number>} feedback
 * @return {!IIRFilterNode}
 */
BaseAudioContext.prototype.createIIRFilter = function(feedforward,feedback) {}
/**
 * @param {!number=} maxDelayTime
 * @return {!DelayNode}
 */
BaseAudioContext.prototype.createDelay = function(maxDelayTime) {}
/**
 * @return {!AnalyserNode}
 */
BaseAudioContext.prototype.createAnalyser = function() {}
/**
 * @param {!Array<!number>} real
 * @param {!Array<!number>} imag
 * @param {!PeriodicWaveConstraints=} constraints
 * @return {!PeriodicWave}
 */
BaseAudioContext.prototype.createPeriodicWave = function(real,imag,constraints) {}
/**
 * @constructor
 * @private
 * @extends {HTMLElement}
 * @nosideeffects
 */
function HTMLMeterElement() {}
/** @type {!NodeList} */ HTMLMeterElement.prototype.labels;
/** @type {!number} */ HTMLMeterElement.prototype.high;
/** @type {!number} */ HTMLMeterElement.prototype.low;
/** @type {!number} */ HTMLMeterElement.prototype.max;
/** @type {!number} */ HTMLMeterElement.prototype.min;
/** @type {!number} */ HTMLMeterElement.prototype.optimum;
/** @type {!number} */ HTMLMeterElement.prototype.value;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function PerformanceNavigation() {}
/** @const {!number} */ PerformanceNavigation.TYPE_BACK_FORWARD;
/** @const {!number} */ PerformanceNavigation.prototype.TYPE_BACK_FORWARD;
/** @const {!number} */ PerformanceNavigation.TYPE_NAVIGATE;
/** @const {!number} */ PerformanceNavigation.prototype.TYPE_NAVIGATE;
/** @const {!number} */ PerformanceNavigation.TYPE_RELOAD;
/** @const {!number} */ PerformanceNavigation.prototype.TYPE_RELOAD;
/** @const {!number} */ PerformanceNavigation.TYPE_RESERVED;
/** @const {!number} */ PerformanceNavigation.prototype.TYPE_RESERVED;
/** @type {!number} */ PerformanceNavigation.prototype.redirectCount;
/** @type {!number} */ PerformanceNavigation.prototype.type;
/**
 * @return {!Object}
 * @override
 */
PerformanceNavigation.prototype.toJSON = function() {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function SpeechRecognitionResult() {}
/** @type {!boolean} */ SpeechRecognitionResult.prototype.isFinal;
/** @type {!number} */ SpeechRecognitionResult.prototype.length;
/**
 * @param {!number} index
 * @return {!SpeechRecognitionAlternative}
 */
SpeechRecognitionResult.prototype.item = function(index) {}
/**
 * @constructor
 * @extends {Event}
 * @param {!string} type
 * @param {!SpeechSynthesisEventInit} eventInitDict
 */
function SpeechSynthesisEvent(type,eventInitDict) {}
/** @type {!number} */ SpeechSynthesisEvent.prototype.charIndex;
/** @type {!number} */ SpeechSynthesisEvent.prototype.charLength;
/** @type {!number} */ SpeechSynthesisEvent.prototype.elapsedTime;
/** @type {!string} */ SpeechSynthesisEvent.prototype.name;
/** @type {!SpeechSynthesisUtterance} */ SpeechSynthesisEvent.prototype.utterance;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function IDBKeyRange() {}
/** @type {*} */ IDBKeyRange.prototype.lower;
/** @type {!boolean} */ IDBKeyRange.prototype.lowerOpen;
/** @type {*} */ IDBKeyRange.prototype.upper;
/** @type {!boolean} */ IDBKeyRange.prototype.upperOpen;
/**
 * @param {*} upper
 * @param {!boolean=} open
 * @return {!IDBKeyRange}
 */
IDBKeyRange.upperBound = function(upper,open) {}
/**
 * @param {*} lower
 * @param {*} upper
 * @param {!boolean=} lowerOpen
 * @param {!boolean=} upperOpen
 * @return {!IDBKeyRange}
 */
IDBKeyRange.bound = function(lower,upper,lowerOpen,upperOpen) {}
/**
 * @param {*} value
 * @return {!IDBKeyRange}
 */
IDBKeyRange.only = function(value) {}
/**
 * @param {*} key
 * @return {!boolean}
 */
IDBKeyRange.prototype.includes = function(key) {}
/**
 * @param {*} lower
 * @param {!boolean=} open
 * @return {!IDBKeyRange}
 */
IDBKeyRange.lowerBound = function(lower,open) {}
/**
 * @constructor
 * @extends {Animation}
 * @param {!Animation} source
 * @param {(!CSSPseudoElement|!Element)} newTarget
 */
function ShadowAnimation(source,newTarget) {}
/** @type {!Animation} */ ShadowAnimation.prototype.sourceAnimation;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function Permissions() {}
/**
 * @param {!Object} permissionDesc
 * @return {!Promise<!PermissionStatus>}
 */
Permissions.prototype.query = function(permissionDesc) {}
/**
 * @constructor
 * @extends {AudioNode}
 * @param {!AudioContext} context
 * @param {!MediaElementAudioSourceOptions} options
 */
function MediaElementAudioSourceNode(context,options) {}
/** @type {!HTMLMediaElement} */ MediaElementAudioSourceNode.prototype.mediaElement;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function GPUShaderStage() {}
/** @const {!GPUFlagsConstant} */ GPUShaderStage.COMPUTE;
/** @const {!GPUFlagsConstant} */ GPUShaderStage.prototype.COMPUTE;
/** @const {!GPUFlagsConstant} */ GPUShaderStage.FRAGMENT;
/** @const {!GPUFlagsConstant} */ GPUShaderStage.prototype.FRAGMENT;
/** @const {!GPUFlagsConstant} */ GPUShaderStage.VERTEX;
/** @const {!GPUFlagsConstant} */ GPUShaderStage.prototype.VERTEX;
/**
 * @constructor
 * @extends {DOMException}
 * @param {!string} constraint
 * @param {!string=} message
 */
function OverconstrainedError(constraint,message) {}
/** @type {!string} */ OverconstrainedError.prototype.constraint;
/**
 * @constructor
 * @private
 * @extends {HTMLElement}
 * @nosideeffects
 */
function HTMLButtonElement() {}
/** @type {?HTMLFormElement} */ HTMLButtonElement.prototype.form;
/** @type {!NodeList} */ HTMLButtonElement.prototype.labels;
/** @type {!string} */ HTMLButtonElement.prototype.validationMessage;
/** @type {!ValidityState} */ HTMLButtonElement.prototype.validity;
/** @type {!boolean} */ HTMLButtonElement.prototype.willValidate;
/** @type {!boolean} */ HTMLButtonElement.prototype.disabled;
/** @type {!string} */ HTMLButtonElement.prototype.formAction;
/** @type {!string} */ HTMLButtonElement.prototype.formEnctype;
/** @type {!string} */ HTMLButtonElement.prototype.formMethod;
/** @type {!boolean} */ HTMLButtonElement.prototype.formNoValidate;
/** @type {!string} */ HTMLButtonElement.prototype.formTarget;
/** @type {!string} */ HTMLButtonElement.prototype.name;
/** @type {!string} */ HTMLButtonElement.prototype.type;
/** @type {!string} */ HTMLButtonElement.prototype.value;
/**
 * @param {!string} error
 * @return {undefined}
 */
HTMLButtonElement.prototype.setCustomValidity = function(error) {}
/**
 * @return {!boolean}
 */
HTMLButtonElement.prototype.reportValidity = function() {}
/**
 * @return {!boolean}
 */
HTMLButtonElement.prototype.checkValidity = function() {}
/**
 * @constructor
 * @extends {Event}
 * @param {!string} type
 * @param {!DeviceOrientationEventInit=} eventInitDict
 */
function DeviceOrientationEvent(type,eventInitDict) {}
/** @type {!boolean} */ DeviceOrientationEvent.prototype.absolute;
/** @type {?number} */ DeviceOrientationEvent.prototype.alpha;
/** @type {?number} */ DeviceOrientationEvent.prototype.beta;
/** @type {?number} */ DeviceOrientationEvent.prototype.gamma;
/**
 * @return {!Promise<!string>}
 */
DeviceOrientationEvent.requestPermission = function() {}
/**
 * @constructor
 * @private
 * @extends {HTMLElement}
 * @nosideeffects
 */
function HTMLHeadingElement() {}
/** @type {!string} */ HTMLHeadingElement.prototype.align;
/**
 * @constructor
 * @extends {Object}
 * @implements {Iterable<!Array<!string|!FormDataEntryValue>>}
 * @param {!HTMLFormElement=} form
 */
function FormData(form) {}
/**
 * @param {!string} arg0
 * @param {(!string|!Blob)} arg1
 * @param {!string=} arg2
 * @return {undefined}
 */
FormData.prototype.set = function(arg0,arg1,arg2) {}
/**
 * @param {!string} name
 * @return {!Array<!FormDataEntryValue>}
 */
FormData.prototype.getAll = function(name) {}
/**
 * @param {!string} name
 * @return {?FormDataEntryValue}
 */
FormData.prototype.get = function(name) {}
/**
 * @param {!string} name
 * @return {!boolean}
 */
FormData.prototype.has = function(name) {}
/**
 * @param {!string} name
 * @return {undefined}
 */
FormData.prototype.delete = function(name) {}
/**
 * @param {!string} arg0
 * @param {(!string|!Blob)} arg1
 * @param {!string=} arg2
 * @return {undefined}
 */
FormData.prototype.append = function(arg0,arg1,arg2) {}
/**
 * @return {!Iterator<!string>}
 * @nosideeffects
 */
FormData.prototype.keys = function() {}
/**
 * @return {!Iterator<!FormDataEntryValue>}
 * @nosideeffects
 */
FormData.prototype.values = function() {}
/**
 * @return {!Iterator<!Array<!string|!FormDataEntryValue>>}
 * @nosideeffects
 */
FormData.prototype.entries = function() {};
/**
 * @return {!Iterator<!Array<!string|!FormDataEntryValue>>}
 * @nosideeffects
 */
FormData.prototype[Symbol.iterator] = function() {};
/**
 * @param {function(!FormDataEntryValue, !string, MAP)} callback
 * @this {MAP}
 * @template MAP
 */
FormData.prototype.forEach = function(callback) {};
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function IDBObjectStore() {}
/** @type {!boolean} */ IDBObjectStore.prototype.autoIncrement;
/** @type {!DOMStringList} */ IDBObjectStore.prototype.indexNames;
/** @type {*} */ IDBObjectStore.prototype.keyPath;
/** @type {!IDBTransaction} */ IDBObjectStore.prototype.transaction;
/** @type {!string} */ IDBObjectStore.prototype.name;
/**
 * @param {*} value
 * @param {*=} key
 * @return {!IDBRequest}
 */
IDBObjectStore.prototype.add = function(value,key) {}
/**
 * @param {*} query
 * @return {!IDBRequest}
 */
IDBObjectStore.prototype.getKey = function(query) {}
/**
 * @param {*=} query
 * @param {!number=} count
 * @return {!IDBRequest}
 */
IDBObjectStore.prototype.getAll = function(query,count) {}
/**
 * @param {*=} query
 * @param {!string=} direction
 * @return {!IDBRequest}
 */
IDBObjectStore.prototype.openCursor = function(query,direction) {}
/**
 * @param {*=} query
 * @return {!IDBRequest}
 */
IDBObjectStore.prototype.count = function(query) {}
/**
 * @return {!IDBRequest}
 */
IDBObjectStore.prototype.clear = function() {}
/**
 * @param {!string} name
 * @return {!IDBIndex}
 */
IDBObjectStore.prototype.index = function(name) {}
/**
 * @param {*=} query
 * @param {!string=} direction
 * @return {!IDBRequest}
 */
IDBObjectStore.prototype.openKeyCursor = function(query,direction) {}
/**
 * @param {*} query
 * @return {!IDBRequest}
 */
IDBObjectStore.prototype.delete = function(query) {}
/**
 * @param {!string} name
 * @param {(!string|!Array<!string>)} keyPath
 * @param {!IDBIndexParameters=} options
 * @return {!IDBIndex}
 */
IDBObjectStore.prototype.createIndex = function(name,keyPath,options) {}
/**
 * @param {*} value
 * @param {*=} key
 * @return {!IDBRequest}
 */
IDBObjectStore.prototype.put = function(value,key) {}
/**
 * @param {!string} name
 * @return {undefined}
 */
IDBObjectStore.prototype.deleteIndex = function(name) {}
/**
 * @param {*=} query
 * @param {!number=} count
 * @return {!IDBRequest}
 */
IDBObjectStore.prototype.getAllKeys = function(query,count) {}
/**
 * @param {*} query
 * @return {!IDBRequest}
 */
IDBObjectStore.prototype.get = function(query) {}
/**
 * @constructor
 * @extends {Object}
 * @param {!ReadableStream} stream
 */
function ReadableStreamDefaultReader(stream) {}
/** @type {!Promise<undefined>} */ ReadableStreamDefaultReader.prototype.closed;
/**
 * @param {*=} reason
 * @return {!Promise<undefined>}
 */
ReadableStreamDefaultReader.prototype.cancel = function(reason) {}
/**
 * @return {!Promise<!ReadableStreamDefaultReadResult>}
 */
ReadableStreamDefaultReader.prototype.read = function() {}
/**
 * @return {undefined}
 */
ReadableStreamDefaultReader.prototype.releaseLock = function() {}
/**
 * @constructor
 * @private
 * @extends {HTMLElement}
 * @nosideeffects
 */
function HTMLLegendElement() {}
/** @type {?HTMLFormElement} */ HTMLLegendElement.prototype.form;
/** @type {!string} */ HTMLLegendElement.prototype.align;
/**
 * @constructor
 * @extends {Event}
 * @param {!string} type
 * @param {!TrackEventInit=} eventInitDict
 */
function TrackEvent(type,eventInitDict) {}
/** @type {VideoTrackOrAudioTrackOrTextTrackUnion} */ TrackEvent.prototype.track;
/**
 * @constructor
 * @private
 * @extends {SVGElement}
 * @nosideeffects
 */
function SVGFEOffsetElement() {}
/** @type {!SVGAnimatedNumber} */ SVGFEOffsetElement.prototype.dx;
/** @type {!SVGAnimatedNumber} */ SVGFEOffsetElement.prototype.dy;
/** @type {!SVGAnimatedString} */ SVGFEOffsetElement.prototype.in1;
/** @type {!SVGAnimatedLength} */ SVGFEOffsetElement.prototype.height;
/** @type {!SVGAnimatedString} */ SVGFEOffsetElement.prototype.result;
/** @type {!SVGAnimatedLength} */ SVGFEOffsetElement.prototype.width;
/** @type {!SVGAnimatedLength} */ SVGFEOffsetElement.prototype.x;
/** @type {!SVGAnimatedLength} */ SVGFEOffsetElement.prototype.y;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function TreeWalker() {}
/** @type {?NodeFilter} */ TreeWalker.prototype.filter;
/** @type {!Node} */ TreeWalker.prototype.root;
/** @type {!number} */ TreeWalker.prototype.whatToShow;
/** @type {!Node} */ TreeWalker.prototype.currentNode;
/**
 * @return {?Node}
 */
TreeWalker.prototype.nextNode = function() {}
/**
 * @return {?Node}
 */
TreeWalker.prototype.lastChild = function() {}
/**
 * @return {?Node}
 */
TreeWalker.prototype.firstChild = function() {}
/**
 * @return {?Node}
 */
TreeWalker.prototype.previousSibling = function() {}
/**
 * @return {?Node}
 */
TreeWalker.prototype.parentNode = function() {}
/**
 * @return {?Node}
 */
TreeWalker.prototype.nextSibling = function() {}
/**
 * @return {?Node}
 */
TreeWalker.prototype.previousNode = function() {}
/**
 * @constructor
 * @private
 * @extends {SVGGraphicsElement}
 * @nosideeffects
 */
function SVGSVGElement() {}
/** @const {!number} */ SVGSVGElement.SVG_ZOOMANDPAN_DISABLE;
/** @const {!number} */ SVGSVGElement.prototype.SVG_ZOOMANDPAN_DISABLE;
/** @const {!number} */ SVGSVGElement.SVG_ZOOMANDPAN_MAGNIFY;
/** @const {!number} */ SVGSVGElement.prototype.SVG_ZOOMANDPAN_MAGNIFY;
/** @const {!number} */ SVGSVGElement.SVG_ZOOMANDPAN_UNKNOWN;
/** @const {!number} */ SVGSVGElement.prototype.SVG_ZOOMANDPAN_UNKNOWN;
/** @type {!DOMPointReadOnly} */ SVGSVGElement.prototype.currentTranslate;
/** @type {!SVGAnimatedLength} */ SVGSVGElement.prototype.height;
/** @type {!SVGAnimatedLength} */ SVGSVGElement.prototype.width;
/** @type {!SVGAnimatedLength} */ SVGSVGElement.prototype.x;
/** @type {!SVGAnimatedLength} */ SVGSVGElement.prototype.y;
/** @type {!number} */ SVGSVGElement.prototype.currentScale;
/** @type {!number} */ SVGSVGElement.prototype.zoomAndPan;
/** @type {!NullableEventHandler} */ SVGSVGElement.prototype.onafterprint;
/** @type {!NullableEventHandler} */ SVGSVGElement.prototype.onbeforeprint;
/** @type {!NullableOnBeforeUnloadEventHandler} */ SVGSVGElement.prototype.onbeforeunload;
/** @type {!NullableEventHandler} */ SVGSVGElement.prototype.onhashchange;
/** @type {!NullableEventHandler} */ SVGSVGElement.prototype.onlanguagechange;
/** @type {!NullableEventHandler} */ SVGSVGElement.prototype.onmessage;
/** @type {!NullableEventHandler} */ SVGSVGElement.prototype.onmessageerror;
/** @type {!NullableEventHandler} */ SVGSVGElement.prototype.onoffline;
/** @type {!NullableEventHandler} */ SVGSVGElement.prototype.ononline;
/** @type {!NullableEventHandler} */ SVGSVGElement.prototype.onpagehide;
/** @type {!NullableEventHandler} */ SVGSVGElement.prototype.onpageshow;
/** @type {!NullableEventHandler} */ SVGSVGElement.prototype.onpopstate;
/** @type {!NullableEventHandler} */ SVGSVGElement.prototype.onrejectionhandled;
/** @type {!NullableEventHandler} */ SVGSVGElement.prototype.onstorage;
/** @type {!NullableEventHandler} */ SVGSVGElement.prototype.onunhandledrejection;
/** @type {!NullableEventHandler} */ SVGSVGElement.prototype.onunload;
/** @type {!NullableEventHandler} */ SVGSVGElement.prototype.ongamepadconnected;
/** @type {!NullableEventHandler} */ SVGSVGElement.prototype.ongamepaddisconnected;
/** @type {!SVGAnimatedPreserveAspectRatio} */ SVGSVGElement.prototype.preserveAspectRatio;
/** @type {!SVGAnimatedRect} */ SVGSVGElement.prototype.viewBox;
/**
 * @param {!number} suspendHandleID
 * @return {undefined}
 */
SVGSVGElement.prototype.unsuspendRedraw = function(suspendHandleID) {}
/**
 * @param {!DOMMatrixReadOnly} matrix
 * @return {!SVGTransform}
 */
SVGSVGElement.prototype.createSVGTransformFromMatrix = function(matrix) {}
/**
 * @return {!SVGAngle}
 */
SVGSVGElement.prototype.createSVGAngle = function() {}
/**
 * @param {!DOMRectReadOnly} rect
 * @param {?SVGElement} referenceElement
 * @return {!NodeList}
 */
SVGSVGElement.prototype.getEnclosureList = function(rect,referenceElement) {}
/**
 * @param {!string} elementId
 * @return {!Element}
 * @nosideeffects
 */
SVGSVGElement.prototype.getElementById = function(elementId) {}
/**
 * @return {undefined}
 */
SVGSVGElement.prototype.deselectAll = function() {}
/**
 * @return {undefined}
 */
SVGSVGElement.prototype.forceRedraw = function() {}
/**
 * @param {!SVGElement} element
 * @param {!DOMRectReadOnly} rect
 * @return {!boolean}
 */
SVGSVGElement.prototype.checkIntersection = function(element,rect) {}
/**
 * @return {!SVGTransform}
 */
SVGSVGElement.prototype.createSVGTransform = function() {}
/**
 * @return {!DOMRect}
 */
SVGSVGElement.prototype.createSVGRect = function() {}
/**
 * @return {!DOMMatrix}
 */
SVGSVGElement.prototype.createSVGMatrix = function() {}
/**
 * @return {!SVGLength}
 */
SVGSVGElement.prototype.createSVGLength = function() {}
/**
 * @param {!number} maxWaitMilliseconds
 * @return {!number}
 */
SVGSVGElement.prototype.suspendRedraw = function(maxWaitMilliseconds) {}
/**
 * @return {!SVGNumber}
 */
SVGSVGElement.prototype.createSVGNumber = function() {}
/**
 * @return {!DOMPoint}
 */
SVGSVGElement.prototype.createSVGPoint = function() {}
/**
 * @return {undefined}
 */
SVGSVGElement.prototype.unsuspendRedrawAll = function() {}
/**
 * @param {!SVGElement} element
 * @param {!DOMRectReadOnly} rect
 * @return {!boolean}
 */
SVGSVGElement.prototype.checkEnclosure = function(element,rect) {}
/**
 * @param {!DOMRectReadOnly} rect
 * @param {?SVGElement} referenceElement
 * @return {!NodeList}
 */
SVGSVGElement.prototype.getIntersectionList = function(rect,referenceElement) {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function WebGLObject() {}
/**
 * @constructor
 * @private
 * @extends {EventTarget}
 * @nosideeffects
 */
function RTCDtlsTransport() {}
/** @type {!RTCIceTransport} */ RTCDtlsTransport.prototype.iceTransport;
/** @type {!string} */ RTCDtlsTransport.prototype.state;
/** @type {!NullableEventHandler} */ RTCDtlsTransport.prototype.onerror;
/** @type {!NullableEventHandler} */ RTCDtlsTransport.prototype.onstatechange;
/**
 * @return {!Array<!ArrayBuffer>}
 */
RTCDtlsTransport.prototype.getRemoteCertificates = function() {}
/**
 * @constructor
 * @extends {EventTarget}
 * @param {!string} url
 * @param {!EventSourceInit=} eventSourceInitDict
 */
function EventSource(url,eventSourceInitDict) {}
/** @const {!number} */ EventSource.CLOSED;
/** @const {!number} */ EventSource.prototype.CLOSED;
/** @const {!number} */ EventSource.CONNECTING;
/** @const {!number} */ EventSource.prototype.CONNECTING;
/** @const {!number} */ EventSource.OPEN;
/** @const {!number} */ EventSource.prototype.OPEN;
/** @type {!number} */ EventSource.prototype.readyState;
/** @type {!string} */ EventSource.prototype.url;
/** @type {!boolean} */ EventSource.prototype.withCredentials;
/** @type {!NullableEventHandler} */ EventSource.prototype.onerror;
/** @type {?MessageEventHandler} */ EventSource.prototype.onmessage;
/** @type {?EventHandler} */ EventSource.prototype.onopen;
/**
 * @return {undefined}
 */
EventSource.prototype.close = function() {}
/**
 * @constructor
 * @extends {Object}
 * @param {!number=} x
 * @param {!number=} y
 * @param {!number=} z
 * @param {!number=} w
 */
function DOMPointReadOnly(x,y,z,w) {}
/** @type {!number} */ DOMPointReadOnly.prototype.w;
/** @type {!number} */ DOMPointReadOnly.prototype.x;
/** @type {!number} */ DOMPointReadOnly.prototype.y;
/** @type {!number} */ DOMPointReadOnly.prototype.z;
/**
 * @param {!DOMMatrixInit=} matrix
 * @return {!DOMPoint}
 */
DOMPointReadOnly.prototype.matrixTransform = function(matrix) {}
/**
 * @return {!Object}
 * @override
 */
DOMPointReadOnly.prototype.toJSON = function() {}
/**
 * @param {!DOMPointInit=} other
 * @return {!DOMPointReadOnly}
 */
DOMPointReadOnly.fromPoint = function(other) {}
/**
 * @constructor
 * @private
 * @extends {Node}
 * @nosideeffects
 */
function CharacterData() {}
/** @type {!number} */ CharacterData.prototype.length;
/** @type {!string} */ CharacterData.prototype.data;
/** @type {?Element} */ CharacterData.prototype.nextElementSibling;
/** @type {?Element} */ CharacterData.prototype.previousElementSibling;
/**
 * @param {!string} data
 * @return {undefined}
 */
CharacterData.prototype.appendData = function(data) {}
/**
 * @param {!number} offset
 * @param {!number} count
 * @param {!string} data
 * @return {undefined}
 */
CharacterData.prototype.replaceData = function(offset,count,data) {}
/**
 * @param {!number} offset
 * @param {!number} count
 * @return {undefined}
 */
CharacterData.prototype.deleteData = function(offset,count) {}
/**
 * @param {...(!Node|!string)} nodes
 * @return {undefined}
 */
CharacterData.prototype.before = function(nodes) {}
/**
 * @param {!number} offset
 * @param {!number} count
 * @return {!string}
 * @nosideeffects
 */
CharacterData.prototype.substringData = function(offset,count) {}
/**
 * @param {...(!Node|!string)} nodes
 * @return {undefined}
 */
CharacterData.prototype.after = function(nodes) {}
/**
 * @param {!number} offset
 * @param {!string} data
 * @return {undefined}
 */
CharacterData.prototype.insertData = function(offset,data) {}
/**
 * @return {undefined}
 */
CharacterData.prototype.remove = function() {}
/**
 * @param {...(!Node|!string)} nodes
 * @return {undefined}
 */
CharacterData.prototype.replaceWith = function(nodes) {}
/**
 * @constructor
 * @private
 * @extends {EventTarget}
 * @nosideeffects
 */
function MediaKeySession() {}
/** @type {!Promise<undefined>} */ MediaKeySession.prototype.closed;
/** @type {!number} */ MediaKeySession.prototype.expiration;
/** @type {!MediaKeyStatusMap} */ MediaKeySession.prototype.keyStatuses;
/** @type {!string} */ MediaKeySession.prototype.sessionId;
/** @type {!NullableEventHandler} */ MediaKeySession.prototype.onkeystatuseschange;
/** @type {!NullableEventHandler} */ MediaKeySession.prototype.onmessage;
/**
 * @param {!string} sessionId
 * @return {!Promise<!boolean>}
 */
MediaKeySession.prototype.load = function(sessionId) {}
/**
 * @param {!BufferSource} response
 * @return {!Promise<undefined>}
 */
MediaKeySession.prototype.update = function(response) {}
/**
 * @param {!string} initDataType
 * @param {!BufferSource} initData
 * @return {!Promise<undefined>}
 */
MediaKeySession.prototype.generateRequest = function(initDataType,initData) {}
/**
 * @return {!Promise<undefined>}
 */
MediaKeySession.prototype.close = function() {}
/**
 * @return {!Promise<undefined>}
 */
MediaKeySession.prototype.remove = function() {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function WEBGL_compressed_texture_etc1() {}
/** @const {!GLenum} */ WEBGL_compressed_texture_etc1.prototype.COMPRESSED_RGB_ETC1_WEBGL;
/**
 * @constructor
 * @private
 * @extends {HTMLElement}
 * @nosideeffects
 */
function HTMLMediaElement() {}
/** @const {!number} */ HTMLMediaElement.HAVE_CURRENT_DATA;
/** @const {!number} */ HTMLMediaElement.prototype.HAVE_CURRENT_DATA;
/** @const {!number} */ HTMLMediaElement.HAVE_ENOUGH_DATA;
/** @const {!number} */ HTMLMediaElement.prototype.HAVE_ENOUGH_DATA;
/** @const {!number} */ HTMLMediaElement.HAVE_FUTURE_DATA;
/** @const {!number} */ HTMLMediaElement.prototype.HAVE_FUTURE_DATA;
/** @const {!number} */ HTMLMediaElement.HAVE_METADATA;
/** @const {!number} */ HTMLMediaElement.prototype.HAVE_METADATA;
/** @const {!number} */ HTMLMediaElement.HAVE_NOTHING;
/** @const {!number} */ HTMLMediaElement.prototype.HAVE_NOTHING;
/** @const {!number} */ HTMLMediaElement.NETWORK_EMPTY;
/** @const {!number} */ HTMLMediaElement.prototype.NETWORK_EMPTY;
/** @const {!number} */ HTMLMediaElement.NETWORK_IDLE;
/** @const {!number} */ HTMLMediaElement.prototype.NETWORK_IDLE;
/** @const {!number} */ HTMLMediaElement.NETWORK_LOADING;
/** @const {!number} */ HTMLMediaElement.prototype.NETWORK_LOADING;
/** @const {!number} */ HTMLMediaElement.NETWORK_NO_SOURCE;
/** @const {!number} */ HTMLMediaElement.prototype.NETWORK_NO_SOURCE;
/** @type {!AudioTrackList} */ HTMLMediaElement.prototype.audioTracks;
/** @type {!TimeRanges} */ HTMLMediaElement.prototype.buffered;
/** @type {!string} */ HTMLMediaElement.prototype.currentSrc;
/** @type {!number} */ HTMLMediaElement.prototype.duration;
/** @type {!boolean} */ HTMLMediaElement.prototype.ended;
/** @type {?MediaError} */ HTMLMediaElement.prototype.error;
/** @type {!number} */ HTMLMediaElement.prototype.networkState;
/** @type {!boolean} */ HTMLMediaElement.prototype.paused;
/** @type {!TimeRanges} */ HTMLMediaElement.prototype.played;
/** @type {!number} */ HTMLMediaElement.prototype.readyState;
/** @type {!TimeRanges} */ HTMLMediaElement.prototype.seekable;
/** @type {!boolean} */ HTMLMediaElement.prototype.seeking;
/** @type {!TextTrackList} */ HTMLMediaElement.prototype.textTracks;
/** @type {!VideoTrackList} */ HTMLMediaElement.prototype.videoTracks;
/** @type {!boolean} */ HTMLMediaElement.prototype.autoplay;
/** @type {!boolean} */ HTMLMediaElement.prototype.controls;
/** @type {?string} */ HTMLMediaElement.prototype.crossOrigin;
/** @type {!number} */ HTMLMediaElement.prototype.currentTime;
/** @type {!boolean} */ HTMLMediaElement.prototype.defaultMuted;
/** @type {!number} */ HTMLMediaElement.prototype.defaultPlaybackRate;
/** @type {!boolean} */ HTMLMediaElement.prototype.loop;
/** @type {!boolean} */ HTMLMediaElement.prototype.muted;
/** @type {!number} */ HTMLMediaElement.prototype.playbackRate;
/** @type {!string} */ HTMLMediaElement.prototype.preload;
/** @type {!boolean} */ HTMLMediaElement.prototype.preservesPitch;
/** @type {!string} */ HTMLMediaElement.prototype.src;
/** @type {?MediaProvider} */ HTMLMediaElement.prototype.srcObject;
/** @type {!number} */ HTMLMediaElement.prototype.volume;
/** @type {?MediaKeys} */ HTMLMediaElement.prototype.mediaKeys;
/** @type {!NullableEventHandler} */ HTMLMediaElement.prototype.onencrypted;
/** @type {!NullableEventHandler} */ HTMLMediaElement.prototype.onwaitingforkey;
/**
 * @return {!Promise<undefined>}
 */
HTMLMediaElement.prototype.play = function() {}
/**
 * @return {!Object}
 */
HTMLMediaElement.prototype.getStartDate = function() {}
/**
 * @return {undefined}
 */
HTMLMediaElement.prototype.load = function() {}
/**
 * @param {?MediaKeys} mediaKeys
 * @return {!Promise<undefined>}
 */
HTMLMediaElement.prototype.setMediaKeys = function(mediaKeys) {}
/**
 * @param {!string} type
 * @return {!string}
 * @nosideeffects
 */
HTMLMediaElement.prototype.canPlayType = function(type) {}
/**
 * @return {undefined}
 */
HTMLMediaElement.prototype.pause = function() {}
/**
 * @param {!string} kind
 * @param {!string=} label
 * @param {!string=} language
 * @return {!TextTrack}
 */
HTMLMediaElement.prototype.addTextTrack = function(kind,label,language) {}
/**
 * @param {!number} time
 * @return {undefined}
 */
HTMLMediaElement.prototype.fastSeek = function(time) {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function BarProp() {}
/** @type {!boolean} */ BarProp.prototype.visible;
/**
 * @constructor
 * @private
 * @extends {HTMLElement}
 * @nosideeffects
 */
function HTMLFieldSetElement() {}
/** @type {!HTMLCollection} */ HTMLFieldSetElement.prototype.elements;
/** @type {?HTMLFormElement} */ HTMLFieldSetElement.prototype.form;
/** @type {!string} */ HTMLFieldSetElement.prototype.type;
/** @type {!string} */ HTMLFieldSetElement.prototype.validationMessage;
/** @type {!ValidityState} */ HTMLFieldSetElement.prototype.validity;
/** @type {!boolean} */ HTMLFieldSetElement.prototype.willValidate;
/** @type {!boolean} */ HTMLFieldSetElement.prototype.disabled;
/** @type {!string} */ HTMLFieldSetElement.prototype.name;
/**
 * @param {!string} error
 * @return {undefined}
 */
HTMLFieldSetElement.prototype.setCustomValidity = function(error) {}
/**
 * @return {!boolean}
 */
HTMLFieldSetElement.prototype.reportValidity = function() {}
/**
 * @return {!boolean}
 */
HTMLFieldSetElement.prototype.checkValidity = function() {}
/**
 * @constructor
 * @extends {AudioScheduledSourceNode}
 * @param {!BaseAudioContext} context
 * @param {!OscillatorOptions=} options
 */
function OscillatorNode(context,options) {}
/** @type {!AudioParam} */ OscillatorNode.prototype.detune;
/** @type {!AudioParam} */ OscillatorNode.prototype.frequency;
/** @type {!string} */ OscillatorNode.prototype.type;
/**
 * @param {!PeriodicWave} periodicWave
 * @return {undefined}
 */
OscillatorNode.prototype.setPeriodicWave = function(periodicWave) {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function GPUSupportedFeatures() {}
/** @const {number} */ GPUSupportedFeatures.prototype.size;
/**
 * @param {!string} value
 * @return {!boolean}
 * @nosideeffects
 */
GPUSupportedFeatures.prototype.has = function(value) {}
/**
 * @return {!Iterator<!string>}
 * @nosideeffects
 */
GPUSupportedFeatures.prototype.keys = function() {}
/**
 * @return {!Iterator<!string>}
 * @nosideeffects
 */
GPUSupportedFeatures.prototype.values = function() {}
/**
 * @return {!Iterator<!Array<!string|!string>>}
 * @nosideeffects
 */
GPUSupportedFeatures.prototype.entries = function() {};
/**
 * @return {!Iterator<!Array<!string|!string>>}
 * @nosideeffects
 */
GPUSupportedFeatures.prototype[Symbol.iterator] = function() {};
/**
 * @param {function(!string, !string, MAP)} callback
 * @this {MAP}
 * @template MAP
 */
GPUSupportedFeatures.prototype.forEach = function(callback) {};
/**
 * @constructor
 * @private
 * @extends {EventTarget}
 * @nosideeffects
 */
function TextTrackList() {}
/** @type {!number} */ TextTrackList.prototype.length;
/** @type {?TrackEventHandler} */ TextTrackList.prototype.onaddtrack;
/** @type {?EventHandler} */ TextTrackList.prototype.onchange;
/** @type {!NullableEventHandler} */ TextTrackList.prototype.onremovetrack;
/**
 * @param {!string} id
 * @return {?TextTrack}
 */
TextTrackList.prototype.getTrackById = function(id) {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function BluetoothCharacteristicProperties() {}
/** @type {!boolean} */ BluetoothCharacteristicProperties.prototype.authenticatedSignedWrites;
/** @type {!boolean} */ BluetoothCharacteristicProperties.prototype.broadcast;
/** @type {!boolean} */ BluetoothCharacteristicProperties.prototype.indicate;
/** @type {!boolean} */ BluetoothCharacteristicProperties.prototype.notify;
/** @type {!boolean} */ BluetoothCharacteristicProperties.prototype.read;
/** @type {!boolean} */ BluetoothCharacteristicProperties.prototype.reliableWrite;
/** @type {!boolean} */ BluetoothCharacteristicProperties.prototype.writableAuxiliaries;
/** @type {!boolean} */ BluetoothCharacteristicProperties.prototype.write;
/** @type {!boolean} */ BluetoothCharacteristicProperties.prototype.writeWithoutResponse;
/**
 * @constructor
 * @private
 * @extends {SVGElement}
 * @nosideeffects
 */
function SVGTitleElement() {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function ValidityState() {}
/** @type {!boolean} */ ValidityState.prototype.badInput;
/** @type {!boolean} */ ValidityState.prototype.customError;
/** @type {!boolean} */ ValidityState.prototype.patternMismatch;
/** @type {!boolean} */ ValidityState.prototype.rangeOverflow;
/** @type {!boolean} */ ValidityState.prototype.rangeUnderflow;
/** @type {!boolean} */ ValidityState.prototype.stepMismatch;
/** @type {!boolean} */ ValidityState.prototype.tooLong;
/** @type {!boolean} */ ValidityState.prototype.tooShort;
/** @type {!boolean} */ ValidityState.prototype.typeMismatch;
/** @type {!boolean} */ ValidityState.prototype.valid;
/** @type {!boolean} */ ValidityState.prototype.valueMissing;
/**
 * @constructor
 * @extends {Object}
 * @param {!MutationCallback} callback
 */
function MutationObserver(callback) {}
/**
 * @return {undefined}
 */
MutationObserver.prototype.disconnect = function() {}
/**
 * @return {!Array<!MutationRecord>}
 */
MutationObserver.prototype.takeRecords = function() {}
/**
 * @param {!Node} target
 * @param {!MutationObserverInit=} options
 * @return {undefined}
 */
MutationObserver.prototype.observe = function(target,options) {}
/**
 * @constructor
 * @private
 * @extends {Node}
 * @nosideeffects
 */
function Element() {}
/** @type {!NamedNodeMap} */ Element.prototype.attributes;
/** @type {!DOMTokenList} */ Element.prototype.classList;
/** @type {!string} */ Element.prototype.localName;
/** @type {?string} */ Element.prototype.namespaceURI;
/** @type {?string} */ Element.prototype.prefix;
/** @type {?ShadowRoot} */ Element.prototype.shadowRoot;
/** @type {!string} */ Element.prototype.tagName;
/** @type {!string} */ Element.prototype.className;
/** @type {!string} */ Element.prototype.id;
/** @type {!string} */ Element.prototype.slot;
/** @type {!number} */ Element.prototype.clientHeight;
/** @type {!number} */ Element.prototype.clientLeft;
/** @type {!number} */ Element.prototype.clientTop;
/** @type {!number} */ Element.prototype.clientWidth;
/** @type {!number} */ Element.prototype.scrollHeight;
/** @type {!number} */ Element.prototype.scrollWidth;
/** @type {!number} */ Element.prototype.scrollLeft;
/** @type {!number} */ Element.prototype.scrollTop;
/** @type {!string} */ Element.prototype.outerHTML;
/** @type {?EventHandler} */ Element.prototype.onfullscreenchange;
/** @type {?EventHandler} */ Element.prototype.onfullscreenerror;
/** @type {!number} */ Element.prototype.childElementCount;
/** @type {!HTMLCollection} */ Element.prototype.children;
/** @type {?Element} */ Element.prototype.firstElementChild;
/** @type {?Element} */ Element.prototype.lastElementChild;
/** @type {!string} */ Element.prototype.innerHTML;
/** @type {?HTMLSlotElement} */ Element.prototype.assignedSlot;
/** @type {?Element} */ Element.prototype.nextElementSibling;
/** @type {?Element} */ Element.prototype.previousElementSibling;
/** @type {!string} */ Element.prototype.ariaAtomic;
/** @type {!string} */ Element.prototype.ariaAutoComplete;
/** @type {!string} */ Element.prototype.ariaBusy;
/** @type {!string} */ Element.prototype.ariaChecked;
/** @type {!string} */ Element.prototype.ariaColCount;
/** @type {!string} */ Element.prototype.ariaColIndex;
/** @type {!string} */ Element.prototype.ariaColIndexText;
/** @type {!string} */ Element.prototype.ariaColSpan;
/** @type {!string} */ Element.prototype.ariaCurrent;
/** @type {!string} */ Element.prototype.ariaDescription;
/** @type {!string} */ Element.prototype.ariaDisabled;
/** @type {!string} */ Element.prototype.ariaExpanded;
/** @type {!string} */ Element.prototype.ariaHasPopup;
/** @type {!string} */ Element.prototype.ariaHidden;
/** @type {!string} */ Element.prototype.ariaInvalid;
/** @type {!string} */ Element.prototype.ariaKeyShortcuts;
/** @type {!string} */ Element.prototype.ariaLabel;
/** @type {!string} */ Element.prototype.ariaLevel;
/** @type {!string} */ Element.prototype.ariaLive;
/** @type {!string} */ Element.prototype.ariaModal;
/** @type {!string} */ Element.prototype.ariaMultiLine;
/** @type {!string} */ Element.prototype.ariaMultiSelectable;
/** @type {!string} */ Element.prototype.ariaOrientation;
/** @type {!string} */ Element.prototype.ariaPlaceholder;
/** @type {!string} */ Element.prototype.ariaPosInSet;
/** @type {!string} */ Element.prototype.ariaPressed;
/** @type {!string} */ Element.prototype.ariaReadOnly;
/** @type {!string} */ Element.prototype.ariaRequired;
/** @type {!string} */ Element.prototype.ariaRoleDescription;
/** @type {!string} */ Element.prototype.ariaRowCount;
/** @type {!string} */ Element.prototype.ariaRowIndex;
/** @type {!string} */ Element.prototype.ariaRowIndexText;
/** @type {!string} */ Element.prototype.ariaRowSpan;
/** @type {!string} */ Element.prototype.ariaSelected;
/** @type {!string} */ Element.prototype.ariaSetSize;
/** @type {!string} */ Element.prototype.ariaSort;
/** @type {!string} */ Element.prototype.ariaValueMax;
/** @type {!string} */ Element.prototype.ariaValueMin;
/** @type {!string} */ Element.prototype.ariaValueNow;
/** @type {!string} */ Element.prototype.ariaValueText;
/** @type {?string} */ Element.prototype.role;
/**
 * @param {!FullscreenOptions=} options
 * @return {!Promise<undefined>}
 */
Element.prototype.requestFullscreen = function(options) {}
/**
 * @return {undefined}
 */
Element.prototype.requestPointerLock = function() {}
/**
 * @param {(!ScrollToOptions|!number)=} arg0
 * @param {!number=} arg1
 * @return {undefined}
 */
Element.prototype.scrollBy = function(arg0,arg1) {}
/**
 * @param {...(!Node|!string)} nodes
 * @return {undefined}
 */
Element.prototype.before = function(nodes) {}
/**
 * @param {!string} selectors
 * @return {!NodeList}
 * @nosideeffects
 */
Element.prototype.querySelectorAll = function(selectors) {}
/**
 * @return {!DOMRect}
 */
Element.prototype.getBoundingClientRect = function() {}
/**
 * @param {...(!Node|!string)} nodes
 * @return {undefined}
 */
Element.prototype.prepend = function(nodes) {}
/**
 * @param {!Attr} attr
 * @return {?Attr}
 */
Element.prototype.setAttributeNodeNS = function(attr) {}
/**
 * @param {?string} namespace
 * @param {!string} localName
 * @return {undefined}
 */
Element.prototype.removeAttributeNS = function(namespace,localName) {}
/**
 * @param {?Object} keyframes
 * @param {(!number|!KeyframeAnimationOptions)=} options
 * @return {!Animation}
 */
Element.prototype.animate = function(keyframes,options) {}
/**
 * @return {undefined}
 */
Element.prototype.remove = function() {}
/**
 * @param {!number} pointerId
 * @return {!boolean}
 */
Element.prototype.hasPointerCapture = function(pointerId) {}
/**
 * @param {!ShadowRootInit} init
 * @return {!ShadowRoot}
 */
Element.prototype.attachShadow = function(init) {}
/**
 * @param {?string} namespace
 * @param {!string} localName
 * @return {!HTMLCollection}
 * @nosideeffects
 */
Element.prototype.getElementsByTagNameNS = function(namespace,localName) {}
/**
 * @param {!string} qualifiedName
 * @param {!string} value
 * @return {undefined}
 */
Element.prototype.setAttribute = function(qualifiedName,value) {}
/**
 * @param {!string} qualifiedName
 * @return {?string}
 * @nosideeffects
 */
Element.prototype.getAttribute = function(qualifiedName) {}
/**
 * @param {(!boolean|!ScrollIntoViewOptions)=} arg
 * @return {undefined}
 */
Element.prototype.scrollIntoView = function(arg) {}
/**
 * @param {!string} selectors
 * @return {!boolean}
 * @nosideeffects
 */
Element.prototype.webkitMatchesSelector = function(selectors) {}
/**
 * @param {!string} where
 * @param {!string} data
 * @return {undefined}
 */
Element.prototype.insertAdjacentText = function(where,data) {}
/**
 * @return {!boolean}
 * @nosideeffects
 */
Element.prototype.hasAttributes = function() {}
/**
 * @param {!string} where
 * @param {!Element} element
 * @return {?Element}
 */
Element.prototype.insertAdjacentElement = function(where,element) {}
/**
 * @param {?string} namespace
 * @param {!string} localName
 * @return {!boolean}
 * @nosideeffects
 */
Element.prototype.hasAttributeNS = function(namespace,localName) {}
/**
 * @param {...(!Node|!string)} nodes
 * @return {undefined}
 */
Element.prototype.after = function(nodes) {}
/**
 * @param {!GetAnimationsOptions=} options
 * @return {!Array<!Animation>}
 */
Element.prototype.getAnimations = function(options) {}
/**
 * @param {?string} namespace
 * @param {!string} qualifiedName
 * @param {!string} value
 * @return {undefined}
 */
Element.prototype.setAttributeNS = function(namespace,qualifiedName,value) {}
/**
 * @param {!string} qualifiedName
 * @return {undefined}
 */
Element.prototype.removeAttribute = function(qualifiedName) {}
/**
 * @param {!CSSOMString} type
 * @return {?CSSPseudoElement}
 */
Element.prototype.pseudo = function(type) {}
/**
 * @param {!string} qualifiedName
 * @return {!HTMLCollection}
 * @nosideeffects
 */
Element.prototype.getElementsByTagName = function(qualifiedName) {}
/**
 * @param {...(!Node|!string)} nodes
 * @return {undefined}
 */
Element.prototype.replaceChildren = function(nodes) {}
/**
 * @param {!string} qualifiedName
 * @param {!boolean=} force
 * @return {!boolean}
 */
Element.prototype.toggleAttribute = function(qualifiedName,force) {}
/**
 * @param {!number} pointerId
 * @return {undefined}
 */
Element.prototype.releasePointerCapture = function(pointerId) {}
/**
 * @param {(!ScrollToOptions|!number)=} arg0
 * @param {!number=} arg1
 * @return {undefined}
 */
Element.prototype.scroll = function(arg0,arg1) {}
/**
 * @param {!Attr} attr
 * @return {?Attr}
 */
Element.prototype.setAttributeNode = function(attr) {}
/**
 * @param {!string} qualifiedName
 * @return {!boolean}
 * @nosideeffects
 */
Element.prototype.hasAttribute = function(qualifiedName) {}
/**
 * @param {!string} selectors
 * @return {?Element}
 * @nosideeffects
 */
Element.prototype.querySelector = function(selectors) {}
/**
 * @param {!string} selectors
 * @return {!boolean}
 * @nosideeffects
 */
Element.prototype.matches = function(selectors) {}
/**
 * @param {(!ScrollToOptions|!number)=} arg0
 * @param {!number=} arg1
 * @return {undefined}
 */
Element.prototype.scrollTo = function(arg0,arg1) {}
/**
 * @return {!DOMRectList}
 */
Element.prototype.getClientRects = function() {}
/**
 * @param {!string} qualifiedName
 * @return {?Attr}
 * @nosideeffects
 */
Element.prototype.getAttributeNode = function(qualifiedName) {}
/**
 * @return {!Array<!string>}
 */
Element.prototype.getAttributeNames = function() {}
/**
 * @param {!number} pointerId
 * @return {undefined}
 */
Element.prototype.setPointerCapture = function(pointerId) {}
/**
 * @param {?string} namespace
 * @param {!string} localName
 * @return {?string}
 * @nosideeffects
 */
Element.prototype.getAttributeNS = function(namespace,localName) {}
/**
 * @param {!string} classNames
 * @return {!HTMLCollection}
 * @nosideeffects
 */
Element.prototype.getElementsByClassName = function(classNames) {}
/**
 * @param {!Attr} attr
 * @return {!Attr}
 */
Element.prototype.removeAttributeNode = function(attr) {}
/**
 * @param {...(!Node|!string)} nodes
 * @return {undefined}
 */
Element.prototype.append = function(nodes) {}
/**
 * @param {!string} position
 * @param {!string} text
 * @return {undefined}
 */
Element.prototype.insertAdjacentHTML = function(position,text) {}
/**
 * @param {?string} namespace
 * @param {!string} localName
 * @return {?Attr}
 * @nosideeffects
 */
Element.prototype.getAttributeNodeNS = function(namespace,localName) {}
/**
 * @param {...(!Node|!string)} nodes
 * @return {undefined}
 */
Element.prototype.replaceWith = function(nodes) {}
/**
 * @param {!string} selectors
 * @return {?Element}
 * @nosideeffects
 */
Element.prototype.closest = function(selectors) {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function GeolocationPositionError() {}
/** @const {!number} */ GeolocationPositionError.PERMISSION_DENIED;
/** @const {!number} */ GeolocationPositionError.prototype.PERMISSION_DENIED;
/** @const {!number} */ GeolocationPositionError.POSITION_UNAVAILABLE;
/** @const {!number} */ GeolocationPositionError.prototype.POSITION_UNAVAILABLE;
/** @const {!number} */ GeolocationPositionError.TIMEOUT;
/** @const {!number} */ GeolocationPositionError.prototype.TIMEOUT;
/** @type {!number} */ GeolocationPositionError.prototype.code;
/** @type {!string} */ GeolocationPositionError.prototype.message;
/**
 * @constructor
 * @extends {MouseEvent}
 * @param {!string} type
 * @param {!DragEventInit=} eventInitDict
 */
function DragEvent(type,eventInitDict) {}
/** @type {?DataTransfer} */ DragEvent.prototype.dataTransfer;
/**
 * @constructor
 * @extends {Error}
 * @param {!string=} message
 * @param {!string=} name
 */
function DOMException(message,name) {}
/** @const {!number} */ DOMException.ABORT_ERR;
/** @const {!number} */ DOMException.prototype.ABORT_ERR;
/** @const {!number} */ DOMException.DATA_CLONE_ERR;
/** @const {!number} */ DOMException.prototype.DATA_CLONE_ERR;
/** @const {!number} */ DOMException.DOMSTRING_SIZE_ERR;
/** @const {!number} */ DOMException.prototype.DOMSTRING_SIZE_ERR;
/** @const {!number} */ DOMException.HIERARCHY_REQUEST_ERR;
/** @const {!number} */ DOMException.prototype.HIERARCHY_REQUEST_ERR;
/** @const {!number} */ DOMException.INDEX_SIZE_ERR;
/** @const {!number} */ DOMException.prototype.INDEX_SIZE_ERR;
/** @const {!number} */ DOMException.INUSE_ATTRIBUTE_ERR;
/** @const {!number} */ DOMException.prototype.INUSE_ATTRIBUTE_ERR;
/** @const {!number} */ DOMException.INVALID_ACCESS_ERR;
/** @const {!number} */ DOMException.prototype.INVALID_ACCESS_ERR;
/** @const {!number} */ DOMException.INVALID_CHARACTER_ERR;
/** @const {!number} */ DOMException.prototype.INVALID_CHARACTER_ERR;
/** @const {!number} */ DOMException.INVALID_MODIFICATION_ERR;
/** @const {!number} */ DOMException.prototype.INVALID_MODIFICATION_ERR;
/** @const {!number} */ DOMException.INVALID_NODE_TYPE_ERR;
/** @const {!number} */ DOMException.prototype.INVALID_NODE_TYPE_ERR;
/** @const {!number} */ DOMException.INVALID_STATE_ERR;
/** @const {!number} */ DOMException.prototype.INVALID_STATE_ERR;
/** @const {!number} */ DOMException.NAMESPACE_ERR;
/** @const {!number} */ DOMException.prototype.NAMESPACE_ERR;
/** @const {!number} */ DOMException.NETWORK_ERR;
/** @const {!number} */ DOMException.prototype.NETWORK_ERR;
/** @const {!number} */ DOMException.NOT_FOUND_ERR;
/** @const {!number} */ DOMException.prototype.NOT_FOUND_ERR;
/** @const {!number} */ DOMException.NOT_SUPPORTED_ERR;
/** @const {!number} */ DOMException.prototype.NOT_SUPPORTED_ERR;
/** @const {!number} */ DOMException.NO_DATA_ALLOWED_ERR;
/** @const {!number} */ DOMException.prototype.NO_DATA_ALLOWED_ERR;
/** @const {!number} */ DOMException.NO_MODIFICATION_ALLOWED_ERR;
/** @const {!number} */ DOMException.prototype.NO_MODIFICATION_ALLOWED_ERR;
/** @const {!number} */ DOMException.QUOTA_EXCEEDED_ERR;
/** @const {!number} */ DOMException.prototype.QUOTA_EXCEEDED_ERR;
/** @const {!number} */ DOMException.SECURITY_ERR;
/** @const {!number} */ DOMException.prototype.SECURITY_ERR;
/** @const {!number} */ DOMException.SYNTAX_ERR;
/** @const {!number} */ DOMException.prototype.SYNTAX_ERR;
/** @const {!number} */ DOMException.TIMEOUT_ERR;
/** @const {!number} */ DOMException.prototype.TIMEOUT_ERR;
/** @const {!number} */ DOMException.TYPE_MISMATCH_ERR;
/** @const {!number} */ DOMException.prototype.TYPE_MISMATCH_ERR;
/** @const {!number} */ DOMException.URL_MISMATCH_ERR;
/** @const {!number} */ DOMException.prototype.URL_MISMATCH_ERR;
/** @const {!number} */ DOMException.VALIDATION_ERR;
/** @const {!number} */ DOMException.prototype.VALIDATION_ERR;
/** @const {!number} */ DOMException.WRONG_DOCUMENT_ERR;
/** @const {!number} */ DOMException.prototype.WRONG_DOCUMENT_ERR;
/** @type {!number} */ DOMException.prototype.code;
/**
 * @constructor
 * @private
 * @extends {SVGElement}
 * @nosideeffects
 */
function SVGStyleElement() {}
/** @type {!string} */ SVGStyleElement.prototype.media;
/** @type {!string} */ SVGStyleElement.prototype.title;
/** @type {!string} */ SVGStyleElement.prototype.type;
/** @type {?CSSStyleSheet} */ SVGStyleElement.prototype.sheet;
/**
 * @constructor
 * @extends {Event}
 * @param {!string} type
 * @param {!BluetoothAdvertisingEventInit} init
 */
function BluetoothAdvertisingEvent(type,init) {}
/** @type {?number} */ BluetoothAdvertisingEvent.prototype.appearance;
/** @type {!BluetoothDevice} */ BluetoothAdvertisingEvent.prototype.device;
/** @type {!BluetoothManufacturerDataMap} */ BluetoothAdvertisingEvent.prototype.manufacturerData;
/** @type {?string} */ BluetoothAdvertisingEvent.prototype.name;
/** @type {?number} */ BluetoothAdvertisingEvent.prototype.rssi;
/** @type {!BluetoothServiceDataMap} */ BluetoothAdvertisingEvent.prototype.serviceData;
/** @type {?number} */ BluetoothAdvertisingEvent.prototype.txPower;
/** @type {!Array<!UUID>} */ BluetoothAdvertisingEvent.prototype.uuids;
/**
 * @constructor
 * @private
 * @extends {SVGGraphicsElement}
 * @nosideeffects
 */
function SVGImageElement() {}
/** @type {!SVGAnimatedLength} */ SVGImageElement.prototype.height;
/** @type {!SVGAnimatedPreserveAspectRatio} */ SVGImageElement.prototype.preserveAspectRatio;
/** @type {!SVGAnimatedLength} */ SVGImageElement.prototype.width;
/** @type {!SVGAnimatedLength} */ SVGImageElement.prototype.x;
/** @type {!SVGAnimatedLength} */ SVGImageElement.prototype.y;
/** @type {?string} */ SVGImageElement.prototype.crossOrigin;
/** @type {!SVGAnimatedString} */ SVGImageElement.prototype.href;
/**
 * @constructor
 * @extends {EventTarget}
 */
function FileReader() {}
/** @const {!number} */ FileReader.DONE;
/** @const {!number} */ FileReader.prototype.DONE;
/** @const {!number} */ FileReader.EMPTY;
/** @const {!number} */ FileReader.prototype.EMPTY;
/** @const {!number} */ FileReader.LOADING;
/** @const {!number} */ FileReader.prototype.LOADING;
/** @type {?DOMException} */ FileReader.prototype.error;
/** @type {!number} */ FileReader.prototype.readyState;
/** @type {StringOrArrayBufferUnion} */ FileReader.prototype.result;
/** @type {?ProgressEventHandler} */ FileReader.prototype.onabort;
/** @type {?ProgressEventHandler} */ FileReader.prototype.onerror;
/** @type {?ProgressEventHandler} */ FileReader.prototype.onload;
/** @type {?ProgressEventHandler} */ FileReader.prototype.onloadend;
/** @type {?ProgressEventHandler} */ FileReader.prototype.onloadstart;
/** @type {?ProgressEventHandler} */ FileReader.prototype.onprogress;
/**
 * @param {!Blob} blob
 * @return {undefined}
 */
FileReader.prototype.readAsBinaryString = function(blob) {}
/**
 * @param {!Blob} blob
 * @return {undefined}
 */
FileReader.prototype.readAsDataURL = function(blob) {}
/**
 * @return {undefined}
 */
FileReader.prototype.abort = function() {}
/**
 * @param {!Blob} blob
 * @param {!string=} encoding
 * @return {undefined}
 */
FileReader.prototype.readAsText = function(blob,encoding) {}
/**
 * @param {!Blob} blob
 * @return {undefined}
 */
FileReader.prototype.readAsArrayBuffer = function(blob) {}
/**
 * @constructor
 * @private
 * @extends {PermissionStatus}
 * @nosideeffects
 */
function BluetoothPermissionResult() {}
/** @type {!Array<!BluetoothDevice>} */ BluetoothPermissionResult.prototype.devices;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function RTCRtpReceiver() {}
/** @type {!MediaStreamTrack} */ RTCRtpReceiver.prototype.track;
/** @type {?RTCDtlsTransport} */ RTCRtpReceiver.prototype.transport;
/**
 * @return {!Promise<!RTCStatsReport>}
 */
RTCRtpReceiver.prototype.getStats = function() {}
/**
 * @return {!Array<!RTCRtpSynchronizationSource>}
 */
RTCRtpReceiver.prototype.getSynchronizationSources = function() {}
/**
 * @return {!RTCRtpReceiveParameters}
 */
RTCRtpReceiver.prototype.getParameters = function() {}
/**
 * @param {!string} kind
 * @return {?RTCRtpCapabilities}
 */
RTCRtpReceiver.getCapabilities = function(kind) {}
/**
 * @return {!Array<!RTCRtpContributingSource>}
 */
RTCRtpReceiver.prototype.getContributingSources = function() {}
/**
 * @constructor
 * @private
 * @extends {AuthenticatorResponse}
 * @nosideeffects
 */
function AuthenticatorAttestationResponse() {}
/** @type {!ArrayBuffer} */ AuthenticatorAttestationResponse.prototype.attestationObject;
/**
 * @return {!ArrayBuffer}
 */
AuthenticatorAttestationResponse.prototype.getAuthenticatorData = function() {}
/**
 * @return {!COSEAlgorithmIdentifier}
 */
AuthenticatorAttestationResponse.prototype.getPublicKeyAlgorithm = function() {}
/**
 * @return {?ArrayBuffer}
 */
AuthenticatorAttestationResponse.prototype.getPublicKey = function() {}
/**
 * @return {!Array<!string>}
 */
AuthenticatorAttestationResponse.prototype.getTransports = function() {}
/**
 * @constructor
 * @private
 * @extends {XRSpace}
 * @nosideeffects
 */
function XRReferenceSpace() {}
/** @type {?XRReferenceSpaceEventHandler} */ XRReferenceSpace.prototype.onreset;
/**
 * @param {!XRRigidTransform} originOffset
 * @return {!XRReferenceSpace}
 */
XRReferenceSpace.prototype.getOffsetReferenceSpace = function(originOffset) {}
/**
 * @constructor
 * @extends {Object}
 */
function EventTarget() {}
/**
 * @param {!string} type
 * @param {?EventListener} callback
 * @param {(!EventListenerOptions|!boolean)=} options
 * @return {undefined}
 */
EventTarget.prototype.removeEventListener = function(type,callback,options) {}
/**
 * @param {!Event} event
 * @return {!boolean}
 */
EventTarget.prototype.dispatchEvent = function(event) {}
/**
 * @param {!string} type
 * @param {?EventListener} callback
 * @param {(!AddEventListenerOptions|!boolean)=} options
 * @return {undefined}
 */
EventTarget.prototype.addEventListener = function(type,callback,options) {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function GPUColorWrite() {}
/** @const {!GPUFlagsConstant} */ GPUColorWrite.ALL;
/** @const {!GPUFlagsConstant} */ GPUColorWrite.prototype.ALL;
/** @const {!GPUFlagsConstant} */ GPUColorWrite.ALPHA;
/** @const {!GPUFlagsConstant} */ GPUColorWrite.prototype.ALPHA;
/** @const {!GPUFlagsConstant} */ GPUColorWrite.BLUE;
/** @const {!GPUFlagsConstant} */ GPUColorWrite.prototype.BLUE;
/** @const {!GPUFlagsConstant} */ GPUColorWrite.GREEN;
/** @const {!GPUFlagsConstant} */ GPUColorWrite.prototype.GREEN;
/** @const {!GPUFlagsConstant} */ GPUColorWrite.RED;
/** @const {!GPUFlagsConstant} */ GPUColorWrite.prototype.RED;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function WebGL2RenderingContext() {}
/** @const {!GLenum} */ WebGL2RenderingContext.ACTIVE_ATTRIBUTES;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.ACTIVE_ATTRIBUTES;
/** @const {!GLenum} */ WebGL2RenderingContext.ACTIVE_TEXTURE;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.ACTIVE_TEXTURE;
/** @const {!GLenum} */ WebGL2RenderingContext.ACTIVE_UNIFORMS;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.ACTIVE_UNIFORMS;
/** @const {!GLenum} */ WebGL2RenderingContext.ALIASED_LINE_WIDTH_RANGE;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.ALIASED_LINE_WIDTH_RANGE;
/** @const {!GLenum} */ WebGL2RenderingContext.ALIASED_POINT_SIZE_RANGE;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.ALIASED_POINT_SIZE_RANGE;
/** @const {!GLenum} */ WebGL2RenderingContext.ALPHA;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.ALPHA;
/** @const {!GLenum} */ WebGL2RenderingContext.ALPHA_BITS;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.ALPHA_BITS;
/** @const {!GLenum} */ WebGL2RenderingContext.ALWAYS;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.ALWAYS;
/** @const {!GLenum} */ WebGL2RenderingContext.ARRAY_BUFFER;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.ARRAY_BUFFER;
/** @const {!GLenum} */ WebGL2RenderingContext.ARRAY_BUFFER_BINDING;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.ARRAY_BUFFER_BINDING;
/** @const {!GLenum} */ WebGL2RenderingContext.ATTACHED_SHADERS;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.ATTACHED_SHADERS;
/** @const {!GLenum} */ WebGL2RenderingContext.BACK;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.BACK;
/** @const {!GLenum} */ WebGL2RenderingContext.BLEND;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.BLEND;
/** @const {!GLenum} */ WebGL2RenderingContext.BLEND_COLOR;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.BLEND_COLOR;
/** @const {!GLenum} */ WebGL2RenderingContext.BLEND_DST_ALPHA;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.BLEND_DST_ALPHA;
/** @const {!GLenum} */ WebGL2RenderingContext.BLEND_DST_RGB;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.BLEND_DST_RGB;
/** @const {!GLenum} */ WebGL2RenderingContext.BLEND_EQUATION;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.BLEND_EQUATION;
/** @const {!GLenum} */ WebGL2RenderingContext.BLEND_EQUATION_ALPHA;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.BLEND_EQUATION_ALPHA;
/** @const {!GLenum} */ WebGL2RenderingContext.BLEND_EQUATION_RGB;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.BLEND_EQUATION_RGB;
/** @const {!GLenum} */ WebGL2RenderingContext.BLEND_SRC_ALPHA;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.BLEND_SRC_ALPHA;
/** @const {!GLenum} */ WebGL2RenderingContext.BLEND_SRC_RGB;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.BLEND_SRC_RGB;
/** @const {!GLenum} */ WebGL2RenderingContext.BLUE_BITS;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.BLUE_BITS;
/** @const {!GLenum} */ WebGL2RenderingContext.BOOL;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.BOOL;
/** @const {!GLenum} */ WebGL2RenderingContext.BOOL_VEC2;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.BOOL_VEC2;
/** @const {!GLenum} */ WebGL2RenderingContext.BOOL_VEC3;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.BOOL_VEC3;
/** @const {!GLenum} */ WebGL2RenderingContext.BOOL_VEC4;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.BOOL_VEC4;
/** @const {!GLenum} */ WebGL2RenderingContext.BROWSER_DEFAULT_WEBGL;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.BROWSER_DEFAULT_WEBGL;
/** @const {!GLenum} */ WebGL2RenderingContext.BUFFER_SIZE;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.BUFFER_SIZE;
/** @const {!GLenum} */ WebGL2RenderingContext.BUFFER_USAGE;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.BUFFER_USAGE;
/** @const {!GLenum} */ WebGL2RenderingContext.BYTE;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.BYTE;
/** @const {!GLenum} */ WebGL2RenderingContext.CCW;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.CCW;
/** @const {!GLenum} */ WebGL2RenderingContext.CLAMP_TO_EDGE;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.CLAMP_TO_EDGE;
/** @const {!GLenum} */ WebGL2RenderingContext.COLOR_ATTACHMENT0;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.COLOR_ATTACHMENT0;
/** @const {!GLenum} */ WebGL2RenderingContext.COLOR_BUFFER_BIT;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.COLOR_BUFFER_BIT;
/** @const {!GLenum} */ WebGL2RenderingContext.COLOR_CLEAR_VALUE;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.COLOR_CLEAR_VALUE;
/** @const {!GLenum} */ WebGL2RenderingContext.COLOR_WRITEMASK;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.COLOR_WRITEMASK;
/** @const {!GLenum} */ WebGL2RenderingContext.COMPILE_STATUS;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.COMPILE_STATUS;
/** @const {!GLenum} */ WebGL2RenderingContext.COMPRESSED_TEXTURE_FORMATS;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.COMPRESSED_TEXTURE_FORMATS;
/** @const {!GLenum} */ WebGL2RenderingContext.CONSTANT_ALPHA;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.CONSTANT_ALPHA;
/** @const {!GLenum} */ WebGL2RenderingContext.CONSTANT_COLOR;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.CONSTANT_COLOR;
/** @const {!GLenum} */ WebGL2RenderingContext.CONTEXT_LOST_WEBGL;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.CONTEXT_LOST_WEBGL;
/** @const {!GLenum} */ WebGL2RenderingContext.CULL_FACE;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.CULL_FACE;
/** @const {!GLenum} */ WebGL2RenderingContext.CULL_FACE_MODE;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.CULL_FACE_MODE;
/** @const {!GLenum} */ WebGL2RenderingContext.CURRENT_PROGRAM;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.CURRENT_PROGRAM;
/** @const {!GLenum} */ WebGL2RenderingContext.CURRENT_VERTEX_ATTRIB;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.CURRENT_VERTEX_ATTRIB;
/** @const {!GLenum} */ WebGL2RenderingContext.CW;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.CW;
/** @const {!GLenum} */ WebGL2RenderingContext.DECR;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.DECR;
/** @const {!GLenum} */ WebGL2RenderingContext.DECR_WRAP;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.DECR_WRAP;
/** @const {!GLenum} */ WebGL2RenderingContext.DELETE_STATUS;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.DELETE_STATUS;
/** @const {!GLenum} */ WebGL2RenderingContext.DEPTH_ATTACHMENT;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.DEPTH_ATTACHMENT;
/** @const {!GLenum} */ WebGL2RenderingContext.DEPTH_BITS;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.DEPTH_BITS;
/** @const {!GLenum} */ WebGL2RenderingContext.DEPTH_BUFFER_BIT;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.DEPTH_BUFFER_BIT;
/** @const {!GLenum} */ WebGL2RenderingContext.DEPTH_CLEAR_VALUE;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.DEPTH_CLEAR_VALUE;
/** @const {!GLenum} */ WebGL2RenderingContext.DEPTH_COMPONENT;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.DEPTH_COMPONENT;
/** @const {!GLenum} */ WebGL2RenderingContext.DEPTH_COMPONENT16;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.DEPTH_COMPONENT16;
/** @const {!GLenum} */ WebGL2RenderingContext.DEPTH_FUNC;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.DEPTH_FUNC;
/** @const {!GLenum} */ WebGL2RenderingContext.DEPTH_RANGE;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.DEPTH_RANGE;
/** @const {!GLenum} */ WebGL2RenderingContext.DEPTH_STENCIL;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.DEPTH_STENCIL;
/** @const {!GLenum} */ WebGL2RenderingContext.DEPTH_STENCIL_ATTACHMENT;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.DEPTH_STENCIL_ATTACHMENT;
/** @const {!GLenum} */ WebGL2RenderingContext.DEPTH_TEST;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.DEPTH_TEST;
/** @const {!GLenum} */ WebGL2RenderingContext.DEPTH_WRITEMASK;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.DEPTH_WRITEMASK;
/** @const {!GLenum} */ WebGL2RenderingContext.DITHER;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.DITHER;
/** @const {!GLenum} */ WebGL2RenderingContext.DONT_CARE;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.DONT_CARE;
/** @const {!GLenum} */ WebGL2RenderingContext.DST_ALPHA;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.DST_ALPHA;
/** @const {!GLenum} */ WebGL2RenderingContext.DST_COLOR;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.DST_COLOR;
/** @const {!GLenum} */ WebGL2RenderingContext.DYNAMIC_DRAW;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.DYNAMIC_DRAW;
/** @const {!GLenum} */ WebGL2RenderingContext.ELEMENT_ARRAY_BUFFER;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.ELEMENT_ARRAY_BUFFER;
/** @const {!GLenum} */ WebGL2RenderingContext.ELEMENT_ARRAY_BUFFER_BINDING;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.ELEMENT_ARRAY_BUFFER_BINDING;
/** @const {!GLenum} */ WebGL2RenderingContext.EQUAL;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.EQUAL;
/** @const {!GLenum} */ WebGL2RenderingContext.FASTEST;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.FASTEST;
/** @const {!GLenum} */ WebGL2RenderingContext.FLOAT;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.FLOAT;
/** @const {!GLenum} */ WebGL2RenderingContext.FLOAT_MAT2;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.FLOAT_MAT2;
/** @const {!GLenum} */ WebGL2RenderingContext.FLOAT_MAT3;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.FLOAT_MAT3;
/** @const {!GLenum} */ WebGL2RenderingContext.FLOAT_MAT4;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.FLOAT_MAT4;
/** @const {!GLenum} */ WebGL2RenderingContext.FLOAT_VEC2;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.FLOAT_VEC2;
/** @const {!GLenum} */ WebGL2RenderingContext.FLOAT_VEC3;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.FLOAT_VEC3;
/** @const {!GLenum} */ WebGL2RenderingContext.FLOAT_VEC4;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.FLOAT_VEC4;
/** @const {!GLenum} */ WebGL2RenderingContext.FRAGMENT_SHADER;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.FRAGMENT_SHADER;
/** @const {!GLenum} */ WebGL2RenderingContext.FRAMEBUFFER;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.FRAMEBUFFER;
/** @const {!GLenum} */ WebGL2RenderingContext.FRAMEBUFFER_ATTACHMENT_OBJECT_NAME;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.FRAMEBUFFER_ATTACHMENT_OBJECT_NAME;
/** @const {!GLenum} */ WebGL2RenderingContext.FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE;
/** @const {!GLenum} */ WebGL2RenderingContext.FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE;
/** @const {!GLenum} */ WebGL2RenderingContext.FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL;
/** @const {!GLenum} */ WebGL2RenderingContext.FRAMEBUFFER_BINDING;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.FRAMEBUFFER_BINDING;
/** @const {!GLenum} */ WebGL2RenderingContext.FRAMEBUFFER_COMPLETE;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.FRAMEBUFFER_COMPLETE;
/** @const {!GLenum} */ WebGL2RenderingContext.FRAMEBUFFER_INCOMPLETE_ATTACHMENT;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.FRAMEBUFFER_INCOMPLETE_ATTACHMENT;
/** @const {!GLenum} */ WebGL2RenderingContext.FRAMEBUFFER_INCOMPLETE_DIMENSIONS;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.FRAMEBUFFER_INCOMPLETE_DIMENSIONS;
/** @const {!GLenum} */ WebGL2RenderingContext.FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT;
/** @const {!GLenum} */ WebGL2RenderingContext.FRAMEBUFFER_UNSUPPORTED;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.FRAMEBUFFER_UNSUPPORTED;
/** @const {!GLenum} */ WebGL2RenderingContext.FRONT;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.FRONT;
/** @const {!GLenum} */ WebGL2RenderingContext.FRONT_AND_BACK;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.FRONT_AND_BACK;
/** @const {!GLenum} */ WebGL2RenderingContext.FRONT_FACE;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.FRONT_FACE;
/** @const {!GLenum} */ WebGL2RenderingContext.FUNC_ADD;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.FUNC_ADD;
/** @const {!GLenum} */ WebGL2RenderingContext.FUNC_REVERSE_SUBTRACT;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.FUNC_REVERSE_SUBTRACT;
/** @const {!GLenum} */ WebGL2RenderingContext.FUNC_SUBTRACT;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.FUNC_SUBTRACT;
/** @const {!GLenum} */ WebGL2RenderingContext.GENERATE_MIPMAP_HINT;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.GENERATE_MIPMAP_HINT;
/** @const {!GLenum} */ WebGL2RenderingContext.GEQUAL;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.GEQUAL;
/** @const {!GLenum} */ WebGL2RenderingContext.GREATER;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.GREATER;
/** @const {!GLenum} */ WebGL2RenderingContext.GREEN_BITS;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.GREEN_BITS;
/** @const {!GLenum} */ WebGL2RenderingContext.HIGH_FLOAT;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.HIGH_FLOAT;
/** @const {!GLenum} */ WebGL2RenderingContext.HIGH_INT;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.HIGH_INT;
/** @const {!GLenum} */ WebGL2RenderingContext.IMPLEMENTATION_COLOR_READ_FORMAT;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.IMPLEMENTATION_COLOR_READ_FORMAT;
/** @const {!GLenum} */ WebGL2RenderingContext.IMPLEMENTATION_COLOR_READ_TYPE;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.IMPLEMENTATION_COLOR_READ_TYPE;
/** @const {!GLenum} */ WebGL2RenderingContext.INCR;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.INCR;
/** @const {!GLenum} */ WebGL2RenderingContext.INCR_WRAP;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.INCR_WRAP;
/** @const {!GLenum} */ WebGL2RenderingContext.INT;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.INT;
/** @const {!GLenum} */ WebGL2RenderingContext.INT_VEC2;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.INT_VEC2;
/** @const {!GLenum} */ WebGL2RenderingContext.INT_VEC3;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.INT_VEC3;
/** @const {!GLenum} */ WebGL2RenderingContext.INT_VEC4;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.INT_VEC4;
/** @const {!GLenum} */ WebGL2RenderingContext.INVALID_ENUM;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.INVALID_ENUM;
/** @const {!GLenum} */ WebGL2RenderingContext.INVALID_FRAMEBUFFER_OPERATION;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.INVALID_FRAMEBUFFER_OPERATION;
/** @const {!GLenum} */ WebGL2RenderingContext.INVALID_OPERATION;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.INVALID_OPERATION;
/** @const {!GLenum} */ WebGL2RenderingContext.INVALID_VALUE;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.INVALID_VALUE;
/** @const {!GLenum} */ WebGL2RenderingContext.INVERT;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.INVERT;
/** @const {!GLenum} */ WebGL2RenderingContext.KEEP;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.KEEP;
/** @const {!GLenum} */ WebGL2RenderingContext.LEQUAL;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.LEQUAL;
/** @const {!GLenum} */ WebGL2RenderingContext.LESS;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.LESS;
/** @const {!GLenum} */ WebGL2RenderingContext.LINEAR;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.LINEAR;
/** @const {!GLenum} */ WebGL2RenderingContext.LINEAR_MIPMAP_LINEAR;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.LINEAR_MIPMAP_LINEAR;
/** @const {!GLenum} */ WebGL2RenderingContext.LINEAR_MIPMAP_NEAREST;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.LINEAR_MIPMAP_NEAREST;
/** @const {!GLenum} */ WebGL2RenderingContext.LINES;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.LINES;
/** @const {!GLenum} */ WebGL2RenderingContext.LINE_LOOP;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.LINE_LOOP;
/** @const {!GLenum} */ WebGL2RenderingContext.LINE_STRIP;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.LINE_STRIP;
/** @const {!GLenum} */ WebGL2RenderingContext.LINE_WIDTH;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.LINE_WIDTH;
/** @const {!GLenum} */ WebGL2RenderingContext.LINK_STATUS;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.LINK_STATUS;
/** @const {!GLenum} */ WebGL2RenderingContext.LOW_FLOAT;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.LOW_FLOAT;
/** @const {!GLenum} */ WebGL2RenderingContext.LOW_INT;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.LOW_INT;
/** @const {!GLenum} */ WebGL2RenderingContext.LUMINANCE;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.LUMINANCE;
/** @const {!GLenum} */ WebGL2RenderingContext.LUMINANCE_ALPHA;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.LUMINANCE_ALPHA;
/** @const {!GLenum} */ WebGL2RenderingContext.MAX_COMBINED_TEXTURE_IMAGE_UNITS;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.MAX_COMBINED_TEXTURE_IMAGE_UNITS;
/** @const {!GLenum} */ WebGL2RenderingContext.MAX_CUBE_MAP_TEXTURE_SIZE;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.MAX_CUBE_MAP_TEXTURE_SIZE;
/** @const {!GLenum} */ WebGL2RenderingContext.MAX_FRAGMENT_UNIFORM_VECTORS;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.MAX_FRAGMENT_UNIFORM_VECTORS;
/** @const {!GLenum} */ WebGL2RenderingContext.MAX_RENDERBUFFER_SIZE;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.MAX_RENDERBUFFER_SIZE;
/** @const {!GLenum} */ WebGL2RenderingContext.MAX_TEXTURE_IMAGE_UNITS;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.MAX_TEXTURE_IMAGE_UNITS;
/** @const {!GLenum} */ WebGL2RenderingContext.MAX_TEXTURE_SIZE;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.MAX_TEXTURE_SIZE;
/** @const {!GLenum} */ WebGL2RenderingContext.MAX_VARYING_VECTORS;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.MAX_VARYING_VECTORS;
/** @const {!GLenum} */ WebGL2RenderingContext.MAX_VERTEX_ATTRIBS;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.MAX_VERTEX_ATTRIBS;
/** @const {!GLenum} */ WebGL2RenderingContext.MAX_VERTEX_TEXTURE_IMAGE_UNITS;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.MAX_VERTEX_TEXTURE_IMAGE_UNITS;
/** @const {!GLenum} */ WebGL2RenderingContext.MAX_VERTEX_UNIFORM_VECTORS;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.MAX_VERTEX_UNIFORM_VECTORS;
/** @const {!GLenum} */ WebGL2RenderingContext.MAX_VIEWPORT_DIMS;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.MAX_VIEWPORT_DIMS;
/** @const {!GLenum} */ WebGL2RenderingContext.MEDIUM_FLOAT;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.MEDIUM_FLOAT;
/** @const {!GLenum} */ WebGL2RenderingContext.MEDIUM_INT;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.MEDIUM_INT;
/** @const {!GLenum} */ WebGL2RenderingContext.MIRRORED_REPEAT;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.MIRRORED_REPEAT;
/** @const {!GLenum} */ WebGL2RenderingContext.NEAREST;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.NEAREST;
/** @const {!GLenum} */ WebGL2RenderingContext.NEAREST_MIPMAP_LINEAR;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.NEAREST_MIPMAP_LINEAR;
/** @const {!GLenum} */ WebGL2RenderingContext.NEAREST_MIPMAP_NEAREST;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.NEAREST_MIPMAP_NEAREST;
/** @const {!GLenum} */ WebGL2RenderingContext.NEVER;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.NEVER;
/** @const {!GLenum} */ WebGL2RenderingContext.NICEST;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.NICEST;
/** @const {!GLenum} */ WebGL2RenderingContext.NONE;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.NONE;
/** @const {!GLenum} */ WebGL2RenderingContext.NOTEQUAL;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.NOTEQUAL;
/** @const {!GLenum} */ WebGL2RenderingContext.NO_ERROR;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.NO_ERROR;
/** @const {!GLenum} */ WebGL2RenderingContext.ONE;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.ONE;
/** @const {!GLenum} */ WebGL2RenderingContext.ONE_MINUS_CONSTANT_ALPHA;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.ONE_MINUS_CONSTANT_ALPHA;
/** @const {!GLenum} */ WebGL2RenderingContext.ONE_MINUS_CONSTANT_COLOR;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.ONE_MINUS_CONSTANT_COLOR;
/** @const {!GLenum} */ WebGL2RenderingContext.ONE_MINUS_DST_ALPHA;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.ONE_MINUS_DST_ALPHA;
/** @const {!GLenum} */ WebGL2RenderingContext.ONE_MINUS_DST_COLOR;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.ONE_MINUS_DST_COLOR;
/** @const {!GLenum} */ WebGL2RenderingContext.ONE_MINUS_SRC_ALPHA;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.ONE_MINUS_SRC_ALPHA;
/** @const {!GLenum} */ WebGL2RenderingContext.ONE_MINUS_SRC_COLOR;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.ONE_MINUS_SRC_COLOR;
/** @const {!GLenum} */ WebGL2RenderingContext.OUT_OF_MEMORY;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.OUT_OF_MEMORY;
/** @const {!GLenum} */ WebGL2RenderingContext.PACK_ALIGNMENT;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.PACK_ALIGNMENT;
/** @const {!GLenum} */ WebGL2RenderingContext.POINTS;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.POINTS;
/** @const {!GLenum} */ WebGL2RenderingContext.POLYGON_OFFSET_FACTOR;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.POLYGON_OFFSET_FACTOR;
/** @const {!GLenum} */ WebGL2RenderingContext.POLYGON_OFFSET_FILL;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.POLYGON_OFFSET_FILL;
/** @const {!GLenum} */ WebGL2RenderingContext.POLYGON_OFFSET_UNITS;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.POLYGON_OFFSET_UNITS;
/** @const {!GLenum} */ WebGL2RenderingContext.RED_BITS;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.RED_BITS;
/** @const {!GLenum} */ WebGL2RenderingContext.RENDERBUFFER;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.RENDERBUFFER;
/** @const {!GLenum} */ WebGL2RenderingContext.RENDERBUFFER_ALPHA_SIZE;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.RENDERBUFFER_ALPHA_SIZE;
/** @const {!GLenum} */ WebGL2RenderingContext.RENDERBUFFER_BINDING;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.RENDERBUFFER_BINDING;
/** @const {!GLenum} */ WebGL2RenderingContext.RENDERBUFFER_BLUE_SIZE;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.RENDERBUFFER_BLUE_SIZE;
/** @const {!GLenum} */ WebGL2RenderingContext.RENDERBUFFER_DEPTH_SIZE;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.RENDERBUFFER_DEPTH_SIZE;
/** @const {!GLenum} */ WebGL2RenderingContext.RENDERBUFFER_GREEN_SIZE;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.RENDERBUFFER_GREEN_SIZE;
/** @const {!GLenum} */ WebGL2RenderingContext.RENDERBUFFER_HEIGHT;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.RENDERBUFFER_HEIGHT;
/** @const {!GLenum} */ WebGL2RenderingContext.RENDERBUFFER_INTERNAL_FORMAT;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.RENDERBUFFER_INTERNAL_FORMAT;
/** @const {!GLenum} */ WebGL2RenderingContext.RENDERBUFFER_RED_SIZE;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.RENDERBUFFER_RED_SIZE;
/** @const {!GLenum} */ WebGL2RenderingContext.RENDERBUFFER_STENCIL_SIZE;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.RENDERBUFFER_STENCIL_SIZE;
/** @const {!GLenum} */ WebGL2RenderingContext.RENDERBUFFER_WIDTH;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.RENDERBUFFER_WIDTH;
/** @const {!GLenum} */ WebGL2RenderingContext.RENDERER;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.RENDERER;
/** @const {!GLenum} */ WebGL2RenderingContext.REPEAT;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.REPEAT;
/** @const {!GLenum} */ WebGL2RenderingContext.REPLACE;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.REPLACE;
/** @const {!GLenum} */ WebGL2RenderingContext.RGB;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.RGB;
/** @const {!GLenum} */ WebGL2RenderingContext.RGB565;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.RGB565;
/** @const {!GLenum} */ WebGL2RenderingContext.RGB5_A1;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.RGB5_A1;
/** @const {!GLenum} */ WebGL2RenderingContext.RGBA;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.RGBA;
/** @const {!GLenum} */ WebGL2RenderingContext.RGBA4;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.RGBA4;
/** @const {!GLenum} */ WebGL2RenderingContext.SAMPLER_2D;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.SAMPLER_2D;
/** @const {!GLenum} */ WebGL2RenderingContext.SAMPLER_CUBE;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.SAMPLER_CUBE;
/** @const {!GLenum} */ WebGL2RenderingContext.SAMPLES;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.SAMPLES;
/** @const {!GLenum} */ WebGL2RenderingContext.SAMPLE_ALPHA_TO_COVERAGE;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.SAMPLE_ALPHA_TO_COVERAGE;
/** @const {!GLenum} */ WebGL2RenderingContext.SAMPLE_BUFFERS;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.SAMPLE_BUFFERS;
/** @const {!GLenum} */ WebGL2RenderingContext.SAMPLE_COVERAGE;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.SAMPLE_COVERAGE;
/** @const {!GLenum} */ WebGL2RenderingContext.SAMPLE_COVERAGE_INVERT;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.SAMPLE_COVERAGE_INVERT;
/** @const {!GLenum} */ WebGL2RenderingContext.SAMPLE_COVERAGE_VALUE;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.SAMPLE_COVERAGE_VALUE;
/** @const {!GLenum} */ WebGL2RenderingContext.SCISSOR_BOX;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.SCISSOR_BOX;
/** @const {!GLenum} */ WebGL2RenderingContext.SCISSOR_TEST;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.SCISSOR_TEST;
/** @const {!GLenum} */ WebGL2RenderingContext.SHADER_TYPE;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.SHADER_TYPE;
/** @const {!GLenum} */ WebGL2RenderingContext.SHADING_LANGUAGE_VERSION;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.SHADING_LANGUAGE_VERSION;
/** @const {!GLenum} */ WebGL2RenderingContext.SHORT;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.SHORT;
/** @const {!GLenum} */ WebGL2RenderingContext.SRC_ALPHA;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.SRC_ALPHA;
/** @const {!GLenum} */ WebGL2RenderingContext.SRC_ALPHA_SATURATE;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.SRC_ALPHA_SATURATE;
/** @const {!GLenum} */ WebGL2RenderingContext.SRC_COLOR;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.SRC_COLOR;
/** @const {!GLenum} */ WebGL2RenderingContext.STATIC_DRAW;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.STATIC_DRAW;
/** @const {!GLenum} */ WebGL2RenderingContext.STENCIL_ATTACHMENT;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.STENCIL_ATTACHMENT;
/** @const {!GLenum} */ WebGL2RenderingContext.STENCIL_BACK_FAIL;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.STENCIL_BACK_FAIL;
/** @const {!GLenum} */ WebGL2RenderingContext.STENCIL_BACK_FUNC;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.STENCIL_BACK_FUNC;
/** @const {!GLenum} */ WebGL2RenderingContext.STENCIL_BACK_PASS_DEPTH_FAIL;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.STENCIL_BACK_PASS_DEPTH_FAIL;
/** @const {!GLenum} */ WebGL2RenderingContext.STENCIL_BACK_PASS_DEPTH_PASS;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.STENCIL_BACK_PASS_DEPTH_PASS;
/** @const {!GLenum} */ WebGL2RenderingContext.STENCIL_BACK_REF;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.STENCIL_BACK_REF;
/** @const {!GLenum} */ WebGL2RenderingContext.STENCIL_BACK_VALUE_MASK;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.STENCIL_BACK_VALUE_MASK;
/** @const {!GLenum} */ WebGL2RenderingContext.STENCIL_BACK_WRITEMASK;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.STENCIL_BACK_WRITEMASK;
/** @const {!GLenum} */ WebGL2RenderingContext.STENCIL_BITS;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.STENCIL_BITS;
/** @const {!GLenum} */ WebGL2RenderingContext.STENCIL_BUFFER_BIT;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.STENCIL_BUFFER_BIT;
/** @const {!GLenum} */ WebGL2RenderingContext.STENCIL_CLEAR_VALUE;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.STENCIL_CLEAR_VALUE;
/** @const {!GLenum} */ WebGL2RenderingContext.STENCIL_FAIL;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.STENCIL_FAIL;
/** @const {!GLenum} */ WebGL2RenderingContext.STENCIL_FUNC;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.STENCIL_FUNC;
/** @const {!GLenum} */ WebGL2RenderingContext.STENCIL_INDEX8;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.STENCIL_INDEX8;
/** @const {!GLenum} */ WebGL2RenderingContext.STENCIL_PASS_DEPTH_FAIL;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.STENCIL_PASS_DEPTH_FAIL;
/** @const {!GLenum} */ WebGL2RenderingContext.STENCIL_PASS_DEPTH_PASS;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.STENCIL_PASS_DEPTH_PASS;
/** @const {!GLenum} */ WebGL2RenderingContext.STENCIL_REF;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.STENCIL_REF;
/** @const {!GLenum} */ WebGL2RenderingContext.STENCIL_TEST;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.STENCIL_TEST;
/** @const {!GLenum} */ WebGL2RenderingContext.STENCIL_VALUE_MASK;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.STENCIL_VALUE_MASK;
/** @const {!GLenum} */ WebGL2RenderingContext.STENCIL_WRITEMASK;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.STENCIL_WRITEMASK;
/** @const {!GLenum} */ WebGL2RenderingContext.STREAM_DRAW;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.STREAM_DRAW;
/** @const {!GLenum} */ WebGL2RenderingContext.SUBPIXEL_BITS;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.SUBPIXEL_BITS;
/** @const {!GLenum} */ WebGL2RenderingContext.TEXTURE;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.TEXTURE;
/** @const {!GLenum} */ WebGL2RenderingContext.TEXTURE0;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.TEXTURE0;
/** @const {!GLenum} */ WebGL2RenderingContext.TEXTURE1;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.TEXTURE1;
/** @const {!GLenum} */ WebGL2RenderingContext.TEXTURE10;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.TEXTURE10;
/** @const {!GLenum} */ WebGL2RenderingContext.TEXTURE11;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.TEXTURE11;
/** @const {!GLenum} */ WebGL2RenderingContext.TEXTURE12;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.TEXTURE12;
/** @const {!GLenum} */ WebGL2RenderingContext.TEXTURE13;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.TEXTURE13;
/** @const {!GLenum} */ WebGL2RenderingContext.TEXTURE14;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.TEXTURE14;
/** @const {!GLenum} */ WebGL2RenderingContext.TEXTURE15;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.TEXTURE15;
/** @const {!GLenum} */ WebGL2RenderingContext.TEXTURE16;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.TEXTURE16;
/** @const {!GLenum} */ WebGL2RenderingContext.TEXTURE17;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.TEXTURE17;
/** @const {!GLenum} */ WebGL2RenderingContext.TEXTURE18;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.TEXTURE18;
/** @const {!GLenum} */ WebGL2RenderingContext.TEXTURE19;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.TEXTURE19;
/** @const {!GLenum} */ WebGL2RenderingContext.TEXTURE2;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.TEXTURE2;
/** @const {!GLenum} */ WebGL2RenderingContext.TEXTURE20;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.TEXTURE20;
/** @const {!GLenum} */ WebGL2RenderingContext.TEXTURE21;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.TEXTURE21;
/** @const {!GLenum} */ WebGL2RenderingContext.TEXTURE22;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.TEXTURE22;
/** @const {!GLenum} */ WebGL2RenderingContext.TEXTURE23;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.TEXTURE23;
/** @const {!GLenum} */ WebGL2RenderingContext.TEXTURE24;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.TEXTURE24;
/** @const {!GLenum} */ WebGL2RenderingContext.TEXTURE25;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.TEXTURE25;
/** @const {!GLenum} */ WebGL2RenderingContext.TEXTURE26;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.TEXTURE26;
/** @const {!GLenum} */ WebGL2RenderingContext.TEXTURE27;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.TEXTURE27;
/** @const {!GLenum} */ WebGL2RenderingContext.TEXTURE28;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.TEXTURE28;
/** @const {!GLenum} */ WebGL2RenderingContext.TEXTURE29;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.TEXTURE29;
/** @const {!GLenum} */ WebGL2RenderingContext.TEXTURE3;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.TEXTURE3;
/** @const {!GLenum} */ WebGL2RenderingContext.TEXTURE30;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.TEXTURE30;
/** @const {!GLenum} */ WebGL2RenderingContext.TEXTURE31;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.TEXTURE31;
/** @const {!GLenum} */ WebGL2RenderingContext.TEXTURE4;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.TEXTURE4;
/** @const {!GLenum} */ WebGL2RenderingContext.TEXTURE5;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.TEXTURE5;
/** @const {!GLenum} */ WebGL2RenderingContext.TEXTURE6;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.TEXTURE6;
/** @const {!GLenum} */ WebGL2RenderingContext.TEXTURE7;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.TEXTURE7;
/** @const {!GLenum} */ WebGL2RenderingContext.TEXTURE8;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.TEXTURE8;
/** @const {!GLenum} */ WebGL2RenderingContext.TEXTURE9;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.TEXTURE9;
/** @const {!GLenum} */ WebGL2RenderingContext.TEXTURE_2D;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.TEXTURE_2D;
/** @const {!GLenum} */ WebGL2RenderingContext.TEXTURE_BINDING_2D;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.TEXTURE_BINDING_2D;
/** @const {!GLenum} */ WebGL2RenderingContext.TEXTURE_BINDING_CUBE_MAP;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.TEXTURE_BINDING_CUBE_MAP;
/** @const {!GLenum} */ WebGL2RenderingContext.TEXTURE_CUBE_MAP;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.TEXTURE_CUBE_MAP;
/** @const {!GLenum} */ WebGL2RenderingContext.TEXTURE_CUBE_MAP_NEGATIVE_X;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.TEXTURE_CUBE_MAP_NEGATIVE_X;
/** @const {!GLenum} */ WebGL2RenderingContext.TEXTURE_CUBE_MAP_NEGATIVE_Y;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.TEXTURE_CUBE_MAP_NEGATIVE_Y;
/** @const {!GLenum} */ WebGL2RenderingContext.TEXTURE_CUBE_MAP_NEGATIVE_Z;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.TEXTURE_CUBE_MAP_NEGATIVE_Z;
/** @const {!GLenum} */ WebGL2RenderingContext.TEXTURE_CUBE_MAP_POSITIVE_X;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.TEXTURE_CUBE_MAP_POSITIVE_X;
/** @const {!GLenum} */ WebGL2RenderingContext.TEXTURE_CUBE_MAP_POSITIVE_Y;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.TEXTURE_CUBE_MAP_POSITIVE_Y;
/** @const {!GLenum} */ WebGL2RenderingContext.TEXTURE_CUBE_MAP_POSITIVE_Z;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.TEXTURE_CUBE_MAP_POSITIVE_Z;
/** @const {!GLenum} */ WebGL2RenderingContext.TEXTURE_MAG_FILTER;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.TEXTURE_MAG_FILTER;
/** @const {!GLenum} */ WebGL2RenderingContext.TEXTURE_MIN_FILTER;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.TEXTURE_MIN_FILTER;
/** @const {!GLenum} */ WebGL2RenderingContext.TEXTURE_WRAP_S;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.TEXTURE_WRAP_S;
/** @const {!GLenum} */ WebGL2RenderingContext.TEXTURE_WRAP_T;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.TEXTURE_WRAP_T;
/** @const {!GLenum} */ WebGL2RenderingContext.TRIANGLES;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.TRIANGLES;
/** @const {!GLenum} */ WebGL2RenderingContext.TRIANGLE_FAN;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.TRIANGLE_FAN;
/** @const {!GLenum} */ WebGL2RenderingContext.TRIANGLE_STRIP;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.TRIANGLE_STRIP;
/** @const {!GLenum} */ WebGL2RenderingContext.UNPACK_ALIGNMENT;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.UNPACK_ALIGNMENT;
/** @const {!GLenum} */ WebGL2RenderingContext.UNPACK_COLORSPACE_CONVERSION_WEBGL;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.UNPACK_COLORSPACE_CONVERSION_WEBGL;
/** @const {!GLenum} */ WebGL2RenderingContext.UNPACK_FLIP_Y_WEBGL;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.UNPACK_FLIP_Y_WEBGL;
/** @const {!GLenum} */ WebGL2RenderingContext.UNPACK_PREMULTIPLY_ALPHA_WEBGL;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.UNPACK_PREMULTIPLY_ALPHA_WEBGL;
/** @const {!GLenum} */ WebGL2RenderingContext.UNSIGNED_BYTE;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.UNSIGNED_BYTE;
/** @const {!GLenum} */ WebGL2RenderingContext.UNSIGNED_INT;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.UNSIGNED_INT;
/** @const {!GLenum} */ WebGL2RenderingContext.UNSIGNED_SHORT;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.UNSIGNED_SHORT;
/** @const {!GLenum} */ WebGL2RenderingContext.UNSIGNED_SHORT_4_4_4_4;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.UNSIGNED_SHORT_4_4_4_4;
/** @const {!GLenum} */ WebGL2RenderingContext.UNSIGNED_SHORT_5_5_5_1;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.UNSIGNED_SHORT_5_5_5_1;
/** @const {!GLenum} */ WebGL2RenderingContext.UNSIGNED_SHORT_5_6_5;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.UNSIGNED_SHORT_5_6_5;
/** @const {!GLenum} */ WebGL2RenderingContext.VALIDATE_STATUS;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.VALIDATE_STATUS;
/** @const {!GLenum} */ WebGL2RenderingContext.VENDOR;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.VENDOR;
/** @const {!GLenum} */ WebGL2RenderingContext.VERSION;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.VERSION;
/** @const {!GLenum} */ WebGL2RenderingContext.VERTEX_ATTRIB_ARRAY_BUFFER_BINDING;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.VERTEX_ATTRIB_ARRAY_BUFFER_BINDING;
/** @const {!GLenum} */ WebGL2RenderingContext.VERTEX_ATTRIB_ARRAY_ENABLED;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.VERTEX_ATTRIB_ARRAY_ENABLED;
/** @const {!GLenum} */ WebGL2RenderingContext.VERTEX_ATTRIB_ARRAY_NORMALIZED;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.VERTEX_ATTRIB_ARRAY_NORMALIZED;
/** @const {!GLenum} */ WebGL2RenderingContext.VERTEX_ATTRIB_ARRAY_POINTER;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.VERTEX_ATTRIB_ARRAY_POINTER;
/** @const {!GLenum} */ WebGL2RenderingContext.VERTEX_ATTRIB_ARRAY_SIZE;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.VERTEX_ATTRIB_ARRAY_SIZE;
/** @const {!GLenum} */ WebGL2RenderingContext.VERTEX_ATTRIB_ARRAY_STRIDE;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.VERTEX_ATTRIB_ARRAY_STRIDE;
/** @const {!GLenum} */ WebGL2RenderingContext.VERTEX_ATTRIB_ARRAY_TYPE;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.VERTEX_ATTRIB_ARRAY_TYPE;
/** @const {!GLenum} */ WebGL2RenderingContext.VERTEX_SHADER;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.VERTEX_SHADER;
/** @const {!GLenum} */ WebGL2RenderingContext.VIEWPORT;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.VIEWPORT;
/** @const {!GLenum} */ WebGL2RenderingContext.ZERO;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.ZERO;
/** @const {!GLenum} */ WebGL2RenderingContext.ACTIVE_UNIFORM_BLOCKS;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.ACTIVE_UNIFORM_BLOCKS;
/** @const {!GLenum} */ WebGL2RenderingContext.ALREADY_SIGNALED;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.ALREADY_SIGNALED;
/** @const {!GLenum} */ WebGL2RenderingContext.ANY_SAMPLES_PASSED;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.ANY_SAMPLES_PASSED;
/** @const {!GLenum} */ WebGL2RenderingContext.ANY_SAMPLES_PASSED_CONSERVATIVE;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.ANY_SAMPLES_PASSED_CONSERVATIVE;
/** @const {!GLenum} */ WebGL2RenderingContext.COLOR;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.COLOR;
/** @const {!GLenum} */ WebGL2RenderingContext.COLOR_ATTACHMENT1;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.COLOR_ATTACHMENT1;
/** @const {!GLenum} */ WebGL2RenderingContext.COLOR_ATTACHMENT10;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.COLOR_ATTACHMENT10;
/** @const {!GLenum} */ WebGL2RenderingContext.COLOR_ATTACHMENT11;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.COLOR_ATTACHMENT11;
/** @const {!GLenum} */ WebGL2RenderingContext.COLOR_ATTACHMENT12;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.COLOR_ATTACHMENT12;
/** @const {!GLenum} */ WebGL2RenderingContext.COLOR_ATTACHMENT13;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.COLOR_ATTACHMENT13;
/** @const {!GLenum} */ WebGL2RenderingContext.COLOR_ATTACHMENT14;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.COLOR_ATTACHMENT14;
/** @const {!GLenum} */ WebGL2RenderingContext.COLOR_ATTACHMENT15;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.COLOR_ATTACHMENT15;
/** @const {!GLenum} */ WebGL2RenderingContext.COLOR_ATTACHMENT2;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.COLOR_ATTACHMENT2;
/** @const {!GLenum} */ WebGL2RenderingContext.COLOR_ATTACHMENT3;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.COLOR_ATTACHMENT3;
/** @const {!GLenum} */ WebGL2RenderingContext.COLOR_ATTACHMENT4;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.COLOR_ATTACHMENT4;
/** @const {!GLenum} */ WebGL2RenderingContext.COLOR_ATTACHMENT5;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.COLOR_ATTACHMENT5;
/** @const {!GLenum} */ WebGL2RenderingContext.COLOR_ATTACHMENT6;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.COLOR_ATTACHMENT6;
/** @const {!GLenum} */ WebGL2RenderingContext.COLOR_ATTACHMENT7;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.COLOR_ATTACHMENT7;
/** @const {!GLenum} */ WebGL2RenderingContext.COLOR_ATTACHMENT8;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.COLOR_ATTACHMENT8;
/** @const {!GLenum} */ WebGL2RenderingContext.COLOR_ATTACHMENT9;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.COLOR_ATTACHMENT9;
/** @const {!GLenum} */ WebGL2RenderingContext.COMPARE_REF_TO_TEXTURE;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.COMPARE_REF_TO_TEXTURE;
/** @const {!GLenum} */ WebGL2RenderingContext.CONDITION_SATISFIED;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.CONDITION_SATISFIED;
/** @const {!GLenum} */ WebGL2RenderingContext.COPY_READ_BUFFER;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.COPY_READ_BUFFER;
/** @const {!GLenum} */ WebGL2RenderingContext.COPY_READ_BUFFER_BINDING;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.COPY_READ_BUFFER_BINDING;
/** @const {!GLenum} */ WebGL2RenderingContext.COPY_WRITE_BUFFER;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.COPY_WRITE_BUFFER;
/** @const {!GLenum} */ WebGL2RenderingContext.COPY_WRITE_BUFFER_BINDING;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.COPY_WRITE_BUFFER_BINDING;
/** @const {!GLenum} */ WebGL2RenderingContext.CURRENT_QUERY;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.CURRENT_QUERY;
/** @const {!GLenum} */ WebGL2RenderingContext.DEPTH;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.DEPTH;
/** @const {!GLenum} */ WebGL2RenderingContext.DEPTH24_STENCIL8;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.DEPTH24_STENCIL8;
/** @const {!GLenum} */ WebGL2RenderingContext.DEPTH32F_STENCIL8;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.DEPTH32F_STENCIL8;
/** @const {!GLenum} */ WebGL2RenderingContext.DEPTH_COMPONENT24;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.DEPTH_COMPONENT24;
/** @const {!GLenum} */ WebGL2RenderingContext.DEPTH_COMPONENT32F;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.DEPTH_COMPONENT32F;
/** @const {!GLenum} */ WebGL2RenderingContext.DRAW_BUFFER0;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.DRAW_BUFFER0;
/** @const {!GLenum} */ WebGL2RenderingContext.DRAW_BUFFER1;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.DRAW_BUFFER1;
/** @const {!GLenum} */ WebGL2RenderingContext.DRAW_BUFFER10;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.DRAW_BUFFER10;
/** @const {!GLenum} */ WebGL2RenderingContext.DRAW_BUFFER11;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.DRAW_BUFFER11;
/** @const {!GLenum} */ WebGL2RenderingContext.DRAW_BUFFER12;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.DRAW_BUFFER12;
/** @const {!GLenum} */ WebGL2RenderingContext.DRAW_BUFFER13;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.DRAW_BUFFER13;
/** @const {!GLenum} */ WebGL2RenderingContext.DRAW_BUFFER14;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.DRAW_BUFFER14;
/** @const {!GLenum} */ WebGL2RenderingContext.DRAW_BUFFER15;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.DRAW_BUFFER15;
/** @const {!GLenum} */ WebGL2RenderingContext.DRAW_BUFFER2;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.DRAW_BUFFER2;
/** @const {!GLenum} */ WebGL2RenderingContext.DRAW_BUFFER3;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.DRAW_BUFFER3;
/** @const {!GLenum} */ WebGL2RenderingContext.DRAW_BUFFER4;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.DRAW_BUFFER4;
/** @const {!GLenum} */ WebGL2RenderingContext.DRAW_BUFFER5;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.DRAW_BUFFER5;
/** @const {!GLenum} */ WebGL2RenderingContext.DRAW_BUFFER6;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.DRAW_BUFFER6;
/** @const {!GLenum} */ WebGL2RenderingContext.DRAW_BUFFER7;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.DRAW_BUFFER7;
/** @const {!GLenum} */ WebGL2RenderingContext.DRAW_BUFFER8;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.DRAW_BUFFER8;
/** @const {!GLenum} */ WebGL2RenderingContext.DRAW_BUFFER9;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.DRAW_BUFFER9;
/** @const {!GLenum} */ WebGL2RenderingContext.DRAW_FRAMEBUFFER;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.DRAW_FRAMEBUFFER;
/** @const {!GLenum} */ WebGL2RenderingContext.DRAW_FRAMEBUFFER_BINDING;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.DRAW_FRAMEBUFFER_BINDING;
/** @const {!GLenum} */ WebGL2RenderingContext.DYNAMIC_COPY;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.DYNAMIC_COPY;
/** @const {!GLenum} */ WebGL2RenderingContext.DYNAMIC_READ;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.DYNAMIC_READ;
/** @const {!GLenum} */ WebGL2RenderingContext.FLOAT_32_UNSIGNED_INT_24_8_REV;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.FLOAT_32_UNSIGNED_INT_24_8_REV;
/** @const {!GLenum} */ WebGL2RenderingContext.FLOAT_MAT2x3;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.FLOAT_MAT2x3;
/** @const {!GLenum} */ WebGL2RenderingContext.FLOAT_MAT2x4;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.FLOAT_MAT2x4;
/** @const {!GLenum} */ WebGL2RenderingContext.FLOAT_MAT3x2;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.FLOAT_MAT3x2;
/** @const {!GLenum} */ WebGL2RenderingContext.FLOAT_MAT3x4;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.FLOAT_MAT3x4;
/** @const {!GLenum} */ WebGL2RenderingContext.FLOAT_MAT4x2;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.FLOAT_MAT4x2;
/** @const {!GLenum} */ WebGL2RenderingContext.FLOAT_MAT4x3;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.FLOAT_MAT4x3;
/** @const {!GLenum} */ WebGL2RenderingContext.FRAGMENT_SHADER_DERIVATIVE_HINT;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.FRAGMENT_SHADER_DERIVATIVE_HINT;
/** @const {!GLenum} */ WebGL2RenderingContext.FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE;
/** @const {!GLenum} */ WebGL2RenderingContext.FRAMEBUFFER_ATTACHMENT_BLUE_SIZE;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.FRAMEBUFFER_ATTACHMENT_BLUE_SIZE;
/** @const {!GLenum} */ WebGL2RenderingContext.FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING;
/** @const {!GLenum} */ WebGL2RenderingContext.FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE;
/** @const {!GLenum} */ WebGL2RenderingContext.FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE;
/** @const {!GLenum} */ WebGL2RenderingContext.FRAMEBUFFER_ATTACHMENT_GREEN_SIZE;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.FRAMEBUFFER_ATTACHMENT_GREEN_SIZE;
/** @const {!GLenum} */ WebGL2RenderingContext.FRAMEBUFFER_ATTACHMENT_RED_SIZE;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.FRAMEBUFFER_ATTACHMENT_RED_SIZE;
/** @const {!GLenum} */ WebGL2RenderingContext.FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE;
/** @const {!GLenum} */ WebGL2RenderingContext.FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER;
/** @const {!GLenum} */ WebGL2RenderingContext.FRAMEBUFFER_DEFAULT;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.FRAMEBUFFER_DEFAULT;
/** @const {!GLenum} */ WebGL2RenderingContext.FRAMEBUFFER_INCOMPLETE_MULTISAMPLE;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.FRAMEBUFFER_INCOMPLETE_MULTISAMPLE;
/** @const {!GLenum} */ WebGL2RenderingContext.HALF_FLOAT;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.HALF_FLOAT;
/** @const {!GLenum} */ WebGL2RenderingContext.INTERLEAVED_ATTRIBS;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.INTERLEAVED_ATTRIBS;
/** @const {!GLenum} */ WebGL2RenderingContext.INT_2_10_10_10_REV;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.INT_2_10_10_10_REV;
/** @const {!GLenum} */ WebGL2RenderingContext.INT_SAMPLER_2D;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.INT_SAMPLER_2D;
/** @const {!GLenum} */ WebGL2RenderingContext.INT_SAMPLER_2D_ARRAY;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.INT_SAMPLER_2D_ARRAY;
/** @const {!GLenum} */ WebGL2RenderingContext.INT_SAMPLER_3D;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.INT_SAMPLER_3D;
/** @const {!GLenum} */ WebGL2RenderingContext.INT_SAMPLER_CUBE;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.INT_SAMPLER_CUBE;
/** @const {!GLenum} */ WebGL2RenderingContext.INVALID_INDEX;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.INVALID_INDEX;
/** @const {!GLenum} */ WebGL2RenderingContext.MAX;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.MAX;
/** @const {!GLenum} */ WebGL2RenderingContext.MAX_3D_TEXTURE_SIZE;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.MAX_3D_TEXTURE_SIZE;
/** @const {!GLenum} */ WebGL2RenderingContext.MAX_ARRAY_TEXTURE_LAYERS;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.MAX_ARRAY_TEXTURE_LAYERS;
/** @const {!GLenum} */ WebGL2RenderingContext.MAX_CLIENT_WAIT_TIMEOUT_WEBGL;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.MAX_CLIENT_WAIT_TIMEOUT_WEBGL;
/** @const {!GLenum} */ WebGL2RenderingContext.MAX_COLOR_ATTACHMENTS;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.MAX_COLOR_ATTACHMENTS;
/** @const {!GLenum} */ WebGL2RenderingContext.MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS;
/** @const {!GLenum} */ WebGL2RenderingContext.MAX_COMBINED_UNIFORM_BLOCKS;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.MAX_COMBINED_UNIFORM_BLOCKS;
/** @const {!GLenum} */ WebGL2RenderingContext.MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS;
/** @const {!GLenum} */ WebGL2RenderingContext.MAX_DRAW_BUFFERS;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.MAX_DRAW_BUFFERS;
/** @const {!GLenum} */ WebGL2RenderingContext.MAX_ELEMENTS_INDICES;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.MAX_ELEMENTS_INDICES;
/** @const {!GLenum} */ WebGL2RenderingContext.MAX_ELEMENTS_VERTICES;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.MAX_ELEMENTS_VERTICES;
/** @const {!GLenum} */ WebGL2RenderingContext.MAX_ELEMENT_INDEX;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.MAX_ELEMENT_INDEX;
/** @const {!GLenum} */ WebGL2RenderingContext.MAX_FRAGMENT_INPUT_COMPONENTS;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.MAX_FRAGMENT_INPUT_COMPONENTS;
/** @const {!GLenum} */ WebGL2RenderingContext.MAX_FRAGMENT_UNIFORM_BLOCKS;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.MAX_FRAGMENT_UNIFORM_BLOCKS;
/** @const {!GLenum} */ WebGL2RenderingContext.MAX_FRAGMENT_UNIFORM_COMPONENTS;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.MAX_FRAGMENT_UNIFORM_COMPONENTS;
/** @const {!GLenum} */ WebGL2RenderingContext.MAX_PROGRAM_TEXEL_OFFSET;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.MAX_PROGRAM_TEXEL_OFFSET;
/** @const {!GLenum} */ WebGL2RenderingContext.MAX_SAMPLES;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.MAX_SAMPLES;
/** @const {!GLenum} */ WebGL2RenderingContext.MAX_SERVER_WAIT_TIMEOUT;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.MAX_SERVER_WAIT_TIMEOUT;
/** @const {!GLenum} */ WebGL2RenderingContext.MAX_TEXTURE_LOD_BIAS;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.MAX_TEXTURE_LOD_BIAS;
/** @const {!GLenum} */ WebGL2RenderingContext.MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS;
/** @const {!GLenum} */ WebGL2RenderingContext.MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS;
/** @const {!GLenum} */ WebGL2RenderingContext.MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS;
/** @const {!GLenum} */ WebGL2RenderingContext.MAX_UNIFORM_BLOCK_SIZE;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.MAX_UNIFORM_BLOCK_SIZE;
/** @const {!GLenum} */ WebGL2RenderingContext.MAX_UNIFORM_BUFFER_BINDINGS;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.MAX_UNIFORM_BUFFER_BINDINGS;
/** @const {!GLenum} */ WebGL2RenderingContext.MAX_VARYING_COMPONENTS;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.MAX_VARYING_COMPONENTS;
/** @const {!GLenum} */ WebGL2RenderingContext.MAX_VERTEX_OUTPUT_COMPONENTS;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.MAX_VERTEX_OUTPUT_COMPONENTS;
/** @const {!GLenum} */ WebGL2RenderingContext.MAX_VERTEX_UNIFORM_BLOCKS;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.MAX_VERTEX_UNIFORM_BLOCKS;
/** @const {!GLenum} */ WebGL2RenderingContext.MAX_VERTEX_UNIFORM_COMPONENTS;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.MAX_VERTEX_UNIFORM_COMPONENTS;
/** @const {!GLenum} */ WebGL2RenderingContext.MIN;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.MIN;
/** @const {!GLenum} */ WebGL2RenderingContext.MIN_PROGRAM_TEXEL_OFFSET;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.MIN_PROGRAM_TEXEL_OFFSET;
/** @const {!GLenum} */ WebGL2RenderingContext.OBJECT_TYPE;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.OBJECT_TYPE;
/** @const {!GLenum} */ WebGL2RenderingContext.PACK_ROW_LENGTH;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.PACK_ROW_LENGTH;
/** @const {!GLenum} */ WebGL2RenderingContext.PACK_SKIP_PIXELS;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.PACK_SKIP_PIXELS;
/** @const {!GLenum} */ WebGL2RenderingContext.PACK_SKIP_ROWS;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.PACK_SKIP_ROWS;
/** @const {!GLenum} */ WebGL2RenderingContext.PIXEL_PACK_BUFFER;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.PIXEL_PACK_BUFFER;
/** @const {!GLenum} */ WebGL2RenderingContext.PIXEL_PACK_BUFFER_BINDING;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.PIXEL_PACK_BUFFER_BINDING;
/** @const {!GLenum} */ WebGL2RenderingContext.PIXEL_UNPACK_BUFFER;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.PIXEL_UNPACK_BUFFER;
/** @const {!GLenum} */ WebGL2RenderingContext.PIXEL_UNPACK_BUFFER_BINDING;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.PIXEL_UNPACK_BUFFER_BINDING;
/** @const {!GLenum} */ WebGL2RenderingContext.QUERY_RESULT;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.QUERY_RESULT;
/** @const {!GLenum} */ WebGL2RenderingContext.QUERY_RESULT_AVAILABLE;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.QUERY_RESULT_AVAILABLE;
/** @const {!GLenum} */ WebGL2RenderingContext.R11F_G11F_B10F;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.R11F_G11F_B10F;
/** @const {!GLenum} */ WebGL2RenderingContext.R16F;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.R16F;
/** @const {!GLenum} */ WebGL2RenderingContext.R16I;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.R16I;
/** @const {!GLenum} */ WebGL2RenderingContext.R16UI;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.R16UI;
/** @const {!GLenum} */ WebGL2RenderingContext.R32F;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.R32F;
/** @const {!GLenum} */ WebGL2RenderingContext.R32I;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.R32I;
/** @const {!GLenum} */ WebGL2RenderingContext.R32UI;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.R32UI;
/** @const {!GLenum} */ WebGL2RenderingContext.R8;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.R8;
/** @const {!GLenum} */ WebGL2RenderingContext.R8I;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.R8I;
/** @const {!GLenum} */ WebGL2RenderingContext.R8UI;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.R8UI;
/** @const {!GLenum} */ WebGL2RenderingContext.R8_SNORM;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.R8_SNORM;
/** @const {!GLenum} */ WebGL2RenderingContext.RASTERIZER_DISCARD;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.RASTERIZER_DISCARD;
/** @const {!GLenum} */ WebGL2RenderingContext.READ_BUFFER;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.READ_BUFFER;
/** @const {!GLenum} */ WebGL2RenderingContext.READ_FRAMEBUFFER;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.READ_FRAMEBUFFER;
/** @const {!GLenum} */ WebGL2RenderingContext.READ_FRAMEBUFFER_BINDING;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.READ_FRAMEBUFFER_BINDING;
/** @const {!GLenum} */ WebGL2RenderingContext.RED;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.RED;
/** @const {!GLenum} */ WebGL2RenderingContext.RED_INTEGER;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.RED_INTEGER;
/** @const {!GLenum} */ WebGL2RenderingContext.RENDERBUFFER_SAMPLES;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.RENDERBUFFER_SAMPLES;
/** @const {!GLenum} */ WebGL2RenderingContext.RG;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.RG;
/** @const {!GLenum} */ WebGL2RenderingContext.RG16F;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.RG16F;
/** @const {!GLenum} */ WebGL2RenderingContext.RG16I;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.RG16I;
/** @const {!GLenum} */ WebGL2RenderingContext.RG16UI;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.RG16UI;
/** @const {!GLenum} */ WebGL2RenderingContext.RG32F;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.RG32F;
/** @const {!GLenum} */ WebGL2RenderingContext.RG32I;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.RG32I;
/** @const {!GLenum} */ WebGL2RenderingContext.RG32UI;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.RG32UI;
/** @const {!GLenum} */ WebGL2RenderingContext.RG8;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.RG8;
/** @const {!GLenum} */ WebGL2RenderingContext.RG8I;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.RG8I;
/** @const {!GLenum} */ WebGL2RenderingContext.RG8UI;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.RG8UI;
/** @const {!GLenum} */ WebGL2RenderingContext.RG8_SNORM;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.RG8_SNORM;
/** @const {!GLenum} */ WebGL2RenderingContext.RGB10_A2;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.RGB10_A2;
/** @const {!GLenum} */ WebGL2RenderingContext.RGB10_A2UI;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.RGB10_A2UI;
/** @const {!GLenum} */ WebGL2RenderingContext.RGB16F;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.RGB16F;
/** @const {!GLenum} */ WebGL2RenderingContext.RGB16I;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.RGB16I;
/** @const {!GLenum} */ WebGL2RenderingContext.RGB16UI;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.RGB16UI;
/** @const {!GLenum} */ WebGL2RenderingContext.RGB32F;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.RGB32F;
/** @const {!GLenum} */ WebGL2RenderingContext.RGB32I;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.RGB32I;
/** @const {!GLenum} */ WebGL2RenderingContext.RGB32UI;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.RGB32UI;
/** @const {!GLenum} */ WebGL2RenderingContext.RGB8;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.RGB8;
/** @const {!GLenum} */ WebGL2RenderingContext.RGB8I;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.RGB8I;
/** @const {!GLenum} */ WebGL2RenderingContext.RGB8UI;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.RGB8UI;
/** @const {!GLenum} */ WebGL2RenderingContext.RGB8_SNORM;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.RGB8_SNORM;
/** @const {!GLenum} */ WebGL2RenderingContext.RGB9_E5;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.RGB9_E5;
/** @const {!GLenum} */ WebGL2RenderingContext.RGBA16F;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.RGBA16F;
/** @const {!GLenum} */ WebGL2RenderingContext.RGBA16I;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.RGBA16I;
/** @const {!GLenum} */ WebGL2RenderingContext.RGBA16UI;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.RGBA16UI;
/** @const {!GLenum} */ WebGL2RenderingContext.RGBA32F;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.RGBA32F;
/** @const {!GLenum} */ WebGL2RenderingContext.RGBA32I;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.RGBA32I;
/** @const {!GLenum} */ WebGL2RenderingContext.RGBA32UI;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.RGBA32UI;
/** @const {!GLenum} */ WebGL2RenderingContext.RGBA8;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.RGBA8;
/** @const {!GLenum} */ WebGL2RenderingContext.RGBA8I;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.RGBA8I;
/** @const {!GLenum} */ WebGL2RenderingContext.RGBA8UI;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.RGBA8UI;
/** @const {!GLenum} */ WebGL2RenderingContext.RGBA8_SNORM;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.RGBA8_SNORM;
/** @const {!GLenum} */ WebGL2RenderingContext.RGBA_INTEGER;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.RGBA_INTEGER;
/** @const {!GLenum} */ WebGL2RenderingContext.RGB_INTEGER;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.RGB_INTEGER;
/** @const {!GLenum} */ WebGL2RenderingContext.RG_INTEGER;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.RG_INTEGER;
/** @const {!GLenum} */ WebGL2RenderingContext.SAMPLER_2D_ARRAY;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.SAMPLER_2D_ARRAY;
/** @const {!GLenum} */ WebGL2RenderingContext.SAMPLER_2D_ARRAY_SHADOW;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.SAMPLER_2D_ARRAY_SHADOW;
/** @const {!GLenum} */ WebGL2RenderingContext.SAMPLER_2D_SHADOW;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.SAMPLER_2D_SHADOW;
/** @const {!GLenum} */ WebGL2RenderingContext.SAMPLER_3D;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.SAMPLER_3D;
/** @const {!GLenum} */ WebGL2RenderingContext.SAMPLER_BINDING;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.SAMPLER_BINDING;
/** @const {!GLenum} */ WebGL2RenderingContext.SAMPLER_CUBE_SHADOW;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.SAMPLER_CUBE_SHADOW;
/** @const {!GLenum} */ WebGL2RenderingContext.SEPARATE_ATTRIBS;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.SEPARATE_ATTRIBS;
/** @const {!GLenum} */ WebGL2RenderingContext.SIGNALED;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.SIGNALED;
/** @const {!GLenum} */ WebGL2RenderingContext.SIGNED_NORMALIZED;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.SIGNED_NORMALIZED;
/** @const {!GLenum} */ WebGL2RenderingContext.SRGB;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.SRGB;
/** @const {!GLenum} */ WebGL2RenderingContext.SRGB8;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.SRGB8;
/** @const {!GLenum} */ WebGL2RenderingContext.SRGB8_ALPHA8;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.SRGB8_ALPHA8;
/** @const {!GLenum} */ WebGL2RenderingContext.STATIC_COPY;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.STATIC_COPY;
/** @const {!GLenum} */ WebGL2RenderingContext.STATIC_READ;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.STATIC_READ;
/** @const {!GLenum} */ WebGL2RenderingContext.STENCIL;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.STENCIL;
/** @const {!GLenum} */ WebGL2RenderingContext.STREAM_COPY;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.STREAM_COPY;
/** @const {!GLenum} */ WebGL2RenderingContext.STREAM_READ;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.STREAM_READ;
/** @const {!GLenum} */ WebGL2RenderingContext.SYNC_CONDITION;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.SYNC_CONDITION;
/** @const {!GLenum} */ WebGL2RenderingContext.SYNC_FENCE;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.SYNC_FENCE;
/** @const {!GLenum} */ WebGL2RenderingContext.SYNC_FLAGS;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.SYNC_FLAGS;
/** @const {!GLenum} */ WebGL2RenderingContext.SYNC_FLUSH_COMMANDS_BIT;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.SYNC_FLUSH_COMMANDS_BIT;
/** @const {!GLenum} */ WebGL2RenderingContext.SYNC_GPU_COMMANDS_COMPLETE;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.SYNC_GPU_COMMANDS_COMPLETE;
/** @const {!GLenum} */ WebGL2RenderingContext.SYNC_STATUS;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.SYNC_STATUS;
/** @const {!GLenum} */ WebGL2RenderingContext.TEXTURE_2D_ARRAY;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.TEXTURE_2D_ARRAY;
/** @const {!GLenum} */ WebGL2RenderingContext.TEXTURE_3D;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.TEXTURE_3D;
/** @const {!GLenum} */ WebGL2RenderingContext.TEXTURE_BASE_LEVEL;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.TEXTURE_BASE_LEVEL;
/** @const {!GLenum} */ WebGL2RenderingContext.TEXTURE_BINDING_2D_ARRAY;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.TEXTURE_BINDING_2D_ARRAY;
/** @const {!GLenum} */ WebGL2RenderingContext.TEXTURE_BINDING_3D;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.TEXTURE_BINDING_3D;
/** @const {!GLenum} */ WebGL2RenderingContext.TEXTURE_COMPARE_FUNC;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.TEXTURE_COMPARE_FUNC;
/** @const {!GLenum} */ WebGL2RenderingContext.TEXTURE_COMPARE_MODE;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.TEXTURE_COMPARE_MODE;
/** @const {!GLenum} */ WebGL2RenderingContext.TEXTURE_IMMUTABLE_FORMAT;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.TEXTURE_IMMUTABLE_FORMAT;
/** @const {!GLenum} */ WebGL2RenderingContext.TEXTURE_IMMUTABLE_LEVELS;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.TEXTURE_IMMUTABLE_LEVELS;
/** @const {!GLenum} */ WebGL2RenderingContext.TEXTURE_MAX_LEVEL;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.TEXTURE_MAX_LEVEL;
/** @const {!GLenum} */ WebGL2RenderingContext.TEXTURE_MAX_LOD;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.TEXTURE_MAX_LOD;
/** @const {!GLenum} */ WebGL2RenderingContext.TEXTURE_MIN_LOD;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.TEXTURE_MIN_LOD;
/** @const {!GLenum} */ WebGL2RenderingContext.TEXTURE_WRAP_R;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.TEXTURE_WRAP_R;
/** @const {!GLenum} */ WebGL2RenderingContext.TIMEOUT_EXPIRED;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.TIMEOUT_EXPIRED;
/** @const {!GLint64} */ WebGL2RenderingContext.TIMEOUT_IGNORED;
/** @const {!GLint64} */ WebGL2RenderingContext.prototype.TIMEOUT_IGNORED;
/** @const {!GLenum} */ WebGL2RenderingContext.TRANSFORM_FEEDBACK;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.TRANSFORM_FEEDBACK;
/** @const {!GLenum} */ WebGL2RenderingContext.TRANSFORM_FEEDBACK_ACTIVE;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.TRANSFORM_FEEDBACK_ACTIVE;
/** @const {!GLenum} */ WebGL2RenderingContext.TRANSFORM_FEEDBACK_BINDING;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.TRANSFORM_FEEDBACK_BINDING;
/** @const {!GLenum} */ WebGL2RenderingContext.TRANSFORM_FEEDBACK_BUFFER;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.TRANSFORM_FEEDBACK_BUFFER;
/** @const {!GLenum} */ WebGL2RenderingContext.TRANSFORM_FEEDBACK_BUFFER_BINDING;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.TRANSFORM_FEEDBACK_BUFFER_BINDING;
/** @const {!GLenum} */ WebGL2RenderingContext.TRANSFORM_FEEDBACK_BUFFER_MODE;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.TRANSFORM_FEEDBACK_BUFFER_MODE;
/** @const {!GLenum} */ WebGL2RenderingContext.TRANSFORM_FEEDBACK_BUFFER_SIZE;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.TRANSFORM_FEEDBACK_BUFFER_SIZE;
/** @const {!GLenum} */ WebGL2RenderingContext.TRANSFORM_FEEDBACK_BUFFER_START;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.TRANSFORM_FEEDBACK_BUFFER_START;
/** @const {!GLenum} */ WebGL2RenderingContext.TRANSFORM_FEEDBACK_PAUSED;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.TRANSFORM_FEEDBACK_PAUSED;
/** @const {!GLenum} */ WebGL2RenderingContext.TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN;
/** @const {!GLenum} */ WebGL2RenderingContext.TRANSFORM_FEEDBACK_VARYINGS;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.TRANSFORM_FEEDBACK_VARYINGS;
/** @const {!GLenum} */ WebGL2RenderingContext.UNIFORM_ARRAY_STRIDE;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.UNIFORM_ARRAY_STRIDE;
/** @const {!GLenum} */ WebGL2RenderingContext.UNIFORM_BLOCK_ACTIVE_UNIFORMS;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.UNIFORM_BLOCK_ACTIVE_UNIFORMS;
/** @const {!GLenum} */ WebGL2RenderingContext.UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES;
/** @const {!GLenum} */ WebGL2RenderingContext.UNIFORM_BLOCK_BINDING;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.UNIFORM_BLOCK_BINDING;
/** @const {!GLenum} */ WebGL2RenderingContext.UNIFORM_BLOCK_DATA_SIZE;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.UNIFORM_BLOCK_DATA_SIZE;
/** @const {!GLenum} */ WebGL2RenderingContext.UNIFORM_BLOCK_INDEX;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.UNIFORM_BLOCK_INDEX;
/** @const {!GLenum} */ WebGL2RenderingContext.UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER;
/** @const {!GLenum} */ WebGL2RenderingContext.UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER;
/** @const {!GLenum} */ WebGL2RenderingContext.UNIFORM_BUFFER;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.UNIFORM_BUFFER;
/** @const {!GLenum} */ WebGL2RenderingContext.UNIFORM_BUFFER_BINDING;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.UNIFORM_BUFFER_BINDING;
/** @const {!GLenum} */ WebGL2RenderingContext.UNIFORM_BUFFER_OFFSET_ALIGNMENT;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.UNIFORM_BUFFER_OFFSET_ALIGNMENT;
/** @const {!GLenum} */ WebGL2RenderingContext.UNIFORM_BUFFER_SIZE;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.UNIFORM_BUFFER_SIZE;
/** @const {!GLenum} */ WebGL2RenderingContext.UNIFORM_BUFFER_START;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.UNIFORM_BUFFER_START;
/** @const {!GLenum} */ WebGL2RenderingContext.UNIFORM_IS_ROW_MAJOR;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.UNIFORM_IS_ROW_MAJOR;
/** @const {!GLenum} */ WebGL2RenderingContext.UNIFORM_MATRIX_STRIDE;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.UNIFORM_MATRIX_STRIDE;
/** @const {!GLenum} */ WebGL2RenderingContext.UNIFORM_OFFSET;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.UNIFORM_OFFSET;
/** @const {!GLenum} */ WebGL2RenderingContext.UNIFORM_SIZE;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.UNIFORM_SIZE;
/** @const {!GLenum} */ WebGL2RenderingContext.UNIFORM_TYPE;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.UNIFORM_TYPE;
/** @const {!GLenum} */ WebGL2RenderingContext.UNPACK_IMAGE_HEIGHT;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.UNPACK_IMAGE_HEIGHT;
/** @const {!GLenum} */ WebGL2RenderingContext.UNPACK_ROW_LENGTH;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.UNPACK_ROW_LENGTH;
/** @const {!GLenum} */ WebGL2RenderingContext.UNPACK_SKIP_IMAGES;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.UNPACK_SKIP_IMAGES;
/** @const {!GLenum} */ WebGL2RenderingContext.UNPACK_SKIP_PIXELS;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.UNPACK_SKIP_PIXELS;
/** @const {!GLenum} */ WebGL2RenderingContext.UNPACK_SKIP_ROWS;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.UNPACK_SKIP_ROWS;
/** @const {!GLenum} */ WebGL2RenderingContext.UNSIGNALED;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.UNSIGNALED;
/** @const {!GLenum} */ WebGL2RenderingContext.UNSIGNED_INT_10F_11F_11F_REV;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.UNSIGNED_INT_10F_11F_11F_REV;
/** @const {!GLenum} */ WebGL2RenderingContext.UNSIGNED_INT_24_8;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.UNSIGNED_INT_24_8;
/** @const {!GLenum} */ WebGL2RenderingContext.UNSIGNED_INT_2_10_10_10_REV;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.UNSIGNED_INT_2_10_10_10_REV;
/** @const {!GLenum} */ WebGL2RenderingContext.UNSIGNED_INT_5_9_9_9_REV;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.UNSIGNED_INT_5_9_9_9_REV;
/** @const {!GLenum} */ WebGL2RenderingContext.UNSIGNED_INT_SAMPLER_2D;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.UNSIGNED_INT_SAMPLER_2D;
/** @const {!GLenum} */ WebGL2RenderingContext.UNSIGNED_INT_SAMPLER_2D_ARRAY;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.UNSIGNED_INT_SAMPLER_2D_ARRAY;
/** @const {!GLenum} */ WebGL2RenderingContext.UNSIGNED_INT_SAMPLER_3D;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.UNSIGNED_INT_SAMPLER_3D;
/** @const {!GLenum} */ WebGL2RenderingContext.UNSIGNED_INT_SAMPLER_CUBE;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.UNSIGNED_INT_SAMPLER_CUBE;
/** @const {!GLenum} */ WebGL2RenderingContext.UNSIGNED_INT_VEC2;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.UNSIGNED_INT_VEC2;
/** @const {!GLenum} */ WebGL2RenderingContext.UNSIGNED_INT_VEC3;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.UNSIGNED_INT_VEC3;
/** @const {!GLenum} */ WebGL2RenderingContext.UNSIGNED_INT_VEC4;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.UNSIGNED_INT_VEC4;
/** @const {!GLenum} */ WebGL2RenderingContext.UNSIGNED_NORMALIZED;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.UNSIGNED_NORMALIZED;
/** @const {!GLenum} */ WebGL2RenderingContext.VERTEX_ARRAY_BINDING;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.VERTEX_ARRAY_BINDING;
/** @const {!GLenum} */ WebGL2RenderingContext.VERTEX_ATTRIB_ARRAY_DIVISOR;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.VERTEX_ATTRIB_ARRAY_DIVISOR;
/** @const {!GLenum} */ WebGL2RenderingContext.VERTEX_ATTRIB_ARRAY_INTEGER;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.VERTEX_ATTRIB_ARRAY_INTEGER;
/** @const {!GLenum} */ WebGL2RenderingContext.WAIT_FAILED;
/** @const {!GLenum} */ WebGL2RenderingContext.prototype.WAIT_FAILED;
/** @type {!GLsizei} */ WebGL2RenderingContext.prototype.drawingBufferHeight;
/** @type {!GLsizei} */ WebGL2RenderingContext.prototype.drawingBufferWidth;
/**
 * @param {?WebGLBuffer} buffer
 * @return {!GLboolean}
 * @nosideeffects
 */
WebGL2RenderingContext.prototype.isBuffer = function(buffer) {}
/**
 * @param {!GLenum} texture
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.activeTexture = function(texture) {}
/**
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.pauseTransformFeedback = function() {}
/**
 * @param {!GLuint} index
 * @param {!GLenum} pname
 * @return {*}
 * @nosideeffects
 */
WebGL2RenderingContext.prototype.getVertexAttrib = function(index,pname) {}
/**
 * @param {!GLenum} arg0
 * @param {!GLint} arg1
 * @param {!GLenum} arg2
 * @param {!GLsizei} arg3
 * @param {!GLsizei} arg4
 * @param {!GLint} arg5
 * @param {(!GLsizei|!ArrayBufferView)} arg6
 * @param {(!GLintptr|!GLuint)=} arg7
 * @param {!GLuint=} arg8
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.compressedTexImage2D = function(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8) {}
/**
 * @param {?WebGLProgram} program
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.useProgram = function(program) {}
/**
 * @param {!GLenum} arg0
 * @param {!GLint} arg1
 * @param {!GLint} arg2
 * @param {!GLint} arg3
 * @param {!GLint} arg4
 * @param {!GLsizei} arg5
 * @param {!GLsizei} arg6
 * @param {!GLsizei} arg7
 * @param {!GLenum} arg8
 * @param {!GLenum} arg9
 * @param {(!GLintptr|!TexImageSource|?ArrayBufferView)} arg10
 * @param {!GLuint=} arg11
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.texSubImage3D = function(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11) {}
/**
 * @param {?WebGLUniformLocation} location
 * @param {!Uint32List} data
 * @param {!GLuint=} srcOffset
 * @param {!GLuint=} srcLength
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.uniform1uiv = function(location,data,srcOffset,srcLength) {}
/**
 * @param {!WebGLProgram} program
 * @param {!string} uniformBlockName
 * @return {!GLuint}
 * @nosideeffects
 */
WebGL2RenderingContext.prototype.getUniformBlockIndex = function(program,uniformBlockName) {}
/**
 * @param {!GLenum} target
 * @param {!WebGLQuery} query
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.beginQuery = function(target,query) {}
/**
 * @param {!GLuint} index
 * @param {!GLfloat} x
 * @param {!GLfloat} y
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.vertexAttrib2f = function(index,x,y) {}
/**
 * @param {!GLenum} target
 * @param {!GLenum} pname
 * @return {?WebGLQuery}
 * @nosideeffects
 */
WebGL2RenderingContext.prototype.getQuery = function(target,pname) {}
/**
 * @return {?Array<!string>}
 * @nosideeffects
 */
WebGL2RenderingContext.prototype.getSupportedExtensions = function() {}
/**
 * @param {?WebGLUniformLocation} location
 * @param {!GLuint} v0
 * @param {!GLuint} v1
 * @param {!GLuint} v2
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.uniform3ui = function(location,v0,v1,v2) {}
/**
 * @param {!GLuint} index
 * @param {!Int32List} values
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.vertexAttribI4iv = function(index,values) {}
/**
 * @param {?WebGLUniformLocation} location
 * @param {!Float32List} data
 * @param {!GLuint=} srcOffset
 * @param {!GLuint=} srcLength
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.uniform4fv = function(location,data,srcOffset,srcLength) {}
/**
 * @return {!boolean}
 * @nosideeffects
 */
WebGL2RenderingContext.prototype.isContextLost = function() {}
/**
 * @return {?WebGLTransformFeedback}
 */
WebGL2RenderingContext.prototype.createTransformFeedback = function() {}
/**
 * @param {!GLenum} shadertype
 * @param {!GLenum} precisiontype
 * @return {?WebGLShaderPrecisionFormat}
 * @nosideeffects
 */
WebGL2RenderingContext.prototype.getShaderPrecisionFormat = function(shadertype,precisiontype) {}
/**
 * @param {!GLfloat} factor
 * @param {!GLfloat} units
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.polygonOffset = function(factor,units) {}
/**
 * @return {!GLenum}
 * @nosideeffects
 */
WebGL2RenderingContext.prototype.getError = function() {}
/**
 * @return {?WebGLContextAttributes}
 * @nosideeffects
 */
WebGL2RenderingContext.prototype.getContextAttributes = function() {}
/**
 * @param {!WebGLProgram} program
 * @param {!Array<!string>} uniformNames
 * @return {?Array<!GLuint>}
 */
WebGL2RenderingContext.prototype.getUniformIndices = function(program,uniformNames) {}
/**
 * @param {!GLenum} arg0
 * @param {!GLint} arg1
 * @param {!GLint} arg2
 * @param {!GLint} arg3
 * @param {(!GLsizei|!GLenum)} arg4
 * @param {(!GLsizei|!GLenum)} arg5
 * @param {(!GLenum|!TexImageSource)} arg6
 * @param {!GLenum=} arg7
 * @param {(?ArrayBufferView|!GLintptr|!TexImageSource|!ArrayBufferView)=} arg8
 * @param {!GLuint=} arg9
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.texSubImage2D = function(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9) {}
/**
 * @param {!GLuint} index
 * @param {!GLenum} pname
 * @return {!GLintptr}
 * @nosideeffects
 */
WebGL2RenderingContext.prototype.getVertexAttribOffset = function(index,pname) {}
/**
 * @param {!GLenum} target
 * @param {!GLenum} pname
 * @return {*}
 * @nosideeffects
 */
WebGL2RenderingContext.prototype.getRenderbufferParameter = function(target,pname) {}
/**
 * @param {!Array<!GLenum>} buffers
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.drawBuffers = function(buffers) {}
/**
 * @param {!GLuint} index
 * @param {!GLfloat} x
 * @param {!GLfloat} y
 * @param {!GLfloat} z
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.vertexAttrib3f = function(index,x,y,z) {}
/**
 * @param {!GLenum} src
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.readBuffer = function(src) {}
/**
 * @param {!WebGLQuery} query
 * @param {!GLenum} pname
 * @return {*}
 */
WebGL2RenderingContext.prototype.getQueryParameter = function(query,pname) {}
/**
 * @param {!GLenum} target
 * @param {!GLuint} index
 * @return {*}
 */
WebGL2RenderingContext.prototype.getIndexedParameter = function(target,index) {}
/**
 * @param {!GLenum} fail
 * @param {!GLenum} zfail
 * @param {!GLenum} zpass
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.stencilOp = function(fail,zfail,zpass) {}
/**
 * @param {?WebGLVertexArrayObject} vertexArray
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.deleteVertexArray = function(vertexArray) {}
/**
 * @param {?WebGLUniformLocation} location
 * @param {!GLboolean} transpose
 * @param {!Float32List} data
 * @param {!GLuint=} srcOffset
 * @param {!GLuint=} srcLength
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.uniformMatrix4fv = function(location,transpose,data,srcOffset,srcLength) {}
/**
 * @param {!GLfloat} width
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.lineWidth = function(width) {}
/**
 * @param {?WebGLRenderbuffer} renderbuffer
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.deleteRenderbuffer = function(renderbuffer) {}
/**
 * @param {!GLenum} modeRGB
 * @param {!GLenum} modeAlpha
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.blendEquationSeparate = function(modeRGB,modeAlpha) {}
/**
 * @param {!WebGLProgram} program
 * @param {!GLuint} index
 * @param {!string} name
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.bindAttribLocation = function(program,index,name) {}
/**
 * @param {!WebGLSync} sync
 * @param {!GLenum} pname
 * @return {*}
 */
WebGL2RenderingContext.prototype.getSyncParameter = function(sync,pname) {}
/**
 * @param {!GLuint} index
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.disableVertexAttribArray = function(index) {}
/**
 * @param {!WebGLShader} shader
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.compileShader = function(shader) {}
/**
 * @param {!GLuint} index
 * @param {!GLfloat} x
 * @param {!GLfloat} y
 * @param {!GLfloat} z
 * @param {!GLfloat} w
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.vertexAttrib4f = function(index,x,y,z,w) {}
/**
 * @param {!GLenum} mode
 * @param {!GLsizei} count
 * @param {!GLenum} type
 * @param {!GLintptr} offset
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.drawElements = function(mode,count,type,offset) {}
/**
 * @return {?WebGLSampler}
 */
WebGL2RenderingContext.prototype.createSampler = function() {}
/**
 * @param {!WebGLSampler} sampler
 * @param {!GLenum} pname
 * @param {!GLfloat} param
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.samplerParameterf = function(sampler,pname,param) {}
/**
 * @param {!GLuint} unit
 * @param {?WebGLSampler} sampler
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.bindSampler = function(unit,sampler) {}
/**
 * @param {!GLclampf} value
 * @param {!GLboolean} invert
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.sampleCoverage = function(value,invert) {}
/**
 * @param {?WebGLUniformLocation} location
 * @param {!GLuint} v0
 * @param {!GLuint} v1
 * @param {!GLuint} v2
 * @param {!GLuint} v3
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.uniform4ui = function(location,v0,v1,v2,v3) {}
/**
 * @param {?WebGLFramebuffer} framebuffer
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.deleteFramebuffer = function(framebuffer) {}
/**
 * @param {!WebGLShader} shader
 * @return {?string}
 * @nosideeffects
 */
WebGL2RenderingContext.prototype.getShaderInfoLog = function(shader) {}
/**
 * @param {?WebGLUniformLocation} location
 * @param {!GLboolean} transpose
 * @param {!Float32List} data
 * @param {!GLuint=} srcOffset
 * @param {!GLuint=} srcLength
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.uniformMatrix2x4fv = function(location,transpose,data,srcOffset,srcLength) {}
/**
 * @param {!WebGLSampler} sampler
 * @param {!GLenum} pname
 * @param {!GLint} param
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.samplerParameteri = function(sampler,pname,param) {}
/**
 * @param {!GLenum} arg0
 * @param {!GLint} arg1
 * @param {!GLenum} arg2
 * @param {!GLsizei} arg3
 * @param {!GLsizei} arg4
 * @param {!GLsizei} arg5
 * @param {!GLint} arg6
 * @param {(!GLsizei|!ArrayBufferView)} arg7
 * @param {(!GLintptr|!GLuint)=} arg8
 * @param {!GLuint=} arg9
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.compressedTexImage3D = function(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9) {}
/**
 * @param {?WebGLBuffer} buffer
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.deleteBuffer = function(buffer) {}
/**
 * @param {?WebGLUniformLocation} location
 * @param {!GLboolean} transpose
 * @param {!Float32List} data
 * @param {!GLuint=} srcOffset
 * @param {!GLuint=} srcLength
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.uniformMatrix3x2fv = function(location,transpose,data,srcOffset,srcLength) {}
/**
 * @param {!GLenum} arg0
 * @param {!GLintptr} arg1
 * @param {(!BufferSource|!ArrayBufferView)} arg2
 * @param {!GLuint=} arg3
 * @param {!GLuint=} arg4
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.bufferSubData = function(arg0,arg1,arg2,arg3,arg4) {}
/**
 * @param {!WebGLProgram} program
 * @param {!Array<!GLuint>} uniformIndices
 * @param {!GLenum} pname
 * @return {*}
 */
WebGL2RenderingContext.prototype.getActiveUniforms = function(program,uniformIndices,pname) {}
/**
 * @param {!GLenum} mode
 * @param {!GLint} first
 * @param {!GLsizei} count
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.drawArrays = function(mode,first,count) {}
/**
 * @param {?WebGLTexture} texture
 * @return {!GLboolean}
 * @nosideeffects
 */
WebGL2RenderingContext.prototype.isTexture = function(texture) {}
/**
 * @param {!GLenum} target
 * @param {!GLsizei} levels
 * @param {!GLenum} internalformat
 * @param {!GLsizei} width
 * @param {!GLsizei} height
 * @param {!GLsizei} depth
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.texStorage3D = function(target,levels,internalformat,width,height,depth) {}
/**
 * @param {?WebGLUniformLocation} location
 * @param {!GLboolean} transpose
 * @param {!Float32List} data
 * @param {!GLuint=} srcOffset
 * @param {!GLuint=} srcLength
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.uniformMatrix3fv = function(location,transpose,data,srcOffset,srcLength) {}
/**
 * @param {!WebGLProgram} program
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.validateProgram = function(program) {}
/**
 * @param {!GLenum} face
 * @param {!GLuint} mask
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.stencilMaskSeparate = function(face,mask) {}
/**
 * @param {!GLclampf} zNear
 * @param {!GLclampf} zFar
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.depthRange = function(zNear,zFar) {}
/**
 * @param {!GLenum} target
 * @param {!Array<!GLenum>} attachments
 * @param {!GLint} x
 * @param {!GLint} y
 * @param {!GLsizei} width
 * @param {!GLsizei} height
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.invalidateSubFramebuffer = function(target,attachments,x,y,width,height) {}
/**
 * @param {!GLenum} mode
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.blendEquation = function(mode) {}
/**
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.finish = function() {}
/**
 * @return {?WebGLProgram}
 * @nosideeffects
 */
WebGL2RenderingContext.prototype.createProgram = function() {}
/**
 * @param {!WebGLProgram} program
 * @param {!WebGLShader} shader
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.detachShader = function(program,shader) {}
/**
 * @param {?WebGLTransformFeedback} tf
 * @return {!GLboolean}
 */
WebGL2RenderingContext.prototype.isTransformFeedback = function(tf) {}
/**
 * @param {!GLenum} target
 * @param {!GLenum} attachment
 * @param {!GLenum} pname
 * @return {*}
 * @nosideeffects
 */
WebGL2RenderingContext.prototype.getFramebufferAttachmentParameter = function(target,attachment,pname) {}
/**
 * @param {?WebGLUniformLocation} location
 * @param {!GLboolean} transpose
 * @param {!Float32List} data
 * @param {!GLuint=} srcOffset
 * @param {!GLuint=} srcLength
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.uniformMatrix2x3fv = function(location,transpose,data,srcOffset,srcLength) {}
/**
 * @param {!GLenum} func
 * @param {!GLint} ref
 * @param {!GLuint} mask
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.stencilFunc = function(func,ref,mask) {}
/**
 * @param {!GLuint} index
 * @param {!Float32List} values
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.vertexAttrib3fv = function(index,values) {}
/**
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.resumeTransformFeedback = function() {}
/**
 * @param {!GLenum} target
 * @param {!GLenum} pname
 * @param {!GLint} param
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.texParameteri = function(target,pname,param) {}
/**
 * @param {!GLenum} target
 * @param {!GLenum} pname
 * @param {!GLfloat} param
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.texParameterf = function(target,pname,param) {}
/**
 * @param {!GLenum} target
 * @param {!GLenum} mode
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.hint = function(target,mode) {}
/**
 * @param {!GLenum} target
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.endQuery = function(target) {}
/**
 * @param {!GLclampf} depth
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.clearDepth = function(depth) {}
/**
 * @param {!GLenum} pname
 * @param {!GLint} param
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.pixelStorei = function(pname,param) {}
/**
 * @param {!WebGLProgram} program
 * @param {!GLuint} uniformBlockIndex
 * @param {!GLenum} pname
 * @return {*}
 */
WebGL2RenderingContext.prototype.getActiveUniformBlockParameter = function(program,uniformBlockIndex,pname) {}
/**
 * @param {!WebGLProgram} program
 * @param {!GLenum} pname
 * @return {*}
 * @nosideeffects
 */
WebGL2RenderingContext.prototype.getProgramParameter = function(program,pname) {}
/**
 * @param {!WebGLProgram} program
 * @param {!WebGLShader} shader
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.attachShader = function(program,shader) {}
/**
 * @param {!GLenum} condition
 * @param {!GLbitfield} flags
 * @return {?WebGLSync}
 */
WebGL2RenderingContext.prototype.fenceSync = function(condition,flags) {}
/**
 * @param {!GLenum} target
 * @param {?WebGLBuffer} buffer
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.bindBuffer = function(target,buffer) {}
/**
 * @param {!GLuint} index
 * @param {!Uint32List} values
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.vertexAttribI4uiv = function(index,values) {}
/**
 * @param {!GLenum} target
 * @param {!GLintptr} srcByteOffset
 * @param {!ArrayBufferView} dstBuffer
 * @param {!GLuint=} dstOffset
 * @param {!GLuint=} length
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.getBufferSubData = function(target,srcByteOffset,dstBuffer,dstOffset,length) {}
/**
 * @param {!GLenum} target
 * @param {?WebGLRenderbuffer} renderbuffer
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.bindRenderbuffer = function(target,renderbuffer) {}
/**
 * @return {?WebGLBuffer}
 * @nosideeffects
 */
WebGL2RenderingContext.prototype.createBuffer = function() {}
/**
 * @param {!GLenum} target
 * @return {!GLenum}
 */
WebGL2RenderingContext.prototype.checkFramebufferStatus = function(target) {}
/**
 * @param {!WebGLProgram} program
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.linkProgram = function(program) {}
/**
 * @param {?WebGLUniformLocation} location
 * @param {!GLboolean} transpose
 * @param {!Float32List} data
 * @param {!GLuint=} srcOffset
 * @param {!GLuint=} srcLength
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.uniformMatrix2fv = function(location,transpose,data,srcOffset,srcLength) {}
/**
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.flush = function() {}
/**
 * @param {!WebGLProgram} program
 * @param {!GLuint} index
 * @return {?WebGLActiveInfo}
 * @nosideeffects
 */
WebGL2RenderingContext.prototype.getActiveAttrib = function(program,index) {}
/**
 * @param {!GLuint} mask
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.stencilMask = function(mask) {}
/**
 * @param {!GLenum} target
 * @param {!GLenum} attachment
 * @param {!GLenum} textarget
 * @param {?WebGLTexture} texture
 * @param {!GLint} level
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.framebufferTexture2D = function(target,attachment,textarget,texture,level) {}
/**
 * @param {!GLenum} type
 * @return {?WebGLShader}
 * @nosideeffects
 */
WebGL2RenderingContext.prototype.createShader = function(type) {}
/**
 * @param {!GLboolean} red
 * @param {!GLboolean} green
 * @param {!GLboolean} blue
 * @param {!GLboolean} alpha
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.colorMask = function(red,green,blue,alpha) {}
/**
 * @param {!GLenum} target
 * @param {!GLenum} internalformat
 * @param {!GLsizei} width
 * @param {!GLsizei} height
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.renderbufferStorage = function(target,internalformat,width,height) {}
/**
 * @param {!WebGLSampler} sampler
 * @param {!GLenum} pname
 * @return {*}
 * @nosideeffects
 */
WebGL2RenderingContext.prototype.getSamplerParameter = function(sampler,pname) {}
/**
 * @return {?WebGLQuery}
 */
WebGL2RenderingContext.prototype.createQuery = function() {}
/**
 * @param {!GLenum} target
 * @param {!GLsizei} levels
 * @param {!GLenum} internalformat
 * @param {!GLsizei} width
 * @param {!GLsizei} height
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.texStorage2D = function(target,levels,internalformat,width,height) {}
/**
 * @return {?WebGLRenderbuffer}
 * @nosideeffects
 */
WebGL2RenderingContext.prototype.createRenderbuffer = function() {}
/**
 * @param {?WebGLQuery} query
 * @return {!GLboolean}
 */
WebGL2RenderingContext.prototype.isQuery = function(query) {}
/**
 * @param {!GLenum} face
 * @param {!GLenum} func
 * @param {!GLint} ref
 * @param {!GLuint} mask
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.stencilFuncSeparate = function(face,func,ref,mask) {}
/**
 * @param {!GLuint} index
 * @param {!Float32List} values
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.vertexAttrib4fv = function(index,values) {}
/**
 * @param {!WebGLProgram} program
 * @param {!string} name
 * @return {?WebGLUniformLocation}
 * @nosideeffects
 */
WebGL2RenderingContext.prototype.getUniformLocation = function(program,name) {}
/**
 * @param {?WebGLUniformLocation} location
 * @param {!Uint32List} data
 * @param {!GLuint=} srcOffset
 * @param {!GLuint=} srcLength
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.uniform2uiv = function(location,data,srcOffset,srcLength) {}
/**
 * @param {!WebGLShader} shader
 * @param {!string} source
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.shaderSource = function(shader,source) {}
/**
 * @param {!WebGLShader} shader
 * @param {!GLenum} pname
 * @return {*}
 * @nosideeffects
 */
WebGL2RenderingContext.prototype.getShaderParameter = function(shader,pname) {}
/**
 * @param {?WebGLProgram} program
 * @return {!GLboolean}
 * @nosideeffects
 */
WebGL2RenderingContext.prototype.isProgram = function(program) {}
/**
 * @param {!GLuint} index
 * @param {!GLfloat} x
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.vertexAttrib1f = function(index,x) {}
/**
 * @param {!GLenum} target
 * @param {!GLenum} internalformat
 * @param {!GLenum} pname
 * @return {*}
 * @nosideeffects
 */
WebGL2RenderingContext.prototype.getInternalformatParameter = function(target,internalformat,pname) {}
/**
 * @param {!GLenum} readTarget
 * @param {!GLenum} writeTarget
 * @param {!GLintptr} readOffset
 * @param {!GLintptr} writeOffset
 * @param {!GLsizeiptr} size
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.copyBufferSubData = function(readTarget,writeTarget,readOffset,writeOffset,size) {}
/**
 * @param {!GLenum} mode
 * @param {!GLsizei} count
 * @param {!GLenum} type
 * @param {!GLintptr} offset
 * @param {!GLsizei} instanceCount
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.drawElementsInstanced = function(mode,count,type,offset,instanceCount) {}
/**
 * @param {!GLenum} target
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.generateMipmap = function(target) {}
/**
 * @param {?WebGLProgram} program
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.deleteProgram = function(program) {}
/**
 * @param {!GLenum} primitiveMode
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.beginTransformFeedback = function(primitiveMode) {}
/**
 * @param {!GLenum} target
 * @param {!GLenum} attachment
 * @param {!GLenum} renderbuffertarget
 * @param {?WebGLRenderbuffer} renderbuffer
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.framebufferRenderbuffer = function(target,attachment,renderbuffertarget,renderbuffer) {}
/**
 * @param {!GLenum} target
 * @param {?WebGLTransformFeedback} tf
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.bindTransformFeedback = function(target,tf) {}
/**
 * @return {?WebGLVertexArrayObject}
 */
WebGL2RenderingContext.prototype.createVertexArray = function() {}
/**
 * @param {!WebGLProgram} program
 * @param {!GLuint} uniformBlockIndex
 * @return {?string}
 * @nosideeffects
 */
WebGL2RenderingContext.prototype.getActiveUniformBlockName = function(program,uniformBlockIndex) {}
/**
 * @param {!GLuint} index
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.enableVertexAttribArray = function(index) {}
/**
 * @param {!GLenum} target
 * @param {?WebGLFramebuffer} framebuffer
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.bindFramebuffer = function(target,framebuffer) {}
/**
 * @param {!GLenum} cap
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.enable = function(cap) {}
/**
 * @param {?WebGLUniformLocation} location
 * @param {!Int32List} data
 * @param {!GLuint=} srcOffset
 * @param {!GLuint=} srcLength
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.uniform1iv = function(location,data,srcOffset,srcLength) {}
/**
 * @param {!GLint} s
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.clearStencil = function(s) {}
/**
 * @return {?WebGLTexture}
 * @nosideeffects
 */
WebGL2RenderingContext.prototype.createTexture = function() {}
/**
 * @param {!GLenum} target
 * @param {!GLint} level
 * @param {!GLint} xoffset
 * @param {!GLint} yoffset
 * @param {!GLint} x
 * @param {!GLint} y
 * @param {!GLsizei} width
 * @param {!GLsizei} height
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.copyTexSubImage2D = function(target,level,xoffset,yoffset,x,y,width,height) {}
/**
 * @param {!GLenum} pname
 * @return {*}
 * @nosideeffects
 */
WebGL2RenderingContext.prototype.getParameter = function(pname) {}
/**
 * @return {?WebGLFramebuffer}
 * @nosideeffects
 */
WebGL2RenderingContext.prototype.createFramebuffer = function() {}
/**
 * @param {!GLenum} target
 * @param {!GLint} level
 * @param {!GLenum} internalformat
 * @param {!GLint} x
 * @param {!GLint} y
 * @param {!GLsizei} width
 * @param {!GLsizei} height
 * @param {!GLint} border
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.copyTexImage2D = function(target,level,internalformat,x,y,width,height,border) {}
/**
 * @param {?WebGLFramebuffer} framebuffer
 * @return {!GLboolean}
 * @nosideeffects
 */
WebGL2RenderingContext.prototype.isFramebuffer = function(framebuffer) {}
/**
 * @param {!WebGLProgram} program
 * @return {?Array<!WebGLShader>}
 * @nosideeffects
 */
WebGL2RenderingContext.prototype.getAttachedShaders = function(program) {}
/**
 * @param {!GLuint} index
 * @param {!Float32List} values
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.vertexAttrib1fv = function(index,values) {}
/**
 * @param {!WebGLProgram} program
 * @param {!GLuint} index
 * @return {?WebGLActiveInfo}
 * @nosideeffects
 */
WebGL2RenderingContext.prototype.getTransformFeedbackVarying = function(program,index) {}
/**
 * @param {!GLuint} index
 * @param {!GLint} x
 * @param {!GLint} y
 * @param {!GLint} z
 * @param {!GLint} w
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.vertexAttribI4i = function(index,x,y,z,w) {}
/**
 * @param {!WebGLSync} sync
 * @param {!GLbitfield} flags
 * @param {!GLint64} timeout
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.waitSync = function(sync,flags,timeout) {}
/**
 * @param {?WebGLSampler} sampler
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.deleteSampler = function(sampler) {}
/**
 * @param {!GLint} srcX0
 * @param {!GLint} srcY0
 * @param {!GLint} srcX1
 * @param {!GLint} srcY1
 * @param {!GLint} dstX0
 * @param {!GLint} dstY0
 * @param {!GLint} dstX1
 * @param {!GLint} dstY1
 * @param {!GLbitfield} mask
 * @param {!GLenum} filter
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.blitFramebuffer = function(srcX0,srcY0,srcX1,srcY1,dstX0,dstY0,dstX1,dstY1,mask,filter) {}
/**
 * @param {?WebGLUniformLocation} location
 * @param {!Uint32List} data
 * @param {!GLuint=} srcOffset
 * @param {!GLuint=} srcLength
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.uniform4uiv = function(location,data,srcOffset,srcLength) {}
/**
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.endTransformFeedback = function() {}
/**
 * @param {!GLenum} target
 * @param {!Array<!GLenum>} attachments
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.invalidateFramebuffer = function(target,attachments) {}
/**
 * @param {!GLenum} buffer
 * @param {!GLint} drawbuffer
 * @param {!GLfloat} depth
 * @param {!GLint} stencil
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.clearBufferfi = function(buffer,drawbuffer,depth,stencil) {}
/**
 * @param {!GLenum} cap
 * @return {!GLboolean}
 * @nosideeffects
 */
WebGL2RenderingContext.prototype.isEnabled = function(cap) {}
/**
 * @param {!GLenum} buffer
 * @param {!GLint} drawbuffer
 * @param {!Float32List} values
 * @param {!GLuint=} srcOffset
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.clearBufferfv = function(buffer,drawbuffer,values,srcOffset) {}
/**
 * @param {!WebGLProgram} program
 * @return {?string}
 * @nosideeffects
 */
WebGL2RenderingContext.prototype.getProgramInfoLog = function(program) {}
/**
 * @param {!GLenum} target
 * @param {!GLint} level
 * @param {!GLint} xoffset
 * @param {!GLint} yoffset
 * @param {!GLint} zoffset
 * @param {!GLint} x
 * @param {!GLint} y
 * @param {!GLsizei} width
 * @param {!GLsizei} height
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.copyTexSubImage3D = function(target,level,xoffset,yoffset,zoffset,x,y,width,height) {}
/**
 * @param {!GLenum} func
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.depthFunc = function(func) {}
/**
 * @param {!GLenum} mode
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.cullFace = function(mode) {}
/**
 * @param {!WebGLProgram} program
 * @param {!string} name
 * @return {!GLint}
 * @nosideeffects
 */
WebGL2RenderingContext.prototype.getAttribLocation = function(program,name) {}
/**
 * @param {!GLuint} index
 * @param {!GLuint} x
 * @param {!GLuint} y
 * @param {!GLuint} z
 * @param {!GLuint} w
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.vertexAttribI4ui = function(index,x,y,z,w) {}
/**
 * @param {?WebGLSync} sync
 * @return {!GLboolean}
 */
WebGL2RenderingContext.prototype.isSync = function(sync) {}
/**
 * @param {!GLuint} index
 * @param {!GLint} size
 * @param {!GLenum} type
 * @param {!GLsizei} stride
 * @param {!GLintptr} offset
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.vertexAttribIPointer = function(index,size,type,stride,offset) {}
/**
 * @param {?WebGLUniformLocation} location
 * @param {!Uint32List} data
 * @param {!GLuint=} srcOffset
 * @param {!GLuint=} srcLength
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.uniform3uiv = function(location,data,srcOffset,srcLength) {}
/**
 * @param {!GLboolean} flag
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.depthMask = function(flag) {}
/**
 * @param {!GLenum} target
 * @param {!GLuint} index
 * @param {?WebGLBuffer} buffer
 * @param {!GLintptr} offset
 * @param {!GLsizeiptr} size
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.bindBufferRange = function(target,index,buffer,offset,size) {}
/**
 * @param {?WebGLUniformLocation} location
 * @param {!Int32List} data
 * @param {!GLuint=} srcOffset
 * @param {!GLuint=} srcLength
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.uniform2iv = function(location,data,srcOffset,srcLength) {}
/**
 * @param {!WebGLShader} shader
 * @return {?string}
 * @nosideeffects
 */
WebGL2RenderingContext.prototype.getShaderSource = function(shader) {}
/**
 * @param {!GLenum} arg0
 * @param {!GLint} arg1
 * @param {!GLint} arg2
 * @param {!GLint} arg3
 * @param {!GLsizei} arg4
 * @param {!GLsizei} arg5
 * @param {!GLenum} arg6
 * @param {(!GLsizei|!ArrayBufferView)} arg7
 * @param {(!GLintptr|!GLuint)=} arg8
 * @param {!GLuint=} arg9
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.compressedTexSubImage2D = function(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9) {}
/**
 * @param {!string} name
 * @return {?WebGLExtension}
 */
WebGL2RenderingContext.prototype.getExtension = function(name) {}
/**
 * @param {!GLenum} face
 * @param {!GLenum} fail
 * @param {!GLenum} zfail
 * @param {!GLenum} zpass
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.stencilOpSeparate = function(face,fail,zfail,zpass) {}
/**
 * @param {!GLenum} mode
 * @param {!GLint} first
 * @param {!GLsizei} count
 * @param {!GLsizei} instanceCount
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.drawArraysInstanced = function(mode,first,count,instanceCount) {}
/**
 * @param {!GLuint} index
 * @param {!Float32List} values
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.vertexAttrib2fv = function(index,values) {}
/**
 * @param {?WebGLShader} shader
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.deleteShader = function(shader) {}
/**
 * @param {!GLenum} cap
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.disable = function(cap) {}
/**
 * @param {!WebGLProgram} program
 * @param {!Array<!string>} varyings
 * @param {!GLenum} bufferMode
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.transformFeedbackVaryings = function(program,varyings,bufferMode) {}
/**
 * @param {!GLenum} target
 * @param {!GLsizei} samples
 * @param {!GLenum} internalformat
 * @param {!GLsizei} width
 * @param {!GLsizei} height
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.renderbufferStorageMultisample = function(target,samples,internalformat,width,height) {}
/**
 * @param {!GLenum} arg0
 * @param {!GLint} arg1
 * @param {!GLint} arg2
 * @param {!GLint} arg3
 * @param {!GLint} arg4
 * @param {!GLsizei} arg5
 * @param {!GLsizei} arg6
 * @param {!GLsizei} arg7
 * @param {!GLenum} arg8
 * @param {(!GLsizei|!ArrayBufferView)} arg9
 * @param {(!GLintptr|!GLuint)=} arg10
 * @param {!GLuint=} arg11
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.compressedTexSubImage3D = function(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11) {}
/**
 * @param {?WebGLUniformLocation} location
 * @param {!Float32List} data
 * @param {!GLuint=} srcOffset
 * @param {!GLuint=} srcLength
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.uniform1fv = function(location,data,srcOffset,srcLength) {}
/**
 * @param {?WebGLQuery} query
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.deleteQuery = function(query) {}
/**
 * @param {!GLint} x
 * @param {!GLint} y
 * @param {!GLsizei} width
 * @param {!GLsizei} height
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.scissor = function(x,y,width,height) {}
/**
 * @param {!GLenum} target
 * @param {!GLenum} pname
 * @return {*}
 * @nosideeffects
 */
WebGL2RenderingContext.prototype.getBufferParameter = function(target,pname) {}
/**
 * @param {!GLuint} index
 * @param {!GLuint} divisor
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.vertexAttribDivisor = function(index,divisor) {}
/**
 * @param {!WebGLProgram} program
 * @param {!GLuint} uniformBlockIndex
 * @param {!GLuint} uniformBlockBinding
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.uniformBlockBinding = function(program,uniformBlockIndex,uniformBlockBinding) {}
/**
 * @param {!GLenum} mode
 * @param {!GLuint} start
 * @param {!GLuint} end
 * @param {!GLsizei} count
 * @param {!GLenum} type
 * @param {!GLintptr} offset
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.drawRangeElements = function(mode,start,end,count,type,offset) {}
/**
 * @param {?WebGLUniformLocation} location
 * @param {!GLfloat} x
 * @param {!GLfloat} y
 * @param {!GLfloat} z
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.uniform3f = function(location,x,y,z) {}
/**
 * @param {!GLint} arg0
 * @param {!GLint} arg1
 * @param {!GLsizei} arg2
 * @param {!GLsizei} arg3
 * @param {!GLenum} arg4
 * @param {!GLenum} arg5
 * @param {(?ArrayBufferView|!GLintptr|!ArrayBufferView)} arg6
 * @param {!GLuint=} arg7
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.readPixels = function(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7) {}
/**
 * @param {?WebGLUniformLocation} location
 * @param {!GLint} x
 * @param {!GLint} y
 * @param {!GLint} z
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.uniform3i = function(location,x,y,z) {}
/**
 * @param {!GLenum} buffer
 * @param {!GLint} drawbuffer
 * @param {!Int32List} values
 * @param {!GLuint=} srcOffset
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.clearBufferiv = function(buffer,drawbuffer,values,srcOffset) {}
/**
 * @param {!GLenum} arg0
 * @param {(!GLsizeiptr|?BufferSource|!ArrayBufferView)} arg1
 * @param {!GLenum} arg2
 * @param {!GLuint=} arg3
 * @param {!GLuint=} arg4
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.bufferData = function(arg0,arg1,arg2,arg3,arg4) {}
/**
 * @param {?WebGLUniformLocation} location
 * @param {!Int32List} data
 * @param {!GLuint=} srcOffset
 * @param {!GLuint=} srcLength
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.uniform3iv = function(location,data,srcOffset,srcLength) {}
/**
 * @param {!GLenum} target
 * @param {?WebGLTexture} texture
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.bindTexture = function(target,texture) {}
/**
 * @param {?WebGLUniformLocation} location
 * @param {!GLuint} v0
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.uniform1ui = function(location,v0) {}
/**
 * @param {!WebGLProgram} program
 * @param {!string} name
 * @return {!GLint}
 * @nosideeffects
 */
WebGL2RenderingContext.prototype.getFragDataLocation = function(program,name) {}
/**
 * @param {?WebGLUniformLocation} location
 * @param {!GLfloat} x
 * @param {!GLfloat} y
 * @param {!GLfloat} z
 * @param {!GLfloat} w
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.uniform4f = function(location,x,y,z,w) {}
/**
 * @param {!GLenum} mode
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.frontFace = function(mode) {}
/**
 * @param {!GLenum} target
 * @param {!GLenum} pname
 * @return {*}
 * @nosideeffects
 */
WebGL2RenderingContext.prototype.getTexParameter = function(target,pname) {}
/**
 * @param {?WebGLUniformLocation} location
 * @param {!GLboolean} transpose
 * @param {!Float32List} data
 * @param {!GLuint=} srcOffset
 * @param {!GLuint=} srcLength
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.uniformMatrix4x3fv = function(location,transpose,data,srcOffset,srcLength) {}
/**
 * @param {?WebGLVertexArrayObject} vertexArray
 * @return {!GLboolean}
 */
WebGL2RenderingContext.prototype.isVertexArray = function(vertexArray) {}
/**
 * @param {!WebGLSync} sync
 * @param {!GLbitfield} flags
 * @param {!GLuint64} timeout
 * @return {!GLenum}
 */
WebGL2RenderingContext.prototype.clientWaitSync = function(sync,flags,timeout) {}
/**
 * @param {?WebGLTexture} texture
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.deleteTexture = function(texture) {}
/**
 * @param {?WebGLUniformLocation} location
 * @param {!Float32List} data
 * @param {!GLuint=} srcOffset
 * @param {!GLuint=} srcLength
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.uniform2fv = function(location,data,srcOffset,srcLength) {}
/**
 * @param {?WebGLUniformLocation} location
 * @param {!GLint} x
 * @param {!GLint} y
 * @param {!GLint} z
 * @param {!GLint} w
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.uniform4i = function(location,x,y,z,w) {}
/**
 * @param {?WebGLVertexArrayObject} array
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.bindVertexArray = function(array) {}
/**
 * @param {!GLenum} arg0
 * @param {!GLint} arg1
 * @param {!GLenum} arg2
 * @param {(!GLsizei|!GLenum)} arg3
 * @param {(!GLsizei|!GLenum)} arg4
 * @param {(!GLint|!TexImageSource)} arg5
 * @param {!GLenum=} arg6
 * @param {!GLenum=} arg7
 * @param {(?ArrayBufferView|!GLintptr|!TexImageSource|!ArrayBufferView)=} arg8
 * @param {!GLuint=} arg9
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.texImage2D = function(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9) {}
/**
 * @param {!GLenum} srcRGB
 * @param {!GLenum} dstRGB
 * @param {!GLenum} srcAlpha
 * @param {!GLenum} dstAlpha
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.blendFuncSeparate = function(srcRGB,dstRGB,srcAlpha,dstAlpha) {}
/**
 * @param {?WebGLSync} sync
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.deleteSync = function(sync) {}
/**
 * @param {!WebGLProgram} program
 * @param {!WebGLUniformLocation} location
 * @return {*}
 * @nosideeffects
 */
WebGL2RenderingContext.prototype.getUniform = function(program,location) {}
/**
 * @param {!GLenum} buffer
 * @param {!GLint} drawbuffer
 * @param {!Uint32List} values
 * @param {!GLuint=} srcOffset
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.clearBufferuiv = function(buffer,drawbuffer,values,srcOffset) {}
/**
 * @return {!Promise<undefined>}
 */
WebGL2RenderingContext.prototype.makeXRCompatible = function() {}
/**
 * @param {!GLclampf} red
 * @param {!GLclampf} green
 * @param {!GLclampf} blue
 * @param {!GLclampf} alpha
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.clearColor = function(red,green,blue,alpha) {}
/**
 * @param {?WebGLRenderbuffer} renderbuffer
 * @return {!GLboolean}
 * @nosideeffects
 */
WebGL2RenderingContext.prototype.isRenderbuffer = function(renderbuffer) {}
/**
 * @param {?WebGLTransformFeedback} tf
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.deleteTransformFeedback = function(tf) {}
/**
 * @param {?WebGLUniformLocation} location
 * @param {!GLint} x
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.uniform1i = function(location,x) {}
/**
 * @param {!GLclampf} red
 * @param {!GLclampf} green
 * @param {!GLclampf} blue
 * @param {!GLclampf} alpha
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.blendColor = function(red,green,blue,alpha) {}
/**
 * @param {!GLenum} target
 * @param {!GLenum} attachment
 * @param {?WebGLTexture} texture
 * @param {!GLint} level
 * @param {!GLint} layer
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.framebufferTextureLayer = function(target,attachment,texture,level,layer) {}
/**
 * @param {!GLuint} index
 * @param {!GLint} size
 * @param {!GLenum} type
 * @param {!GLboolean} normalized
 * @param {!GLsizei} stride
 * @param {!GLintptr} offset
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.vertexAttribPointer = function(index,size,type,normalized,stride,offset) {}
/**
 * @param {?WebGLUniformLocation} location
 * @param {!GLfloat} x
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.uniform1f = function(location,x) {}
/**
 * @param {?WebGLUniformLocation} location
 * @param {!Int32List} data
 * @param {!GLuint=} srcOffset
 * @param {!GLuint=} srcLength
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.uniform4iv = function(location,data,srcOffset,srcLength) {}
/**
 * @param {?WebGLUniformLocation} location
 * @param {!GLuint} v0
 * @param {!GLuint} v1
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.uniform2ui = function(location,v0,v1) {}
/**
 * @param {!WebGLProgram} program
 * @param {!GLuint} index
 * @return {?WebGLActiveInfo}
 * @nosideeffects
 */
WebGL2RenderingContext.prototype.getActiveUniform = function(program,index) {}
/**
 * @param {?WebGLSampler} sampler
 * @return {!GLboolean}
 */
WebGL2RenderingContext.prototype.isSampler = function(sampler) {}
/**
 * @param {!GLenum} arg0
 * @param {!GLint} arg1
 * @param {!GLint} arg2
 * @param {!GLsizei} arg3
 * @param {!GLsizei} arg4
 * @param {!GLsizei} arg5
 * @param {!GLint} arg6
 * @param {!GLenum} arg7
 * @param {!GLenum} arg8
 * @param {(!GLintptr|!TexImageSource|?ArrayBufferView|!ArrayBufferView)} arg9
 * @param {!GLuint=} arg10
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.texImage3D = function(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10) {}
/**
 * @param {!GLbitfield} mask
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.clear = function(mask) {}
/**
 * @param {!GLenum} sfactor
 * @param {!GLenum} dfactor
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.blendFunc = function(sfactor,dfactor) {}
/**
 * @param {!GLint} x
 * @param {!GLint} y
 * @param {!GLsizei} width
 * @param {!GLsizei} height
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.viewport = function(x,y,width,height) {}
/**
 * @param {!GLenum} target
 * @param {!GLuint} index
 * @param {?WebGLBuffer} buffer
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.bindBufferBase = function(target,index,buffer) {}
/**
 * @param {?WebGLUniformLocation} location
 * @param {!GLboolean} transpose
 * @param {!Float32List} data
 * @param {!GLuint=} srcOffset
 * @param {!GLuint=} srcLength
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.uniformMatrix4x2fv = function(location,transpose,data,srcOffset,srcLength) {}
/**
 * @param {?WebGLUniformLocation} location
 * @param {!GLboolean} transpose
 * @param {!Float32List} data
 * @param {!GLuint=} srcOffset
 * @param {!GLuint=} srcLength
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.uniformMatrix3x4fv = function(location,transpose,data,srcOffset,srcLength) {}
/**
 * @param {?WebGLUniformLocation} location
 * @param {!GLint} x
 * @param {!GLint} y
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.uniform2i = function(location,x,y) {}
/**
 * @param {?WebGLUniformLocation} location
 * @param {!Float32List} data
 * @param {!GLuint=} srcOffset
 * @param {!GLuint=} srcLength
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.uniform3fv = function(location,data,srcOffset,srcLength) {}
/**
 * @param {?WebGLUniformLocation} location
 * @param {!GLfloat} x
 * @param {!GLfloat} y
 * @return {undefined}
 */
WebGL2RenderingContext.prototype.uniform2f = function(location,x,y) {}
/**
 * @param {?WebGLShader} shader
 * @return {!GLboolean}
 * @nosideeffects
 */
WebGL2RenderingContext.prototype.isShader = function(shader) {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function GPUBuffer() {}
/** @type {?string} */ GPUBuffer.prototype.label;
/**
 * @param {!GPUFlagsConstant} mode
 * @param {!GPUSize64=} offset
 * @param {!GPUSize64=} size
 * @return {!Promise<undefined>}
 */
GPUBuffer.prototype.mapAsync = function(mode,offset,size) {}
/**
 * @return {undefined}
 */
GPUBuffer.prototype.unmap = function() {}
/**
 * @return {undefined}
 */
GPUBuffer.prototype.destroy = function() {}
/**
 * @param {!GPUSize64=} offset
 * @param {!GPUSize64=} size
 * @return {!ArrayBuffer}
 */
GPUBuffer.prototype.getMappedRange = function(offset,size) {}
/**
 * @constructor
 * @private
 * @extends {EventTarget}
 * @nosideeffects
 */
function SourceBufferList() {}
/** @type {!number} */ SourceBufferList.prototype.length;
/** @type {!NullableEventHandler} */ SourceBufferList.prototype.onaddsourcebuffer;
/** @type {!NullableEventHandler} */ SourceBufferList.prototype.onremovesourcebuffer;
/**
 * @constructor
 * @extends {Object}
 * @param {!RequestInfo} input
 * @param {!RequestInit=} init
 */
function Request(input,init) {}
/** @type {!string} */ Request.prototype.cache;
/** @type {!string} */ Request.prototype.credentials;
/** @type {!string} */ Request.prototype.destination;
/** @type {!Headers} */ Request.prototype.headers;
/** @type {!string} */ Request.prototype.integrity;
/** @type {!boolean} */ Request.prototype.isHistoryNavigation;
/** @type {!boolean} */ Request.prototype.isReloadNavigation;
/** @type {!boolean} */ Request.prototype.keepalive;
/** @type {!string} */ Request.prototype.method;
/** @type {!string} */ Request.prototype.mode;
/** @type {!string} */ Request.prototype.redirect;
/** @type {!string} */ Request.prototype.referrer;
/** @type {!string} */ Request.prototype.referrerPolicy;
/** @type {!AbortSignal} */ Request.prototype.signal;
/** @type {!string} */ Request.prototype.url;
/** @type {?ReadableStream} */ Request.prototype.body;
/** @type {!boolean} */ Request.prototype.bodyUsed;
/**
 * @return {!Promise<!Blob>}
 */
Request.prototype.blob = function() {}
/**
 * @return {!Promise<!ArrayBuffer>}
 */
Request.prototype.arrayBuffer = function() {}
/**
 * @return {!Request}
 */
Request.prototype.clone = function() {}
/**
 * @return {!Promise<*>}
 */
Request.prototype.json = function() {}
/**
 * @return {!Promise<!FormData>}
 */
Request.prototype.formData = function() {}
/**
 * @return {!Promise<!string>}
 */
Request.prototype.text = function() {}
/**
 * @constructor
 * @private
 * @extends {Node}
 * @nosideeffects
 */
function DocumentType() {}
/** @type {!string} */ DocumentType.prototype.name;
/** @type {!string} */ DocumentType.prototype.publicId;
/** @type {!string} */ DocumentType.prototype.systemId;
/**
 * @param {...(!Node|!string)} nodes
 * @return {undefined}
 */
DocumentType.prototype.before = function(nodes) {}
/**
 * @param {...(!Node|!string)} nodes
 * @return {undefined}
 */
DocumentType.prototype.after = function(nodes) {}
/**
 * @return {undefined}
 */
DocumentType.prototype.remove = function() {}
/**
 * @param {...(!Node|!string)} nodes
 * @return {undefined}
 */
DocumentType.prototype.replaceWith = function(nodes) {}
/**
 * @constructor
 * @private
 * @extends {HTMLElement}
 * @nosideeffects
 */
function HTMLSourceElement() {}
/** @type {!number} */ HTMLSourceElement.prototype.height;
/** @type {!string} */ HTMLSourceElement.prototype.media;
/** @type {!string} */ HTMLSourceElement.prototype.sizes;
/** @type {!string} */ HTMLSourceElement.prototype.src;
/** @type {!string} */ HTMLSourceElement.prototype.srcset;
/** @type {!string} */ HTMLSourceElement.prototype.type;
/** @type {!number} */ HTMLSourceElement.prototype.width;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function GPUSupportedLimits() {}
/** @type {!number} */ GPUSupportedLimits.prototype.maxBindGroups;
/** @type {!number} */ GPUSupportedLimits.prototype.maxComputePerDimensionDispatchSize;
/** @type {!number} */ GPUSupportedLimits.prototype.maxComputeWorkgroupInvocations;
/** @type {!GPUExtent3D} */ GPUSupportedLimits.prototype.maxComputeWorkgroupSize;
/** @type {!number} */ GPUSupportedLimits.prototype.maxComputeWorkgroupStorageSize;
/** @type {!number} */ GPUSupportedLimits.prototype.maxDynamicStorageBuffersPerPipelineLayout;
/** @type {!number} */ GPUSupportedLimits.prototype.maxDynamicUniformBuffersPerPipelineLayout;
/** @type {!number} */ GPUSupportedLimits.prototype.maxInterStageShaderComponents;
/** @type {!number} */ GPUSupportedLimits.prototype.maxSampledTexturesPerShaderStage;
/** @type {!number} */ GPUSupportedLimits.prototype.maxSamplersPerShaderStage;
/** @type {!number} */ GPUSupportedLimits.prototype.maxStorageBufferBindingSize;
/** @type {!number} */ GPUSupportedLimits.prototype.maxStorageBuffersPerShaderStage;
/** @type {!number} */ GPUSupportedLimits.prototype.maxStorageTexturesPerShaderStage;
/** @type {!number} */ GPUSupportedLimits.prototype.maxTextureArrayLayers;
/** @type {!number} */ GPUSupportedLimits.prototype.maxTextureDimension1D;
/** @type {!number} */ GPUSupportedLimits.prototype.maxTextureDimension2D;
/** @type {!number} */ GPUSupportedLimits.prototype.maxTextureDimension3D;
/** @type {!number} */ GPUSupportedLimits.prototype.maxUniformBufferBindingSize;
/** @type {!number} */ GPUSupportedLimits.prototype.maxUniformBuffersPerShaderStage;
/** @type {!number} */ GPUSupportedLimits.prototype.maxVertexAttributes;
/** @type {!number} */ GPUSupportedLimits.prototype.maxVertexBufferArrayStride;
/** @type {!number} */ GPUSupportedLimits.prototype.maxVertexBuffers;
/** @type {!number} */ GPUSupportedLimits.prototype.minStorageBufferOffsetAlignment;
/** @type {!number} */ GPUSupportedLimits.prototype.minUniformBufferOffsetAlignment;
/**
 * @constructor
 * @private
 * @extends {BaseAudioContext}
 * @nosideeffects
 */
function AudioContext() {}
/** @type {!number} */ AudioContext.prototype.baseLatency;
/** @type {!number} */ AudioContext.prototype.outputLatency;
/**
 * @return {!Promise<undefined>}
 */
AudioContext.prototype.suspend = function() {}
/**
 * @return {!Promise<undefined>}
 */
AudioContext.prototype.resume = function() {}
/**
 * @param {!MediaStreamTrack} mediaStreamTrack
 * @return {!MediaStreamTrackAudioSourceNode}
 */
AudioContext.prototype.createMediaStreamTrackSource = function(mediaStreamTrack) {}
/**
 * @param {!HTMLMediaElement} mediaElement
 * @return {!MediaElementAudioSourceNode}
 */
AudioContext.prototype.createMediaElementSource = function(mediaElement) {}
/**
 * @return {!MediaStreamAudioDestinationNode}
 */
AudioContext.prototype.createMediaStreamDestination = function() {}
/**
 * @return {!Promise<undefined>}
 */
AudioContext.prototype.close = function() {}
/**
 * @return {!AudioTimestamp}
 */
AudioContext.prototype.getOutputTimestamp = function() {}
/**
 * @param {!MediaStream} mediaStream
 * @return {!MediaStreamAudioSourceNode}
 */
AudioContext.prototype.createMediaStreamSource = function(mediaStream) {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function EXT_texture_norm16() {}
/** @const {!GLenum} */ EXT_texture_norm16.prototype.R16_EXT;
/** @const {!GLenum} */ EXT_texture_norm16.prototype.R16_SNORM_EXT;
/** @const {!GLenum} */ EXT_texture_norm16.prototype.RG16_EXT;
/** @const {!GLenum} */ EXT_texture_norm16.prototype.RG16_SNORM_EXT;
/** @const {!GLenum} */ EXT_texture_norm16.prototype.RGB16_EXT;
/** @const {!GLenum} */ EXT_texture_norm16.prototype.RGB16_SNORM_EXT;
/** @const {!GLenum} */ EXT_texture_norm16.prototype.RGBA16_EXT;
/** @const {!GLenum} */ EXT_texture_norm16.prototype.RGBA16_SNORM_EXT;
/**
 * @constructor
 * @extends {AudioNode}
 * @param {!BaseAudioContext} context
 * @param {!IIRFilterOptions} options
 */
function IIRFilterNode(context,options) {}
/**
 * @param {!Float32Array} frequencyHz
 * @param {!Float32Array} magResponse
 * @param {!Float32Array} phaseResponse
 * @return {undefined}
 */
IIRFilterNode.prototype.getFrequencyResponse = function(frequencyHz,magResponse,phaseResponse) {}
/**
 * @constructor
 * @extends {Credential}
 * @param {!FederatedCredentialInit} data
 */
function FederatedCredential(data) {}
/** @type {?string} */ FederatedCredential.prototype.protocol;
/** @type {!string} */ FederatedCredential.prototype.provider;
/** @type {!string} */ FederatedCredential.prototype.iconURL;
/** @type {!string} */ FederatedCredential.prototype.name;
/**
 * @constructor
 * @private
 * @extends {Worklet}
 * @nosideeffects
 */
function AudioWorklet() {}
/**
 * @constructor
 * @private
 * @extends {HTMLElement}
 * @nosideeffects
 */
function HTMLParagraphElement() {}
/** @type {!string} */ HTMLParagraphElement.prototype.align;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function ANGLE_instanced_arrays() {}
/** @const {!GLenum} */ ANGLE_instanced_arrays.prototype.VERTEX_ATTRIB_ARRAY_DIVISOR_ANGLE;
/**
 * @param {!GLuint} index
 * @param {!GLuint} divisor
 * @return {undefined}
 */
ANGLE_instanced_arrays.prototype.vertexAttribDivisorANGLE = function(index,divisor) {}
/**
 * @param {!GLenum} mode
 * @param {!GLint} first
 * @param {!GLsizei} count
 * @param {!GLsizei} primcount
 * @return {undefined}
 */
ANGLE_instanced_arrays.prototype.drawArraysInstancedANGLE = function(mode,first,count,primcount) {}
/**
 * @param {!GLenum} mode
 * @param {!GLsizei} count
 * @param {!GLenum} type
 * @param {!GLintptr} offset
 * @param {!GLsizei} primcount
 * @return {undefined}
 */
ANGLE_instanced_arrays.prototype.drawElementsInstancedANGLE = function(mode,count,type,offset,primcount) {}
/**
 * @constructor
 * @extends {EventTarget}
 * @param {!string} name
 */
function BroadcastChannel(name) {}
/** @type {!string} */ BroadcastChannel.prototype.name;
/** @type {?MessageEventHandler} */ BroadcastChannel.prototype.onmessage;
/** @type {?MessageEventHandler} */ BroadcastChannel.prototype.onmessageerror;
/**
 * @param {*} message
 * @return {undefined}
 */
BroadcastChannel.prototype.postMessage = function(message) {}
/**
 * @return {undefined}
 */
BroadcastChannel.prototype.close = function() {}
/**
 * @constructor
 * @private
 * @extends {SVGGraphicsElement}
 * @nosideeffects
 */
function SVGSwitchElement() {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function GPUQueue() {}
/** @type {?string} */ GPUQueue.prototype.label;
/**
 * @param {!GPUImageCopyExternalImage} source
 * @param {!GPUImageCopyTextureTagged} destination
 * @param {!GPUExtent3D} copySize
 * @return {undefined}
 */
GPUQueue.prototype.copyExternalImageToTexture = function(source,destination,copySize) {}
/**
 * @param {!Array<!GPUCommandBuffer>} commandBuffers
 * @return {undefined}
 */
GPUQueue.prototype.submit = function(commandBuffers) {}
/**
 * @param {!GPUImageCopyTexture} destination
 * @param {!BufferSource} data
 * @param {!GPUImageDataLayout} dataLayout
 * @param {!GPUExtent3D} size
 * @return {undefined}
 */
GPUQueue.prototype.writeTexture = function(destination,data,dataLayout,size) {}
/**
 * @param {!GPUBuffer} buffer
 * @param {!GPUSize64} bufferOffset
 * @param {!BufferSource} data
 * @param {!GPUSize64=} dataOffset
 * @param {!GPUSize64=} size
 * @return {undefined}
 */
GPUQueue.prototype.writeBuffer = function(buffer,bufferOffset,data,dataOffset,size) {}
/**
 * @return {!Promise<undefined>}
 */
GPUQueue.prototype.onSubmittedWorkDone = function() {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function OES_fbo_render_mipmap() {}
/**
 * @constructor
 * @private
 * @extends {Event}
 * @nosideeffects
 */
function BeforeUnloadEvent() {}
/** @type {!string} */ BeforeUnloadEvent.prototype.returnValue;
/**
 * @constructor
 * @private
 * @extends {SVGElement}
 * @nosideeffects
 */
function SVGFEImageElement() {}
/** @type {!SVGAnimatedString} */ SVGFEImageElement.prototype.crossOrigin;
/** @type {!SVGAnimatedPreserveAspectRatio} */ SVGFEImageElement.prototype.preserveAspectRatio;
/** @type {!SVGAnimatedString} */ SVGFEImageElement.prototype.href;
/** @type {!SVGAnimatedLength} */ SVGFEImageElement.prototype.height;
/** @type {!SVGAnimatedString} */ SVGFEImageElement.prototype.result;
/** @type {!SVGAnimatedLength} */ SVGFEImageElement.prototype.width;
/** @type {!SVGAnimatedLength} */ SVGFEImageElement.prototype.x;
/** @type {!SVGAnimatedLength} */ SVGFEImageElement.prototype.y;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function Location() {}
/** @type {!DOMStringList} */ Location.prototype.ancestorOrigins;
/** @type {!string} */ Location.prototype.origin;
/** @type {!string} */ Location.prototype.hash;
/** @type {!string} */ Location.prototype.host;
/** @type {!string} */ Location.prototype.hostname;
/** @type {!string} */ Location.prototype.pathname;
/** @type {!string} */ Location.prototype.port;
/** @type {!string} */ Location.prototype.protocol;
/** @type {!string} */ Location.prototype.search;
/** @type {!string} */ Location.prototype.href;
/**
 * @return {undefined}
 */
Location.prototype.reload = function() {}
/**
 * @param {!string} url
 * @return {undefined}
 */
Location.prototype.replace = function(url) {}
/**
 * @param {!string} url
 * @return {undefined}
 */
Location.prototype.assign = function(url) {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function SpeechGrammar() {}
/** @type {!string} */ SpeechGrammar.prototype.src;
/** @type {!number} */ SpeechGrammar.prototype.weight;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
WebAssembly.CompileError = function() {}
/**
 * @constructor
 * @private
 * @extends {EventTarget}
 * @nosideeffects
 */
function TextTrack() {}
/** @type {?TextTrackCueList} */ TextTrack.prototype.activeCues;
/** @type {?TextTrackCueList} */ TextTrack.prototype.cues;
/** @type {!string} */ TextTrack.prototype.id;
/** @type {!string} */ TextTrack.prototype.inBandMetadataTrackDispatchType;
/** @type {!string} */ TextTrack.prototype.kind;
/** @type {!string} */ TextTrack.prototype.label;
/** @type {!string} */ TextTrack.prototype.language;
/** @type {!string} */ TextTrack.prototype.mode;
/** @type {?EventHandler} */ TextTrack.prototype.oncuechange;
/** @type {?SourceBuffer} */ TextTrack.prototype.sourceBuffer;
/**
 * @param {!TextTrackCue} cue
 * @return {undefined}
 */
TextTrack.prototype.removeCue = function(cue) {}
/**
 * @param {!TextTrackCue} cue
 * @return {undefined}
 */
TextTrack.prototype.addCue = function(cue) {}
/**
 * @constructor
 * @private
 * @extends {EventTarget}
 * @nosideeffects
 */
function CSSPseudoElement() {}
/** @type {!Element} */ CSSPseudoElement.prototype.element;
/** @type {!CSSOMString} */ CSSPseudoElement.prototype.type;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function HTMLAllCollection() {}
/** @type {!number} */ HTMLAllCollection.prototype.length;
/**
 * @param {!string} name
 * @return {HTMLCollectionOrElementUnion}
 */
HTMLAllCollection.prototype.namedItem = function(name) {}
/**
 * @param {!string=} nameOrIndex
 * @return {HTMLCollectionOrElementUnion}
 */
HTMLAllCollection.prototype.item = function(nameOrIndex) {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function CryptoKey() {}
/** @type {!Object} */ CryptoKey.prototype.algorithm;
/** @type {!boolean} */ CryptoKey.prototype.extractable;
/** @type {!string} */ CryptoKey.prototype.type;
/** @type {!Object} */ CryptoKey.prototype.usages;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function GPUAdapter() {}
/** @type {!GPUSupportedFeatures} */ GPUAdapter.prototype.features;
/** @type {!boolean} */ GPUAdapter.prototype.isSoftware;
/** @type {!GPUSupportedLimits} */ GPUAdapter.prototype.limits;
/** @type {!string} */ GPUAdapter.prototype.name;
/**
 * @param {!GPUDeviceDescriptor=} descriptor
 * @return {!Promise<!GPUDevice>}
 */
GPUAdapter.prototype.requestDevice = function(descriptor) {}
/**
 * @constructor
 * @private
 * @extends {SVGGeometryElement}
 * @nosideeffects
 */
function SVGLineElement() {}
/** @type {!SVGAnimatedLength} */ SVGLineElement.prototype.x1;
/** @type {!SVGAnimatedLength} */ SVGLineElement.prototype.x2;
/** @type {!SVGAnimatedLength} */ SVGLineElement.prototype.y1;
/** @type {!SVGAnimatedLength} */ SVGLineElement.prototype.y2;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function GeolocationCoordinates() {}
/** @type {!number} */ GeolocationCoordinates.prototype.accuracy;
/** @type {?number} */ GeolocationCoordinates.prototype.altitude;
/** @type {?number} */ GeolocationCoordinates.prototype.altitudeAccuracy;
/** @type {?number} */ GeolocationCoordinates.prototype.heading;
/** @type {!number} */ GeolocationCoordinates.prototype.latitude;
/** @type {!number} */ GeolocationCoordinates.prototype.longitude;
/** @type {?number} */ GeolocationCoordinates.prototype.speed;
/**
 * @constructor
 * @extends {Object}
 * @param {!string} message
 */
function GPUValidationError(message) {}
/** @type {!string} */ GPUValidationError.prototype.message;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function DeviceMotionEventAcceleration() {}
/** @type {?number} */ DeviceMotionEventAcceleration.prototype.x;
/** @type {?number} */ DeviceMotionEventAcceleration.prototype.y;
/** @type {?number} */ DeviceMotionEventAcceleration.prototype.z;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function GPUCompilationMessage() {}
/** @type {!number} */ GPUCompilationMessage.prototype.length;
/** @type {!number} */ GPUCompilationMessage.prototype.lineNum;
/** @type {!number} */ GPUCompilationMessage.prototype.linePos;
/** @type {!string} */ GPUCompilationMessage.prototype.message;
/** @type {!number} */ GPUCompilationMessage.prototype.offset;
/** @type {!string} */ GPUCompilationMessage.prototype.type;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function SVGAnimatedNumber() {}
/** @type {!number} */ SVGAnimatedNumber.prototype.animVal;
/** @type {!number} */ SVGAnimatedNumber.prototype.baseVal;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function SVGStringList() {}
/** @type {!number} */ SVGStringList.prototype.length;
/** @type {!number} */ SVGStringList.prototype.numberOfItems;
/**
 * @param {!number} index
 * @return {!string}
 */
SVGStringList.prototype.removeItem = function(index) {}
/**
 * @param {!string} newItem
 * @param {!number} index
 * @return {!string}
 */
SVGStringList.prototype.insertItemBefore = function(newItem,index) {}
/**
 * @param {!string} newItem
 * @param {!number} index
 * @return {!string}
 */
SVGStringList.prototype.replaceItem = function(newItem,index) {}
/**
 * @return {undefined}
 */
SVGStringList.prototype.clear = function() {}
/**
 * @param {!number} index
 * @return {!string}
 */
SVGStringList.prototype.getItem = function(index) {}
/**
 * @param {!string} newItem
 * @return {!string}
 */
SVGStringList.prototype.initialize = function(newItem) {}
/**
 * @param {!string} newItem
 * @return {!string}
 */
SVGStringList.prototype.appendItem = function(newItem) {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @implements {Iterable<!Array<!UUID|!DataView>>}
 * @nosideeffects
 */
function BluetoothServiceDataMap() {}
/** @const {number} */ BluetoothServiceDataMap.prototype.size;
/**
 * @param {!UUID} key
 * @return {!boolean}
 * @nosideeffects
 */
BluetoothServiceDataMap.prototype.has = function(key) {}
/**
 * @param {!UUID} key
 * @return {!DataView}
 * @nosideeffects
 */
BluetoothServiceDataMap.prototype.get = function(key) {}
/**
 * @return {!Iterator<!UUID>}
 * @nosideeffects
 */
BluetoothServiceDataMap.prototype.keys = function() {}
/**
 * @return {!Iterator<!DataView>}
 * @nosideeffects
 */
BluetoothServiceDataMap.prototype.values = function() {}
/**
 * @return {!Iterator<!Array<!UUID|!DataView>>}
 * @nosideeffects
 */
BluetoothServiceDataMap.prototype.entries = function() {};
/**
 * @return {!Iterator<!Array<!UUID|!DataView>>}
 * @nosideeffects
 */
BluetoothServiceDataMap.prototype[Symbol.iterator] = function() {};
/**
 * @param {function(!DataView, !UUID, MAP)} callback
 * @this {MAP}
 * @template MAP
 */
BluetoothServiceDataMap.prototype.forEach = function(callback) {};
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function IDBCursor() {}
/** @type {!string} */ IDBCursor.prototype.direction;
/** @type {*} */ IDBCursor.prototype.key;
/** @type {*} */ IDBCursor.prototype.primaryKey;
/** @type {!IDBRequest} */ IDBCursor.prototype.request;
/** @type {IDBObjectStoreOrIDBIndexUnion} */ IDBCursor.prototype.source;
/**
 * @param {*=} key
 * @return {undefined}
 */
IDBCursor.prototype.continue = function(key) {}
/**
 * @param {*} value
 * @return {!IDBRequest}
 */
IDBCursor.prototype.update = function(value) {}
/**
 * @param {*} key
 * @param {*} primaryKey
 * @return {undefined}
 */
IDBCursor.prototype.continuePrimaryKey = function(key,primaryKey) {}
/**
 * @return {!IDBRequest}
 */
IDBCursor.prototype.delete = function() {}
/**
 * @param {!number} count
 * @return {undefined}
 */
IDBCursor.prototype.advance = function(count) {}
/**
 * @constructor
 * @private
 * @extends {EventTarget}
 * @nosideeffects
 */
function RTCSctpTransport() {}
/** @type {?number} */ RTCSctpTransport.prototype.maxChannels;
/** @type {!number} */ RTCSctpTransport.prototype.maxMessageSize;
/** @type {!string} */ RTCSctpTransport.prototype.state;
/** @type {!RTCDtlsTransport} */ RTCSctpTransport.prototype.transport;
/** @type {!NullableEventHandler} */ RTCSctpTransport.prototype.onstatechange;
/**
 * @constructor
 * @private
 * @extends {SVGElement}
 * @nosideeffects
 */
function SVGFEGaussianBlurElement() {}
/** @const {!number} */ SVGFEGaussianBlurElement.SVG_EDGEMODE_DUPLICATE;
/** @const {!number} */ SVGFEGaussianBlurElement.prototype.SVG_EDGEMODE_DUPLICATE;
/** @const {!number} */ SVGFEGaussianBlurElement.SVG_EDGEMODE_NONE;
/** @const {!number} */ SVGFEGaussianBlurElement.prototype.SVG_EDGEMODE_NONE;
/** @const {!number} */ SVGFEGaussianBlurElement.SVG_EDGEMODE_UNKNOWN;
/** @const {!number} */ SVGFEGaussianBlurElement.prototype.SVG_EDGEMODE_UNKNOWN;
/** @const {!number} */ SVGFEGaussianBlurElement.SVG_EDGEMODE_WRAP;
/** @const {!number} */ SVGFEGaussianBlurElement.prototype.SVG_EDGEMODE_WRAP;
/** @type {!SVGAnimatedEnumeration} */ SVGFEGaussianBlurElement.prototype.edgeMode;
/** @type {!SVGAnimatedString} */ SVGFEGaussianBlurElement.prototype.in1;
/** @type {!SVGAnimatedNumber} */ SVGFEGaussianBlurElement.prototype.stdDeviationX;
/** @type {!SVGAnimatedNumber} */ SVGFEGaussianBlurElement.prototype.stdDeviationY;
/** @type {!SVGAnimatedLength} */ SVGFEGaussianBlurElement.prototype.height;
/** @type {!SVGAnimatedString} */ SVGFEGaussianBlurElement.prototype.result;
/** @type {!SVGAnimatedLength} */ SVGFEGaussianBlurElement.prototype.width;
/** @type {!SVGAnimatedLength} */ SVGFEGaussianBlurElement.prototype.x;
/** @type {!SVGAnimatedLength} */ SVGFEGaussianBlurElement.prototype.y;
/**
 * @param {!number} stdDeviationX
 * @param {!number} stdDeviationY
 * @return {undefined}
 */
SVGFEGaussianBlurElement.prototype.setStdDeviation = function(stdDeviationX,stdDeviationY) {}
/**
 * @constructor
 * @private
 * @extends {HTMLElement}
 * @nosideeffects
 */
function HTMLTableElement() {}
/** @type {!HTMLCollection} */ HTMLTableElement.prototype.rows;
/** @type {!HTMLCollection} */ HTMLTableElement.prototype.tBodies;
/** @type {?HTMLTableCaptionElement} */ HTMLTableElement.prototype.caption;
/** @type {?HTMLTableSectionElement} */ HTMLTableElement.prototype.tFoot;
/** @type {?HTMLTableSectionElement} */ HTMLTableElement.prototype.tHead;
/** @type {!string} */ HTMLTableElement.prototype.align;
/** @type {!string} */ HTMLTableElement.prototype.bgColor;
/** @type {!string} */ HTMLTableElement.prototype.border;
/** @type {!string} */ HTMLTableElement.prototype.cellPadding;
/** @type {!string} */ HTMLTableElement.prototype.cellSpacing;
/** @type {!string} */ HTMLTableElement.prototype.frame;
/** @type {!string} */ HTMLTableElement.prototype.rules;
/** @type {!string} */ HTMLTableElement.prototype.summary;
/** @type {!string} */ HTMLTableElement.prototype.width;
/**
 * @return {undefined}
 */
HTMLTableElement.prototype.deleteCaption = function() {}
/**
 * @param {!number} index
 * @return {undefined}
 */
HTMLTableElement.prototype.deleteRow = function(index) {}
/**
 * @return {!HTMLTableSectionElement}
 */
HTMLTableElement.prototype.createTFoot = function() {}
/**
 * @param {!number=} index
 * @return {!HTMLTableRowElement}
 */
HTMLTableElement.prototype.insertRow = function(index) {}
/**
 * @return {undefined}
 */
HTMLTableElement.prototype.deleteTFoot = function() {}
/**
 * @return {!HTMLTableSectionElement}
 */
HTMLTableElement.prototype.createTBody = function() {}
/**
 * @return {undefined}
 */
HTMLTableElement.prototype.deleteTHead = function() {}
/**
 * @return {!HTMLTableCaptionElement}
 */
HTMLTableElement.prototype.createCaption = function() {}
/**
 * @return {!HTMLTableSectionElement}
 */
HTMLTableElement.prototype.createTHead = function() {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function OES_element_index_uint() {}
/**
 * @constructor
 * @extends {AudioNode}
 * @param {!BaseAudioContext} context
 * @param {!StereoPannerOptions=} options
 */
function StereoPannerNode(context,options) {}
/** @type {!AudioParam} */ StereoPannerNode.prototype.pan;
/**
 * @constructor
 * @extends {AudioScheduledSourceNode}
 * @param {!BaseAudioContext} context
 * @param {!ConstantSourceOptions=} options
 */
function ConstantSourceNode(context,options) {}
/** @type {!AudioParam} */ ConstantSourceNode.prototype.offset;
/**
 * @constructor
 * @private
 * @extends {EventTarget}
 * @nosideeffects
 */
function RTCIceTransport() {}
/** @type {!string} */ RTCIceTransport.prototype.component;
/** @type {!string} */ RTCIceTransport.prototype.gatheringState;
/** @type {!string} */ RTCIceTransport.prototype.role;
/** @type {!string} */ RTCIceTransport.prototype.state;
/** @type {?EventHandler} */ RTCIceTransport.prototype.ongatheringstatechange;
/** @type {?EventHandler} */ RTCIceTransport.prototype.onselectedcandidatepairchange;
/** @type {?EventHandler} */ RTCIceTransport.prototype.onstatechange;
/**
 * @return {?RTCIceParameters}
 */
RTCIceTransport.prototype.getLocalParameters = function() {}
/**
 * @return {!Array<!RTCIceCandidate>}
 */
RTCIceTransport.prototype.getLocalCandidates = function() {}
/**
 * @return {!Array<!RTCIceCandidate>}
 */
RTCIceTransport.prototype.getRemoteCandidates = function() {}
/**
 * @return {?RTCIceParameters}
 */
RTCIceTransport.prototype.getRemoteParameters = function() {}
/**
 * @return {?RTCIceCandidatePair}
 */
RTCIceTransport.prototype.getSelectedCandidatePair = function() {}
/**
 * @constructor
 * @private
 * @extends {EventTarget}
 * @nosideeffects
 */
function BluetoothDevice() {}
/** @type {?BluetoothRemoteGATTServer} */ BluetoothDevice.prototype.gatt;
/** @type {!string} */ BluetoothDevice.prototype.id;
/** @type {?string} */ BluetoothDevice.prototype.name;
/** @type {!boolean} */ BluetoothDevice.prototype.watchingAdvertisements;
/** @type {!NullableEventHandler} */ BluetoothDevice.prototype.onserviceadded;
/** @type {!NullableEventHandler} */ BluetoothDevice.prototype.onservicechanged;
/** @type {!NullableEventHandler} */ BluetoothDevice.prototype.onserviceremoved;
/** @type {!NullableEventHandler} */ BluetoothDevice.prototype.onadvertisementreceived;
/** @type {!NullableEventHandler} */ BluetoothDevice.prototype.ongattserverdisconnected;
/** @type {!NullableEventHandler} */ BluetoothDevice.prototype.oncharacteristicvaluechanged;
/**
 * @param {!WatchAdvertisementsOptions=} options
 * @return {!Promise<undefined>}
 */
BluetoothDevice.prototype.watchAdvertisements = function(options) {}
/**
 * @constructor
 * @private
 * @extends {Element}
 * @nosideeffects
 */
function HTMLElement() {}
/** @type {!string} */ HTMLElement.prototype.accessKeyLabel;
/** @type {!string} */ HTMLElement.prototype.accessKey;
/** @type {!string} */ HTMLElement.prototype.autocapitalize;
/** @type {!string} */ HTMLElement.prototype.dir;
/** @type {!boolean} */ HTMLElement.prototype.draggable;
/** @type {!boolean} */ HTMLElement.prototype.hidden;
/** @type {!string} */ HTMLElement.prototype.innerText;
/** @type {!string} */ HTMLElement.prototype.lang;
/** @type {!string} */ HTMLElement.prototype.outerText;
/** @type {!boolean} */ HTMLElement.prototype.spellcheck;
/** @type {!string} */ HTMLElement.prototype.title;
/** @type {!boolean} */ HTMLElement.prototype.translate;
/** @type {!number} */ HTMLElement.prototype.offsetHeight;
/** @type {!number} */ HTMLElement.prototype.offsetLeft;
/** @type {?Element} */ HTMLElement.prototype.offsetParent;
/** @type {!number} */ HTMLElement.prototype.offsetTop;
/** @type {!number} */ HTMLElement.prototype.offsetWidth;
/** @type {!CSSStyleDeclaration} */ HTMLElement.prototype.style;
/** @type {!NullableEventHandler} */ HTMLElement.prototype.onabort;
/** @type {?MouseEventHandler} */ HTMLElement.prototype.onauxclick;
/** @type {?FocusEventHandler} */ HTMLElement.prototype.onblur;
/** @type {?EventHandler} */ HTMLElement.prototype.oncancel;
/** @type {!NullableEventHandler} */ HTMLElement.prototype.oncanplay;
/** @type {!NullableEventHandler} */ HTMLElement.prototype.oncanplaythrough;
/** @type {?EventHandler} */ HTMLElement.prototype.onchange;
/** @type {?MouseEventHandler} */ HTMLElement.prototype.onclick;
/** @type {!NullableEventHandler} */ HTMLElement.prototype.onclose;
/** @type {?MouseEventHandler} */ HTMLElement.prototype.oncontextmenu;
/** @type {!NullableEventHandler} */ HTMLElement.prototype.oncuechange;
/** @type {?MouseEventHandler} */ HTMLElement.prototype.ondblclick;
/** @type {!NullableEventHandler} */ HTMLElement.prototype.ondrag;
/** @type {!NullableEventHandler} */ HTMLElement.prototype.ondragend;
/** @type {!NullableEventHandler} */ HTMLElement.prototype.ondragenter;
/** @type {!NullableEventHandler} */ HTMLElement.prototype.ondragleave;
/** @type {!NullableEventHandler} */ HTMLElement.prototype.ondragover;
/** @type {!NullableEventHandler} */ HTMLElement.prototype.ondragstart;
/** @type {!NullableEventHandler} */ HTMLElement.prototype.ondrop;
/** @type {!NullableEventHandler} */ HTMLElement.prototype.ondurationchange;
/** @type {!NullableEventHandler} */ HTMLElement.prototype.onemptied;
/** @type {!NullableEventHandler} */ HTMLElement.prototype.onended;
/** @type {!NullableOnErrorEventHandler} */ HTMLElement.prototype.onerror;
/** @type {?FocusEventHandler} */ HTMLElement.prototype.onfocus;
/** @type {!NullableEventHandler} */ HTMLElement.prototype.onformdata;
/** @type {?InputEventHandler} */ HTMLElement.prototype.oninput;
/** @type {?EventHandler} */ HTMLElement.prototype.oninvalid;
/** @type {!NullableEventHandler} */ HTMLElement.prototype.onkeydown;
/** @type {!NullableEventHandler} */ HTMLElement.prototype.onkeypress;
/** @type {!NullableEventHandler} */ HTMLElement.prototype.onkeyup;
/** @type {!NullableEventHandler} */ HTMLElement.prototype.onload;
/** @type {!NullableEventHandler} */ HTMLElement.prototype.onloadeddata;
/** @type {!NullableEventHandler} */ HTMLElement.prototype.onloadedmetadata;
/** @type {!NullableEventHandler} */ HTMLElement.prototype.onloadstart;
/** @type {?MouseEventHandler} */ HTMLElement.prototype.onmousedown;
/** @type {?MouseEventHandler} */ HTMLElement.prototype.onmouseenter;
/** @type {?MouseEventHandler} */ HTMLElement.prototype.onmouseleave;
/** @type {?MouseEventHandler} */ HTMLElement.prototype.onmousemove;
/** @type {?MouseEventHandler} */ HTMLElement.prototype.onmouseout;
/** @type {?MouseEventHandler} */ HTMLElement.prototype.onmouseover;
/** @type {?MouseEventHandler} */ HTMLElement.prototype.onmouseup;
/** @type {!NullableEventHandler} */ HTMLElement.prototype.onpause;
/** @type {!NullableEventHandler} */ HTMLElement.prototype.onplay;
/** @type {!NullableEventHandler} */ HTMLElement.prototype.onplaying;
/** @type {!NullableEventHandler} */ HTMLElement.prototype.onprogress;
/** @type {!NullableEventHandler} */ HTMLElement.prototype.onratechange;
/** @type {!NullableEventHandler} */ HTMLElement.prototype.onreset;
/** @type {!NullableEventHandler} */ HTMLElement.prototype.onresize;
/** @type {?EventHandler} */ HTMLElement.prototype.onscroll;
/** @type {!NullableEventHandler} */ HTMLElement.prototype.onsecuritypolicyviolation;
/** @type {!NullableEventHandler} */ HTMLElement.prototype.onseeked;
/** @type {!NullableEventHandler} */ HTMLElement.prototype.onseeking;
/** @type {!NullableEventHandler} */ HTMLElement.prototype.onselect;
/** @type {!NullableEventHandler} */ HTMLElement.prototype.onslotchange;
/** @type {!NullableEventHandler} */ HTMLElement.prototype.onstalled;
/** @type {!NullableEventHandler} */ HTMLElement.prototype.onsubmit;
/** @type {!NullableEventHandler} */ HTMLElement.prototype.onsuspend;
/** @type {!NullableEventHandler} */ HTMLElement.prototype.ontimeupdate;
/** @type {!NullableEventHandler} */ HTMLElement.prototype.ontoggle;
/** @type {!NullableEventHandler} */ HTMLElement.prototype.onvolumechange;
/** @type {!NullableEventHandler} */ HTMLElement.prototype.onwaiting;
/** @type {!NullableEventHandler} */ HTMLElement.prototype.onwebkitanimationend;
/** @type {!NullableEventHandler} */ HTMLElement.prototype.onwebkitanimationiteration;
/** @type {!NullableEventHandler} */ HTMLElement.prototype.onwebkitanimationstart;
/** @type {!NullableEventHandler} */ HTMLElement.prototype.onwebkittransitionend;
/** @type {?WheelEventHandler} */ HTMLElement.prototype.onwheel;
/** @type {?AnimationEventHandler} */ HTMLElement.prototype.onanimationcancel;
/** @type {?AnimationEventHandler} */ HTMLElement.prototype.onanimationend;
/** @type {?AnimationEventHandler} */ HTMLElement.prototype.onanimationiteration;
/** @type {?AnimationEventHandler} */ HTMLElement.prototype.onanimationstart;
/** @type {?TransitionEventHandler} */ HTMLElement.prototype.ontransitioncancel;
/** @type {?TransitionEventHandler} */ HTMLElement.prototype.ontransitionend;
/** @type {?TransitionEventHandler} */ HTMLElement.prototype.ontransitionrun;
/** @type {?TransitionEventHandler} */ HTMLElement.prototype.ontransitionstart;
/** @type {?PointerEventHandler} */ HTMLElement.prototype.ongotpointercapture;
/** @type {?PointerEventHandler} */ HTMLElement.prototype.onlostpointercapture;
/** @type {?PointerEventHandler} */ HTMLElement.prototype.onpointercancel;
/** @type {?PointerEventHandler} */ HTMLElement.prototype.onpointerdown;
/** @type {?PointerEventHandler} */ HTMLElement.prototype.onpointerenter;
/** @type {?PointerEventHandler} */ HTMLElement.prototype.onpointerleave;
/** @type {?PointerEventHandler} */ HTMLElement.prototype.onpointermove;
/** @type {?PointerEventHandler} */ HTMLElement.prototype.onpointerout;
/** @type {?PointerEventHandler} */ HTMLElement.prototype.onpointerover;
/** @type {?PointerEventHandler} */ HTMLElement.prototype.onpointerup;
/** @type {!NullableEventHandler} */ HTMLElement.prototype.onselectionchange;
/** @type {!NullableEventHandler} */ HTMLElement.prototype.onselectstart;
/** @type {?TouchEventHandler} */ HTMLElement.prototype.ontouchcancel;
/** @type {?TouchEventHandler} */ HTMLElement.prototype.ontouchend;
/** @type {?TouchEventHandler} */ HTMLElement.prototype.ontouchmove;
/** @type {?TouchEventHandler} */ HTMLElement.prototype.ontouchstart;
/** @type {!DOMStringMap} */ HTMLElement.prototype.dataset;
/** @type {!boolean} */ HTMLElement.prototype.autofocus;
/** @type {!string} */ HTMLElement.prototype.nonce;
/** @type {!number} */ HTMLElement.prototype.tabIndex;
/** @type {?ClipboardEventHandler} */ HTMLElement.prototype.oncopy;
/** @type {?ClipboardEventHandler} */ HTMLElement.prototype.oncut;
/** @type {?ClipboardEventHandler} */ HTMLElement.prototype.onpaste;
/** @type {!boolean} */ HTMLElement.prototype.isContentEditable;
/** @type {!string} */ HTMLElement.prototype.contentEditable;
/** @type {!string} */ HTMLElement.prototype.enterKeyHint;
/** @type {!string} */ HTMLElement.prototype.inputMode;
/**
 * @return {!ElementInternals}
 */
HTMLElement.prototype.attachInternals = function() {}
/**
 * @param {!FocusOptions=} options
 * @return {undefined}
 */
HTMLElement.prototype.focus = function(options) {}
/**
 * @return {undefined}
 */
HTMLElement.prototype.blur = function() {}
/**
 * @return {undefined}
 */
HTMLElement.prototype.click = function() {}
/**
 * @constructor
 * @extends {AudioNode}
 * @param {!BaseAudioContext} context
 * @param {!ChannelSplitterOptions=} options
 */
function ChannelSplitterNode(context,options) {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function SpeechSynthesisVoice() {}
/** @type {!boolean} */ SpeechSynthesisVoice.prototype.default;
/** @type {!string} */ SpeechSynthesisVoice.prototype.lang;
/** @type {!boolean} */ SpeechSynthesisVoice.prototype.localService;
/** @type {!string} */ SpeechSynthesisVoice.prototype.name;
/** @type {!string} */ SpeechSynthesisVoice.prototype.voiceURI;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @implements {Iterable<!Array<!number|!Node>>}
 * @nosideeffects
 */
function NodeList() {}
/** @type {!number} */ NodeList.prototype.length;
/**
 * @param {!number} index
 * @return {?Node}
 */
NodeList.prototype.item = function(index) {}
/**
 * @return {!Iterator<!number>}
 * @nosideeffects
 */
NodeList.prototype.keys = function() {}
/**
 * @return {!Iterator<!Node>}
 * @nosideeffects
 */
NodeList.prototype.values = function() {}
/**
 * @return {!Iterator<!Array<!number|!Node>>}
 * @nosideeffects
 */
NodeList.prototype.entries = function() {};
/**
 * @return {!Iterator<!Array<!number|!Node>>}
 * @nosideeffects
 */
NodeList.prototype[Symbol.iterator] = function() {};
/**
 * @param {function(!Node, !number, MAP)} callback
 * @this {MAP}
 * @template MAP
 */
NodeList.prototype.forEach = function(callback) {};
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function SyncManager() {}
/**
 * @return {!Promise<!Array<!string>>}
 */
SyncManager.prototype.getTags = function() {}
/**
 * @param {!string} tag
 * @return {!Promise<undefined>}
 */
SyncManager.prototype.register = function(tag) {}
/**
 * @constructor
 * @extends {Event}
 * @param {!string} type
 * @param {!XRReferenceSpaceEventInit} eventInitDict
 */
function XRReferenceSpaceEvent(type,eventInitDict) {}
/** @type {!XRReferenceSpace} */ XRReferenceSpaceEvent.prototype.referenceSpace;
/** @type {?XRRigidTransform} */ XRReferenceSpaceEvent.prototype.transform;
/**
 * @constructor
 * @extends {Object}
 * @param {!Object=} underlyingSink
 * @param {!QueuingStrategy=} strategy
 */
function WritableStream(underlyingSink,strategy) {}
/** @type {!boolean} */ WritableStream.prototype.locked;
/**
 * @param {*=} reason
 * @return {!Promise<undefined>}
 */
WritableStream.prototype.abort = function(reason) {}
/**
 * @return {!WritableStreamDefaultWriter}
 */
WritableStream.prototype.getWriter = function() {}
/**
 * @return {!Promise<undefined>}
 */
WritableStream.prototype.close = function() {}
/**
 * @constructor
 * @extends {Object}
 * @param {(!string|!Array<!number>)=} init
 */
function DOMMatrixReadOnly(init) {}
/** @type {!number} */ DOMMatrixReadOnly.prototype.a;
/** @type {!number} */ DOMMatrixReadOnly.prototype.b;
/** @type {!number} */ DOMMatrixReadOnly.prototype.c;
/** @type {!number} */ DOMMatrixReadOnly.prototype.d;
/** @type {!number} */ DOMMatrixReadOnly.prototype.e;
/** @type {!number} */ DOMMatrixReadOnly.prototype.f;
/** @type {!boolean} */ DOMMatrixReadOnly.prototype.is2D;
/** @type {!boolean} */ DOMMatrixReadOnly.prototype.isIdentity;
/** @type {!number} */ DOMMatrixReadOnly.prototype.m11;
/** @type {!number} */ DOMMatrixReadOnly.prototype.m12;
/** @type {!number} */ DOMMatrixReadOnly.prototype.m13;
/** @type {!number} */ DOMMatrixReadOnly.prototype.m14;
/** @type {!number} */ DOMMatrixReadOnly.prototype.m21;
/** @type {!number} */ DOMMatrixReadOnly.prototype.m22;
/** @type {!number} */ DOMMatrixReadOnly.prototype.m23;
/** @type {!number} */ DOMMatrixReadOnly.prototype.m24;
/** @type {!number} */ DOMMatrixReadOnly.prototype.m31;
/** @type {!number} */ DOMMatrixReadOnly.prototype.m32;
/** @type {!number} */ DOMMatrixReadOnly.prototype.m33;
/** @type {!number} */ DOMMatrixReadOnly.prototype.m34;
/** @type {!number} */ DOMMatrixReadOnly.prototype.m41;
/** @type {!number} */ DOMMatrixReadOnly.prototype.m42;
/** @type {!number} */ DOMMatrixReadOnly.prototype.m43;
/** @type {!number} */ DOMMatrixReadOnly.prototype.m44;
/**
 * @param {!number=} rotX
 * @param {!number=} rotY
 * @param {!number=} rotZ
 * @return {!DOMMatrix}
 */
DOMMatrixReadOnly.prototype.rotate = function(rotX,rotY,rotZ) {}
/**
 * @return {!DOMMatrix}
 */
DOMMatrixReadOnly.prototype.inverse = function() {}
/**
 * @param {!number=} scaleX
 * @param {!number=} scaleY
 * @return {!DOMMatrix}
 */
DOMMatrixReadOnly.prototype.scaleNonUniform = function(scaleX,scaleY) {}
/**
 * @param {!number=} x
 * @param {!number=} y
 * @return {!DOMMatrix}
 */
DOMMatrixReadOnly.prototype.rotateFromVector = function(x,y) {}
/**
 * @param {!number=} sx
 * @return {!DOMMatrix}
 */
DOMMatrixReadOnly.prototype.skewX = function(sx) {}
/**
 * @param {!number=} sy
 * @return {!DOMMatrix}
 */
DOMMatrixReadOnly.prototype.skewY = function(sy) {}
/**
 * @param {!number=} scaleX
 * @param {!number=} scaleY
 * @param {!number=} scaleZ
 * @param {!number=} originX
 * @param {!number=} originY
 * @param {!number=} originZ
 * @return {!DOMMatrix}
 */
DOMMatrixReadOnly.prototype.scale = function(scaleX,scaleY,scaleZ,originX,originY,originZ) {}
/**
 * @param {!number=} tx
 * @param {!number=} ty
 * @param {!number=} tz
 * @return {!DOMMatrix}
 */
DOMMatrixReadOnly.prototype.translate = function(tx,ty,tz) {}
/**
 * @return {!Object}
 * @override
 */
DOMMatrixReadOnly.prototype.toJSON = function() {}
/**
 * @param {!DOMMatrixInit=} other
 * @return {!DOMMatrixReadOnly}
 */
DOMMatrixReadOnly.fromMatrix = function(other) {}
/**
 * @param {!Float64Array} array64
 * @return {!DOMMatrixReadOnly}
 */
DOMMatrixReadOnly.fromFloat64Array = function(array64) {}
/**
 * @param {!Float32Array} array32
 * @return {!DOMMatrixReadOnly}
 */
DOMMatrixReadOnly.fromFloat32Array = function(array32) {}
/**
 * @param {!DOMPointInit=} point
 * @return {!DOMPoint}
 */
DOMMatrixReadOnly.prototype.transformPoint = function(point) {}
/**
 * @return {!Float64Array}
 */
DOMMatrixReadOnly.prototype.toFloat64Array = function() {}
/**
 * @return {!DOMMatrix}
 */
DOMMatrixReadOnly.prototype.flipX = function() {}
/**
 * @return {!Float32Array}
 */
DOMMatrixReadOnly.prototype.toFloat32Array = function() {}
/**
 * @param {!DOMMatrixInit=} other
 * @return {!DOMMatrix}
 */
DOMMatrixReadOnly.prototype.multiply = function(other) {}
/**
 * @return {!DOMMatrix}
 */
DOMMatrixReadOnly.prototype.flipY = function() {}
/**
 * @param {!number=} scale
 * @param {!number=} originX
 * @param {!number=} originY
 * @param {!number=} originZ
 * @return {!DOMMatrix}
 */
DOMMatrixReadOnly.prototype.scale3d = function(scale,originX,originY,originZ) {}
/**
 * @param {!number=} x
 * @param {!number=} y
 * @param {!number=} z
 * @param {!number=} angle
 * @return {!DOMMatrix}
 */
DOMMatrixReadOnly.prototype.rotateAxisAngle = function(x,y,z,angle) {}
/**
 * @constructor
 * @extends {AudioNode}
 * @param {!BaseAudioContext} context
 * @param {!BiquadFilterOptions=} options
 */
function BiquadFilterNode(context,options) {}
/** @type {!AudioParam} */ BiquadFilterNode.prototype.Q;
/** @type {!AudioParam} */ BiquadFilterNode.prototype.detune;
/** @type {!AudioParam} */ BiquadFilterNode.prototype.frequency;
/** @type {!AudioParam} */ BiquadFilterNode.prototype.gain;
/** @type {!string} */ BiquadFilterNode.prototype.type;
/**
 * @param {!Float32Array} frequencyHz
 * @param {!Float32Array} magResponse
 * @param {!Float32Array} phaseResponse
 * @return {undefined}
 */
BiquadFilterNode.prototype.getFrequencyResponse = function(frequencyHz,magResponse,phaseResponse) {}
/**
 * @constructor
 * @private
 * @extends {AudioNode}
 * @nosideeffects
 */
function ScriptProcessorNode() {}
/** @type {!number} */ ScriptProcessorNode.prototype.bufferSize;
/** @type {?AudioProcessingEventHandler} */ ScriptProcessorNode.prototype.onaudioprocess;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function NavigationPreloadManager() {}
/**
 * @return {!Promise<!NavigationPreloadState>}
 */
NavigationPreloadManager.prototype.getState = function() {}
/**
 * @return {!Promise<undefined>}
 */
NavigationPreloadManager.prototype.enable = function() {}
/**
 * @return {!Promise<undefined>}
 */
NavigationPreloadManager.prototype.disable = function() {}
/**
 * @param {!string} value
 * @return {!Promise<undefined>}
 */
NavigationPreloadManager.prototype.setHeaderValue = function(value) {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function GPUComputePassEncoder() {}
/** @type {?string} */ GPUComputePassEncoder.prototype.label;
/**
 * @param {!GPUComputePipeline} pipeline
 * @return {undefined}
 */
GPUComputePassEncoder.prototype.setPipeline = function(pipeline) {}
/**
 * @param {!GPUQuerySet} querySet
 * @param {!GPUSize32} queryIndex
 * @return {undefined}
 */
GPUComputePassEncoder.prototype.writeTimestamp = function(querySet,queryIndex) {}
/**
 * @param {!GPUSize32} x
 * @param {!GPUSize32=} y
 * @param {!GPUSize32=} z
 * @return {undefined}
 */
GPUComputePassEncoder.prototype.dispatch = function(x,y,z) {}
/**
 * @return {undefined}
 */
GPUComputePassEncoder.prototype.endPipelineStatisticsQuery = function() {}
/**
 * @param {!GPUQuerySet} querySet
 * @param {!GPUSize32} queryIndex
 * @return {undefined}
 */
GPUComputePassEncoder.prototype.beginPipelineStatisticsQuery = function(querySet,queryIndex) {}
/**
 * @param {!string} groupLabel
 * @return {undefined}
 */
GPUComputePassEncoder.prototype.pushDebugGroup = function(groupLabel) {}
/**
 * @return {undefined}
 */
GPUComputePassEncoder.prototype.popDebugGroup = function() {}
/**
 * @return {undefined}
 */
GPUComputePassEncoder.prototype.endPass = function() {}
/**
 * @param {!string} markerLabel
 * @return {undefined}
 */
GPUComputePassEncoder.prototype.insertDebugMarker = function(markerLabel) {}
/**
 * @param {!GPUIndex32} arg0
 * @param {!GPUBindGroup} arg1
 * @param {(!Array<!GPUBufferDynamicOffset>|!Uint32Array)=} arg2
 * @param {!GPUSize64=} arg3
 * @param {!GPUSize32=} arg4
 * @return {undefined}
 */
GPUComputePassEncoder.prototype.setBindGroup = function(arg0,arg1,arg2,arg3,arg4) {}
/**
 * @param {!GPUBuffer} indirectBuffer
 * @param {!GPUSize64} indirectOffset
 * @return {undefined}
 */
GPUComputePassEncoder.prototype.dispatchIndirect = function(indirectBuffer,indirectOffset) {}
/**
 * @constructor
 * @extends {EventTarget}
 * @param {(!MediaStream|!Array<!MediaStreamTrack>)=} arg0
 */
function MediaStream(arg0) {}
/** @type {!boolean} */ MediaStream.prototype.active;
/** @type {!string} */ MediaStream.prototype.id;
/** @type {?MediaStreamTrackEventHandler} */ MediaStream.prototype.onaddtrack;
/** @type {?MediaStreamTrackEventHandler} */ MediaStream.prototype.onremovetrack;
/**
 * @param {!MediaStreamTrack} track
 * @return {undefined}
 */
MediaStream.prototype.addTrack = function(track) {}
/**
 * @param {!string} trackId
 * @return {?MediaStreamTrack}
 */
MediaStream.prototype.getTrackById = function(trackId) {}
/**
 * @param {!MediaStreamTrack} track
 * @return {undefined}
 */
MediaStream.prototype.removeTrack = function(track) {}
/**
 * @return {!Array<!MediaStreamTrack>}
 */
MediaStream.prototype.getTracks = function() {}
/**
 * @return {!MediaStream}
 */
MediaStream.prototype.clone = function() {}
/**
 * @return {!Array<!MediaStreamTrack>}
 */
MediaStream.prototype.getAudioTracks = function() {}
/**
 * @return {!Array<!MediaStreamTrack>}
 */
MediaStream.prototype.getVideoTracks = function() {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @implements {Iterable<!Array<!string|!string>>}
 * @nosideeffects
 */
function RegExpGroups() {}
/** @const {number} */ RegExpGroups.prototype.size;
/**
 * @param {!string} key
 * @return {!boolean}
 * @nosideeffects
 */
RegExpGroups.prototype.has = function(key) {}
/**
 * @param {!string} key
 * @return {?string}
 * @nosideeffects
 */
RegExpGroups.prototype.get = function(key) {}
/**
 * @return {!Iterator<!string>}
 * @nosideeffects
 */
RegExpGroups.prototype.keys = function() {}
/**
 * @return {!Iterator<!string>}
 * @nosideeffects
 */
RegExpGroups.prototype.values = function() {}
/**
 * @return {!Iterator<!Array<!string|!string>>}
 * @nosideeffects
 */
RegExpGroups.prototype.entries = function() {};
/**
 * @return {!Iterator<!Array<!string|!string>>}
 * @nosideeffects
 */
RegExpGroups.prototype[Symbol.iterator] = function() {};
/**
 * @param {function(!string, !string, MAP)} callback
 * @this {MAP}
 * @template MAP
 */
RegExpGroups.prototype.forEach = function(callback) {};
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function WEBGL_multi_draw() {}
/**
 * @param {!GLenum} mode
 * @param {!Int32Array} countsList
 * @param {!GLuint} countsOffset
 * @param {!GLenum} type
 * @param {!Int32Array} offsetsList
 * @param {!GLuint} offsetsOffset
 * @param {!Int32Array} instanceCountsList
 * @param {!GLuint} instanceCountsOffset
 * @param {!GLsizei} drawcount
 * @return {undefined}
 */
WEBGL_multi_draw.prototype.multiDrawElementsInstancedWEBGL = function(mode,countsList,countsOffset,type,offsetsList,offsetsOffset,instanceCountsList,instanceCountsOffset,drawcount) {}
/**
 * @param {!GLenum} mode
 * @param {!Int32Array} countsList
 * @param {!GLuint} countsOffset
 * @param {!GLenum} type
 * @param {!Int32Array} offsetsList
 * @param {!GLuint} offsetsOffset
 * @param {!GLsizei} drawcount
 * @return {undefined}
 */
WEBGL_multi_draw.prototype.multiDrawElementsWEBGL = function(mode,countsList,countsOffset,type,offsetsList,offsetsOffset,drawcount) {}
/**
 * @param {!GLenum} mode
 * @param {!Int32Array} firstsList
 * @param {!GLuint} firstsOffset
 * @param {!Int32Array} countsList
 * @param {!GLuint} countsOffset
 * @param {!Int32Array} instanceCountsList
 * @param {!GLuint} instanceCountsOffset
 * @param {!GLsizei} drawcount
 * @return {undefined}
 */
WEBGL_multi_draw.prototype.multiDrawArraysInstancedWEBGL = function(mode,firstsList,firstsOffset,countsList,countsOffset,instanceCountsList,instanceCountsOffset,drawcount) {}
/**
 * @param {!GLenum} mode
 * @param {!Int32Array} firstsList
 * @param {!GLuint} firstsOffset
 * @param {!Int32Array} countsList
 * @param {!GLuint} countsOffset
 * @param {!GLsizei} drawcount
 * @return {undefined}
 */
WEBGL_multi_draw.prototype.multiDrawArraysWEBGL = function(mode,firstsList,firstsOffset,countsList,countsOffset,drawcount) {}
/**
 * @constructor
 * @private
 * @extends {HTMLElement}
 * @nosideeffects
 */
function HTMLTrackElement() {}
/** @const {!number} */ HTMLTrackElement.ERROR;
/** @const {!number} */ HTMLTrackElement.prototype.ERROR;
/** @const {!number} */ HTMLTrackElement.LOADED;
/** @const {!number} */ HTMLTrackElement.prototype.LOADED;
/** @const {!number} */ HTMLTrackElement.LOADING;
/** @const {!number} */ HTMLTrackElement.prototype.LOADING;
/** @const {!number} */ HTMLTrackElement.NONE;
/** @const {!number} */ HTMLTrackElement.prototype.NONE;
/** @type {!number} */ HTMLTrackElement.prototype.readyState;
/** @type {!TextTrack} */ HTMLTrackElement.prototype.track;
/** @type {!boolean} */ HTMLTrackElement.prototype.default;
/** @type {!string} */ HTMLTrackElement.prototype.kind;
/** @type {!string} */ HTMLTrackElement.prototype.label;
/** @type {!string} */ HTMLTrackElement.prototype.src;
/** @type {!string} */ HTMLTrackElement.prototype.srclang;
/**
 * @constructor
 * @private
 * @extends {EventTarget}
 * @nosideeffects
 */
function Performance() {}
/** @type {!DOMHighResTimeStamp} */ Performance.prototype.timeOrigin;
/** @type {!PerformanceNavigation} */ Performance.prototype.navigation;
/** @type {!PerformanceTiming} */ Performance.prototype.timing;
/** @type {?EventHandler} */ Performance.prototype.onresourcetimingbufferfull;
/**
 * @param {!string} name
 * @param {!string=} type
 * @return {!PerformanceEntryList}
 * @nosideeffects
 */
Performance.prototype.getEntriesByName = function(name,type) {}
/**
 * @return {!Object}
 * @override
 */
Performance.prototype.toJSON = function() {}
/**
 * @param {!string} measureName
 * @param {!string=} startMark
 * @param {!string=} endMark
 * @return {undefined}
 */
Performance.prototype.measure = function(measureName,startMark,endMark) {}
/**
 * @param {!number} maxSize
 * @return {undefined}
 */
Performance.prototype.setResourceTimingBufferSize = function(maxSize) {}
/**
 * @param {!string=} measureName
 * @return {undefined}
 */
Performance.prototype.clearMeasures = function(measureName) {}
/**
 * @param {!string=} markName
 * @return {undefined}
 */
Performance.prototype.clearMarks = function(markName) {}
/**
 * @return {!PerformanceEntryList}
 * @nosideeffects
 */
Performance.prototype.getEntries = function() {}
/**
 * @return {!DOMHighResTimeStamp}
 * @nosideeffects
 */
Performance.prototype.now = function() {}
/**
 * @param {!string} type
 * @return {!PerformanceEntryList}
 * @nosideeffects
 */
Performance.prototype.getEntriesByType = function(type) {}
/**
 * @return {undefined}
 */
Performance.prototype.clearResourceTimings = function() {}
/**
 * @param {!string} markName
 * @return {undefined}
 */
Performance.prototype.mark = function(markName) {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
WebAssembly.LinkError = function() {}
/**
 * @constructor
 * @extends {Object}
 * @param {!BufferSource} bytes
 */
WebAssembly.Module = function(bytes) {}
/**
 * @param {!WebAssembly.Module} moduleObject
 * @return {!Array<!ModuleImportDescriptor>}
 */
WebAssembly.Module.imports = function(moduleObject) {}
/**
 * @param {!WebAssembly.Module} moduleObject
 * @param {!string} sectionName
 * @return {!Array<!ArrayBuffer>}
 */
WebAssembly.Module.customSections = function(moduleObject,sectionName) {}
/**
 * @param {!WebAssembly.Module} moduleObject
 * @return {!Array<!ModuleExportDescriptor>}
 */
WebAssembly.Module.exports = function(moduleObject) {}
/**
 * @constructor
 * @extends {Event}
 * @param {!string} type
 * @param {!DeviceMotionEventInit=} eventInitDict
 */
function DeviceMotionEvent(type,eventInitDict) {}
/** @type {?DeviceMotionEventAcceleration} */ DeviceMotionEvent.prototype.acceleration;
/** @type {?DeviceMotionEventAcceleration} */ DeviceMotionEvent.prototype.accelerationIncludingGravity;
/** @type {!number} */ DeviceMotionEvent.prototype.interval;
/** @type {?DeviceMotionEventRotationRate} */ DeviceMotionEvent.prototype.rotationRate;
/**
 * @return {!Promise<!string>}
 */
DeviceMotionEvent.requestPermission = function() {}
/**
 * @constructor
 * @extends {Event}
 * @param {!string} type
 * @param {!PopStateEventInit=} eventInitDict
 */
function PopStateEvent(type,eventInitDict) {}
/** @type {*} */ PopStateEvent.prototype.state;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function WEBGL_lose_context() {}
/**
 * @return {undefined}
 */
WEBGL_lose_context.prototype.restoreContext = function() {}
/**
 * @return {undefined}
 */
WEBGL_lose_context.prototype.loseContext = function() {}
/**
 * @constructor
 * @private
 * @extends {SVGTextPositioningElement}
 * @nosideeffects
 */
function SVGTextElement() {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function ReadableStreamBYOBRequest() {}
/** @type {?ArrayBufferView} */ ReadableStreamBYOBRequest.prototype.view;
/**
 * @param {!ArrayBufferView} view
 * @return {undefined}
 */
ReadableStreamBYOBRequest.prototype.respondWithNewView = function(view) {}
/**
 * @param {!number} bytesWritten
 * @return {undefined}
 */
ReadableStreamBYOBRequest.prototype.respond = function(bytesWritten) {}
/**
 * @constructor
 * @extends {Object}
 * @param {!DOMPointInit=} position
 * @param {!DOMPointInit=} orientation
 */
function XRRigidTransform(position,orientation) {}
/** @type {!XRRigidTransform} */ XRRigidTransform.prototype.inverse;
/** @type {!Float32Array} */ XRRigidTransform.prototype.matrix;
/** @type {!DOMPointReadOnly} */ XRRigidTransform.prototype.orientation;
/** @type {!DOMPointReadOnly} */ XRRigidTransform.prototype.position;
/**
 * @constructor
 * @extends {Object}
 * @param {(!Path2D|!string)=} path
 */
function Path2D(path) {}
/**
 * @param {!number} x
 * @param {!number} y
 * @param {!number} w
 * @param {!number} h
 * @param {!Array<UnrestrictedDoubleOrDOMPointInitUnion>} radii
 * @return {undefined}
 */
Path2D.prototype.roundRect = function(x,y,w,h,radii) {}
/**
 * @param {!number} x
 * @param {!number} y
 * @param {!number} w
 * @param {!number} h
 * @return {undefined}
 */
Path2D.prototype.rect = function(x,y,w,h) {}
/**
 * @param {!number} x1
 * @param {!number} y1
 * @param {!number} x2
 * @param {!number} y2
 * @param {!number} radius
 * @return {undefined}
 */
Path2D.prototype.arcTo = function(x1,y1,x2,y2,radius) {}
/**
 * @param {!number} x
 * @param {!number} y
 * @param {!number} radius
 * @param {!number} startAngle
 * @param {!number} endAngle
 * @param {!boolean=} counterclockwise
 * @return {undefined}
 */
Path2D.prototype.arc = function(x,y,radius,startAngle,endAngle,counterclockwise) {}
/**
 * @return {undefined}
 */
Path2D.prototype.closePath = function() {}
/**
 * @param {!number} x
 * @param {!number} y
 * @return {undefined}
 */
Path2D.prototype.lineTo = function(x,y) {}
/**
 * @param {!number} x
 * @param {!number} y
 * @param {!number} radiusX
 * @param {!number} radiusY
 * @param {!number} rotation
 * @param {!number} startAngle
 * @param {!number} endAngle
 * @param {!boolean=} counterclockwise
 * @return {undefined}
 */
Path2D.prototype.ellipse = function(x,y,radiusX,radiusY,rotation,startAngle,endAngle,counterclockwise) {}
/**
 * @param {!number} cpx
 * @param {!number} cpy
 * @param {!number} x
 * @param {!number} y
 * @return {undefined}
 */
Path2D.prototype.quadraticCurveTo = function(cpx,cpy,x,y) {}
/**
 * @param {!number} cp1x
 * @param {!number} cp1y
 * @param {!number} cp2x
 * @param {!number} cp2y
 * @param {!number} x
 * @param {!number} y
 * @return {undefined}
 */
Path2D.prototype.bezierCurveTo = function(cp1x,cp1y,cp2x,cp2y,x,y) {}
/**
 * @param {!Path2D} path
 * @param {!DOMMatrix2DInit=} transform
 * @return {undefined}
 */
Path2D.prototype.addPath = function(path,transform) {}
/**
 * @param {!number} x
 * @param {!number} y
 * @return {undefined}
 */
Path2D.prototype.moveTo = function(x,y) {}
/**
 * @constructor
 * @extends {Object}
 */
function XPathEvaluator() {}
/**
 * @param {!Node} nodeResolver
 * @return {!XPathNSResolver}
 */
XPathEvaluator.prototype.createNSResolver = function(nodeResolver) {}
/**
 * @param {!string} expression
 * @param {!Node} contextNode
 * @param {?XPathNSResolver=} resolver
 * @param {!number=} type
 * @param {?XPathResult=} result
 * @return {!XPathResult}
 */
XPathEvaluator.prototype.evaluate = function(expression,contextNode,resolver,type,result) {}
/**
 * @param {!string} expression
 * @param {?XPathNSResolver=} resolver
 * @return {!XPathExpression}
 */
XPathEvaluator.prototype.createExpression = function(expression,resolver) {}
/**
 * @constructor
 * @extends {Object}
 * @param {!string} format
 */
function CompressionStream(format) {}
/** @type {!ReadableStream} */ CompressionStream.prototype.readable;
/** @type {!WritableStream} */ CompressionStream.prototype.writable;
/**
 * @constructor
 * @private
 * @extends {WebGLObject}
 * @nosideeffects
 */
function WebGLBuffer() {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @implements {Iterable<!Array<!BufferSource|!string>>}
 * @nosideeffects
 */
function MediaKeyStatusMap() {}
/** @type {!number} */ MediaKeyStatusMap.prototype.size;
/**
 * @param {!BufferSource} keyId
 * @return {*}
 */
MediaKeyStatusMap.prototype.get = function(keyId) {}
/**
 * @param {!BufferSource} keyId
 * @return {!boolean}
 */
MediaKeyStatusMap.prototype.has = function(keyId) {}
/**
 * @return {!Iterator<!BufferSource>}
 * @nosideeffects
 */
MediaKeyStatusMap.prototype.keys = function() {}
/**
 * @return {!Iterator<!string>}
 * @nosideeffects
 */
MediaKeyStatusMap.prototype.values = function() {}
/**
 * @return {!Iterator<!Array<!BufferSource|!string>>}
 * @nosideeffects
 */
MediaKeyStatusMap.prototype.entries = function() {};
/**
 * @return {!Iterator<!Array<!BufferSource|!string>>}
 * @nosideeffects
 */
MediaKeyStatusMap.prototype[Symbol.iterator] = function() {};
/**
 * @param {function(!string, !BufferSource, MAP)} callback
 * @this {MAP}
 * @template MAP
 */
MediaKeyStatusMap.prototype.forEach = function(callback) {};
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function GamepadPose() {}
/** @type {?Float32Array} */ GamepadPose.prototype.angularAcceleration;
/** @type {?Float32Array} */ GamepadPose.prototype.angularVelocity;
/** @type {!boolean} */ GamepadPose.prototype.hasOrientation;
/** @type {!boolean} */ GamepadPose.prototype.hasPosition;
/** @type {?Float32Array} */ GamepadPose.prototype.linearAcceleration;
/** @type {?Float32Array} */ GamepadPose.prototype.linearVelocity;
/** @type {?Float32Array} */ GamepadPose.prototype.orientation;
/** @type {?Float32Array} */ GamepadPose.prototype.position;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function PushManager() {}
/** @type {!Array<!string>} */ PushManager.supportedContentEncodings;
/**
 * @param {!PushSubscriptionOptionsInit=} options
 * @return {!Promise<!string>}
 */
PushManager.prototype.permissionState = function(options) {}
/**
 * @param {!PushSubscriptionOptionsInit=} options
 * @return {!Promise<!PushSubscription>}
 */
PushManager.prototype.subscribe = function(options) {}
/**
 * @return {!Promise<?PushSubscription>}
 */
PushManager.prototype.getSubscription = function() {}
/**
 * @constructor
 * @extends {DOMPointReadOnly}
 * @param {!number=} x
 * @param {!number=} y
 * @param {!number=} z
 * @param {!number=} w
 */
function DOMPoint(x,y,z,w) {}
/** @type {!number} */ DOMPoint.prototype.w;
/** @type {!number} */ DOMPoint.prototype.x;
/** @type {!number} */ DOMPoint.prototype.y;
/** @type {!number} */ DOMPoint.prototype.z;
/**
 * @param {!DOMPointInit=} other
 * @return {!DOMPoint}
 */
DOMPoint.fromPoint = function(other) {}
/**
 * @constructor
 * @extends {Object}
 * @param {!AudioBufferOptions} options
 */
function AudioBuffer(options) {}
/** @type {!number} */ AudioBuffer.prototype.duration;
/** @type {!number} */ AudioBuffer.prototype.length;
/** @type {!number} */ AudioBuffer.prototype.numberOfChannels;
/** @type {!number} */ AudioBuffer.prototype.sampleRate;
/**
 * @param {!number} channel
 * @return {!Float32Array}
 */
AudioBuffer.prototype.getChannelData = function(channel) {}
/**
 * @param {!Float32Array} source
 * @param {!number} channelNumber
 * @param {!number=} bufferOffset
 * @return {undefined}
 */
AudioBuffer.prototype.copyToChannel = function(source,channelNumber,bufferOffset) {}
/**
 * @param {!Float32Array} destination
 * @param {!number} channelNumber
 * @param {!number=} bufferOffset
 * @return {undefined}
 */
AudioBuffer.prototype.copyFromChannel = function(destination,channelNumber,bufferOffset) {}
/**
 * @constructor
 * @private
 * @extends {SVGElement}
 * @nosideeffects
 */
function SVGStopElement() {}
/** @type {!SVGAnimatedNumber} */ SVGStopElement.prototype.offset;
/**
 * @constructor
 * @private
 * @extends {SVGElement}
 * @nosideeffects
 */
function SVGViewElement() {}
/** @const {!number} */ SVGViewElement.SVG_ZOOMANDPAN_DISABLE;
/** @const {!number} */ SVGViewElement.prototype.SVG_ZOOMANDPAN_DISABLE;
/** @const {!number} */ SVGViewElement.SVG_ZOOMANDPAN_MAGNIFY;
/** @const {!number} */ SVGViewElement.prototype.SVG_ZOOMANDPAN_MAGNIFY;
/** @const {!number} */ SVGViewElement.SVG_ZOOMANDPAN_UNKNOWN;
/** @const {!number} */ SVGViewElement.prototype.SVG_ZOOMANDPAN_UNKNOWN;
/** @type {!SVGAnimatedPreserveAspectRatio} */ SVGViewElement.prototype.preserveAspectRatio;
/** @type {!SVGAnimatedRect} */ SVGViewElement.prototype.viewBox;
/** @type {!number} */ SVGViewElement.prototype.zoomAndPan;
/**
 * @constructor
 * @extends {Object}
 * @param {!TableDescriptor} descriptor
 */
WebAssembly.Table = function(descriptor) {}
/** @type {!number} */ WebAssembly.Table.prototype.length;
/**
 * @param {!number} index
 * @param {?Function} value
 * @return {undefined}
 */
WebAssembly.Table.prototype.set = function(index,value) {}
/**
 * @param {!number} delta
 * @return {!number}
 */
WebAssembly.Table.prototype.grow = function(delta) {}
/**
 * @param {!number} index
 * @return {?Function}
 */
WebAssembly.Table.prototype.get = function(index) {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function DOMStringList() {}
/** @type {!number} */ DOMStringList.prototype.length;
/**
 * @param {!number} index
 * @return {?string}
 * @nosideeffects
 */
DOMStringList.prototype.item = function(index) {}
/**
 * @param {!string} string
 * @return {!boolean}
 * @nosideeffects
 */
DOMStringList.prototype.contains = function(string) {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function SVGAnimatedString() {}
/** @type {!string} */ SVGAnimatedString.prototype.animVal;
/** @type {!string} */ SVGAnimatedString.prototype.baseVal;
/**
 * @constructor
 * @extends {Event}
 * @param {!string} type
 * @param {!BlobEventInit} eventInitDict
 */
function BlobEvent(type,eventInitDict) {}
/** @type {!Blob} */ BlobEvent.prototype.data;
/** @type {!DOMHighResTimeStamp} */ BlobEvent.prototype.timecode;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function AnimationEffect() {}
/**
 * @return {!EffectTiming}
 */
AnimationEffect.prototype.getTiming = function() {}
/**
 * @return {!ComputedEffectTiming}
 */
AnimationEffect.prototype.getComputedTiming = function() {}
/**
 * @param {!OptionalEffectTiming=} timing
 * @return {undefined}
 */
AnimationEffect.prototype.updateTiming = function(timing) {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function WebGLShaderPrecisionFormat() {}
/** @type {!GLint} */ WebGLShaderPrecisionFormat.prototype.precision;
/** @type {!GLint} */ WebGLShaderPrecisionFormat.prototype.rangeMax;
/** @type {!GLint} */ WebGLShaderPrecisionFormat.prototype.rangeMin;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function Worklet() {}
/**
 * @param {!string} moduleURL
 * @param {!WorkletOptions=} options
 * @return {!Promise<undefined>}
 */
Worklet.prototype.addModule = function(moduleURL,options) {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function SVGAnimatedAngle() {}
/** @type {!SVGAngle} */ SVGAnimatedAngle.prototype.animVal;
/** @type {!SVGAngle} */ SVGAnimatedAngle.prototype.baseVal;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function CSSStyleDeclaration() {}
/** @type {!number} */ CSSStyleDeclaration.prototype.length;
/** @type {?CSSRule} */ CSSStyleDeclaration.prototype.parentRule;
/** @type {!CSSOMString} */ CSSStyleDeclaration.prototype.cssFloat;
/** @type {!CSSOMString} */ CSSStyleDeclaration.prototype.cssText;
/**
 * @param {!number} index
 * @return {!CSSOMString}
 */
CSSStyleDeclaration.prototype.item = function(index) {}
/**
 * @param {!CSSOMString} property
 * @return {!CSSOMString}
 */
CSSStyleDeclaration.prototype.getPropertyValue = function(property) {}
/**
 * @param {!CSSOMString} property
 * @return {!CSSOMString}
 */
CSSStyleDeclaration.prototype.getPropertyPriority = function(property) {}
/**
 * @param {!CSSOMString} property
 * @param {!CSSOMString} value
 * @param {!CSSOMString=} priority
 * @return {undefined}
 */
CSSStyleDeclaration.prototype.setProperty = function(property,value,priority) {}
/**
 * @param {!CSSOMString} property
 * @return {!CSSOMString}
 */
CSSStyleDeclaration.prototype.removeProperty = function(property) {}
/**
 * @constructor
 * @extends {AudioNode}
 * @param {!AudioContext} context
 * @param {!AudioNodeOptions=} options
 */
function MediaStreamAudioDestinationNode(context,options) {}
/** @type {!MediaStream} */ MediaStreamAudioDestinationNode.prototype.stream;
/**
 * @constructor
 * @extends {EventTarget}
 * @nosideeffects
 * @param {!number} width
 * @param {!number} height
 */
function OffscreenCanvas(width,height) {}
/** @type {!number} */ OffscreenCanvas.prototype.height;
/** @type {!number} */ OffscreenCanvas.prototype.width;
/**
 * @param {!ImageEncodeOptions=} options
 * @return {!Promise<!Blob>}
 */
OffscreenCanvas.prototype.convertToBlob = function(options) {}
/**
 * @return {!ImageBitmap}
 */
OffscreenCanvas.prototype.transferToImageBitmap = function() {}
/**
 * @param {!string} contextId
 * @param {*=} options
 * @return {?OffscreenRenderingContext}
 */
OffscreenCanvas.prototype.getContext = function(contextId,options) {}
/**
 * @constructor
 * @private
 * @extends {SVGElement}
 * @nosideeffects
 */
function SVGScriptElement() {}
/** @type {?string} */ SVGScriptElement.prototype.crossOrigin;
/** @type {!string} */ SVGScriptElement.prototype.type;
/** @type {!SVGAnimatedString} */ SVGScriptElement.prototype.href;
/**
 * @constructor
 * @private
 * @extends {WebGLObject}
 * @nosideeffects
 */
function WebGLQuery() {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function TimeRanges() {}
/** @type {!number} */ TimeRanges.prototype.length;
/**
 * @param {!number} index
 * @return {!number}
 */
TimeRanges.prototype.start = function(index) {}
/**
 * @param {!number} index
 * @return {!number}
 */
TimeRanges.prototype.end = function(index) {}
/**
 * @constructor
 * @extends {Object}
 * @param {!EncodedAudioChunkInit} init
 */
function EncodedAudioChunk(init) {}
/** @type {!number} */ EncodedAudioChunk.prototype.byteLength;
/** @type {!number} */ EncodedAudioChunk.prototype.duration;
/** @type {!number} */ EncodedAudioChunk.prototype.timestamp;
/** @type {!string} */ EncodedAudioChunk.prototype.type;
/**
 * @param {!BufferSource} destination
 * @return {undefined}
 */
EncodedAudioChunk.prototype.copyTo = function(destination) {}
/**
 * @constructor
 * @private
 * @extends {HTMLElement}
 * @nosideeffects
 */
function HTMLScriptElement() {}
/** @type {!boolean} */ HTMLScriptElement.prototype.async;
/** @type {?string} */ HTMLScriptElement.prototype.crossOrigin;
/** @type {!boolean} */ HTMLScriptElement.prototype.defer;
/** @type {!string} */ HTMLScriptElement.prototype.integrity;
/** @type {!boolean} */ HTMLScriptElement.prototype.noModule;
/** @type {!string} */ HTMLScriptElement.prototype.referrerPolicy;
/** @type {!string} */ HTMLScriptElement.prototype.src;
/** @type {!string} */ HTMLScriptElement.prototype.text;
/** @type {!string} */ HTMLScriptElement.prototype.type;
/** @type {!string} */ HTMLScriptElement.prototype.charset;
/** @type {!string} */ HTMLScriptElement.prototype.event;
/** @type {!string} */ HTMLScriptElement.prototype.htmlFor;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function GPUPipelineLayout() {}
/** @type {?string} */ GPUPipelineLayout.prototype.label;
/**
 * @constructor
 * @extends {Object}
 * @param {!ReportingObserverCallback} callback
 * @param {!ReportingObserverOptions=} options
 */
function ReportingObserver(callback,options) {}
/**
 * @return {undefined}
 */
ReportingObserver.prototype.disconnect = function() {}
/**
 * @return {!ReportList}
 */
ReportingObserver.prototype.takeRecords = function() {}
/**
 * @return {undefined}
 */
ReportingObserver.prototype.observe = function() {}
/**
 * @constructor
 * @extends {Event}
 * @param {!string} type
 * @param {!ErrorEventInit=} eventInitDict
 */
function ErrorEvent(type,eventInitDict) {}
/** @type {!number} */ ErrorEvent.prototype.colno;
/** @type {*} */ ErrorEvent.prototype.error;
/** @type {!string} */ ErrorEvent.prototype.filename;
/** @type {!number} */ ErrorEvent.prototype.lineno;
/** @type {!string} */ ErrorEvent.prototype.message;
/**
 * @constructor
 * @private
 * @extends {WebGLObject}
 * @nosideeffects
 */
function WebGLProgram() {}
/**
 * @constructor
 * @extends {TextTrackCue}
 * @param {!number} startTime
 * @param {!number} endTime
 * @param {!string} text
 */
function VTTCue(startTime,endTime,text) {}
/** @type {!string} */ VTTCue.prototype.align;
/** @type {!LineAndPositionSetting} */ VTTCue.prototype.line;
/** @type {!string} */ VTTCue.prototype.lineAlign;
/** @type {!LineAndPositionSetting} */ VTTCue.prototype.position;
/** @type {!string} */ VTTCue.prototype.positionAlign;
/** @type {?VTTRegion} */ VTTCue.prototype.region;
/** @type {!number} */ VTTCue.prototype.size;
/** @type {!boolean} */ VTTCue.prototype.snapToLines;
/** @type {!string} */ VTTCue.prototype.text;
/** @type {!string} */ VTTCue.prototype.vertical;
/**
 * @return {!DocumentFragment}
 */
VTTCue.prototype.getCueAsHTML = function() {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function CustomElementRegistry() {}
/**
 * @param {!Node} root
 * @return {undefined}
 */
CustomElementRegistry.prototype.upgrade = function(root) {}
/**
 * @param {!string} name
 * @return {CustomElementConstructorOrUndefinedUnion}
 */
CustomElementRegistry.prototype.get = function(name) {}
/**
 * @param {!string} name
 * @param {!CustomElementConstructor} constructor
 * @param {!ElementDefinitionOptions=} options
 * @return {undefined}
 */
CustomElementRegistry.prototype.define = function(name,constructor,options) {}
/**
 * @param {!string} name
 * @return {!Promise<!CustomElementConstructor>}
 */
CustomElementRegistry.prototype.whenDefined = function(name) {}
/**
 * @constructor
 * @extends {Event}
 * @param {!string} type
 * @param {!PageTransitionEventInit=} eventInitDict
 */
function PageTransitionEvent(type,eventInitDict) {}
/** @type {!boolean} */ PageTransitionEvent.prototype.persisted;
/**
 * @constructor
 * @extends {Event}
 * @param {!string} type
 * @param {!WebGLContextEventInit=} eventInit
 */
function WebGLContextEvent(type,eventInit) {}
/** @type {!string} */ WebGLContextEvent.prototype.statusMessage;
/**
 * @constructor
 * @extends {Object}
 * @param {!string=} label
 * @param {!TextDecoderOptions=} options
 */
function TextDecoder(label,options) {}
/** @type {!string} */ TextDecoder.prototype.encoding;
/** @type {!boolean} */ TextDecoder.prototype.fatal;
/** @type {!boolean} */ TextDecoder.prototype.ignoreBOM;
/**
 * @param {!BufferSource=} input
 * @param {!TextDecodeOptions=} options
 * @return {!string}
 */
TextDecoder.prototype.decode = function(input,options) {}
/**
 * @constructor
 * @extends {Event}
 * @param {!string} type
 * @param {!RTCPeerConnectionIceEventInit=} eventInitDict
 */
function RTCPeerConnectionIceEvent(type,eventInitDict) {}
/** @type {?RTCIceCandidate} */ RTCPeerConnectionIceEvent.prototype.candidate;
/** @type {?string} */ RTCPeerConnectionIceEvent.prototype.url;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function DataTransferItem() {}
/** @type {!string} */ DataTransferItem.prototype.kind;
/** @type {!string} */ DataTransferItem.prototype.type;
/**
 * @return {?File}
 * @nosideeffects
 */
DataTransferItem.prototype.getAsFile = function() {}
/**
 * @param {?FunctionStringCallback} _callback
 * @return {undefined}
 */
DataTransferItem.prototype.getAsString = function(_callback) {}
/**
 * @constructor
 * @private
 * @extends {WebGLObject}
 * @nosideeffects
 */
function WebGLTexture() {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function WEBGL_compressed_texture_astc() {}
/** @const {!GLenum} */ WEBGL_compressed_texture_astc.prototype.COMPRESSED_RGBA_ASTC_10x10_KHR;
/** @const {!GLenum} */ WEBGL_compressed_texture_astc.prototype.COMPRESSED_RGBA_ASTC_10x5_KHR;
/** @const {!GLenum} */ WEBGL_compressed_texture_astc.prototype.COMPRESSED_RGBA_ASTC_10x6_KHR;
/** @const {!GLenum} */ WEBGL_compressed_texture_astc.prototype.COMPRESSED_RGBA_ASTC_10x8_KHR;
/** @const {!GLenum} */ WEBGL_compressed_texture_astc.prototype.COMPRESSED_RGBA_ASTC_12x10_KHR;
/** @const {!GLenum} */ WEBGL_compressed_texture_astc.prototype.COMPRESSED_RGBA_ASTC_12x12_KHR;
/** @const {!GLenum} */ WEBGL_compressed_texture_astc.prototype.COMPRESSED_RGBA_ASTC_4x4_KHR;
/** @const {!GLenum} */ WEBGL_compressed_texture_astc.prototype.COMPRESSED_RGBA_ASTC_5x4_KHR;
/** @const {!GLenum} */ WEBGL_compressed_texture_astc.prototype.COMPRESSED_RGBA_ASTC_5x5_KHR;
/** @const {!GLenum} */ WEBGL_compressed_texture_astc.prototype.COMPRESSED_RGBA_ASTC_6x5_KHR;
/** @const {!GLenum} */ WEBGL_compressed_texture_astc.prototype.COMPRESSED_RGBA_ASTC_6x6_KHR;
/** @const {!GLenum} */ WEBGL_compressed_texture_astc.prototype.COMPRESSED_RGBA_ASTC_8x5_KHR;
/** @const {!GLenum} */ WEBGL_compressed_texture_astc.prototype.COMPRESSED_RGBA_ASTC_8x6_KHR;
/** @const {!GLenum} */ WEBGL_compressed_texture_astc.prototype.COMPRESSED_RGBA_ASTC_8x8_KHR;
/** @const {!GLenum} */ WEBGL_compressed_texture_astc.prototype.COMPRESSED_SRGB8_ALPHA8_ASTC_10x10_KHR;
/** @const {!GLenum} */ WEBGL_compressed_texture_astc.prototype.COMPRESSED_SRGB8_ALPHA8_ASTC_10x5_KHR;
/** @const {!GLenum} */ WEBGL_compressed_texture_astc.prototype.COMPRESSED_SRGB8_ALPHA8_ASTC_10x6_KHR;
/** @const {!GLenum} */ WEBGL_compressed_texture_astc.prototype.COMPRESSED_SRGB8_ALPHA8_ASTC_10x8_KHR;
/** @const {!GLenum} */ WEBGL_compressed_texture_astc.prototype.COMPRESSED_SRGB8_ALPHA8_ASTC_12x10_KHR;
/** @const {!GLenum} */ WEBGL_compressed_texture_astc.prototype.COMPRESSED_SRGB8_ALPHA8_ASTC_12x12_KHR;
/** @const {!GLenum} */ WEBGL_compressed_texture_astc.prototype.COMPRESSED_SRGB8_ALPHA8_ASTC_4x4_KHR;
/** @const {!GLenum} */ WEBGL_compressed_texture_astc.prototype.COMPRESSED_SRGB8_ALPHA8_ASTC_5x4_KHR;
/** @const {!GLenum} */ WEBGL_compressed_texture_astc.prototype.COMPRESSED_SRGB8_ALPHA8_ASTC_5x5_KHR;
/** @const {!GLenum} */ WEBGL_compressed_texture_astc.prototype.COMPRESSED_SRGB8_ALPHA8_ASTC_6x5_KHR;
/** @const {!GLenum} */ WEBGL_compressed_texture_astc.prototype.COMPRESSED_SRGB8_ALPHA8_ASTC_6x6_KHR;
/** @const {!GLenum} */ WEBGL_compressed_texture_astc.prototype.COMPRESSED_SRGB8_ALPHA8_ASTC_8x5_KHR;
/** @const {!GLenum} */ WEBGL_compressed_texture_astc.prototype.COMPRESSED_SRGB8_ALPHA8_ASTC_8x6_KHR;
/** @const {!GLenum} */ WEBGL_compressed_texture_astc.prototype.COMPRESSED_SRGB8_ALPHA8_ASTC_8x8_KHR;
/**
 * @return {!Array<!string>}
 */
WEBGL_compressed_texture_astc.prototype.getSupportedProfiles = function() {}
/**
 * @constructor
 * @private
 * @extends {SVGGeometryElement}
 * @nosideeffects
 */
function SVGPolylineElement() {}
/** @type {!SVGPointList} */ SVGPolylineElement.prototype.animatedPoints;
/** @type {!SVGPointList} */ SVGPolylineElement.prototype.points;
/**
 * @constructor
 * @extends {Object}
 * @param {!BaseAudioContext} context
 * @param {!PeriodicWaveOptions=} options
 */
function PeriodicWave(context,options) {}
/**
 * @constructor
 * @private
 * @extends {CSSRule}
 * @nosideeffects
 */
function CSSKeyframesRule() {}
/** @type {!CSSRuleList} */ CSSKeyframesRule.prototype.cssRules;
/** @type {!CSSOMString} */ CSSKeyframesRule.prototype.name;
/**
 * @param {!CSSOMString} select
 * @return {?CSSKeyframeRule}
 */
CSSKeyframesRule.prototype.findRule = function(select) {}
/**
 * @param {!CSSOMString} select
 * @return {undefined}
 */
CSSKeyframesRule.prototype.deleteRule = function(select) {}
/**
 * @param {!CSSOMString} rule
 * @return {undefined}
 */
CSSKeyframesRule.prototype.appendRule = function(rule) {}
/**
 * @constructor
 * @private
 * @extends {SVGComponentTransferFunctionElement}
 * @nosideeffects
 */
function SVGFEFuncGElement() {}
/**
 * @constructor
 * @extends {UIEvent}
 * @param {!string} type
 * @param {!FocusEventInit=} eventInitDict
 */
function FocusEvent(type,eventInitDict) {}
/** @type {?EventTarget} */ FocusEvent.prototype.relatedTarget;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function CSSRuleList() {}
/** @type {!number} */ CSSRuleList.prototype.length;
/**
 * @param {!number} index
 * @return {?CSSRule}
 */
CSSRuleList.prototype.item = function(index) {}
/**
 * @constructor
 * @private
 * @extends {SVGComponentTransferFunctionElement}
 * @nosideeffects
 */
function SVGFEFuncRElement() {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function DOMRectList() {}
/** @type {!number} */ DOMRectList.prototype.length;
/**
 * @param {!number} index
 * @return {?DOMRect}
 */
DOMRectList.prototype.item = function(index) {}
/**
 * @constructor
 * @private
 * @extends {SVGElement}
 * @nosideeffects
 */
function SVGFEBlendElement() {}
/** @const {!number} */ SVGFEBlendElement.SVG_FEBLEND_MODE_COLOR;
/** @const {!number} */ SVGFEBlendElement.prototype.SVG_FEBLEND_MODE_COLOR;
/** @const {!number} */ SVGFEBlendElement.SVG_FEBLEND_MODE_COLOR_BURN;
/** @const {!number} */ SVGFEBlendElement.prototype.SVG_FEBLEND_MODE_COLOR_BURN;
/** @const {!number} */ SVGFEBlendElement.SVG_FEBLEND_MODE_COLOR_DODGE;
/** @const {!number} */ SVGFEBlendElement.prototype.SVG_FEBLEND_MODE_COLOR_DODGE;
/** @const {!number} */ SVGFEBlendElement.SVG_FEBLEND_MODE_DARKEN;
/** @const {!number} */ SVGFEBlendElement.prototype.SVG_FEBLEND_MODE_DARKEN;
/** @const {!number} */ SVGFEBlendElement.SVG_FEBLEND_MODE_DIFFERENCE;
/** @const {!number} */ SVGFEBlendElement.prototype.SVG_FEBLEND_MODE_DIFFERENCE;
/** @const {!number} */ SVGFEBlendElement.SVG_FEBLEND_MODE_EXCLUSION;
/** @const {!number} */ SVGFEBlendElement.prototype.SVG_FEBLEND_MODE_EXCLUSION;
/** @const {!number} */ SVGFEBlendElement.SVG_FEBLEND_MODE_HARD_LIGHT;
/** @const {!number} */ SVGFEBlendElement.prototype.SVG_FEBLEND_MODE_HARD_LIGHT;
/** @const {!number} */ SVGFEBlendElement.SVG_FEBLEND_MODE_HUE;
/** @const {!number} */ SVGFEBlendElement.prototype.SVG_FEBLEND_MODE_HUE;
/** @const {!number} */ SVGFEBlendElement.SVG_FEBLEND_MODE_LIGHTEN;
/** @const {!number} */ SVGFEBlendElement.prototype.SVG_FEBLEND_MODE_LIGHTEN;
/** @const {!number} */ SVGFEBlendElement.SVG_FEBLEND_MODE_LUMINOSITY;
/** @const {!number} */ SVGFEBlendElement.prototype.SVG_FEBLEND_MODE_LUMINOSITY;
/** @const {!number} */ SVGFEBlendElement.SVG_FEBLEND_MODE_MULTIPLY;
/** @const {!number} */ SVGFEBlendElement.prototype.SVG_FEBLEND_MODE_MULTIPLY;
/** @const {!number} */ SVGFEBlendElement.SVG_FEBLEND_MODE_NORMAL;
/** @const {!number} */ SVGFEBlendElement.prototype.SVG_FEBLEND_MODE_NORMAL;
/** @const {!number} */ SVGFEBlendElement.SVG_FEBLEND_MODE_OVERLAY;
/** @const {!number} */ SVGFEBlendElement.prototype.SVG_FEBLEND_MODE_OVERLAY;
/** @const {!number} */ SVGFEBlendElement.SVG_FEBLEND_MODE_SATURATION;
/** @const {!number} */ SVGFEBlendElement.prototype.SVG_FEBLEND_MODE_SATURATION;
/** @const {!number} */ SVGFEBlendElement.SVG_FEBLEND_MODE_SCREEN;
/** @const {!number} */ SVGFEBlendElement.prototype.SVG_FEBLEND_MODE_SCREEN;
/** @const {!number} */ SVGFEBlendElement.SVG_FEBLEND_MODE_SOFT_LIGHT;
/** @const {!number} */ SVGFEBlendElement.prototype.SVG_FEBLEND_MODE_SOFT_LIGHT;
/** @const {!number} */ SVGFEBlendElement.SVG_FEBLEND_MODE_UNKNOWN;
/** @const {!number} */ SVGFEBlendElement.prototype.SVG_FEBLEND_MODE_UNKNOWN;
/** @type {!SVGAnimatedString} */ SVGFEBlendElement.prototype.in1;
/** @type {!SVGAnimatedString} */ SVGFEBlendElement.prototype.in2;
/** @type {!SVGAnimatedEnumeration} */ SVGFEBlendElement.prototype.mode;
/** @type {!SVGAnimatedLength} */ SVGFEBlendElement.prototype.height;
/** @type {!SVGAnimatedString} */ SVGFEBlendElement.prototype.result;
/** @type {!SVGAnimatedLength} */ SVGFEBlendElement.prototype.width;
/** @type {!SVGAnimatedLength} */ SVGFEBlendElement.prototype.x;
/** @type {!SVGAnimatedLength} */ SVGFEBlendElement.prototype.y;
/**
 * @constructor
 * @private
 * @extends {HTMLElement}
 * @nosideeffects
 */
function HTMLParamElement() {}
/** @type {!string} */ HTMLParamElement.prototype.name;
/** @type {!string} */ HTMLParamElement.prototype.value;
/** @type {!string} */ HTMLParamElement.prototype.type;
/** @type {!string} */ HTMLParamElement.prototype.valueType;
/**
 * @constructor
 * @private
 * @extends {SVGGeometryElement}
 * @nosideeffects
 */
function SVGRectElement() {}
/** @type {!SVGAnimatedLength} */ SVGRectElement.prototype.height;
/** @type {!SVGAnimatedLength} */ SVGRectElement.prototype.rx;
/** @type {!SVGAnimatedLength} */ SVGRectElement.prototype.ry;
/** @type {!SVGAnimatedLength} */ SVGRectElement.prototype.width;
/** @type {!SVGAnimatedLength} */ SVGRectElement.prototype.x;
/** @type {!SVGAnimatedLength} */ SVGRectElement.prototype.y;
/**
 * @constructor
 * @extends {AudioNode}
 * @param {!BaseAudioContext} context
 * @param {!AnalyserOptions=} options
 */
function AnalyserNode(context,options) {}
/** @type {!number} */ AnalyserNode.prototype.frequencyBinCount;
/** @type {!number} */ AnalyserNode.prototype.fftSize;
/** @type {!number} */ AnalyserNode.prototype.maxDecibels;
/** @type {!number} */ AnalyserNode.prototype.minDecibels;
/** @type {!number} */ AnalyserNode.prototype.smoothingTimeConstant;
/**
 * @param {!Float32Array} array
 * @return {undefined}
 */
AnalyserNode.prototype.getFloatFrequencyData = function(array) {}
/**
 * @param {!Uint8Array} array
 * @return {undefined}
 */
AnalyserNode.prototype.getByteTimeDomainData = function(array) {}
/**
 * @param {!Uint8Array} array
 * @return {undefined}
 */
AnalyserNode.prototype.getByteFrequencyData = function(array) {}
/**
 * @param {!Float32Array} array
 * @return {undefined}
 */
AnalyserNode.prototype.getFloatTimeDomainData = function(array) {}
/**
 * @constructor
 * @extends {Event}
 * @param {!string} type
 * @param {!RTCTrackEventInit} eventInitDict
 */
function RTCTrackEvent(type,eventInitDict) {}
/** @type {!RTCRtpReceiver} */ RTCTrackEvent.prototype.receiver;
/** @type {!Array<!MediaStream>} */ RTCTrackEvent.prototype.streams;
/** @type {!MediaStreamTrack} */ RTCTrackEvent.prototype.track;
/** @type {!RTCRtpTransceiver} */ RTCTrackEvent.prototype.transceiver;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function WEBGL_compressed_texture_s3tc_srgb() {}
/** @const {!GLenum} */ WEBGL_compressed_texture_s3tc_srgb.prototype.COMPRESSED_SRGB_ALPHA_S3TC_DXT1_EXT;
/** @const {!GLenum} */ WEBGL_compressed_texture_s3tc_srgb.prototype.COMPRESSED_SRGB_ALPHA_S3TC_DXT3_EXT;
/** @const {!GLenum} */ WEBGL_compressed_texture_s3tc_srgb.prototype.COMPRESSED_SRGB_ALPHA_S3TC_DXT5_EXT;
/** @const {!GLenum} */ WEBGL_compressed_texture_s3tc_srgb.prototype.COMPRESSED_SRGB_S3TC_DXT1_EXT;
/**
 * @constructor
 * @private
 * @extends {EventTarget}
 * @nosideeffects
 */
function MediaDevices() {}
/** @type {!NullableEventHandler} */ MediaDevices.prototype.ondevicechange;
/**
 * @param {!MediaStreamConstraints=} constraints
 * @return {!Promise<!MediaStream>}
 */
MediaDevices.prototype.getUserMedia = function(constraints) {}
/**
 * @param {!DisplayMediaStreamConstraints=} constraints
 * @return {!Promise<!MediaStream>}
 */
MediaDevices.prototype.getDisplayMedia = function(constraints) {}
/**
 * @return {!Promise<!Array<!MediaDeviceInfo>>}
 */
MediaDevices.prototype.enumerateDevices = function() {}
/**
 * @return {!MediaTrackSupportedConstraints}
 */
MediaDevices.prototype.getSupportedConstraints = function() {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function SVGAnimatedEnumeration() {}
/** @type {!number} */ SVGAnimatedEnumeration.prototype.animVal;
/** @type {!number} */ SVGAnimatedEnumeration.prototype.baseVal;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function XRViewport() {}
/** @type {!number} */ XRViewport.prototype.height;
/** @type {!number} */ XRViewport.prototype.width;
/** @type {!number} */ XRViewport.prototype.x;
/** @type {!number} */ XRViewport.prototype.y;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function EXT_color_buffer_float() {}
/**
 * @constructor
 * @private
 * @extends {HTMLElement}
 * @nosideeffects
 */
function HTMLTableCellElement() {}
/** @type {!number} */ HTMLTableCellElement.prototype.cellIndex;
/** @type {!string} */ HTMLTableCellElement.prototype.abbr;
/** @type {!number} */ HTMLTableCellElement.prototype.colSpan;
/** @type {!string} */ HTMLTableCellElement.prototype.headers;
/** @type {!number} */ HTMLTableCellElement.prototype.rowSpan;
/** @type {!string} */ HTMLTableCellElement.prototype.scope;
/** @type {!string} */ HTMLTableCellElement.prototype.align;
/** @type {!string} */ HTMLTableCellElement.prototype.axis;
/** @type {!string} */ HTMLTableCellElement.prototype.bgColor;
/** @type {!string} */ HTMLTableCellElement.prototype.ch;
/** @type {!string} */ HTMLTableCellElement.prototype.chOff;
/** @type {!string} */ HTMLTableCellElement.prototype.height;
/** @type {!boolean} */ HTMLTableCellElement.prototype.noWrap;
/** @type {!string} */ HTMLTableCellElement.prototype.vAlign;
/** @type {!string} */ HTMLTableCellElement.prototype.width;
/**
 * @constructor
 * @extends {Object}
 * @param {!VideoDecoderInit} init
 */
function VideoDecoder(init) {}
/** @type {!number} */ VideoDecoder.prototype.decodeQueueSize;
/** @type {!string} */ VideoDecoder.prototype.state;
/**
 * @return {!Promise<undefined>}
 */
VideoDecoder.prototype.flush = function() {}
/**
 * @return {undefined}
 */
VideoDecoder.prototype.reset = function() {}
/**
 * @param {!VideoDecoderConfig} config
 * @return {undefined}
 */
VideoDecoder.prototype.configure = function(config) {}
/**
 * @param {!EncodedVideoChunk} chunk
 * @return {undefined}
 */
VideoDecoder.prototype.decode = function(chunk) {}
/**
 * @return {undefined}
 */
VideoDecoder.prototype.close = function() {}
/**
 * @param {!VideoDecoderConfig} config
 * @return {!Promise<!VideoDecoderSupport>}
 */
VideoDecoder.isConfigSupported = function(config) {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function SVGLengthList() {}
/** @type {!number} */ SVGLengthList.prototype.length;
/** @type {!number} */ SVGLengthList.prototype.numberOfItems;
/**
 * @param {!number} index
 * @return {!SVGLength}
 */
SVGLengthList.prototype.removeItem = function(index) {}
/**
 * @param {!SVGLength} newItem
 * @param {!number} index
 * @return {!SVGLength}
 */
SVGLengthList.prototype.insertItemBefore = function(newItem,index) {}
/**
 * @param {!SVGLength} newItem
 * @param {!number} index
 * @return {!SVGLength}
 */
SVGLengthList.prototype.replaceItem = function(newItem,index) {}
/**
 * @return {undefined}
 */
SVGLengthList.prototype.clear = function() {}
/**
 * @param {!number} index
 * @return {!SVGLength}
 */
SVGLengthList.prototype.getItem = function(index) {}
/**
 * @param {!SVGLength} newItem
 * @return {!SVGLength}
 */
SVGLengthList.prototype.initialize = function(newItem) {}
/**
 * @param {!SVGLength} newItem
 * @return {!SVGLength}
 */
SVGLengthList.prototype.appendItem = function(newItem) {}
/**
 * @constructor
 * @private
 * @extends {SVGElement}
 * @nosideeffects
 */
function SVGDescElement() {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function EXT_blend_minmax() {}
/** @const {!GLenum} */ EXT_blend_minmax.prototype.MAX_EXT;
/** @const {!GLenum} */ EXT_blend_minmax.prototype.MIN_EXT;
/**
 * @constructor
 * @extends {Object}
 * @nosideeffects
 * @param {!Array<!BlobPart>=} blobParts
 * @param {!BlobPropertyBag=} options
 */
function Blob(blobParts,options) {}
/** @type {!number} */ Blob.prototype.size;
/** @type {!string} */ Blob.prototype.type;
/**
 * @return {!Promise<!ArrayBuffer>}
 * @nosideeffects
 */
Blob.prototype.arrayBuffer = function() {}
/**
 * @return {!ReadableStream}
 */
Blob.prototype.stream = function() {}
/**
 * @param {!number=} start
 * @param {!number=} end
 * @param {!string=} contentType
 * @return {!Blob}
 * @nosideeffects
 */
Blob.prototype.slice = function(start,end,contentType) {}
/**
 * @return {!Promise<!string>}
 * @nosideeffects
 */
Blob.prototype.text = function() {}
/**
 * @constructor
 * @private
 * @extends {SVGGraphicsElement}
 * @nosideeffects
 */
function SVGGElement() {}
/**
 * @constructor
 * @extends {MouseEvent}
 * @param {!string} type
 * @param {!WheelEventInit=} eventInitDict
 */
function WheelEvent(type,eventInitDict) {}
/** @const {!number} */ WheelEvent.DOM_DELTA_LINE;
/** @const {!number} */ WheelEvent.prototype.DOM_DELTA_LINE;
/** @const {!number} */ WheelEvent.DOM_DELTA_PAGE;
/** @const {!number} */ WheelEvent.prototype.DOM_DELTA_PAGE;
/** @const {!number} */ WheelEvent.DOM_DELTA_PIXEL;
/** @const {!number} */ WheelEvent.prototype.DOM_DELTA_PIXEL;
/** @type {!number} */ WheelEvent.prototype.deltaMode;
/** @type {!number} */ WheelEvent.prototype.deltaX;
/** @type {!number} */ WheelEvent.prototype.deltaY;
/** @type {!number} */ WheelEvent.prototype.deltaZ;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function FileList() {}
/** @type {!number} */ FileList.prototype.length;
/**
 * @param {!number} index
 * @return {?File}
 * @nosideeffects
 */
FileList.prototype.item = function(index) {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function WEBGL_depth_texture() {}
/** @const {!GLenum} */ WEBGL_depth_texture.prototype.UNSIGNED_INT_24_8_WEBGL;
/**
 * @constructor
 * @extends {Event}
 * @param {!CSSOMString} type
 * @param {!TransitionEventInit=} transitionEventInitDict
 */
function TransitionEvent(type,transitionEventInitDict) {}
/** @type {!number} */ TransitionEvent.prototype.elapsedTime;
/** @type {!CSSOMString} */ TransitionEvent.prototype.propertyName;
/** @type {!CSSOMString} */ TransitionEvent.prototype.pseudoElement;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function MediaKeySystemAccess() {}
/** @type {!string} */ MediaKeySystemAccess.prototype.keySystem;
/**
 * @return {!Promise<!MediaKeys>}
 */
MediaKeySystemAccess.prototype.createMediaKeys = function() {}
/**
 * @return {!MediaKeySystemConfiguration}
 */
MediaKeySystemAccess.prototype.getConfiguration = function() {}
/**
 * @constructor
 * @private
 * @extends {EventTarget}
 * @nosideeffects
 */
function MediaStreamTrack() {}
/** @type {!string} */ MediaStreamTrack.prototype.id;
/** @type {!string} */ MediaStreamTrack.prototype.kind;
/** @type {!string} */ MediaStreamTrack.prototype.label;
/** @type {!boolean} */ MediaStreamTrack.prototype.muted;
/** @type {!string} */ MediaStreamTrack.prototype.readyState;
/** @type {!boolean} */ MediaStreamTrack.prototype.enabled;
/** @type {?EventHandler} */ MediaStreamTrack.prototype.onended;
/** @type {?EventHandler} */ MediaStreamTrack.prototype.onmute;
/** @type {?EventHandler} */ MediaStreamTrack.prototype.onunmute;
/** @type {!boolean} */ MediaStreamTrack.prototype.isolated;
/** @type {!NullableEventHandler} */ MediaStreamTrack.prototype.onisolationchange;
/**
 * @return {!MediaTrackConstraints}
 */
MediaStreamTrack.prototype.getConstraints = function() {}
/**
 * @return {undefined}
 */
MediaStreamTrack.prototype.stop = function() {}
/**
 * @return {!MediaTrackSettings}
 */
MediaStreamTrack.prototype.getSettings = function() {}
/**
 * @param {!MediaTrackConstraints=} constraints
 * @return {!Promise<undefined>}
 */
MediaStreamTrack.prototype.applyConstraints = function(constraints) {}
/**
 * @return {!MediaStreamTrack}
 */
MediaStreamTrack.prototype.clone = function() {}
/**
 * @return {!MediaTrackCapabilities}
 */
MediaStreamTrack.prototype.getCapabilities = function() {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function GamepadButton() {}
/** @type {!boolean} */ GamepadButton.prototype.pressed;
/** @type {!boolean} */ GamepadButton.prototype.touched;
/** @type {!number} */ GamepadButton.prototype.value;
/**
 * @constructor
 * @private
 * @extends {SVGGraphicsElement}
 * @nosideeffects
 */
function SVGAElement() {}
/** @type {!DOMTokenList} */ SVGAElement.prototype.relList;
/** @type {!SVGAnimatedString} */ SVGAElement.prototype.target;
/** @type {!string} */ SVGAElement.prototype.download;
/** @type {!string} */ SVGAElement.prototype.hreflang;
/** @type {!string} */ SVGAElement.prototype.ping;
/** @type {!string} */ SVGAElement.prototype.referrerPolicy;
/** @type {!string} */ SVGAElement.prototype.rel;
/** @type {!string} */ SVGAElement.prototype.text;
/** @type {!string} */ SVGAElement.prototype.type;
/** @type {!string} */ SVGAElement.prototype.origin;
/** @type {!string} */ SVGAElement.prototype.hash;
/** @type {!string} */ SVGAElement.prototype.host;
/** @type {!string} */ SVGAElement.prototype.hostname;
/** @type {!string} */ SVGAElement.prototype.password;
/** @type {!string} */ SVGAElement.prototype.pathname;
/** @type {!string} */ SVGAElement.prototype.port;
/** @type {!string} */ SVGAElement.prototype.protocol;
/** @type {!string} */ SVGAElement.prototype.search;
/** @type {!string} */ SVGAElement.prototype.username;
/** @type {!string} */ SVGAElement.prototype.href;
/**
 * @constructor
 * @private
 * @extends {EventTarget}
 * @nosideeffects
 */
function SourceBuffer() {}
/** @type {!AudioTrackList} */ SourceBuffer.prototype.audioTracks;
/** @type {!TimeRanges} */ SourceBuffer.prototype.buffered;
/** @type {!TextTrackList} */ SourceBuffer.prototype.textTracks;
/** @type {!boolean} */ SourceBuffer.prototype.updating;
/** @type {!VideoTrackList} */ SourceBuffer.prototype.videoTracks;
/** @type {!number} */ SourceBuffer.prototype.appendWindowEnd;
/** @type {!number} */ SourceBuffer.prototype.appendWindowStart;
/** @type {!string} */ SourceBuffer.prototype.mode;
/** @type {!NullableEventHandler} */ SourceBuffer.prototype.onabort;
/** @type {!NullableEventHandler} */ SourceBuffer.prototype.onerror;
/** @type {!NullableEventHandler} */ SourceBuffer.prototype.onupdate;
/** @type {!NullableEventHandler} */ SourceBuffer.prototype.onupdateend;
/** @type {!NullableEventHandler} */ SourceBuffer.prototype.onupdatestart;
/** @type {!number} */ SourceBuffer.prototype.timestampOffset;
/**
 * @return {undefined}
 */
SourceBuffer.prototype.abort = function() {}
/**
 * @param {!BufferSource} data
 * @return {undefined}
 */
SourceBuffer.prototype.appendBuffer = function(data) {}
/**
 * @param {!number} start
 * @param {!number} end
 * @return {undefined}
 */
SourceBuffer.prototype.remove = function(start,end) {}
/**
 * @constructor
 * @private
 * @extends {HTMLElement}
 * @nosideeffects
 */
function HTMLLinkElement() {}
/** @type {!DOMTokenList} */ HTMLLinkElement.prototype.relList;
/** @type {!DOMTokenList} */ HTMLLinkElement.prototype.sizes;
/** @type {!string} */ HTMLLinkElement.prototype.as;
/** @type {?string} */ HTMLLinkElement.prototype.crossOrigin;
/** @type {!boolean} */ HTMLLinkElement.prototype.disabled;
/** @type {!string} */ HTMLLinkElement.prototype.href;
/** @type {!string} */ HTMLLinkElement.prototype.hreflang;
/** @type {!string} */ HTMLLinkElement.prototype.imageSizes;
/** @type {!string} */ HTMLLinkElement.prototype.imageSrcset;
/** @type {!string} */ HTMLLinkElement.prototype.integrity;
/** @type {!string} */ HTMLLinkElement.prototype.media;
/** @type {!string} */ HTMLLinkElement.prototype.referrerPolicy;
/** @type {!string} */ HTMLLinkElement.prototype.rel;
/** @type {!string} */ HTMLLinkElement.prototype.type;
/** @type {!string} */ HTMLLinkElement.prototype.charset;
/** @type {!string} */ HTMLLinkElement.prototype.rev;
/** @type {!string} */ HTMLLinkElement.prototype.target;
/** @type {?CSSStyleSheet} */ HTMLLinkElement.prototype.sheet;
/**
 * @constructor
 * @private
 * @extends {CSSConditionRule}
 * @nosideeffects
 */
function CSSSupportsRule() {}
/**
 * @constructor
 * @private
 * @extends {SVGElement}
 * @nosideeffects
 */
function SVGFETurbulenceElement() {}
/** @const {!number} */ SVGFETurbulenceElement.SVG_STITCHTYPE_NOSTITCH;
/** @const {!number} */ SVGFETurbulenceElement.prototype.SVG_STITCHTYPE_NOSTITCH;
/** @const {!number} */ SVGFETurbulenceElement.SVG_STITCHTYPE_STITCH;
/** @const {!number} */ SVGFETurbulenceElement.prototype.SVG_STITCHTYPE_STITCH;
/** @const {!number} */ SVGFETurbulenceElement.SVG_STITCHTYPE_UNKNOWN;
/** @const {!number} */ SVGFETurbulenceElement.prototype.SVG_STITCHTYPE_UNKNOWN;
/** @const {!number} */ SVGFETurbulenceElement.SVG_TURBULENCE_TYPE_FRACTALNOISE;
/** @const {!number} */ SVGFETurbulenceElement.prototype.SVG_TURBULENCE_TYPE_FRACTALNOISE;
/** @const {!number} */ SVGFETurbulenceElement.SVG_TURBULENCE_TYPE_TURBULENCE;
/** @const {!number} */ SVGFETurbulenceElement.prototype.SVG_TURBULENCE_TYPE_TURBULENCE;
/** @const {!number} */ SVGFETurbulenceElement.SVG_TURBULENCE_TYPE_UNKNOWN;
/** @const {!number} */ SVGFETurbulenceElement.prototype.SVG_TURBULENCE_TYPE_UNKNOWN;
/** @type {!SVGAnimatedNumber} */ SVGFETurbulenceElement.prototype.baseFrequencyX;
/** @type {!SVGAnimatedNumber} */ SVGFETurbulenceElement.prototype.baseFrequencyY;
/** @type {!SVGAnimatedInteger} */ SVGFETurbulenceElement.prototype.numOctaves;
/** @type {!SVGAnimatedNumber} */ SVGFETurbulenceElement.prototype.seed;
/** @type {!SVGAnimatedEnumeration} */ SVGFETurbulenceElement.prototype.stitchTiles;
/** @type {!SVGAnimatedEnumeration} */ SVGFETurbulenceElement.prototype.type;
/** @type {!SVGAnimatedLength} */ SVGFETurbulenceElement.prototype.height;
/** @type {!SVGAnimatedString} */ SVGFETurbulenceElement.prototype.result;
/** @type {!SVGAnimatedLength} */ SVGFETurbulenceElement.prototype.width;
/** @type {!SVGAnimatedLength} */ SVGFETurbulenceElement.prototype.x;
/** @type {!SVGAnimatedLength} */ SVGFETurbulenceElement.prototype.y;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function EXT_shader_texture_lod() {}
/**
 * @constructor
 * @extends {Object}
 * @param {!string=} label
 * @param {!TextDecoderOptions=} options
 */
function TextDecoderStream(label,options) {}
/** @type {!ReadableStream} */ TextDecoderStream.prototype.readable;
/** @type {!WritableStream} */ TextDecoderStream.prototype.writable;
/** @type {!string} */ TextDecoderStream.prototype.encoding;
/** @type {!boolean} */ TextDecoderStream.prototype.fatal;
/** @type {!boolean} */ TextDecoderStream.prototype.ignoreBOM;
/**
 * @constructor
 * @extends {EventTarget}
 * @param {!RTCConfiguration=} configuration
 */
function RTCPeerConnection(configuration) {}
/** @type {?boolean} */ RTCPeerConnection.prototype.canTrickleIceCandidates;
/** @type {!string} */ RTCPeerConnection.prototype.connectionState;
/** @type {?RTCSessionDescription} */ RTCPeerConnection.prototype.currentLocalDescription;
/** @type {?RTCSessionDescription} */ RTCPeerConnection.prototype.currentRemoteDescription;
/** @type {!string} */ RTCPeerConnection.prototype.iceConnectionState;
/** @type {!string} */ RTCPeerConnection.prototype.iceGatheringState;
/** @type {?RTCSessionDescription} */ RTCPeerConnection.prototype.localDescription;
/** @type {?RTCSessionDescription} */ RTCPeerConnection.prototype.pendingLocalDescription;
/** @type {?RTCSessionDescription} */ RTCPeerConnection.prototype.pendingRemoteDescription;
/** @type {?RTCSessionDescription} */ RTCPeerConnection.prototype.remoteDescription;
/** @type {!string} */ RTCPeerConnection.prototype.signalingState;
/** @type {?EventHandler} */ RTCPeerConnection.prototype.onconnectionstatechange;
/** @type {?RTCPeerConnectionIceEventHandler} */ RTCPeerConnection.prototype.onicecandidate;
/** @type {?RTCPeerConnectionIceErrorEventHandler} */ RTCPeerConnection.prototype.onicecandidateerror;
/** @type {?EventHandler} */ RTCPeerConnection.prototype.oniceconnectionstatechange;
/** @type {?EventHandler} */ RTCPeerConnection.prototype.onicegatheringstatechange;
/** @type {?EventHandler} */ RTCPeerConnection.prototype.onnegotiationneeded;
/** @type {?EventHandler} */ RTCPeerConnection.prototype.onsignalingstatechange;
/** @type {?RTCTrackEventHandler} */ RTCPeerConnection.prototype.ontrack;
/** @type {?RTCSctpTransport} */ RTCPeerConnection.prototype.sctp;
/** @type {?RTCDataChannelEventHandler} */ RTCPeerConnection.prototype.ondatachannel;
/** @type {?string} */ RTCPeerConnection.prototype.idpErrorInfo;
/** @type {?string} */ RTCPeerConnection.prototype.idpLoginUrl;
/** @type {!Promise<!RTCIdentityAssertion>} */ RTCPeerConnection.prototype.peerIdentity;
/**
 * @param {!AlgorithmIdentifier} keygenAlgorithm
 * @return {!Promise<!RTCCertificate>}
 */
RTCPeerConnection.generateCertificate = function(keygenAlgorithm) {}
/**
 * @param {?MediaStreamTrack=} selector
 * @return {!Promise<!RTCStatsReport>}
 */
RTCPeerConnection.prototype.getStats = function(selector) {}
/**
 * @param {!RTCRtpSender} sender
 * @return {undefined}
 */
RTCPeerConnection.prototype.removeTrack = function(sender) {}
/**
 * @param {(!RTCAnswerOptions|!RTCSessionDescriptionCallback)=} arg0
 * @param {!RTCPeerConnectionErrorCallback=} arg1
 * @return {(!Promise<!RTCSessionDescriptionInit>|!Promise<undefined>)}
 */
RTCPeerConnection.prototype.createAnswer = function(arg0,arg1) {}
/**
 * @param {!string} provider
 * @param {!RTCIdentityProviderOptions=} options
 * @return {undefined}
 */
RTCPeerConnection.prototype.setIdentityProvider = function(provider,options) {}
/**
 * @return {!Array<!RTCRtpTransceiver>}
 */
RTCPeerConnection.prototype.getTransceivers = function() {}
/**
 * @param {(!MediaStreamTrack|!string)} trackOrKind
 * @param {!RTCRtpTransceiverInit=} init
 * @return {!RTCRtpTransceiver}
 */
RTCPeerConnection.prototype.addTransceiver = function(trackOrKind,init) {}
/**
 * @return {undefined}
 */
RTCPeerConnection.prototype.restartIce = function() {}
/**
 * @param {(!RTCOfferOptions|!RTCSessionDescriptionCallback)=} arg0
 * @param {!RTCPeerConnectionErrorCallback=} arg1
 * @param {!RTCOfferOptions=} arg2
 * @return {(!Promise<!RTCSessionDescriptionInit>|!Promise<undefined>)}
 */
RTCPeerConnection.prototype.createOffer = function(arg0,arg1,arg2) {}
/**
 * @param {!RTCLocalSessionDescriptionInit=} arg0
 * @param {!VoidFunction=} arg1
 * @param {!RTCPeerConnectionErrorCallback=} arg2
 * @return {!Promise<undefined>}
 */
RTCPeerConnection.prototype.setLocalDescription = function(arg0,arg1,arg2) {}
/**
 * @return {!Array<!RTCRtpReceiver>}
 */
RTCPeerConnection.prototype.getReceivers = function() {}
/**
 * @param {!MediaStreamTrack} track
 * @param {...!MediaStream} streams
 * @return {!RTCRtpSender}
 */
RTCPeerConnection.prototype.addTrack = function(track,streams) {}
/**
 * @param {!RTCSessionDescriptionInit} arg0
 * @param {!VoidFunction=} arg1
 * @param {!RTCPeerConnectionErrorCallback=} arg2
 * @return {!Promise<undefined>}
 */
RTCPeerConnection.prototype.setRemoteDescription = function(arg0,arg1,arg2) {}
/**
 * @param {!RTCIceCandidateInit=} arg0
 * @param {!VoidFunction=} arg1
 * @param {!RTCPeerConnectionErrorCallback=} arg2
 * @return {!Promise<undefined>}
 */
RTCPeerConnection.prototype.addIceCandidate = function(arg0,arg1,arg2) {}
/**
 * @return {!RTCConfiguration}
 */
RTCPeerConnection.prototype.getConfiguration = function() {}
/**
 * @return {!Promise<!string>}
 */
RTCPeerConnection.prototype.getIdentityAssertion = function() {}
/**
 * @return {!Array<!RTCRtpSender>}
 */
RTCPeerConnection.prototype.getSenders = function() {}
/**
 * @param {!string} label
 * @param {!RTCDataChannelInit=} dataChannelDict
 * @return {!RTCDataChannel}
 */
RTCPeerConnection.prototype.createDataChannel = function(label,dataChannelDict) {}
/**
 * @param {!RTCConfiguration=} configuration
 * @return {undefined}
 */
RTCPeerConnection.prototype.setConfiguration = function(configuration) {}
/**
 * @return {undefined}
 */
RTCPeerConnection.prototype.close = function() {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function GPUDeviceLostInfo() {}
/** @type {!string} */ GPUDeviceLostInfo.prototype.message;
/** @type {GPUDeviceLostReasonOrUndefinedUnion} */ GPUDeviceLostInfo.prototype.reason;
/**
 * @constructor
 * @private
 * @extends {DocumentFragment}
 * @nosideeffects
 */
function ShadowRoot() {}
/** @type {!boolean} */ ShadowRoot.prototype.delegatesFocus;
/** @type {!Element} */ ShadowRoot.prototype.host;
/** @type {!string} */ ShadowRoot.prototype.mode;
/** @type {!string} */ ShadowRoot.prototype.slotAssignment;
/** @type {!NullableEventHandler} */ ShadowRoot.prototype.onslotchange;
/** @type {!StyleSheetList} */ ShadowRoot.prototype.styleSheets;
/** @type {?Element} */ ShadowRoot.prototype.pointerLockElement;
/** @type {?Element} */ ShadowRoot.prototype.fullscreenElement;
/** @type {?Element} */ ShadowRoot.prototype.activeElement;
/** @type {!string} */ ShadowRoot.prototype.innerHTML;
/**
 * @return {!Array<!Animation>}
 */
ShadowRoot.prototype.getAnimations = function() {}
/**
 * @constructor
 * @private
 * @extends {HTMLElement}
 * @nosideeffects
 */
function HTMLHeadElement() {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function IDBIndex() {}
/** @type {*} */ IDBIndex.prototype.keyPath;
/** @type {!boolean} */ IDBIndex.prototype.multiEntry;
/** @type {!IDBObjectStore} */ IDBIndex.prototype.objectStore;
/** @type {!boolean} */ IDBIndex.prototype.unique;
/** @type {!string} */ IDBIndex.prototype.name;
/**
 * @param {*} query
 * @return {!IDBRequest}
 */
IDBIndex.prototype.getKey = function(query) {}
/**
 * @param {*=} query
 * @param {!number=} count
 * @return {!IDBRequest}
 */
IDBIndex.prototype.getAll = function(query,count) {}
/**
 * @param {*=} query
 * @param {!number=} count
 * @return {!IDBRequest}
 */
IDBIndex.prototype.getAllKeys = function(query,count) {}
/**
 * @param {*=} query
 * @param {!string=} direction
 * @return {!IDBRequest}
 */
IDBIndex.prototype.openCursor = function(query,direction) {}
/**
 * @param {*} query
 * @return {!IDBRequest}
 */
IDBIndex.prototype.get = function(query) {}
/**
 * @param {*=} query
 * @return {!IDBRequest}
 */
IDBIndex.prototype.count = function(query) {}
/**
 * @param {*=} query
 * @param {!string=} direction
 * @return {!IDBRequest}
 */
IDBIndex.prototype.openKeyCursor = function(query,direction) {}
/**
 * @constructor
 * @private
 * @extends {SVGElement}
 * @nosideeffects
 */
function SVGFEDisplacementMapElement() {}
/** @const {!number} */ SVGFEDisplacementMapElement.SVG_CHANNEL_A;
/** @const {!number} */ SVGFEDisplacementMapElement.prototype.SVG_CHANNEL_A;
/** @const {!number} */ SVGFEDisplacementMapElement.SVG_CHANNEL_B;
/** @const {!number} */ SVGFEDisplacementMapElement.prototype.SVG_CHANNEL_B;
/** @const {!number} */ SVGFEDisplacementMapElement.SVG_CHANNEL_G;
/** @const {!number} */ SVGFEDisplacementMapElement.prototype.SVG_CHANNEL_G;
/** @const {!number} */ SVGFEDisplacementMapElement.SVG_CHANNEL_R;
/** @const {!number} */ SVGFEDisplacementMapElement.prototype.SVG_CHANNEL_R;
/** @const {!number} */ SVGFEDisplacementMapElement.SVG_CHANNEL_UNKNOWN;
/** @const {!number} */ SVGFEDisplacementMapElement.prototype.SVG_CHANNEL_UNKNOWN;
/** @type {!SVGAnimatedString} */ SVGFEDisplacementMapElement.prototype.in1;
/** @type {!SVGAnimatedString} */ SVGFEDisplacementMapElement.prototype.in2;
/** @type {!SVGAnimatedNumber} */ SVGFEDisplacementMapElement.prototype.scale;
/** @type {!SVGAnimatedEnumeration} */ SVGFEDisplacementMapElement.prototype.xChannelSelector;
/** @type {!SVGAnimatedEnumeration} */ SVGFEDisplacementMapElement.prototype.yChannelSelector;
/** @type {!SVGAnimatedLength} */ SVGFEDisplacementMapElement.prototype.height;
/** @type {!SVGAnimatedString} */ SVGFEDisplacementMapElement.prototype.result;
/** @type {!SVGAnimatedLength} */ SVGFEDisplacementMapElement.prototype.width;
/** @type {!SVGAnimatedLength} */ SVGFEDisplacementMapElement.prototype.x;
/** @type {!SVGAnimatedLength} */ SVGFEDisplacementMapElement.prototype.y;
/**
 * @constructor
 * @extends {Object}
 * @param {!IntersectionObserverCallback} callback
 * @param {!IntersectionObserverInit=} options
 */
function IntersectionObserver(callback,options) {}
/** @type {ElementOrDocumentUnion} */ IntersectionObserver.prototype.root;
/** @type {!string} */ IntersectionObserver.prototype.rootMargin;
/** @type {!Array<!number>} */ IntersectionObserver.prototype.thresholds;
/**
 * @return {undefined}
 */
IntersectionObserver.prototype.disconnect = function() {}
/**
 * @param {!Element} target
 * @return {undefined}
 */
IntersectionObserver.prototype.unobserve = function(target) {}
/**
 * @return {!Array<!IntersectionObserverEntry>}
 */
IntersectionObserver.prototype.takeRecords = function() {}
/**
 * @param {!Element} target
 * @return {undefined}
 */
IntersectionObserver.prototype.observe = function(target) {}
/**
 * @constructor
 * @private
 * @extends {AudioNode}
 * @nosideeffects
 */
function AudioDestinationNode() {}
/** @type {!number} */ AudioDestinationNode.prototype.maxChannelCount;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function Screen() {}
/** @type {!number} */ Screen.prototype.availHeight;
/** @type {!number} */ Screen.prototype.availWidth;
/** @type {!number} */ Screen.prototype.colorDepth;
/** @type {!number} */ Screen.prototype.height;
/** @type {!number} */ Screen.prototype.pixelDepth;
/** @type {!number} */ Screen.prototype.width;
/** @type {!ScreenOrientation} */ Screen.prototype.orientation;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function WebGLActiveInfo() {}
/** @type {!string} */ WebGLActiveInfo.prototype.name;
/** @type {!GLint} */ WebGLActiveInfo.prototype.size;
/** @type {!GLenum} */ WebGLActiveInfo.prototype.type;
/**
 * @constructor
 * @extends {Object}
 * @param {!TouchInit} touchInitDict
 */
function Touch(touchInitDict) {}
/** @type {!number} */ Touch.prototype.altitudeAngle;
/** @type {!number} */ Touch.prototype.azimuthAngle;
/** @type {!number} */ Touch.prototype.clientX;
/** @type {!number} */ Touch.prototype.clientY;
/** @type {!number} */ Touch.prototype.force;
/** @type {!number} */ Touch.prototype.identifier;
/** @type {!number} */ Touch.prototype.pageX;
/** @type {!number} */ Touch.prototype.pageY;
/** @type {!number} */ Touch.prototype.radiusX;
/** @type {!number} */ Touch.prototype.radiusY;
/** @type {!number} */ Touch.prototype.rotationAngle;
/** @type {!number} */ Touch.prototype.screenX;
/** @type {!number} */ Touch.prototype.screenY;
/** @type {!EventTarget} */ Touch.prototype.target;
/** @type {!string} */ Touch.prototype.touchType;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function SVGAnimatedRect() {}
/** @type {!DOMRectReadOnly} */ SVGAnimatedRect.prototype.animVal;
/** @type {!DOMRect} */ SVGAnimatedRect.prototype.baseVal;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function WEBGL_draw_buffers() {}
/** @const {!GLenum} */ WEBGL_draw_buffers.prototype.COLOR_ATTACHMENT0_WEBGL;
/** @const {!GLenum} */ WEBGL_draw_buffers.prototype.COLOR_ATTACHMENT10_WEBGL;
/** @const {!GLenum} */ WEBGL_draw_buffers.prototype.COLOR_ATTACHMENT11_WEBGL;
/** @const {!GLenum} */ WEBGL_draw_buffers.prototype.COLOR_ATTACHMENT12_WEBGL;
/** @const {!GLenum} */ WEBGL_draw_buffers.prototype.COLOR_ATTACHMENT13_WEBGL;
/** @const {!GLenum} */ WEBGL_draw_buffers.prototype.COLOR_ATTACHMENT14_WEBGL;
/** @const {!GLenum} */ WEBGL_draw_buffers.prototype.COLOR_ATTACHMENT15_WEBGL;
/** @const {!GLenum} */ WEBGL_draw_buffers.prototype.COLOR_ATTACHMENT1_WEBGL;
/** @const {!GLenum} */ WEBGL_draw_buffers.prototype.COLOR_ATTACHMENT2_WEBGL;
/** @const {!GLenum} */ WEBGL_draw_buffers.prototype.COLOR_ATTACHMENT3_WEBGL;
/** @const {!GLenum} */ WEBGL_draw_buffers.prototype.COLOR_ATTACHMENT4_WEBGL;
/** @const {!GLenum} */ WEBGL_draw_buffers.prototype.COLOR_ATTACHMENT5_WEBGL;
/** @const {!GLenum} */ WEBGL_draw_buffers.prototype.COLOR_ATTACHMENT6_WEBGL;
/** @const {!GLenum} */ WEBGL_draw_buffers.prototype.COLOR_ATTACHMENT7_WEBGL;
/** @const {!GLenum} */ WEBGL_draw_buffers.prototype.COLOR_ATTACHMENT8_WEBGL;
/** @const {!GLenum} */ WEBGL_draw_buffers.prototype.COLOR_ATTACHMENT9_WEBGL;
/** @const {!GLenum} */ WEBGL_draw_buffers.prototype.DRAW_BUFFER0_WEBGL;
/** @const {!GLenum} */ WEBGL_draw_buffers.prototype.DRAW_BUFFER10_WEBGL;
/** @const {!GLenum} */ WEBGL_draw_buffers.prototype.DRAW_BUFFER11_WEBGL;
/** @const {!GLenum} */ WEBGL_draw_buffers.prototype.DRAW_BUFFER12_WEBGL;
/** @const {!GLenum} */ WEBGL_draw_buffers.prototype.DRAW_BUFFER13_WEBGL;
/** @const {!GLenum} */ WEBGL_draw_buffers.prototype.DRAW_BUFFER14_WEBGL;
/** @const {!GLenum} */ WEBGL_draw_buffers.prototype.DRAW_BUFFER15_WEBGL;
/** @const {!GLenum} */ WEBGL_draw_buffers.prototype.DRAW_BUFFER1_WEBGL;
/** @const {!GLenum} */ WEBGL_draw_buffers.prototype.DRAW_BUFFER2_WEBGL;
/** @const {!GLenum} */ WEBGL_draw_buffers.prototype.DRAW_BUFFER3_WEBGL;
/** @const {!GLenum} */ WEBGL_draw_buffers.prototype.DRAW_BUFFER4_WEBGL;
/** @const {!GLenum} */ WEBGL_draw_buffers.prototype.DRAW_BUFFER5_WEBGL;
/** @const {!GLenum} */ WEBGL_draw_buffers.prototype.DRAW_BUFFER6_WEBGL;
/** @const {!GLenum} */ WEBGL_draw_buffers.prototype.DRAW_BUFFER7_WEBGL;
/** @const {!GLenum} */ WEBGL_draw_buffers.prototype.DRAW_BUFFER8_WEBGL;
/** @const {!GLenum} */ WEBGL_draw_buffers.prototype.DRAW_BUFFER9_WEBGL;
/** @const {!GLenum} */ WEBGL_draw_buffers.prototype.MAX_COLOR_ATTACHMENTS_WEBGL;
/** @const {!GLenum} */ WEBGL_draw_buffers.prototype.MAX_DRAW_BUFFERS_WEBGL;
/**
 * @param {!Array<!GLenum>} buffers
 * @return {undefined}
 */
WEBGL_draw_buffers.prototype.drawBuffersWEBGL = function(buffers) {}
/**
 * @constructor
 * @private
 * @extends {HTMLElement}
 * @nosideeffects
 */
function HTMLAreaElement() {}
/** @type {!DOMTokenList} */ HTMLAreaElement.prototype.relList;
/** @type {!string} */ HTMLAreaElement.prototype.alt;
/** @type {!string} */ HTMLAreaElement.prototype.coords;
/** @type {!string} */ HTMLAreaElement.prototype.download;
/** @type {!string} */ HTMLAreaElement.prototype.ping;
/** @type {!string} */ HTMLAreaElement.prototype.referrerPolicy;
/** @type {!string} */ HTMLAreaElement.prototype.rel;
/** @type {!string} */ HTMLAreaElement.prototype.shape;
/** @type {!string} */ HTMLAreaElement.prototype.target;
/** @type {!boolean} */ HTMLAreaElement.prototype.noHref;
/** @type {!string} */ HTMLAreaElement.prototype.origin;
/** @type {!string} */ HTMLAreaElement.prototype.hash;
/** @type {!string} */ HTMLAreaElement.prototype.host;
/** @type {!string} */ HTMLAreaElement.prototype.hostname;
/** @type {!string} */ HTMLAreaElement.prototype.password;
/** @type {!string} */ HTMLAreaElement.prototype.pathname;
/** @type {!string} */ HTMLAreaElement.prototype.port;
/** @type {!string} */ HTMLAreaElement.prototype.protocol;
/** @type {!string} */ HTMLAreaElement.prototype.search;
/** @type {!string} */ HTMLAreaElement.prototype.username;
/** @type {!string} */ HTMLAreaElement.prototype.href;
/**
 * @constructor
 * @private
 * @extends {HTMLElement}
 * @nosideeffects
 */
function HTMLTableSectionElement() {}
/** @type {!HTMLCollection} */ HTMLTableSectionElement.prototype.rows;
/** @type {!string} */ HTMLTableSectionElement.prototype.align;
/** @type {!string} */ HTMLTableSectionElement.prototype.ch;
/** @type {!string} */ HTMLTableSectionElement.prototype.chOff;
/** @type {!string} */ HTMLTableSectionElement.prototype.vAlign;
/**
 * @param {!number} index
 * @return {undefined}
 */
HTMLTableSectionElement.prototype.deleteRow = function(index) {}
/**
 * @param {!number=} index
 * @return {!HTMLTableRowElement}
 */
HTMLTableSectionElement.prototype.insertRow = function(index) {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function GPURenderBundle() {}
/** @type {?string} */ GPURenderBundle.prototype.label;
/**
 * @constructor
 * @private
 * @extends {EventTarget}
 * @nosideeffects
 */
function ServiceWorkerContainer() {}
/** @type {?ServiceWorker} */ ServiceWorkerContainer.prototype.controller;
/** @type {!Promise<!ServiceWorkerRegistration>} */ ServiceWorkerContainer.prototype.ready;
/** @type {!NullableEventHandler} */ ServiceWorkerContainer.prototype.oncontrollerchange;
/** @type {?MessageEventHandler} */ ServiceWorkerContainer.prototype.onmessage;
/** @type {!NullableEventHandler} */ ServiceWorkerContainer.prototype.onmessageerror;
/**
 * @return {undefined}
 */
ServiceWorkerContainer.prototype.startMessages = function() {}
/**
 * @param {!string=} clientURL
 * @return {!Promise<ServiceWorkerRegistrationOrUndefinedUnion>}
 */
ServiceWorkerContainer.prototype.getRegistration = function(clientURL) {}
/**
 * @return {!Promise<!Array<!ServiceWorkerRegistration>>}
 */
ServiceWorkerContainer.prototype.getRegistrations = function() {}
/**
 * @param {!string} scriptURL
 * @param {!RegistrationOptions=} options
 * @return {!Promise<!ServiceWorkerRegistration>}
 */
ServiceWorkerContainer.prototype.register = function(scriptURL,options) {}
/**
 * @constructor
 * @private
 * @extends {EventTarget}
 * @nosideeffects
 */
function AbortSignal() {}
/** @type {!boolean} */ AbortSignal.prototype.aborted;
/** @type {?EventHandler} */ AbortSignal.prototype.onabort;
/**
 * @return {!AbortSignal}
 */
AbortSignal.abort = function() {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function RTCCertificate() {}
/** @type {!DOMTimeStamp} */ RTCCertificate.prototype.expires;
/**
 * @return {!Array<!RTCDtlsFingerprint>}
 */
RTCCertificate.prototype.getFingerprints = function() {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function OES_texture_float() {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function XPathResult() {}
/** @const {!number} */ XPathResult.ANY_TYPE;
/** @const {!number} */ XPathResult.prototype.ANY_TYPE;
/** @const {!number} */ XPathResult.ANY_UNORDERED_NODE_TYPE;
/** @const {!number} */ XPathResult.prototype.ANY_UNORDERED_NODE_TYPE;
/** @const {!number} */ XPathResult.BOOLEAN_TYPE;
/** @const {!number} */ XPathResult.prototype.BOOLEAN_TYPE;
/** @const {!number} */ XPathResult.FIRST_ORDERED_NODE_TYPE;
/** @const {!number} */ XPathResult.prototype.FIRST_ORDERED_NODE_TYPE;
/** @const {!number} */ XPathResult.NUMBER_TYPE;
/** @const {!number} */ XPathResult.prototype.NUMBER_TYPE;
/** @const {!number} */ XPathResult.ORDERED_NODE_ITERATOR_TYPE;
/** @const {!number} */ XPathResult.prototype.ORDERED_NODE_ITERATOR_TYPE;
/** @const {!number} */ XPathResult.ORDERED_NODE_SNAPSHOT_TYPE;
/** @const {!number} */ XPathResult.prototype.ORDERED_NODE_SNAPSHOT_TYPE;
/** @const {!number} */ XPathResult.STRING_TYPE;
/** @const {!number} */ XPathResult.prototype.STRING_TYPE;
/** @const {!number} */ XPathResult.UNORDERED_NODE_ITERATOR_TYPE;
/** @const {!number} */ XPathResult.prototype.UNORDERED_NODE_ITERATOR_TYPE;
/** @const {!number} */ XPathResult.UNORDERED_NODE_SNAPSHOT_TYPE;
/** @const {!number} */ XPathResult.prototype.UNORDERED_NODE_SNAPSHOT_TYPE;
/** @type {!boolean} */ XPathResult.prototype.booleanValue;
/** @type {!boolean} */ XPathResult.prototype.invalidIteratorState;
/** @type {!number} */ XPathResult.prototype.numberValue;
/** @type {!number} */ XPathResult.prototype.resultType;
/** @type {?Node} */ XPathResult.prototype.singleNodeValue;
/** @type {!number} */ XPathResult.prototype.snapshotLength;
/** @type {!string} */ XPathResult.prototype.stringValue;
/**
 * @return {?Node}
 */
XPathResult.prototype.iterateNext = function() {}
/**
 * @param {!number} index
 * @return {?Node}
 */
XPathResult.prototype.snapshotItem = function(index) {}
/**
 * @constructor
 * @extends {Object}
 */
function XSLTProcessor() {}
/**
 * @param {!Node} source
 * @param {!Document} output
 * @return {!DocumentFragment}
 */
XSLTProcessor.prototype.transformToFragment = function(source,output) {}
/**
 * @param {!Node} style
 * @return {undefined}
 */
XSLTProcessor.prototype.importStylesheet = function(style) {}
/**
 * @param {!string} namespaceURI
 * @param {!string} localName
 * @param {*} value
 * @return {undefined}
 */
XSLTProcessor.prototype.setParameter = function(namespaceURI,localName,value) {}
/**
 * @return {undefined}
 */
XSLTProcessor.prototype.reset = function() {}
/**
 * @return {undefined}
 */
XSLTProcessor.prototype.clearParameters = function() {}
/**
 * @param {!Node} source
 * @return {!Document}
 */
XSLTProcessor.prototype.transformToDocument = function(source) {}
/**
 * @param {!string} namespaceURI
 * @param {!string} localName
 * @return {undefined}
 */
XSLTProcessor.prototype.removeParameter = function(namespaceURI,localName) {}
/**
 * @param {!string} namespaceURI
 * @param {!string} localName
 * @return {*}
 */
XSLTProcessor.prototype.getParameter = function(namespaceURI,localName) {}
/**
 * @constructor
 * @private
 * @extends {CSSRule}
 * @nosideeffects
 */
function CSSCounterStyleRule() {}
/** @type {!CSSOMString} */ CSSCounterStyleRule.prototype.additiveSymbols;
/** @type {!CSSOMString} */ CSSCounterStyleRule.prototype.fallback;
/** @type {!CSSOMString} */ CSSCounterStyleRule.prototype.name;
/** @type {!CSSOMString} */ CSSCounterStyleRule.prototype.negative;
/** @type {!CSSOMString} */ CSSCounterStyleRule.prototype.pad;
/** @type {!CSSOMString} */ CSSCounterStyleRule.prototype.prefix;
/** @type {!CSSOMString} */ CSSCounterStyleRule.prototype.range;
/** @type {!CSSOMString} */ CSSCounterStyleRule.prototype.speakAs;
/** @type {!CSSOMString} */ CSSCounterStyleRule.prototype.suffix;
/** @type {!CSSOMString} */ CSSCounterStyleRule.prototype.symbols;
/** @type {!CSSOMString} */ CSSCounterStyleRule.prototype.system;
/**
 * @constructor
 * @private
 * @extends {EventTarget}
 * @nosideeffects
 */
function PermissionStatus() {}
/** @type {!string} */ PermissionStatus.prototype.state;
/** @type {!NullableEventHandler} */ PermissionStatus.prototype.onchange;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function EXT_disjoint_timer_query_webgl2() {}
/** @const {!GLenum} */ EXT_disjoint_timer_query_webgl2.prototype.GPU_DISJOINT_EXT;
/** @const {!GLenum} */ EXT_disjoint_timer_query_webgl2.prototype.QUERY_COUNTER_BITS_EXT;
/** @const {!GLenum} */ EXT_disjoint_timer_query_webgl2.prototype.TIMESTAMP_EXT;
/** @const {!GLenum} */ EXT_disjoint_timer_query_webgl2.prototype.TIME_ELAPSED_EXT;
/**
 * @param {!WebGLQuery} query
 * @param {!GLenum} target
 * @return {undefined}
 */
EXT_disjoint_timer_query_webgl2.prototype.queryCounterEXT = function(query,target) {}
/**
 * @constructor
 * @extends {Event}
 * @param {!string} type
 * @param {!FormDataEventInit} eventInitDict
 */
function FormDataEvent(type,eventInitDict) {}
/** @type {!FormData} */ FormDataEvent.prototype.formData;
/**
 * @constructor
 * @extends {MouseEvent}
 * @param {!string} type
 * @param {!PointerEventInit=} eventInitDict
 */
function PointerEvent(type,eventInitDict) {}
/** @type {!number} */ PointerEvent.prototype.height;
/** @type {!boolean} */ PointerEvent.prototype.isPrimary;
/** @type {!number} */ PointerEvent.prototype.pointerId;
/** @type {!string} */ PointerEvent.prototype.pointerType;
/** @type {!number} */ PointerEvent.prototype.pressure;
/** @type {!number} */ PointerEvent.prototype.tangentialPressure;
/** @type {!number} */ PointerEvent.prototype.tiltX;
/** @type {!number} */ PointerEvent.prototype.tiltY;
/** @type {!number} */ PointerEvent.prototype.twist;
/** @type {!number} */ PointerEvent.prototype.width;
/**
 * @constructor
 * @private
 * @extends {HTMLElement}
 * @nosideeffects
 */
function HTMLSlotElement() {}
/** @type {!string} */ HTMLSlotElement.prototype.name;
/**
 * @param {!AssignedNodesOptions=} options
 * @return {!Array<!Node>}
 */
HTMLSlotElement.prototype.assignedNodes = function(options) {}
/**
 * @param {!AssignedNodesOptions=} options
 * @return {!Array<!Element>}
 */
HTMLSlotElement.prototype.assignedElements = function(options) {}
/**
 * @param {...(!Element|!Text)} nodes
 * @return {undefined}
 */
HTMLSlotElement.prototype.assign = function(nodes) {}
/**
 * @constructor
 * @private
 * @extends {HTMLElement}
 * @nosideeffects
 */
function HTMLDataElement() {}
/** @type {!string} */ HTMLDataElement.prototype.value;
/**
 * @constructor
 * @private
 * @extends {PerformanceEntry}
 * @nosideeffects
 */
function PerformanceMeasure() {}
/**
 * @constructor
 * @extends {Event}
 * @param {!string} type
 * @param {!XRInputSourceEventInit} eventInitDict
 */
function XRInputSourceEvent(type,eventInitDict) {}
/** @type {!XRFrame} */ XRInputSourceEvent.prototype.frame;
/** @type {!XRInputSource} */ XRInputSourceEvent.prototype.inputSource;
/**
 * @constructor
 * @extends {Object}
 * @param {!AudioEncoderInit} init
 */
function AudioEncoder(init) {}
/** @type {!number} */ AudioEncoder.prototype.encodeQueueSize;
/** @type {!string} */ AudioEncoder.prototype.state;
/**
 * @param {!AudioData} data
 * @return {undefined}
 */
AudioEncoder.prototype.encode = function(data) {}
/**
 * @return {!Promise<undefined>}
 */
AudioEncoder.prototype.flush = function() {}
/**
 * @return {undefined}
 */
AudioEncoder.prototype.reset = function() {}
/**
 * @param {!AudioEncoderConfig} config
 * @return {undefined}
 */
AudioEncoder.prototype.configure = function(config) {}
/**
 * @return {undefined}
 */
AudioEncoder.prototype.close = function() {}
/**
 * @param {!AudioEncoderConfig} config
 * @return {!Promise<!AudioEncoderSupport>}
 */
AudioEncoder.isConfigSupported = function(config) {}
/**
 * @constructor
 * @private
 * @extends {SVGElement}
 * @nosideeffects
 */
function SVGClipPathElement() {}
/** @type {!SVGAnimatedEnumeration} */ SVGClipPathElement.prototype.clipPathUnits;
/** @type {!SVGAnimatedTransformList} */ SVGClipPathElement.prototype.transform;
/**
 * @constructor
 * @private
 * @extends {SVGComponentTransferFunctionElement}
 * @nosideeffects
 */
function SVGFEFuncBElement() {}
/**
 * @constructor
 * @extends {Object}
 * @param {!ImageDecoderInit} init
 */
function ImageDecoder(init) {}
/** @type {!boolean} */ ImageDecoder.prototype.complete;
/** @type {!Promise<undefined>} */ ImageDecoder.prototype.completed;
/** @type {!ImageTrackList} */ ImageDecoder.prototype.tracks;
/**
 * @return {undefined}
 */
ImageDecoder.prototype.reset = function() {}
/**
 * @param {!string} type
 * @return {!Promise<!boolean>}
 */
ImageDecoder.isTypeSupported = function(type) {}
/**
 * @param {!ImageDecodeOptions=} options
 * @return {!Promise<!ImageDecodeResult>}
 */
ImageDecoder.prototype.decode = function(options) {}
/**
 * @return {undefined}
 */
ImageDecoder.prototype.close = function() {}
/**
 * @constructor
 * @extends {UIEvent}
 * @param {!string} type
 * @param {!CompositionEventInit=} eventInitDict
 */
function CompositionEvent(type,eventInitDict) {}
/** @type {!string} */ CompositionEvent.prototype.data;
/**
 * @constructor
 * @extends {Object}
 * @param {?BodyInit=} body
 * @param {!ResponseInit=} init
 */
function Response(body,init) {}
/** @type {!Headers} */ Response.prototype.headers;
/** @type {!boolean} */ Response.prototype.ok;
/** @type {!boolean} */ Response.prototype.redirected;
/** @type {!number} */ Response.prototype.status;
/** @type {!string} */ Response.prototype.statusText;
/** @type {!string} */ Response.prototype.type;
/** @type {!string} */ Response.prototype.url;
/** @type {?ReadableStream} */ Response.prototype.body;
/** @type {!boolean} */ Response.prototype.bodyUsed;
/**
 * @param {!string} url
 * @param {!number=} status
 * @return {!Response}
 */
Response.redirect = function(url,status) {}
/**
 * @return {!Promise<!Blob>}
 */
Response.prototype.blob = function() {}
/**
 * @return {!Promise<!ArrayBuffer>}
 */
Response.prototype.arrayBuffer = function() {}
/**
 * @return {!Response}
 */
Response.prototype.clone = function() {}
/**
 * @return {!Promise<*>}
 */
Response.prototype.json = function() {}
/**
 * @return {!Promise<!FormData>}
 */
Response.prototype.formData = function() {}
/**
 * @return {!Promise<!string>}
 */
Response.prototype.text = function() {}
/**
 * @return {!Response}
 */
Response.error = function() {}
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function CredentialsContainer() {}
/**
 * @return {!Promise<undefined>}
 */
CredentialsContainer.prototype.preventSilentAccess = function() {}
/**
 * @param {!CredentialRequestOptions=} options
 * @return {!Promise<?Credential>}
 */
CredentialsContainer.prototype.get = function(options) {}
/**
 * @param {!CredentialCreationOptions=} options
 * @return {!Promise<?Credential>}
 */
CredentialsContainer.prototype.create = function(options) {}
/**
 * @param {!Credential} credential
 * @return {!Promise<!Credential>}
 */
CredentialsContainer.prototype.store = function(credential) {}
/**
 * @constructor
 * @private
 * @extends {EventTarget}
 * @nosideeffects
 */
function MediaSource() {}
/** @type {!SourceBufferList} */ MediaSource.prototype.activeSourceBuffers;
/** @type {!string} */ MediaSource.prototype.readyState;
/** @type {!SourceBufferList} */ MediaSource.prototype.sourceBuffers;
/** @type {!number} */ MediaSource.prototype.duration;
/** @type {!NullableEventHandler} */ MediaSource.prototype.onsourceclose;
/** @type {!NullableEventHandler} */ MediaSource.prototype.onsourceended;
/** @type {!NullableEventHandler} */ MediaSource.prototype.onsourceopen;
/**
 * @param {!SourceBuffer} sourceBuffer
 * @return {undefined}
 */
MediaSource.prototype.removeSourceBuffer = function(sourceBuffer) {}
/**
 * @param {!string=} error
 * @return {undefined}
 */
MediaSource.prototype.endOfStream = function(error) {}
/**
 * @param {!string} type
 * @return {!SourceBuffer}
 */
MediaSource.prototype.addSourceBuffer = function(type) {}
/**
 * @param {!number} start
 * @param {!number} end
 * @return {undefined}
 */
MediaSource.prototype.setLiveSeekableRange = function(start,end) {}
/**
 * @param {!string} type
 * @return {!boolean}
 */
MediaSource.isTypeSupported = function(type) {}
/**
 * @return {undefined}
 */
MediaSource.prototype.clearLiveSeekableRange = function() {}
/**
 * @constructor
 * @private
 * @extends {SVGElement}
 * @nosideeffects
 */
function SVGFESpotLightElement() {}
/** @type {!SVGAnimatedNumber} */ SVGFESpotLightElement.prototype.limitingConeAngle;
/** @type {!SVGAnimatedNumber} */ SVGFESpotLightElement.prototype.pointsAtX;
/** @type {!SVGAnimatedNumber} */ SVGFESpotLightElement.prototype.pointsAtY;
/** @type {!SVGAnimatedNumber} */ SVGFESpotLightElement.prototype.pointsAtZ;
/** @type {!SVGAnimatedNumber} */ SVGFESpotLightElement.prototype.specularExponent;
/** @type {!SVGAnimatedNumber} */ SVGFESpotLightElement.prototype.x;
/** @type {!SVGAnimatedNumber} */ SVGFESpotLightElement.prototype.y;
/** @type {!SVGAnimatedNumber} */ SVGFESpotLightElement.prototype.z;
/**
 * @constructor
 * @private
 * @extends {HTMLElement}
 * @nosideeffects
 */
function HTMLPreElement() {}
/** @type {!number} */ HTMLPreElement.prototype.width;
/**
 * @constructor
 * @extends {StyleSheet}
 * @param {!CSSStyleSheetInit=} options
 */
function CSSStyleSheet(options) {}
/** @type {!CSSRuleList} */ CSSStyleSheet.prototype.cssRules;
/** @type {?CSSRule} */ CSSStyleSheet.prototype.ownerRule;
/** @type {!CSSRuleList} */ CSSStyleSheet.prototype.rules;
/**
 * @param {!CSSOMString} rule
 * @param {!number=} index
 * @return {!number}
 */
CSSStyleSheet.prototype.insertRule = function(rule,index) {}
/**
 * @param {!string=} selector
 * @param {!string=} style
 * @param {!number=} index
 * @return {!number}
 */
CSSStyleSheet.prototype.addRule = function(selector,style,index) {}
/**
 * @param {!string} text
 * @return {!Promise<!CSSStyleSheet>}
 */
CSSStyleSheet.prototype.replace = function(text) {}
/**
 * @param {!number=} index
 * @return {undefined}
 */
CSSStyleSheet.prototype.removeRule = function(index) {}
/**
 * @param {!number} index
 * @return {undefined}
 */
CSSStyleSheet.prototype.deleteRule = function(index) {}
/**
 * @param {!string} text
 * @return {undefined}
 */
CSSStyleSheet.prototype.replaceSync = function(text) {}
/**
 * @constructor
 * @extends {Event}
 * @param {!string} type
 * @param {!RTCDataChannelEventInit} eventInitDict
 */
function RTCDataChannelEvent(type,eventInitDict) {}
/** @type {!RTCDataChannel} */ RTCDataChannelEvent.prototype.channel;
/**
 * @constructor
 * @private
 * @extends {WebGLObject}
 * @nosideeffects
 */
function WebGLVertexArrayObjectOES() {}
/**
 * @constructor
 * @private
 * @extends {ReportBody}
 * @nosideeffects
 */
function CSPViolationReportBody() {}
/** @type {?string} */ CSPViolationReportBody.prototype.blockedURL;
/** @type {?number} */ CSPViolationReportBody.prototype.columnNumber;
/** @type {!string} */ CSPViolationReportBody.prototype.disposition;
/** @type {!string} */ CSPViolationReportBody.prototype.documentURL;
/** @type {!string} */ CSPViolationReportBody.prototype.effectiveDirective;
/** @type {?number} */ CSPViolationReportBody.prototype.lineNumber;
/** @type {!string} */ CSPViolationReportBody.prototype.originalPolicy;
/** @type {?string} */ CSPViolationReportBody.prototype.referrer;
/** @type {?string} */ CSPViolationReportBody.prototype.sample;
/** @type {?string} */ CSPViolationReportBody.prototype.sourceFile;
/** @type {!number} */ CSPViolationReportBody.prototype.statusCode;
/**
 * @constructor
 * @private
 * @extends {Object}
 * @nosideeffects
 */
function EXT_color_buffer_half_float() {}
/** @const {!GLenum} */ EXT_color_buffer_half_float.prototype.FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE_EXT;
/** @const {!GLenum} */ EXT_color_buffer_half_float.prototype.RGB16F_EXT;
/** @const {!GLenum} */ EXT_color_buffer_half_float.prototype.RGBA16F_EXT;
/** @const {!GLenum} */ EXT_color_buffer_half_float.prototype.UNSIGNED_NORMALIZED_EXT;
/**
 * @constructor
 * @private
 * @extends {HTMLElement}
 * @nosideeffects
 */
function HTMLCanvasElement() {}
/** @type {!number} */ HTMLCanvasElement.prototype.height;
/** @type {!number} */ HTMLCanvasElement.prototype.width;
/**
 * @return {!OffscreenCanvas}
 */
HTMLCanvasElement.prototype.transferControlToOffscreen = function() {}
/**
 * @param {!BlobCallback} _callback
 * @param {!string=} type
 * @param {*=} quality
 * @return {undefined}
 */
HTMLCanvasElement.prototype.toBlob = function(_callback,type,quality) {}
/**
 * @param {!string=} type
 * @param {*=} quality
 * @return {!string}
 */
HTMLCanvasElement.prototype.toDataURL = function(type,quality) {}
/**
 * @param {!string} contextId
 * @param {(!CanvasRenderingContext2DSettings|!ImageBitmapRenderingContextSettings|!WebGLContextAttributes)=} options
 * @return {?RenderingContext}
 */
HTMLCanvasElement.prototype.getContext = function(contextId,options) {}
/**
 * @typedef {(!number|!DOMPointInit)}
 */
var UnrestrictedDoubleOrDOMPointInitUnion;
/**
 * @typedef {(!IDBObjectStore|!IDBIndex)}
 */
var IDBObjectStoreOrIDBIndexUnion;
/**
 * @typedef {(!IDBObjectStore|!IDBIndex|!IDBCursor)}
 */
var IDBObjectStoreOrIDBIndexOrIDBCursorUnion;
/**
 * @typedef {(!number|!string)}
 */
var UnrestrictedDoubleOrStringUnion;
/**
 * @typedef {(!string|!Array<!string>)}
 */
var CompositeOperationOrAutoOrCompositeOperationOrAutoArrayUnion;
/**
 * @typedef {(!ImageBitmap|!HTMLCanvasElement|!OffscreenCanvas)}
 */
var ImageBitmapOrHTMLCanvasElementOrOffscreenCanvasUnion;
/**
 * @typedef {(!string|undefined)}
 */
var GPUDeviceLostReasonOrUndefinedUnion;
/**
 * @typedef {(!Element|!ProcessingInstruction)}
 */
var ElementOrProcessingInstructionUnion;
/**
 * @typedef {(!string|!ArrayBuffer)}
 */
var StringOrArrayBufferUnion;
/**
 * @typedef {(!RadioNodeList|!Element)}
 */
var RadioNodeListOrElementUnion;
/**
 * @typedef {(!Event|!string)}
 */
var EventOrStringUnion;
/**
 * @typedef {(!Event|undefined)}
 */
var EventOrUndefinedUnion;
/**
 * @typedef {(!string|!GPUColor)}
 */
var GPULoadOpOrGPUColorUnion;
/**
 * @typedef {(!string|!GPUStencilValue)}
 */
var GPULoadOpOrGPUStencilValueUnion;
/**
 * @typedef {(!CustomElementConstructor|undefined)}
 */
var CustomElementConstructorOrUndefinedUnion;
/**
 * @typedef {(!MediaList|!string)}
 */
var MediaListOrStringUnion;
/**
 * @typedef {(!Response|undefined)}
 */
var ResponseOrUndefinedUnion;
/**
 * @typedef {(!string|!number)}
 */
var GPULoadOpOrFloatUnion;
/**
 * @typedef {(!string|!number)}
 */
var StringOrUnsignedLongUnion;
/**
 * @typedef {(!ServiceWorkerRegistration|undefined)}
 */
var ServiceWorkerRegistrationOrUndefinedUnion;
/**
 * @typedef {(!HTMLCollection|!Element)}
 */
var HTMLCollectionOrElementUnion;
/**
 * @typedef {(!boolean|!MediaTrackConstraints)}
 */
var BooleanOrMediaTrackConstraintsUnion;
/**
 * @typedef {(!VideoTrack|!AudioTrack|!TextTrack)}
 */
var VideoTrackOrAudioTrackOrTextTrackUnion;
/**
 * @typedef {(!string|!CanvasGradient|!CanvasPattern)}
 */
var StringOrCanvasGradientOrCanvasPatternUnion;
/**
 * @typedef {(!number|!Array<!number>)}
 */
var DoubleOrDoubleArrayUnion;
/**
 * @typedef {(!AudioNode|undefined)}
 */
var AudioNodeOrUndefinedUnion;
/**
 * @typedef {(!string|!Array<!UUID>)}
 */
var StringOrUUIDArrayUnion;
/**
 * @typedef {(!string|!Array<!string>)}
 */
var StringOrStringArrayUnion;
/**
 * @typedef {(!BufferSource|!string)}
 */
var BufferSourceOrStringUnion;
/**
 * @typedef {(!Element|!Document)}
 */
var ElementOrDocumentUnion;
/**
 * @typedef {(!string|!number)}
 */
var AudioContextLatencyCategoryOrDoubleUnion;
/**
 * @typedef {(!Document|?WindowProxy)}
 */
var DocumentOrWindowProxyUnion;
/**
 * @typedef {(!HTMLCanvasElement|!OffscreenCanvas)}
 */
var HTMLCanvasElementOrOffscreenCanvasUnion;
/** @type {!Navigator} */ var clientInformation;
/** @type {!boolean} */ var closed;
/** @type {!CustomElementRegistry} */ var customElements;
/** @type {!Document} */ var document;
/** @type {?Element} */ var frameElement;
/** @type {!WindowProxy} */ var frames;
/** @type {!History} */ var history;
/** @type {!number} */ var length;
/** @type {!Location} */ var location;
/** @type {!BarProp} */ var locationbar;
/** @type {!BarProp} */ var menubar;
/** @type {!Navigator} */ var navigator;
/** @type {!boolean} */ var originAgentCluster;
/** @type {?WindowProxy} */ var parent;
/** @type {!BarProp} */ var personalbar;
/** @type {!BarProp} */ var scrollbars;
/** @type {!WindowProxy} */ var self;
/** @type {!BarProp} */ var statusbar;
/** @type {!BarProp} */ var toolbar;
/** @type {?WindowProxy} */ var top;
/** @type {!WindowProxy} */ var window;
/** @type {!string} */ var name;
/** @type {*} */ var opener;
/** @type {!string} */ var status;
/** @type {!number} */ var devicePixelRatio;
/** @type {!number} */ var innerHeight;
/** @type {!number} */ var innerWidth;
/** @type {!number} */ var outerHeight;
/** @type {!number} */ var outerWidth;
/** @type {!number} */ var pageXOffset;
/** @type {!number} */ var pageYOffset;
/** @type {!Screen} */ var screen;
/** @type {!number} */ var screenLeft;
/** @type {!number} */ var screenTop;
/** @type {!number} */ var screenX;
/** @type {!number} */ var screenY;
/** @type {!number} */ var scrollX;
/** @type {!number} */ var scrollY;
/** @type {?DeviceOrientationEventHandler} */ var ondeviceorientation;
/** @type {!NullableEventHandler} */ var ondeviceorientationabsolute;
/** @type {!NullableEventHandler} */ var oncompassneedscalibration;
/** @type {?DeviceMotionEventHandler} */ var ondevicemotion;
/** @type {!SpeechSynthesis} */ var speechSynthesis;
/** @type {!VisualViewport} */ var visualViewport;
/** @type {!number} */ var orientation;
/** @type {?EventHandler} */ var onorientationchange;
/** @type {EventOrUndefinedUnion} */ var event;
/** @type {!boolean} */ var crossOriginIsolated;
/** @type {!boolean} */ var isSecureContext;
/** @type {!string} */ var origin;
/** @type {!Performance} */ var performance;
/** @type {!IDBFactory} */ var indexedDB;
/** @type {!CacheStorage} */ var caches;
/** @type {!Crypto} */ var crypto;
/** @type {?EventHandler} */ var onafterprint;
/** @type {?EventHandler} */ var onbeforeprint;
/** @type {!NullableOnBeforeUnloadEventHandler} */ var onbeforeunload;
/** @type {?HashChangeEventHandler} */ var onhashchange;
/** @type {?EventHandler} */ var onlanguagechange;
/** @type {?MessageEventHandler} */ var onmessage;
/** @type {?MessageEventHandler} */ var onmessageerror;
/** @type {?EventHandler} */ var onoffline;
/** @type {?EventHandler} */ var ononline;
/** @type {?PageTransitionEventHandler} */ var onpagehide;
/** @type {?PageTransitionEventHandler} */ var onpageshow;
/** @type {!NullableEventHandler} */ var onpopstate;
/** @type {?PromiseRejectionEventHandler} */ var onrejectionhandled;
/** @type {?StorageEventHandler} */ var onstorage;
/** @type {?PromiseRejectionEventHandler} */ var onunhandledrejection;
/** @type {?EventHandler} */ var onunload;
/** @type {?GamepadEventHandler} */ var ongamepadconnected;
/** @type {?GamepadEventHandler} */ var ongamepaddisconnected;
/** @type {!Storage} */ var localStorage;
/** @type {!NullableEventHandler} */ var onabort;
/** @type {!NullableEventHandler} */ var onauxclick;
/** @type {?FocusEventHandler} */ var onblur;
/** @type {!NullableEventHandler} */ var oncancel;
/** @type {!NullableEventHandler} */ var oncanplay;
/** @type {!NullableEventHandler} */ var oncanplaythrough;
/** @type {!NullableEventHandler} */ var onchange;
/** @type {!NullableEventHandler} */ var onclick;
/** @type {!NullableEventHandler} */ var onclose;
/** @type {!NullableEventHandler} */ var oncontextmenu;
/** @type {!NullableEventHandler} */ var oncuechange;
/** @type {!NullableEventHandler} */ var ondblclick;
/** @type {!NullableEventHandler} */ var ondrag;
/** @type {!NullableEventHandler} */ var ondragend;
/** @type {!NullableEventHandler} */ var ondragenter;
/** @type {!NullableEventHandler} */ var ondragleave;
/** @type {!NullableEventHandler} */ var ondragover;
/** @type {!NullableEventHandler} */ var ondragstart;
/** @type {!NullableEventHandler} */ var ondrop;
/** @type {!NullableEventHandler} */ var ondurationchange;
/** @type {!NullableEventHandler} */ var onemptied;
/** @type {!NullableEventHandler} */ var onended;
/** @type {!NullableOnErrorEventHandler} */ var onerror;
/** @type {?FocusEventHandler} */ var onfocus;
/** @type {!NullableEventHandler} */ var onformdata;
/** @type {!NullableEventHandler} */ var oninput;
/** @type {!NullableEventHandler} */ var oninvalid;
/** @type {!NullableEventHandler} */ var onkeydown;
/** @type {!NullableEventHandler} */ var onkeypress;
/** @type {!NullableEventHandler} */ var onkeyup;
/** @type {?EventHandler} */ var onload;
/** @type {!NullableEventHandler} */ var onloadeddata;
/** @type {!NullableEventHandler} */ var onloadedmetadata;
/** @type {!NullableEventHandler} */ var onloadstart;
/** @type {!NullableEventHandler} */ var onmousedown;
/** @type {!NullableEventHandler} */ var onmouseenter;
/** @type {!NullableEventHandler} */ var onmouseleave;
/** @type {!NullableEventHandler} */ var onmousemove;
/** @type {!NullableEventHandler} */ var onmouseout;
/** @type {!NullableEventHandler} */ var onmouseover;
/** @type {!NullableEventHandler} */ var onmouseup;
/** @type {!NullableEventHandler} */ var onpause;
/** @type {!NullableEventHandler} */ var onplay;
/** @type {!NullableEventHandler} */ var onplaying;
/** @type {!NullableEventHandler} */ var onprogress;
/** @type {!NullableEventHandler} */ var onratechange;
/** @type {!NullableEventHandler} */ var onreset;
/** @type {?UIEventHandler} */ var onresize;
/** @type {!NullableEventHandler} */ var onscroll;
/** @type {!NullableEventHandler} */ var onsecuritypolicyviolation;
/** @type {!NullableEventHandler} */ var onseeked;
/** @type {!NullableEventHandler} */ var onseeking;
/** @type {!NullableEventHandler} */ var onselect;
/** @type {!NullableEventHandler} */ var onslotchange;
/** @type {!NullableEventHandler} */ var onstalled;
/** @type {!NullableEventHandler} */ var onsubmit;
/** @type {!NullableEventHandler} */ var onsuspend;
/** @type {!NullableEventHandler} */ var ontimeupdate;
/** @type {!NullableEventHandler} */ var ontoggle;
/** @type {!NullableEventHandler} */ var onvolumechange;
/** @type {!NullableEventHandler} */ var onwaiting;
/** @type {!NullableEventHandler} */ var onwebkitanimationend;
/** @type {!NullableEventHandler} */ var onwebkitanimationiteration;
/** @type {!NullableEventHandler} */ var onwebkitanimationstart;
/** @type {!NullableEventHandler} */ var onwebkittransitionend;
/** @type {!NullableEventHandler} */ var onwheel;
/** @type {?AnimationEventHandler} */ var onanimationcancel;
/** @type {?AnimationEventHandler} */ var onanimationend;
/** @type {?AnimationEventHandler} */ var onanimationiteration;
/** @type {?AnimationEventHandler} */ var onanimationstart;
/** @type {?TransitionEventHandler} */ var ontransitioncancel;
/** @type {?TransitionEventHandler} */ var ontransitionend;
/** @type {?TransitionEventHandler} */ var ontransitionrun;
/** @type {?TransitionEventHandler} */ var ontransitionstart;
/** @type {!NullableEventHandler} */ var ongotpointercapture;
/** @type {!NullableEventHandler} */ var onlostpointercapture;
/** @type {!NullableEventHandler} */ var onpointercancel;
/** @type {!NullableEventHandler} */ var onpointerdown;
/** @type {!NullableEventHandler} */ var onpointerenter;
/** @type {!NullableEventHandler} */ var onpointerleave;
/** @type {!NullableEventHandler} */ var onpointermove;
/** @type {!NullableEventHandler} */ var onpointerout;
/** @type {!NullableEventHandler} */ var onpointerover;
/** @type {!NullableEventHandler} */ var onpointerup;
/** @type {!NullableEventHandler} */ var onselectionchange;
/** @type {!NullableEventHandler} */ var onselectstart;
/** @type {!NullableEventHandler} */ var ontouchcancel;
/** @type {!NullableEventHandler} */ var ontouchend;
/** @type {!NullableEventHandler} */ var ontouchmove;
/** @type {!NullableEventHandler} */ var ontouchstart;
/** @type {!Storage} */ var sessionStorage;
/**
 * @param {(!ScrollToOptions|!number)=} arg0
 * @param {!number=} arg1
 * @return {undefined}
 */
function scrollBy(arg0,arg1) {}
/**
 * @return {undefined}
 */
function focus() {}
/**
 * @return {undefined}
 */
function blur() {}
/**
 * @param {!VoidFunction} callback
 * @return {undefined}
 */
function queueMicrotask(callback) {}
/**
 * @param {!string} data
 * @return {!string}
 * @nosideeffects
 */
function btoa(data) {}
/**
 * @param {!Element} elt
 * @param {?CSSOMString=} pseudoElt
 * @return {!CSSStyleDeclaration}
 * @nosideeffects
 */
function getComputedStyle(elt,pseudoElt) {}
/**
 * @param {!FrameRequestCallback} callback
 * @return {!number}
 */
function requestAnimationFrame(callback) {}
/**
 * @param {!number=} handle
 * @return {undefined}
 */
function clearInterval(handle) {}
/**
 * @param {!TimerHandler} handler
 * @param {!number=} timeout
 * @return {!number}
 */
function setInterval(handler,timeout) {}
/**
 * @param {!string=} arg0
 * @return {undefined}
 */
function alert(arg0) {}
/**
 * @param {!number} width
 * @param {!number} height
 * @return {undefined}
 */
function resizeTo(width,height) {}
/**
 * @param {!number=} handle
 * @return {undefined}
 */
function clearTimeout(handle) {}
/**
 * @param {*} arg0
 * @param {(!string|!WindowPostMessageOptions)=} arg1
 * @param {!Array<!Transferable>=} arg2
 * @return {undefined}
 */
function postMessage(arg0,arg1,arg2) {}
/**
 * @param {!number} x
 * @param {!number} y
 * @return {undefined}
 */
function moveBy(x,y) {}
/**
 * @param {!IdleRequestCallback} callback
 * @param {!IdleRequestOptions=} options
 * @return {!number}
 */
function requestIdleCallback(callback,options) {}
/**
 * @return {undefined}
 */
function close() {}
/**
 * @param {!number} handle
 * @return {undefined}
 */
function cancelAnimationFrame(handle) {}
/**
 * @param {!ImageBitmapSource} arg0
 * @param {(!ImageBitmapOptions|!number)=} arg1
 * @param {!number=} arg2
 * @param {!number=} arg3
 * @param {!number=} arg4
 * @param {!ImageBitmapOptions=} arg5
 * @return {!Promise<!ImageBitmap>}
 */
function createImageBitmap(arg0,arg1,arg2,arg3,arg4,arg5) {}
/**
 * @param {(!ScrollToOptions|!number)=} arg0
 * @param {!number=} arg1
 * @return {undefined}
 */
function scroll(arg0,arg1) {}
/**
 * @param {!string} data
 * @return {!string}
 * @nosideeffects
 */
function atob(data) {}
/**
 * @param {(!ScrollToOptions|!number)=} arg0
 * @param {!number=} arg1
 * @return {undefined}
 */
function scrollTo(arg0,arg1) {}
/**
 * @param {!string=} message
 * @return {!boolean}
 */
function confirm(message) {}
/**
 * @param {!TimerHandler} handler
 * @param {!number=} timeout
 * @return {!number}
 */
function setTimeout(handler,timeout) {}
/**
 * @param {!number} x
 * @param {!number} y
 * @return {undefined}
 */
function resizeBy(x,y) {}
/**
 * @return {undefined}
 */
function print() {}
/**
 * @return {?Selection}
 * @nosideeffects
 */
function getSelection() {}
/**
 * @return {undefined}
 */
function stop() {}
/**
 * @param {!number} handle
 * @return {undefined}
 */
function cancelIdleCallback(handle) {}
/**
 * @param {!RequestInfo} input
 * @param {!RequestInit=} init
 * @return {!Promise<!Response>}
 */
function fetch(input,init) {}
/**
 * @param {!CSSOMString} query
 * @return {!MediaQueryList}
 */
function matchMedia(query) {}
/**
 * @param {!string=} message
 * @param {!string=} default_
 * @return {?string}
 */
function prompt(message,default_) {}
/**
 * @param {!string=} url
 * @param {!string=} target
 * @param {!string=} features
 * @return {?WindowProxy}
 */
function open(url,target,features) {}
/**
 * @param {!number} x
 * @param {!number} y
 * @return {undefined}
 */
function moveTo(x,y) {}
/**
 * This type def is an alias because the type is used in closure/base that is added during J2CL compiles.
 *
 * @typedef {Document}
 */
var HTMLDocument;
