/*
 * Decompiled with CFR 0.152.
 */
package akasha;

import java.lang.annotation.Documented;
import javax.annotation.Nonnull;

@Documented
public @interface FormEncodingType {
    @Nonnull
    public static final String urlencoded = "application/x-www-form-urlencoded";
    @Nonnull
    public static final String multipart_form_data = "multipart/form-data";
    @Nonnull
    public static final String text_plain = "text/plain";

    public static final class Util {
        private Util() {
        }

        @FormEncodingType
        public static String requireValid(String value) {
            Util.assertValid(value);
            return value;
        }

        public static void assertValid(@Nonnull String value) {
            assert (Util.isValid(value));
        }

        public static boolean isValid(@Nonnull String value) {
            return FormEncodingType.urlencoded.equals(value) || FormEncodingType.multipart_form_data.equals(value) || FormEncodingType.text_plain.equals(value);
        }
    }
}

