/*
 * Decompiled with CFR 0.152.
 */
package akasha.gpu;

import java.lang.annotation.Documented;
import javax.annotation.Nonnull;
import org.jetbrains.annotations.ApiStatus;

@Documented
@ApiStatus.Experimental
public @interface GPUBufferBindingType {
    @Nonnull
    public static final String read_only_storage = "read-only-storage";
    @Nonnull
    public static final String storage = "storage";
    @Nonnull
    public static final String uniform = "uniform";

    public static final class Util {
        private Util() {
        }

        @GPUBufferBindingType
        public static String requireValid(String value) {
            Util.assertValid(value);
            return value;
        }

        public static void assertValid(@Nonnull String value) {
            assert (Util.isValid(value));
        }

        public static boolean isValid(@Nonnull String value) {
            return GPUBufferBindingType.read_only_storage.equals(value) || GPUBufferBindingType.storage.equals(value) || GPUBufferBindingType.uniform.equals(value);
        }
    }
}

