/*
 * Decompiled with CFR 0.152.
 */
package akasha.gpu;

import java.lang.annotation.Documented;
import javax.annotation.Nonnull;

@Documented
public @interface GPUShaderStageFlags {

    public static final class Util {
        private Util() {
        }

        @GPUShaderStageFlags
        public static int requireValid(int value) {
            Util.assertValid(value);
            return value;
        }

        public static void assertValid(int value) {
            assert (Util.isValid(value)) : "@GPUShaderStageFlags annotated value must be one of [GPUShaderStage.VERTEX, GPUShaderStage.FRAGMENT, GPUShaderStage.COMPUTE] but is " + value;
        }

        public static boolean isValid(int value) {
            return 1 == value || 2 == value || 4 == value;
        }

        @Nonnull
        public static String describe(int value) {
            return 1 == value ? "VERTEX" : (2 == value ? "FRAGMENT" : (4 == value ? "COMPUTE" : "Unknown value " + value));
        }
    }
}

