/*
 * Decompiled with CFR 0.152.
 */
package akasha;

import java.lang.annotation.Documented;
import javax.annotation.Nonnull;

@Documented
public @interface ReferrerPolicy {
    @Nonnull
    public static final String no_referrer = "no-referrer";
    @Nonnull
    public static final String no_referrer_when_downgrade = "no-referrer-when-downgrade";
    @Nonnull
    public static final String origin = "origin";
    @Nonnull
    public static final String origin_when_cross_origin = "origin-when-cross-origin";
    @Nonnull
    public static final String same_origin = "same-origin";
    @Nonnull
    public static final String strict_origin = "strict-origin";
    @Nonnull
    public static final String strict_origin_when_cross_origin = "strict-origin-when-cross-origin";
    @Nonnull
    public static final String unsafe_url = "unsafe-url";

    public static final class Util {
        private Util() {
        }

        @ReferrerPolicy
        public static String requireValid(String value) {
            Util.assertValid(value);
            return value;
        }

        public static void assertValid(@Nonnull String value) {
            assert (Util.isValid(value));
        }

        public static boolean isValid(@Nonnull String value) {
            return ReferrerPolicy.no_referrer.equals(value) || ReferrerPolicy.no_referrer_when_downgrade.equals(value) || ReferrerPolicy.origin.equals(value) || ReferrerPolicy.origin_when_cross_origin.equals(value) || ReferrerPolicy.same_origin.equals(value) || ReferrerPolicy.strict_origin.equals(value) || ReferrerPolicy.strict_origin_when_cross_origin.equals(value) || ReferrerPolicy.unsafe_url.equals(value);
        }
    }
}

