/*
 * Decompiled with CFR 0.152.
 */
package akasha.crypto;

import java.lang.annotation.Documented;
import javax.annotation.Nonnull;

@Documented
public @interface KeyFormat {
    @Nonnull
    public static final String jwk = "jwk";
    @Nonnull
    public static final String pkcs8 = "pkcs8";
    @Nonnull
    public static final String raw = "raw";
    @Nonnull
    public static final String spki = "spki";

    public static final class Util {
        private Util() {
        }

        @KeyFormat
        public static String requireValid(String value) {
            Util.assertValid(value);
            return value;
        }

        public static void assertValid(@Nonnull String value) {
            assert (Util.isValid(value));
        }

        public static boolean isValid(@Nonnull String value) {
            return KeyFormat.jwk.equals(value) || KeyFormat.pkcs8.equals(value) || KeyFormat.raw.equals(value) || KeyFormat.spki.equals(value);
        }
    }
}

