/*
 * Decompiled with CFR 0.152.
 */
package akasha.crypto;

import java.lang.annotation.Documented;
import javax.annotation.Nonnull;

@Documented
public @interface KeyUsage {
    @Nonnull
    public static final String decrypt = "decrypt";
    @Nonnull
    public static final String deriveBits = "deriveBits";
    @Nonnull
    public static final String deriveKey = "deriveKey";
    @Nonnull
    public static final String encrypt = "encrypt";
    @Nonnull
    public static final String sign = "sign";
    @Nonnull
    public static final String unwrapKey = "unwrapKey";
    @Nonnull
    public static final String verify = "verify";
    @Nonnull
    public static final String wrapKey = "wrapKey";

    public static final class Util {
        private Util() {
        }

        @KeyUsage
        public static String requireValid(String value) {
            Util.assertValid(value);
            return value;
        }

        public static void assertValid(@Nonnull String value) {
            assert (Util.isValid(value));
        }

        public static boolean isValid(@Nonnull String value) {
            return KeyUsage.decrypt.equals(value) || KeyUsage.deriveBits.equals(value) || KeyUsage.deriveKey.equals(value) || KeyUsage.encrypt.equals(value) || KeyUsage.sign.equals(value) || KeyUsage.unwrapKey.equals(value) || KeyUsage.verify.equals(value) || KeyUsage.wrapKey.equals(value);
        }
    }
}

