/*
 * Decompiled with CFR 0.152.
 */
package akasha.wasm;

import java.lang.annotation.Documented;
import javax.annotation.Nonnull;

@Documented
public @interface ValueType {
    @Nonnull
    public static final String f32 = "f32";
    @Nonnull
    public static final String f64 = "f64";
    @Nonnull
    public static final String i32 = "i32";
    @Nonnull
    public static final String i64 = "i64";

    public static final class Util {
        private Util() {
        }

        @ValueType
        public static String requireValid(String value) {
            Util.assertValid(value);
            return value;
        }

        public static void assertValid(@Nonnull String value) {
            assert (Util.isValid(value));
        }

        public static boolean isValid(@Nonnull String value) {
            return ValueType.f32.equals(value) || ValueType.f64.equals(value) || ValueType.i32.equals(value) || ValueType.i64.equals(value);
        }
    }
}

