package akasha;

import javax.annotation.Generated;
import javax.annotation.Nonnull;
import jsinterop.annotations.JsOverlay;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsProperty;
import jsinterop.annotations.JsType;

/**
 * KeyboardEvent objects describe a user interaction with the keyboard; each event describes a single interaction between the user and a key (or combination of a key with modifier keys) on the keyboard. The event type (keydown, keypress, or keyup) identifies what kind of keyboard activity occurred.
 *
 * @see <a href="https://developer.mozilla.org/en-US/docs/Web/API/KeyboardEvent">KeyboardEvent - MDN</a>
 * @see <a href="https://w3c.github.io/uievents/#interface-keyboardevent"># interface-keyboardevent</a>
 */
@Generated("org.realityforge.webtack")
@JsType(
    isNative = true,
    namespace = JsPackage.GLOBAL,
    name = "KeyboardEvent"
)
public class KeyboardEvent extends UIEvent {
  @JsOverlay
  public static final int DOM_KEY_LOCATION_LEFT = 0x01;

  @JsOverlay
  public static final int DOM_KEY_LOCATION_NUMPAD = 0x03;

  @JsOverlay
  public static final int DOM_KEY_LOCATION_RIGHT = 0x02;

  @JsOverlay
  public static final int DOM_KEY_LOCATION_STANDARD = 0x00;

  /**
   * The KeyboardEvent() constructor creates a new KeyboardEvent.
   *
   * @see <a href="https://developer.mozilla.org/en-US/docs/Web/API/KeyboardEvent/KeyboardEvent">KeyboardEvent.KeyboardEvent - MDN</a>
   * @see <a href="https://w3c.github.io/uievents/#dom-keyboardevent-keyboardevent">KeyboardEvent() - UI Events</a>
   * @see <a href="https://www.w3.org/TR/2014/WD-DOM-Level-3-Events-20140925/#interface-KeyboardEvent">KeyboardEvent() - Document Object Model (DOM) Level 3 Events Specification</a>
   */
  public KeyboardEvent(@Nonnull final String type, @Nonnull final KeyboardEventInit eventInitDict) {
    super( null );
  }

  /**
   * The KeyboardEvent() constructor creates a new KeyboardEvent.
   *
   * @see <a href="https://developer.mozilla.org/en-US/docs/Web/API/KeyboardEvent/KeyboardEvent">KeyboardEvent.KeyboardEvent - MDN</a>
   * @see <a href="https://w3c.github.io/uievents/#dom-keyboardevent-keyboardevent">KeyboardEvent() - UI Events</a>
   * @see <a href="https://www.w3.org/TR/2014/WD-DOM-Level-3-Events-20140925/#interface-KeyboardEvent">KeyboardEvent() - Document Object Model (DOM) Level 3 Events Specification</a>
   */
  public KeyboardEvent(@Nonnull final String type) {
    super( null );
  }

  /**
   * The KeyboardEvent.altKey read-only property is a Boolean that indicates if the alt key (Option or ⌥ on OS X) was pressed (true) or not (false) when the event occured.
   *
   * @see <a href="https://developer.mozilla.org/en-US/docs/Web/API/KeyboardEvent/altKey">KeyboardEvent.altKey - MDN</a>
   * @see <a href="https://www.w3.org/TR/2014/WD-DOM-Level-3-Events-20140925/#widl-KeyboardEvent-altKey">KeyboardEvent.altkey - Document Object Model (DOM) Level 3 Events Specification</a>
   */
  @JsProperty(
      name = "altKey"
  )
  public native boolean altKey();

  /**
   * The charCode read-only property of the KeyboardEvent interface returns the Unicode value of a character key pressed during a keypress event.
   *
   * @see <a href="https://developer.mozilla.org/en-US/docs/Web/API/KeyboardEvent/charCode">KeyboardEvent.charCode - MDN</a>
   * @see <a href="https://www.w3.org/TR/2014/WD-DOM-Level-3-Events-20140925/#widl-KeyboardEvent-charCode">KeyboardEvent.charCode - Document Object Model (DOM) Level 3 Events Specification</a>
   */
  @JsProperty(
      name = "charCode"
  )
  public native int charCode();

  /**
   * The KeyboardEvent.code property represents a physical key on the keyboard (as opposed to the character generated by pressing the key). In other words, this property returns a value that isn't altered by keyboard layout or the state of the modifier keys.
   *
   * @see <a href="https://developer.mozilla.org/en-US/docs/Web/API/KeyboardEvent/code">KeyboardEvent.code - MDN</a>
   */
  @JsProperty(
      name = "code"
  )
  @Nonnull
  public native String code();

  /**
   * The KeyboardEvent.ctrlKey read-only property returns a Boolean that indicates if the control key was pressed (true) or not (false) when the event occured.
   *
   * @see <a href="https://developer.mozilla.org/en-US/docs/Web/API/KeyboardEvent/ctrlKey">KeyboardEvent.ctrlKey - MDN</a>
   * @see <a href="https://www.w3.org/TR/2014/WD-DOM-Level-3-Events-20140925/#widl-KeyboardEvent-ctrlKey">KeyboardEvent.ctrlKey - Document Object Model (DOM) Level 3 Events Specification</a>
   */
  @JsProperty(
      name = "ctrlKey"
  )
  public native boolean ctrlKey();

  /**
   * The KeyboardEvent.isComposing read-only property returns a Boolean value indicating if the event is fired within a composition session, i.e. after compositionstart and before compositionend.
   *
   * @see <a href="https://developer.mozilla.org/en-US/docs/Web/API/KeyboardEvent/isComposing">KeyboardEvent.isComposing - MDN</a>
   * @see <a href="https://w3c.github.io/uievents/#dom-keyboardevent-iscomposing">KeyboardEvent.prototype.isComposing - UI Events</a>
   * @see <a href="https://www.w3.org/TR/2014/WD-DOM-Level-3-Events-20140925/#widl-KeyboardEvent-isComposing">KeyboardEvent.prototype.isComposing - Document Object Model (DOM) Level 3 Events Specification</a>
   */
  @JsProperty(
      name = "isComposing"
  )
  public native boolean isComposing();

  /**
   * The KeyboardEvent interface's key read-only property returns the value of the key pressed by the user, taking into consideration the state of modifier keys such as Shift as well as the keyboard locale and layout.
   *
   * @see <a href="https://developer.mozilla.org/en-US/docs/Web/API/KeyboardEvent/key">KeyboardEvent.key - MDN</a>
   */
  @JsProperty(
      name = "key"
  )
  @Nonnull
  public native String key();

  /**
   * The deprecated KeyboardEvent.keyCode read-only property represents a system and implementation dependent numerical code identifying the unmodified value of the pressed key.
   *
   * @see <a href="https://developer.mozilla.org/en-US/docs/Web/API/KeyboardEvent/keyCode">KeyboardEvent.keyCode - MDN</a>
   * @see <a href="https://www.w3.org/TR/2014/WD-DOM-Level-3-Events-20140925/#widl-KeyboardEvent-keyCode">KeyboardEvent.keyCode - Document Object Model (DOM) Level 3 Events Specification</a>
   */
  @JsProperty(
      name = "keyCode"
  )
  public native int keyCode();

  /**
   * The KeyboardEvent.location read-only property returns an unsigned long representing the location of the key on the keyboard or other input device.
   *
   * @see <a href="https://developer.mozilla.org/en-US/docs/Web/API/KeyboardEvent/location">KeyboardEvent.location - MDN</a>
   * @see <a href="https://www.w3.org/TR/2014/WD-DOM-Level-3-Events-20140925/#widl-KeyboardEvent-location">KeyboardEvent.location - Document Object Model (DOM) Level 3 Events Specification</a>
   */
  @JsProperty(
      name = "location"
  )
  @KeyboardEventLocation
  public native int location();

  /**
   * The KeyboardEvent.metaKey read-only property returning a Boolean that indicates if the Meta key was pressed (true) or not (false) when the event occurred. Some operating systems may intercept the key so it is never detected.
   *
   * @see <a href="https://developer.mozilla.org/en-US/docs/Web/API/KeyboardEvent/metaKey">KeyboardEvent.metaKey - MDN</a>
   * @see <a href="https://www.w3.org/TR/2014/WD-DOM-Level-3-Events-20140925/#widl-KeyboardEvent-metaKey">KeyboardEvent.metaKey - Document Object Model (DOM) Level 3 Events Specification</a>
   */
  @JsProperty(
      name = "metaKey"
  )
  public native boolean metaKey();

  /**
   * The repeat read-only property of the KeyboardEvent interface returns a Boolean that is true if the given key is being held down such that it is automatically repeating.
   *
   * @see <a href="https://developer.mozilla.org/en-US/docs/Web/API/KeyboardEvent/repeat">KeyboardEvent.repeat - MDN</a>
   * @see <a href="https://www.w3.org/TR/2014/WD-DOM-Level-3-Events-20140925/#widl-KeyboardEvent-repeat">KeyboardEvent.repeat - Document Object Model (DOM) Level 3 Events Specification</a>
   */
  @JsProperty(
      name = "repeat"
  )
  public native boolean repeat();

  /**
   * The KeyboardEvent.shiftKey read-only property is a Boolean that indicates if the shift key was pressed (true) or not (false) when the event occurred.
   *
   * @see <a href="https://developer.mozilla.org/en-US/docs/Web/API/KeyboardEvent/shiftKey">KeyboardEvent.shiftKey - MDN</a>
   * @see <a href="https://www.w3.org/TR/2014/WD-DOM-Level-3-Events-20140925/#widl-KeyboardEvent-shiftKey">KeyboardEvent.shiftKey - Document Object Model (DOM) Level 3 Events Specification</a>
   */
  @JsProperty(
      name = "shiftKey"
  )
  public native boolean shiftKey();

  /**
   * The KeyboardEvent.getModifierState() method returns the current state of the specified modifier key: true if the modifier is active (that is the modifier key is pressed or locked), otherwise, false.
   *
   * @see <a href="https://developer.mozilla.org/en-US/docs/Web/API/KeyboardEvent/getModifierState">KeyboardEvent.getModifierState - MDN</a>
   * @see <a href="https://www.w3.org/TR/2014/WD-DOM-Level-3-Events-20140925/#widl-KeyboardEvent-getModifierState">getModifierState() - Document Object Model (DOM) Level 3 Events Specification</a>
   */
  public native boolean getModifierState(@Nonnull String keyArg);
}
