/*
 * Decompiled with CFR 0.152.
 */
package akasha.codecs;

import java.lang.annotation.Documented;
import javax.annotation.Nonnull;

@Documented
public @interface VideoPixelFormat {
    @Nonnull
    public static final String BGRA = "BGRA";
    @Nonnull
    public static final String BGRX = "BGRX";
    @Nonnull
    public static final String I420 = "I420";
    @Nonnull
    public static final String I420A = "I420A";
    @Nonnull
    public static final String I422 = "I422";
    @Nonnull
    public static final String I444 = "I444";
    @Nonnull
    public static final String NV12 = "NV12";
    @Nonnull
    public static final String RGBA = "RGBA";
    @Nonnull
    public static final String RGBX = "RGBX";

    public static final class Util {
        private Util() {
        }

        @VideoPixelFormat
        public static String requireValid(String value) {
            Util.assertValid(value);
            return value;
        }

        public static void assertValid(@Nonnull String value) {
            assert (Util.isValid(value));
        }

        public static boolean isValid(@Nonnull String value) {
            return VideoPixelFormat.BGRA.equals(value) || VideoPixelFormat.BGRX.equals(value) || VideoPixelFormat.I420.equals(value) || VideoPixelFormat.I420A.equals(value) || VideoPixelFormat.I422.equals(value) || VideoPixelFormat.I444.equals(value) || VideoPixelFormat.NV12.equals(value) || VideoPixelFormat.RGBA.equals(value) || VideoPixelFormat.RGBX.equals(value);
        }
    }
}

