/*
 * Decompiled with CFR 0.152.
 */
package akasha.gpu;

import java.lang.annotation.Documented;
import javax.annotation.Nonnull;

@Documented
public @interface GPUMapModeFlags {

    public static final class Util {
        private Util() {
        }

        @GPUMapModeFlags
        public static int requireValid(int value) {
            Util.assertValid(value);
            return value;
        }

        public static void assertValid(int value) {
            assert (Util.isValid(value)) : "@GPUMapModeFlags annotated value must be one of [GPUMapMode.READ, GPUMapMode.WRITE] but is " + value;
        }

        public static boolean isValid(int value) {
            return 1 == value || 2 == value;
        }

        @Nonnull
        public static String describe(int value) {
            return 1 == value ? "READ" : (2 == value ? "WRITE" : "Unknown value " + value);
        }
    }
}

