/*
 * Decompiled with CFR 0.152.
 */
package akasha.idb;

import java.lang.annotation.Documented;
import javax.annotation.Nonnull;

@Documented
public @interface IDBTransactionDurability {
    @Nonnull
    public static final String default_ = "default";
    @Nonnull
    public static final String relaxed = "relaxed";
    @Nonnull
    public static final String strict = "strict";

    public static final class Util {
        private Util() {
        }

        @IDBTransactionDurability
        public static String requireValid(String value) {
            Util.assertValid(value);
            return value;
        }

        public static void assertValid(@Nonnull String value) {
            assert (Util.isValid(value));
        }

        public static boolean isValid(@Nonnull String value) {
            return IDBTransactionDurability.default_.equals(value) || IDBTransactionDurability.relaxed.equals(value) || IDBTransactionDurability.strict.equals(value);
        }
    }
}

