/*
 * Decompiled with CFR 0.152.
 */
package akasha.gpu;

import java.lang.annotation.Documented;
import javax.annotation.Nonnull;
import org.jetbrains.annotations.ApiStatus;

@Documented
@ApiStatus.Experimental
public @interface GPUCompareFunction {
    @Nonnull
    public static final String always = "always";
    @Nonnull
    public static final String equal = "equal";
    @Nonnull
    public static final String greater = "greater";
    @Nonnull
    public static final String greater_equal = "greater-equal";
    @Nonnull
    public static final String less = "less";
    @Nonnull
    public static final String less_equal = "less-equal";
    @Nonnull
    public static final String never = "never";
    @Nonnull
    public static final String not_equal = "not-equal";

    public static final class Util {
        private Util() {
        }

        @GPUCompareFunction
        public static String requireValid(String value) {
            Util.assertValid(value);
            return value;
        }

        public static void assertValid(@Nonnull String value) {
            assert (Util.isValid(value));
        }

        public static boolean isValid(@Nonnull String value) {
            return GPUCompareFunction.always.equals(value) || GPUCompareFunction.equal.equals(value) || GPUCompareFunction.greater.equals(value) || GPUCompareFunction.greater_equal.equals(value) || GPUCompareFunction.less.equals(value) || GPUCompareFunction.less_equal.equals(value) || GPUCompareFunction.never.equals(value) || GPUCompareFunction.not_equal.equals(value);
        }
    }
}

