package akasha;

import akasha.core.ArrayBuffer;
import akasha.core.BufferSource;
import akasha.promise.Promise;
import javax.annotation.Generated;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jsinterop.annotations.JsMethod;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsProperty;
import jsinterop.annotations.JsType;
import jsinterop.base.Any;

/**
 * The Response interface of the Fetch API represents the response to a request.
 *
 * @see <a href="https://developer.mozilla.org/en-US/docs/Web/API/Response">Response - MDN</a>
 * @see <a href="https://fetch.spec.whatwg.org/#response-class">Response - Fetch</a>
 */
@Generated("org.realityforge.webtack")
@JsType(
    isNative = true,
    namespace = JsPackage.GLOBAL,
    name = "Response"
)
public class Response {
  /**
   * The Response() constructor creates a new Response object.
   *
   * @see <a href="https://developer.mozilla.org/en-US/docs/Web/API/Response/Response">Response.Response - MDN</a>
   * @see <a href="https://fetch.spec.whatwg.org/#dom-response">Response() - Fetch</a>
   */
  public Response(@Nullable final BodyInit body, @Nonnull final ResponseInit init) {
  }

  /**
   * The Response() constructor creates a new Response object.
   *
   * @see <a href="https://developer.mozilla.org/en-US/docs/Web/API/Response/Response">Response.Response - MDN</a>
   * @see <a href="https://fetch.spec.whatwg.org/#dom-response">Response() - Fetch</a>
   */
  public Response(@Nonnull final ReadableStream body, @Nonnull final ResponseInit init) {
  }

  /**
   * The Response() constructor creates a new Response object.
   *
   * @see <a href="https://developer.mozilla.org/en-US/docs/Web/API/Response/Response">Response.Response - MDN</a>
   * @see <a href="https://fetch.spec.whatwg.org/#dom-response">Response() - Fetch</a>
   */
  public Response(@Nonnull final XMLHttpRequestBodyInit body, @Nonnull final ResponseInit init) {
  }

  /**
   * The Response() constructor creates a new Response object.
   *
   * @see <a href="https://developer.mozilla.org/en-US/docs/Web/API/Response/Response">Response.Response - MDN</a>
   * @see <a href="https://fetch.spec.whatwg.org/#dom-response">Response() - Fetch</a>
   */
  public Response(@Nonnull final Blob body, @Nonnull final ResponseInit init) {
  }

  /**
   * The Response() constructor creates a new Response object.
   *
   * @see <a href="https://developer.mozilla.org/en-US/docs/Web/API/Response/Response">Response.Response - MDN</a>
   * @see <a href="https://fetch.spec.whatwg.org/#dom-response">Response() - Fetch</a>
   */
  public Response(@Nonnull final BufferSource body, @Nonnull final ResponseInit init) {
  }

  /**
   * The Response() constructor creates a new Response object.
   *
   * @see <a href="https://developer.mozilla.org/en-US/docs/Web/API/Response/Response">Response.Response - MDN</a>
   * @see <a href="https://fetch.spec.whatwg.org/#dom-response">Response() - Fetch</a>
   */
  public Response(@Nonnull final FormData body, @Nonnull final ResponseInit init) {
  }

  /**
   * The Response() constructor creates a new Response object.
   *
   * @see <a href="https://developer.mozilla.org/en-US/docs/Web/API/Response/Response">Response.Response - MDN</a>
   * @see <a href="https://fetch.spec.whatwg.org/#dom-response">Response() - Fetch</a>
   */
  public Response(@Nonnull final URLSearchParams body, @Nonnull final ResponseInit init) {
  }

  /**
   * The Response() constructor creates a new Response object.
   *
   * @see <a href="https://developer.mozilla.org/en-US/docs/Web/API/Response/Response">Response.Response - MDN</a>
   * @see <a href="https://fetch.spec.whatwg.org/#dom-response">Response() - Fetch</a>
   */
  public Response(@Nonnull final String body, @Nonnull final ResponseInit init) {
  }

  /**
   * The Response() constructor creates a new Response object.
   *
   * @see <a href="https://developer.mozilla.org/en-US/docs/Web/API/Response/Response">Response.Response - MDN</a>
   * @see <a href="https://fetch.spec.whatwg.org/#dom-response">Response() - Fetch</a>
   */
  public Response(@Nullable final BodyInit body) {
  }

  /**
   * The Response() constructor creates a new Response object.
   *
   * @see <a href="https://developer.mozilla.org/en-US/docs/Web/API/Response/Response">Response.Response - MDN</a>
   * @see <a href="https://fetch.spec.whatwg.org/#dom-response">Response() - Fetch</a>
   */
  public Response(@Nonnull final ReadableStream body) {
  }

  /**
   * The Response() constructor creates a new Response object.
   *
   * @see <a href="https://developer.mozilla.org/en-US/docs/Web/API/Response/Response">Response.Response - MDN</a>
   * @see <a href="https://fetch.spec.whatwg.org/#dom-response">Response() - Fetch</a>
   */
  public Response(@Nonnull final XMLHttpRequestBodyInit body) {
  }

  /**
   * The Response() constructor creates a new Response object.
   *
   * @see <a href="https://developer.mozilla.org/en-US/docs/Web/API/Response/Response">Response.Response - MDN</a>
   * @see <a href="https://fetch.spec.whatwg.org/#dom-response">Response() - Fetch</a>
   */
  public Response(@Nonnull final Blob body) {
  }

  /**
   * The Response() constructor creates a new Response object.
   *
   * @see <a href="https://developer.mozilla.org/en-US/docs/Web/API/Response/Response">Response.Response - MDN</a>
   * @see <a href="https://fetch.spec.whatwg.org/#dom-response">Response() - Fetch</a>
   */
  public Response(@Nonnull final BufferSource body) {
  }

  /**
   * The Response() constructor creates a new Response object.
   *
   * @see <a href="https://developer.mozilla.org/en-US/docs/Web/API/Response/Response">Response.Response - MDN</a>
   * @see <a href="https://fetch.spec.whatwg.org/#dom-response">Response() - Fetch</a>
   */
  public Response(@Nonnull final FormData body) {
  }

  /**
   * The Response() constructor creates a new Response object.
   *
   * @see <a href="https://developer.mozilla.org/en-US/docs/Web/API/Response/Response">Response.Response - MDN</a>
   * @see <a href="https://fetch.spec.whatwg.org/#dom-response">Response() - Fetch</a>
   */
  public Response(@Nonnull final URLSearchParams body) {
  }

  /**
   * The Response() constructor creates a new Response object.
   *
   * @see <a href="https://developer.mozilla.org/en-US/docs/Web/API/Response/Response">Response.Response - MDN</a>
   * @see <a href="https://fetch.spec.whatwg.org/#dom-response">Response() - Fetch</a>
   */
  public Response(@Nonnull final String body) {
  }

  /**
   * The Response() constructor creates a new Response object.
   *
   * @see <a href="https://developer.mozilla.org/en-US/docs/Web/API/Response/Response">Response.Response - MDN</a>
   * @see <a href="https://fetch.spec.whatwg.org/#dom-response">Response() - Fetch</a>
   */
  public Response() {
  }

  /**
   * The body read-only property of the Body mixin is a simple getter used to expose a ReadableStream of the body contents.
   *
   * @see <a href="https://developer.mozilla.org/en-US/docs/Web/API/Body/body">Body.body - MDN</a>
   * @see <a href="https://fetch.spec.whatwg.org/#dom-body-body">body - Fetch</a>
   */
  @JsProperty(
      name = "body"
  )
  @Nullable
  public native ReadableStream body();

  /**
   * The bodyUsed read-only property of the Body mixin contains a Boolean that indicates whether the body has been read yet.
   *
   * @see <a href="https://developer.mozilla.org/en-US/docs/Web/API/Response/bodyUsed">Response.bodyUsed - MDN</a>
   * @see <a href="https://fetch.spec.whatwg.org/#dom-body-bodyused">bodyUsed - Fetch</a>
   */
  @JsProperty(
      name = "bodyUsed"
  )
  public native boolean bodyUsed();

  /**
   * The headers read-only property of the Response interface contains the Headers object associated with the response.
   *
   * @see <a href="https://developer.mozilla.org/en-US/docs/Web/API/Response/headers">Response.headers - MDN</a>
   * @see <a href="https://fetch.spec.whatwg.org/#dom-response-headers">headers - Fetch</a>
   */
  @JsProperty(
      name = "headers"
  )
  @Nonnull
  public native Headers headers();

  /**
   * The ok read-only property of the Response interface contains a Boolean stating whether the response was successful (status in the range 200-299) or not.
   *
   * @see <a href="https://developer.mozilla.org/en-US/docs/Web/API/Response/ok">Response.ok - MDN</a>
   * @see <a href="https://fetch.spec.whatwg.org/#dom-response-ok">ok - Fetch</a>
   */
  @JsProperty(
      name = "ok"
  )
  public native boolean ok();

  /**
   * The read-only redirected property of the Response interface indicates whether or not the response is the result of a request you made which was redirected.
   *
   * @see <a href="https://developer.mozilla.org/en-US/docs/Web/API/Response/redirected">Response.redirected - MDN</a>
   * @see <a href="https://fetch.spec.whatwg.org/#dom-response-redirected">redirected - Fetch</a>
   */
  @JsProperty(
      name = "redirected"
  )
  public native boolean redirected();

  /**
   * The status read-only property of the Response interface contains the status code of the response (e.g., 200 for a success).
   *
   * @see <a href="https://developer.mozilla.org/en-US/docs/Web/API/Response/status">Response.status - MDN</a>
   * @see <a href="https://fetch.spec.whatwg.org/#dom-response-status">status - Fetch</a>
   */
  @JsProperty(
      name = "status"
  )
  public native int status();

  /**
   * The statusText read-only property of the Response interface contains the status message corresponding to the status code (e.g., OK for 200).
   *
   * @see <a href="https://developer.mozilla.org/en-US/docs/Web/API/Response/statusText">Response.statusText - MDN</a>
   * @see <a href="https://fetch.spec.whatwg.org/#dom-response-statustext">statusText - Fetch</a>
   */
  @JsProperty(
      name = "statusText"
  )
  @Nonnull
  public native String statusText();

  /**
   * The type read-only property of the Response interface contains the type of the response. It can be one of the following:
   *
   * @see <a href="https://developer.mozilla.org/en-US/docs/Web/API/Response/type">Response.type - MDN</a>
   * @see <a href="https://fetch.spec.whatwg.org/#dom-response-type">type - Fetch</a>
   */
  @JsProperty(
      name = "type"
  )
  @Nonnull
  @ResponseType
  public native String type();

  /**
   * The url read-only property of the Response interface contains the URL of the response. The value of the url property will be the final URL obtained after any redirects.
   *
   * @see <a href="https://developer.mozilla.org/en-US/docs/Web/API/Response/url">Response.url - MDN</a>
   * @see <a href="https://fetch.spec.whatwg.org/#dom-response-url">url - Fetch</a>
   */
  @JsProperty(
      name = "url"
  )
  @Nonnull
  public native String url();

  /**
   * The error() method of the Response interface returns a new Response object associated with a network error.
   *
   * @see <a href="https://developer.mozilla.org/en-US/docs/Web/API/Response/error">Response.error - MDN</a>
   * @see <a href="https://fetch.spec.whatwg.org/#dom-response-error">error() - Fetch</a>
   */
  @Nonnull
  public static native Response error();

  /**
   * The redirect() method of the Response interface returns a Response resulting in a redirect to the specified URL.
   *
   * @see <a href="https://developer.mozilla.org/en-US/docs/Web/API/Response/redirect">Response.redirect - MDN</a>
   * @see <a href="https://fetch.spec.whatwg.org/#dom-response-redirect">redirect() - Fetch</a>
   */
  @Nonnull
  public static native Response redirect(@Nonnull String url, int status);

  /**
   * The redirect() method of the Response interface returns a Response resulting in a redirect to the specified URL.
   *
   * @see <a href="https://developer.mozilla.org/en-US/docs/Web/API/Response/redirect">Response.redirect - MDN</a>
   * @see <a href="https://fetch.spec.whatwg.org/#dom-response-redirect">redirect() - Fetch</a>
   */
  @Nonnull
  public static native Response redirect(@Nonnull String url);

  /**
   * The clone() method of the Response interface creates a clone of a response object, identical in every way, but stored in a different variable.
   *
   * @see <a href="https://developer.mozilla.org/en-US/docs/Web/API/Response/clone">Response.clone - MDN</a>
   * @see <a href="https://fetch.spec.whatwg.org/#dom-response-clone">clone() - Fetch</a>
   */
  @JsMethod(
      name = "clone"
  )
  @Nonnull
  public native Response clone_();

  /**
   * The arrayBuffer() method of the Body mixin takes a Response stream and reads it to completion. It returns a promise that resolves with an ArrayBuffer.
   *
   * @see <a href="https://developer.mozilla.org/en-US/docs/Web/API/Response/arrayBuffer">Response.arrayBuffer - MDN</a>
   * @see <a href="https://fetch.spec.whatwg.org/#dom-body-arraybuffer">arrayBuffer() - Fetch</a>
   */
  @Nonnull
  public native Promise<ArrayBuffer> arrayBuffer();

  /**
   * The blob() method of the Body mixin takes a Response stream and reads it to completion. It returns a promise that resolves with a Blob.
   *
   * @see <a href="https://developer.mozilla.org/en-US/docs/Web/API/Response/blob">Response.blob - MDN</a>
   * @see <a href="https://fetch.spec.whatwg.org/#dom-body-blob">blob() - Fetch</a>
   */
  @Nonnull
  public native Promise<Blob> blob();

  /**
   * The formData() method of the Body mixin takes a Response stream and reads it to completion. It returns a promise that resolves with a FormData object.
   *
   * @see <a href="https://developer.mozilla.org/en-US/docs/Web/API/Body/formData">Body.formData - MDN</a>
   * @see <a href="https://fetch.spec.whatwg.org/#dom-body-formdata">formData() - Fetch</a>
   */
  @Nonnull
  public native Promise<FormData> formData();

  /**
   * The json() method of the Body mixin takes a Response stream and reads it to completion. It returns a promise that resolves with the result of parsing the body text as JSON.
   *
   * @see <a href="https://developer.mozilla.org/en-US/docs/Web/API/Response/json">Response.json - MDN</a>
   * @see <a href="https://fetch.spec.whatwg.org/#dom-body-json">Body.json() - Fetch</a>
   */
  @Nonnull
  public native Promise<Any> json();

  /**
   * The text() method of the Body mixin takes a Response stream and reads it to completion. It returns a promise that resolves with a USVString object (text). The response is always decoded using UTF-8.
   *
   * @see <a href="https://developer.mozilla.org/en-US/docs/Web/API/Response/text">Response.text - MDN</a>
   * @see <a href="https://fetch.spec.whatwg.org/#dom-body-text">text() - Fetch</a>
   */
  @Nonnull
  public native Promise<String> text();
}
