/**
 * @fileoverview
 * @externs
 */
/**
 * @typedef {!number}
 */
var GPUSize32;
/**
 * @typedef {(!Array<!number>|!GPUColorDict)}
 */
var GPUColor;
/**
 * @typedef {!number}
 */
var GPUSampleMask;
/**
 * @typedef {(!Array<!GPUIntegerCoordinate>|!GPUOrigin2DDict)}
 */
var GPUOrigin2D;
/**
 * @typedef {!number}
 */
var GPUIntegerCoordinate;
/**
 * @typedef {(!Array<!GPUIntegerCoordinate>|!GPUOrigin3DDict)}
 */
var GPUOrigin3D;
/**
 * @typedef {(!Int8Array|!Int16Array|!Int32Array|!Uint8Array|!Uint16Array|!Uint32Array|!Uint8ClampedArray)}
 */
var IntegerTypedArray;
/**
 * @typedef {!number}
 */
var DOMTimeStamp;
/**
 * @typedef {!number}
 */
var GPUSize64;
/**
 * @typedef {?EventHandlerNonNull}
 */
var EventHandler;
/**
 * @typedef {!number}
 */
var GPUSignedOffset32;
/**
 * @typedef {!number}
 */
var DOMHighResTimeStamp;
/**
 * @typedef {!number}
 */
var GPUPipelineConstantValue;
/**
 * @typedef {(!Array<!GPUIntegerCoordinate>|!GPUExtent3DDict)}
 */
var GPUExtent3D;
/**
 * @typedef {(!GPUOutOfMemoryError|!GPUValidationError)}
 */
var GPUError;
/**
 * @typedef {!number}
 */
var GPUIndex32;
/**
 * @typedef {(!boolean|!string|undefined)}
 */
var ReturnValueType;
/**
 * @typedef {!number}
 */
var GPUDepthBias;
/**
 * @typedef {(!GPUSampler|!GPUTextureView|!GPUBufferBinding|!GPUExternalTexture)}
 */
var GPUBindingResource;
/**
 * @typedef {!number}
 */
var GPUBufferDynamicOffset;
/**
 * @typedef {!number}
 */
var GPUStencilValue;
/**
 * @typedef {!number}
 */
var GPUFlagsConstant;
/**
 * @typedef {function(): *}
 */
var PropertyAccessorFunction;
/**
 * @typedef {function(): undefined}
 */
var VoidFunction;
/**
 * @typedef {function(*): undefined}
 */
var PropertyMutatorFunction;
/**
 * @typedef {function(!Event): *}
 */
var EventHandlerNonNull;
/**
 * @typedef {{buffers:(!Array<?GPUVertexBufferLayout>|undefined),module:!GPUShaderModule,entryPoint:!string,constants:(!Object<!string,!GPUPipelineConstantValue>|undefined)}}
 */
var GPUVertexState;
/**
 * @typedef {{binding:!GPUIndex32,resource:!GPUBindingResource}}
 */
var GPUBindGroupEntry;
/**
 * @typedef {{compute:!GPUProgrammableStage,layout:(!GPUPipelineLayout|undefined),label:(!string|undefined)}}
 */
var GPUComputePipelineDescriptor;
/**
 * @typedef {{x:(!GPUIntegerCoordinate|undefined),y:(!GPUIntegerCoordinate|undefined)}}
 */
var GPUOrigin2DDict;
/**
 * @typedef {{r:!number,g:!number,b:!number,a:!number}}
 */
var GPUColorDict;
/**
 * @typedef {{view:!GPUTextureView,resolveTarget:(!GPUTextureView|undefined),loadValue:GPULoadOpOrGPUColorUnion,storeOp:!string}}
 */
var GPURenderPassColorAttachment;
/**
 * @typedef {{arrayLayerCount:(!GPUIntegerCoordinate|undefined),aspect:(!string|undefined),baseArrayLayer:(!GPUIntegerCoordinate|undefined),baseMipLevel:(!GPUIntegerCoordinate|undefined),dimension:(!string|undefined),format:(!string|undefined),mipLevelCount:(!GPUIntegerCoordinate|undefined),label:(!string|undefined)}}
 */
var GPUTextureViewDescriptor;
/**
 * @typedef {{layout:!GPUBindGroupLayout,entries:!Array<!GPUBindGroupEntry>,label:(!string|undefined)}}
 */
var GPUBindGroupDescriptor;
/**
 * @typedef {{label:(!string|undefined)}}
 */
var GPUCommandBufferDescriptor;
/**
 * @typedef {{targets:!Array<!GPUColorTargetState>,module:!GPUShaderModule,entryPoint:!string,constants:(!Object<!string,!GPUPipelineConstantValue>|undefined)}}
 */
var GPUFragmentState;
/**
 * @typedef {{width:!GPUIntegerCoordinate,depthOrArrayLayers:(!GPUIntegerCoordinate|undefined),height:(!GPUIntegerCoordinate|undefined)}}
 */
var GPUExtent3DDict;
/**
 * @typedef {{size:!GPUExtent3D,dimension:(!string|undefined),mipLevelCount:(!GPUIntegerCoordinate|undefined),sampleCount:(!GPUSize32|undefined),format:!string,usage:!GPUFlagsConstant,label:(!string|undefined)}}
 */
var GPUTextureDescriptor;
/**
 * @typedef {{device:!GPUDevice,format:!string,colorSpace:(!string|undefined),compositingAlphaMode:(!string|undefined),size:(!GPUExtent3D|undefined),usage:(!GPUFlagsConstant|undefined)}}
 */
var GPUCanvasConfiguration;
/**
 * @typedef {{arrayStride:!GPUSize64,stepMode:(!string|undefined),attributes:!Array<!GPUVertexAttribute>}}
 */
var GPUVertexBufferLayout;
/**
 * @typedef {{size:!GPUSize64,usage:!GPUFlagsConstant,mappedAtCreation:(!boolean|undefined),label:(!string|undefined)}}
 */
var GPUBufferDescriptor;
/**
 * @typedef {{label:(!string|undefined)}}
 */
var GPUComputePassDescriptor;
/**
 * @typedef {{addressModeU:(!string|undefined),addressModeV:(!string|undefined),addressModeW:(!string|undefined),compare:(!string|undefined),lodMaxClamp:(!number|undefined),lodMinClamp:(!number|undefined),magFilter:(!string|undefined),maxAnisotropy:(!number|undefined),minFilter:(!string|undefined),mipmapFilter:(!string|undefined),label:(!string|undefined)}}
 */
var GPUSamplerDescriptor;
/**
 * @typedef {{color:!GPUBlendComponent,alpha:!GPUBlendComponent}}
 */
var GPUBlendState;
/**
 * @typedef {{colorAttachments:!Array<!GPURenderPassColorAttachment>,depthStencilAttachment:(!GPURenderPassDepthStencilAttachment|undefined),occlusionQuerySet:(!GPUQuerySet|undefined),label:(!string|undefined)}}
 */
var GPURenderPassDescriptor;
/**
 * @typedef {{hasDynamicOffset:(!boolean|undefined),minBindingSize:(!GPUSize64|undefined),type:(!string|undefined)}}
 */
var GPUBufferBindingLayout;
/**
 * @typedef {{label:(!string|undefined)}}
 */
var GPUObjectDescriptorBase;
/**
 * @record
 */
var GPUExternalTextureBindingLayout;
/**
 * @typedef {{bindGroupLayouts:!Array<!GPUBindGroupLayout>,label:(!string|undefined)}}
 */
var GPUPipelineLayoutDescriptor;
/**
 * @typedef {{x:(!GPUIntegerCoordinate|undefined),y:(!GPUIntegerCoordinate|undefined),z:(!GPUIntegerCoordinate|undefined)}}
 */
var GPUOrigin3DDict;
/**
 * @typedef {{depthReadOnly:(!boolean|undefined),stencilReadOnly:(!boolean|undefined),colorFormats:!Array<!string>,depthStencilFormat:(!string|undefined),sampleCount:(!GPUSize32|undefined),label:(!string|undefined)}}
 */
var GPURenderBundleEncoderDescriptor;
/**
 * @typedef {{clampDepth:(!boolean|undefined),cullMode:(!string|undefined),frontFace:(!string|undefined),stripIndexFormat:(!string|undefined),topology:(!string|undefined)}}
 */
var GPUPrimitiveState;
/**
 * @typedef {{binding:!GPUIndex32,visibility:!GPUFlagsConstant,buffer:(!GPUBufferBindingLayout|undefined),externalTexture:(!GPUExternalTextureBindingLayout|undefined),sampler:(!GPUSamplerBindingLayout|undefined),storageTexture:(!GPUStorageTextureBindingLayout|undefined),texture:(!GPUTextureBindingLayout|undefined)}}
 */
var GPUBindGroupLayoutEntry;
/**
 * @typedef {{requiredFeatures:(!Array<!string>|undefined),requiredLimits:(!Object<!string,!GPUSize32>|undefined),label:(!string|undefined)}}
 */
var GPUDeviceDescriptor;
/**
 * @typedef {{vertex:!GPUVertexState,depthStencil:(!GPUDepthStencilState|undefined),fragment:(!GPUFragmentState|undefined),multisample:(!GPUMultisampleState|undefined),primitive:(!GPUPrimitiveState|undefined),layout:(!GPUPipelineLayout|undefined),label:(!string|undefined)}}
 */
var GPURenderPipelineDescriptor;
/**
 * @typedef {{forceSoftware:(!boolean|undefined),powerPreference:(!string|undefined)}}
 */
var GPURequestAdapterOptions;
/**
 * @typedef {{format:!string,blend:(!GPUBlendState|undefined),writeMask:(!GPUFlagsConstant|undefined)}}
 */
var GPUColorTargetState;
/**
 * @typedef {{format:!string,offset:!GPUSize64,shaderLocation:!GPUIndex32}}
 */
var GPUVertexAttribute;
/**
 * @typedef {{format:!string,depthBias:(!GPUDepthBias|undefined),depthBiasClamp:(!number|undefined),depthBiasSlopeScale:(!number|undefined),depthCompare:(!string|undefined),depthWriteEnabled:(!boolean|undefined),stencilBack:(!GPUStencilFaceState|undefined),stencilFront:(!GPUStencilFaceState|undefined),stencilReadMask:(!GPUStencilValue|undefined),stencilWriteMask:(!GPUStencilValue|undefined)}}
 */
var GPUDepthStencilState;
/**
 * @typedef {{bytesPerRow:(!GPUSize32|undefined),offset:(!GPUSize64|undefined),rowsPerImage:(!GPUSize32|undefined)}}
 */
var GPUImageDataLayout;
/**
 * @typedef {{error:!GPUError,bubbles:(!boolean|undefined),cancelable:(!boolean|undefined),composed:(!boolean|undefined)}}
 */
var GPUUncapturedErrorEventInit;
/**
 * @typedef {{source:ImageBitmapOrHTMLCanvasElementOrOffscreenCanvasUnion,origin:(!GPUOrigin2D|undefined)}}
 */
var GPUImageCopyExternalImage;
/**
 * @typedef {{multisampled:(!boolean|undefined),sampleType:(!string|undefined),viewDimension:(!string|undefined)}}
 */
var GPUTextureBindingLayout;
/**
 * @typedef {{view:!GPUTextureView,depthLoadValue:GPULoadOpOrFloatUnion,depthStoreOp:!string,depthReadOnly:(!boolean|undefined),stencilLoadValue:GPULoadOpOrGPUStencilValueUnion,stencilStoreOp:!string,stencilReadOnly:(!boolean|undefined)}}
 */
var GPURenderPassDepthStencilAttachment;
/**
 * @typedef {{dstFactor:(!string|undefined),operation:(!string|undefined),srcFactor:(!string|undefined)}}
 */
var GPUBlendComponent;
/**
 * @typedef {{texture:!GPUTexture,aspect:(!string|undefined),mipLevel:(!GPUIntegerCoordinate|undefined),origin:(!GPUOrigin3D|undefined)}}
 */
var GPUImageCopyTexture;
/**
 * @typedef {{access:(!string|undefined),format:!string,viewDimension:(!string|undefined)}}
 */
var GPUStorageTextureBindingLayout;
/**
 * @typedef {{colorFormats:!Array<!string>,depthStencilFormat:(!string|undefined),sampleCount:(!GPUSize32|undefined),label:(!string|undefined)}}
 */
var GPURenderPassLayout;
/**
 * @typedef {{colorSpace:(!string|undefined),premultipliedAlpha:(!boolean|undefined),texture:!GPUTexture,aspect:(!string|undefined),mipLevel:(!GPUIntegerCoordinate|undefined),origin:(!GPUOrigin3D|undefined)}}
 */
var GPUImageCopyTextureTagged;
/**
 * @typedef {{module:!GPUShaderModule,entryPoint:!string,constants:(!Object<!string,!GPUPipelineConstantValue>|undefined)}}
 */
var GPUProgrammableStage;
/**
 * @typedef {{type:(!string|undefined)}}
 */
var GPUSamplerBindingLayout;
/**
 * @typedef {{label:(!string|undefined)}}
 */
var GPURenderBundleDescriptor;
/**
 * @typedef {{buffer:!GPUBuffer,bytesPerRow:(!GPUSize32|undefined),offset:(!GPUSize64|undefined),rowsPerImage:(!GPUSize32|undefined)}}
 */
var GPUImageCopyBuffer;
/**
 * @typedef {{layout:(!GPUPipelineLayout|undefined),label:(!string|undefined)}}
 */
var GPUPipelineDescriptorBase;
/**
 * @typedef {{type:!string,count:!GPUSize32,pipelineStatistics:(!Array<!string>|undefined),label:(!string|undefined)}}
 */
var GPUQuerySetDescriptor;
/**
 * @typedef {{measureExecutionTime:(!boolean|undefined),label:(!string|undefined)}}
 */
var GPUCommandEncoderDescriptor;
/**
 * @typedef {{alphaToCoverageEnabled:(!boolean|undefined),count:(!GPUSize32|undefined),mask:(!GPUSampleMask|undefined)}}
 */
var GPUMultisampleState;
/**
 * @typedef {{compare:(!string|undefined),depthFailOp:(!string|undefined),failOp:(!string|undefined),passOp:(!string|undefined)}}
 */
var GPUStencilFaceState;
/**
 * @typedef {{buffer:!GPUBuffer,offset:(!GPUSize64|undefined),size:(!GPUSize64|undefined)}}
 */
var GPUBufferBinding;
/**
 * @typedef {{source:!HTMLVideoElement,colorSpace:(!string|undefined),label:(!string|undefined)}}
 */
var GPUExternalTextureDescriptor;
/**
 * @typedef {{code:!string,sourceMap:(!Object|undefined),label:(!string|undefined)}}
 */
var GPUShaderModuleDescriptor;
/**
 * @typedef {{entries:!Array<!GPUBindGroupLayoutEntry>,label:(!string|undefined)}}
 */
var GPUBindGroupLayoutDescriptor;
/**
 * @constructor
 * @private
 * @nosideeffects
 */
function GPURenderBundleEncoder() {}
/** @type {?string} */ GPURenderBundleEncoder.prototype.label;
/**
 * @param {!GPURenderPipeline} pipeline
 * @return {undefined}
 */
GPURenderBundleEncoder.prototype.setPipeline = function(pipeline) {}
/**
 * @param {!GPUBuffer} buffer
 * @param {!string} indexFormat
 * @param {!GPUSize64=} offset
 * @param {!GPUSize64=} size
 * @return {undefined}
 */
GPURenderBundleEncoder.prototype.setIndexBuffer = function(buffer,indexFormat,offset,size) {}
/**
 * @param {!GPUBuffer} indirectBuffer
 * @param {!GPUSize64} indirectOffset
 * @return {undefined}
 */
GPURenderBundleEncoder.prototype.drawIndirect = function(indirectBuffer,indirectOffset) {}
/**
 * @param {!GPUIndex32} slot
 * @param {!GPUBuffer} buffer
 * @param {!GPUSize64=} offset
 * @param {!GPUSize64=} size
 * @return {undefined}
 */
GPURenderBundleEncoder.prototype.setVertexBuffer = function(slot,buffer,offset,size) {}
/**
 * @param {!string} groupLabel
 * @return {undefined}
 */
GPURenderBundleEncoder.prototype.pushDebugGroup = function(groupLabel) {}
/**
 * @return {undefined}
 */
GPURenderBundleEncoder.prototype.popDebugGroup = function() {}
/**
 * @param {!GPURenderBundleDescriptor=} descriptor
 * @return {!GPURenderBundle}
 */
GPURenderBundleEncoder.prototype.finish = function(descriptor) {}
/**
 * @param {!GPUBuffer} indirectBuffer
 * @param {!GPUSize64} indirectOffset
 * @return {undefined}
 */
GPURenderBundleEncoder.prototype.drawIndexedIndirect = function(indirectBuffer,indirectOffset) {}
/**
 * @param {!GPUSize32} vertexCount
 * @param {!GPUSize32=} instanceCount
 * @param {!GPUSize32=} firstVertex
 * @param {!GPUSize32=} firstInstance
 * @return {undefined}
 */
GPURenderBundleEncoder.prototype.draw = function(vertexCount,instanceCount,firstVertex,firstInstance) {}
/**
 * @param {!GPUSize32} indexCount
 * @param {!GPUSize32=} instanceCount
 * @param {!GPUSize32=} firstIndex
 * @param {!GPUSignedOffset32=} baseVertex
 * @param {!GPUSize32=} firstInstance
 * @return {undefined}
 */
GPURenderBundleEncoder.prototype.drawIndexed = function(indexCount,instanceCount,firstIndex,baseVertex,firstInstance) {}
/**
 * @param {!string} markerLabel
 * @return {undefined}
 */
GPURenderBundleEncoder.prototype.insertDebugMarker = function(markerLabel) {}
/**
 * @param {!GPUIndex32} arg0
 * @param {!GPUBindGroup} arg1
 * @param {(!Array<!GPUBufferDynamicOffset>|!Uint32Array)=} arg2
 * @param {!GPUSize64=} arg3
 * @param {!GPUSize32=} arg4
 * @return {undefined}
 */
GPURenderBundleEncoder.prototype.setBindGroup = function(arg0,arg1,arg2,arg3,arg4) {}
/**
 * @constructor
 * @private
 * @nosideeffects
 */
function GPUBindGroupLayout() {}
/** @type {?string} */ GPUBindGroupLayout.prototype.label;
/**
 * @constructor
 * @private
 * @nosideeffects
 */
function GPUAdapter() {}
/** @type {!GPUSupportedFeatures} */ GPUAdapter.prototype.features;
/** @type {!boolean} */ GPUAdapter.prototype.isSoftware;
/** @type {!GPUSupportedLimits} */ GPUAdapter.prototype.limits;
/** @type {!string} */ GPUAdapter.prototype.name;
/**
 * @param {!GPUDeviceDescriptor=} descriptor
 * @return {!Promise<!GPUDevice>}
 */
GPUAdapter.prototype.requestDevice = function(descriptor) {}
/**
 * @constructor
 * @private
 * @nosideeffects
 */
function GPU() {}
/**
 * @param {!GPURequestAdapterOptions=} options
 * @return {!Promise<?GPUAdapter>}
 */
GPU.prototype.requestAdapter = function(options) {}
/**
 * @constructor
 * @param {!string} message
 */
function GPUValidationError(message) {}
/** @type {!string} */ GPUValidationError.prototype.message;
/**
 * @constructor
 * @private
 * @nosideeffects
 */
function GPUCompilationMessage() {}
/** @type {!number} */ GPUCompilationMessage.prototype.length;
/** @type {!number} */ GPUCompilationMessage.prototype.lineNum;
/** @type {!number} */ GPUCompilationMessage.prototype.linePos;
/** @type {!string} */ GPUCompilationMessage.prototype.message;
/** @type {!number} */ GPUCompilationMessage.prototype.offset;
/** @type {!string} */ GPUCompilationMessage.prototype.type;
/**
 * @constructor
 * @private
 * @nosideeffects
 */
function GPUShaderModule() {}
/** @type {?string} */ GPUShaderModule.prototype.label;
/**
 * @return {!Promise<!GPUCompilationInfo>}
 */
GPUShaderModule.prototype.compilationInfo = function() {}
/**
 * @constructor
 * @private
 * @nosideeffects
 */
function GPURenderPipeline() {}
/** @type {?string} */ GPURenderPipeline.prototype.label;
/**
 * @param {!number} index
 * @return {!GPUBindGroupLayout}
 */
GPURenderPipeline.prototype.getBindGroupLayout = function(index) {}
/** @type {!GPUSupportedFeatures} */ GPUDevice.prototype.features;
/** @type {!GPUSupportedLimits} */ GPUDevice.prototype.limits;
/** @type {!GPUQueue} */ GPUDevice.prototype.queue;
/** @type {!Promise<!GPUDeviceLostInfo>} */ GPUDevice.prototype.lost;
/** @type {!EventHandler} */ GPUDevice.prototype.onuncapturederror;
/** @type {?string} */ GPUDevice.prototype.label;
/**
 * @param {!string} filter
 * @return {undefined}
 */
GPUDevice.prototype.pushErrorScope = function(filter) {}
/**
 * @param {!GPUSamplerDescriptor=} descriptor
 * @return {!GPUSampler}
 */
GPUDevice.prototype.createSampler = function(descriptor) {}
/**
 * @param {!GPUShaderModuleDescriptor} descriptor
 * @return {!GPUShaderModule}
 */
GPUDevice.prototype.createShaderModule = function(descriptor) {}
/**
 * @param {!GPURenderPipelineDescriptor} descriptor
 * @return {!GPURenderPipeline}
 */
GPUDevice.prototype.createRenderPipeline = function(descriptor) {}
/**
 * @param {!GPUQuerySetDescriptor} descriptor
 * @return {!GPUQuerySet}
 */
GPUDevice.prototype.createQuerySet = function(descriptor) {}
/**
 * @param {!GPUPipelineLayoutDescriptor} descriptor
 * @return {!GPUPipelineLayout}
 */
GPUDevice.prototype.createPipelineLayout = function(descriptor) {}
/**
 * @param {!GPURenderBundleEncoderDescriptor} descriptor
 * @return {!GPURenderBundleEncoder}
 */
GPUDevice.prototype.createRenderBundleEncoder = function(descriptor) {}
/**
 * @return {undefined}
 */
GPUDevice.prototype.destroy = function() {}
/**
 * @param {!GPUCommandEncoderDescriptor=} descriptor
 * @return {!GPUCommandEncoder}
 */
GPUDevice.prototype.createCommandEncoder = function(descriptor) {}
/**
 * @param {!GPUExternalTextureDescriptor} descriptor
 * @return {!GPUExternalTexture}
 */
GPUDevice.prototype.importExternalTexture = function(descriptor) {}
/**
 * @param {!GPUBufferDescriptor} descriptor
 * @return {!GPUBuffer}
 */
GPUDevice.prototype.createBuffer = function(descriptor) {}
/**
 * @param {!GPUBindGroupDescriptor} descriptor
 * @return {!GPUBindGroup}
 */
GPUDevice.prototype.createBindGroup = function(descriptor) {}
/**
 * @return {!Promise<?GPUError>}
 */
GPUDevice.prototype.popErrorScope = function() {}
/**
 * @param {!GPUComputePipelineDescriptor} descriptor
 * @return {!GPUComputePipeline}
 */
GPUDevice.prototype.createComputePipeline = function(descriptor) {}
/**
 * @param {!GPUComputePipelineDescriptor} descriptor
 * @return {!Promise<!GPUComputePipeline>}
 */
GPUDevice.prototype.createComputePipelineAsync = function(descriptor) {}
/**
 * @param {!GPUBindGroupLayoutDescriptor} descriptor
 * @return {!GPUBindGroupLayout}
 */
GPUDevice.prototype.createBindGroupLayout = function(descriptor) {}
/**
 * @param {!GPUTextureDescriptor} descriptor
 * @return {!GPUTexture}
 */
GPUDevice.prototype.createTexture = function(descriptor) {}
/**
 * @param {!GPURenderPipelineDescriptor} descriptor
 * @return {!Promise<!GPURenderPipeline>}
 */
GPUDevice.prototype.createRenderPipelineAsync = function(descriptor) {}
/**
 * @constructor
 * @private
 * @nosideeffects
 */
function GPUShaderStage() {}
/** @const {!GPUFlagsConstant} */ GPUShaderStage.COMPUTE;
/** @const {!GPUFlagsConstant} */ GPUShaderStage.prototype.COMPUTE;
/** @const {!GPUFlagsConstant} */ GPUShaderStage.FRAGMENT;
/** @const {!GPUFlagsConstant} */ GPUShaderStage.prototype.FRAGMENT;
/** @const {!GPUFlagsConstant} */ GPUShaderStage.VERTEX;
/** @const {!GPUFlagsConstant} */ GPUShaderStage.prototype.VERTEX;
/**
 * @constructor
 * @private
 * @nosideeffects
 */
function GPUBufferUsage() {}
/** @const {!GPUFlagsConstant} */ GPUBufferUsage.COPY_DST;
/** @const {!GPUFlagsConstant} */ GPUBufferUsage.prototype.COPY_DST;
/** @const {!GPUFlagsConstant} */ GPUBufferUsage.COPY_SRC;
/** @const {!GPUFlagsConstant} */ GPUBufferUsage.prototype.COPY_SRC;
/** @const {!GPUFlagsConstant} */ GPUBufferUsage.INDEX;
/** @const {!GPUFlagsConstant} */ GPUBufferUsage.prototype.INDEX;
/** @const {!GPUFlagsConstant} */ GPUBufferUsage.INDIRECT;
/** @const {!GPUFlagsConstant} */ GPUBufferUsage.prototype.INDIRECT;
/** @const {!GPUFlagsConstant} */ GPUBufferUsage.MAP_READ;
/** @const {!GPUFlagsConstant} */ GPUBufferUsage.prototype.MAP_READ;
/** @const {!GPUFlagsConstant} */ GPUBufferUsage.MAP_WRITE;
/** @const {!GPUFlagsConstant} */ GPUBufferUsage.prototype.MAP_WRITE;
/** @const {!GPUFlagsConstant} */ GPUBufferUsage.QUERY_RESOLVE;
/** @const {!GPUFlagsConstant} */ GPUBufferUsage.prototype.QUERY_RESOLVE;
/** @const {!GPUFlagsConstant} */ GPUBufferUsage.STORAGE;
/** @const {!GPUFlagsConstant} */ GPUBufferUsage.prototype.STORAGE;
/** @const {!GPUFlagsConstant} */ GPUBufferUsage.UNIFORM;
/** @const {!GPUFlagsConstant} */ GPUBufferUsage.prototype.UNIFORM;
/** @const {!GPUFlagsConstant} */ GPUBufferUsage.VERTEX;
/** @const {!GPUFlagsConstant} */ GPUBufferUsage.prototype.VERTEX;
/**
 * @constructor
 * @extends {Event}
 * @param {!string} type
 * @param {!GPUUncapturedErrorEventInit} gpuUncapturedErrorEventInitDict
 */
function GPUUncapturedErrorEvent(type,gpuUncapturedErrorEventInitDict) {}
/** @type {!GPUError} */ GPUUncapturedErrorEvent.prototype.error;
/**
 * @constructor
 * @private
 * @nosideeffects
 */
function GPUComputePassEncoder() {}
/** @type {?string} */ GPUComputePassEncoder.prototype.label;
/**
 * @param {!GPUComputePipeline} pipeline
 * @return {undefined}
 */
GPUComputePassEncoder.prototype.setPipeline = function(pipeline) {}
/**
 * @param {!GPUQuerySet} querySet
 * @param {!GPUSize32} queryIndex
 * @return {undefined}
 */
GPUComputePassEncoder.prototype.writeTimestamp = function(querySet,queryIndex) {}
/**
 * @param {!GPUSize32} x
 * @param {!GPUSize32=} y
 * @param {!GPUSize32=} z
 * @return {undefined}
 */
GPUComputePassEncoder.prototype.dispatch = function(x,y,z) {}
/**
 * @return {undefined}
 */
GPUComputePassEncoder.prototype.endPipelineStatisticsQuery = function() {}
/**
 * @param {!GPUQuerySet} querySet
 * @param {!GPUSize32} queryIndex
 * @return {undefined}
 */
GPUComputePassEncoder.prototype.beginPipelineStatisticsQuery = function(querySet,queryIndex) {}
/**
 * @param {!string} groupLabel
 * @return {undefined}
 */
GPUComputePassEncoder.prototype.pushDebugGroup = function(groupLabel) {}
/**
 * @return {undefined}
 */
GPUComputePassEncoder.prototype.popDebugGroup = function() {}
/**
 * @return {undefined}
 */
GPUComputePassEncoder.prototype.endPass = function() {}
/**
 * @param {!string} markerLabel
 * @return {undefined}
 */
GPUComputePassEncoder.prototype.insertDebugMarker = function(markerLabel) {}
/**
 * @param {!GPUIndex32} arg0
 * @param {!GPUBindGroup} arg1
 * @param {(!Array<!GPUBufferDynamicOffset>|!Uint32Array)=} arg2
 * @param {!GPUSize64=} arg3
 * @param {!GPUSize32=} arg4
 * @return {undefined}
 */
GPUComputePassEncoder.prototype.setBindGroup = function(arg0,arg1,arg2,arg3,arg4) {}
/**
 * @param {!GPUBuffer} indirectBuffer
 * @param {!GPUSize64} indirectOffset
 * @return {undefined}
 */
GPUComputePassEncoder.prototype.dispatchIndirect = function(indirectBuffer,indirectOffset) {}
/**
 * @constructor
 * @private
 * @nosideeffects
 */
function GPUExternalTexture() {}
/** @type {?string} */ GPUExternalTexture.prototype.label;
/**
 * @constructor
 * @private
 * @nosideeffects
 */
function GPUSampler() {}
/** @type {?string} */ GPUSampler.prototype.label;
/**
 * @constructor
 * @private
 * @nosideeffects
 */
function GPUDeviceLostInfo() {}
/** @type {!string} */ GPUDeviceLostInfo.prototype.message;
/** @type {GPUDeviceLostReasonOrUndefinedUnion} */ GPUDeviceLostInfo.prototype.reason;
/**
 * @constructor
 * @private
 * @nosideeffects
 */
function GPUTextureUsage() {}
/** @const {!GPUFlagsConstant} */ GPUTextureUsage.COPY_DST;
/** @const {!GPUFlagsConstant} */ GPUTextureUsage.prototype.COPY_DST;
/** @const {!GPUFlagsConstant} */ GPUTextureUsage.COPY_SRC;
/** @const {!GPUFlagsConstant} */ GPUTextureUsage.prototype.COPY_SRC;
/** @const {!GPUFlagsConstant} */ GPUTextureUsage.RENDER_ATTACHMENT;
/** @const {!GPUFlagsConstant} */ GPUTextureUsage.prototype.RENDER_ATTACHMENT;
/** @const {!GPUFlagsConstant} */ GPUTextureUsage.SHADER_READ;
/** @const {!GPUFlagsConstant} */ GPUTextureUsage.prototype.SHADER_READ;
/** @const {!GPUFlagsConstant} */ GPUTextureUsage.STORAGE;
/** @const {!GPUFlagsConstant} */ GPUTextureUsage.prototype.STORAGE;
/**
 * @constructor
 * @private
 * @nosideeffects
 */
function GPUCompilationInfo() {}
/** @type {!Array<!GPUCompilationMessage>} */ GPUCompilationInfo.prototype.messages;
/**
 * @constructor
 * @private
 * @nosideeffects
 */
function GPUTextureView() {}
/** @type {?string} */ GPUTextureView.prototype.label;
/**
 * @constructor
 * @private
 * @nosideeffects
 */
function GPUCommandBuffer() {}
/** @type {!Promise<!number>} */ GPUCommandBuffer.prototype.executionTime;
/** @type {?string} */ GPUCommandBuffer.prototype.label;
/**
 * @constructor
 * @private
 * @nosideeffects
 */
function GPUComputePipeline() {}
/** @type {?string} */ GPUComputePipeline.prototype.label;
/**
 * @param {!number} index
 * @return {!GPUBindGroupLayout}
 */
GPUComputePipeline.prototype.getBindGroupLayout = function(index) {}
/**
 * @constructor
 * @private
 * @nosideeffects
 */
function GPUSupportedFeatures() {}
/** @const {number} */ GPUSupportedFeatures.prototype.size;
/**
 * @param {!string} value
 * @return {!boolean}
 * @nosideeffects
 */
GPUSupportedFeatures.prototype.has = function(value) {}
/**
 * @return {!Iterator<!string>}
 * @nosideeffects
 */
GPUSupportedFeatures.prototype.keys = function() {}
/**
 * @return {!Iterator<!string>}
 * @nosideeffects
 */
GPUSupportedFeatures.prototype.values = function() {}
/**
 * @return {!Iterator<!Array<!string|!string>>}
 * @nosideeffects
 */
GPUSupportedFeatures.prototype.entries = function() {};
/**
 * @return {!Iterator<!Array<!string|!string>>}
 * @nosideeffects
 */
GPUSupportedFeatures.prototype[Symbol.iterator] = function() {};
/**
 * @param {function(!string, !string, MAP)} callback
 * @this {MAP}
 * @template MAP
 */
GPUSupportedFeatures.prototype.forEach = function(callback) {};
/**
 * @constructor
 * @private
 * @nosideeffects
 */
function GPUQuerySet() {}
/** @type {?string} */ GPUQuerySet.prototype.label;
/**
 * @return {undefined}
 */
GPUQuerySet.prototype.destroy = function() {}
/**
 * @constructor
 * @private
 * @nosideeffects
 */
function GPURenderBundle() {}
/** @type {?string} */ GPURenderBundle.prototype.label;
/**
 * @constructor
 * @private
 * @nosideeffects
 */
function GPUTexture() {}
/** @type {?string} */ GPUTexture.prototype.label;
/**
 * @return {undefined}
 */
GPUTexture.prototype.destroy = function() {}
/**
 * @param {!GPUTextureViewDescriptor=} descriptor
 * @return {!GPUTextureView}
 */
GPUTexture.prototype.createView = function(descriptor) {}
/**
 * @constructor
 * @private
 * @nosideeffects
 */
function GPUBindGroup() {}
/** @type {?string} */ GPUBindGroup.prototype.label;
/**
 * @constructor
 * @private
 * @nosideeffects
 */
function GPUColorWrite() {}
/** @const {!GPUFlagsConstant} */ GPUColorWrite.ALL;
/** @const {!GPUFlagsConstant} */ GPUColorWrite.prototype.ALL;
/** @const {!GPUFlagsConstant} */ GPUColorWrite.ALPHA;
/** @const {!GPUFlagsConstant} */ GPUColorWrite.prototype.ALPHA;
/** @const {!GPUFlagsConstant} */ GPUColorWrite.BLUE;
/** @const {!GPUFlagsConstant} */ GPUColorWrite.prototype.BLUE;
/** @const {!GPUFlagsConstant} */ GPUColorWrite.GREEN;
/** @const {!GPUFlagsConstant} */ GPUColorWrite.prototype.GREEN;
/** @const {!GPUFlagsConstant} */ GPUColorWrite.RED;
/** @const {!GPUFlagsConstant} */ GPUColorWrite.prototype.RED;
/**
 * @constructor
 * @private
 * @nosideeffects
 */
function GPUCanvasContext() {}
/** @type {HTMLCanvasElementOrOffscreenCanvasUnion} */ GPUCanvasContext.prototype.canvas;
/**
 * @param {!GPUAdapter} adapter
 * @return {!string}
 */
GPUCanvasContext.prototype.getPreferredFormat = function(adapter) {}
/**
 * @return {!GPUTexture}
 */
GPUCanvasContext.prototype.getCurrentTexture = function() {}
/**
 * @param {!GPUCanvasConfiguration} configuration
 * @return {undefined}
 */
GPUCanvasContext.prototype.configure = function(configuration) {}
/**
 * @return {undefined}
 */
GPUCanvasContext.prototype.unconfigure = function() {}
/**
 * @constructor
 */
function GPUOutOfMemoryError() {}
/**
 * @constructor
 * @private
 * @nosideeffects
 */
function GPUBuffer() {}
/** @type {?string} */ GPUBuffer.prototype.label;
/**
 * @param {!GPUFlagsConstant} mode
 * @param {!GPUSize64=} offset
 * @param {!GPUSize64=} size
 * @return {!Promise<undefined>}
 */
GPUBuffer.prototype.mapAsync = function(mode,offset,size) {}
/**
 * @return {undefined}
 */
GPUBuffer.prototype.unmap = function() {}
/**
 * @return {undefined}
 */
GPUBuffer.prototype.destroy = function() {}
/**
 * @param {!GPUSize64=} offset
 * @param {!GPUSize64=} size
 * @return {!ArrayBuffer}
 */
GPUBuffer.prototype.getMappedRange = function(offset,size) {}
/**
 * @constructor
 * @private
 * @nosideeffects
 */
function ObjectPropertyEntry() {}
/**
 * @constructor
 * @private
 * @nosideeffects
 */
function GPUMapMode() {}
/** @const {!GPUFlagsConstant} */ GPUMapMode.READ;
/** @const {!GPUFlagsConstant} */ GPUMapMode.prototype.READ;
/** @const {!GPUFlagsConstant} */ GPUMapMode.WRITE;
/** @const {!GPUFlagsConstant} */ GPUMapMode.prototype.WRITE;
/**
 * @constructor
 * @private
 * @nosideeffects
 */
function GPUSupportedLimits() {}
/** @type {!number} */ GPUSupportedLimits.prototype.maxBindGroups;
/** @type {!number} */ GPUSupportedLimits.prototype.maxComputePerDimensionDispatchSize;
/** @type {!number} */ GPUSupportedLimits.prototype.maxComputeWorkgroupInvocations;
/** @type {!GPUExtent3D} */ GPUSupportedLimits.prototype.maxComputeWorkgroupSize;
/** @type {!number} */ GPUSupportedLimits.prototype.maxComputeWorkgroupStorageSize;
/** @type {!number} */ GPUSupportedLimits.prototype.maxDynamicStorageBuffersPerPipelineLayout;
/** @type {!number} */ GPUSupportedLimits.prototype.maxDynamicUniformBuffersPerPipelineLayout;
/** @type {!number} */ GPUSupportedLimits.prototype.maxInterStageShaderComponents;
/** @type {!number} */ GPUSupportedLimits.prototype.maxSampledTexturesPerShaderStage;
/** @type {!number} */ GPUSupportedLimits.prototype.maxSamplersPerShaderStage;
/** @type {!number} */ GPUSupportedLimits.prototype.maxStorageBufferBindingSize;
/** @type {!number} */ GPUSupportedLimits.prototype.maxStorageBuffersPerShaderStage;
/** @type {!number} */ GPUSupportedLimits.prototype.maxStorageTexturesPerShaderStage;
/** @type {!number} */ GPUSupportedLimits.prototype.maxTextureArrayLayers;
/** @type {!number} */ GPUSupportedLimits.prototype.maxTextureDimension1D;
/** @type {!number} */ GPUSupportedLimits.prototype.maxTextureDimension2D;
/** @type {!number} */ GPUSupportedLimits.prototype.maxTextureDimension3D;
/** @type {!number} */ GPUSupportedLimits.prototype.maxUniformBufferBindingSize;
/** @type {!number} */ GPUSupportedLimits.prototype.maxUniformBuffersPerShaderStage;
/** @type {!number} */ GPUSupportedLimits.prototype.maxVertexAttributes;
/** @type {!number} */ GPUSupportedLimits.prototype.maxVertexBufferArrayStride;
/** @type {!number} */ GPUSupportedLimits.prototype.maxVertexBuffers;
/** @type {!number} */ GPUSupportedLimits.prototype.minStorageBufferOffsetAlignment;
/** @type {!number} */ GPUSupportedLimits.prototype.minUniformBufferOffsetAlignment;
/**
 * @constructor
 * @private
 * @nosideeffects
 */
function GPURenderPassEncoder() {}
/** @type {?string} */ GPURenderPassEncoder.prototype.label;
/**
 * @param {!Array<!GPURenderBundle>} bundles
 * @return {undefined}
 */
GPURenderPassEncoder.prototype.executeBundles = function(bundles) {}
/**
 * @param {!GPURenderPipeline} pipeline
 * @return {undefined}
 */
GPURenderPassEncoder.prototype.setPipeline = function(pipeline) {}
/**
 * @param {!GPUSize32} queryIndex
 * @return {undefined}
 */
GPURenderPassEncoder.prototype.beginOcclusionQuery = function(queryIndex) {}
/**
 * @param {!GPUColor} color
 * @return {undefined}
 */
GPURenderPassEncoder.prototype.setBlendConstant = function(color) {}
/**
 * @param {!GPUBuffer} buffer
 * @param {!string} indexFormat
 * @param {!GPUSize64=} offset
 * @param {!GPUSize64=} size
 * @return {undefined}
 */
GPURenderPassEncoder.prototype.setIndexBuffer = function(buffer,indexFormat,offset,size) {}
/**
 * @param {!GPUIntegerCoordinate} x
 * @param {!GPUIntegerCoordinate} y
 * @param {!GPUIntegerCoordinate} width
 * @param {!GPUIntegerCoordinate} height
 * @return {undefined}
 */
GPURenderPassEncoder.prototype.setScissorRect = function(x,y,width,height) {}
/**
 * @return {undefined}
 */
GPURenderPassEncoder.prototype.endOcclusionQuery = function() {}
/**
 * @param {!string} groupLabel
 * @return {undefined}
 */
GPURenderPassEncoder.prototype.pushDebugGroup = function(groupLabel) {}
/**
 * @return {undefined}
 */
GPURenderPassEncoder.prototype.popDebugGroup = function() {}
/**
 * @param {!GPUSize32} vertexCount
 * @param {!GPUSize32=} instanceCount
 * @param {!GPUSize32=} firstVertex
 * @param {!GPUSize32=} firstInstance
 * @return {undefined}
 */
GPURenderPassEncoder.prototype.draw = function(vertexCount,instanceCount,firstVertex,firstInstance) {}
/**
 * @param {!number} x
 * @param {!number} y
 * @param {!number} width
 * @param {!number} height
 * @param {!number} minDepth
 * @param {!number} maxDepth
 * @return {undefined}
 */
GPURenderPassEncoder.prototype.setViewport = function(x,y,width,height,minDepth,maxDepth) {}
/**
 * @param {!GPUStencilValue} reference
 * @return {undefined}
 */
GPURenderPassEncoder.prototype.setStencilReference = function(reference) {}
/**
 * @param {!GPUQuerySet} querySet
 * @param {!GPUSize32} queryIndex
 * @return {undefined}
 */
GPURenderPassEncoder.prototype.writeTimestamp = function(querySet,queryIndex) {}
/**
 * @return {undefined}
 */
GPURenderPassEncoder.prototype.endPipelineStatisticsQuery = function() {}
/**
 * @param {!GPUBuffer} indirectBuffer
 * @param {!GPUSize64} indirectOffset
 * @return {undefined}
 */
GPURenderPassEncoder.prototype.drawIndirect = function(indirectBuffer,indirectOffset) {}
/**
 * @param {!GPUIndex32} slot
 * @param {!GPUBuffer} buffer
 * @param {!GPUSize64=} offset
 * @param {!GPUSize64=} size
 * @return {undefined}
 */
GPURenderPassEncoder.prototype.setVertexBuffer = function(slot,buffer,offset,size) {}
/**
 * @param {!GPUQuerySet} querySet
 * @param {!GPUSize32} queryIndex
 * @return {undefined}
 */
GPURenderPassEncoder.prototype.beginPipelineStatisticsQuery = function(querySet,queryIndex) {}
/**
 * @param {!GPUBuffer} indirectBuffer
 * @param {!GPUSize64} indirectOffset
 * @return {undefined}
 */
GPURenderPassEncoder.prototype.drawIndexedIndirect = function(indirectBuffer,indirectOffset) {}
/**
 * @param {!GPUSize32} indexCount
 * @param {!GPUSize32=} instanceCount
 * @param {!GPUSize32=} firstIndex
 * @param {!GPUSignedOffset32=} baseVertex
 * @param {!GPUSize32=} firstInstance
 * @return {undefined}
 */
GPURenderPassEncoder.prototype.drawIndexed = function(indexCount,instanceCount,firstIndex,baseVertex,firstInstance) {}
/**
 * @return {undefined}
 */
GPURenderPassEncoder.prototype.endPass = function() {}
/**
 * @param {!string} markerLabel
 * @return {undefined}
 */
GPURenderPassEncoder.prototype.insertDebugMarker = function(markerLabel) {}
/**
 * @param {!GPUIndex32} arg0
 * @param {!GPUBindGroup} arg1
 * @param {(!Array<!GPUBufferDynamicOffset>|!Uint32Array)=} arg2
 * @param {!GPUSize64=} arg3
 * @param {!GPUSize32=} arg4
 * @return {undefined}
 */
GPURenderPassEncoder.prototype.setBindGroup = function(arg0,arg1,arg2,arg3,arg4) {}
/**
 * @constructor
 * @extends {Error}
 * @param {!Iterable<*>} errors
 * @param {!string=} message
 */
function AggregateError(errors,message) {}
/** @type {!Iterable<*>} */ AggregateError.prototype.errors;
/**
 * @constructor
 * @private
 * @nosideeffects
 */
function GPUPipelineLayout() {}
/** @type {?string} */ GPUPipelineLayout.prototype.label;
/**
 * @constructor
 * @private
 * @nosideeffects
 */
function GPUCommandEncoder() {}
/** @type {?string} */ GPUCommandEncoder.prototype.label;
/**
 * @param {!GPUQuerySet} querySet
 * @param {!GPUSize32} queryIndex
 * @return {undefined}
 */
GPUCommandEncoder.prototype.writeTimestamp = function(querySet,queryIndex) {}
/**
 * @param {!GPUImageCopyTexture} source
 * @param {!GPUImageCopyBuffer} destination
 * @param {!GPUExtent3D} copySize
 * @return {undefined}
 */
GPUCommandEncoder.prototype.copyTextureToBuffer = function(source,destination,copySize) {}
/**
 * @param {!GPUImageCopyBuffer} source
 * @param {!GPUImageCopyTexture} destination
 * @param {!GPUExtent3D} copySize
 * @return {undefined}
 */
GPUCommandEncoder.prototype.copyBufferToTexture = function(source,destination,copySize) {}
/**
 * @param {!GPURenderPassDescriptor} descriptor
 * @return {!GPURenderPassEncoder}
 */
GPUCommandEncoder.prototype.beginRenderPass = function(descriptor) {}
/**
 * @param {!GPUQuerySet} querySet
 * @param {!GPUSize32} firstQuery
 * @param {!GPUSize32} queryCount
 * @param {!GPUBuffer} destination
 * @param {!GPUSize64} destinationOffset
 * @return {undefined}
 */
GPUCommandEncoder.prototype.resolveQuerySet = function(querySet,firstQuery,queryCount,destination,destinationOffset) {}
/**
 * @param {!string} groupLabel
 * @return {undefined}
 */
GPUCommandEncoder.prototype.pushDebugGroup = function(groupLabel) {}
/**
 * @param {!GPUBuffer} source
 * @param {!GPUSize64} sourceOffset
 * @param {!GPUBuffer} destination
 * @param {!GPUSize64} destinationOffset
 * @param {!GPUSize64} size
 * @return {undefined}
 */
GPUCommandEncoder.prototype.copyBufferToBuffer = function(source,sourceOffset,destination,destinationOffset,size) {}
/**
 * @return {undefined}
 */
GPUCommandEncoder.prototype.popDebugGroup = function() {}
/**
 * @param {!GPUCommandBufferDescriptor=} descriptor
 * @return {!GPUCommandBuffer}
 */
GPUCommandEncoder.prototype.finish = function(descriptor) {}
/**
 * @param {!string} markerLabel
 * @return {undefined}
 */
GPUCommandEncoder.prototype.insertDebugMarker = function(markerLabel) {}
/**
 * @param {!GPUImageCopyTexture} source
 * @param {!GPUImageCopyTexture} destination
 * @param {!GPUExtent3D} copySize
 * @return {undefined}
 */
GPUCommandEncoder.prototype.copyTextureToTexture = function(source,destination,copySize) {}
/**
 * @param {!GPUComputePassDescriptor=} descriptor
 * @return {!GPUComputePassEncoder}
 */
GPUCommandEncoder.prototype.beginComputePass = function(descriptor) {}
/**
 * @constructor
 * @private
 * @nosideeffects
 */
function GPUQueue() {}
/** @type {?string} */ GPUQueue.prototype.label;
/**
 * @param {!GPUImageCopyExternalImage} source
 * @param {!GPUImageCopyTextureTagged} destination
 * @param {!GPUExtent3D} copySize
 * @return {undefined}
 */
GPUQueue.prototype.copyExternalImageToTexture = function(source,destination,copySize) {}
/**
 * @param {!Array<!GPUCommandBuffer>} commandBuffers
 * @return {undefined}
 */
GPUQueue.prototype.submit = function(commandBuffers) {}
/**
 * @param {!GPUImageCopyTexture} destination
 * @param {!BufferSource} data
 * @param {!GPUImageDataLayout} dataLayout
 * @param {!GPUExtent3D} size
 * @return {undefined}
 */
GPUQueue.prototype.writeTexture = function(destination,data,dataLayout,size) {}
/**
 * @param {!GPUBuffer} buffer
 * @param {!GPUSize64} bufferOffset
 * @param {!BufferSource} data
 * @param {!GPUSize64=} dataOffset
 * @param {!GPUSize64=} size
 * @return {undefined}
 */
GPUQueue.prototype.writeBuffer = function(buffer,bufferOffset,data,dataOffset,size) {}
/**
 * @return {!Promise<undefined>}
 */
GPUQueue.prototype.onSubmittedWorkDone = function() {}
/**
 * @typedef {(!string|!GPUColor)}
 */
var GPULoadOpOrGPUColorUnion;
/**
 * @typedef {(!string|!GPUStencilValue)}
 */
var GPULoadOpOrGPUStencilValueUnion;
/**
 * @typedef {(!HTMLCanvasElement|!OffscreenCanvas)}
 */
var HTMLCanvasElementOrOffscreenCanvasUnion;
/**
 * @typedef {(!ImageBitmap|!HTMLCanvasElement|!OffscreenCanvas)}
 */
var ImageBitmapOrHTMLCanvasElementOrOffscreenCanvasUnion;
/**
 * @typedef {(!string|undefined)}
 */
var GPUDeviceLostReasonOrUndefinedUnion;
/**
 * @typedef {(!string|!number)}
 */
var GPULoadOpOrFloatUnion;
/**
 * @constructor
 * @private
 * @implements {EventTarget}
 * @nosideeffects
 */
function GPUDevice() {}
