package akasha.core;

import javax.annotation.Generated;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsProperty;
import jsinterop.annotations.JsType;

/**
 * The SharedArrayBuffer object is used to represent a generic, fixed-length raw binary data buffer, similar to the ArrayBuffer object, but in a way that they can be used to create views on shared memory.
 * Unlike an ArrayBuffer, a SharedArrayBuffer cannot become detached.
 *
 * @see <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/SharedArrayBuffer">SharedArrayBuffer - MDN</a>
 * @see <a href="https://tc39.es/ecma262/#sec-sharedarraybuffer-objects">SharedArrayBuffer - ECMA</a>
 */
@Generated("org.realityforge.webtack")
@JsType(
    isNative = true,
    namespace = JsPackage.GLOBAL,
    name = "SharedArrayBuffer"
)
public class SharedArrayBuffer {
  /**
   * The SharedArrayBuffer() constructor is used to create a SharedArrayBuffer object representing a generic, fixed-length raw binary data buffer, similar to the ArrayBuffer object.
   *
   * @see <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/SharedArrayBuffer/SharedArrayBuffer">SharedArrayBuffer() - MDN</a>
   * @see <a href="https://tc39.es/ecma262/#sec-sharedarraybuffer-constructor">The SharedArrayBuffer Constructor - ECMA</a>
   */
  public SharedArrayBuffer(final int length) {
  }

  /**
   * The byteLength accessor property represents the length of an SharedArrayBuffer in bytes.
   *
   * @see <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/SharedArrayBuffer/byteLength">SharedArrayBuffer.byteLength - MDN</a>
   * @see <a href="https://tc39.es/ecma262/#sec-get-sharedarraybuffer.prototype.bytelength">SharedArrayBuffer.prototype.byteLength - ECMA</a>
   */
  @JsProperty(
      name = "byteLength"
  )
  public native int byteLength();
}
