package akasha.core;

import javax.annotation.Generated;
import javax.annotation.Nonnull;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsType;

/**
 * The RangeError object indicates an error when a value is not in the set or range of allowed values.
 *
 * @see <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/RangeError">RangeError - MDN</a>
 * @see <a href="https://tc39.es/ecma262/multipage/fundamental-objects.html#sec-native-error-types-used-in-this-standard-rangeerror"># sec-native-error-types-used-in-this-standard-rangeerror</a>
 */
@Generated("org.realityforge.webtack")
@JsType(
    isNative = true,
    namespace = JsPackage.GLOBAL,
    name = "RangeError"
)
public class RangeError extends JsError {
  /**
   * The RangeError() constructor creates an error when a value is not in the set or range of allowed values.
   *
   * @see <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/RangeError/RangeError">RangeError() - MDN</a>
   * @see <a href="https://tc39.es/ecma262/#sec-native-error-types-used-in-this-standard-rangeerror">RangeError() - ECMA</a>
   */
  public RangeError(@Nonnull final String message) {
  }

  /**
   * The RangeError() constructor creates an error when a value is not in the set or range of allowed values.
   *
   * @see <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/RangeError/RangeError">RangeError() - MDN</a>
   * @see <a href="https://tc39.es/ecma262/#sec-native-error-types-used-in-this-standard-rangeerror">RangeError() - ECMA</a>
   */
  public RangeError() {
  }
}
