package elemental2.dom;

import jsinterop.annotations.JsOverlay;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsProperty;
import jsinterop.annotations.JsType;
import jsinterop.base.Js;
import jsinterop.base.JsPropertyMap;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class BlobEvent extends Event {
  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface BlobEventEventInitDictType {
    @JsOverlay
    static BlobEvent.BlobEventEventInitDictType create() {
      return Js.uncheckedCast(JsPropertyMap.of());
    }

    @JsProperty
    Blob getData();

    @JsProperty
    double getTimecode();

    @JsProperty
    void setData(Blob data);

    @JsProperty
    void setTimecode(double timecode);
  }

  public Blob data;
  public double timecode;

  public BlobEvent(String type, BlobEvent.BlobEventEventInitDictType eventInitDict) {
    // This call is only here for java compilation purpose.
    super((String) null, (EventInit) null);
  }
}
