package elemental2.dom;

import elemental2.core.JsIterable;
import jsinterop.annotations.JsOverlay;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsType;
import jsinterop.base.Js;
import jsinterop.base.JsPropertyMap;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class URLSearchParams implements JsIterable<String[]> {
  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface ConstructorInitUnionType {
    @JsOverlay
    static URLSearchParams.ConstructorInitUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default JsPropertyMap<String> asJsPropertyMap() {
      return Js.cast(this);
    }

    @JsOverlay
    default String asString() {
      return Js.asString(this);
    }

    @JsOverlay
    default String[][] asStringArrayArray() {
      return Js.cast(this);
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }

    @JsOverlay
    default boolean isStringArrayArray() {
      return (Object) this instanceof Object[];
    }
  }

  public URLSearchParams() {}

  public URLSearchParams(URLSearchParams.ConstructorInitUnionType init) {}

  public URLSearchParams(JsPropertyMap<String> init) {}

  public URLSearchParams(String init) {}

  public URLSearchParams(String[][] init) {}

  public native void append(String name, String value);

  public native void delete(String name);

  public native String get(String name);

  public native String[] getAll(String name);

  public native boolean has(String name);

  public native void set(String name, String value);

  public native void sort();
}
