package elemental2.dom;

import elemental2.core.JsDate;
import elemental2.core.JsIteratorIterable;
import elemental2.core.JsObject;
import jsinterop.annotations.JsFunction;
import jsinterop.annotations.JsOverlay;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsProperty;
import jsinterop.annotations.JsType;
import jsinterop.base.Js;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public interface RTCStatsReport {
  @JsFunction
  public interface ForEachCallbackFn<MAP> {
    Object onInvoke(JsObject p0, String p1, MAP p2);

    @JsOverlay
    default Object onInvoke(Object p0, String p1, MAP p2) {
      return onInvoke(Js.<JsObject>uncheckedCast(p0), p1, p2);
    }
  }

  <MAP, SCOPE> Object forEach(
      RTCStatsReport.ForEachCallbackFn<? super MAP> callback, SCOPE thisObj);

  <MAP> Object forEach(RTCStatsReport.ForEachCallbackFn<? super MAP> callback);

  JsObject get(String key);

  @JsProperty
  String getId();

  @Deprecated
  @JsProperty
  RTCStatsReport getLocal();

  @Deprecated
  @JsProperty
  RTCStatsReport getRemote();

  @JsProperty
  JsDate getTimestamp();

  @JsProperty
  String getType();

  JsIteratorIterable<String> keys();

  String[] names();

  String stat(String name);
}
