package elemental2.dom;

import elemental2.core.JsDate;
import jsinterop.annotations.JsOverlay;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsProperty;
import jsinterop.annotations.JsType;
import jsinterop.base.Js;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public interface RTCStats {
  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface GetTimestampUnionType {
    @JsOverlay
    static RTCStats.GetTimestampUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default double asDouble() {
      return Js.asDouble(this);
    }

    @JsOverlay
    default JsDate asJsDate() {
      return Js.cast(this);
    }

    @JsOverlay
    default boolean isDouble() {
      return (Object) this instanceof Double;
    }

    @JsOverlay
    default boolean isJsDate() {
      return (Object) this instanceof JsDate;
    }
  }

  @JsProperty
  String getId();

  @JsProperty
  RTCStats.GetTimestampUnionType getTimestamp();

  @JsProperty
  String getType();
}
