package elemental2.dom;

import jsinterop.annotations.JsOverlay;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsType;
import jsinterop.base.Js;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class URL {
  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface ConstructorBaseUnionType {
    @JsOverlay
    static URL.ConstructorBaseUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default String asString() {
      return Js.asString(this);
    }

    @JsOverlay
    default URL asURL() {
      return Js.cast(this);
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }

    @JsOverlay
    default boolean isURL() {
      return (Object) this instanceof URL;
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface CreateObjectURLObjUnionType {
    @JsOverlay
    static URL.CreateObjectURLObjUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default Blob asBlob() {
      return Js.cast(this);
    }

    @JsOverlay
    default MediaStream asMediaStream() {
      return Js.cast(this);
    }

    @JsOverlay
    default Object asObject() {
      return Js.cast(this);
    }

    @JsOverlay
    default boolean isBlob() {
      return (Object) this instanceof Blob;
    }

    @JsOverlay
    default boolean isMediaStream() {
      return (Object) this instanceof MediaStream;
    }

    @JsOverlay
    default boolean isObject() {
      return (Object) this instanceof Object;
    }
  }

  @JsOverlay
  public static final String createObjectURL(Blob obj) {
    return createObjectURL(Js.<URL.CreateObjectURLObjUnionType>uncheckedCast(obj));
  }

  public static native String createObjectURL(URL.CreateObjectURLObjUnionType obj);

  @JsOverlay
  public static final String createObjectURL(MediaStream obj) {
    return createObjectURL(Js.<URL.CreateObjectURLObjUnionType>uncheckedCast(obj));
  }

  @JsOverlay
  public static final String createObjectURL(Object obj) {
    return createObjectURL(Js.<URL.CreateObjectURLObjUnionType>uncheckedCast(obj));
  }

  public static native String domainToASCII(String domain);

  public static native String domainToUnicode(String domain);

  public static native void revokeObjectURL(String url);

  public String hash;
  public String host;
  public String hostname;
  public String href;
  public String origin;
  public String password;
  public String pathname;
  public String port;
  public String protocol;
  public String search;
  public URLSearchParams searchParams;
  public String username;

  public URL(String url, URL.ConstructorBaseUnionType base) {}

  public URL(String url, String base) {}

  public URL(String url, URL base) {}

  public URL(String url) {}
}
