package elemental2.dom;

import jsinterop.annotations.JsFunction;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsType;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class VisualViewport implements EventTarget {
  @JsFunction
  public interface OnresizeFn {
    Object onInvoke(Event event);
  }

  @JsFunction
  public interface OnscrollFn {
    Object onInvoke(Event event);
  }

  public double height;
  public double offsetLeft;
  public double offsetTop;
  public VisualViewport.OnresizeFn onresize;
  public VisualViewport.OnscrollFn onscroll;
  public double pageLeft;
  public double pageTop;
  public double scale;
  public double width;

  public native void addEventListener(
      String type, EventListener listener, EventTarget.AddEventListenerOptionsUnionType options);

  public native void addEventListener(String type, EventListener listener);

  public native boolean dispatchEvent(Event evt);

  public native void removeEventListener(
      String type, EventListener listener, EventTarget.RemoveEventListenerOptionsUnionType options);

  public native void removeEventListener(String type, EventListener listener);
}
