package elemental2.dom;

import jsinterop.annotations.JsFunction;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsType;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class ApplicationCache implements EventTarget {
  @JsFunction
  public interface OncachedFn {
    Object onInvoke(Event event);
  }

  @JsFunction
  public interface OncheckingFn {
    Object onInvoke(Event event);
  }

  @JsFunction
  public interface OndownloadingFn {
    Object onInvoke(Event event);
  }

  @JsFunction
  public interface OnerrorFn {
    Object onInvoke(Event event);
  }

  @JsFunction
  public interface OnnoupdateFn {
    Object onInvoke(Event event);
  }

  @JsFunction
  public interface OnprogressFn {
    Object onInvoke(Event event);
  }

  @JsFunction
  public interface OnupdatereadyFn {
    Object onInvoke(Event event);
  }

  public int CHECKING;
  public int DOWNLOADING;
  public int IDLE;
  public int OBSOLETE;
  public int UNCACHED;
  public int UPDATEREADY;
  public ApplicationCache.OncachedFn oncached;
  public ApplicationCache.OncheckingFn onchecking;
  public ApplicationCache.OndownloadingFn ondownloading;
  public ApplicationCache.OnerrorFn onerror;
  public ApplicationCache.OnnoupdateFn onnoupdate;
  public ApplicationCache.OnprogressFn onprogress;
  public ApplicationCache.OnupdatereadyFn onupdateready;
  public int status;

  public native void addEventListener(
      String type, EventListener listener, EventTarget.AddEventListenerOptionsUnionType options);

  public native void addEventListener(String type, EventListener listener);

  public native boolean dispatchEvent(Event evt);

  public native void removeEventListener(
      String type, EventListener listener, EventTarget.RemoveEventListenerOptionsUnionType options);

  public native void removeEventListener(String type, EventListener listener);

  public native void swapCache();

  public native void update();
}
